### E2 Catching an exception.

##### Example
```php
<?php

namespace Test\e2;

class EmptyCatch {
    public function test() {
        try {
            $this->throw();
        } catch(Exception $e) {}
    }

    public function throw() {
        throw new Exception("test");
    }
}
```

There is nothing wrong with catching an exception. The problem is
that `Exception` can be anything. When implementing this feature, 
you are probably trying to solve an issue you ran into.

Instead of catching `\Exception` or `Throwable` it will be better to create 
a specific `Throwable` class that `specificies` what happened.


### Solution 

```php
<?php

namespace Test\e2;

class EmptyCatch {
    public function test() {
        try {
            $this->throw();
        } catch(TestFailedException $e) {}
    }

    public function throw() {
        throw new TestFailedException("test");
    }
}
`


