#### E10 Too many paths. 


Too many paths in a method make the code harder to understand, maintain, and test. It increases complexity, reduces readability, and makes debugging challenging. Keeping methods concise and focused helps mitigate these issues and improves code quality.

### Problem
```php 
<?php 

class Test{

    public function tooManyPaths(string $letter){
        if($letter === 'a'){
            
          return 'A';
        }

        if($letter === 'b'){

          return 'B';
        }
       
        if($letter === 'c'){

          return 'C';
        }


        if($letter === 'd'){

          return 'D';
        }
        
        if($letter === 'e'){
  
          return 'E':
        }
    }
}
```
The `tooManyPaths` method already has too many paths, and we are still missing the other letters of the alphabet. To make this code block more readable, you can put all the letters and the desired return value into an array. 

### Solution 

```php
<?php 

class Test{
    
    public function tooManyPaths(string $letter){
        $alphabet = [
            'a' => 'A',
            'b' => 'B',
            'c' => 'C',
            'd' => 'D',
            'e' => 'E',
        ];
        return $alphabet[$letter];
    }
}
```


