﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using MySql.Data.MySqlClient;

/* 
类名: ViewClass 
功能：wap正文类
作者：书红
*/
//Start ViewClass Class
public partial class ViewClass : Page
{
	string ID = null;
	int currentPage = 0;
	MysqlHelp mh = null;
		
	public ViewClass(){
		///创建数据连接对象：
		mh = new MysqlHelp();
	}
		
	/// 判断输入的是否是数字 
	public bool IsNumberic(string oText){ 
		try 
		{ 
			int var1=Convert.ToInt32 (oText); 
			return true; 
		} 
		catch 
		{ 
			return false; 
		} 
	}
	
	///获取合法的数字字符串
	public string getValidateNumStr(string strNum){
		if( strNum != null && strNum.Length>999999999 )strNum = strNum.Substring(0,999999999);
		if( strNum == null )strNum = "0";
		if( !IsNumberic(strNum) )strNum = "0"; 	
		return strNum;
	}
	
	///获取分页后的文章正文
	public string getPageArticle(string article,string ID,int page){
		string articleStr = "";
		int articleLength = article.Length;
		int pos = 0;
		int i = 0;
		for(i=0;i<articleLength;i++){
			articleLength = article.Length;
			pos = article.IndexOf("&lt;-分页符-&gt;",0);
			if(pos != -1){
				if(i == page){
					articleStr = article.Substring(0,pos);
					///articleLength=0;
				}
				article=article.Remove(0,pos+13);
			}
			else{
				if(i == page){
					articleStr = article;
				}
				articleLength=0;
			}
		}
		string PageStr = "";
		if(i-1>0){
			PageStr += "<center><table cellspacing=2 cellpadding=2 style='line-height:16px;'><tr>";
		
			if(page>0){
				PageStr += "<td class='pageBox'><a href='view.aspx?ID="+ID+"'>首页</a></td>";
				PageStr += "<td class='pageBox'><a href='view.aspx?ID="+ID+"&Page="+(page-1)+"'>上一页</a></td>";
			}
			/*
			for(int j=0;j<i;j++){
				if(j != page){
					PageStr += "<td class='pageBox'><a href='view.aspx?ID="+ID+"&Page="+j+"'>"+(j+1)+"</a></td>";
				}
				else {
					PageStr += "<td class='FocuspageBox'>"+(j+1)+"</td>";
				}
			}
			*/
			if(page<i-1){
				PageStr += "<td class='pageBox'><a href='view.aspx?ID="+ID+"&Page="+(page+1)+"'>下一页</a></td>";
				PageStr += "<td class='pageBox'><a href='view.aspx?ID="+ID+"&Page="+(i-1)+"'>末页</a></td>";
			}
			PageStr += "<td class='pageBox'>第"+(page+1)+"页/共"+(i)+"页</td>";
			PageStr += "</tr></table></center>";
		}
		articleStr += PageStr;
		return articleStr;
	}
	
	protected void Page_Load(object sender, EventArgs e)
    {	
		///获取文章ID
		ID = Request.QueryString["ID"];
		///获取合法的文章ID
		ID = getValidateNumStr(ID);
		
		///获取文章当前页码
		string currentPageStr = Request.QueryString["Page"];
		///获取合法的文章ID
		currentPage = Convert.ToInt32(getValidateNumStr(currentPageStr));
		
		string themeHtml ="";
		string Title = "文章标题";
		string Author = "地平线";
		string DateStr = DateTime.Now.ToString("yyyy-MM-dd");
		string ClassID = "1";
		string ClassName = "栏目分类";
		string Article = "正文";
		string ReadCount = "0";
		string Source = "地平线";
		DataTable dt=new DataTable();
		dt = mh.GetDatabysql("Select Title,Author,DateStr,ClassID,Name,Article,ReadCount,Source,FatherID From Article4DeepSoon,Class4DeepSoon Where Article4DeepSoon.ID = " + ID +" and isDelete=false and isPassed=true and Article4DeepSoon.ClassID=Class4DeepSoon.ID");
		if(dt.Rows.Count>0)
		{
			Title = dt.Rows[0]["Title"].ToString();
			Author = dt.Rows[0]["Author"].ToString();
			DateStr = Convert.ToDateTime( dt.Rows[0]["DateStr"].ToString() ).ToString("yyyy年MM月dd日hh:mm");
			ClassID = dt.Rows[0]["ClassID"].ToString();
			ClassName = dt.Rows[0]["Name"].ToString();
			Article = dt.Rows[0]["Article"].ToString();
			Article = getPageArticle(Article,ID,currentPage);
			ReadCount = dt.Rows[0]["ReadCount"].ToString();
			Source = dt.Rows[0]["Source"].ToString();
				
			string ViewURL = "view-"+ID+".aspx";
			string ClassURL = "list.aspx?classID="+ClassID+"";
			
			///更新文章的点击量
			int newReadCount = Convert.ToInt32(ReadCount) +1;
			mh.Runsql("Update Article4DeepSoon Set ReadCount = " + newReadCount + " Where ID = "+ID);

			themeHtml += "<div class='zwTitle'>"+Title+"</div>";
			themeHtml += "<div class='zwInfor'><span>"+DateStr+"&nbsp;&nbsp;<a href='"+ClassURL+"'>"+ClassName+"</a>&nbsp;&nbsp;<img src='images/ico_ydcs.png' width=12 style='margin-bottom:-2px;'> "+ReadCount+"</span></div>";
			themeHtml += "<div class='zwContent'>";
			themeHtml += Article;
			themeHtml += "</div>";
			
			Page.Title = Title;
		}			
		else {
				themeHtml = "<div class='errorBox'><img src='/Resources/Images/cry.gif'> 文章已删除/不存在/未正式发表！</div>";
			}
		
		this.labelViewContent.Text = themeHtml;
    }
		
}
//End ViewClass Class
