﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using MySql.Data.MySqlClient;
using System.Web.Configuration;
using System.Text.RegularExpressions; 
using System.Text;

	
/* 
类名: ListClass 
功能：wap列表类
作者：书红
*/
//Start ListFunctions Class
public partial class ListClass : Page
{
	string className = "";
	string classID = "";
	int articlePageCurrent = 0;
	
	MysqlHelp mh = null;
		
	public ListClass(){
		///创建数据连接对象：
		mh = new MysqlHelp();
	}
	
	/// 判断输入的是否是数字 
	public bool IsNumberic(string oText){ 
		try 
		{ 
			int var1=Convert.ToInt32 (oText); 
			return true; 
		} 
		catch 
		{ 
			return false; 
		} 
	}
	
	///获取合法的数字字符串
	public string getValidateNumStr(string strNum){
		if( strNum != null && strNum.Length>999999999 )strNum = strNum.Substring(0,999999999);
		if( strNum == null )strNum = "0";
		if( !IsNumberic(strNum) )strNum = "0"; 	
		return strNum;
	}
	
	///列表页分页
	public string getPageStr(int articlePageSum,string classID,int articlePageCurrent){
		string PageStr = "";
		int start = 0;
		PageStr += "<div style='padding-top:5px;padding-bottom:5px;'>";
		if(articlePageCurrent/5==0)
			start=0; 
		else start=(articlePageCurrent/5)*5-1;
  
		int end1=start+6;

		if(end1>articlePageSum)
			end1=articlePageSum;
		PageStr += "<table cellspacing=2 cellpadding=2><tr>";
		if(articlePageCurrent>0){
			PageStr += "<td class='pageBox'><a href='list.aspx?classID="+classID+"'>首页</a></td>";
			PageStr += "<td class='pageBox'><a href='list.aspx?classID="+classID+"&page="+(articlePageCurrent-1)+"'>上一页</a></td>";
		}
		if(end1>1){
			/*
			for(int i=start;i<end1;i++){
				if(i==articlePageCurrent)
					PageStr +="<td class='FocuspageBox'>"+(i+1)+"</td>";
				else 
					PageStr += "<td class='pageBox'><a href='list.aspx?classID="+classID+"&page="+i+"'>"+(i+1)+"</a></td>";
			}
			*/
			if(articlePageCurrent<articlePageSum-1){
				PageStr += "<td class='pageBox'><a href='list.aspx?classID="+classID+"&page="+(articlePageCurrent+1)+"'>下一页</a></td>";
				PageStr += "<td class='pageBox'><a href='list.aspx?classID="+classID+"&page="+(articlePageSum-1)+"'>末页</a></td>";
			}
			PageStr += "<td class='pageBox'>第"+(articlePageCurrent+1)+"页/共"+articlePageSum+"页</td>";
		}
		PageStr += "</tr></table></div>";
		return PageStr;
   }
	
	protected void Page_Load(object sender, EventArgs e)
    {		
		///获取classID
		classID = Request.QueryString["ClassID"];
		///获取合法的classID
		classID = getValidateNumStr(classID);
		
		///获取articlePageCurrentStr
		string articlePageCurrentStr = Request.QueryString["Page"];
		///获取合法的articlePageCurrentStr
		articlePageCurrentStr = getValidateNumStr(articlePageCurrentStr);
		///获取当前页码		
		articlePageCurrent = Convert.ToInt32(articlePageCurrentStr);
		
		int articlePageSize = 8;
		DataTable ChildIdDt=new DataTable();
		DataTable newsDt=new DataTable();
		DataTable countDt=new DataTable();
			
		string themeHtml = "";
		///查询[文章列表]的所有子类集：
		ChildIdDt = mh.GetDatabysql("Select Name,ChildID From Class4DeepSoon Where ID = "+classID);
		
		///如果classID的菜单存在，则继续：
		if(ChildIdDt.Rows.Count>0){
			string ChildIDSet = "("+ChildIdDt.Rows[0]["ChildID"].ToString()+")";
			///查询符合条件的记录总数：
			countDt = mh.GetDatabysql("Select Count(*) As CountNum From Article4DeepSoon,Class4DeepSoon Where ClassID in "+ChildIDSet+" and isDelete=false and isPassed=true and Article4DeepSoon.ClassID=Class4DeepSoon.ID");
			int articlePageCount = Convert.ToInt32(countDt.Rows[0]["CountNum"]);
			///计算记录总数总共可以分为多少页：
			int PageCount = articlePageCount/articlePageSize+1;
			if(articlePageCount%articlePageSize==0)PageCount = PageCount-1;
			///如果当前页码越界：
			if( articlePageCurrent < 0 )articlePageCurrent=0;
			if( articlePageCurrent > PageCount)articlePageCurrent = PageCount;
			///查询记录的起始位置：
			int articlePageStart = articlePageSize * articlePageCurrent;
			
			///如果有记录
			if(articlePageCount>0){
			///------ if Start -----
				///查询文章表中classID属于子类集中的记录：
				newsDt = mh.GetDatabysql("Select Article4DeepSoon.ID,ClassID,Title,Name,Source,Author,DateStr,BriefInfor,thumbnailImage,ReadCount,URL,isSetURL From Article4DeepSoon,Class4DeepSoon Where ClassID in "+ChildIDSet+" and isDelete=false and isPassed=true and Article4DeepSoon.ClassID=Class4DeepSoon.ID Order By Article4DeepSoon.ID DESC Limit "+articlePageStart+","+articlePageSize);
				///[文章列表]内容载体初始化：
				string ListContent = "";
				for(int i = 0 ; i < newsDt.Rows.Count ; i++)
				{
					string ID = newsDt.Rows[i]["ID"].ToString();
					string Title = newsDt.Rows[i]["Title"].ToString();
					string DateStr = Convert.ToDateTime( newsDt.Rows[i]["DateStr"].ToString() ).ToString("yyyy年MM月dd日");
					string ClassID = newsDt.Rows[i]["ClassID"].ToString();
					string ClassName = newsDt.Rows[i]["Name"].ToString();
					string Author = newsDt.Rows[i]["Author"].ToString();
					string Source = newsDt.Rows[i]["Source"].ToString();
					string BriefInfor = newsDt.Rows[i]["BriefInfor"].ToString()+"...";
					BriefInfor = Regex.Replace(BriefInfor, @"\s*|\t|\r|\n", "", RegexOptions.IgnoreCase);
					BriefInfor = Regex.Replace(BriefInfor, "（", "(", RegexOptions.IgnoreCase);
					BriefInfor = Regex.Replace(BriefInfor, "）", ")", RegexOptions.IgnoreCase);		
						
					string thumbnailImage = newsDt.Rows[i]["thumbnailImage"].ToString();
					if(thumbnailImage=="")thumbnailImage = "Resources/Images/defaultPic.jpg";
					string ReadCount = newsDt.Rows[i]["ReadCount"].ToString();
						
					string ViewURL = "view.aspx?ID="+ID;
					string ClassURL = "list.aspx?ClassID="+ClassID;
					
					bool isSetURL=(bool)newsDt.Rows[i]["isSetURL"];
					if(isSetURL)ViewURL=newsDt.Rows[i]["URL"].ToString();
				
					Page.Title = ClassName;
					
					themeHtml += "<li><a href='"+ViewURL+"'>"+Title+"</a><br><span>"+DateStr+"</span> "+ClassName+" </li>";
				}///end For
				
			}///------ if 文章存在 -----
			else {
				themeHtml = "<center><div class='errorBox'><img src='/Resources/Images/cry.gif'> 对不起，该栏目下暂时无文章！</div></center>";
			}
			
			//添加分页页码
			themeHtml += getPageStr(PageCount,classID,articlePageCurrent);
				
		}			
		
		this.labelListContent.Text = themeHtml;	
		
    }
}
//End ListClass Class
