﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using MySql.Data.MySqlClient;

/* 
类名: IndexClass 
功能：wap首页类
作者：书红
*/
//Start IndexClass Class
public partial class IndexClass : Page
{
	MysqlHelp mh = null;
		
	public IndexClass(){
		///创建数据连接对象：
		mh = new MysqlHelp();
	}
		
	
	///处理ShowImgPlayer文章列表标签
	public string ShowImgPlayer(){
		string ImgPlayerContent = "<div id='focus' class='focusPhoto'>";
			
		string sqlStr = "Select ID,Title,BriefInfor,thumbnailImage,isSetURL,URL From Article4DeepSoon Where isSlideShow=True and isDelete=false and isPassed=true Order By ID DESC Limit 3";
			
		DataTable ImgPlayerDt = new DataTable();
		ImgPlayerDt = mh.GetDatabysql(sqlStr);
		if(ImgPlayerDt.Rows.Count>0){
			for(int i = 0 ; i < ImgPlayerDt.Rows.Count ; i++)
			{
			string ID = ImgPlayerDt.Rows[i]["ID"].ToString();
			string Title = ImgPlayerDt.Rows[i]["Title"].ToString();
			if(Title.Length>20)Title = Title.Substring(0,20)+"...";
			string allTitle = Title;
			string BriefInfor = ImgPlayerDt.Rows[i]["BriefInfor"].ToString();
			//if(BriefInfor.Length>32)BriefInfor = BriefInfor.Substring(0,32)+"...";
			string thumbnailImage = ImgPlayerDt.Rows[i]["thumbnailImage"].ToString();
			if(thumbnailImage=="")thumbnailImage = "/Resources/Images/defaultPic.jpg";
				
			string ViewURL = "view.aspx?ID="+ID;
			bool isSetURL=(bool)ImgPlayerDt.Rows[i]["isSetURL"];
			if(isSetURL)ViewURL=ImgPlayerDt.Rows[i]["URL"].ToString();
						
			ImgPlayerContent += "<section>";
			ImgPlayerContent += "<a href='"+ViewURL+"'>";
			ImgPlayerContent += "<img src='"+thumbnailImage+"'>";
			ImgPlayerContent += "</a>";
			ImgPlayerContent += "<aside>"+Title+"</aside>";
			ImgPlayerContent += "</section>";
		
			}//end for
		}//end if
		else{
			ImgPlayerContent += "无幻灯图展示";	
		}
		ImgPlayerContent += "</div>"+"<div class='focusDotBg'><p class='focusDot' id='focusDot'></p></div>";
		return ImgPlayerContent;
	}
	
	
	
	
	///处理showList文章列表标签
	public string ShowList(string keyWord){
		string ShowListContent = "";
			
		///查询[列表模块]的所有子类集：
		DataTable ChildIdDt=new DataTable();
		ChildIdDt = mh.GetDatabysql("Select ChildID From Class4DeepSoon Where Name like '"+keyWord+"'");
		///[列表模块]内容载体初始化：
		if(ChildIdDt.Rows.Count>0){
			string ChildIDSet = "("+ChildIdDt.Rows[0]["ChildID"].ToString()+")";
			string sqlStr = "Select Article4DeepSoon.ID,ClassID,Title,Name,Source,Author,DateStr,BriefInfor,thumbnailImage,ReadCount,URL,isSetURL From Article4DeepSoon,Class4DeepSoon Where ClassID in "+ChildIDSet+" and isDelete=false and isPassed=true  and Article4DeepSoon.ClassID=Class4DeepSoon.ID Order By ID DESC Limit 0,8";
			
			DataTable showListDt = new DataTable();
			showListDt = mh.GetDatabysql(sqlStr);
			if(showListDt.Rows.Count>0){
				for(int i = 0 ; i < showListDt.Rows.Count ; i++)
				{
					string ID = showListDt.Rows[i]["ID"].ToString();
					string DateStr = Convert.ToDateTime( showListDt.Rows[i]["DateStr"].ToString() ).ToString("yyyy年MM月dd日");
					string Title = showListDt.Rows[i]["Title"].ToString();
					string allTitle = Title;
					string ClassID = showListDt.Rows[i]["ClassID"].ToString();
					string ClassName = showListDt.Rows[i]["Name"].ToString();
					string BriefInfor = showListDt.Rows[i]["BriefInfor"].ToString();
					//if(BriefInfor.Length>32)BriefInfor = BriefInfor.Substring(0,32)+"...";
					string thumbnailImage = showListDt.Rows[i]["thumbnailImage"].ToString();
					if(thumbnailImage=="")thumbnailImage = "/Resources/Images/defaultPic.jpg";
					string ReadCount = showListDt.Rows[i]["ReadCount"].ToString();
				
					string ViewURL = "view.aspx?ID="+ID;
					bool isSetURL=(bool)showListDt.Rows[i]["isSetURL"];
					if(isSetURL)ViewURL=showListDt.Rows[i]["URL"].ToString();
						
					ShowListContent  +=  "<li class='full'>";
					ShowListContent += "<a href='"+ViewURL+"'>";
					ShowListContent += "<div class='thumb'><img src='"+thumbnailImage+"' width='75' height='62'></div>";
					ShowListContent += "<h2>"+Title+"</h2>";
					ShowListContent += "<p>"+BriefInfor+"</p>";
					ShowListContent += "</a>";
					ShowListContent += "</li>";
				}
			}
			else ShowListContent += "<div class='errorInforContent'>抱歉！当前【"+keyWord+"】栏目下暂时无内容。</div>";	
		}
		else 
		{
			ShowListContent += "<div class='errorInforContent'>栏目【"+keyWord+"】不存在</div>";
		}
			
		return ShowListContent;
	}
	
	
	public string ShowNormalList(string keyWord){
		string ShowListContent = "";
			
		///查询[列表模块]的所有子类集：
		DataTable ChildIdDt=new DataTable();
		ChildIdDt = mh.GetDatabysql("Select ChildID From Class4DeepSoon Where Name like '"+keyWord+"'");
		///[列表模块]内容载体初始化：
		if(ChildIdDt.Rows.Count>0){
			string ChildIDSet = "("+ChildIdDt.Rows[0]["ChildID"].ToString()+")";
			string sqlStr = "Select Article4DeepSoon.ID,ClassID,Title,Name,Source,Author,DateStr,BriefInfor,thumbnailImage,ReadCount,URL,isSetURL From Article4DeepSoon,Class4DeepSoon Where ClassID in "+ChildIDSet+" and isDelete=false and isPassed=true  and Article4DeepSoon.ClassID=Class4DeepSoon.ID Order By ID DESC Limit 0,15";
			
			DataTable showListDt = new DataTable();
			showListDt = mh.GetDatabysql(sqlStr);
			if(showListDt.Rows.Count>0){
				for(int i = 0 ; i < showListDt.Rows.Count ; i++)
				{
					string ID = showListDt.Rows[i]["ID"].ToString();
					string DateStr = Convert.ToDateTime( showListDt.Rows[i]["DateStr"].ToString() ).ToString("MM/dd");
					string Title = showListDt.Rows[i]["Title"].ToString();
					string allTitle = Title;
					string ClassID = showListDt.Rows[i]["ClassID"].ToString();
					string ClassName = showListDt.Rows[i]["Name"].ToString();
					string BriefInfor = showListDt.Rows[i]["BriefInfor"].ToString();
					//if(BriefInfor.Length>32)BriefInfor = BriefInfor.Substring(0,32)+"...";
					string thumbnailImage = showListDt.Rows[i]["thumbnailImage"].ToString();
					if(thumbnailImage=="")thumbnailImage = "/Resources/Images/defaultPic.jpg";
					string ReadCount = showListDt.Rows[i]["ReadCount"].ToString();
				
					string ViewURL = "view.aspx?ID="+ID;
					bool isSetURL=(bool)showListDt.Rows[i]["isSetURL"];
					if(isSetURL)ViewURL=showListDt.Rows[i]["URL"].ToString();
						
					ShowListContent  += "<li>["+DateStr+"] <a href='"+ViewURL+"' title='"+allTitle+"'>"+Title+"</a></li>";	
		
				}
			}
			else ShowListContent += "<div class='errorInforContent'>抱歉！当前【"+keyWord+"】栏目下暂时无内容。</div>";	
		}
		else 
		{
			ShowListContent += "<div class='errorInforContent'>栏目【"+keyWord+"】不存在</div>";
		}
			
		return ShowListContent;
	}
	
	
	protected void Page_Load(object sender, EventArgs e)
    {	
		this.labelImgPlayer.Text = ShowImgPlayer();
		this.labelNewsList.Text = ShowList("校园新闻");
		this.labelNoticeList.Text = ShowNormalList("公示公告");
    }
		
}
//End IndexClass Class
