﻿function getObjBy(id) {
	return "string" == typeof id ? document.getElementById(id) : id;
};
var Class = {
  create: function() {
	return function() {
	  this.initialize.apply(this, arguments);
	}
  }
}
Object.extend = function(destination, source) {
	for (var property in source) {
		destination[property] = source[property];
	}
	return destination;
}
var TransformView = Class.create();
TransformView.prototype = {
  //容器对象,滑动对象,切换参数,切换数量
  initialize: function(container, slider, parameter, count, options) {
	if(parameter <= 0 || count <= 0) return;
	var oContainer = getObjBy(container), oSlider = getObjBy(slider), oThis = this;
	this.Index = 0;//当前索引
	this._timer = null;//定时器
	this._slider = oSlider;//滑动对象
	this._parameter = parameter;//切换参数
	this._count = count || 0;//切换数量
	this._target = 0;//目标参数
	this.SetOptions(options);
	this.Up = !!this.options.Up;
	this.Step = Math.abs(this.options.Step);
	this.Time = Math.abs(this.options.Time);
	this.Auto = !!this.options.Auto;
	this.Pause = Math.abs(this.options.Pause);
	this.onStart = this.options.onStart;
	this.onFinish = this.options.onFinish;
	oContainer.style.overflow = "hidden";
	oContainer.style.position = "relative";
	oSlider.style.position = "absolute";
	oSlider.style.top = oSlider.style.left = 0;
  },
  //设置默认属性
  SetOptions: function(options) {
	this.options = {//默认值
		Up:	true,//是否向上(否则向左)
		Time:	10,//滑动延时
		Auto:	true,//是否自动转换
		Pause:	4000,//停顿时间(Auto为true时有效)
		onStart:	function(){},//开始转换时执行
		onFinish:	function(){}//完成转换时执行
	};
	Object.extend(this.options, options || {});
  },
  //开始切换设置
  Start: function() {
	if(this.Index < 0){
		this.Index = this._count - 1;
	} else if (this.Index >= this._count){ this.Index = 0; }
	
	var oU=getObjBy("ImgList4Album"); 
	var dier=oU.getElementsByTagName('li')[this.Index];
	//获取图片的地址
	var imgSrc=dier.getElementsByTagName('img')[0].src;
	
	dier.getElementsByTagName('img')[0].style.display = "block";
	//获取图片的原始尺寸
	var imgWidthOld=dier.getElementsByTagName('img')[0].width;
	var imgHeightOld=dier.getElementsByTagName('img')[0].height;
	if(imgWidthOld > 600){
		imgHeight=imgHeightOld/imgWidthOld*600;
		imgWidth = 600;
	}
	else{
		imgHeight= imgHeightOld;
		imgWidth = imgWidthOld;
	}
	
	//alert("原始宽度："+imgWidthOld+" 宽度："+imgWidth+"/原始高度："+imgHeightOld+" 高度："+imgHeight+"");
	dier.getElementsByTagName('img')[0].style.display = "none";
	//设定相册当前图片的地址和尺寸
	getObjBy("showCurrentImg").src = imgSrc;
	getObjBy("showCurrentImg").width = imgWidth;
	getObjBy("showCurrentImg").height = imgHeight;
	$("#showCurrentImg").animate({ opacity: "0.2"}, 10);
	$("#showCurrentImg").animate({ opacity: "1"}, 400);
	
	//修改第一幅/共三幅图片信息
	getObjBy("currentImg4Album").innerText=this.Index+1;
	
	this._target = -1 * this._parameter * this.Index;
	this.onStart();
	this.Move();
  },
  //移动
  Move: function() {
	clearTimeout(this._timer);
	var oThis = this;
	if (this.Auto) { this._timer = setTimeout(function(){ oThis.Index++; oThis.Start(); }, this.Pause); }
  },
  //停止
  Stop: function(iTarget, iNow) {
	clearTimeout(this._timer);
  }
};


window.onload=function(){
	function Each(list, fun){
		for (var i = 0, len = list.length; i < len; i++) { fun(list[i], i); }
	};
	//getObjBy("Album").style.textalign = "center";
	var sumImg4Album = getObjBy("ImgList4Album").getElementsByTagName("li").length;
	getObjBy("sumImg4Album").innerText = sumImg4Album;
	var objs = getObjBy("AlbumButton").getElementsByTagName("li");
	var tv = new TransformView("Album", "ImgList4Album", 600,sumImg4Album, {
		onStart: function(){ },//按钮样式
		Up: false
	});
	tv.Start();
	Each(objs, function(o, i){
		if(i==0){
			o.onmouseover = function(){
			o.className = "mouseOover";
			}
			o.onmouseout = function(){
			o.className = "";
			}
			o.onclick = function(){
			tv.Auto = false;
			tv.Index = tv.Index-1;
			tv.Start();
			}			
		}
		else{
			o.onmouseover = function(){
			o.className = "mouseOover";
			}
			o.onmouseout = function(){
			o.className = "";
			}
			o.onclick = function(){
			tv.Auto = false;
			tv.Index = tv.Index+1;
			tv.Start();
			}
		}
	})
}