﻿using System;
using System.Text;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Security.Cryptography;
using MySql.Data.MySqlClient;
using System.IO;
using System.Drawing;
using System.Drawing.Imaging;
using System.Text.RegularExpressions; 

using UserCenter;
namespace UserCenter
{
	/* 
	类名: authorList4userCenter 
	功能：会员中心.会员的文章列表类
	作者：书红
	*/
	//Start authorList4userCenter Class
	public partial class authorList4userCenter : System.Web.UI.Page
    {
		string className = "";
		string AuthorID = "";
		
		DeepSoonHelp dh = null;
		string themeFileName = "";
		string urlRule = "";
		string themeHtml = "";
		
		MysqlHelp mh = null;
	
		int articlePageCurrent = 0;
		
		public authorList4userCenter(){
			///创建数据连接对象：
			mh = new MysqlHelp();
		}
		
		///作者文章列表页分页
		public string getAuthorPageStr(int articlePageSum,string authorID,int articlePageCurrent,string urlRule){
			string PageStr = "";
			int start = 0;
			PageStr += "<div style='padding-top:5px;padding-bottom:5px;'>";
			if(articlePageCurrent/5==0)
				start=0; 
			else start=(articlePageCurrent/5)*5-1;
  
			int end1=start+6;

			if(end1>articlePageSum)
				end1=articlePageSum;
			PageStr += "<table cellspacing=2 cellpadding=2><tr>";
			if(articlePageCurrent>0){
				PageStr += "<td class='pageBox'><a href='authorList.aspx?authorID="+authorID+"'>首页</a></td>";
				PageStr += "<td class='pageBox'><a href='authorList.aspx?authorID="+authorID+"&page="+(articlePageCurrent-1)+"'>上一页</a></td>";
			}
			if(end1>1){
				for(int i=start;i<end1;i++){
					if(i==articlePageCurrent)
						PageStr +="<td class='FocuspageBox'>"+(i+1)+"</td>";
					else {
						PageStr += "<td class='pageBox'><a href='authorList.aspx?authorID="+authorID+"&page="+i+"'>"+(i+1)+"</a></td>";
					}
				}
				if(articlePageCurrent<articlePageSum-1){
					PageStr += "<td class='pageBox'><a href='authorList.aspx?authorID="+authorID+"&page="+(articlePageCurrent+1)+"'>下一页</a></td>";
					PageStr += "<td class='pageBox'><a href='authorList.aspx?authorID="+authorID+"&page="+(articlePageSum-1)+"'>末页</a></td>";
				}
				PageStr += "<td class='pageBox'>第"+(articlePageCurrent+1)+"页/共"+articlePageSum+"页</td>";
			}
			PageStr += "</tr></table></div>";
			return PageStr;
		}
	
	
		///处理authorList文章列表标签
		public string replaceAuthorListTag(string themeHtml,string urlRule,string authorID,int articlePageCurrent){
			string listPattern = @"\{dp:authorList.*pageSize=\'(.*?)\'.*titleLen=\'(.*?)\'\}([\s\S]*?)\{\/dp:authorList\}";
			MatchCollection listMatches = Regex.Matches(themeHtml,listPattern, RegexOptions.IgnoreCase);
			foreach (Match match in listMatches){
				///获取pageSize，并判断合法性
				string argsPageSizeStr = match.Groups[1].Value;
				if(argsPageSizeStr == "")argsPageSizeStr = "6";
				int articlePageSize = Convert.ToInt32(argsPageSizeStr);
				///标题字符个数：
				string argsTitleLengthStr = match.Groups[2].Value;
				if(argsTitleLengthStr == "")argsTitleLengthStr = "12";
				int argsTitleLenght = Convert.ToInt32(argsTitleLengthStr);
				///获取List的行字符串样式
				string rowString = match.Groups[3].Value;
			
				DataTable ChildIdDt=new DataTable();
				DataTable newsDt=new DataTable();
				DataTable countDt=new DataTable();
			
				///查询[文章列表]的所有子类集：
				ChildIdDt=new DataTable();
				ChildIdDt = mh.GetDatabysql("Select Name From Users4DeepSoon Where ID = "+authorID);
				///如果classID的菜单存在，则继续：
				if(ChildIdDt.Rows.Count>0){
					string AuthorStr = ChildIdDt.Rows[0]["Name"].ToString();
					///查询符合条件的记录总数：
					countDt = mh.GetDatabysql("Select Count(*) As CountNum From Article4DeepSoon,Class4DeepSoon Where Author ='"+AuthorStr+"' and isDelete=false and isPassed=true and Article4DeepSoon.ClassID=Class4DeepSoon.ID");
					int articlePageCount = Convert.ToInt32(countDt.Rows[0]["CountNum"]);
					///计算记录总数总共可以分为多少页：
					int PageCount = articlePageCount/articlePageSize+1;
					if(articlePageCount%articlePageSize==0)PageCount = PageCount-1;
					///如果当前页码越界：
					if( articlePageCurrent < 0 )articlePageCurrent=0;
					if( articlePageCurrent > PageCount)articlePageCurrent = PageCount;
					///查询记录的起始位置：
					int articlePageStart = articlePageSize * articlePageCurrent;
			
					///如果有记录
					if(articlePageCount>0){
					///------ if Start -----
						///查询文章表中classID属于子类集中的记录：
						newsDt = mh.GetDatabysql("Select Article4DeepSoon.ID,ClassID,Title,Name,Source,Author,DateStr,BriefInfor,thumbnailImage,ReadCount From Article4DeepSoon,Class4DeepSoon Where Author ='"+AuthorStr+"' and isDelete=false and isPassed=true and Article4DeepSoon.ClassID=Class4DeepSoon.ID Order By Article4DeepSoon.ID DESC Limit "+articlePageStart+","+articlePageSize);
						///[文章列表]内容载体初始化：
						string ListContent = "";
						for(int i = 0 ; i < newsDt.Rows.Count ; i++)
						{
							string ID = newsDt.Rows[i]["ID"].ToString();
							string Title = newsDt.Rows[i]["Title"].ToString();
							if(Title.Length>argsTitleLenght)Title = Title.Substring(0,argsTitleLenght);
							string DateStr = Convert.ToDateTime( newsDt.Rows[i]["DateStr"].ToString() ).ToString("yyyy/MM/dd");
							string ClassID = newsDt.Rows[i]["ClassID"].ToString();
							string ClassName = newsDt.Rows[i]["Name"].ToString();
							string BriefInfor = newsDt.Rows[i]["BriefInfor"].ToString()+"...";
							BriefInfor = Regex.Replace(BriefInfor, @"\s*|\t|\r|\n", "", RegexOptions.IgnoreCase);
							BriefInfor = Regex.Replace(BriefInfor, "（", "(", RegexOptions.IgnoreCase);
							BriefInfor = Regex.Replace(BriefInfor, "）", ")", RegexOptions.IgnoreCase);		
						
							string thumbnailImage = newsDt.Rows[i]["thumbnailImage"].ToString();
							if(thumbnailImage=="")thumbnailImage = "../Resources/Images//defaultPic.jpg";
							string ReadCount = newsDt.Rows[i]["ReadCount"].ToString();
						
							string ViewURL = "";
							string ClassURL = "";
							switch (urlRule)
							{
								case "endWithASPX":
									ViewURL = "view-"+ID+".aspx";
									ClassURL = "list-"+ClassID+"-0.aspx";
									break;
								case "endWithHTML":
									ViewURL = "view-"+ID+".html";
									ClassURL = "list-"+ClassID+"-0.html";
									break;
								case "noPostfix":
									ViewURL = "view-"+ID+"";
									ClassURL = "list-"+ClassID+"-0";
									break;
								case "activeArgs":
									ViewURL = "view.aspx?ID="+ID+"";
									ClassURL = "list.aspx?classID="+ClassID+"";
									break;
								default:
									ViewURL = "view-"+ID+".aspx";
									ClassURL = "list-"+ClassID+"-0.aspx";
									break;
							}///end switch
							ViewURL = "../publish/"+ViewURL;
							ClassURL = "../publish/"+ClassURL;
							
							ListContent += rowString.Replace("[authorList:i]",""+i).Replace("[authorList:numTag]",""+(i+1)).Replace("[authorList:viewURL]",ViewURL).Replace("[authorList:classURL]",ClassURL).Replace("[authorList:BriefInfor]",BriefInfor).Replace("[authorList:thumbnailImage]",thumbnailImage).Replace("[authorList:Title]",Title).Replace("[authorList:ID]",ID).Replace("[authorList:DateStr]",DateStr).Replace("[authorList:ClassName]",ClassName).Replace("[authorList:ClassID]",ClassID).Replace("[authorList:ReadCount]",ReadCount);
						}///end For
						themeHtml = themeHtml.Replace(match.Groups[0].Value, ListContent);
					}///------ if 文章存在 -----
					else {
						themeHtml = "<div class='errorBox'><img src='../Resources/Images/cry.gif'> Ta还没有发布任何文章！</div>";
					}
				
					string PageContent = getAuthorPageStr(PageCount,authorID,articlePageCurrent,urlRule);
					if( themeHtml.Contains("{dp:authorListPreNextButton}") ){
						themeHtml = themeHtml.Replace("{dp:authorListPreNextButton}", PageContent);
					}
				
				}			
			}
			return themeHtml;
		}
	
		///处理作者信息标签
		public string replaceAuthorInforTag(string themeHtml,string ID){
			string authorInforPattern = @"\{dp:authorInfor\}([\s\S]*?)\{\/dp:authorInfor\}";
			MatchCollection authorInforMatches = Regex.Matches(themeHtml,authorInforPattern, RegexOptions.IgnoreCase);
			foreach (Match match in authorInforMatches){
				///获取List的行字符串样式
				string rowString = match.Groups[1].Value;
			
				string authorInforStr = "";
				///查询[文章列表]的所有子类集：
				DataTable dt=new DataTable();
				MysqlHelp authorMh = new MysqlHelp();
				dt = authorMh.GetDatabysql("Select Users4DeepSoon.ID,Author,ChatHead,Blog,RegisterDate,LastLoginDate,SelfIntroduction,Email From Article4DeepSoon,Users4DeepSoon Where Article4DeepSoon.Author=Users4DeepSoon.Name and Users4DeepSoon.ID = "+ID);
				///如果classID的菜单存在，则继续：
				if(dt.Rows.Count>0){
					string AuthorID = dt.Rows[0]["ID"].ToString();
					string Author = dt.Rows[0]["Author"].ToString();
					string ChatHead = dt.Rows[0]["ChatHead"].ToString();
					if(ChatHead == "")ChatHead = "dpDefault.jpg";
					string Blog = dt.Rows[0]["Blog"].ToString();
					string Email = dt.Rows[0]["Email"].ToString();
					string SelfIntroduction = dt.Rows[0]["SelfIntroduction"].ToString();
					if(SelfIntroduction=="")SelfIntroduction="Ta很懒，什么也没写";
					string RegisterDate = dt.Rows[0]["RegisterDate"].ToString();
					string LastLoginDate = dt.Rows[0]["LastLoginDate"].ToString();
					if(Blog == "")Blog = "#";
					authorInforStr = rowString.Replace("[authorInfor:AuthorID]", AuthorID).Replace("[authorInfor:Author]", Author).Replace("[authorInfor:ChatHead]", ChatHead).Replace("[authorInfor:Blog]", Blog).Replace("[authorInfor:Email]", Email).Replace("[authorInfor:SelfIntroduction]", SelfIntroduction).Replace("[authorInfor:RegisterDate]", RegisterDate).Replace("[authorInfor:LastLoginDate]", LastLoginDate);
				
					///统计文章总数
					DataTable articleCountDt=new DataTable();
					articleCountDt = authorMh.GetDatabysql("Select Count(ID) As articleCount From Article4DeepSoon Where Author = '"+Author+"'");
					string articleCount = articleCountDt.Rows[0]["articleCount"].ToString();
					authorInforStr =  authorInforStr.Replace("[authorInfor:articleCount]", articleCount);
				
					///统计评论总数
					DataTable commentCountDt=new DataTable();
					commentCountDt = authorMh.GetDatabysql("Select Count(ID) As commentCount From Comment4DeepSoon Where Author = '"+Author+"'");
					string commentCount = commentCountDt.Rows[0]["commentCount"].ToString();
					authorInforStr =  authorInforStr.Replace("[authorInfor:commentCount]", commentCount);
			
				}
				else{
					authorInforStr = "";
				}
				themeHtml = themeHtml.Replace(match.Groups[0].Value, authorInforStr);
			}
			return themeHtml;
		}
	
        protected void Page_Load(object sender, EventArgs e)
        {
			///创建函数库
			dh = new DeepSoonHelp();
		
			///获取classID
			AuthorID = Request.QueryString["AuthorID"];
			
			if(dh.notHasSQLInsertCode(AuthorID) ){
				///获取className:
				MysqlHelp mh = new MysqlHelp();
				DataTable classNameDt = new DataTable();
				classNameDt = mh.GetDatabysql("Select Name From Users4DeepSoon Where ID = "+AuthorID);
				if(classNameDt.Rows.Count > 0){
					className = classNameDt.Rows[0]["Name"].ToString()+"的主页";
					themeFileName = "T_authorList.html";
					
					///获取articlePageCurrentStr
					string articlePageCurrentStr = Request.QueryString["Page"];
					///获取合法的articlePageCurrentStr
					articlePageCurrentStr = dh.getValidateNumStr(articlePageCurrentStr);
					///获取当前页码		
					articlePageCurrent = Convert.ToInt32(articlePageCurrentStr);
		
					///设置标题以及当前位置：
					Page.Title = className;
		
					///获取首选项的urlRule配置
					urlRule = dh.getUrlRule();
		
					///获取模板内容
					themeHtml = dh.getThemeHtml(themeFileName);
		
					///处理广告标签
					themeHtml = dh.replaceAdTag(themeHtml,"ViewRight");
		
					///处理头版头条标签
					themeHtml = dh.replaceHdTitleTag(themeHtml,urlRule);
		
					///处理幻灯图片标签
					themeHtml = dh.replaceImgPlayerTag(themeHtml,urlRule);
			
					///处理list文章列表标签
					themeHtml = replaceAuthorListTag(themeHtml,urlRule,AuthorID,articlePageCurrent);
		
					///处理showList文章标签
					themeHtml = dh.replaceShowListTag(themeHtml,urlRule);
		
					///处理作者信息标签
					themeHtml = replaceAuthorInforTag(themeHtml,AuthorID);
		
					///将网页数据显示
					this.labelListContent.Text = themeHtml;
				}
				else {
					Response.Write("<script>alert('作者不存在！');</script>");
				}
				
			}
			else{
				Response.Write("<script>alert('请勿注入SQL');</script>");
			}
			
			
		}
	
    }
	//End authorList4userCenter Class
	
	/* 
	类名: addArticle4userCenter 
	功能：会员中心.添加文章类
	作者：书红
	*/
	//Start addArticle4userCenter Class
	public partial class addArticle4userCenter : PageBase4userCenter
    {
		
		DataTable dt = null;
		string className = null;
		
		protected string articleOldStr = "";
		protected string attachmentFileStr = "";
		
		///定义树节点的结构体
		struct ClassTreeNode{
			public string ID;
			public string Name;
			public string OutLinkHref;
			public int Level;
		}
		
		
        protected void Page_Load(object sender, EventArgs e)
        {
			if (!IsPostBack) 
			{ 
				MysqlHelp mh = new MysqlHelp();
				dt = mh.GetDatabysql("Select * From Class4DeepSoon Where openArea='all' Order By Id");
				///显示ID=?的节点+孩子节点，并设定层级初值level
				ClassTreeNode nd;
				nd.ID="0";               ///节点ID
				nd.Name="请选择所属栏目";        ///节点Name
				nd.OutLinkHref = "";     ///节点外链OutLinkHref
				nd.Level=0;              ///节点Level
				///添加栏目下拉菜单
				ListItem li=new ListItem(nd.Name,"Enable"+nd.ID);
				li.Attributes.Add("style","color:#1081BC;");
				this.dropListClassName.Items.Add(li);
				showNodes(nd);
				
				MysqlHelp settingmh = new MysqlHelp();
				///读取配置表信息：
				bool addArticleOpen=true;
				DataTable settingDt=new DataTable();
				settingDt = settingmh.GetDatabysql("Select * From UserCenterSetting4DeepSoon");
				if(settingDt.Rows.Count > 0){
					addArticleOpen = (bool)settingDt.Rows[0]["addArticleOpen"];
					if(!addArticleOpen){
						this.addArticleContent.Text ="<img src='../Resources/Images/cry.gif'> 管理员已关闭发布文章功能，请您改天再来发布吧!";
					}
				}
			}
			
			this.btnAdd.Attributes.Add("onClick", "document.getElementById('hiddArticle').value = document.getElementById('contentBox').contentWindow.document.body.innerHTML;var textBriefInfor;if(document.all){textBriefInfor=document.getElementById('contentBox').contentWindow.document.body.innerText;}else{textBriefInfor=document.getElementById('contentBox').contentWindow.document.body.textContent;}if(textBriefInfor.length > 120)textBriefInfor = textBriefInfor.substring(0,119);document.getElementById('hiddBriefInfor').value = textBriefInfor;");		
		}
		
		protected void btnAdd_Click(object sender, EventArgs e)
		{
			string title = this.txtTitle.Text.Replace("'", "");
			string classId = this.dropListClassName.SelectedItem.Value;
			string article = Request.Form.Get("hiddArticle").ToString().ToLower().Replace("'","");
			///article = article.Replace("\"","");
			string briefInfor = Request.Form.Get("hiddBriefInfor").ToString(); 
			if(briefInfor.Length>120)briefInfor = briefInfor.Substring(0,120);
			briefInfor = Regex.Replace(briefInfor, @"\s*|\t|\r|\n", "", RegexOptions.IgnoreCase);
			briefInfor = Regex.Replace(briefInfor, "（", "(", RegexOptions.IgnoreCase);
			briefInfor = Regex.Replace(briefInfor, "）", ")", RegexOptions.IgnoreCase);		
			string thumbnailImage = getImageUrl(Request.Form.Get("hiddArticle").ToString());
			bool classIdEnable = classId.Contains("Enable");
			
			attachmentFileStr = Request.Form.Get("attachmentFile").ToString().ToLower().Replace("'","");
			
			///过滤敏感sql字符：
			DeepSoonHelp dp = new DeepSoonHelp();
			if(dp.notHasSQLInsertCode(title) && dp.notHasSQLInsertCode(article)  && dp.notHasSQLInsertCode(attachmentFileStr)){
			
				if(classIdEnable){
					labelAddInfor.Text = "选择的所属栏目不合法，不允许外部栏目！";
					articleOldStr = article.Replace("\"","\'");
				}
				else{
					if(title != "" && !classIdEnable && article != ""){
						string Values = "'"+title+"','会员投稿','"+base.strUser4userCenter+"','"+classId+"','"+article+"','"+briefInfor+"','"+thumbnailImage+"',False";
						///创建数据连接对象：
						MysqlHelp mh = new MysqlHelp();
						mh.Runsql("Insert Into Article4DeepSoon(Title,Source,Author,ClassID,Article,BriefInfor,thumbnailImage,isPassed) Values ("+Values+")");
						labelAddInfor.Text = "文章已添加！"+briefInfor;
					
						///获取新添加的文章ID
						DataTable newArticleDt = new DataTable();
						newArticleDt = mh.GetDatabysql("Select ID From Article4DeepSoon Order By ID DESC Limit 1");
						string newArticleID = "";
						if(newArticleDt.Rows.Count>0){
							newArticleID = newArticleDt.Rows[0]["ID"].ToString();
						}
						
						///添加附件表记录
						if( attachmentFileStr.Length > 0 ){
							string attachmentFile = attachmentFileStr.Substring(0,attachmentFileStr.Length-1);
							string[] fileArray = attachmentFile.Split(new char[1]{'|'});
							foreach (string fileUrl in fileArray){
								string insertattAchmentFileSQL = "insert into attachmentFile4DeepSoon(uploadAuthor,fileUrl,ArticleID) values ('"+base.strUser4userCenter+"','"+fileUrl+"','"+newArticleID+"')";
								mh.Runsql(insertattAchmentFileSQL);
							}
						}
					
						Response.Redirect("Default.aspx");
					}
					else {
						labelAddInfor.Text = "文章信息没有填写完整！";
						articleOldStr = article.Replace("\"","\'");
					}
				}
			}
			else{
				Response.Write("<script language='JavaScript'>alert('请不要SQL注入!');</script>");
			}
			
		}
		
		/// 获取文中图片地址
		public static string getImageUrl(string content)
		{ 
			string imgSrcValue = "";
			MatchCollection mc = Regex.Matches(content, @"<img(?:(?!src).)*src=(['""]?)(?<path>.*?)/(?<name>[^/\s'""]*)\1", RegexOptions.IgnoreCase);
			if( mc.Count > 0){
				Match m = mc[0];
				imgSrcValue += m.Groups["path"].Value + "/";
				imgSrcValue += m.Groups["name"].Value;
			}
			return imgSrcValue;
		} 
		
		///显示节点+孩子节点
		private void showNodes(ClassTreeNode node)
        {
			this.showNodesFunction(node);
		}
		///显示节点递归函数
		private void showNodesFunction(ClassTreeNode node)
        {			
			DataRow [] rows = dt.Select("fatherId = '"+node.ID+"'");///筛选node的孩子节点 
			string spaceStr = "";
			foreach(DataRow dr in rows)///循环孩子节点
            {
				ClassTreeNode childNd;
				childNd.ID = dr["id"].ToString();                    ///孩子节点ID
                childNd.Name = dr["name"].ToString();                ///孩子节点Name
				childNd.OutLinkHref = dr["outLinkHref"].ToString();  ///孩子节点外链OutLinkHref
				childNd.Level = node.Level+1; 
				spaceStr = "";
				///孩子节点Level
				for(int i=0;i<childNd.Level;i++){
					spaceStr += "　 ";
				}
				///添加栏目下拉菜单
				///判断当前节点是否有孩子节点
				bool isFather = dr["childID"].ToString().Contains(",");
				if(isFather){
					ListItem li=new ListItem(spaceStr+"├ "+childNd.Name+"*","Enable"+childNd.ID);
					li.Attributes.Add("style","color:#1081BC;");
					this.dropListClassName.Items.Add(li);
				}
				else{
					ListItem li=new ListItem(spaceStr+"├ "+childNd.Name+"",childNd.ID);
					this.dropListClassName.Items.Add(li);
				}
				this.showNodesFunction(childNd);//递归调用自身  
            }
		}
	
    }
	//End addArticle4userCenter Class
	
	/* 
	类名: login4userCenter 
	功能：会员中心.会员登录类
	作者：书红
	*/
	//Start login4userCenter Class
	public partial class login4userCenter : ValidateBase4userCenter
    {
        protected void Page_Load(object sender, EventArgs e)
        {
			if(!IsPostBack){
				if (base.strUser4userCenter != ""){
					this.labelInfor.Text = "您当前状态为已登录，已登录账户:"+base.strUser4userCenter+" 进入<a href='Default.aspx'>会员中心</a>";
					this.txtLoginName.Text = base.strUser4userCenter;
				}
			}
        }
				
        protected void btnLogin_Click(object sender, EventArgs e)
        {
			///获取用户输入的验证码：
			String txtVailValue = this.txtVail.Text.ToUpper().Replace("'", "");
			if(txtVailValue.Length>4)txtVailValue = this.txtVail.Text.Substring(0,4);
			///获取用户输入的账户名：
			String txtLoginNameValue = this.txtLoginName.Text.Replace("'", "");
			if(txtLoginNameValue.Length>20)txtLoginNameValue = this.txtLoginName.Text.Substring(0,20);
			///获取用户输入的保密码：
			String txtLoginPWDValue = this.txtLoginPWD.Text.Replace("'", "");
			if(txtLoginPWDValue.Length>16)txtLoginPWDValue = this.txtLoginPWD.Text.Substring(0,16);
			
			DeepSoonHelp dp = new DeepSoonHelp();
			///检验是否有sql注入敏感字符
			if(dp.notHasSQLInsertCode(txtLoginNameValue) && dp.notHasSQLInsertCode(txtLoginPWDValue)){
				if ( txtVailValue== base.strValidate4userCenter)///如果用户输入的验证码和系统自生成的验证码相同
				{
					///利用MD5进行加密：
					string MD5PWD=System.Web.Security.FormsAuthentication.HashPasswordForStoringInConfigFile(txtLoginPWDValue,"MD5");
			
					///创建数据连接对象：
					MysqlHelp mh = new MysqlHelp();
					///查询数据库
					DataTable dt=new DataTable();
					MySqlParameter[] quryParms  = {new MySqlParameter("?Name",MySqlDbType.VarChar,20),new MySqlParameter("?PWD",MySqlDbType.VarChar,20)};
					quryParms[0].Value = ""+txtLoginNameValue;
					quryParms[1].Value = ""+MD5PWD;
					dt = mh.GetDatabysql("Select * From Users4DeepSoon Where Name=?Name and PWD=?PWD ",quryParms);
				
					///如果数据库查询到了记录，则成功登陆
					if (dt.Rows.Count>0){
						///保存用户登录名到基类的成员变量，并写入cookie
						///base.strUser4userCenter = txtLoginNameValue;
						HttpCookie userCookie = new HttpCookie("strUser4userCenter");
						userCookie.Value = HttpUtility.UrlEncode(HttpUtility.UrlEncode(txtLoginNameValue, Encoding.GetEncoding("UTF-8"))); 
						userCookie.Expires = DateTime.Now.AddDays(7); 
						Response.Cookies.Add(userCookie);
						HttpCookie pwdCookie = new HttpCookie("strPwd4userCenter");
						pwdCookie.Value = HttpUtility.UrlEncode(HttpUtility.UrlEncode(MD5PWD, Encoding.GetEncoding("UTF-8"))); 
						pwdCookie.Expires = DateTime.Now.AddDays(7); 
						Response.Cookies.Add(pwdCookie);
						
						///登录成功，跳转到管理首页
						Response.Redirect("Default.aspx");
					}
					else {
						base.strUser4userCenter = "";
						this.labelInfor.Text = "您输入的用户名或密码不对!";
					}
				}
				else
				{
					///base.strUser = "";
					this.labelInfor.Text = "您输入的验证不对!";
				}	
			
			}///end if(notHasSqlInsert(txtLoginNameValue)
			else{
				base.strUser4userCenter = "";
                this.labelInfor.Text = "本站禁止SQL注入!";
			}	
			
        }
    }
	//End login4userCenter Class
	
	
	/* 
	类名: userCenter2Register 
	功能：会员中心.会员注册类
	作者：书红
	*/
	//Start userCenter2Register Class
	public partial class userCenter2Register : ValidateBase4userCenter
	{
		protected void Page_Load(object sender, EventArgs e)
		{
			if(!IsPostBack)
			{
				MysqlHelp settingmh = new MysqlHelp();
				///读取配置表信息：
				bool registerOpen=true;
				DataTable settingDt=new DataTable();
				settingDt = settingmh.GetDatabysql("Select * From UserCenterSetting4DeepSoon");
				if(settingDt.Rows.Count > 0){
					registerOpen = (bool)settingDt.Rows[0]["registerOpen"];
					if(!registerOpen){
						this.registerContent.Text ="<img src='../Resources/Images//cry.gif'> 管理员已关闭注册功能，请您改天再来注册吧!";
					}
				}
			}
		}
	
		protected void btnAdd_Click(object sender, EventArgs e)
		{
			///获取用户输入的验证码：
			String txtVailValue = this.txtVail.Text.ToUpper().Replace("'", "");
			if(txtVailValue.Length>4)txtVailValue = this.txtVail.Text.Substring(0,4);
			///获取用户输入的账号：
			string txtLoginNameValue = this.txtLoginName.Text.Replace("'", "");
			if(txtLoginNameValue.Length>20)txtLoginNameValue = txtLoginNameValue.Substring(0,20);
			///获取用户输入的保密码：
			string txtLoginPWDValue = this.txtLoginPWD.Text.Replace("'", "");
			if(txtLoginPWDValue.Length>16)txtLoginPWDValue = this.txtLoginPWD.Text.Substring(0,16);
			///获取用户输入的确认密码：
			string txtLoginPWDAgainValue = this.txtLoginPWDAgain.Text.Replace("'", "");
			if(txtLoginPWDAgainValue.Length>16)txtLoginPWDAgainValue = txtLoginPWDAgainValue.Substring(0,16);
			///获取用户邮箱：
			string txtEmailValue = this.txtEmail.Text.Replace("'", "");
			if(txtEmailValue.Length>40)txtEmailValue = txtEmailValue.Substring(0,40);
			
			DeepSoonHelp dp = new DeepSoonHelp();
			
			if (txtLoginNameValue!="" && txtLoginPWDValue!="" && txtEmailValue != ""){///判断用户输入的是否为空用户名和密码
				if( dp.notHasSQLInsertCode(txtLoginNameValue) && dp.notHasSQLInsertCode(txtLoginPWDValue)  && dp.notHasSQLInsertCode(txtEmailValue) ){
					if ( txtVailValue== base.strValidate4userCenter)///如果用户输入的验证码和系统自生成的验证码相同
					{
						
						Regex reg = new Regex("^[\u4e00-\u9fa5a-zA-Z0-9]+$");
						if (reg.IsMatch(txtLoginNameValue) && reg.IsMatch(txtLoginPWDValue)){///判断是否为汉字/字母/数字的组合
							///正则表达式字符串
							string emailStr = @"^([a-zA-Z0-9_\.\-])+\@(([a-zA-Z0-9\-])+\.)+([a-zA-Z0-9]{2,5})+$";
							//邮箱正则表达式对象
							Regex emailReg = new Regex(emailStr);
							if ( emailReg.IsMatch(txtEmailValue) ){
								if ( txtLoginPWDValue== txtLoginPWDAgainValue)///如果用户输入的密码和确认密码相同
								{
									///创建数据连接对象：
									MysqlHelp mh = new MysqlHelp();
									///查询数据库，主要检测用户名是否已经存在
									DataTable dt=new DataTable();
									MySqlParameter[] quryParms  = {new MySqlParameter("?Name",MySqlDbType.VarChar,20)};
									quryParms[0].Value = ""+txtLoginNameValue;
									dt = mh.GetDatabysql("Select * From Users4DeepSoon Where Name=?Name",quryParms);
				
									///如果数据库查询到了记录，说明用户名已经存在了
									if (dt.Rows.Count>0){
										this.labelAddInfor.Text = "您输入的用户名已经存在!";
									}
									else {
										///请求来路非法，防止恶意注册
										if(Request.UrlReferrer!=null && Request.UrlReferrer.Host==Request.Url.Host)
										{
											///利用MD5进行加密：
											string MD5PWD=System.Web.Security.FormsAuthentication.HashPasswordForStoringInConfigFile(txtLoginPWDValue,"MD5");
											///添加新账户：
											MySqlParameter[] addParms ={new MySqlParameter("?Name",MySqlDbType.VarChar,20),new MySqlParameter("?PWD",MySqlDbType.VarChar,32),new MySqlParameter("?Email",MySqlDbType.VarChar,20)};
											addParms[0].Value = ""+txtLoginNameValue;
											addParms[1].Value = ""+MD5PWD;
											addParms[2].Value = ""+txtEmailValue;
											mh.Runsql("Insert Into Users4DeepSoon(Name,PWD,Email,Class) Values (?Name,?PWD,?Email,'normal')", addParms);
											///注册成功，跳转到管理首页
											this.labelAddInfor.Text="恭喜，注册成功。现在您可以<a href='userCenter2Login.aspx'>登陆</a>会员中心了。";
											this.txtLoginName.Text = "";
											this.txtEmail.Text = "";
											this.txtVail.Text = "";
											///Response.Redirect("userCenter2Login.aspx");
										}
										else {
											Response.Write("<script>alert('请勿恶意注册。');</script>");
										}
									}
								}
								else
								{
									this.labelAddInfor.Text="你输入的前后密码不一致";
								}
						
							}
							else {
								this.labelAddInfor.Text="你输入的邮箱格式非法!";
							}
						
						}
						else{
							this.labelAddInfor.Text="用户名和保密码只允许输入汉字/字母/数字的组合，不允许其他字符!";
						}
					}
					else{
						this.labelAddInfor.Text = "您输入的验证不对!";
					}
				}
				else{
					this.labelAddInfor.Text="本站不允许SQL注入!";
				}
				
			}//end 判断是否账户名和密码为空
			else
			{
				this.labelAddInfor.Text="账户名和密码不允许为空!";
			}
		}///end btnAdd_Click()
	}
	//End userCenter2Register Class
	
	/* 
	类名: resetPWD4userCenter 
	功能：会员中心.重设密码类
	作者：书红
	*/
	//Start resetPWD4userCenter Class
	public partial class resetPWD4userCenter : ValidateBase4userCenter
	{
		protected void Page_Load(object sender, EventArgs e)
		{
			
		}
		
		protected void btnReset_Click(object sender, EventArgs e)
		{
			///获取用户输入的验证码：
			String txtVailValue = this.txtVail.Text.ToUpper().Replace("'", "");
			if(txtVailValue.Length>4)txtVailValue = this.txtVail.Text.Substring(0,4);
			///获取用户输入的账号：
			string txtLoginNameValue = this.txtLoginName.Text.Replace("'", "");
			if(txtLoginNameValue.Length>20)txtLoginNameValue = txtLoginNameValue.Substring(0,20);
			///获取用户输入的注册邮箱
			string txtEmailValue = this.txtEmail.Text.Replace("'", "");
			if(txtEmailValue.Length>40)txtEmailValue = txtEmailValue.Substring(0,40);
		
			DeepSoonHelp dp = new DeepSoonHelp();
			
			///检验是否有sql注入敏感字符
			if(dp.notHasSQLInsertCode(txtLoginNameValue) && dp.notHasSQLInsertCode(txtEmailValue)){
				if ( txtVailValue== base.strValidate4userCenter)///如果用户输入的验证码和系统自生成的验证码相同
				{
					if (txtLoginNameValue!="" && txtEmailValue!=""){///判断用户输入的是否为空用户名和邮箱
						///创建数据连接对象：
						MysqlHelp mh = new MysqlHelp();
						///查询数据库，主要检测用户名是否已经存在
						DataTable dt=new DataTable();
						dt = mh.GetDatabysql("Select * From Users4DeepSoon Where Name='"+txtLoginNameValue+"' and Email='"+txtEmailValue+"' and Class = 'normal'");
		
						///如果数据库查询到了记录，说明用户名已经存在了
						if (dt.Rows.Count>0){
							///利用MD5进行加密：
							string MD5PWD=System.Web.Security.FormsAuthentication.HashPasswordForStoringInConfigFile("123456","MD5");
							///重置账户密码为123456：
							mh.Runsql("Update Users4DeepSoon Set PWD='"+MD5PWD+"' Where Name='"+txtLoginNameValue+"'");
							this.labelResetInfor.Text = "您的账户密码已经重置为123456，请马上登陆会员中心修改密码!";
						}
						else {
							this.labelResetInfor.Text = "您输入账户名或邮箱不正确!";
						}
					}//end 判断是否账户名和邮箱为空
					else
					{
						this.labelResetInfor.Text="账户名和注册邮箱不允许为空!";
					}
				}
				else{
					this.labelResetInfor.Text = "您输入的验证不对!";
				}
			}
			else{
				base.strUser4userCenter = "";
				this.labelResetInfor.Text = "本站禁止SQL注入!";
				Response.Write("<script language='JavaScript'>alert('请不要SQL注入!');</script>");
			}
		}///end btnAdd_Click()
		
	}
	//End resetPWD4userCenter Class

	
	/* 
	类名: unLogin4userCenter 
	功能：会员中心.退出类
	作者：书红
	*/
	//Start unLogin4userCenter Class
	public partial class unLogin4userCenter : System.Web.UI.Page
    {
		protected void Page_Load(object sender, EventArgs e)
        {
			HttpCookie userNameCookie = Request.Cookies["strUser4userCenter"];
　　　　	if (userNameCookie != null)
　　　　	{
　　　　　　	TimeSpan userNameTs = new TimeSpan(-1, 0, 0, 0);
				userNameCookie.Expires = DateTime.Now.Add(userNameTs);
　　　　　　	Response.AppendCookie(userNameCookie);
　　　　	}
			HttpCookie userPwdCookie = Request.Cookies["strPwd4userCenter"];
　　　　	if (userPwdCookie != null)
　　　　	{
　　　　　　	TimeSpan userPwdTs = new TimeSpan(-1, 0, 0, 0);
				userPwdCookie.Expires = DateTime.Now.Add(userPwdTs);
　　　　　　	Response.AppendCookie(userPwdCookie);
　　　　	}

        }
		
    }
	//End unLogin4userCenter Class
	
	/* 
	类名: updateArticle4userCenter 
	功能：会员中心.更新文章类
	作者：书红
	*/
	//Start updateArticle4userCenter Class
	public partial class updateArticle4userCenter : PageBase4userCenter
    {
		
		///创建数据连接对象：
		MysqlHelp mh = new MysqlHelp();
		DataTable articleDT = new DataTable();
		DataTable dt = new DataTable();
		string ID = null;
		
		protected string articleOldStr = "";
		
		protected string attachmentFileStr = "";
		
		///定义树节点的结构体
		struct ClassTreeNode{
			public string ID;
			public string Name;
			public string OutLinkHref;
			public int Level;
		}
		
        protected void Page_Load(object sender, EventArgs e)
        {
			DeepSoonHelp dh = new DeepSoonHelp();
			ID = Request.QueryString["ID"];
			ID = dh.getValidateNumStr(ID);
			
			if (!IsPostBack) 
			{ 
				dt = mh.GetDatabysql("Select * From Class4DeepSoon Where openArea='all' Order By Id");
				///显示ID=?的节点+孩子节点，并设定层级初值level
				ClassTreeNode nd;
				nd.ID="0";               ///节点ID
				nd.Name="请选择所属栏目";        ///节点Name
				nd.OutLinkHref = "";     ///节点外链OutLinkHref
				nd.Level=0;              ///节点Level
				///添加栏目下拉菜单
				ListItem li=new ListItem(nd.Name,"Enable"+nd.ID);
				li.Attributes.Add("style","color:#1081BC;");
				this.dropListClassName.Items.Add(li);
				showNodes(nd);
				
				if(ID != null){
					///查询数据库
					articleDT = mh.GetDatabysql("Select * From Article4DeepSoon Where Author='"+base.strUser4userCenter+"' and ID="+ID);
					if(articleDT.Rows.Count > 0 ){
						string title = ""+articleDT.Rows[0]["Title"];
						string classId = ""+articleDT.Rows[0]["ClassID"];
						articleOldStr = ""+articleDT.Rows[0]["Article"];
						articleOldStr = articleOldStr.Replace("\"","'");
					
						///初始化表单数据
						ListItem item=this.dropListClassName.Items.FindByValue(classId);
						if(item != null)
						{
							item.Selected = true;
						}
						this.txtTitle.Text = title;
					}
					else {
						Response.Redirect("userCenter2AddArticle.aspx");
					}				
				
				}
				
			}
			
			this.btnAdd.Attributes.Add("onClick", "document.getElementById('hiddArticle').value = document.getElementById('contentBox').contentWindow.document.body.innerHTML;var textBriefInfor;if(document.all){textBriefInfor=document.getElementById('contentBox').contentWindow.document.body.innerText;}else{textBriefInfor=document.getElementById('contentBox').contentWindow.document.body.textContent;}if(textBriefInfor.length > 120)textBriefInfor = textBriefInfor.substring(0,119);document.getElementById('hiddBriefInfor').value = textBriefInfor;");		
		}
		
		protected void btnUpdate_Click(object sender, EventArgs e)
		{
			string title = this.txtTitle.Text.Replace("'", "");
			string classId = this.dropListClassName.SelectedItem.Value;
			string article = Request.Form.Get("hiddArticle").ToString().ToLower().Replace("'","");
			string briefInfor = Request.Form.Get("hiddBriefInfor").ToString(); 
			if(briefInfor.Length>120)briefInfor = briefInfor.Substring(0,120);
			briefInfor = Regex.Replace(briefInfor, @"\s*|\t|\r|\n", "", RegexOptions.IgnoreCase);
			briefInfor = Regex.Replace(briefInfor, "（", "(", RegexOptions.IgnoreCase);
			briefInfor = Regex.Replace(briefInfor, "）", ")", RegexOptions.IgnoreCase);		
			string thumbnailImage = getImageUrl(Request.Form.Get("hiddArticle").ToString());
			bool classIdEnable = classId.Contains("Enable");
			
			attachmentFileStr = Request.Form.Get("attachmentFile").ToString().ToLower().Replace("'","");
			
			///过滤敏感sql字符：
			DeepSoonHelp dp = new DeepSoonHelp();
			if(dp.notHasSQLInsertCode(title) && dp.notHasSQLInsertCode(article)  && dp.notHasSQLInsertCode(attachmentFileStr)){
				if(classIdEnable){
					labelUpdateInfor.Text = "选择的所属栏目不合法，不允许外部栏目！";
					articleOldStr = article.Replace("\"","\'");
				}
				else{
					if(title != "" && !classIdEnable && article != ""){
						mh.Runsql("Update Article4DeepSoon Set Title='"+title+"',ClassID='"+classId+"',Article='"+article+"',BriefInfor='"+briefInfor+"',thumbnailImage='"+thumbnailImage+"',isPassed=False Where ID="+ID);
						labelUpdateInfor.Text = "文章已经更新";
					
						///添加附件表记录
						if( attachmentFileStr.Length > 0 ){
							string attachmentFile = attachmentFileStr.Substring(0,attachmentFileStr.Length-1);
							string[] fileArray = attachmentFile.Split(new char[1]{'|'});
							foreach (string fileUrl in fileArray){
								string insertattAchmentFileSQL = "insert into attachmentFile4DeepSoon(uploadAuthor,fileUrl,ArticleID) values ('"+base.strUser4userCenter+"','"+fileUrl+"','"+ID+"')";
								mh.Runsql(insertattAchmentFileSQL);
							}
						}
					
						Response.Redirect("Default.aspx");
					}
					else {
						labelUpdateInfor.Text = "文章信息没有填写完整！";
						articleOldStr = article.Replace("\"","\'");
					}
				}
			}
			else{
				Response.Write("<script language='JavaScript'>alert('请不要SQL注入!');</script>");
			}
			
		}
		
		/// 获取文中图片地址
		public static string getImageUrl(string content)
		{ 
			string imgSrcValue = "";
			MatchCollection mc = Regex.Matches(content, @"<img(?:(?!src).)*src=(['""]?)(?<path>.*?)/(?<name>[^/\s'""]*)\1", RegexOptions.IgnoreCase);
			if( mc.Count > 0){
				Match m = mc[0];
				imgSrcValue += m.Groups["path"].Value + "/";
				imgSrcValue += m.Groups["name"].Value;
			}
			return imgSrcValue;
		} 
		
		///显示节点+孩子节点
		private void showNodes(ClassTreeNode node)
        {
			this.showNodesFunction(node);
		}
		///显示节点递归函数
		private void showNodesFunction(ClassTreeNode node)
        {			
			DataRow [] rows = dt.Select("fatherId = '"+node.ID+"'");///筛选node的孩子节点 
			string spaceStr = "";
			foreach(DataRow dr in rows)///循环孩子节点
            {
				ClassTreeNode childNd;
				childNd.ID = dr["id"].ToString();                    ///孩子节点ID
                childNd.Name = dr["name"].ToString();                ///孩子节点Name
				childNd.OutLinkHref = dr["outLinkHref"].ToString();  ///孩子节点外链OutLinkHref
				childNd.Level = node.Level+1; 
				spaceStr = "";
				///孩子节点Level
				for(int i=0;i<childNd.Level;i++){
					spaceStr += "　 ";
				}
				///添加栏目下拉菜单
				///判断当前节点是否有孩子节点
				bool isFather = dr["childID"].ToString().Contains(",");
				if(isFather){
					ListItem li=new ListItem(spaceStr+"├ "+childNd.Name+"*","Enable"+childNd.ID);
					li.Attributes.Add("style","color:#1081BC;");
					this.dropListClassName.Items.Add(li);
				}
				else{
					ListItem li=new ListItem(spaceStr+"├ "+childNd.Name+"",childNd.ID);
					this.dropListClassName.Items.Add(li);
				}
				this.showNodesFunction(childNd);//递归调用自身  
            }
		}
	
    }
	//End updateArticle4userCenter Class
	
	/* 
	类名: ValidateCode4userCenter 
	功能：会员中心.验证码生成类
	作者：书红
	*/
	//Start ValidateCode4userCenter Class
	public partial class ValidateCode4userCenter : ValidateBase4userCenter
    {
        /// 验证码长度
        private int codeLen = 4;
        /// 图片清晰度
        private int fineness = 85;
        // 图片宽度
        private int imgWidth = 80;
        // 图片高度
        private int imgHeight = 24;
        // 字体家族名称
        private string fontFamily = "Times New Roman";
        // 字体大小
        private int fontSize = 14;
        // 字体样式
        private int fontStyle = 0;
        // 绘制起始坐标 X
        private int posX = 6;
        // 绘制起始坐标 Y
        private int posY = 0;
        protected void Page_Load(object sender, EventArgs e)
        {
			string validateCode = CreateValidateCode();//生成验证码
            Bitmap bitmap = new Bitmap(imgWidth, imgHeight);// 生成BITMAP图像
            DisturbBitmap(bitmap);// 图像背景
            DrawValidateCode(bitmap, validateCode);// 绘制验证码图像
            bitmap.Save(Response.OutputStream,ImageFormat.Gif);// 保存验证码图像，等待输出
        }
        
		/// 生成验证码
        /// <returns></returns>
        private string CreateValidateCode()
        {
            string validateCode = "";
            Random random = new Random();// 随机数对象
            for (int i = 0; i < codeLen; i++)
            {
                int n = random.Next(26); // 26: a - z  字符
                validateCode += (char)(n + 65); // 将数字转换成大写字母

                //int n = random.Next(10); //数字
                //validateCode += n.ToString();
            }
            base.strValidate4userCenter = validateCode;// 保存验证码
            return validateCode;
        }
        
		/// 图像背景
        /// <param name="bitmap"></param>
        private void DisturbBitmap(Bitmap bitmap)
        {
            Random random = new Random();// 通过随机数生成
            for (int i = 0; i < bitmap.Width; i++)
            {
                for (int j = 0; j < bitmap.Height; j++)
                {
                    if (random.Next(90) <= this.fineness)
                        bitmap.SetPixel(i, j, Color.White);
                }
            }
        }
        
		/// 绘制验证码图像,bitmap 图板,validateCode 验证码值
        /// <param name="bitmap"></param>
        /// <param name="validateCode"></param>
        private void DrawValidateCode(Bitmap bitmap, string validateCode)
        {
            Graphics g = Graphics.FromImage(bitmap);// 获取绘制器对象
			Font font = new Font(fontFamily, fontSize, FontStyle.Bold);// 设置绘制字体
			g.DrawString(validateCode, font, Brushes.Orange, posX, posY);// 绘制验证码图像
        }
    }
	//End ValidateCode4userCenter Class
	
	/* 
	类名: account4userCenter 
	功能：会员中心.账户管理类
	作者：书红
	*/
	//Start account4userCenter Class
	public partial class account4userCenter : PageBase4userCenter
    {
		string userID = "";
		string chatHeadDir = "../UserCenter/ChatHeadImg/";
        protected void Page_Load(object sender, EventArgs e)
        {
			if(!IsPostBack)
            {
				///设置管理员默认账户
				this.txtUpdateLoginName.Text= base.strUser4userCenter;
			
				///创建数据连接对象：
				MysqlHelp mh = new MysqlHelp();
				///查询并显示数据：
				DataTable dt=new DataTable();
				dt = mh.GetDatabysql("Select * From Users4DeepSoon where Name='"+base.strUser4userCenter+"'");
				if(dt.Rows.Count > 0 ){
					userID = "" + dt.Rows[0]["ID"];
					string Email = "" + dt.Rows[0]["Email"];
					string Blog = "" + dt.Rows[0]["Blog"];
					if(Blog == "")Blog = "http://";
					string SelfIntroduction = "" + dt.Rows[0]["SelfIntroduction"];
					string chatHead = "" + dt.Rows[0]["ChatHead"];
					if(chatHead == "")
						chatHead = "dpDefault.jpg";
					this.txtSelfIntroduction.Text = SelfIntroduction;
					this.txtEmail.Text = Email;
					this.txtBlog.Text = Blog;
					this.imgChatHead.ImageUrl = chatHeadDir+chatHead+"?temp="+DateTime.Now.Millisecond.ToString();
					this.hiddenUserID.Value = "ChatHead4ID" + userID;
				}
				else {
					Response.Redirect("Login.aspx");
				}

				MysqlHelp settingmh = new MysqlHelp();
				///读取配置表信息：
				bool uploadChatHeadOpen=true;
				DataTable settingDt=new DataTable();
				settingDt = settingmh.GetDatabysql("Select * From UserCenterSetting4DeepSoon");
				if(settingDt.Rows.Count > 0){
					uploadChatHeadOpen = (bool)settingDt.Rows[0]["uploadChatHeadOpen"];
					if(!uploadChatHeadOpen){
						this.uploadChatHead.Text ="不可上传头像，管理员已将该功能关闭!";
					}
				}
			}
        }
		
		protected void btnUpdate_Click(object sender, EventArgs e)
        {
			///获取用户输入的旧密码：
			string txtUpdateLoginPWDValue = this.txtUpdateLoginPWD.Text.Replace("'", "");
			if(txtUpdateLoginPWDValue.Length>16)txtUpdateLoginPWDValue = this.txtUpdateLoginPWD.Text.Substring(0,16);
			///获取用户输入的新密码：
			string txtUpdateLoginPWDAgainValue = this.txtUpdateLoginPWDAgain.Text.Replace("'", "");
			if(txtUpdateLoginPWDAgainValue.Length>16)txtUpdateLoginPWDAgainValue = this.txtUpdateLoginPWDAgain.Text.Substring(0,16);
			///获取用户输入的个人签名：
			string txtUpdateSelfIntroductionValue = this.txtSelfIntroduction.Text.Replace("'", "");
			///获取用户输入的Email：
			string txtEmailValue = this.txtEmail.Text;
			///获取用户输入的Email：
			string txtBlogValue = this.txtBlog.Text;
			
			///过滤敏感sql字符：
			DeepSoonHelp dp = new DeepSoonHelp();
			if(dp.notHasSQLInsertCode(txtUpdateLoginPWDValue) && dp.notHasSQLInsertCode(txtUpdateLoginPWDAgainValue) && dp.notHasSQLInsertCode(txtUpdateSelfIntroductionValue) && dp.notHasSQLInsertCode(txtEmailValue) && dp.notHasSQLInsertCode(txtBlogValue)){
				if (txtUpdateLoginPWDAgainValue!="" && txtEmailValue != ""){///判断用户输入的是否为空用户名和密码
					Regex reg = new Regex("^[\u4e00-\u9fa5a-zA-Z0-9]+$");
					if (reg.IsMatch(txtUpdateLoginPWDAgainValue)){///判断是否为汉字/字母/数字的组合
						///利用MD5进行加密：
						string MD5PWDOld=System.Web.Security.FormsAuthentication.HashPasswordForStoringInConfigFile(txtUpdateLoginPWDValue,"MD5");
						string MD5PWDNew=System.Web.Security.FormsAuthentication.HashPasswordForStoringInConfigFile(txtUpdateLoginPWDAgainValue,"MD5");
					
						///创建数据连接对象：
						MysqlHelp mh = new MysqlHelp();
						///查询数据库，主要检测用户名和密码是否已经存在
						DataTable dt=new DataTable();
						MySqlParameter[] quryParms  = {new MySqlParameter("?Name",MySqlDbType.VarChar,20),new MySqlParameter("?PWD",MySqlDbType.VarChar,32)};
						quryParms[0].Value = ""+base.strUser4userCenter;;
						quryParms[1].Value = ""+MD5PWDOld;
						dt = mh.GetDatabysql("Select * From Users4DeepSoon Where Name=?Name and PWD=?PWD and Class = 'normal'",quryParms);
				
						///如果数据库查询到了记录，说明要修改的账户已经存在于数据库中
						if (dt.Rows.Count>0 && txtEmailValue != ""){
							///修改账户的密码：
							mh.Runsql("Update Users4DeepSoon Set PWD='"+MD5PWDNew+"',SelfIntroduction='"+txtUpdateSelfIntroductionValue+"',Email='"+txtEmailValue+"',Blog='"+txtBlogValue+"' Where Name='"+base.strUser4userCenter+"' and Class = 'normal'");
							this.labelAddInfor.Text = base.strUser4userCenter+"账户已经修改!";
						}
						else{
							this.labelAddInfor.Text = "您要修改的账户不存在，或许你输入的旧密码不对!";
						}
					}
					else{
						this.labelAddInfor.Text = "用户名和保密码只允许输入汉字/字母/数字的组合，不允许其他字符!";
					}
				}
				else{
					this.labelAddInfor.Text = "亲，原密码、新密码和邮箱都不能为空的啊!";
				}
			
			}
			else{
				Response.Write("<script language='JavaScript'>alert('请不要SQL注入!');</script>");
			}
			
		}
		
		protected void btnUploadImg_Click(object sender, EventArgs e)
		{
			if (this.fileUpload.HasFile)
			{
				string uploadFileDir = "../UserCenter/ChatHeadImg/";
				
				string fileContentType = this.fileUpload.PostedFile.ContentType;
				if (fileContentType == "image/jpeg"|| fileContentType == "image/pjpeg")
				{
					string name = this.fileUpload.PostedFile.FileName;  /// 客户端上传文件路径
					FileInfo file = new FileInfo(name);
					string FileType = file.Name.Substring(file.Name.LastIndexOf("."));                   ///文件后缀名   
					string fileName = this.hiddenUserID.Value+".jpg";                /// 上传的文件名称
					string webFilePath = Server.MapPath(uploadFileDir + fileName);        /// 服务器端文件路径
					
					try
					{
						if ( File.Exists(webFilePath) )
							File.Delete(webFilePath);
						this.fileUpload.SaveAs(webFilePath);       /// 暂时保存原始文件
						this.imgChatHead.ImageUrl = uploadFileDir + this.hiddenUserID.Value +".jpg?temp="+DateTime.Now.Millisecond.ToString();
						///更新数据库头像字段
						
						DeepSoonHelp dh = new DeepSoonHelp();
						///检验是否有sql注入敏感字符
						if(dh.notHasSQLInsertCode(this.hiddenUserID.Value)){
							MysqlHelp mh = new MysqlHelp();
							mh.Runsql("Update Users4DeepSoon Set ChatHead='"+ this.hiddenUserID.Value +".jpg' Where Name='"+base.strUser4userCenter+"'");
						}
					}catch (Exception ex){}
				}///end if
				else{
					Response.Write("<script language='JavaScript'>alert('用户上传额头像文件只允许Jpg格式!');history.go(-1);</script>");
				}
			}///end if
			else{
				Response.Write("<script language='JavaScript'>alert('没有选择头像文件!');history.go(-1);</script>");
			}

		}///end btnUploadImg_Click

		
        /// <summary>
        /// 缩小裁剪图片
        /// </summary>
        /// <param name="int_Width">要缩小裁剪图片宽度</param>
        /// <param name="int_Height">要缩小裁剪图片长度</param>
        /// <param name="input_ImgUrl">要处理图片路径</param>
        /// <param name="out_ImgUrl">处理完毕图片路径</param>
        public void ImgReduceCutOut(int int_Width,int int_Height,string input_ImgUrl,string out_ImgUrl)
        {
            // ＝＝＝上传标准图大小＝＝＝
            int int_Standard_Width=160;
            int int_Standard_Height=160;

            int Reduce_Width=0; // 缩小的宽度
            int Reduce_Height=0; // 缩小的高度
            int CutOut_Width=0; // 裁剪的宽度
            int CutOut_Height=0; // 裁剪的高度
            int level = 100; //缩略图的质量 1-100的范围
            
            // ＝＝＝获得缩小，裁剪大小＝＝＝
            if (int_Standard_Height*int_Width/int_Standard_Width>int_Height) 
            {
                Reduce_Width=int_Width;
                Reduce_Height=int_Standard_Height*int_Width/int_Standard_Width;
                CutOut_Width=int_Width;
                CutOut_Height=int_Height;
            }
            else if (int_Standard_Height*int_Width/int_Standard_Width<int_Height)
            {
                Reduce_Width=int_Standard_Width*int_Height/int_Standard_Height;
                Reduce_Height=int_Height;
                CutOut_Width=int_Width;
                CutOut_Height=int_Height;
            }
            else
            {
                Reduce_Width=int_Width;
                Reduce_Height=int_Height;
                CutOut_Width=int_Width;
                CutOut_Height=int_Height;
            }

            // ＝＝＝通过连接创建Image对象＝＝＝
            System.Drawing.Image oldimage = System.Drawing.Image.FromFile(Server.MapPath(input_ImgUrl));

            // ＝＝＝缩小图片＝＝＝
            System.Drawing.Image thumbnailImage = oldimage.GetThumbnailImage(Reduce_Width, Reduce_Height,new System.Drawing.Image.GetThumbnailImageAbort(ThumbnailCallback), IntPtr.Zero);
            Bitmap bm=new Bitmap(thumbnailImage); 

            
            // ＝＝＝裁剪图片＝＝＝
            Rectangle cloneRect = new Rectangle(0, 0, CutOut_Width, CutOut_Height);
            PixelFormat format = bm.PixelFormat;
            Bitmap cloneBitmap = bm.Clone(cloneRect, format);

            // ＝＝＝保存图片＝＝＝
			cloneBitmap.Save(Server.MapPath(out_ImgUrl));
        }

        public bool ThumbnailCallback()
        {
            return false;
        }
    }
	//End account4userCenter Class
	
	/* 
	类名: comment4userCenter 
	功能：会员中心.评论类
	作者：书红
	*/
	//Start comment4userCenter Class
	public partial class comment4userCenter : PageBase4userCenter
    {
        protected void Page_Load(object sender, EventArgs e)
        {
			if (!IsPostBack) 
			{ 
				btnDelAll.Attributes.Add("onclick","return confirm(\"是否确认删除？\")") ;
				GridviewBind();
			}
        }
		
		public string GetM(string strm)
		{
			if(strm == "False")
				return "[通过审核]";
			else
				return "[取消通过]";
		}
		
		protected void GridviewBind() 
		{ 
			///创建数据连接对象：
			MysqlHelp mh = new MysqlHelp();
			DataTable dt=new DataTable();
			dt = mh.GetDatabysql("Select * From Comment4DeepSoon Where Author='"+base.strUser4userCenter+"' Order By ID DESC");
			myGridView.DataSource = dt;        
			myGridView.DataBind();
		}
	
		protected void myGridView_PageIndexChanging(object sender, GridViewPageEventArgs e)
		{
			myGridView.PageIndex = e.NewPageIndex;
			GridviewBind();//重新执行自定义的GridView数据绑定函数
			((TextBox)myGridView.BottomPagerRow.FindControl("txtGoPage")).Text = ""+(myGridView.PageIndex+1);
		}
		
		protected void myGridView_RowCommand(object sender, GridViewCommandEventArgs e) 
		{ 
			if(e.CommandName == "deleteFeedBack"){
				///创建数据连接对象：
				MysqlHelp mh = new MysqlHelp();
				MySqlParameter[] updateParms ={new MySqlParameter("?ID",MySqlDbType.VarChar,8)};
				updateParms[0].Value = ""+e.CommandArgument.ToString();
				mh.Runsql("Delete From Comment4DeepSoon Where ID=?ID", updateParms);
				mh.Runsql("Delete From Comment4DeepSoon Where FatherID=?ID", updateParms);
				GridviewBind(); 
			}
			else if(e.CommandName == "setPass"){
				MysqlHelp mh = new MysqlHelp();
				string ID = e.CommandArgument.ToString();
				DataTable Dt = new DataTable();
				Dt = mh.GetDatabysql("Select isPass From Comment4DeepSoon Where ID="+ID);
				if(Dt.Rows.Count>0){
					string isPass = Dt.Rows[0]["isPass"].ToString();
					string isPassNowValue = "False";
					if(isPass == "False")isPassNowValue="True";
					else isPassNowValue = "False";
					mh.Runsql( "Update Comment4DeepSoon Set isPass="+isPassNowValue+" Where ID="+ID );
				}
				GridviewBind(); 
			}
		}
		
		protected void myGridView_RowDataBound(object sender, GridViewRowEventArgs e)
		{
			if (e.Row.RowType == DataControlRowType.DataRow)
			{
				//当鼠标在某一行上方时激发
				e.Row.Attributes.Add("onmouseover", "curColor=this.style.backgroundColor;this.style.backgroundColor='#F0F0F0'");
				//当鼠标从某一行上方移开时激发
				e.Row.Attributes.Add("onmouseout", "this.style.backgroundColor=curColor");
			}
			
			if (e.Row.RowType == DataControlRowType.DataRow)  
			{  
				//设置申请原因字符串显示长度   
				string strDISC = e.Row.Cells[2].Text.Trim();  
				e.Row.Cells[2].Text = "<div class='listover200'>" + strDISC + "</div>";  
				e.Row.Cells[2].ToolTip = strDISC;//鼠标放上去显示所有
				
				string strArticleID = e.Row.Cells[5].Text.Trim();  
				e.Row.Cells[5].Text = "<a href='../publish/view.aspx?id="+strArticleID+"' target='_blank'>查看原文</a>"; 
			}
		}
		
		protected void btnDelAll_Click(object sender, EventArgs e) 
		{ 
			string sqlText = "("; 
			int countNum = 0;//统计用户选取的记录数目
			for (int i = 0; i < myGridView.Rows.Count; i++) 
			{ 
				//搜索第n行3列 
				CheckBox cbx = (CheckBox)myGridView.Rows[i].FindControl("cbxId"); 
				if (cbx.Checked == true) 
				{ 
					sqlText = sqlText + Convert.ToInt32(myGridView.DataKeys[i].Value) + ",";
					countNum ++;
				} 
			} 
			//去掉最后的逗号，并且加上右括号 
			sqlText = sqlText.Substring(0,sqlText.Length - 1) + ")"; 
			if(countNum>0){///如果选择不为空
				MysqlHelp mh = new MysqlHelp();
				mh.Runsql("Delete From Comment4DeepSoon Where ID In" + sqlText);
				mh.Runsql("Delete From Comment4DeepSoon Where FatherID In" + sqlText);
			}
			GridviewBind(); 
		}

		protected void btnSelAll_Click(object sender, EventArgs e) 
		{ 
			for (int i = 0; i < myGridView.Rows.Count; i++) 
			{ 
				//搜索第n行3列 
				CheckBox cbx = (CheckBox)myGridView.Rows[i].FindControl("cbxId"); 
				cbx.Checked = true;
			}
		}
		
		protected void btnUnSelAll_Click(object sender, EventArgs e) 
		{ 
			for (int i = 0; i < myGridView.Rows.Count; i++) 
			{ 
				//搜索第n行3列 
				CheckBox cbx = (CheckBox)myGridView.Rows[i].FindControl("cbxId"); 
				cbx.Checked = false;
			}
		}
		
		#region 转到触发方法
		protected void btnGo_Click(object sender, EventArgs e)
		{
			if(((TextBox)myGridView.BottomPagerRow.FindControl("txtGoPage")).Text != ""){
				myGridView.PageIndex = int.Parse(((TextBox)myGridView.BottomPagerRow.FindControl("txtGoPage")).Text) - 1;
				GridviewBind();   //重新绑定GridView
				((TextBox)myGridView.BottomPagerRow.FindControl("txtGoPage")).Text = ""+(myGridView.PageIndex+1);
			}
		}
		#endregion
		
		protected void btnTruncate_Click(object sender, EventArgs e)
		{
			MysqlHelp mh = new MysqlHelp();
			mh.Runsql("Truncate Table Comment4DeepSoon");
			Response.Redirect("DeepSoonComment.aspx");
		}
	
    }
	//End comment4userCenter Class
	
	/* 
	类名: default4userCenter 
	功能：会员中心.默认页面类
	作者：书红
	*/
	//Start default4userCenter Class
	public partial class default4userCenter : PageBase4userCenter
    {
		string classID = null;
		string className = null;
		
        protected void Page_Load(object sender, EventArgs e)
        {
			btnDelAll.Attributes.Add("onclick","return confirm(\"是否确认删除？\")") ;
			
			if (!IsPostBack) 
			{ 			
				GridviewBind();
			}
        }
		
		public string GetS(string strm)
		{
			if(strm == "False")
				return "未审核";
			else
				return "已审核";
		}
		
		protected void GridviewBind() 
		{ 
			///创建数据连接对象：
			MysqlHelp mh = new MysqlHelp();
			///查询文章表中classID在子类集中的记录
			DataTable dt=new DataTable();
			dt = mh.GetDatabysql("Select Article4DeepSoon.ID,Title,Name,Source,Author,DateStr,isSlideShow,isPassed From Article4DeepSoon,Class4DeepSoon Where Author='"+base.strUser4userCenter+"' and ClassID=Class4DeepSoon.ID and isDelete=false Order By ID DESC");
			myGridView.DataSource = dt;        
			myGridView.DataBind();
		}
	
		protected void myGridView_PageIndexChanging(object sender, GridViewPageEventArgs e)
		{
			myGridView.PageIndex = e.NewPageIndex;
			GridviewBind();//重新执行自定义的GridView数据绑定函数
			((TextBox)myGridView.BottomPagerRow.FindControl("txtGoPage")).Text = ""+(myGridView.PageIndex+1);
		}
		
		protected void myGridView_RowCommand(object sender, GridViewCommandEventArgs e) 
		{ 
			if(e.CommandName == "viewArticle"){
				Response.Write("获取的ID"+e.CommandArgument.ToString() );
				Response.Redirect( "../publish/view.aspx?ID="+e.CommandArgument.ToString() );
			}
			if(e.CommandName == "editArticle"){
				Response.Write("获取的ID"+e.CommandArgument.ToString() );
				Response.Redirect( "UpdateArticle.aspx?ID="+e.CommandArgument.ToString() );
			}
			else if(e.CommandName == "deleteArticle"){
				///创建数据连接对象：
				MysqlHelp mh = new MysqlHelp();
				MySqlParameter[] updateParms ={new MySqlParameter("?ID",MySqlDbType.VarChar,8)};
				updateParms[0].Value = ""+e.CommandArgument.ToString();
				mh.Runsql("Update Article4DeepSoon Set isDelete=true Where ID=?ID", updateParms);		
				GridviewBind(); 
			}
		}
	
		protected void myGridView_RowDataBound(object sender, GridViewRowEventArgs e)
		{
			if (e.Row.RowType == DataControlRowType.DataRow)
			{
				//当鼠标在某一行上方时激发
				e.Row.Attributes.Add("onmouseover", "curColor=this.style.backgroundColor;this.style.backgroundColor='#F0F0F0'");
				//当鼠标从某一行上方移开时激发
				e.Row.Attributes.Add("onmouseout", "this.style.backgroundColor=curColor");
			}
		}
	
		protected void btnDelAll_Click(object sender, EventArgs e) 
		{ 
			string sqlText = "("; 
			int countNum = 0;//统计用户选取的记录数目
			for (int i = 0; i < myGridView.Rows.Count; i++) 
			{ 
				//搜索第n行3列 
				CheckBox cbx = (CheckBox)myGridView.Rows[i].FindControl("cbxId"); 
				if (cbx.Checked == true) 
				{ 
					sqlText = sqlText + Convert.ToInt32(myGridView.DataKeys[i].Value) + ",";
					countNum ++;
				} 
			} 
			//去掉最后的逗号，并且加上右括号 
			sqlText = sqlText.Substring(0,sqlText.Length - 1) + ")"; 
			if(countNum>0){///如果选择不为空
				sqlText = "Update Article4DeepSoon Set isDelete=true Where ID In" + sqlText; 
				MysqlHelp mh = new MysqlHelp();
				mh.Runsql(sqlText); 
			}
			GridviewBind(); 
		}
		
		protected void btnSelAll_Click(object sender, EventArgs e) 
		{ 
			for (int i = 0; i < myGridView.Rows.Count; i++) 
			{ 
				//搜索第n行3列 
				CheckBox cbx = (CheckBox)myGridView.Rows[i].FindControl("cbxId"); 
				cbx.Checked = true;
			}
		}
		
		protected void btnUnSelAll_Click(object sender, EventArgs e) 
		{ 
			for (int i = 0; i < myGridView.Rows.Count; i++) 
			{ 
				//搜索第n行3列 
				CheckBox cbx = (CheckBox)myGridView.Rows[i].FindControl("cbxId"); 
				cbx.Checked = false;
			}
		}

		#region 转到触发方法
		protected void btnGo_Click(object sender, EventArgs e)
		{
			if(((TextBox)myGridView.BottomPagerRow.FindControl("txtGoPage")).Text != ""){
				myGridView.PageIndex = int.Parse(((TextBox)myGridView.BottomPagerRow.FindControl("txtGoPage")).Text) - 1;
				GridviewBind();   //重新绑定GridView
				((TextBox)myGridView.BottomPagerRow.FindControl("txtGoPage")).Text = ""+(myGridView.PageIndex+1);
			}
		}
		#endregion
	
    }
	//End default4userCenter Class
}