﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using System.Net.Mail;
using MySql.Data.MySqlClient;
using System.Web.Configuration; 

public partial class SendMail : System.Web.UI.Page
{
	///邮件配置参变量
	string setTitle="电子邮件";
	string setContent="欢迎给我们发送电子邮件，您提交的信息将直接发送到我们的邮箱!";
	string setButtonName="发送";
	bool setOpen=true;
	string Host="smtp.126.com";
	string Account="";
	string PWD="";
	string FromMail="XXX@126.com";
	string ToMail="XXX@qq.com";
	
	protected string attachmentFileStr = "";
		
	MysqlHelp mh = null;
	DataTable dt = null;
	DeepSoon deepsoon = null;
	
	protected void Page_Load(object sender, EventArgs e)
	{
		///创建数据连接对象：
		mh = new MysqlHelp();
		
		///读取配置表信息：
		DataTable settingDt=new DataTable();
		settingDt = mh.GetDatabysql("Select * From MailSetting4DeepSoon");
		if(settingDt.Rows.Count > 0){
			setTitle = settingDt.Rows[0]["setTitle"].ToString();
			setContent = settingDt.Rows[0]["setContent"].ToString();
			setButtonName = settingDt.Rows[0]["setButtonName"].ToString();
			setOpen = (bool)settingDt.Rows[0]["setOpen"];
			Host = settingDt.Rows[0]["Host"].ToString();
			Account = settingDt.Rows[0]["Account"].ToString();
			PWD = settingDt.Rows[0]["PWD"].ToString();
			FromMail = settingDt.Rows[0]["FromMail"].ToString();
			ToMail = settingDt.Rows[0]["ToMail"].ToString();
			
		}
		this.labelMailTitle.Text = setTitle;
		this.labelMailInfor.Text = setContent;
		this.btnSend.Text = setButtonName;
		
		this.btnSend.Attributes.Add("onClick", "document.getElementById('hiddArticle').value = document.getElementById('contentBox').contentWindow.document.body.innerHTML;"); 
		
		
    }
	
    protected void btnSend_Click(object sender, EventArgs e)
    {
        string StrTo = ToMail;
        string title = this.txtTitle.Text.Replace("'", "").Replace("select", "").Replace("delete", "").Replace("update", "").Replace("insert", "");
		string content = Request.Form.Get("hiddArticle").ToString().ToLower().Replace("'","");
		
		attachmentFileStr = Request.Form.Get("attachmentFile").ToString().ToLower().Replace("'","");
			
		///过滤敏感sql字符：
		DeepSoonHelp dp = new DeepSoonHelp();
		if(dp.notHasSQLInsertCode(attachmentFileStr)){
		}
		else{
			Response.Write("<script language='JavaScript'>alert('请不要SQL注入!');</script>");
			Response.Redirect("index.aspx");
		}
		
		if(title != "" && content != ""){
		
			///防止恶意评论，限定用户spaceTime时间内提交一次。
			int spaceTime = 300;
			Object[] obj = null;
			string userName = Session.SessionID.ToString();  //假定为session中取得的用户名
			if (Session["emailFilter"] != null)
			{
				obj = (Object[])Session["emailFilter"]; 
			}
			else {
				obj = new Object[] { userName, 1 };
			}
			long nowTime = Convert.ToInt64(DateTime.Now.ToString("yyyyMMddhhmmss"));
			long lastTime = Convert.ToInt64(obj[1]);
			if (nowTime - lastTime >= spaceTime && userName != "" && userName != null)
			{
				///添加附件表记录
				if( attachmentFileStr.Length > 0 ){
					string attachmentFile = attachmentFileStr.Substring(0,attachmentFileStr.Length-1);
					string[] fileArray = attachmentFile.Split(new char[1]{'|'});
					foreach (string fileUrl in fileArray){
						string insertattAchmentFileSQL = "insert into attachmentFile4DeepSoon(uploadAuthor,fileUrl,ArticleID) values ('邮件作者','"+fileUrl+"','0')";
						///mh.Runsql(insertattAchmentFileSQL);
					}
				}
					
				bool s = sendmail(StrTo, title, content);
				if(s)
					this.labelInfor.Text = "<font color=green>您的邮件已经成功发送给我们。</font>";
				else 
					this.labelInfor.Text = "<font color=red>邮件发送失败！</font>";
			}
			else {
				Response.Write("<script language='JavaScript'>alert('操作太过频繁!"+spaceTime+"秒后请再提交');</script>");
			}
			Session["emailFilter"] = new Object[] { userName, nowTime };	
		}
		else
			this.labelInfor.Text = "<font color=red>邮件主题和内容都不能为空！</font>";
    }
    public bool sendmail(string StrTo, string title, string content)
    {
        string HostName = Host;   //STMP服务器地址
        string StrAccount = Account;       //SMTP服务帐号
        string StrPwd = PWD;       //SMTP服务密码
        string StrFrom = FromMail;  //发送方邮件地址
        SmtpClient _smtpClient = new SmtpClient();
        _smtpClient.DeliveryMethod = SmtpDeliveryMethod.Network;//指定电子邮件发送方式
        _smtpClient.Host = HostName; ;//指定SMTP服务器
        _smtpClient.Credentials = new System.Net.NetworkCredential(StrAccount, StrPwd);//用户名和密码
        MailMessage _mailMessage = new MailMessage(StrFrom, StrTo);
        _mailMessage.Subject = title;//主题
        _mailMessage.Body = content;//内容
        _mailMessage.BodyEncoding = System.Text.Encoding.UTF8;//正文编码
        _mailMessage.IsBodyHtml = true;//设置为HTML格式
		
		///ZIP附件
		string attFilePath = ""+this.FilePath.Text;
		int pos = attFilePath.LastIndexOf(".");
		if(pos > 0){
			string endName = attFilePath.Substring(pos);
			if(endName == ".zip"){
				var attach = new Attachment(@attFilePath, "application/x-zip-compressed");
				_mailMessage.Attachments.Add(attach);
			}
		}
		
        _mailMessage.Priority = MailPriority.High;//优先级
        try
        {
            _smtpClient.Send(_mailMessage);
			return true;
        }
        catch
        {
			return false;
        }
    }
	
}
