﻿using System;
using System.Data;
using MySql.Data.MySqlClient;

public partial class listClass : System.Web.UI.Page
{
	string className = "";
	string classID = "";
		
	DeepSoonHelp dh = null;
	string themeFileName = "";
	string urlRule = "";
	string themeHtml = "";
	
	int articlePageCurrent = 0;
	
	protected void Page_Load(object sender, EventArgs e)
    {
		///创建函数库
		dh = new DeepSoonHelp();
		
		///获取classID
		classID = Request.QueryString["ClassID"];
		///获取合法的classID
		classID = dh.getValidateNumStr(classID);
			
		///获取className:
		MysqlHelp mh = new MysqlHelp();
		DataTable classNameDt = new DataTable();
		classNameDt = mh.GetDatabysql("Select Name,ThemeFile From Class4DeepSoon Where ID = "+classID);
		if(classNameDt.Rows.Count > 0){
			className = classNameDt.Rows[0]["Name"].ToString();
			themeFileName = classNameDt.Rows[0]["ThemeFile"].ToString();
		}
		else {
			className = "不存在的栏目";
			themeFileName = "T_list.html";
		}
		
		///获取articlePageCurrentStr
		string articlePageCurrentStr = Request.QueryString["Page"];
		///获取合法的articlePageCurrentStr
		articlePageCurrentStr = dh.getValidateNumStr(articlePageCurrentStr);
		///获取当前页码		
		articlePageCurrent = Convert.ToInt32(articlePageCurrentStr);
		
		///设置标题以及当前位置：
		Page.Title = className;
		
		///获取首选项的urlRule配置
		urlRule = dh.getUrlRule();
		
		///获取模板内容
		themeHtml = dh.getThemeHtml(themeFileName);
		
		///处理广告标签
		themeHtml = dh.replaceAdTag(themeHtml,"ViewRight");
		
		///处理头版头条标签
		themeHtml = dh.replaceHdTitleTag(themeHtml,urlRule);
		
		///处理幻灯图片标签
		themeHtml = dh.replaceImgPlayerTag(themeHtml,urlRule);
			
		///处理list文章列表标签
		themeHtml = dh.replaceListTag(themeHtml,urlRule,classID,articlePageCurrent);
		
		///处理showList文章标签
		themeHtml = dh.replaceShowListTag(themeHtml,urlRule);
		
		///处理频道子栏目列表标签
		themeHtml = dh.replaceListClassNameTag(themeHtml,urlRule,classID);
		
		///处理频道信息标签
		themeHtml = dh.replaceListChannelTag(themeHtml,urlRule,classID);
		
		///处理频道信息标签
		themeHtml = dh.replaceBriefInformationTag(themeHtml,classID);
		
		///将网页数据显示
		this.labelListContent.Text = themeHtml;
    }
	
}