﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using MySql.Data.MySqlClient;
using System.Web.Configuration;
using System.Text.RegularExpressions; 
using System.Text;

public partial class defaultPageClass : System.Web.UI.MasterPage
{
	string themeHtml4Nav = "";
	string themeHtml4Copyright = "";
	string ThemeCSS = "";
	string chatHeadDir = "../UserCenter/ChatHeadImg/";
	
	string classID = null;
	string ID = null;
	DeepSoonHelp dh = null;
	MysqlHelp mh = null;
	
	protected void Page_Load(object sender, EventArgs e)
    {
		///创建函数库
		dh = new DeepSoonHelp();
		
		mh = new MysqlHelp();
		
		///获取文章ID
		ID = Request.QueryString["ID"];
		ID = dh.getValidateNumStr(ID);
		
		if(ID != "0"){///所在页面为正文页,可获取ID,通过ID提取classID
			DataTable classIDDt=new DataTable();
			classIDDt = mh.GetDatabysql("Select ClassID From Article4DeepSoon Where ID = '"+ID+"' ");
			if(classIDDt.Rows.Count > 0 ){
				classID = classIDDt.Rows[0]["ClassID"].ToString();
			}
		}
		else{///所在页面非正文页,直接获取classID
			///获取栏目classID
			classID = Request.QueryString["ClassID"];
		}
		
		///获取合法的classID
		classID = dh.getValidateNumStr(classID);
		
		///根据获取的classID,获取其根目录频道rootID
		string rootID = "0";
		DataTable rootDt=new DataTable();
		rootDt = mh.GetDatabysql("Select rootID From Class4DeepSoon Where ID = '"+classID+"' ");
		if(rootDt.Rows.Count > 0 ){
			rootID = rootDt.Rows[0]["rootID"].ToString();
		}
		
		
		///获取导航栏模板代码
		themeHtml4Nav = dh.getThemeHtml("T_nav.html");
		
		///获取版权信息模板代码
		themeHtml4Copyright = dh.getThemeHtml("T_copyright.html");
		
		///获取模板的样式表文件路径
		ThemeCSS = dh.getThemeCSS();
		
		///获取网站的基本信息
		SiteInfor si = dh.getSiteInfor();
		
		///设置网站风格的css文件路径：
		HtmlLink cssLink = new HtmlLink();
		cssLink.Attributes.Add("type","text/css");
		cssLink.Attributes.Add("rel","stylesheet");
		cssLink.Href = ThemeCSS;
		this.Page.Header.Controls.Add(cssLink);		
		
		///处理网站基本信息标签：
		string sitePos = "<a href='/'><b>" + si.siteName + "</b></a> &gt; <b>" + Page.Header.Title+"</b>";
		themeHtml4Nav = themeHtml4Nav.Replace("{dp:siteLogoAddr}", si.siteLogoAddr).Replace("{dp:siteTitle}", si.siteTitle).Replace("{dp:sitePos}", sitePos);
		
		///统计评论总数
		MysqlHelp countMH = new MysqlHelp();
		DataTable userCountDt=new DataTable();
		userCountDt = countMH.GetDatabysql("Select Count(ID) As userCount From Users4DeepSoon");
		string userCount = userCountDt.Rows[0]["userCount"].ToString();
		///处理顶部会员登录banner标签
		string userCenterTopBannerStr = "";
		if (Request.Cookies["strUser4userCenter"] != null && Request.Cookies["strPwd4userCenter"] != null){
			HttpCookie userCookie = Request.Cookies["strUser4userCenter"];
			string loginName = HttpUtility.UrlDecode(HttpUtility.UrlDecode(userCookie.Value, Encoding.GetEncoding("UTF-8")));
			
			HttpCookie pwdCookie = Request.Cookies["strPwd4userCenter"];
			string loginPwd = HttpUtility.UrlDecode(HttpUtility.UrlDecode(pwdCookie.Value, Encoding.GetEncoding("UTF-8")));
			
			string chatHead = chatHeadDir + "dpDefault.jpg";
			string SelfIntroduction = "个人签名";
			
			if(dh.notHasSQLInsertCode(loginName) && dh.notHasSQLInsertCode(loginPwd)){
				///查询并显示数据：
				DataTable dt=new DataTable();
				dt = mh.GetDatabysql("Select * From Users4DeepSoon where Name='"+loginName+"' and PWD='"+ loginPwd +"'");
				if(dt.Rows.Count > 0 ){
					chatHead = "" + dt.Rows[0]["ChatHead"];
					if(chatHead == "")
						chatHead = "dpDefault.jpg";
						SelfIntroduction = "" + dt.Rows[0]["SelfIntroduction"];
						if(SelfIntroduction == "")SelfIntroduction = "Ta很懒，什么也没写";
						if(SelfIntroduction.Length > 10) SelfIntroduction = SelfIntroduction.Substring(0,10)+"...";
				}
			}
				
			userCenterTopBannerStr += "<img src='"+chatHeadDir+""+chatHead+"' style='width:50px;height:50px;float:left;margin-right:10px;'>";
			userCenterTopBannerStr += "欢迎您，"+loginName+"<br>";
			userCenterTopBannerStr += SelfIntroduction+"<br>";
			userCenterTopBannerStr += "<a href='../UserCenter/Default.aspx'>会员中心</a> / ";
			userCenterTopBannerStr += "<a href='../UserCenter/Unlogin.aspx'  onclick='return confirm(\"确定退出吗？\")'>退出</a>";
		}
		else{
			userCenterTopBannerStr += "<img src='../UserCenter/ChatHeadImg/dpDefault.jpg' style='width:50px;height:50px;float:left;margin-right:10px;'>";
			userCenterTopBannerStr += "<a href='../UserCenter/Login.aspx'>立即登录</a>";
			userCenterTopBannerStr += " / ";
			userCenterTopBannerStr += "<a href='../UserCenter/Register.aspx'>注册</a><br>我们已经拥有"+userCount+"名注册会员<br>还等什么，赶快加入组织吧!";
		}
		themeHtml4Nav = themeHtml4Nav.Replace("{dp:userCenterTopBanner}",userCenterTopBannerStr);
		
		///处理网站头信息
		HtmlMeta metaKeywords = new HtmlMeta();
		metaKeywords.Name = "keywords";
		metaKeywords.Content = si.siteKeywords;
		
		HtmlMeta metaDescribe = new HtmlMeta();
		metaDescribe.Name = "description";
		metaDescribe.Content = si.siteDescribe;
		
		HtmlHead head = Page.Header;
		head.Controls.Add(metaKeywords);
		head.Controls.Add(metaDescribe);
		
		Page.Title = (Page.Header.Title.Replace("</b> &gt; <b>正文</b>", "").Replace("</b> &gt; <b>列表</b>", "") +" &brvbar; "+si.siteTitle).Replace("首页 &brvbar;", "")+" - Powered by deepsoon";
		
		///处理版权标签
		string siteOppInfor = "GMT+8."+DateTime.Now.ToString("yyyy-MM-dd")+" "+DateTime.Now.ToLongTimeString().ToString()+". Deepsoon Open Source Soft";
		DeepSoon deepsoon = new DeepSoon();
		themeHtml4Copyright = themeHtml4Copyright.Replace("{dp:siteSystemInfor}",deepsoon.getSystemInfor()).Replace("{dp:siteCopyRight}",si.siteCopyRight).Replace("{dp:siteOppInfor}",siteOppInfor);
		
		///处理菜单栏标签
		string classTreeStr = dh.getClassTreeStr(rootID,classID,si.urlRule);
		themeHtml4Nav = themeHtml4Nav.Replace("{dp:siteNav}", classTreeStr);
		
		///导航栏和版权信息模块显示到网页
		this.labelSiteNav.Text = themeHtml4Nav;
		this.labelSiteCopyright.Text = themeHtml4Copyright;
    }
	
}