﻿<%@ WebHandler Language="C#" Class="Handler" %>

using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using MySql.Data.MySqlClient;
using MySql.Data.Types;
using System.Text.RegularExpressions; 
using System.Text;
using System.Web.Services;
using System.Web.Services.Protocols;
using System.Web.SessionState;

public class Handler : IHttpHandler,IRequiresSessionState 
{

	int PageSize = 4;
	
	///获取文章总数
	private string GetPageCount(string articleID,string setPass)
	{
		DeepSoonHelp dh = new DeepSoonHelp();
		if(dh.notHasSQLInsertCode(articleID)){
			DataTable dt = new DataTable();
			MysqlHelp mh = new MysqlHelp();
			string sql = "";
			if(setPass == "true" || setPass == "True")
				sql = "Select Count(*) As rowCount From Comment4DeepSoon Where isPass = true and ArticleID = " + articleID;
			else sql = "Select Count(*) As rowCount From Comment4DeepSoon Where ArticleID = " + articleID;
			dt = mh.GetDatabysql(sql);
			int rowcount = Convert.ToInt32(dt.Rows[0]["rowCount"]);
			return ((rowcount + PageSize - 1) / PageSize).ToString();
		}
		else{
			return "0";
		}
	}
	
	///获取属于当前页的记录数据
	private string GetPageData(string currentPage,string articleID,string setPass)
	{
		DeepSoonHelp dh = new DeepSoonHelp();
		if(dh.notHasSQLInsertCode(currentPage) && dh.notHasSQLInsertCode(articleID)){
			int PageIndex = Convert.ToInt32(currentPage);
			DataTable commentDt = new DataTable();
			MysqlHelp mh = new MysqlHelp();
			string sql = "";
			if(setPass == "true" || setPass == "True")
				sql = "select Author,IPAddress,Content,DateStr from Comment4DeepSoon Where isPass = true and ArticleID = "+articleID+" order by ID Desc limit "+((PageIndex - 1) * PageSize)+","+PageSize;
			else sql = "select Author,IPAddress,Content,DateStr from Comment4DeepSoon Where ArticleID = "+articleID+"  order by ID Desc  limit "+((PageIndex - 1) * PageSize)+","+PageSize;
			commentDt = mh.GetDatabysql(sql);
			string CommentStr = "";
			for(int i = 0 ; i < commentDt.Rows.Count ; i++)
			{
				string commAuthor = commentDt.Rows[i]["Author"].ToString(); 
			
				string commAuthorChatHead = "../Resources/Images/defaultHeader.jpg";
				DataTable dt=new DataTable();
				dt = mh.GetDatabysql("Select ChatHead From Users4DeepSoon where Name='"+commAuthor+"'");
				if(dt.Rows.Count > 0 ){
					commAuthorChatHead = "" + dt.Rows[0]["ChatHead"];
					if(commAuthorChatHead == "")
						commAuthorChatHead = "../Resources/Images/defaultHeader.jpg";
					else
						commAuthorChatHead = "../UserCenter/ChatHeadImg/" +commAuthorChatHead;
				}
				else {
					commAuthorChatHead = "../Resources/Images/defaultHeader.jpg";
				}
			
				string commIPAddress = commentDt.Rows[i]["IPAddress"].ToString();
				string fullCommIPAddress = commIPAddress;
				int dotPos = commIPAddress.LastIndexOf(".");
				if(dotPos>0){
					commIPAddress = commIPAddress.Substring(0,dotPos)+".*";
				}
				string commContent = commentDt.Rows[i]["Content"].ToString(); 
				string commDateStr = commentDt.Rows[i]["DateStr"].ToString(); 
				
				CommentStr += "<div class='commInfor'>";
				CommentStr += ""+commAuthor;
				CommentStr += " / IP地址 "+commIPAddress+" ";
				CommentStr += " / 发布于："+commDateStr;
				CommentStr += "</div>";
				
				CommentStr += "<div class='commContent'>";
				CommentStr += "<img src='"+commAuthorChatHead+"' style='float:left;width:56px;height:56px;'>";
				CommentStr += "<div style='text-align:left;width:480px;float:right;word-break:break-all;'>"+commContent+"</div>";
				CommentStr += "</div>";
				CommentStr += "<div style='clear:both;'></div>";
			}
			return CommentStr;
		}
		else{
			return "";
		}
		
	}
	
	///添加评论
	private void AddComment(string Content,string Author,string ArticleID)
	{
		Content = Content.Replace("'", "").Replace("select", "").Replace("delete", "").Replace("update", "").Replace("insert", "").Replace("<", "&lt;").Replace(">", "&gt;");
		Author = Author.Replace("'", "").Replace("select", "").Replace("delete", "").Replace("update", "").Replace("insert", "").Replace("<", "&lt;").Replace(">", "&gt;");
		if(Author.Length > 20)Author = Author.Substring(0,20);
		ArticleID = ArticleID.Replace("'", "").Replace("select", "").Replace("delete", "").Replace("update", "").Replace("insert", "").Replace("<", "&lt;").Replace(">", "&gt;");
		
		///创建数据连接对象：
		MysqlHelp mh = new MysqlHelp();
		DeepSoonHelp dh = new DeepSoonHelp();
		string IPAddress = dh.getClientIP();
			
		int setSize = 100;
		bool setOpen=true;
		DataTable settingDt=new DataTable();
		settingDt = mh.GetDatabysql("Select * From CommentSetting4DeepSoon");
		if(settingDt.Rows.Count > 0){
			setOpen = (bool)settingDt.Rows[0]["setOpen"];
			setSize = Convert.ToInt32(settingDt.Rows[0]["setSize"]);
		}
		if(Content.Length > setSize)Content = Content.Substring(0,setSize);
			
		if(setOpen && Content != null && Author != null && ArticleID != null){
			mh.Runsql("Insert Into Comment4DeepSoon(Content,Author,IPAddress,ArticleID) Values ('"+Content+"','"+Author+"','"+IPAddress+"','"+ArticleID+"')");			
		}	
	}
		
	///处理页面请求，返回msg数据
    public void ProcessRequest(HttpContext context)
    {
		///请求来路非法，如果不是合法的ajax请求（例如直接在浏览器栏输入本页面），则跳转到其他页面，防止恶意评论
		if(context.Request.UrlReferrer!=null && context.Request.UrlReferrer.Host==context.Request.Url.Host)
		{
		}
		else {
			context.Response.Redirect("index.aspx");
		}
		
		context.Response.ContentType = "text/plain";
		//不让浏览器缓存
		context.Response.Buffer = true;
		context.Response.ExpiresAbsolute = DateTime.Now.AddDays(-1);
		context.Response.AddHeader("pragma", "no-cache");
		context.Response.AddHeader("cache-control", "");
		context.Response.CacheControl = "no-cache";
		
		DeepSoonHelp dh = new DeepSoonHelp();
		string result = "";
		///获取记录分页总数
		string getPageCount = context.Request.Params["getPageCount"];
		getPageCount = dh.getValidateNumStr(getPageCount);
		///当前页码
		string pageIndex = context.Request.Params["pageIndex"];
		pageIndex = dh.getValidateNumStr(pageIndex);
		///评论文章ID
		string articleID = context.Request.Params["articleID"];
		articleID = dh.getValidateNumStr(articleID);
		///是否通过审核后显示评论
		string setPass = context.Request.Params["setPass"];
		
		///评论正文
		string CommContent = context.Request.Params["CommContent"];
		///评论作者
		string CommAuthor = context.Request.Params["CommAuthor"];
		///评论文章ID
		string CommArticleID = context.Request.Params["CommArticleID"];
		CommArticleID = dh.getValidateNumStr(CommArticleID);
		
		///添加评论
		if (context.Request.Params["CommContent"] != null && context.Request.Params["CommAuthor"] != null && context.Request.Params["CommArticleID"] != null){ 
			///防止恶意评论，限定用户spaceTime时间内提交一次。
			int spaceTime = 30;
			Object[] obj = null;
			string userName = context.Session["CommentSubmitAuthor"].ToString();  //假定为session中取得的用户名
			if (context.Session["filter"] != null)
			{
				obj = (Object[])context.Session["filter"]; 
			}
			else {
				obj = new Object[] { userName, 1 };
			}
			long nowTime = Convert.ToInt64(DateTime.Now.ToString("yyyyMMddhhmmss"));
			long lastTime = Convert.ToInt64(obj[1]);
			if (nowTime - lastTime >= spaceTime && userName != "" && userName != null)
			{
				if( dh.notHasSQLInsertCode(CommContent) && dh.notHasSQLInsertCode(CommAuthor)){
					AddComment(CommContent,CommAuthor,CommArticleID);
					result = "评论已成功提交!";
				}
				else{
					result = "评论中含有敏感字符!";
				}
			}
			else {
				///context.Response.Write("<script>alert('操作太过频繁！拒绝操作。')</script>");
				result = "操作太过频繁！请在"+spaceTime+"秒后再提交。";
			}
			context.Session["filter"] = new Object[] { userName, nowTime };	
		}
		
		///获取文章的总页数
		if (context.Request.Params["getPageCount"] != null && context.Request.Params["articleID"] != null && context.Request.Params["setPass"] != null){ 
			result = GetPageCount(articleID,setPass);
		}
		///获取当前页的数据
		if (context.Request.Params["pageIndex"] != null && context.Request.Params["articleID"] != null && context.Request.Params["setPass"] != null)
		{
			if( dh.notHasSQLInsertCode(setPass) ){
				result = GetPageData(pageIndex,articleID,setPass);
			}
		}
		context.Response.ContentType = "text/xml";
		context.Response.Write(result);
	}

	public bool IsReusable
	{
		get
		{
			return false;
		}
	}

}