﻿<%@ WebHandler Language="C#" Class="Handler" %>

using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using MySql.Data.MySqlClient;
using MySql.Data.Types;
using System.Text.RegularExpressions; 
using System.Text;
using System.Web.Services;
using System.Web.Services.Protocols;
using System.Web.SessionState;

public class Handler : IHttpHandler,IRequiresSessionState 
{

		///定义树节点的结构体
		struct ClassTreeNode{
			public string ID;
			public string Name;
			public string OutLinkHref;
			public int Level;
		}
		
		MysqlHelp mh = null;
		DataTable dt = null;
		string treeStr="";
		
		///显示节点递归函数
		private void showNodesFunction(ClassTreeNode node)
        {			
			DataRow [] rows = dt.Select("fatherId = '"+node.ID+"'");///筛选node的孩子节点 
			
			if(rows.Length > 0){
			treeStr +=	"\n<ul>";
			}
			int i=0;			
			foreach(DataRow dr in rows)///循环孩子节点
            {
				ClassTreeNode childNd;
				childNd.ID = dr["id"].ToString();                    ///孩子节点ID
                childNd.Name = dr["name"].ToString();                ///孩子节点Name
				childNd.OutLinkHref = dr["outLinkHref"].ToString();  ///孩子节点外链OutLinkHref
				childNd.Level = node.Level+1;
				treeStr += "\n<li>";
				DataRow [] childRows = dt.Select("fatherId = '"+childNd.ID+"'");
				if(childRows.Length > 0){
					treeStr +=	"<em></em>";
				}
				treeStr += "<a href='javascript:void(0);'>"+childNd.Name+"</a>";
				i++;
				this.showNodesFunction(childNd);//递归调用自身 
				treeStr += "\n</li>";
            }
			
			if(rows.Length > 0)
				treeStr +=	"\n</ul>";
		}
		
	///处理页面请求，返回msg数据
    public void ProcessRequest(HttpContext context)
    {
		mh = new MysqlHelp();
		dt = mh.GetDatabysql("Select * From Class4DeepSoon Order By Id");
		
		ClassTreeNode nd;
		nd.ID="0";               ///节点ID
		nd.Name="门户网";        ///节点Name
		nd.OutLinkHref = "";     ///节点外链OutLinkHref
		nd.Level=-1;              ///节点Level
		showNodesFunction(nd);
			
		context.Response.ContentType = "text/xml";
		context.Response.Write(treeStr);
	}

	public bool IsReusable
	{
		get
		{
			return false;
		}
	}

}