﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Configuration;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls.WebParts;
using MySql.Data.MySqlClient;
using System.IO;
using System.Drawing;
using System.Drawing.Imaging;
using System.Text.RegularExpressions; 

using Security;
namespace Security
{
	/* 
	类名: DeepSoonPWD 
	功能：账户管理类
	作者：书红
	*/
	//Start DeepSoonPWD Class
    public partial class DeepSoonPWD : PageBase
    {
		protected void Page_Load(object sender, EventArgs e)
        {
			if (!IsPostBack) 
			{ 
				
				///操作权限检测
				if( hasRightTo("UserGroupSelect","查看用户组列表") ){
					GridviewBind();
					///设置管理员默认账户
				}
				else{
					Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning')</script>");
				}
				this.txtUpdateLoginName.Text= base.strUser;
			}
			
			btnDelAll.Attributes.Add("onclick","return confirm(\"删除后数据无法恢复，是否确认删除？\")") ;
			
        }
		
		public string GetM(string strm)
		{
			string roleStr = "";
			switch (strm)
			{
				case "super":
					roleStr = "超级用户";
					break;
				case "normal":
					roleStr = "普通用户";
					break;
				default:
					roleStr = "普通用户";
					break;
			}///end switch
			return roleStr;
		}
		
		protected void GridviewBind() 
		{ 
			///创建数据连接对象：
			MysqlHelp mh = new MysqlHelp();
			///查询并显示数据：
			DataTable dt=new DataTable();
			dt = mh.GetDatabysql("Select * From Users4DeepSoon Order By ID DESC");
			myGridView.DataSource = dt;        
			myGridView.DataBind();
		}
	
		protected void myGridView_PageIndexChanging(object sender, GridViewPageEventArgs e)
		{
			myGridView.PageIndex = e.NewPageIndex;
			GridviewBind();//重新执行自定义的GridView数据绑定函数
			((TextBox)myGridView.BottomPagerRow.FindControl("txtGoPage")).Text = ""+(myGridView.PageIndex+1);
		}

		protected void myGridView_RowCommand(object sender, GridViewCommandEventArgs e) 
		{ 
			if(e.CommandName == "editUser"){
				Response.Write("获取的ID"+e.CommandArgument.ToString() );
				Response.Redirect( "PWDUpdate.aspx?ID="+e.CommandArgument.ToString() );
			}
			else if(e.CommandName == "deleteUser"){
				///操作权限检测
				if( hasRightTo("UserDelete","删除用户") ){
					MysqlHelp mh = new MysqlHelp();
					MySqlParameter[] updateParms ={new MySqlParameter("?ID",MySqlDbType.VarChar,8)};
					updateParms[0].Value = ""+e.CommandArgument.ToString();
					mh.Runsql("Delete From Users4DeepSoon Where ID=?ID", updateParms);		
					GridviewBind();
					Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','账户已删除!','OK')</script>");
				}
				else{
					Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning')</script>");
				}	
				
			}
		}
		
		protected void myGridView_RowDataBound(object sender, GridViewRowEventArgs e)
		{
			if (e.Row.RowType == DataControlRowType.DataRow)
			{
				//当鼠标在某一行上方时激发
				e.Row.Attributes.Add("onmouseover", "curColor=this.style.backgroundColor;this.style.backgroundColor='#F0F0F0'");
				//当鼠标从某一行上方移开时激发
				e.Row.Attributes.Add("onmouseout", "this.style.backgroundColor=curColor");
			}
			if (e.Row.RowType == DataControlRowType.DataRow)  
			{  
				//设置申请原因字符串显示长度   
				string userID = e.Row.Cells[1].Text.Trim(); 
				string userHeaderImg = "";
				string userHeaderImgSrc = e.Row.Cells[2].Text.Trim();
				if(userHeaderImgSrc != "&nbsp;" && userHeaderImgSrc != null)
					userHeaderImg = "<img src='../../UserCenter/ChatHeadImg/"+userHeaderImgSrc+"?temp="+DateTime.Now.Millisecond.ToString()+"' style='border:1px solid #CCCCCC;width:60px;height:60px;'>";
				else 
					userHeaderImg = "<img src='../../UserCenter/ChatHeadImg/dpDefault.jpg' style='border:1px solid #CCCCCC;width:60px;height:60px;'>";
				e.Row.Cells[2].Text = userHeaderImg;
				
				string groupID = e.Row.Cells[6].Text.Trim(); 
				///查询数据库
				DataTable dt = new DataTable();
				MysqlHelp mh = new MysqlHelp();
				dt = mh.GetDatabysql("Select * From Group4DeepSoon Where ID="+groupID);
				if(dt.Rows.Count > 0){
					e.Row.Cells[6].Text=dt.Rows[0]["Title"].ToString();
				}
				else{
					e.Row.Cells[6].Text="所在用户组已被删除或不存在!";
				}
				
			}
		}
		
		protected void btnDelAll_Click(object sender, EventArgs e) 
		{ 
			string sqlText = "("; 
			int countNum = 0;//统计用户选取的记录数目
			for (int i = 0; i < myGridView.Rows.Count; i++) 
			{ 
				//搜索第n行3列 
				CheckBox cbx = (CheckBox)myGridView.Rows[i].FindControl("cbxId"); 
				if (cbx.Checked == true) 
				{ 
					sqlText = sqlText + Convert.ToInt32(myGridView.DataKeys[i].Value) + ",";
					countNum ++;
				} 
			} 
			//去掉最后的逗号，并且加上右括号 
			sqlText = sqlText.Substring(0,sqlText.Length - 1) + ")"; 
			if(countNum>0){///如果选择不为空
				///操作权限检测
				if( hasRightTo("UserDelete","批量删除用户") ){
					sqlText = "Delete From Users4DeepSoon Where ID In" + sqlText; 
					MysqlHelp mh = new MysqlHelp();
					mh.Runsql(sqlText);
					Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','账户已删除!','OK')</script>");
				}
				else{
					Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning')</script>");
				}
				
			
			}
			GridviewBind(); 
		}
		
		protected void btnSelAll_Click(object sender, EventArgs e) 
		{ 
			for (int i = 0; i < myGridView.Rows.Count; i++) 
			{ 
				//搜索第n行3列 
				CheckBox cbx = (CheckBox)myGridView.Rows[i].FindControl("cbxId"); 
				cbx.Checked = true;
			}
		}
		
		protected void btnUnSelAll_Click(object sender, EventArgs e) 
		{ 
			for (int i = 0; i < myGridView.Rows.Count; i++) 
			{ 
				//搜索第n行3列 
				CheckBox cbx = (CheckBox)myGridView.Rows[i].FindControl("cbxId"); 
				cbx.Checked = false;
			}
		}
	

		#region 转到触发方法
		protected void btnGo_Click(object sender, EventArgs e)
		{
			if(((TextBox)myGridView.BottomPagerRow.FindControl("txtGoPage")).Text != ""){
				myGridView.PageIndex = int.Parse(((TextBox)myGridView.BottomPagerRow.FindControl("txtGoPage")).Text) - 1;
				GridviewBind();   //重新绑定GridView
				((TextBox)myGridView.BottomPagerRow.FindControl("txtGoPage")).Text = ""+(myGridView.PageIndex+1);
			}
		}
		#endregion
		
		protected void btnAdd_Click(object sender, EventArgs e)
        {
			///获取用户输入的账号：
			string txtLoginNameValue = this.txtLoginName.Text.Replace("'", "");
			if(txtLoginNameValue.Length>20)txtLoginNameValue = txtLoginNameValue.Substring(0,20);
			///获取用户输入的保密码：
			string txtLoginPWDValue = this.txtLoginPWD.Text.Replace("'", "");
			if(txtLoginPWDValue.Length>16)txtLoginPWDValue = this.txtLoginPWD.Text.Substring(0,16);
			///获取用户输入的确认密码：
			string txtLoginPWDAgainValue = this.txtLoginPWDAgain.Text.Replace("'", "");
			if(txtLoginPWDAgainValue.Length>16)txtLoginPWDAgainValue = txtLoginPWDAgainValue.Substring(0,16);
			///获取用户选择的账户权限：
			string txtClassValue = this.dropListClass.SelectedItem.Value.Replace("'", "");
			if(txtClassValue.Length>20)txtClassValue = txtClassValue.Substring(0,20);
						
			if (txtLoginNameValue!="" && txtLoginPWDValue!=""){//判断用户输入的是否为空用户名和密码
				Regex reg = new Regex("^[\u4e00-\u9fa5a-zA-Z0-9]+$");
				if (reg.IsMatch(txtLoginNameValue) && reg.IsMatch(txtLoginPWDValue)){///判断是否为汉字/字母/数字的组合
					if ( txtLoginPWDValue== txtLoginPWDAgainValue)///如果用户输入的密码和确认密码相同
					{
						///创建数据连接对象：
						MysqlHelp mh = new MysqlHelp();
						///查询数据库，主要检测用户名是否已经存在
						DataTable dt=new DataTable();
						MySqlParameter[] quryParms  = {new MySqlParameter("?Name",MySqlDbType.VarChar,20)};
						quryParms[0].Value = ""+txtLoginNameValue;
						dt = mh.GetDatabysql("Select * From Users4DeepSoon Where Name=?Name",quryParms);
				
						///如果数据库查询到了记录，说明用户名已经存在了
						if (dt.Rows.Count>0){
							this.labelInfor.Text = "您输入的用户名已经存在!";
							Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您输入的用户名已经存在!','Warning')</script>");
						}
						else {
							///操作权限检测
							if( hasRightTo("UserAdd","添加用户") ){
								///利用MD5进行加密：
								string MD5PWD=System.Web.Security.FormsAuthentication.HashPasswordForStoringInConfigFile(txtLoginPWDValue,"MD5");
								///添加新账户：
								MySqlParameter[] addParms ={new MySqlParameter("?Name",MySqlDbType.VarChar,20),new MySqlParameter("?PWD",MySqlDbType.VarChar,32),new MySqlParameter("?Class",MySqlDbType.VarChar,20)};
								addParms[0].Value = ""+txtLoginNameValue;
								addParms[1].Value = ""+MD5PWD;
								addParms[2].Value = ""+txtClassValue;
								mh.Runsql("Insert Into Users4DeepSoon(Name,PWD,Class) Values (?Name,?PWD,?Class)", addParms);
								this.labelInfor.Text = "新账户已经成功添加!";
								GridviewBind();
								Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','新账户已经成功添加!','OK')</script>");
							}
							else{
								Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning')</script>");
							}
						}
				
					}
					else
					{
						this.labelInfor.Text="你输入的前后密码不一致!";
						Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','你输入的前后密码不一致!','Error')</script>");
					}					
				}
				else{
					this.labelInfor.Text = "用户名和保密码只允许输入汉字/字母/数字的组合,不允许其他字符!";
					Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','用户名和保密码只允许输入汉字/字母/数字的组合,不允许其他字符!','Error')</script>");
				}
			}//end 判断是否账户名和密码为空
			else
			{
				this.labelInfor.Text="账户名和密码不允许为空!";
				Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','账户名和密码不允许为空!','Error')</script>");
			}
		}///end btnAdd_Click()
		
		protected void btnUpdate_Click(object sender, EventArgs e)
        {
			///获取用户输入的账号：
			string txtUpdateLoginNameValue = this.txtUpdateLoginName.Text.Replace("'", "");
			if(txtUpdateLoginNameValue.Length>20)txtUpdateLoginNameValue = this.txtUpdateLoginName.Text.Substring(0,20);
			///获取用户输入的旧密码：
			string txtUpdateLoginPWDValue = this.txtUpdateLoginPWD.Text.Replace("'", "");
			if(txtUpdateLoginPWDValue.Length>16)txtUpdateLoginPWDValue = this.txtUpdateLoginPWD.Text.Substring(0,16);
			///获取用户输入的新密码：
			string txtUpdateLoginPWDAgainValue = this.txtUpdateLoginPWDAgain.Text.Replace("'", "");
			if(txtUpdateLoginPWDAgainValue.Length>16)txtUpdateLoginPWDAgainValue = this.txtUpdateLoginPWDAgain.Text.Substring(0,16);
			///获取用户选择的账户权限：
			string txtUpdateClassValue = this.dropListUpdateClass.SelectedItem.Value.Replace("'", "");
			if(txtUpdateClassValue.Length>20)txtUpdateClassValue = txtUpdateClassValue.Substring(0,20);
			
			if (txtUpdateLoginNameValue!="" && txtUpdateLoginPWDAgainValue!=""){//判断用户输入的是否为空用户名和密码
				Regex reg = new Regex("^[\u4e00-\u9fa5a-zA-Z0-9]+$");
				if (reg.IsMatch(txtUpdateLoginNameValue) && reg.IsMatch(txtUpdateLoginPWDAgainValue)){///判断是否为汉字/字母/数字的组合
					///利用MD5进行加密：
					string MD5PWDOld=System.Web.Security.FormsAuthentication.HashPasswordForStoringInConfigFile(txtUpdateLoginPWDValue,"MD5");
					string MD5PWDNew=System.Web.Security.FormsAuthentication.HashPasswordForStoringInConfigFile(txtUpdateLoginPWDAgainValue,"MD5");
					
					///创建数据连接对象：
					MysqlHelp mh = new MysqlHelp();
					///查询数据库，主要检测用户名和密码是否已经存在
					DataTable dt=new DataTable();
					MySqlParameter[] quryParms  = {new MySqlParameter("?Name",MySqlDbType.VarChar,20),new MySqlParameter("?PWD",MySqlDbType.VarChar,32)};
					quryParms[0].Value = ""+txtUpdateLoginNameValue;
					quryParms[1].Value = ""+MD5PWDOld;
					dt = mh.GetDatabysql("Select * From Users4DeepSoon Where Name=?Name and PWD=?PWD",quryParms);
				
					///如果数据库查询到了记录，说明要修改的账户已经存在于数据库中
					if (dt.Rows.Count>0){
						///操作权限检测
						if( hasRightTo("UserUpdate","修改用户信息") ){
							///修改账户的密码：
							MySqlParameter[] updateParms ={new MySqlParameter("?PWD",MySqlDbType.VarChar,32),new MySqlParameter("?Name",MySqlDbType.VarChar,20),new MySqlParameter("?Class",MySqlDbType.VarChar,20)};
							updateParms[0].Value = ""+MD5PWDNew;
							updateParms[1].Value = ""+txtUpdateLoginNameValue;
							updateParms[2].Value = ""+txtUpdateClassValue;
							mh.Runsql("Update Users4DeepSoon Set PWD=?PWD,Class=?Class Where Name=?Name", updateParms);
							this.labelInfor.Text = txtUpdateLoginNameValue+"账户已经修改!";
							GridviewBind();
							Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','账户已更新!','OK')</script>");
						}
						else{
							Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning')</script>");
						}
			
					}
					else{
						this.labelInfor.Text = "您要修改的账户不存在,或许你输入的旧密码不对!";
						Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您要修改的账户不存在,或许你输入的旧密码不对!','Warning')</script>");
					}				
				}
				else{
					this.labelInfor.Text = "用户名和保密码只允许输入汉字/字母/数字的组合,不允许其他字符!";
					Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','用户名和保密码只允许输入汉字/字母/数字的组合,不允许其他字符!','Error')</script>");
				}
			}
			else{
				this.labelInfor.Text = "新密码不能为空!";
				Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','新密码不能为空!','Error')</script>");
			}
		}///end btnAdd_Click()
    }
	//End DeepSoonPWD Class
	
	
	/* 
	类名: PWDUpdate 
	功能：修改账户类
	作者：书红
	*/
	//Start PWDUpdate Class
	public partial class PWDUpdate : PageBase
    {
		///创建数据连接对象：
		MysqlHelp mh = new MysqlHelp();
		DataTable dt = new DataTable();
		string ID = null;
		
		protected void Page_Load(object sender, EventArgs e)
		{
			ID = Request.QueryString["ID"];
			
			if(!IsPostBack)
            {
				///绘制用户组下拉列表
				DataTable groupDt = mh.GetDatabysql("Select * From Group4DeepSoon");
				for(int i = 0 ; i < groupDt.Rows.Count ; i++)
				{
					string GroupID = groupDt.Rows[i]["ID"].ToString();
					string GroupTitle = groupDt.Rows[i]["Title"].ToString();
					ListItem li=new ListItem(GroupTitle,GroupID);
					this.GroupID.Items.Add(li);
				} 
				
				DeepSoonHelp dh = new DeepSoonHelp();
				if(ID != null && dh.notHasSQLInsertCode(ID) ){
					///查询数据库
					dt = mh.GetDatabysql("Select * From Users4DeepSoon Where ID="+ID);
					if(dt.Rows.Count > 0 ){
						this.loginID.Text =dt.Rows[0]["ID"].ToString();
						string groupID =dt.Rows[0]["GroupID"].ToString();
						this.txtUpdateLoginName.Text = dt.Rows[0]["Name"].ToString();
						string chatHead = "" + dt.Rows[0]["ChatHead"];
						if(chatHead == "")
							chatHead = "../../UserCenter/ChatHeadImg/dpDefault.jpg";
						this.txtSelfIntroduction.Text = dt.Rows[0]["SelfIntroduction"].ToString();
						this.txtEmail.Text = dt.Rows[0]["Email"].ToString();
						this.txtBlog.Text = dt.Rows[0]["Blog"].ToString();
						this.imgChatHead.ImageUrl = "../../UserCenter/ChatHeadImg/"+chatHead+"?temp="+DateTime.Now.Millisecond.ToString();
						
						///初始化用户组
						ListItem item=this.GroupID.Items.FindByValue(groupID);
						if(item != null)
						{
							item.Selected = true;
						}
					}
				
				}///end IF
			}///End IF			
			
        }
		
		protected void btnUploadImg_Click(object sender, EventArgs e)
		{
			if( hasRightTo("UserUpdate","修改用户信息") ){
				if (this.fileUpload.HasFile)
				{
					string uploadFileDir = "../../UserCenter/ChatHeadImg/";
				
					string fileContentType = this.fileUpload.PostedFile.ContentType;
					if (fileContentType == "image/jpeg"|| fileContentType == "image/pjpeg")
					{
						string name = this.fileUpload.PostedFile.FileName;  /// 客户端上传文件路径
						FileInfo file = new FileInfo(name);
						string FileType = file.Name.Substring(file.Name.LastIndexOf("."));                   ///文件后缀名   
						string fileName = "ChatHead4ID" + this.loginID.Text+""+FileType;                /// 上传的文件名称
						string webFilePath = Server.MapPath(uploadFileDir + fileName);        /// 服务器端文件路径
					
						try
						{
							if ( File.Exists(webFilePath) )
								File.Delete(webFilePath);
							this.fileUpload.SaveAs(webFilePath);       /// 暂时保存原始文件
							this.imgChatHead.ImageUrl = uploadFileDir + fileName +"?temp="+DateTime.Now.Millisecond.ToString();
							///更新数据库头像字段
							MysqlHelp mh = new MysqlHelp();
							mh.Runsql("Update Users4DeepSoon Set ChatHead='" + fileName +"' Where ID='"+this.loginID.Text+"'");
							Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','账户头像已更新!','OK')</script>");
						
						}catch (Exception ex){}
					}///end if
				}///end if

			}
			else{
				Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning')</script>");
			}
			
		}///end btnUploadImg_Click
		
		protected void btnUpdate_Click(object sender, EventArgs e)
		{
			///获取用户ID：
			string loginID = this.loginID.Text.Replace("'", "");
			///获取用户个人签名：
			string txtUpdateSelfIntroductionValue = this.txtSelfIntroduction.Text.Replace("'", "");
			///获取用户的Email：
			string txtEmailValue = this.txtEmail.Text;
			///获取用户的Blog：
			string txtBlogValue = this.txtBlog.Text;
			string groupID = this.GroupID.SelectedItem.Value;
			
			DataTable dt = new DataTable();
			dt = mh.GetDatabysql("Select * From Users4DeepSoon Where ID="+loginID);
			///如果数据库查询到了记录，说明要修改的账户已经存在于数据库中
			if (dt.Rows.Count>0){
				///操作权限检测
				if( hasRightTo("UserUpdateGroup","修改用户所属用户组") ){
					mh.Runsql("Update Users4DeepSoon Set SelfIntroduction='"+txtUpdateSelfIntroductionValue+"',Email='"+txtEmailValue+"',Blog='"+txtBlogValue+"',GroupID='"+groupID+"' Where ID='"+loginID+"'");
					this.labelUpdateInfor.Text = "账户已经修改!";
					Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','账户信息已更新!','OK')</script>");
				}
				else{
					Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning')</script>");
				}
			}
			else{
				this.labelUpdateInfor.Text = "您要修改的账户不存在!";
				Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您要修改的账户不存在!','Warning')</script>");
			}
			
		}

	}//end class
	//End PWDUpdate Class
	
	
	
	/* 
	类名: UserCenterSetting 
	功能：用户中心设置类
	作者：书红
	*/
	//Start UserCenterSetting Class
	public partial class UserCenterSetting : PageBase
    {
		MysqlHelp mh = null;
		DataTable dt = null;
		protected void Page_Load(object sender, EventArgs e)
		{
			if(!IsPostBack)
            {
				MysqlHelp mh = new MysqlHelp();
				
				///读取配置表信息：
				bool registerOpen=true;
				bool uploadChatHeadOpen=true;
				bool uploadFileOpen=true;
				bool addArticleOpen=true;
				DataTable settingDt=new DataTable();
				settingDt = mh.GetDatabysql("Select * From UserCenterSetting4DeepSoon");
				if(settingDt.Rows.Count > 0){
					registerOpen = (bool)settingDt.Rows[0]["registerOpen"];
					uploadChatHeadOpen = (bool)settingDt.Rows[0]["uploadChatHeadOpen"];
					uploadFileOpen = (bool)settingDt.Rows[0]["uploadFileOpen"];
					addArticleOpen = (bool)settingDt.Rows[0]["addArticleOpen"];
					///是否开放注册
					if(registerOpen){
						this.dropRegisterOpen.SelectedIndex = 0;
					}else{
						this.dropRegisterOpen.SelectedIndex = 1;
					}
					///是否开放上传头像
					if(uploadChatHeadOpen){
						this.dropUploadChatHeadOpen.SelectedIndex = 0;
					}
					else {
						this.dropUploadChatHeadOpen.SelectedIndex = 1;
					}
					///是否开放上传文件（含图片）
					if(uploadFileOpen){
						this.dropUploadFileOpen.SelectedIndex = 0;
					}
					else {
						this.dropUploadFileOpen.SelectedIndex = 1;
					}
					///是否开放发布文章
					if(addArticleOpen){
						this.dropAddArticleOpen.SelectedIndex = 0;
					}
					else {
						this.dropAddArticleOpen.SelectedIndex = 1;
					}
				
				}
				
            }			
        }
		

		protected void btnUpdate_Click(object sender, EventArgs e)
		{
			bool registerOpen = true;
			string registerOpenStr = this.dropRegisterOpen.SelectedItem.Value;
			if (registerOpenStr=="false") registerOpen = false;
			
			bool uploadChatHeadOpen = true;
			string uploadChatHeadOpenStr = this.dropUploadChatHeadOpen.SelectedItem.Value;
			if (uploadChatHeadOpenStr == "false") uploadChatHeadOpen = false;
			
			bool uploadFileOpen = true;
			string uploadFileOpenStr = this.dropUploadFileOpen.SelectedItem.Value;
			if (uploadFileOpenStr == "false") uploadFileOpen = false;
			
			bool addArticleOpen = true;
			string addArticleOpenStr = this.dropAddArticleOpen.SelectedItem.Value;
			if (addArticleOpenStr == "false") addArticleOpen = false;
			
			///操作权限检测
			if( hasRightTo("UserCenterUpdate","用户中心更新") ){
				///创建数据连接对象：
				MysqlHelp mh = new MysqlHelp();
				///修改参数：
				mh.Runsql("Update UserCenterSetting4DeepSoon Set registerOpen="+registerOpen+",uploadChatHeadOpen="+uploadChatHeadOpen+",uploadFileOpen="+uploadFileOpen+",AddArticleOpen="+addArticleOpen);
				this.labelUpdateInfor.Text="会员系统配置已经保存!";
				///Response.Redirect("deepSoonUserCenterSetting.aspx");
				Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','会员系统配置已经保存!','OK')</script>");				
			}
			else{
				Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning')</script>");
			}	
			
			
		}

	}//end class
	//End UserCenterSetting Class
	
	
	/* 
	类名: Group 
	功能：用户组管理类
	作者：书红
	*/
	//Start Group Class
	public partial class Group : PageBase
    {
		protected void Page_Load(object sender, EventArgs e)
        {			
			btnDelAll.Attributes.Add("onclick","return confirm(\"是否确认删除？\")") ;
			
			if (!IsPostBack) 
			{ 
				///操作权限检测
				if( hasRightTo("UserGroupSelect","查看用户组列表") ){
					GridviewBind();
				}
				else{
					Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning')</script>");
				}
			}
        }
		
		
		protected void GridviewBind() 
		{ 
			///创建数据连接对象：
			MysqlHelp mh = new MysqlHelp();
			DataTable dt=new DataTable();
			dt = mh.GetDatabysql("Select * From Group4DeepSoon Order By ID DESC");
			myGridView.DataSource = dt;        
			myGridView.DataBind();
		}
	
		protected void myGridView_PageIndexChanging(object sender, GridViewPageEventArgs e)
		{
			myGridView.PageIndex = e.NewPageIndex;
			GridviewBind();//重新执行自定义的GridView数据绑定函数
			((TextBox)myGridView.BottomPagerRow.FindControl("txtGoPage")).Text = ""+(myGridView.PageIndex+1);
		}
		
		protected void myGridView_RowCommand(object sender, GridViewCommandEventArgs e) 
		{ 
			if(e.CommandName == "editGroup"){
				Response.Write("获取的ID"+e.CommandArgument.ToString() );
				Response.Redirect( "GroupUpdate.aspx?ID="+e.CommandArgument.ToString() );
			}
			else if(e.CommandName == "deleteGroup"){
				///操作权限检测
				if( hasRightTo("UserGroupDelete","删除用户组") ){
					///创建数据连接对象：
					MysqlHelp mh = new MysqlHelp();
					MySqlParameter[] updateParms ={new MySqlParameter("?ID",MySqlDbType.VarChar,8)};
					updateParms[0].Value = ""+e.CommandArgument.ToString();
					mh.Runsql("Delete From Group4DeepSoon Where ID=?ID", updateParms);		
					GridviewBind();
					Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','用户组已删除!','OK')</script>");
				}
				else{
					Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning')</script>");
				}
			}
		}
	
		protected void myGridView_RowDataBound(object sender, GridViewRowEventArgs e)
		{
			if (e.Row.RowType == DataControlRowType.DataRow)
			{
				//当鼠标在某一行上方时激发
				e.Row.Attributes.Add("onmouseover", "curColor=this.style.backgroundColor;this.style.backgroundColor='#F0F0F0'");
				//当鼠标从某一行上方移开时激发
				e.Row.Attributes.Add("onmouseout", "this.style.backgroundColor=curColor");
			}
		}
	
		protected void btnDelAll_Click(object sender, EventArgs e) 
		{ 
			string sqlText = "("; 
			int countNum = 0;//统计用户选取的记录数目
			for (int i = 0; i < myGridView.Rows.Count; i++) 
			{ 
				//搜索第n行3列 
				CheckBox cbx = (CheckBox)myGridView.Rows[i].FindControl("cbxId"); 
				if (cbx.Checked == true) 
				{ 
					sqlText = sqlText + Convert.ToInt32(myGridView.DataKeys[i].Value) + ",";
					countNum ++;
				} 
			} 
			//去掉最后的逗号，并且加上右括号 
			sqlText = sqlText.Substring(0,sqlText.Length - 1) + ")"; 
			if(countNum>0){///如果选择不为空
				///操作权限检测
				if( hasRightTo("UserGroupDelete","批量删除用户组") ){
					sqlText = "Delete From Group4DeepSoon Where ID In" + sqlText; 
					MysqlHelp mh = new MysqlHelp();
					mh.Runsql(sqlText); 
					Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','用户组已删除!','OK')</script>");
				}
				else{
					Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning')</script>");
				}
			}
			GridviewBind(); 
		}
		
		protected void btnSelAll_Click(object sender, EventArgs e) 
		{ 
			for (int i = 0; i < myGridView.Rows.Count; i++) 
			{ 
				//搜索第n行3列 
				CheckBox cbx = (CheckBox)myGridView.Rows[i].FindControl("cbxId"); 
				cbx.Checked = true;
			}
		}
		
		protected void btnUnSelAll_Click(object sender, EventArgs e) 
		{ 
			for (int i = 0; i < myGridView.Rows.Count; i++) 
			{ 
				//搜索第n行3列 
				CheckBox cbx = (CheckBox)myGridView.Rows[i].FindControl("cbxId"); 
				cbx.Checked = false;
			}
		}


		#region 转到触发方法
		protected void btnGo_Click(object sender, EventArgs e)
		{
			if(((TextBox)myGridView.BottomPagerRow.FindControl("txtGoPage")).Text != ""){
				myGridView.PageIndex = int.Parse(((TextBox)myGridView.BottomPagerRow.FindControl("txtGoPage")).Text) - 1;
				GridviewBind();   //重新绑定GridView
				((TextBox)myGridView.BottomPagerRow.FindControl("txtGoPage")).Text = ""+(myGridView.PageIndex+1);
			}
		}
		#endregion
		
    }
	//End Group Class
	
	
	/* 
	类名: GroupAdd 
	功能：用户组添加类
	作者：书红
	*/
	//Start GroupAdd Class
    public partial class GroupAdd : PageBase
    {
		protected void Page_Load(object sender, EventArgs e)
		{
			if(!IsPostBack)
            {
				
			}
        }
		
		protected void btnAdd_Click(object sender, EventArgs e)
		{
			string Title = this.Title.Text.Replace("'", "");
			bool PreferenceUpdate = this.PreferenceUpdate.Checked;
			bool LinksSelect = this.LinksSelect.Checked;
			bool LinksAdd = this.LinksAdd.Checked;
			bool LinksDelete = this.LinksDelete.Checked;
			bool LinksUpdate = this.LinksUpdate.Checked;
			bool LinksCanVisit = this.LinksCanVisit.Checked;
			bool LogSelect = this.LogSelect.Checked;
			bool LogDelete = this.LogDelete.Checked;
			bool ThemeUpdate = this.ThemeUpdate.Checked;
			bool ThemeDelete = this.ThemeDelete.Checked;
			bool ClassTreeSelect = this.ClassTreeSelect.Checked;
			bool ClassTreeAdd = this.ClassTreeAdd.Checked;
			bool ClassTreeDelete = this.ClassTreeDelete.Checked;
			bool ClassTreeUpdate = this.ClassTreeUpdate.Checked;
			bool ArticleSelect = this.ArticleSelect.Checked;
			bool ArticleAdd = this.ArticleAdd.Checked;
			bool ArticleDelete = this.ArticleDelete.Checked;
			bool ArticleUpdate = this.ArticleUpdate.Checked;
			bool ArticleCheck = this.ArticleCheck.Checked;
			bool ArticleSetIndexPic = this.ArticleSetIndexPic.Checked;
			bool ArticleHeadTitle = this.ArticleHeadTitle.Checked;
			bool ArticleRecycle = this.ArticleRecycle.Checked;
			bool ArticleUploadFile = this.ArticleUploadFile.Checked;
			bool ArticleUploadImg = this.ArticleUploadImg.Checked;
			bool DocumentSelect = this.DocumentSelect.Checked;
			bool DocumentAdd = this.DocumentAdd.Checked;
			bool DocumentDelete = this.DocumentDelete.Checked;
			bool DocumentUpdate = this.DocumentUpdate.Checked;
			bool DocumentUploadFile = this.DocumentUploadFile.Checked;
			bool DocumentEdit = this.DocumentEdit.Checked;
			bool UserAdd = this.UserAdd.Checked;
			bool UserDelete = this.UserDelete.Checked;
			bool UserUpdate = this.UserUpdate.Checked;
			bool UserUpdateGroup = this.UserUpdateGroup.Checked;
			bool UserCenterUpdate = this.UserCenterUpdate.Checked;
			bool UserGroupSelect = this.UserGroupSelect.Checked;
			bool UserGroupAdd = this.UserGroupAdd.Checked;
			bool UserGroupDelete = this.UserGroupDelete.Checked;
			bool UserGroupUpdate = this.UserGroupUpdate.Checked;
			bool CommentSettingUpdate = this.CommentSettingUpdate.Checked;
			bool CommentSelect = this.CommentSelect.Checked;
			bool CommentDelete = this.CommentDelete.Checked;
			bool CommentCheck = this.CommentCheck.Checked;
			bool FeedBackSettingUpdate = this.FeedBackSettingUpdate.Checked;
			bool FeedBackSelect = this.FeedBackSelect.Checked;
			bool FeedBackDelete = this.FeedBackDelete.Checked;
			bool FeedBackCheck = this.FeedBackCheck.Checked;
			bool CollectRuleSelect = this.CollectRuleSelect.Checked;
			bool CollectRuleAdd = this.CollectRuleAdd.Checked;
			bool CollectRuleDelete = this.CollectRuleDelete.Checked;
			bool CollectRuleUpdate = this.CollectRuleUpdate.Checked;
			bool CollectRuleExec = this.CollectRuleExec.Checked;
			bool MailSetting = this.MailSetting.Checked;
			
			if(Title != ""){
				Regex reg = new Regex("^[\u4e00-\u9fa5a-zA-Z0-9]+$");
				if (reg.IsMatch(Title)){///判断是否为汉字/字母/数字的组合
					///操作权限检测
					if( hasRightTo("UserGroupAdd","添加用户组") ){
						string Values = "'"+Title+"',"+PreferenceUpdate+","+LinksSelect+","+LinksAdd +","+LinksDelete +","+LinksUpdate +","+LinksCanVisit +","+LogSelect +","+LogDelete +","+ThemeUpdate +","+ThemeDelete +","+ClassTreeSelect +","+ClassTreeAdd +","+ClassTreeDelete +","+ClassTreeUpdate +","+ArticleSelect +","+ArticleAdd +","+ArticleDelete +","+ArticleUpdate +","+ArticleCheck +","+ArticleSetIndexPic +","+ArticleHeadTitle +","+ArticleRecycle +","+ArticleUploadFile +","+ArticleUploadImg +","+DocumentSelect +","+DocumentAdd +","+DocumentDelete +","+DocumentUpdate +","+DocumentUploadFile +","+DocumentEdit +","+UserAdd +","+UserDelete +","+UserUpdate+","+UserUpdateGroup +","+UserCenterUpdate +","+UserGroupSelect +","+UserGroupAdd +","+UserGroupDelete +","+UserGroupUpdate +","+CommentSettingUpdate +","+CommentSelect +","+CommentDelete +","+CommentCheck +","+FeedBackSettingUpdate +","+FeedBackSelect +","+FeedBackDelete +","+FeedBackCheck +","+CollectRuleSelect +","+CollectRuleAdd +","+CollectRuleDelete +","+CollectRuleUpdate +","+CollectRuleExec +","+MailSetting ;
			
						///创建数据连接对象：
						MysqlHelp mh = new MysqlHelp();
						mh.Runsql("Insert Into Group4DeepSoon(Title,PreferenceUpdate,LinksSelect,LinksAdd,LinksDelete,LinksUpdate,LinksCanVisit,LogSelect,LogDelete,ThemeUpdate,ThemeDelete,ClassTreeSelect,ClassTreeAdd,ClassTreeDelete,ClassTreeUpdate,ArticleSelect,ArticleAdd,ArticleDelete,ArticleUpdate,ArticleCheck,ArticleSetIndexPic,ArticleHeadTitle,ArticleRecycle,ArticleUploadFile,ArticleUploadImg,DocumentSelect,DocumentAdd,DocumentDelete,DocumentUpdate,DocumentUploadFile,DocumentEdit,UserAdd,UserDelete,UserUpdate,UserUpdateGroup,UserCenterUpdate,UserGroupSelect,UserGroupAdd,UserGroupDelete,UserGroupUpdate,CommentSettingUpdate,CommentSelect,CommentDelete,CommentCheck,FeedBackSettingUpdate,FeedBackSelect,FeedBackDelete,FeedBackCheck,CollectRuleSelect,CollectRuleAdd,CollectRuleDelete,CollectRuleUpdate,CollectRuleExec,MailSetting) Values ("+Values+")");
						labelAddInfor.Text = "用户组已添加！";
						Response.Redirect("Group.aspx");
					}
					else{
						Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning')</script>");
					}
				}
				else{
					labelAddInfor.Text = "用户组名称只可以是汉字/字母/数字的组合!";
					Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','用户组名称只可以是汉字/字母/数字的组合!','Error')</script>");
				}
			}
			else{
				labelAddInfor.Text = "用户组名称不能为空!";
				Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','用户组名称不能为空!','Error')</script>");
			}
		}

	}
	//End GroupAdd Class
	
	
	
	/* 
	类名: GroupUpdate 
	功能：用户组更新类
	作者：书红
	*/
	//Start GroupUpdate Class
	public partial class GroupUpdate : PageBase
    {
		///创建数据连接对象：
		MysqlHelp mh = new MysqlHelp();
		DataTable dt = new DataTable();
		string ID = null;
		
		protected void Page_Load(object sender, EventArgs e)
		{
			ID = Request.QueryString["ID"];
			
			DeepSoonHelp dh = new DeepSoonHelp();
			if(!IsPostBack)
            {
				if(ID != null && dh.notHasSQLInsertCode(ID) ){
					///查询数据库
					dt = mh.GetDatabysql("Select * From Group4DeepSoon Where ID="+ID);
					this.Title.Text=dt.Rows[0]["Title"].ToString();
					this.PreferenceUpdate.Checked=(bool)dt.Rows[0]["PreferenceUpdate"];
					this.LinksSelect.Checked=(bool)dt.Rows[0]["LinksSelect"];
					this.LinksAdd.Checked=(bool)dt.Rows[0]["LinksAdd"];
					this.LinksDelete.Checked=(bool)dt.Rows[0]["LinksDelete"];
					this.LinksUpdate.Checked=(bool)dt.Rows[0]["LinksUpdate"];
					this.LinksCanVisit.Checked=(bool)dt.Rows[0]["LinksCanVisit"];
					this.LogSelect.Checked=(bool)dt.Rows[0]["LogSelect"];
					this.LogDelete.Checked=(bool)dt.Rows[0]["LogDelete"];
					this.ThemeUpdate.Checked=(bool)dt.Rows[0]["ThemeUpdate"];
					this.ThemeDelete.Checked=(bool)dt.Rows[0]["ThemeDelete"];
					this.ClassTreeSelect.Checked=(bool)dt.Rows[0]["ClassTreeSelect"];
					this.ClassTreeAdd.Checked=(bool)dt.Rows[0]["ClassTreeAdd"];
					this.ClassTreeDelete.Checked=(bool)dt.Rows[0]["ClassTreeDelete"];
					this.ClassTreeUpdate.Checked=(bool)dt.Rows[0]["ClassTreeUpdate"];
					this.ArticleSelect.Checked=(bool)dt.Rows[0]["ArticleSelect"];
					this.ArticleAdd.Checked=(bool)dt.Rows[0]["ArticleAdd"];
					this.ArticleDelete.Checked=(bool)dt.Rows[0]["ArticleDelete"];
					this.ArticleUpdate.Checked=(bool)dt.Rows[0]["ArticleUpdate"];
					this.ArticleCheck.Checked=(bool)dt.Rows[0]["ArticleCheck"];
					this.ArticleSetIndexPic.Checked=(bool)dt.Rows[0]["ArticleSetIndexPic"];
					this.ArticleHeadTitle.Checked=(bool)dt.Rows[0]["ArticleHeadTitle"];
					this.ArticleRecycle.Checked=(bool)dt.Rows[0]["ArticleRecycle"];
					this.ArticleUploadFile.Checked=(bool)dt.Rows[0]["ArticleUploadFile"];
					this.ArticleUploadImg.Checked=(bool)dt.Rows[0]["ArticleUploadImg"];
					this.DocumentSelect.Checked=(bool)dt.Rows[0]["DocumentSelect"];
					this.DocumentAdd.Checked=(bool)dt.Rows[0]["DocumentAdd"];
					this.DocumentDelete.Checked=(bool)dt.Rows[0]["DocumentDelete"];
					this.DocumentUpdate.Checked=(bool)dt.Rows[0]["DocumentUpdate"];
					this.DocumentUploadFile.Checked=(bool)dt.Rows[0]["DocumentUploadFile"];
					this.DocumentEdit.Checked=(bool)dt.Rows[0]["DocumentEdit"];
					this.UserAdd.Checked=(bool)dt.Rows[0]["UserAdd"];
					this.UserDelete.Checked=(bool)dt.Rows[0]["UserDelete"];
					this.UserUpdate.Checked=(bool)dt.Rows[0]["UserUpdate"];
					this.UserUpdateGroup.Checked=(bool)dt.Rows[0]["UserUpdateGroup"];
					this.UserCenterUpdate.Checked=(bool)dt.Rows[0]["UserCenterUpdate"];
					this.UserGroupSelect.Checked=(bool)dt.Rows[0]["UserGroupSelect"];
					this.UserGroupAdd.Checked=(bool)dt.Rows[0]["UserGroupAdd"];
					this.UserGroupDelete.Checked=(bool)dt.Rows[0]["UserGroupDelete"];
					this.UserGroupUpdate.Checked=(bool)dt.Rows[0]["UserGroupUpdate"];
					this.CommentSettingUpdate.Checked=(bool)dt.Rows[0]["CommentSettingUpdate"];
					this.CommentSelect.Checked=(bool)dt.Rows[0]["CommentSelect"];
					this.CommentDelete.Checked=(bool)dt.Rows[0]["CommentDelete"];
					this.CommentCheck.Checked=(bool)dt.Rows[0]["CommentCheck"];
					this.FeedBackSettingUpdate.Checked=(bool)dt.Rows[0]["FeedBackSettingUpdate"];
					this.FeedBackSelect.Checked=(bool)dt.Rows[0]["FeedBackSelect"];
					this.FeedBackDelete.Checked=(bool)dt.Rows[0]["FeedBackDelete"];
					this.FeedBackCheck.Checked=(bool)dt.Rows[0]["FeedBackCheck"];
					this.CollectRuleSelect.Checked=(bool)dt.Rows[0]["CollectRuleSelect"];
					this.CollectRuleAdd.Checked=(bool)dt.Rows[0]["CollectRuleAdd"];
					this.CollectRuleDelete.Checked=(bool)dt.Rows[0]["CollectRuleDelete"];
					this.CollectRuleUpdate.Checked=(bool)dt.Rows[0]["CollectRuleUpdate"];
					this.CollectRuleExec.Checked=(bool)dt.Rows[0]["CollectRuleExec"];
					this.MailSetting.Checked=(bool)dt.Rows[0]["MailSetting"];
				
				}
			}			
			
        }
		
		protected void btnUpdate_Click(object sender, EventArgs e)
		{
			string Title = this.Title.Text.Replace("'", "");
			bool PreferenceUpdate = this.PreferenceUpdate.Checked;
			bool LinksSelect = this.LinksSelect.Checked;
			bool LinksAdd = this.LinksAdd.Checked;
			bool LinksDelete = this.LinksDelete.Checked;
			bool LinksUpdate = this.LinksUpdate.Checked;
			bool LinksCanVisit = this.LinksCanVisit.Checked;
			bool LogSelect = this.LogSelect.Checked;
			bool LogDelete = this.LogDelete.Checked;
			bool ThemeUpdate = this.ThemeUpdate.Checked;
			bool ThemeDelete = this.ThemeDelete.Checked;
			bool ClassTreeSelect = this.ClassTreeSelect.Checked;
			bool ClassTreeAdd = this.ClassTreeAdd.Checked;
			bool ClassTreeDelete = this.ClassTreeDelete.Checked;
			bool ClassTreeUpdate = this.ClassTreeUpdate.Checked;
			bool ArticleSelect = this.ArticleSelect.Checked;
			bool ArticleAdd = this.ArticleAdd.Checked;
			bool ArticleDelete = this.ArticleDelete.Checked;
			bool ArticleUpdate = this.ArticleUpdate.Checked;
			bool ArticleCheck = this.ArticleCheck.Checked;
			bool ArticleSetIndexPic = this.ArticleSetIndexPic.Checked;
			bool ArticleHeadTitle = this.ArticleHeadTitle.Checked;
			bool ArticleRecycle = this.ArticleRecycle.Checked;
			bool ArticleUploadFile = this.ArticleUploadFile.Checked;
			bool ArticleUploadImg = this.ArticleUploadImg.Checked;
			bool DocumentSelect = this.DocumentSelect.Checked;
			bool DocumentAdd = this.DocumentAdd.Checked;
			bool DocumentDelete = this.DocumentDelete.Checked;
			bool DocumentUpdate = this.DocumentUpdate.Checked;
			bool DocumentUploadFile = this.DocumentUploadFile.Checked;
			bool DocumentEdit = this.DocumentEdit.Checked;
			bool UserAdd = this.UserAdd.Checked;
			bool UserDelete = this.UserDelete.Checked;
			bool UserUpdate = this.UserUpdate.Checked;
			bool UserUpdateGroup = this.UserUpdateGroup.Checked;
			bool UserCenterUpdate = this.UserCenterUpdate.Checked;
			bool UserGroupSelect = this.UserGroupSelect.Checked;
			bool UserGroupAdd = this.UserGroupAdd.Checked;
			bool UserGroupDelete = this.UserGroupDelete.Checked;
			bool UserGroupUpdate = this.UserGroupUpdate.Checked;
			bool CommentSettingUpdate = this.CommentSettingUpdate.Checked;
			bool CommentSelect = this.CommentSelect.Checked;
			bool CommentDelete = this.CommentDelete.Checked;
			bool CommentCheck = this.CommentCheck.Checked;
			bool FeedBackSettingUpdate = this.FeedBackSettingUpdate.Checked;
			bool FeedBackSelect = this.FeedBackSelect.Checked;
			bool FeedBackDelete = this.FeedBackDelete.Checked;
			bool FeedBackCheck = this.FeedBackCheck.Checked;
			bool CollectRuleSelect = this.CollectRuleSelect.Checked;
			bool CollectRuleAdd = this.CollectRuleAdd.Checked;
			bool CollectRuleDelete = this.CollectRuleDelete.Checked;
			bool CollectRuleUpdate = this.CollectRuleUpdate.Checked;
			bool CollectRuleExec = this.CollectRuleExec.Checked;
			bool MailSetting = this.MailSetting.Checked;
			
			if(Title != ""){
				Regex reg = new Regex("^[\u4e00-\u9fa5a-zA-Z0-9]+$");
				if (reg.IsMatch(Title)){///判断是否为汉字/字母/数字的组合
					///操作权限检测
					if( hasRightTo("UserGroupUpdate","修改用户组") ){
						///创建数据连接对象：
						MysqlHelp mh = new MysqlHelp();
						mh.Runsql("Update Group4DeepSoon Set Title='"+Title+"',PreferenceUpdate="+PreferenceUpdate+",LinksSelect="+LinksSelect+",LinksAdd="+LinksAdd +",LinksDelete="+LinksDelete +",LinksUpdate="+LinksUpdate +",LinksCanVisit="+LinksCanVisit +",LogSelect="+LogSelect +",LogDelete="+LogDelete +",ThemeUpdate="+ThemeUpdate +",ThemeDelete="+ThemeDelete +",ClassTreeSelect="+ClassTreeSelect +",ClassTreeAdd="+ClassTreeAdd +",ClassTreeDelete="+ClassTreeDelete +",ClassTreeUpdate="+ClassTreeUpdate +",ArticleSelect="+ArticleSelect +",ArticleAdd="+ArticleAdd +",ArticleDelete="+ArticleDelete +",ArticleUpdate="+ArticleUpdate +",ArticleCheck="+ArticleCheck +",ArticleSetIndexPic="+ArticleSetIndexPic +",ArticleHeadTitle="+ArticleHeadTitle +",ArticleRecycle="+ArticleRecycle +",ArticleUploadFile="+ArticleUploadFile +",ArticleUploadImg="+ArticleUploadImg +",DocumentSelect="+DocumentSelect +",DocumentAdd="+DocumentAdd +",DocumentDelete="+DocumentDelete +",DocumentUpdate="+DocumentUpdate +",DocumentUploadFile="+DocumentUploadFile +",DocumentEdit="+DocumentEdit +",UserAdd="+UserAdd +",UserDelete="+UserDelete +",UserUpdate="+UserUpdate +",UserUpdateGroup="+UserUpdateGroup +",UserCenterUpdate="+UserCenterUpdate +",UserGroupSelect="+UserGroupSelect +",UserGroupAdd="+UserGroupAdd +",UserGroupDelete="+UserGroupDelete +",UserGroupUpdate="+UserGroupUpdate +",CommentSettingUpdate="+CommentSettingUpdate +",CommentSelect="+CommentSelect +",CommentDelete="+CommentDelete +",CommentCheck="+CommentCheck +",FeedBackSettingUpdate="+FeedBackSettingUpdate +",FeedBackSelect="+FeedBackSelect +",FeedBackDelete="+FeedBackDelete +",FeedBackCheck="+FeedBackCheck +",CollectRuleSelect="+CollectRuleSelect +",CollectRuleAdd="+CollectRuleAdd +",CollectRuleDelete="+CollectRuleDelete +",CollectRuleUpdate="+CollectRuleUpdate +",CollectRuleExec="+CollectRuleExec +",MailSetting="+MailSetting+" Where ID="+ID);
						labelUpdateInfor.Text = "用户组已已更新";
						Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','用户组信息已更新!','OK')</script>");
					}
					else{
						Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning')</script>");
					}
				}
				else{
					labelUpdateInfor.Text = "用户组名称只可以是汉字/字母/数字的组合!";
					Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','用户组名称只可以是汉字/字母/数字的组合!','Error')</script>");
				}
			}
			else{
				labelUpdateInfor.Text = "用户组名称不能为空!";
				Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','用户组名称不能为空!','Error')</script>");
			}
		}

	}//end class
	//End GroupUpdate Class

}