﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.IO;

using Security;
namespace Security
{
	/* 
	类名: uploadFile 
	功能：文章的文件上传类
	作者：书红
	*/
	//Start uploadFile Class
	public partial class uploadFile : PageBase
	{
		protected void Page_Load(object sender, EventArgs e){ 
			
		}

		protected void btnUploadFile_Click(object sender, EventArgs e)
		{
			if (fileUpload.HasFile)
			{
				///创建数据连接对象：
				MysqlHelp mh = new MysqlHelp();
				///查询数据库
				DataTable dt=new DataTable();
				dt = mh.GetDatabysql("Select * From Preference4DeepSoon");
				string uploadFileDir = "/UploadFile/";
				if(dt.Rows.Count > 0 ){
					uploadFileDir = dt.Rows[0]["uploadFileDir"].ToString();
				}
			
				string fileContentType = this.fileUpload.PostedFile.ContentType;
				///文件格式检测
				if (fileContentType == "text/plain" || fileContentType == "application/x-zip-compressed" || fileContentType == "application/octet-stream" || fileContentType == "application/vnd.ms-excel"  || fileContentType == "application/x-xls" || fileContentType == "text/xml" || fileContentType == "application/msword" || fileContentType == "image/bmp" || fileContentType == "image/bmp" || fileContentType == "image/gif" || fileContentType == "image/jpeg"|| fileContentType == "image/pjpeg")
				{
					///文件大小检测
					if (this.fileUpload.PostedFile.ContentLength > 2048000)
					{ 
						Response.Write("<script language='JavaScript'>alert('上传文件大小不能超过2048K');</script>"); 
					}
					else{
						string folderName = DateTime.Now.ToString("yyyyMM")+"/";
						string saveDir = uploadFileDir + folderName;
						string TimePath = Server.MapPath(saveDir).ToString();//获取上传路径的物理地址 
						if (!Directory.Exists(TimePath))//判断文件夹是否存在 
						{ 
							Directory.CreateDirectory(TimePath);//不存在则创建文件夹 
						}
					
						string name = fileUpload.PostedFile.FileName;  /// 客户端上传文件路径
						FileInfo file = new FileInfo(name);
						string FileType = file.Name.Substring(file.Name.LastIndexOf("."));                   ///文件后缀名   
						string fileName = DateTime.Now.ToString("yyyyMMddhhmmssms")+FileType;                /// 上传的文件名称
						string webFilePath = Server.MapPath(uploadFileDir + folderName + fileName);        /// 服务器端文件路径
						if (!File.Exists(webFilePath))
						{
							try
							{
								///操作权限检测
								if( hasRightTo("ArticleUploadFile","上传附件") ){
									fileUpload.SaveAs(webFilePath);       /// 保存原始文件
									Response.Write("<script type='text/javascript'>");
									Response.Write("window.parent.document.getElementById('fileHref').value = '" + uploadFileDir + folderName + fileName+"';");
									Response.Write("window.parent.document.getElementById('attachmentFile').value += '" + uploadFileDir + folderName + fileName+"|';");
									Response.Write("</script>");
								}
								else{
									Response.Write("<script language='JavaScript'>alert('您所在的用户组无权进行本操作!');history.go(-1);</script>");
								}
							}catch (Exception ex){}
						}
					}
				}
				else{
					Response.Write("<script type='text/javascript'>alert('您上传的文件格式不被允许！');</script>");
				}
				
			}

		}
		
	}
	//End uploadFile Class

	
	/* 
	类名: uploadImg 
	功能：文章的图片上传类
	作者：书红
	*/
	//Start uploadImg Class
	public partial class uploadImg : PageBase
	{
		protected void Page_Load(object sender, EventArgs e){ }

		string addIcon = "false";
		
		protected void btnUploadImg_Click(object sender, EventArgs e)
		{
			if (this.fileUpload.HasFile)
			{
				///创建数据连接对象：
				MysqlHelp mh = new MysqlHelp();
				///查询数据库
				DataTable dt=new DataTable();
				dt = mh.GetDatabysql("Select * From Preference4DeepSoon");
				string uploadFileDir = "/UploadFile/";
				string WatermarkLogo = "/System_Img/WatermarkLogo.png";
				
				if(dt.Rows.Count > 0 ){
					uploadFileDir = dt.Rows[0]["uploadFileDir"].ToString();
					WatermarkLogo = dt.Rows[0]["WatermarkLogo"].ToString();
					addIcon = dt.Rows[0]["addIcon"].ToString();
				}
				
				string fileContentType = this.fileUpload.PostedFile.ContentType;
				///文件格式检测
				if (fileContentType == "image/png" || fileContentType == "image/gif" || fileContentType == "image/bmp" || fileContentType == "image/jpeg"|| fileContentType == "image/pjpeg")
				{
					///文件大小检测
					if (this.fileUpload.PostedFile.ContentLength > 2048000)
					{ 
						Response.Write("<script language='JavaScript'>alert('上传文件大小不能超过2048K');</script>"); 
					}
					else{
						string folderName = DateTime.Now.ToString("yyyyMM")+"/";
						string saveDir = uploadFileDir + folderName;
						string TimePath = Server.MapPath(saveDir).ToString();//获取上传路径的物理地址 
						if (!Directory.Exists(TimePath))//判断文件夹是否存在 
						{ 
							Directory.CreateDirectory(TimePath);//不存在则创建文件夹 
						}
					
						string name = this.fileUpload.PostedFile.FileName;  /// 客户端上传文件路径
						FileInfo file = new FileInfo(name);
						string FileType = file.Name.Substring(file.Name.LastIndexOf("."));                   ///文件后缀名   
						string fileName = "old_"+DateTime.Now.ToString("yyyyMMddhhmmssms")+FileType;                /// 上传的文件名称
						string fileName_syp = DateTime.Now.ToString("yyyyMMddhhmmssms")+FileType;   /// 加水印图片（图片）名称
						string webFilePath = Server.MapPath(uploadFileDir + folderName + fileName);        /// 服务器端文件路径
						string webFilePath_syp = Server.MapPath(uploadFileDir + folderName + fileName_syp);  /// 服务器端带水印（图片）路径
						string webFilePath_sypf = Server.MapPath(WatermarkLogo);  /// 当做水印的图片
					
						if (!File.Exists(webFilePath))
						{
							try
							{
								///操作权限检测
								if( hasRightTo("ArticleUploadImg","上传图片附件") ){
									this.fileUpload.SaveAs(webFilePath);       /// 暂时保存原始文件
									AddWatermarkPic(webFilePath, webFilePath_syp, webFilePath_sypf); ///给原始图片加图片水印并保存至服务器
									//System.Drawing.Image image = System.Drawing.Image.FromFile(webFilePath_syp);
									Response.Write("<script type='text/javascript'>");
									Response.Write("window.parent.document.getElementById('imgHref').value = '" + uploadFileDir + folderName + fileName_syp+"';");
									Response.Write("window.parent.document.getElementById('preImg').src = '" + uploadFileDir + folderName + fileName_syp+"';");
									//Response.Write("window.parent.document.getElementById('imgWidthOld').value = '" + image.Width +"';");
									//Response.Write("window.parent.document.getElementById('imgHeightOld').value = '" + image.Height +"';");
									//Response.Write("window.parent.document.getElementById('imgWidth').value = '" + image.Width +"';");
									//Response.Write("window.parent.document.getElementById('imgHeight').value = '" + image.Height +"';");
									Response.Write("window.parent.document.getElementById('attachmentFile').value += '" + uploadFileDir + folderName + fileName_syp+"|';");
									Response.Write("</script>");
									//image.Dispose();
									File.Delete(MapPath(uploadFileDir + folderName + fileName));  ///立即删除原始图片
								}
								else{
									Response.Write("<script language='JavaScript'>alert('您所在的用户组无权进行本操作!');history.go(-1);</script>");
								}	
							
			
							}catch (Exception ex){}
						}
					}
					
				}
				else{
					Response.Write("<script type='text/javascript'>alert('您上传的文件格式不被允许！');</script>");
				}
			}

		}

		/// 加图片水印
		protected void AddWatermarkPic(string Path, string Path_syp, string Path_sypf)
		{
			System.Drawing.Image image = System.Drawing.Image.FromFile(Path);
			System.Drawing.Image copyImage = System.Drawing.Image.FromFile(Path_sypf);
			if(addIcon!="False"){
				System.Drawing.Graphics g = System.Drawing.Graphics.FromImage(image);
				g.DrawImage(copyImage, new System.Drawing.Rectangle(image.Width - copyImage.Width, image.Height - copyImage.Height, copyImage.Width, copyImage.Height), 0, 0, copyImage.Width, copyImage.Height, System.Drawing.GraphicsUnit.Pixel);
				g.Dispose();			
			}
			image.Save(Path_syp);
			image.Dispose();
		}
		
	}
	//End uploadImg Class
	
}