﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.IO;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using MySql.Data.MySqlClient;

using Security;
namespace Security
{
    public partial class DeepSoonTheme : PageBase
    {
		protected void Page_Load(object sender, EventArgs e)
        {
			///创建数据连接对象：
			MysqlHelp mh = new MysqlHelp();
				
			string themeNameReq = Request.QueryString["themeName"];
			
			DeepSoonHelp dh = new DeepSoonHelp();
			if( themeNameReq != null && dh.notHasSQLInsertCode(themeNameReq) ){
				///操作权限检测
				if( hasRightTo("ThemeUpdate","切换主题风格") ){
					mh.Runsql("Update Theme4DeepSoon Set ThemeName='"+themeNameReq+"'");
					Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','网站主题风格已切换!','OK')</script>");
				}
				else{
					Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning')</script>");
				}				
			}
			
			///卸载主题包
			string delThemeReq = Request.QueryString["delThemeName"];
			string delThemePath = Server.MapPath("../../Theme/"+delThemeReq).ToString(); 
			if(delThemeReq != null){
				if (Directory.Exists(delThemePath))//判断文件夹是否存在 
				{ 
					///操作权限检测
					if( hasRightTo("ThemeDelete","卸载主题") ){
						Directory.Delete(delThemePath,true);
						Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','主题风格已卸载!','OK')</script>");
					}
					else{
						Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning')</script>");
					}
				}
			}	
			
			if (!IsPostBack) 
			{ 
				DataTable dt=new DataTable();
				dt = mh.GetDatabysql("Select * From Theme4DeepSoon");
				string currThemeName = "";
				if (dt.Rows.Count>0){
					currThemeName = dt.Rows[0]["ThemeName"].ToString();
				}
				else{
					mh.Runsql("insert into Theme4DeepSoon(ThemeName) Values('Default')");
					currThemeName = "Default";
				}
				
				System.IO.DirectoryInfo dirInfo = new System.IO.DirectoryInfo(Server.MapPath("../../Theme"));
				System.IO.DirectoryInfo []dirs = dirInfo.GetDirectories();
				string themeStr = "";
				string themeName = "";
				for(int i=0;i<dirs.Length;i++){
					themeName = dirs[i].Name.ToString();
					
					themeStr += "<div class='themeBox'  title='主题包:"+themeName+"'>";
					themeStr += "<img src='../../Theme/"+themeName+"/screenshot.png' class='themeImg'>";
					themeStr += "<div class='themeBanner'>";
					if(currThemeName != themeName){
						themeStr += "<div class='themeTool'>";
						themeStr += "<a href='Theme.aspx?themeName="+themeName+"'>使用该皮肤</a> | ";
						if(themeName != "Default"){
							themeStr += "<a href='Theme.aspx?delThemeName="+themeName+"' OnClick='if (!confirm(\"卸载后主题包无法恢复，是否确认卸载？\")) return false;'>卸载</a>";
						}
						else{
							themeStr += "<font color='#CCCCCC'>卸载</font>";
						}
						themeStr += "</div>";
					}
					else {
						themeStr += "<div class='themeTool'>";
						themeStr += "<img src='../images/selectTag.png'> 使用中 | ";
						themeStr += "<a href='../../Publish/index.aspx' target='_blank'>";
							themeStr += "<img src='../images/viewTag.png'> <font color=#000000>预览</font>";
						themeStr += "</a>";
						themeStr += "</div>";
					}
					themeStr += "</div>";
					themeStr += "</div>";
				}
				this.labelTheme.Text = themeStr;
			}///end if isPostBack
			
        }

    }
}