﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using MySql.Data.MySqlClient;
using System.Web.Configuration;

using Security;
namespace Security
{
	/* 
	类名: Log 
	功能：日志管理类
	作者：书红
	*/
	//Start Log Class
	public partial class Log : PageBase
    {
		protected void Page_Load(object sender, EventArgs e)
        {
			if (!IsPostBack) 
			{ 
				///操作权限检测
				if( hasRightTo("LogSelect","查看系统操作日志") ){
					GridviewBind();
				}
				else{
					Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning')</script>");
				}
			}
			btnDelAll.Attributes.Add("onclick","return confirm(\"删除后数据无法恢复，是否确认删除？\")") ;
			btnTruAll.Attributes.Add("onclick","return confirm(\"清空后数据无法恢复，是否确认清空？\")") ;
			///myGridView.Attributes.Add("style","table-layout:fixed");
        }
		
		protected void GridviewBind() 
		{ 
			///创建数据连接对象：
			MysqlHelp mh = new MysqlHelp();
			///查询并显示数据：
			DataTable dt=new DataTable();
			dt = mh.GetDatabysql("Select * From Log4DeepSoon Order By ID DESC");
			myGridView.DataSource = dt;        
			myGridView.DataBind();
		}
	
		protected void myGridView_PageIndexChanging(object sender, GridViewPageEventArgs e)
		{
			myGridView.PageIndex = e.NewPageIndex;
			GridviewBind();//重新执行自定义的GridView数据绑定函数
			((TextBox)myGridView.BottomPagerRow.FindControl("txtGoPage")).Text = ""+(myGridView.PageIndex+1);
		}

		protected void myGridView_RowDeleting(object sender, GridViewDeleteEventArgs e) 
		{ 
			int deleteID = Convert.ToInt32(myGridView.DataKeys[e.RowIndex].Value);//获取主键
		
			///创建数据连接对象：
			MysqlHelp mh = new MysqlHelp();
			MySqlParameter[] updateParms ={new MySqlParameter("?ID",MySqlDbType.VarChar,4)};
			updateParms[0].Value = ""+deleteID;
			///操作权限检测
			if( hasRightTo("LogDelete","删除系统操作日志") ){
				mh.Runsql("Delete From Log4DeepSoon Where ID=?ID", updateParms);
				GridviewBind();
				Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','系统操作日志已删除!','OK')</script>");
			}
			else{
				Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning')</script>");
			}
		} 
		
		protected void myGridView_RowDataBound(object sender, GridViewRowEventArgs e)
		{
			if (e.Row.RowType == DataControlRowType.DataRow)
			{
				//当鼠标在某一行上方时激发
				e.Row.Attributes.Add("onmouseover", "curColor=this.style.backgroundColor;this.style.backgroundColor='#F0F0F0'");
				//当鼠标从某一行上方移开时激发
				e.Row.Attributes.Add("onmouseout", "this.style.backgroundColor=curColor");
			}
			if (e.Row.RowType == DataControlRowType.DataRow)  
			{  
				//设置申请原因字符串显示长度   
				string strIP = e.Row.Cells[4].Text.Trim();
				string getAddrStr = "<script src='http://int.dpool.sina.com.cn/iplookup/iplookup.php?format=js&ip="+strIP+"' type='text/ecmascript'></script>";
				getAddrStr += "<script type='text/javascript'>document.write(remote_ip_info ['province'] + '省' + '' + remote_ip_info ['city'] + '市');</script>";
				e.Row.Cells[5].Text = getAddrStr;
			}
		}
		
		protected void btnDelAll_Click(object sender, EventArgs e) 
		{ 
			string sqlText = "("; 
			int countNum = 0;//统计用户选取的记录数目
			for (int i = 0; i < myGridView.Rows.Count; i++) 
			{ 
				//搜索第n行3列 
				CheckBox cbx = (CheckBox)myGridView.Rows[i].FindControl("cbxId"); 
				if (cbx.Checked == true) 
				{ 
					sqlText = sqlText + Convert.ToInt32(myGridView.DataKeys[i].Value) + ",";
					countNum ++;
				} 
			} 
			//去掉最后的逗号，并且加上右括号 
			sqlText = sqlText.Substring(0,sqlText.Length - 1) + ")"; 
			if(countNum>0){///如果选择不为空
				sqlText = "Delete From Log4DeepSoon Where ID In" + sqlText; 
				MysqlHelp mh = new MysqlHelp();
				///操作权限检测
				if( hasRightTo("LogDelete","批量删除系统操作日志") ){
					mh.Runsql(sqlText);
					Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','系统操作日志已删除!','OK')</script>");
				}
				else{
					Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning')</script>");
				} 
			}
			GridviewBind(); 
		}
		
		
		
		
		protected void btnTruAll_Click(object sender, EventArgs e)
		{
			///操作权限检测
			if( hasRightTo("LogDelete","清空操作日志") ){
				MysqlHelp mh = new MysqlHelp();
				mh.Runsql("Truncate Table Log4DeepSoon");
				///Response.Redirect("ArticleTree.aspx");
				Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','已清空日志!','OK')</script>");
			}
			else{
				Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning')</script>");
			}
			
		}
		
		
		
		
		protected void btnSelAll_Click(object sender, EventArgs e) 
		{ 
			for (int i = 0; i < myGridView.Rows.Count; i++) 
			{ 
				//搜索第n行3列 
				CheckBox cbx = (CheckBox)myGridView.Rows[i].FindControl("cbxId"); 
				cbx.Checked = true;
			}
		}
		
		protected void btnUnSelAll_Click(object sender, EventArgs e) 
		{ 
			for (int i = 0; i < myGridView.Rows.Count; i++) 
			{ 
				//搜索第n行3列 
				CheckBox cbx = (CheckBox)myGridView.Rows[i].FindControl("cbxId"); 
				cbx.Checked = false;
			}
		}

		#region 转到触发方法
		protected void btnGo_Click(object sender, EventArgs e)
		{
			if(((TextBox)myGridView.BottomPagerRow.FindControl("txtGoPage")).Text != ""){
				myGridView.PageIndex = int.Parse(((TextBox)myGridView.BottomPagerRow.FindControl("txtGoPage")).Text) - 1;
				GridviewBind();   //重新绑定GridView
				((TextBox)myGridView.BottomPagerRow.FindControl("txtGoPage")).Text = ""+(myGridView.PageIndex+1);
			}
		}
		#endregion
		
    }
	//End Log Class
	
	
	/* 
	类名: DeepSoonPreference 
	功能：网站首选项类
	作者：书红
	*/
	//Start DeepSoonPreference Class
	public partial class Preference : PageBase
    {
		protected void Page_Load(object sender, EventArgs e)
        {
		if(!IsPostBack){
			///创建数据连接对象：
			MysqlHelp mh = new MysqlHelp();
			///查询数据库
			DataTable dt=new DataTable();
			dt = mh.GetDatabysql("Select * From Preference4DeepSoon");
			string siteName = "";
			string siteTitle = "";
			string siteKeywords = "";
			string siteDescribe = "";	
			string siteMain = "";
			string siteLogoAddr = "";
			string urlRule = "";
			string htmlDir = "";
			string uploadFileDir = "";
			string WatermarkLogo = "";
			string siteCopyRight = "";
			if(dt.Rows.Count > 0 ){
				siteName = dt.Rows[0]["siteName"].ToString();
				siteTitle = dt.Rows[0]["siteTitle"].ToString();
				siteKeywords = dt.Rows[0]["siteKeywords"].ToString();
				siteDescribe = dt.Rows[0]["siteDescribe"].ToString();
				siteMain = dt.Rows[0]["siteMain"].ToString();
				siteLogoAddr = dt.Rows[0]["siteLogoAddr"].ToString();
				urlRule = dt.Rows[0]["urlRule"].ToString();
				htmlDir = dt.Rows[0]["htmlDir"].ToString();
				uploadFileDir = dt.Rows[0]["uploadFileDir"].ToString();	
				WatermarkLogo = dt.Rows[0]["WatermarkLogo"].ToString();					
				siteCopyRight = dt.Rows[0]["siteCopyRight"].ToString();	
				this.addIcon.Checked=(bool)dt.Rows[0]["addIcon"];
			}
			else {
				string insertSQLStr = "insert into Preference4DeepSoon(siteName,siteTitle,siteKeywords,siteDescribe,siteMain,siteLogoAddr,htmlDir,uploadFileDir,siteCopyRight,WatermarkLogo,urlRule) Values ('"+siteName+"','"+siteTitle+"','"+siteKeywords+"','"+siteDescribe+"','www.DeepSoon.com','Resources/Images/logo.png','/Html/','/uploadFile/','"+siteTitle+" | 版权所有&bull;侵权必究','/Resources/Images/WatermarkLogo.png','endWithASPX')";
				mh.Runsql(insertSQLStr);
				siteName = "地平线";
				siteTitle = "地平线官网";
				siteKeywords = "地平线，asp.net,门户网，论坛，开源，社区";
				siteDescribe = "地平线门户网是用ASP.Net+MySQL技术开发的一个开源产品，利用该软件您可以轻易的订制自己的博客，新闻系统。";	
				siteMain = "www.DeepSoon.com";
				siteLogoAddr = "System_Img/logo.png";
				urlRule = "endWithASPX";
				htmlDir = "/Html/";
				uploadFileDir = "/uploadFile/";
				WatermarkLogo = "/System_Img/WatermarkLogo.png";
				siteCopyRight = "地平线官网 | 版权所有&bull;侵权必究";
			}
			switch (urlRule)
			{
			case "endWithASPX":
				this.urlRuleList.SelectedIndex = 0;
				break;
			case "endWithHTML":
				this.urlRuleList.SelectedIndex = 1;
				break;
			case "noPostfix":
				this.urlRuleList.SelectedIndex = 2;
				break;
			case "activeArgs":
				this.urlRuleList.SelectedIndex = 3;
				break;
			default:
				this.urlRuleList.SelectedIndex = 0;
				break;
			}

			this.siteName.Text = siteName;
			this.siteTitle.Text = siteTitle;
			this.siteKeywords.Text = siteKeywords;
			this.siteDescribe.Text = siteDescribe;
			this.siteMain.Text = siteMain;
			this.siteLogoAddr.Text = siteLogoAddr;
			this.htmlDir.Text = htmlDir;
			this.uploadFileDir.Text = uploadFileDir;
			this.WatermarkLogo.Text = WatermarkLogo;
			this.siteCopyRight.Text = siteCopyRight;
		}
        }
		
		/// 获取客户端IP
		public static string getClientIP(){
			string result = HttpContext.Current.Request.ServerVariables["HTTP_X_FORWARDED_FOR"];
			if (null == result || result == String.Empty){
				result = HttpContext.Current.Request.ServerVariables["REMOTE_ADDR"];
			} 
			if (null == result || result == String.Empty){
				result = HttpContext.Current.Request.UserHostAddress; 
			} 
			return result;
		}
		
		protected void btnUpdate_Click(object sender, EventArgs e)
        {
			///获取用户输入的新的数据：
			string siteNameUpdate = this.siteName.Text.Replace("'", "");
			if(siteNameUpdate.Length>250)siteNameUpdate = siteNameUpdate.Substring(0,250);
			
			string siteTitleUpdate = this.siteTitle.Text.Replace("'", "");
			if(siteTitleUpdate.Length>250)siteTitleUpdate = siteTitleUpdate.Substring(0,250);
			
			string siteKeywordsUpdate = this.siteKeywords.Text.Replace("'", "");
			if(siteKeywordsUpdate.Length>250)siteKeywordsUpdate = siteKeywordsUpdate.Substring(0,250);
			
			string siteDescribeUpdate = this.siteDescribe.Text.Replace("'", "");
			if(siteDescribeUpdate.Length>250)siteDescribeUpdate = siteDescribeUpdate.Substring(0,200);
			
			string siteMainUpdate = this.siteMain.Text.Replace("'", "");
			if(siteMainUpdate.Length>250)siteMainUpdate = siteMainUpdate.Substring(0,250);
			
			string siteLogoAddrUpdate = this.siteLogoAddr.Text.Replace("'", "");
			if(siteLogoAddrUpdate.Length>250)siteLogoAddrUpdate = siteLogoAddrUpdate.Substring(0,250);
			
			string htmlDirUpdate = this.htmlDir.Text.Replace("'", "");
			
			string uploadFileDirUpdate = this.uploadFileDir.Text.Replace("'", "");
			
			string watermarkLogoUpdate = this.WatermarkLogo.Text.Replace("'", "");
			
			string siteCopyRight = this.siteCopyRight.Text.Replace("'", "");
			if(siteCopyRight.Length>1000)siteCopyRight = siteCopyRight.Substring(0,1000);
			
			string urlRuleUpdate = this.urlRuleList.SelectedItem.Value;
			
			bool addIcon = this.addIcon.Checked;
			
			if(siteNameUpdate!="" && siteTitleUpdate!="" && siteKeywordsUpdate!="" && siteDescribeUpdate!="" && siteMainUpdate!="" && siteLogoAddrUpdate!="" &&htmlDirUpdate!="" && uploadFileDirUpdate!="" && watermarkLogoUpdate!="" && siteCopyRight!="")///如果用户输入的参数没有空项
			{
				MySqlParameter[] updateParms ={
				new MySqlParameter("?siteName",MySqlDbType.VarChar,250),
				new MySqlParameter("?siteTitle",MySqlDbType.VarChar,250),
				new MySqlParameter("?siteKeywords",MySqlDbType.VarChar,250),
				new MySqlParameter("?siteDescribe",MySqlDbType.VarChar,250),
				new MySqlParameter("?siteMain",MySqlDbType.VarChar,250),
				new MySqlParameter("?siteLogoAddr",MySqlDbType.VarChar,250),
				new MySqlParameter("?htmlDir",MySqlDbType.VarChar,250),
				new MySqlParameter("?uploadFileDir",MySqlDbType.VarChar,250),
				new MySqlParameter("?watermarkLogo",MySqlDbType.VarChar,250),
				new MySqlParameter("?siteCopyRight",MySqlDbType.VarChar,250),
				new MySqlParameter("?urlRule",MySqlDbType.VarChar,250),
				new MySqlParameter("?addIcon",MySqlDbType.Bit,1)
				};
				updateParms[0].Value = ""+siteNameUpdate;
				updateParms[1].Value = ""+siteTitleUpdate;
				updateParms[2].Value = ""+siteKeywordsUpdate;
				updateParms[3].Value = ""+siteDescribeUpdate;
				updateParms[4].Value = ""+siteMainUpdate;
				updateParms[5].Value = ""+siteLogoAddrUpdate;
				updateParms[6].Value = ""+htmlDirUpdate;
				updateParms[7].Value = ""+uploadFileDirUpdate;
				updateParms[8].Value = ""+watermarkLogoUpdate;
				updateParms[9].Value = ""+siteCopyRight;
				updateParms[10].Value = ""+urlRuleUpdate;
				updateParms[11].Value = addIcon;
			
				///创建数据连接对象：
				MysqlHelp mh = new MysqlHelp();
				///修改参数：
				if( hasRightTo("PreferenceUpdate","文章首选项更新") ){
					mh.Runsql("Update Preference4DeepSoon Set siteName=?siteName,siteTitle=?siteTitle,siteKeywords=?siteKeywords,siteDescribe=?siteDescribe,siteMain=?siteMain,siteLogoAddr=?siteLogoAddr,htmlDir=?htmlDir,uploadFileDir=?uploadFileDir,WatermarkLogo=?watermarkLogo,siteCopyRight=?siteCopyRight,urlRule=?urlRule,addIcon=?addIcon", updateParms);
					this.labelUpdateInfor.Text="网站首选项配置参数已经更新!";
					Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','网站首选项已更新!','OK')</script>");
				}
				else{
					Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning')</script>");
				}					
			}
			else {
				this.labelUpdateInfor.Text="所有项不允许为空,请将配置参数填写完整!";
				Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','所有项不允许为空,请将配置参数填写完整!','Error')</script>");
			}
		}
	}
	//End DeepSoonPreference Class
	
}