﻿using System;
using System.Text;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Security.Cryptography;
using MySql.Data.MySqlClient;
using System.Drawing;
using System.Drawing.Imaging;


using Security;
namespace Security
{
	
	/* 
	类名: login 
	功能：账户登陆类
	作者：书红
	*/
	//Start login Class
	public partial class login : ValidateBase
    {
        protected void Page_Load(object sender, EventArgs e)
        {
			if(!IsPostBack){
				if (base.strUser != ""){
					this.labelInfor.Text = "您已用账户"+base.strUser+"登陆，<a href='index.aspx'>直接进入后台</a><br>或者更换一个登录账户:";
					this.txtLoginName.Text = base.strUser;
				}
			}
        }
		
        protected void btnLogin_Click(object sender, EventArgs e)
        {
			///获取用户输入的验证码：
			String txtVailValue = this.txtVail.Text.ToUpper().Replace("'", "");
			if(txtVailValue.Length>4)txtVailValue = this.txtVail.Text.Substring(0,4);
			///获取用户输入的账户名：
			String txtLoginNameValue = this.txtLoginName.Text.Replace("'", "");
			if(txtLoginNameValue.Length>20)txtLoginNameValue = this.txtLoginName.Text.Substring(0,20);
			///获取用户输入的保密码：
			String txtLoginPWDValue = this.txtLoginPWD.Text.Replace("'", "");
			if(txtLoginPWDValue.Length>16)txtLoginPWDValue = this.txtLoginPWD.Text.Substring(0,16);
			
			//创建函数库：
			DeepSoonHelp dh = new DeepSoonHelp();
			///检验是否有sql注入敏感字符
			if(dh.notHasSQLInsertCode(txtLoginNameValue) && dh.notHasSQLInsertCode(txtLoginPWDValue)){
				if ( txtVailValue== base.strValidate)///如果用户输入的验证码和系统自生成的验证码相同
				{
					///利用MD5进行加密：
					string MD5PWD=System.Web.Security.FormsAuthentication.HashPasswordForStoringInConfigFile(txtLoginPWDValue,"MD5");
			
					///创建数据连接对象：
					MysqlHelp mh = new MysqlHelp();
					///查询数据库
					DataTable dt=new DataTable();
					MySqlParameter[] quryParms  = {new MySqlParameter("?Name",MySqlDbType.VarChar,20),new MySqlParameter("?PWD",MySqlDbType.VarChar,20)};
					quryParms[0].Value = ""+txtLoginNameValue;
					quryParms[1].Value = ""+MD5PWD;
					dt = mh.GetDatabysql("Select * From Users4DeepSoon Where Name=?Name and PWD=?PWD and Class='super' ",quryParms);
				
					///如果数据库查询到了记录，则成功登陆
					if (dt.Rows.Count>0){
						///保存用户登录名和MD5密码串，并写入cookie
						HttpCookie userCookie = new HttpCookie("strUser4Deepsoon");
						userCookie.Value = HttpUtility.UrlEncode(HttpUtility.UrlEncode(txtLoginNameValue, Encoding.GetEncoding("UTF-8"))); 
						userCookie.Expires = DateTime.Now.AddDays(7); 
						Response.Cookies.Add(userCookie);
						HttpCookie pwdCookie = new HttpCookie("strPwd4Deepsoon");
						pwdCookie.Value = HttpUtility.UrlEncode(HttpUtility.UrlEncode(MD5PWD, Encoding.GetEncoding("UTF-8"))); 
						pwdCookie.Expires = DateTime.Now.AddDays(7); 
						Response.Cookies.Add(pwdCookie);
						
						///管理日志：登录
						MySqlParameter[] logParms ={new MySqlParameter("?Name",MySqlDbType.VarChar,20),
						new MySqlParameter("?EventStr",MySqlDbType.VarChar,40),
						new MySqlParameter("?IPStr",MySqlDbType.VarChar,20)};
						logParms[0].Value = txtLoginNameValue;
						logParms[1].Value = "登录系统";
						logParms[2].Value = ""+getClientIP();
						mh.Runsql("Insert Into Log4DeepSoon(Name,EventStr,IPStr) Values (?Name,?EventStr,?IPStr)", logParms);
						
						///登录成功，跳转到管理首页
						Response.Redirect("Index.aspx");
					}
					else {
						base.strUser = "";
						this.labelInfor.Text = "错误:<br>您输入的用户名或密码不对!";
					}
				}
				else
				{
					///base.strUser = "";
					this.labelInfor.Text = "错误:<br>您输入的验证不对!";
				}	
			
			}///end if(notHasSqlInsert(txtLoginNameValue)
			else{
				base.strUser = "";
                this.labelInfor.Text = "本站禁止SQL注入!";
			}	
			
        }
    }
	//End login Class
	
	
	/* 
	类名: unLogin 
	功能：账户退出类
	作者：书红
	*/
	//Start unLogin Class
	 public partial class unLogin : System.Web.UI.Page
    {
		protected void Page_Load(object sender, EventArgs e)
        {
			HttpCookie userNameCookie = Request.Cookies["strUser4Deepsoon"];
　　　　	if (userNameCookie != null)
　　　　	{
　　　　　　	TimeSpan userNameTs = new TimeSpan(-1, 0, 0, 0);
				userNameCookie.Expires = DateTime.Now.Add(userNameTs);
　　　　　　	Response.AppendCookie(userNameCookie);
　　　　	}
			HttpCookie userPwdCookie = Request.Cookies["strPwd4Deepsoon"];
　　　　	if (userPwdCookie != null)
　　　　	{
　　　　　　	TimeSpan userPwdTs = new TimeSpan(-1, 0, 0, 0);
				userPwdCookie.Expires = DateTime.Now.Add(userPwdTs);
　　　　　　	Response.AppendCookie(userPwdCookie);
　　　　	}

        }
		
    }
	//End unLogin Class
	
	
	/* 
	类名: ValidateCode 
	功能：生成验证码类
	作者：书红
	*/
	//Start ValidateCode Class
	public partial class ValidateCode : ValidateBase
    {
        /// 验证码长度
        private int codeLen = 4;
        /// 图片清晰度
        private int fineness = 85;
        // 图片宽度
        private int imgWidth = 80;
        // 图片高度
        private int imgHeight = 24;
        // 字体家族名称
        private string fontFamily = "微软雅黑";
        // 字体大小
        private int fontSize = 14;
        // 字体样式
        private int fontStyle = 0;
        // 绘制起始坐标 X
        private int posX = 6;
        // 绘制起始坐标 Y
        private int posY = 0;
        protected void Page_Load(object sender, EventArgs e)
        {
			string validateCode = CreateValidateCode();//生成验证码
            Bitmap bitmap = new Bitmap(imgWidth, imgHeight);// 生成BITMAP图像
            DisturbBitmap(bitmap);// 图像背景
            DrawValidateCode(bitmap, validateCode);// 绘制验证码图像
            bitmap.Save(Response.OutputStream,ImageFormat.Gif);// 保存验证码图像，等待输出
        }
        
		/// 生成验证码
        /// <returns></returns>
        private string CreateValidateCode()
        {
            string validateCode = "";
            Random random = new Random();// 随机数对象
            for (int i = 0; i < codeLen; i++)
            {
                int n = random.Next(26); // 26: a - z  字符
                validateCode += (char)(n + 65); // 将数字转换成大写字母

                //int n = random.Next(10); //数字
                //validateCode += n.ToString();
            }
            base.strValidate = validateCode;// 保存验证码
            return validateCode;
        }
        
		/// 图像背景
        /// <param name="bitmap"></param>
        private void DisturbBitmap(Bitmap bitmap)
        {
            Random random = new Random();// 通过随机数生成
            for (int i = 0; i < bitmap.Width; i++)
            {
                for (int j = 0; j < bitmap.Height; j++)
                {
                    if (random.Next(90) <= this.fineness)
                        bitmap.SetPixel(i, j, Color.White);
                }
            }
        }
        
		/// 绘制验证码图像,bitmap 图板,validateCode 验证码值
        /// <param name="bitmap"></param>
        /// <param name="validateCode"></param>
        private void DrawValidateCode(Bitmap bitmap, string validateCode)
        {
            Graphics g = Graphics.FromImage(bitmap);// 获取绘制器对象
			Font font = new Font(fontFamily, fontSize, FontStyle.Bold);// 设置绘制字体
			g.DrawString(validateCode, font, Brushes.Red, posX, posY);// 绘制验证码图像
        }
    }
	//End ValidateCode Class
	
	
}