﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using MySql.Data.MySqlClient;
using System.Web.Configuration;

using Security;
namespace Security
{
	/* 
	类名: DeepSoonLinks 
	功能：链接管理类
	作者：书红
	*/
	//Start Links Class
    public partial class Links : PageBase
    {
		protected void Page_Load(object sender, EventArgs e)
        {
			if (!IsPostBack) 
			{ 
				///绘制链接类别下拉列表
				MysqlHelp mh = new MysqlHelp();
				DataTable linkGroupDt = mh.GetDatabysql("Select * From LinkGroup4DeepSoon");
				for(int i = 0 ; i < linkGroupDt.Rows.Count ; i++)
				{
					string linkGroupID = linkGroupDt.Rows[i]["ID"].ToString();
					string linkGroupName = linkGroupDt.Rows[i]["LinkGroupName"].ToString();
					ListItem li=new ListItem(linkGroupName,linkGroupID);
					this.LinkGroupID.Items.Add(li);
				} 
				
				GridviewBind();
			}
			
			btnDelAll.Attributes.Add("onclick","return confirm(\"删除后数据无法恢复，是否确认删除？\")") ;
			
        }
		
		protected void GridviewBind() 
		{ 
			if( hasRightTo("LinksSelect","查看链接列表") ){
				///创建数据连接对象：
				MysqlHelp mh = new MysqlHelp();
				///查询并显示数据：
				DataTable dt=new DataTable();
				dt = mh.GetDatabysql("Select * From Links4DeepSoon Order By ID DESC");
				myGridView.DataSource = dt;        
				myGridView.DataBind();
			}
			else{
				Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning')</script>");
			}	
			
		}
		
		protected void myGridView_PageIndexChanging(object sender, GridViewPageEventArgs e)
		{
			myGridView.PageIndex = e.NewPageIndex;
			GridviewBind();//重新执行自定义的GridView数据绑定函数
			((TextBox)myGridView.BottomPagerRow.FindControl("txtGoPage")).Text = ""+(myGridView.PageIndex+1);
		}

		protected void myGridView_RowDeleting(object sender, GridViewDeleteEventArgs e) 
		{ 
			if( hasRightTo("LinksDelete","删除链接") ){
				int deleteID = Convert.ToInt32(myGridView.DataKeys[e.RowIndex].Value);//获取主键
		
				///创建数据连接对象：
				MysqlHelp mh = new MysqlHelp();
				MySqlParameter[] updateParms ={new MySqlParameter("?ID",MySqlDbType.VarChar,4)};
				updateParms[0].Value = ""+deleteID;
				mh.Runsql("Delete From Links4DeepSoon Where ID=?ID", updateParms);		
				GridviewBind(); 
				Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','链接已删除!','OK')</script>");
			}
			else{
				Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning')</script>");
			}
		} 
		
		protected void myGridView_RowCommand(object sender, GridViewCommandEventArgs e) 
		{ 
			if(e.CommandName == "CanVisit"){
				MysqlHelp mh = new MysqlHelp();
				string linkID = e.CommandArgument.ToString();
				DataTable linkDt = new DataTable();
				linkDt = mh.GetDatabysql("Select canVisit From Links4DeepSoon Where ID="+linkID);
				if(linkDt.Rows.Count>0){
					string canVisit = linkDt.Rows[0]["canVisit"].ToString();
					string canVisitValue = "False";
					if(canVisit == "False")canVisitValue="True";
					else canVisitValue = "False";
					///操作权限检测
					if( hasRightTo("LinksCanVisit","设置链接状态") ){
						mh.Runsql( "Update Links4DeepSoon Set canVisit="+canVisitValue+" Where ID="+linkID );
						Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','链接状态已更新!','OK')</script>");
					}
					else{
						Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning')</script>");
					}
				}
				GridviewBind(); 
			}
		}
		
		protected void myGridView_RowDataBound(object sender, GridViewRowEventArgs e)
		{
			if (e.Row.RowType == DataControlRowType.DataRow)
			{
				//当鼠标在某一行上方时激发
				e.Row.Attributes.Add("onmouseover", "curColor=this.style.backgroundColor;this.style.backgroundColor='#F0F0F0'");
				//当鼠标从某一行上方移开时激发
				e.Row.Attributes.Add("onmouseout", "this.style.backgroundColor=curColor");
			}
			if (e.Row.RowType == DataControlRowType.DataRow)  
			{  
				//设置申请原因字符串显示长度   
				string strLinkID = e.Row.Cells[1].Text.Trim(); 
				string strLinkName = e.Row.Cells[2].Text.Trim(); 				
				string strLinkSrc = e.Row.Cells[3].Text.Trim();
				string strLinkLogo = "";
					   strLinkLogo = e.Row.Cells[4].Text.Trim();
				e.Row.Cells[3].Text = "<a href='"+strLinkSrc+"' target='_blank'>" + strLinkSrc + "</a>";  
				e.Row.Cells[3].ToolTip = strLinkName;//鼠标放上去显示所有
				if(strLinkLogo != "&nbsp;")
					e.Row.Cells[4].Text = "<img src='"+strLinkLogo+"' style='width:120px;height:30px;border:1px solid #CCCCCC;'>"; 
					
				string strLinkGroupID = e.Row.Cells[5].Text.Trim();
				DataTable dt=new DataTable();
				string LinkGroupName = "";
				MysqlHelp mh = new MysqlHelp();
				dt = mh.GetDatabysql("Select LinkGroupName From LinkGroup4DeepSoon Where ID="+strLinkGroupID);
				if(dt.Rows.Count > 0){
					LinkGroupName = dt.Rows[0]["LinkGroupName"].ToString();
				}
				else{
					LinkGroupName = "类别已删除";
				}
				e.Row.Cells[5].Text = LinkGroupName;
				
				e.Row.Cells[7].Text = "<a href='LinksUpdate.aspx?updateID="+strLinkID+"'>修改..</a>";
			}
		}
		
		protected void btnDelAll_Click(object sender, EventArgs e) 
		{ 
			string sqlText = "("; 
			int countNum = 0;//统计用户选取的记录数目
			for (int i = 0; i < myGridView.Rows.Count; i++) 
			{ 
				//搜索第n行3列 
				CheckBox cbx = (CheckBox)myGridView.Rows[i].FindControl("cbxId"); 
				if (cbx.Checked == true) 
				{ 
					sqlText = sqlText + Convert.ToInt32(myGridView.DataKeys[i].Value) + ",";
					countNum ++;
				} 
			} 
			//去掉最后的逗号，并且加上右括号 
			sqlText = sqlText.Substring(0,sqlText.Length - 1) + ")"; 
			if(countNum>0){///如果选择不为空
				sqlText = "Delete From Links4DeepSoon Where ID In" + sqlText; 
				MysqlHelp mh = new MysqlHelp();
				///操作权限检测
				if( hasRightTo("LinksDelete","删除链接") ){
					mh.Runsql(sqlText);
					Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','链接已删除!','OK')</script>");
				}
				else{
					Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning')</script>");
				}	
			}
			GridviewBind(); 
		}
		
		protected void btnSelAll_Click(object sender, EventArgs e) 
		{ 
			for (int i = 0; i < myGridView.Rows.Count; i++) 
			{ 
				//搜索第n行3列 
				CheckBox cbx = (CheckBox)myGridView.Rows[i].FindControl("cbxId"); 
				cbx.Checked = true;
			}
		}
		
		protected void btnUnSelAll_Click(object sender, EventArgs e) 
		{ 
			for (int i = 0; i < myGridView.Rows.Count; i++) 
			{ 
				//搜索第n行3列 
				CheckBox cbx = (CheckBox)myGridView.Rows[i].FindControl("cbxId"); 
				cbx.Checked = false;
			}
		}
		
		public string GetS(string strm)
		{
			if(strm == "False")
				return "屏蔽访问";
			else
				return "正常";
		}

		#region 转到触发方法
		protected void btnGo_Click(object sender, EventArgs e)
		{
			if(((TextBox)myGridView.BottomPagerRow.FindControl("txtGoPage")).Text != ""){
				myGridView.PageIndex = int.Parse(((TextBox)myGridView.BottomPagerRow.FindControl("txtGoPage")).Text) - 1;
				GridviewBind();   //重新绑定GridView
				((TextBox)myGridView.BottomPagerRow.FindControl("txtGoPage")).Text = ""+(myGridView.PageIndex+1);
			}
		}
		#endregion
		protected void btnAdd_Click(object sender, EventArgs e)
        {
			///获取输入的链接名称：
			string txtLinkNameValue = this.txtLinkName.Text.Replace("'", "");
			if(txtLinkNameValue.Length>20)txtLinkNameValue = txtLinkNameValue.Substring(0,20);
			///获取输入的链接地址：
			string txtLinkHrefValue = this.txtLinkHref.Text.Replace("'", "");
			if(txtLinkHrefValue.Length>200)txtLinkHrefValue = txtLinkHrefValue.Substring(0,200);
			///获取输入的链接地址：
			string txtLinkLogoValue = this.txtLinkLogo.Text.Replace("'", "");
			if(txtLinkLogoValue.Length>200)txtLinkLogoValue = txtLinkLogoValue.Substring(0,200);
			string linkGroupID = this.LinkGroupID.SelectedItem.Value;
			
			if (txtLinkNameValue!="" && txtLinkHrefValue!="" && linkGroupID!="" ){//判断用户输入的是否为空用户名和密码,链接类别是否为空
				///创建数据连接对象：
				string Values = "'"+linkGroupID+"',"+"'"+txtLinkNameValue+"','"+txtLinkHrefValue+"','"+txtLinkLogoValue+"'";
				MysqlHelp mh = new MysqlHelp();
				///操作权限检测
				if( hasRightTo("LinksAdd","添加链接") ){
					mh.Runsql("Insert Into Links4DeepSoon(LinkGroupID,LinkName,LinkHref,LinkLogo) Values ("+Values+")");	
					this.labelAddInfor.Text="链接添加成功!";
					GridviewBind();
					Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','链接已添加!','OK')</script>");
				}
				else{
					Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning')</script>");
				}
			}//end 判断是否链接名称和链接地址为空
			else
			{
				this.labelAddInfor.Text="链接名称和地址不允许为空!";
				Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','链接名称和地址不允许为空!','Error')</script>");
			}
		}///end btnAdd_Click()
		
		
	}
	//End Links Class

	/* 
	类名: LinksUpdate 
	功能：链接更新类
	作者：书红
	*/
	//Start LinksUpdate Class
	public partial class LinksUpdate : PageBase
    {
		protected void Page_Load(object sender, EventArgs e)
		{
			if(!IsPostBack)
            {
				string updateID = Request.QueryString["updateID"];
				
				DeepSoonHelp dh = new DeepSoonHelp();
				if(dh.notHasSQLInsertCode(updateID) && updateID != null){			
					///获取数据源
					MysqlHelp mh = new MysqlHelp();
					DataTable dt = new DataTable();
					
					dt = mh.GetDatabysql("Select * From Links4DeepSoon Where ID="+updateID);
					this.txtLinkName.Text = dt.Rows[0]["LinkName"].ToString();
					this.txtLinkHref.Text = dt.Rows[0]["LinkHref"].ToString();
					this.txtLinkLogo.Text = dt.Rows[0]["LinkLogo"].ToString();
					this.txtLinkID.Text = updateID;
					
					///绘制链接类别下拉列表
					DataTable linkGroupDt = mh.GetDatabysql("Select * From LinkGroup4DeepSoon");
					for(int i = 0 ; i < linkGroupDt.Rows.Count ; i++)
					{
						string linkGroupID = linkGroupDt.Rows[i]["ID"].ToString();
						string linkGroupName = linkGroupDt.Rows[i]["LinkGroupName"].ToString();
						ListItem li=new ListItem(linkGroupName,linkGroupID);
						this.LinkGroupID.Items.Add(li);
					} 
				
					ListItem linkTargetItem=this.LinkGroupID.Items.FindByValue(dt.Rows[0]["LinkGroupID"].ToString());
					if(linkTargetItem != null)
					{
						linkTargetItem.Selected = true;
					}
					
				}///end if
            }			
        }
		

		protected void btnUpdate_Click(object sender, EventArgs e)
		{
			///获取更新链接的ID：
			string ID = this.txtLinkID.Text.Replace("'", "");
			///获取输入的链接名称：
			string LinkName = this.txtLinkName.Text.Replace("'", "");
			if(LinkName.Length>20)LinkName = LinkName.Substring(0,20);
			///获取输入的链接地址：
			string LinkHref = this.txtLinkHref.Text.Replace("'", "");
			if(LinkHref.Length>200)LinkHref = LinkHref.Substring(0,200);
			///获取输入的链接地址：
			string LinkLogo = this.txtLinkLogo.Text.Replace("'", "");
			if(LinkLogo.Length>200)LinkLogo = LinkLogo.Substring(0,200);
			string LinkGroupID = this.LinkGroupID.SelectedItem.Value;
			
			if (LinkName!="" && LinkHref!="" && LinkGroupID!="" ){//判断用户输入的是否为空用户名和密码,链接类别是否为空
				if( hasRightTo("LinksUpdate","更新链接") ){
					///创建数据连接对象：
					MysqlHelp mh = new MysqlHelp();
					///修改参数：
					mh.Runsql("Update Links4DeepSoon Set LinkName='"+LinkName+"',LinkHref='"+LinkHref+"',LinkLogo='"+LinkLogo+"',LinkGroupID="+LinkGroupID+" Where ID="+ID);
					this.labelUpdateInfor.Text="链接已经更新!";
					Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','链接信息已更新!','OK')</script>");
					///Response.Redirect("deepSoonTreeUpdate.aspx?updateID="+menuID+"&updateName="+menuName);
				}
				else{
					Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning')</script>");
				}
			}
			else {
				this.labelUpdateInfor.Text="请将必填项填写完整!";
				Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','请将必填项填写完整!','Error')</script>");
			}
			
		}

	}//end class
	//End LinksUpdate Class
	
	
	
	/* 
	类名: LinkGroup 
	功能：链接类别管理类
	作者：书红
	*/
	//Start LinkGroup Class
    public partial class LinkGroup : PageBase
    {
		protected void Page_Load(object sender, EventArgs e)
        {
			if (!IsPostBack) 
			{ 
				GridviewBind();
			}
			
			btnDelAll.Attributes.Add("onclick","return confirm(\"删除后数据无法恢复，是否确认删除？\")") ;
			
        }
		
		protected void GridviewBind() 
		{ 
			if( hasRightTo("LinksSelect","查看链接类别") ){
				///创建数据连接对象：
				MysqlHelp mh = new MysqlHelp();
				///查询并显示数据：
				DataTable dt=new DataTable();
				dt = mh.GetDatabysql("Select * From LinkGroup4DeepSoon Order By ID DESC");
				myGridView.DataSource = dt;        
				myGridView.DataBind();
			}
			else{
				Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning')</script>");
			}	
			
		}
		
		protected void myGridView_PageIndexChanging(object sender, GridViewPageEventArgs e)
		{
			myGridView.PageIndex = e.NewPageIndex;
			GridviewBind();//重新执行自定义的GridView数据绑定函数
			((TextBox)myGridView.BottomPagerRow.FindControl("txtGoPage")).Text = ""+(myGridView.PageIndex+1);
		}

		protected void myGridView_RowDeleting(object sender, GridViewDeleteEventArgs e) 
		{ 
			if( hasRightTo("LinksDelete","删除链接类别") ){
				int deleteID = Convert.ToInt32(myGridView.DataKeys[e.RowIndex].Value);//获取主键
		
				///创建数据连接对象：
				MysqlHelp mh = new MysqlHelp();
				MySqlParameter[] updateParms ={new MySqlParameter("?ID",MySqlDbType.VarChar,4)};
				updateParms[0].Value = ""+deleteID;
				mh.Runsql("Delete From LinkGroup4DeepSoon Where ID=?ID", updateParms);		
				GridviewBind(); 
				Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','链接类别已删除!','OK')</script>");
			}
			else{
				Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning')</script>");
			}
		} 
		
		protected void myGridView_RowCommand(object sender, GridViewCommandEventArgs e) 
		{ 
			
		}
		
		protected void myGridView_RowDataBound(object sender, GridViewRowEventArgs e)
		{
			if (e.Row.RowType == DataControlRowType.DataRow)
			{
				//当鼠标在某一行上方时激发
				e.Row.Attributes.Add("onmouseover", "curColor=this.style.backgroundColor;this.style.backgroundColor='#F0F0F0'");
				//当鼠标从某一行上方移开时激发
				e.Row.Attributes.Add("onmouseout", "this.style.backgroundColor=curColor");
			}
			if (e.Row.RowType == DataControlRowType.DataRow)  
			{  
				//设置申请原因字符串显示长度   
				string strLinkGroupID = e.Row.Cells[1].Text.Trim(); 
				e.Row.Cells[3].Text = "<a href='LinkGroupUpdate.aspx?updateID="+strLinkGroupID+"'>修改..</a>";
			}
		}
		
		protected void btnDelAll_Click(object sender, EventArgs e) 
		{ 
			string sqlText = "("; 
			int countNum = 0;//统计用户选取的记录数目
			for (int i = 0; i < myGridView.Rows.Count; i++) 
			{ 
				//搜索第n行3列 
				CheckBox cbx = (CheckBox)myGridView.Rows[i].FindControl("cbxId"); 
				if (cbx.Checked == true) 
				{ 
					sqlText = sqlText + Convert.ToInt32(myGridView.DataKeys[i].Value) + ",";
					countNum ++;
				} 
			} 
			//去掉最后的逗号，并且加上右括号 
			sqlText = sqlText.Substring(0,sqlText.Length - 1) + ")"; 
			if(countNum>0){///如果选择不为空
				sqlText = "Delete From LinkGroup4DeepSoon Where ID In" + sqlText; 
				MysqlHelp mh = new MysqlHelp();
				///操作权限检测
				if( hasRightTo("LinksDelete","删除链接类别") ){
					mh.Runsql(sqlText);
					Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','链接类别已删除!','OK')</script>");
				}
				else{
					Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning')</script>");
				}	
			}
			GridviewBind(); 
		}
		
		protected void btnSelAll_Click(object sender, EventArgs e) 
		{ 
			for (int i = 0; i < myGridView.Rows.Count; i++) 
			{ 
				//搜索第n行3列 
				CheckBox cbx = (CheckBox)myGridView.Rows[i].FindControl("cbxId"); 
				cbx.Checked = true;
			}
		}
		
		protected void btnUnSelAll_Click(object sender, EventArgs e) 
		{ 
			for (int i = 0; i < myGridView.Rows.Count; i++) 
			{ 
				//搜索第n行3列 
				CheckBox cbx = (CheckBox)myGridView.Rows[i].FindControl("cbxId"); 
				cbx.Checked = false;
			}
		}

		#region 转到触发方法
		protected void btnGo_Click(object sender, EventArgs e)
		{
			if(((TextBox)myGridView.BottomPagerRow.FindControl("txtGoPage")).Text != ""){
				myGridView.PageIndex = int.Parse(((TextBox)myGridView.BottomPagerRow.FindControl("txtGoPage")).Text) - 1;
				GridviewBind();   //重新绑定GridView
				((TextBox)myGridView.BottomPagerRow.FindControl("txtGoPage")).Text = ""+(myGridView.PageIndex+1);
			}
		}
		#endregion
		protected void btnAdd_Click(object sender, EventArgs e)
        {
			///获取输入的链接名称：
			string txtLinkGroupNameValue = this.txtLinkGroupName.Text.Replace("'", "");
			
			if (txtLinkGroupNameValue!=""){//判断用户输入的是否为空用户名和密码,链接类别是否为空
				///创建数据连接对象：
				string Values = "'"+txtLinkGroupNameValue+"'";
				MysqlHelp mh = new MysqlHelp();
				///操作权限检测
				if( hasRightTo("LinksAdd","添加链接类别") ){
					mh.Runsql("Insert Into LinkGroup4DeepSoon(LinkGroupName) Values ("+Values+")");	
					this.labelAddInfor.Text="链接类别添加成功!";
					GridviewBind();
					Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','链接类别已添加!','OK')</script>");
				}
				else{
					Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning')</script>");
				}
			}//end 判断是否链接名称和链接地址为空
			else
			{
				this.labelAddInfor.Text="链接类别名称不允许为空!";
				Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','链接类别名称不允许为空!','Error')</script>");
			}
		}///end btnAdd_Click()
		
		
	}
	//End LinkGroup Class
	
	
	
	/* 
	类名: LinkGroupUpdate 
	功能：链接更新类
	作者：书红
	*/
	//Start LinkGroupUpdate Class
	public partial class LinkGroupUpdate : PageBase
    {
		protected void Page_Load(object sender, EventArgs e)
		{
			if(!IsPostBack)
            {
				string updateID = Request.QueryString["updateID"];
				
				DeepSoonHelp dh = new DeepSoonHelp();
				if(dh.notHasSQLInsertCode(updateID) && updateID != null){			
					///获取数据源
					MysqlHelp mh = new MysqlHelp();
					DataTable dt = new DataTable();
					
					dt = mh.GetDatabysql("Select * From LinkGroup4DeepSoon Where ID="+updateID);
					this.txtLinkGroupName.Text = dt.Rows[0]["LinkGroupName"].ToString();
					this.txtLinkGroupID.Text = updateID;
					
				}///end if
            }			
        }
		

		protected void btnUpdate_Click(object sender, EventArgs e)
		{
			///获取更新链接的ID：
			string ID = this.txtLinkGroupID.Text.Replace("'", "");
			///获取输入的链接名称：
			string LinkGroupName = this.txtLinkGroupName.Text.Replace("'", "");
			if(LinkGroupName.Length>20)LinkGroupName = LinkGroupName.Substring(0,20);
			
			if (LinkGroupName!="" && ID!="" ){//判断是否为空
				if( hasRightTo("LinksUpdate","更新链接类别") ){
					///创建数据连接对象：
					MysqlHelp mh = new MysqlHelp();
					///修改参数：
					mh.Runsql("Update LinkGroup4DeepSoon Set LinkGroupName='"+LinkGroupName+"' Where ID="+ID);
					this.labelUpdateInfor.Text="链接类别已经更新!";
					Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','链接类别信息已更新!','OK')</script>");
					///Response.Redirect("deepSoonTreeUpdate.aspx?updateID="+menuID+"&updateName="+menuName);
				}
				else{
					Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning')</script>");
				}
			}
			else {
				this.labelUpdateInfor.Text="请将必填项填写完整!";
				Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','请将必填项填写完整!','Error')</script>");
			}
			
		}

	}//end class
	//End LinkGroupUpdate Class

}