﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.IO;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using MySql.Data.MySqlClient;

using Security;
namespace Security
{
	/* 
	类名: DeepSoonCreateDir 
	功能：创建目录类
	作者：书红
	*/
	//Start DeepSoonCreateDir Class
    public partial class DeepSoonCreateDir : PageBase
    {
		protected void Page_Load(object sender, EventArgs e)
        {
			string levelDir = Request.QueryString["levelDir"];
			
			if(levelDir == null){			
				levelDir = "../";
			}
			this.txtFolderDir.Text = levelDir;
			
			if (!IsPostBack) 
			{ 
				
				
			}///end if isPostBack
			
        }
		
		protected void btnAdd_Click(object sender, EventArgs e)
        {
			string folderName = this.txtFolderName.Text.Replace("'", "").Replace(":", "").Replace("*", "").Replace("?", "").Replace(">", "").Replace("<", "").Replace("|", "").Replace("\"", "").Replace("\\", "").Replace("/", "");
			string saveDir = this.txtFolderDir.Text.Replace("'", "").Replace(":", "").Replace("*", "").Replace("?", "").Replace(">", "").Replace("<", "").Replace("|", "").Replace("\"", "");
			if(folderName != "" && saveDir != ""){
				string savePath = Server.MapPath("../"+saveDir+folderName).ToString();//获取物理地址 
				if (!Directory.Exists(savePath))//判断文件夹是否存在 
				{ 
					///操作权限检测
					if( hasRightTo("DocumentAdd","创建目录") ){
						Directory.CreateDirectory(savePath); 
						Response.Redirect("Document.aspx?levelDir="+saveDir);
					}
					else{
						Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning')</script>");
					}
				}
			}
			else{
				labelAddInfor.Text = "没有填写完整,名称只允许数字/汉字/字母组合!";
				Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','没有填写完整,名称只允许数字/汉字/字母组合!','Error')</script>");
			}
			
		}///end btnAdd_Click()

    }
	//End DeepSoonCreateDir Class
	
	
	/* 
	类名: DeepSoonDocument 
	功能：文档管理类
	作者：书红
	*/
	//Start DeepSoonDocument Class
	public partial class DeepSoonDocument : PageBase
    {
		protected void Page_Load(object sender, EventArgs e)
        {
			string Dir = "../";
			string DirRoot = "../";
			string topDirLink = "../";
			
			string levelDir = Request.QueryString["levelDir"];
			DeepSoonHelp dh = new DeepSoonHelp();
			
			if( levelDir != null && dh.notHasSQLInsertCode(levelDir) )levelDir = levelDir.Replace("'", "").Replace(":", "").Replace("*", "").Replace("?", "").Replace(">", "").Replace("<", "").Replace("|", "").Replace("\"", "");
			if( levelDir != null && dh.notHasSQLInsertCode(levelDir) ){			
				Dir = levelDir;
				if(levelDir != "../"){
					DirRoot = levelDir.Substring(0, (levelDir.Substring(0,levelDir.LastIndexOf('/'))).LastIndexOf('/')+1 );
					topDirLink = "<a href='Document.aspx?levelDir="+DirRoot+"'>上级目录..</a>";
				}
				else{
					topDirLink = "<a href='#'>../</a>";
				}
			}
				
			///删除文件夹
			string delFolderPathReq = Request.QueryString["delFolderPath"];
			if( delFolderPathReq != null && dh.notHasSQLInsertCode(delFolderPathReq) )delFolderPathReq = delFolderPathReq.Replace("'", "").Replace(":", "").Replace("*", "").Replace("?", "").Replace(">", "").Replace("<", "").Replace("|", "").Replace("\"", "");
			string delFolderPath = Server.MapPath("../"+delFolderPathReq).ToString(); 
			if( delFolderPathReq != null && dh.notHasSQLInsertCode(delFolderPathReq) ){			
				if (Directory.Exists(delFolderPath))//判断文件夹是否存在 
				{ 
					///操作权限检测
					if( hasRightTo("DocumentDelete","删除目录") ){
						Directory.Delete(delFolderPath,true);
						string RedirectDir = delFolderPathReq.Substring(0, (delFolderPathReq.Substring(0,delFolderPathReq.LastIndexOf('/'))).LastIndexOf('/')+1 );
						Response.Redirect("Document.aspx?levelDir="+RedirectDir);
					}
					else{
						Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning')</script>");
					}
				}
			}	
			
			///删除文件
			string delFileNameReq = Request.QueryString["delFileName"];
			if( delFileNameReq != null && dh.notHasSQLInsertCode(delFileNameReq) )delFileNameReq = delFileNameReq.Replace("'", "").Replace(":", "").Replace("*", "").Replace("?", "").Replace(">", "").Replace("<", "").Replace("|", "").Replace("\"", "");
			string delFilePathReq = Request.QueryString["delFilePath"];
			if(delFilePathReq != null)delFilePathReq = delFilePathReq.Replace("'", "").Replace(":", "").Replace("*", "").Replace("?", "").Replace(">", "").Replace("<", "").Replace("|", "").Replace("\"", "");
			if( delFileNameReq != null && delFilePathReq != null  && dh.notHasSQLInsertCode(delFileNameReq) && dh.notHasSQLInsertCode(delFilePathReq) ){			
				if (File.Exists(MapPath("../"+delFilePathReq+delFileNameReq))){
					///操作权限检测
					if( hasRightTo("DocumentDelete","删除文件") ){
						File.Delete(MapPath("../"+delFilePathReq+delFileNameReq));
						Response.Redirect("Document.aspx?levelDir="+delFilePathReq);
					}
					else{
						Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning')</script>");
					}
				}
			}
			
			if (!IsPostBack) 
			{ 
				string fileContentStr = "";
				
				fileContentStr += "<div style='float:left;width:160px;'><ul id='buttonContent'>";
				fileContentStr += "<li class='selAllbutton' >";
					fileContentStr += "<img src='../images/addIcon.png' style='margin-bottom:-2px;'> <a href='CreateDir.aspx?levelDir="+Dir+"'>创建目录</a>";
				fileContentStr += "</li>";
				fileContentStr += "<li class='unSelbutton'>";
					fileContentStr += "<a href='UploadFile.aspx?levelDir="+Dir+"'>上传文件</a>";
				fileContentStr += "</li>";
				fileContentStr += "</ul></div>";
				
				fileContentStr += "<div style='float:left;text-align:right;padding-top:5px;'>"+Dir+"</div><div style='clear:both;'></div>";
				fileContentStr += "<table style='width:100%;' cellspacing=0 cellpadding=0>";
				fileContentStr += "<tr><th>文件/文件夹名称</th><th>创建时间</th><th>访问时间</th><th>修改时间</th><th>文件大小</th><th>操作</th></tr>";
				
				DirectoryInfo rootFolder=new DirectoryInfo(Server.MapPath("../"+DirRoot));
				string rootFolderCreateTime = rootFolder.CreationTime.ToString();
				string rootFolderLastAccessTime = rootFolder.LastAccessTime.ToString();
				string rootFolderLastWriteTime = rootFolder.LastWriteTime.ToString();
				fileContentStr += "<tr><td><img src='../images/uplevel.png' style='margin-bottom:-2px;'> "+topDirLink+"</td><td style='width:84px;'>"+rootFolderCreateTime+"</td><td style='width:84px;'>"+rootFolderLastAccessTime+"</td><td style='width:84px;'>"+rootFolderLastWriteTime+"</td><td>&nbsp;</td><td>删除</td></tr>";
				
				
				DirectoryInfo TheFolder=new DirectoryInfo(Server.MapPath("../"+Dir));
				///遍历文件夹
				System.IO.DirectoryInfo []dirs = TheFolder.GetDirectories();
				string folderName = "";
				string folderCreateTime = "";
				string folderLastAccessTime = "";
				string folderLastWriteTime = "";
				for(int i=0;i<dirs.Length;i++){
					folderName = dirs[i].Name.ToString();
					folderCreateTime = dirs[i].CreationTime.ToString();
					folderLastAccessTime = dirs[i].LastAccessTime.ToString();
					folderLastWriteTime = dirs[i].LastWriteTime.ToString();
					fileContentStr += "<tr onmouseOver='this.style.backgroundColor=\"#F0F0F0\"' onmouseOut='this.style.backgroundColor=\"#FFFFFF\"'>";
					fileContentStr += "<td><a href='Document.aspx?levelDir="+Dir+folderName+"/'><img src='../images/file-folder.png' style='margin-bottom:-2px;'> "+folderName+"</a></td>";
					fileContentStr += "<td style='width:84px;'>"+folderCreateTime+"</td>";
					fileContentStr += "<td style='width:84px;'>"+folderLastAccessTime+"</td>";
					fileContentStr += "<td style='width:84px;'>"+folderLastWriteTime+"</td>";
					fileContentStr += "<td style='width:100px;'>&nbsp;</td>";
					fileContentStr += "<td style='width:100px;'>";
						fileContentStr += "<a href='Document.aspx?delFolderPath="+Dir+folderName+"/' OnClick='if (!confirm(\"文件夹内的所有文件将被同时删除，是否确认删除？\")) return false;'>删除</a>";
					fileContentStr += "</td>";
					fileContentStr += "</tr>";
					
				}
				
				///遍历文件
				string fileName = "";
				string fileEndType = "";
				string fileCreationTime = "";
				string fileLastAccessTime = "";
				string fileLastWriteTime = "";
				string fileLength = "";
				foreach(FileInfo NextFile in TheFolder.GetFiles())
				{
					fileName = NextFile.Name;
					fileEndType = fileName.Substring(fileName.LastIndexOf("."));
					fileCreationTime = NextFile.CreationTime.ToString();
					fileLastAccessTime = NextFile.LastAccessTime.ToString();
					fileLastWriteTime = NextFile.LastWriteTime.ToString();
					long intFileLength = NextFile.Length/1024;
					fileLength = intFileLength + "KB";
					
					fileContentStr += "<tr onmouseOver='this.style.backgroundColor=\"#F0F0F0\"' onmouseOut='this.style.backgroundColor=\"#FFFFFF\"'>";
					if(fileEndType == ".html" || fileEndType == ".htm" || fileEndType == ".js" || fileEndType == ".css" || fileEndType == ".txt" || fileEndType == ".jpg" || fileEndType == ".png" || fileEndType == ".gif"  || fileEndType == ".pdf"  || fileEndType == ".zip"  || fileEndType == ".doc"  || fileEndType == ".rar")
						fileContentStr += "<td><a href='../"+Dir+fileName+"' target='_blank'><img src='../images/file-webscript.png' style='margin-bottom:-2px;'> "+fileName+"</a></td>";
					else
						fileContentStr += "<td><img src='../images/file-webscript.png' style='margin-bottom:-2px;'> "+fileName+"</td>";
					fileContentStr += "<td style='width:84px;'>"+fileCreationTime+"</td>";
					fileContentStr += "<td style='width:84px;'>"+fileLastAccessTime+"</td>";
					fileContentStr += "<td style='width:84px;'>"+fileLastWriteTime+"</td>";
					fileContentStr += "<td style='width:100px;'>"+fileLength+"</td>";
					fileContentStr += "<td style='width:100px;'>";
						fileContentStr += "<a href='Document.aspx?delFilePath="+Dir+"&delFileName="+fileName+"' OnClick='if (!confirm(\"附件删除后不可恢复，是否确认删除？\")) return false;'>删除</a>";
						if(fileEndType == ".html" || fileEndType == ".htm" || fileEndType == ".js" || fileEndType == ".css" || fileEndType == ".txt"){
							fileContentStr += " | <a href='TxtEdit.aspx?filePath="+Dir+"&fileName="+fileName+"'>编辑</a>";
						}
					fileContentStr += "</td>";
					fileContentStr += "</tr>";
				}
				fileContentStr += "</table>";
				
				///操作权限检测
				if( hasRightTo("DocumentSelect","查看文档") ){
					this.labelFile.Text = fileContentStr;
				}
				else{
					Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning')</script>");
				}
				
			}///end if isPostBack
			
        }

    }
	//End DeepSoonDocument Class
	
	
	
	/* 
	类名: DeepSoonTxtEdit 
	功能：文档在线编辑类
	作者：书红
	*/
	//Start DeepSoonTxtEdit Class
	public partial class DeepSoonTxtEdit : PageBase
    {
		string filePath;
		string fileName;
		
		protected void Page_Load(object sender, EventArgs e)
        {
			filePath = Request.QueryString["filePath"];
			fileName = Request.QueryString["fileName"];
			
			DeepSoonHelp dh = new DeepSoonHelp();
			if (!IsPostBack && dh.notHasSQLInsertCode(filePath) && dh.notHasSQLInsertCode(fileName) && fileName != "web.config") 
			{ 
				if( hasRightTo("DocumentEdit","编辑文件") ){
					string fileAtServer = Server.MapPath("../"+filePath+fileName).ToString();
					if(File.Exists(fileAtServer)){
						string fileContent = "";
						fileContent = File.ReadAllText(fileAtServer); 
						this.labelFileFullPath.Text = filePath + fileName;
						this.textFileContent.Text = fileContent;
					}
					else{
						this.labelSaveInfor.Text = "文件不存在";
						Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','文件爱呢不存在!','Warning')</script>");
					}
				}
				else{
					Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning')</script>");
				}
			}
			
        }
		
		protected void btnSave_Click(object sender, EventArgs e)
        {
			string fileAtServer = Server.MapPath("../"+filePath+fileName).ToString();
			string fileContent =  this.textFileContent.Text;
			if(File.Exists(fileAtServer)){
				///操作权限检测
				if( hasRightTo("DocumentEdit","编辑文件") ){
					File.Delete(fileAtServer);
					File.WriteAllText(fileAtServer, fileContent); 
					this.labelSaveInfor.Text = "文件已保存!";
					Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','文件已保存!','OK')</script>");
				}
				else{
					Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning')</script>");
				}
			}
			else{
				this.labelSaveInfor.Text = "文件不存在!";
				Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','文件不存在!','Warning')</script>");
			}
		}///end btnAdd_Click()

    }
	//End DeepSoonTxtEdit Class
	
	
	/* 
	类名: DeepSoonUploadFile 
	功能：上传文档类
	作者：书红
	*/
	//Start DeepSoonUploadFile Class
	public partial class DeepSoonUploadFile : PageBase
    {
		protected void Page_Load(object sender, EventArgs e)
        {
			string levelDir = Request.QueryString["levelDir"];
			if(levelDir == null){			
				levelDir = "../";
			}
			this.txtFolderDir.Text = levelDir;
			
			if (!IsPostBack) 
			{ 
			
			}///end if isPostBack
			
        }
		
		protected void btnUploadFile_Click(object sender, EventArgs e)
		{
			if (fileUpload.HasFile)
			{
				string fileContentType = fileUpload.PostedFile.ContentType;
				string name = fileUpload.PostedFile.FileName;  /// 客户端上传文件路径
				FileInfo file = new FileInfo(name);
				string fileName = file.Name;                /// 上传的文件名称
				string webFilePath = Server.MapPath("../"+this.txtFolderDir.Text + fileName);        /// 服务器端文件路径
				///if (!File.Exists(webFilePath))
				///{
					try
					{
						///操作权限检测
						if( hasRightTo("DocumentUploadFile","上传文件") ){
							if (File.Exists(webFilePath)){
								File.Delete(webFilePath);
							}
							fileUpload.SaveAs(webFilePath);
							Response.Redirect("Document.aspx?levelDir="+this.txtFolderDir.Text);
						}
						else{
							Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning')</script>");
						}	
						
					}catch (Exception ex){}
				///}
			}

		}

    }
	//End DeepSoonUploadFile Class
	
	
	/* 
	类名: UploadFileLog 
	功能：上传日志管理类
	作者：书红
	*/
	//Start UploadFileLog Class
	public partial class UploadFileLog : PageBase
    {
		protected void Page_Load(object sender, EventArgs e)
        {
			if (!IsPostBack) 
			{ 
				///操作权限检测
				if( hasRightTo("DocumentSelect","查看附件上传日志") ){
					GridviewBind();
				}
				else{
					Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning')</script>");
				}
			}
			btnDelAll.Attributes.Add("onclick","return confirm(\"删除后数据无法恢复，是否确认删除？\")") ;
			///myGridView.Attributes.Add("style","table-layout:fixed");
        }
		
		protected void GridviewBind() 
		{ 
			///创建数据连接对象：
			MysqlHelp mh = new MysqlHelp();
			///查询并显示数据：
			DataTable dt=new DataTable();
			dt = mh.GetDatabysql("Select * From attachmentFile4DeepSoon Order By ID DESC");
			myGridView.DataSource = dt;        
			myGridView.DataBind();
		}
	
		protected void myGridView_PageIndexChanging(object sender, GridViewPageEventArgs e)
		{
			myGridView.PageIndex = e.NewPageIndex;
			GridviewBind();//重新执行自定义的GridView数据绑定函数
			((TextBox)myGridView.BottomPagerRow.FindControl("txtGoPage")).Text = ""+(myGridView.PageIndex+1);
		}

		protected void myGridView_RowDeleting(object sender, GridViewDeleteEventArgs e) 
		{ 
			int deleteID = Convert.ToInt32(myGridView.DataKeys[e.RowIndex].Value);//获取主键
		
			///创建数据连接对象：
			MysqlHelp mh = new MysqlHelp();
			MySqlParameter[] updateParms ={new MySqlParameter("?ID",MySqlDbType.VarChar,4)};
			updateParms[0].Value = ""+deleteID;
			///操作权限检测
			if( hasRightTo("DocumentDelete","删除附件上传日志以及附件") ){
			
				///删除服务器附件
				DataTable attachmentFileDt = new DataTable();
				attachmentFileDt = mh.GetDatabysql("Select fileUrl From attachmentFile4DeepSoon Where ID=?ID",updateParms);
				if(attachmentFileDt.Rows.Count>0){
					for(int i = 0 ; i < attachmentFileDt.Rows.Count ; i++)
					{
						string fileUrl = attachmentFileDt.Rows[i]["fileUrl"].ToString();
						///删除服务器上的附件
						if (File.Exists(MapPath(fileUrl))){
							File.Delete(MapPath(fileUrl));
						}
					}
				}
				///删除日志记录
				mh.Runsql("Delete From attachmentFile4DeepSoon Where ID=?ID", updateParms);
				GridviewBind();
				Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','附件上传日志和附件已删除!','OK')</script>");
			}
			else{
				Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning')</script>");
			}
		} 
		
		protected void myGridView_RowDataBound(object sender, GridViewRowEventArgs e)
		{
			if (e.Row.RowType == DataControlRowType.DataRow)
			{
				//当鼠标在某一行上方时激发
				e.Row.Attributes.Add("onmouseover", "curColor=this.style.backgroundColor;this.style.backgroundColor='#F0F0F0'");
				//当鼠标从某一行上方移开时激发
				e.Row.Attributes.Add("onmouseout", "this.style.backgroundColor=curColor");
			}
			if (e.Row.RowType == DataControlRowType.DataRow)  
			{  
				//引用文章   
				MysqlHelp mh = new MysqlHelp();
				string articleID = e.Row.Cells[2].Text.Trim().ToLower();  
				DataTable articleDt = new DataTable();
				articleDt = mh.GetDatabysql("Select Title From Article4DeepSoon Where ID="+articleID);
				if(articleDt.Rows.Count>0){
					string articleTitle = articleDt.Rows[0]["Title"].ToString();
					e.Row.Cells[2].Text = "<a href='/view.aspx?ID="+articleID+"' target='_blank'>"+articleTitle+"</a>";
				}
				else{
					e.Row.Cells[2].Text = "<a href='#' target='_blank'>邮件正文引用</a>";
				}
				
				//附件内容   
				string attachFileStr = e.Row.Cells[4].Text.Trim().ToLower();  
				//附件后缀名
				string fileType = attachFileStr.Substring(attachFileStr.LastIndexOf(".")); 
				if( fileType == ".jpg" || fileType == ".png"  || fileType == ".gif" ){
					e.Row.Cells[4].Text = "<a href='"+attachFileStr+"' target='_blank'><img src='"+attachFileStr+"' style='height:50px;'></a>";  
					e.Row.Cells[4].ToolTip = "图片附件，点击查看原图";
				}
				else{
					e.Row.Cells[4].Text = "<a href='"+attachFileStr+"' target='_blank'>查看"+fileType+"附件</a>";  
					e.Row.Cells[4].ToolTip = "文档附件，点击查看";
				}
			}
		}
		
		protected void btnDelAll_Click(object sender, EventArgs e) 
		{ 
			string sqlText = "("; 
			int countNum = 0;//统计用户选取的记录数目
			for (int i = 0; i < myGridView.Rows.Count; i++) 
			{ 
				//搜索第n行3列 
				CheckBox cbx = (CheckBox)myGridView.Rows[i].FindControl("cbxId"); 
				if (cbx.Checked == true) 
				{ 
					sqlText = sqlText + Convert.ToInt32(myGridView.DataKeys[i].Value) + ",";
					countNum ++;
				} 
			} 
			//去掉最后的逗号，并且加上右括号 
			sqlText = sqlText.Substring(0,sqlText.Length - 1) + ")"; 
			if(countNum>0){///如果选择不为空
				MysqlHelp mh = new MysqlHelp();
				///操作权限检测
				if( hasRightTo("DocumentDelete","批量删除附件上传日志以及附件") ){
				
					///删除服务器附件
					DataTable attachmentFileDt = new DataTable();
					attachmentFileDt = mh.GetDatabysql("Select fileUrl From attachmentFile4DeepSoon Where ID In " + sqlText);
					if(attachmentFileDt.Rows.Count>0){
						for(int i = 0 ; i < attachmentFileDt.Rows.Count ; i++)
						{
							string fileUrl = attachmentFileDt.Rows[i]["fileUrl"].ToString();
							///删除服务器上的附件
							if (File.Exists(MapPath(fileUrl))){
								File.Delete(MapPath(fileUrl));
							}
						}
					}
					///删除日志记录
					sqlText = "Delete From attachmentFile4DeepSoon Where ID In " + sqlText; 
					mh.Runsql(sqlText);
					GridviewBind();
				
					Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','附件上传日志和附件已删除!','OK')</script>");
				}
				else{
					Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning')</script>");
				} 
			}
			GridviewBind(); 
		}
		
		protected void btnSelAll_Click(object sender, EventArgs e) 
		{ 
			for (int i = 0; i < myGridView.Rows.Count; i++) 
			{ 
				//搜索第n行3列 
				CheckBox cbx = (CheckBox)myGridView.Rows[i].FindControl("cbxId"); 
				cbx.Checked = true;
			}
		}
		
		protected void btnUnSelAll_Click(object sender, EventArgs e) 
		{ 
			for (int i = 0; i < myGridView.Rows.Count; i++) 
			{ 
				//搜索第n行3列 
				CheckBox cbx = (CheckBox)myGridView.Rows[i].FindControl("cbxId"); 
				cbx.Checked = false;
			}
		}

		#region 转到触发方法
		protected void btnGo_Click(object sender, EventArgs e)
		{
			if(((TextBox)myGridView.BottomPagerRow.FindControl("txtGoPage")).Text != ""){
				myGridView.PageIndex = int.Parse(((TextBox)myGridView.BottomPagerRow.FindControl("txtGoPage")).Text) - 1;
				GridviewBind();   //重新绑定GridView
				((TextBox)myGridView.BottomPagerRow.FindControl("txtGoPage")).Text = ""+(myGridView.PageIndex+1);
			}
		}
		#endregion
		
    }
	//End UploadFileLog Class
	
}