﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Configuration;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls.WebParts;
using MySql.Data.MySqlClient;

using Security;
namespace Security
{
	/* 
	类名: Comment 
	功能：评论管理类
	作者：书红
	*/
	//Start Comment Class
    public partial class Comment : PageBase
    {
		protected void Page_Load(object sender, EventArgs e)
        {			
			btnDelAll.Attributes.Add("onclick","return confirm(\"是否确认删除？\")") ;
			
			if (!IsPostBack) 
			{ 
				///操作权限检测
				if( hasRightTo("CommentSelect","查看评论列表") ){
					GridviewBind();
				}
				else{
					Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning')</script>");
				}
			}
        }
		
		public string GetM(string strm)
		{
			if(strm == "False")
				return "通过审核";
			else
				return "取消通过";
		}
		
		protected void GridviewBind() 
		{ 
			///创建数据连接对象：
			MysqlHelp mh = new MysqlHelp();
			DataTable dt=new DataTable();
			dt = mh.GetDatabysql("Select * From Comment4DeepSoon Order By ID DESC");
			myGridView.DataSource = dt;        
			myGridView.DataBind();
		}
	
		protected void myGridView_PageIndexChanging(object sender, GridViewPageEventArgs e)
		{
			myGridView.PageIndex = e.NewPageIndex;
			GridviewBind();//重新执行自定义的GridView数据绑定函数
			((TextBox)myGridView.BottomPagerRow.FindControl("txtGoPage")).Text = ""+(myGridView.PageIndex+1);
		}
		
		protected void myGridView_RowCommand(object sender, GridViewCommandEventArgs e) 
		{ 
			if(e.CommandName == "deleteComment"){
				///创建数据连接对象：
				MysqlHelp mh = new MysqlHelp();
				MySqlParameter[] updateParms ={new MySqlParameter("?ID",MySqlDbType.VarChar,8)};
				updateParms[0].Value = ""+e.CommandArgument.ToString();
				///操作权限检测
				if( hasRightTo("CommentDelete","删除评论") ){
					mh.Runsql("Delete From Comment4DeepSoon Where ID=?ID", updateParms);
					mh.Runsql("Delete From Comment4DeepSoon Where FatherID=?ID", updateParms);
					GridviewBind(); 
					Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','评论已删除!','OK')</script>");
				}
				else{
					Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning')</script>");
				}
			}
			else if(e.CommandName == "setPass"){
				MysqlHelp mh = new MysqlHelp();
				string ID = e.CommandArgument.ToString();
				DataTable Dt = new DataTable();
				Dt = mh.GetDatabysql("Select isPass From Comment4DeepSoon Where ID="+ID);
				if(Dt.Rows.Count>0){
					string isPass = Dt.Rows[0]["isPass"].ToString();
					string isPassNowValue = "False";
					if(isPass == "False")isPassNowValue="True";
					else isPassNowValue = "False";
					///操作权限检测
					if( hasRightTo("CommentCheck","评论审核") ){
						mh.Runsql( "Update Comment4DeepSoon Set isPass="+isPassNowValue+" Where ID="+ID );
						Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','评论状态已更新!','OK')</script>");
					}
					else{
						Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning')</script>");
					}
				}
				GridviewBind(); 
			}
		}
		
		protected void myGridView_RowDataBound(object sender, GridViewRowEventArgs e)
		{
			if (e.Row.RowType == DataControlRowType.DataRow)
			{
				//当鼠标在某一行上方时激发
				e.Row.Attributes.Add("onmouseover", "curColor=this.style.backgroundColor;this.style.backgroundColor='#F0F0F0'");
				//当鼠标从某一行上方移开时激发
				e.Row.Attributes.Add("onmouseout", "this.style.backgroundColor=curColor");
			}
			
			if (e.Row.RowType == DataControlRowType.DataRow)  
			{  
				//设置申请原因字符串显示长度   
				string strDISC = e.Row.Cells[2].Text.Trim();  
				e.Row.Cells[2].Text = "<div class='listover200'>" + strDISC + "</div>";  
				e.Row.Cells[2].ToolTip = strDISC;//鼠标放上去显示所有
				
				string strArticleID = e.Row.Cells[7].Text.Trim();  
				e.Row.Cells[7].Text = "<a href='../../view.aspx?id="+strArticleID+"' target='_blank'>原文</a>"; 
				
				//获取所在城市   
				string strIP = e.Row.Cells[3].Text.Trim();
				string getAddrStr = "<script src='http://int.dpool.sina.com.cn/iplookup/iplookup.php?format=js&ip="+strIP+"' type='text/ecmascript'></script>";
				getAddrStr += "<script type='text/javascript'>document.write(remote_ip_info ['province'] + '省' + '' + remote_ip_info ['city'] + '市');</script>";
				e.Row.Cells[4].Text = getAddrStr;
			}
		}
		
		protected void btnDelAll_Click(object sender, EventArgs e) 
		{ 
			string sqlText = "("; 
			int countNum = 0;//统计用户选取的记录数目
			for (int i = 0; i < myGridView.Rows.Count; i++) 
			{ 
				//搜索第n行3列 
				CheckBox cbx = (CheckBox)myGridView.Rows[i].FindControl("cbxId"); 
				if (cbx.Checked == true) 
				{ 
					sqlText = sqlText + Convert.ToInt32(myGridView.DataKeys[i].Value) + ",";
					countNum ++;
				} 
			} 
			//去掉最后的逗号，并且加上右括号 
			sqlText = sqlText.Substring(0,sqlText.Length - 1) + ")"; 
			if(countNum>0){///如果选择不为空
				///操作权限检测
				if( hasRightTo("CommentDelete","删除评论") ){
					MysqlHelp mh = new MysqlHelp();
					mh.Runsql("Delete From Comment4DeepSoon Where ID In" + sqlText);
					mh.Runsql("Delete From Comment4DeepSoon Where FatherID In" + sqlText);
					Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','评论已删除!','OK')</script>");
				}
				else{
					Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning')</script>");
				}
			}
			GridviewBind(); 
		}

		protected void btnSelAll_Click(object sender, EventArgs e) 
		{ 
			for (int i = 0; i < myGridView.Rows.Count; i++) 
			{ 
				//搜索第n行3列 
				CheckBox cbx = (CheckBox)myGridView.Rows[i].FindControl("cbxId"); 
				cbx.Checked = true;
			}
		}
		
		protected void btnUnSelAll_Click(object sender, EventArgs e) 
		{ 
			for (int i = 0; i < myGridView.Rows.Count; i++) 
			{ 
				//搜索第n行3列 
				CheckBox cbx = (CheckBox)myGridView.Rows[i].FindControl("cbxId"); 
				cbx.Checked = false;
			}
		}
		
		#region 转到触发方法
		protected void btnGo_Click(object sender, EventArgs e)
		{
			if(((TextBox)myGridView.BottomPagerRow.FindControl("txtGoPage")).Text != ""){
				myGridView.PageIndex = int.Parse(((TextBox)myGridView.BottomPagerRow.FindControl("txtGoPage")).Text) - 1;
				GridviewBind();   //重新绑定GridView
				((TextBox)myGridView.BottomPagerRow.FindControl("txtGoPage")).Text = ""+(myGridView.PageIndex+1);
			}
		}
		#endregion
		
		protected void btnTruncate_Click(object sender, EventArgs e)
		{
			///操作权限检测
			if( hasRightTo("CommentDelete","清空评论") ){
				MysqlHelp mh = new MysqlHelp();
				mh.Runsql("Truncate Table Comment4DeepSoon");
				Response.Redirect("DeepSoonComment.aspx");
			}
			else{
				Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning')</script>");
			}
			
		}
    }
	//End Comment Class
	
	
	/* 
	类名: CommentSetting 
	功能：评论设置类
	作者：书红
	*/
	//Start CommentSetting Class
	 public partial class CommentSetting : PageBase
    {
		MysqlHelp mh = null;
		DataTable dt = null;
		protected void Page_Load(object sender, EventArgs e)
		{
			if(!IsPostBack)
            {
				MysqlHelp mh = new MysqlHelp();
				
				///读取评论配置表信息：
				bool setOpen=true;
				bool setPass=false;
				int setSize=200;
				string openArea = "all";
				DataTable settingDt=new DataTable();
				settingDt = mh.GetDatabysql("Select * From CommentSetting4DeepSoon");
				if(settingDt.Rows.Count > 0){
					setOpen = (bool)settingDt.Rows[0]["setOpen"];
					setPass = (bool)settingDt.Rows[0]["setPass"];
					setSize = Convert.ToInt32(settingDt.Rows[0]["setSize"]);
					openArea = settingDt.Rows[0]["openArea"].ToString();
					///是否开放评论
					if(setOpen){
						this.dropSetOpen.SelectedIndex = 0;
					}else{
						this.dropSetOpen.SelectedIndex = 1;
					}
					///是否审核后显示
					if(setPass){
						this.dropSetPass.SelectedIndex = 0;
					}
					else {
						this.dropSetPass.SelectedIndex = 1;
					}
				
					///设定评论权限
					ListItem opentAreaItem=this.dropOpenArea.Items.FindByValue(openArea);
					if(opentAreaItem != null)
					{
						opentAreaItem.Selected = true;
					}
					///评论字数限制
					this.txtSetSize.Text = ""+setSize;
				
				}
				
            }			
        }
		

		/// 功能：判断输入的是否是数字 
		/// 参数：string oText：源文本 
		/// 返回值：　bool true:是　false:否 
		public bool IsNumberic(string oText) 
		{ 
			try 
			{ 
				int var1=Convert.ToInt32 (oText); 
				return true; 
			} 
			catch 
			{ 
				return false; 
			} 
		}
		
		protected void btnUpdate_Click(object sender, EventArgs e)
		{
			bool setOpen = true;
			string setOpenStr = this.dropSetOpen.SelectedItem.Value;
			if (setOpenStr=="false") setOpen = false;
			
			bool setPass = false;
			string setPassStr = this.dropSetPass.SelectedItem.Value;
			if (setPassStr == "true") setPass = true;
		
			int setSize = 200;
			string setSizeStr = this.txtSetSize.Text.Replace("'", "");
			if( setSizeStr != null && setSizeStr.Length>999999999 )setSizeStr = setSizeStr.Substring(0,999999999);
			if( setSizeStr == null )setSizeStr = "200";
			if( !IsNumberic(setSizeStr) )setSizeStr = "200"; 
			setSize = Convert.ToInt32(setSizeStr);
			
			string openArea = this.dropOpenArea.SelectedItem.Value;
			
			///创建数据连接对象：
			MysqlHelp mh = new MysqlHelp();
			///操作权限检测
			if( hasRightTo("CommentSettingUpdate","评论设置更新") ){
				mh.Runsql("Update CommentSetting4DeepSoon Set setOpen="+setOpen+",setPass="+setPass+",setSize="+setSize+",openArea='"+openArea+"'");
				this.labelUpdateInfor.Text="评论配置已经保存!";
				///Response.Redirect("DeepSoonCommentSetting.aspx");
				Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','评论配置已经保存!','OK')</script>");
			}
			else{
				Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning')</script>");
			}	
			
		}

	}//end class
	//End CommentSetting Class
	
}