﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using MySql.Data.MySqlClient;
using System.Web.Configuration;
using System.Text.RegularExpressions; 
using System.Text;
using System.IO;
using System.Net;
using System.Text;
using System.Collections.Generic;

using Security;
namespace Security
{
	/* 
	类名: CollectRule 
	功能：采集规则管理类
	作者：书红
	*/
	//Start CollectRule Class
    public partial class CollectRule : PageBase
    {
		protected void Page_Load(object sender, EventArgs e)
        {			
			btnDelAll.Attributes.Add("onclick","return confirm(\"是否确认删除？\")") ;
			
			if (!IsPostBack) 
			{ 
				///操作权限检测
				if( hasRightTo("CollectRuleSelect","查看采集规则") ){
					GridviewBind();
				}
				else{
					Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning')</script>");
				}
			}
        }
		
		protected void GridviewBind() 
		{ 
			///创建数据连接对象：
			MysqlHelp mh = new MysqlHelp();
			DataTable dt=new DataTable();
			dt = mh.GetDatabysql("Select CollectRule4DeepSoon.ID,Title,CharSet,ClassID,EntranceUrl,Name From CollectRule4DeepSoon,Class4DeepSoon Where CollectRule4DeepSoon.ClassID = Class4DeepSoon.ID Order By ID DESC");
			myGridView.DataSource = dt;        
			myGridView.DataBind();
		}
	
		protected void myGridView_PageIndexChanging(object sender, GridViewPageEventArgs e)
		{
			myGridView.PageIndex = e.NewPageIndex;
			GridviewBind();//重新执行自定义的GridView数据绑定函数
			((TextBox)myGridView.BottomPagerRow.FindControl("txtGoPage")).Text = ""+(myGridView.PageIndex+1);
		}
		
		protected void myGridView_RowCommand(object sender, GridViewCommandEventArgs e) 
		{ 
			if(e.CommandName == "editCollectRule"){
				Response.Redirect( "CollectRuleUpdate.aspx?ID="+e.CommandArgument.ToString() );
			}
			else if(e.CommandName == "deleteCollectRule"){
				///创建数据连接对象：
				MysqlHelp mh = new MysqlHelp();
				MySqlParameter[] updateParms ={new MySqlParameter("?ID",MySqlDbType.VarChar,8)};
				updateParms[0].Value = ""+e.CommandArgument.ToString();
				///操作权限检测
				if( hasRightTo("CollectRuleDelete","删除采集规则") ){
					mh.Runsql("Delete From CollectRule4DeepSoon Where ID=?ID", updateParms);
					GridviewBind();
					Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','采集规则已删除!','OK')</script>");
				}
				else{
					Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning')</script>");
				}
			}
			else if(e.CommandName == "execCollectRule"){
				Response.Redirect( "CollectRuleExec.aspx?ID="+e.CommandArgument.ToString() );
			}
		}
		
		protected void myGridView_RowDataBound(object sender, GridViewRowEventArgs e)
		{
			if (e.Row.RowType == DataControlRowType.DataRow)
			{
				//当鼠标在某一行上方时激发
				e.Row.Attributes.Add("onmouseover", "curColor=this.style.backgroundColor;this.style.backgroundColor='#F0F0F0'");
				//当鼠标从某一行上方移开时激发
				e.Row.Attributes.Add("onmouseout", "this.style.backgroundColor=curColor");
			}
			if (e.Row.RowType == DataControlRowType.DataRow)  
			{  
				//设置申请原因字符串显示长度   
				string strDISC = e.Row.Cells[5].Text.Trim();  
				e.Row.Cells[5].Text = "<div class='listover400'>" + strDISC + "</div>";  
				e.Row.Cells[5].ToolTip = strDISC;//鼠标放上去显示所有
			}
		}
		
		protected void btnDelAll_Click(object sender, EventArgs e) 
		{ 
			string sqlText = "("; 
			int countNum = 0;//统计用户选取的记录数目
			for (int i = 0; i < myGridView.Rows.Count; i++) 
			{ 
				//搜索第n行3列 
				CheckBox cbx = (CheckBox)myGridView.Rows[i].FindControl("cbxId"); 
				if (cbx.Checked == true) 
				{ 
					sqlText = sqlText + Convert.ToInt32(myGridView.DataKeys[i].Value) + ",";
					countNum ++;
				} 
			} 
			//去掉最后的逗号，并且加上右括号 
			sqlText = sqlText.Substring(0,sqlText.Length - 1) + ")"; 
			if(countNum>0){///如果选择不为空
				///操作权限检测
				if( hasRightTo("CollectRuleDelete","批量删除采集规则") ){
					MysqlHelp mh = new MysqlHelp();
					mh.Runsql("Delete From CollectRule4DeepSoon Where ID In" + sqlText);
					Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','采集规则已删除!','OK')</script>");
				}
				else{
					Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning')</script>");
				}
			}
			GridviewBind(); 
		}
		
		protected void btnSelAll_Click(object sender, EventArgs e) 
		{ 
			for (int i = 0; i < myGridView.Rows.Count; i++) 
			{ 
				//搜索第n行3列 
				CheckBox cbx = (CheckBox)myGridView.Rows[i].FindControl("cbxId"); 
				cbx.Checked = true;
			}
		}
		
		protected void btnUnSelAll_Click(object sender, EventArgs e) 
		{ 
			for (int i = 0; i < myGridView.Rows.Count; i++) 
			{ 
				//搜索第n行3列 
				CheckBox cbx = (CheckBox)myGridView.Rows[i].FindControl("cbxId"); 
				cbx.Checked = false;
			}
		}

		#region 转到触发方法
		protected void btnGo_Click(object sender, EventArgs e)
		{
			if(((TextBox)myGridView.BottomPagerRow.FindControl("txtGoPage")).Text != ""){
				myGridView.PageIndex = int.Parse(((TextBox)myGridView.BottomPagerRow.FindControl("txtGoPage")).Text) - 1;
				GridviewBind();   //重新绑定GridView
				((TextBox)myGridView.BottomPagerRow.FindControl("txtGoPage")).Text = ""+(myGridView.PageIndex+1);
			}
		}
		#endregion
		
		protected void btnTruncate_Click(object sender, EventArgs e)
		{
			///操作权限检测
			if( hasRightTo("CollectRuleDelete","删除采集规则") ){
				MysqlHelp mh = new MysqlHelp();
				mh.Runsql("Truncate Table CollectRule4DeepSoon");
				Response.Redirect("CollectRule.aspx");
			}
			else{
				Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning')</script>");
			}
		}
    }
	//End CollectRule Class
	
	
	/* 
	类名: DeepSoonCollectRuleAdd 
	功能：采集规则添加类
	作者：书红
	*/
	//Start DeepSoonCollectRuleAdd Class
	public partial class DeepSoonCollectRuleAdd : PageBase
    {
		DataTable dt = null;
		string className = null;
		
		///定义树节点的结构体
		struct ClassTreeNode{
			public string ID;
			public string Name;
			public string OutLinkHref;
			public int Level;
		}
		
		protected void Page_Load(object sender, EventArgs e)
        {
			if(!IsPostBack){
				MysqlHelp mh = new MysqlHelp();
				dt = mh.GetDatabysql("Select * From Class4DeepSoon Order By Id");
				///显示ID=?的节点+孩子节点，并设定层级初值level
				ClassTreeNode nd;
				nd.ID="0";               ///节点ID
				nd.Name="请选择所属栏目";        ///节点Name
				nd.OutLinkHref = "";     ///节点外链OutLinkHref
				nd.Level=0;              ///节点Level
				///添加栏目下拉菜单
				ListItem li=new ListItem(nd.Name,"Enable"+nd.ID);
				li.Attributes.Add("style","color:#1081BC;");
				this.dropListClassName.Items.Add(li);
				showNodes(nd);
			}
        }
		
		protected void btnAdd_Click(object sender, EventArgs e)
        {
			string ruleName = this.ruleName.Text.Replace("'", "");
			string charSet = this.charSet.Text.Replace("'", "");
			string classId = this.dropListClassName.SelectedItem.Value;
			string entranceUrl = this.entranceUrl.Text.Replace("'", "");
			
			string listUrlStart = this.listUrlStart.Text.Replace("'", "");
			string listUrlEnd = this.listUrlEnd.Text.Replace("'", "");
			
			string viewUrlTitleStart = this.viewUrlTitleStart.Text.Replace("'", "");
			string viewUrlTitleEnd = this.viewUrlTitleEnd.Text.Replace("'", "");
			string viewUrlSourceStart = this.viewUrlSourceStart.Text.Replace("'", "");
			string viewUrlSourceEnd = this.viewUrlSourceEnd.Text.Replace("'", "");
			string viewUrlDateStart = this.viewUrlDateStart.Text.Replace("'", "");
			string viewUrlDateEnd = this.viewUrlDateEnd.Text.Replace("'", "");
			string viewUrlAuthorStart = this.viewUrlAuthorStart.Text.Replace("'", "");
			string viewUrlAuthorEnd = this.viewUrlAuthorEnd.Text.Replace("'", "");
			string viewUrlArticleStart = this.viewUrlArticleStart.Text.Replace("'", "");
			string viewUrlArticleEnd = this.viewUrlArticleEnd.Text.Replace("'", "");
			
			bool classIdEnable = classId.Contains("Enable");
			
			if(classIdEnable){
				labelAddInfor.Text = "选择的导入栏目不合法,不允许外部栏目!";
				Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','选择的导入栏目不合法,不允许外部栏目!','Error')</script>");
			}
			else{
				if(ruleName != "" && charSet != "" && classId != "" && entranceUrl != "" &&listUrlStart != "" && listUrlEnd != "" && viewUrlTitleStart != "" && viewUrlTitleEnd != "" && viewUrlSourceStart != "" && viewUrlSourceEnd != ""&& viewUrlDateStart != "" && viewUrlDateEnd != "" && viewUrlAuthorStart != "" && viewUrlAuthorEnd != "" && viewUrlArticleStart != ""  && viewUrlArticleEnd != "" ){
					///操作权限检测
					if( hasRightTo("CollectRuleAdd","添加采集规则") ){
						string Values = "'"+ruleName+"','"+charSet+"','"+entranceUrl+"','"+classId+"','"+listUrlStart+"','"+listUrlEnd+"','"+viewUrlTitleStart+"','"+viewUrlTitleEnd+"','"+viewUrlSourceStart+"','"+viewUrlSourceEnd+"','"+viewUrlDateStart+"','"+viewUrlDateEnd+"','"+viewUrlAuthorStart+"','"+viewUrlAuthorEnd+"','"+viewUrlArticleStart+"','"+viewUrlArticleEnd+"'";
						///创建数据连接对象：
						MysqlHelp mh = new MysqlHelp();
						mh.Runsql("Insert Into CollectRule4DeepSoon(Title,CharSet,EntranceUrl,ClassId,ListUrlStart,ListUrlEnd,ViewUrlTitleStart,ViewUrlTitleEnd,ViewUrlSourceStart,viewUrlSourceEnd,ViewUrlDateStart,viewUrlDateEnd,ViewUrlAuthorStart,ViewUrlAuthorEnd,ViewUrlContentStart,ViewUrlContentEnd) Values ("+Values+")");
						labelAddInfor.Text = "已添加！";
						Response.Redirect("CollectRule.aspx");
					}
					else{
						Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning')</script>");
					}
				}
				else {
					labelAddInfor.Text = "采集规则没有填写完整!";
					Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','采集规则没有填写完整!','Error')</script>");
				}
			}
			
		}
		
		///显示节点+孩子节点
		private void showNodes(ClassTreeNode node)
        {
			this.showNodesFunction(node);
			///this.myLabel.Text = treeStr;
			
		}
		///显示节点递归函数
		private void showNodesFunction(ClassTreeNode node)
        {			
			DataRow [] rows = dt.Select("fatherId = '"+node.ID+"'");///筛选node的孩子节点 
			string spaceStr = "";
			foreach(DataRow dr in rows)///循环孩子节点
            {
				ClassTreeNode childNd;
				childNd.ID = dr["id"].ToString();                    ///孩子节点ID
                childNd.Name = dr["name"].ToString();                ///孩子节点Name
				childNd.OutLinkHref = dr["outLinkHref"].ToString();  ///孩子节点外链OutLinkHref
				childNd.Level = node.Level+1; 
				spaceStr = "";
				///孩子节点Level
				for(int i=0;i<childNd.Level;i++){
					spaceStr += "　 ";
				}
				///添加栏目下拉菜单
				///判断当前节点是否有孩子节点
				bool isFather = dr["childID"].ToString().Contains(",");
				if(isFather){
					ListItem li=new ListItem(spaceStr+"├ "+childNd.Name+"*","Enable"+childNd.ID);
					li.Attributes.Add("style","color:#1081BC;");
					this.dropListClassName.Items.Add(li);
				}
				else{
					ListItem li=new ListItem(spaceStr+"├ "+childNd.Name+"",childNd.ID);
					this.dropListClassName.Items.Add(li);
				}
				this.showNodesFunction(childNd);//递归调用自身  
            }
		}
	}
	//End DeepSoonCollectRuleAdd Class
	
	/* 
	类名: CollectRuleExec 
	功能：内容采集类
	作者：书红
	*/
	//Start CollectRuleExec Class
	public partial class CollectRuleExec : PageBase
    {
		///创建数据连接对象：
		MysqlHelp mh = new MysqlHelp();
		DataTable dt = new DataTable();
		string ID = null;
		string ruleName = "";
		string charSet = "";
		string classID = "";
		string className = "";
		string entranceUrl = "";
		string listUrlStart = "";
		string listUrlEnd = "";
					
		string viewUrlTitleStart = "";
		string viewUrlTitleEnd = "";
		string viewUrlSourceStart = "";
		string viewUrlSourceEnd = "";
		string viewUrlDateStart = "";
		string viewUrlDateEnd = "";
		string viewUrlAuthorStart = "";
		string viewUrlAuthorEnd = "";
		string viewUrlArticleStart = "";
		string viewUrlArticleEnd = "";
		
		List<string> links = new List<string>();
		
		///输入url,chaset获取html文本
		protected string getHtmlFromUrl(string urlStr,string chasetStr){
			WebRequest request = WebRequest.Create(urlStr); //WebRequest.Create方法，返回WebRequest的子类HttpWebRequest
			WebResponse response = request.GetResponse(); //WebRequest.GetResponse方法，返回对 Internet 请求的响应
			Stream resStream = response.GetResponseStream(); //WebResponse.GetResponseStream 方法，从 Internet 资源返回数据流。 
			Encoding enc = Encoding.GetEncoding(chasetStr); // 如果是乱码就改成 utf-8 / GB2312
			StreamReader sr = new StreamReader(resStream, enc); //命名空间:System.IO。 StreamReader 类实现一个 TextReader (TextReader类，表示可读取连续字符系列的读取器)，使其以一种特定的编码从字节流中读取字符。 
			string htmlValueStr = sr.ReadToEnd(); //输出(HTML代码)，ContentHtml为Multiline模式的TextBox控件
			resStream.Close(); 
			sr.Close();
			return htmlValueStr;
		}
		
		protected void Page_Load(object sender, EventArgs e)
        {
			ID = Request.QueryString["ID"];
			
			if(!IsPostBack){
				
			}
			
			DeepSoonHelp dh = new DeepSoonHelp();
			if(ID != null && dh.notHasSQLInsertCode(ID)){
				///查询数据库
				dt = mh.GetDatabysql("Select CollectRule4DeepSoon.*,Class4DeepSoon.Name From CollectRule4DeepSoon,Class4DeepSoon Where CollectRule4DeepSoon.ClassID = Class4DeepSoon.ID and CollectRule4DeepSoon.ID="+ID);
				ruleName = ""+dt.Rows[0]["Title"];
				charSet = ""+dt.Rows[0]["CharSet"];
				classID = ""+dt.Rows[0]["ClassID"];
				className = ""+dt.Rows[0]["Name"];
				entranceUrl = ""+dt.Rows[0]["EntranceUrl"];
				listUrlStart = ""+dt.Rows[0]["ListUrlStart"];
				listUrlEnd = ""+dt.Rows[0]["ListUrlEnd"];
				
				viewUrlTitleStart = ""+dt.Rows[0]["ViewUrlTitleStart"];
				viewUrlTitleEnd = ""+dt.Rows[0]["ViewUrlTitleEnd"];
				viewUrlSourceStart = ""+dt.Rows[0]["ViewUrlSourceStart"];
				viewUrlSourceEnd = ""+dt.Rows[0]["ViewUrlSourceEnd"];
				viewUrlDateStart = ""+dt.Rows[0]["ViewUrlDateStart"];
				viewUrlDateEnd = ""+dt.Rows[0]["ViewUrlDateEnd"];
				viewUrlAuthorStart = ""+dt.Rows[0]["ViewUrlAuthorStart"];
				viewUrlAuthorEnd = ""+dt.Rows[0]["ViewUrlAuthorEnd"];
				viewUrlArticleStart = ""+dt.Rows[0]["ViewUrlContentStart"];
				viewUrlArticleEnd = ""+dt.Rows[0]["ViewUrlContentEnd"];
					
				///获取links的html文本：
				string listURLHtml = getHtmlFromUrl(entranceUrl,charSet);
				string listURLPattern = listUrlStart+@"([\s\S]*?)"+listUrlEnd;
				MatchCollection listURLMatches = Regex.Matches(listURLHtml,listURLPattern, RegexOptions.IgnoreCase);
				string contentStr = "";
				int countInt = 0;
				///提取含有url网址的区块
				foreach (Match match in listURLMatches){
					string urlHtml = match.Groups[1].Value;
					string urlPattern = "href=\"([^\"]*?)\"";
					MatchCollection urlMatches = Regex.Matches(urlHtml,urlPattern, RegexOptions.IgnoreCase);
					///提取a标签的所有href属性值
					foreach (Match urlMatch in urlMatches){
						contentStr += "<div style='background-color:#F5F5F5;border:1px dotted #D3D3D3;padding:10px;margin-bottom:20px;'>";
						
						contentStr += "【采集编号】"+(countInt+1)+"<br>";
						///根据提取的网址获取内容页数据
						string urlStr= urlMatch.Groups[1].Value.ToLower().Replace("div", "span");
						contentStr += "【目标网址】<a href='"+urlStr+"' target='_blank'>"+urlStr+"</a><br>";
						
						links.Add(urlStr);
						
						///contentStr += urlStr+"<br>";
						string contentHtml = getHtmlFromUrl(urlStr,charSet);
						///获取标题字段
						Regex titleRegex = new Regex(viewUrlTitleStart+@"([\s\S]*?)"+viewUrlTitleEnd);
						Match titleMatch = titleRegex.Match(contentHtml);
						string titleStr = titleMatch.Groups[1].Value.ToLower().Replace("'","").Replace("<","&lt;").Replace(">","&gt;");	
						contentStr += "【文章标题】"+titleStr+"<br>";
						///获取来源字段
						Regex sourceRegex = new Regex(viewUrlSourceStart+@"([\s\S]*?)"+viewUrlSourceEnd);
						Match sourceMatch = sourceRegex.Match(contentHtml);
						string sourceStr = sourceMatch.Groups[1].Value.ToLower().Replace("'","").Replace("<","&lt;").Replace(">","&gt;");	
						contentStr += "【文章来源】"+sourceStr+"<br>";
						///获取发布时间字段
						Regex dateRegex = new Regex(viewUrlDateStart+@"([\s\S]*?)"+viewUrlDateEnd);
						Match dateMatch = dateRegex.Match(contentHtml);
						string dateStr = dateMatch.Groups[1].Value.ToLower().Replace("'","").Replace("<","&lt;").Replace(">","&gt;");	
						contentStr += "【发布时间】"+dateStr+"<br>";
						///获取作者字段
						Regex authorRegex = new Regex(viewUrlAuthorStart+@"([\s\S]*?)"+viewUrlAuthorEnd);
						Match authorMatch = authorRegex.Match(contentHtml);
						string authorStr = authorMatch.Groups[1].Value.ToLower().Replace("'","").Replace("<","&lt;").Replace(">","&gt;");	
						contentStr += "【文章作者】"+authorStr+"<br>";
						///获取正文字段
						Regex articleRegex = new Regex(viewUrlArticleStart+@"([\s\S]*?)"+viewUrlArticleEnd);
						Match articleMatch = articleRegex.Match(contentHtml);
						string articleStr = articleMatch.Groups[1].Value.ToLower().Replace("'", "").Replace("div", "p");
						contentStr += "【文章正文】<br><div style='height:500px;overflow-y:hidden;background-color:#FFFFFF;padding:10px;'>"+articleStr+"</div>";
						
						contentStr += "</div>";
						countInt ++;
					}///end for
				}///end for
				string resultStr = "<div style='margin-top:10px;margin-bottom:10px;padding:10px;'>";
				resultStr += "【采集标题】"+ruleName+"<br>";
				resultStr += "【采集网址】<a href='"+entranceUrl+"' target='_blank'>"+entranceUrl+"</a><br>";
				resultStr += "【采集编码】"+charSet+"<br>";
				resultStr += "【采集结果】共采集到"+countInt+"篇文档<br>";
				resultStr += "【导入栏目】"+className+"<br>";
				resultStr += "【操作提示】采集的数据批量导入栏目后，不可撤销，请谨慎操作。";
				resultStr += "</div>";
				this.labelCollectResult.Text = resultStr;
				this.labelContent.Text = "<div style='margin-top:20px;'>"+contentStr+"</div>";					 
			}///end if
			
			btnAdd.Attributes.Add("onclick","return confirm(\"采集的数据批量导入对应栏目后，数据无法撤销，您确定导入吗？\")") ;
			
        }
		
		/// 获取文中图片地址
		public static string getImageUrl(string content)
		{ 
			string imgSrcValue = "";
			MatchCollection mc = Regex.Matches(content, @"<img(?:(?!src).)*src=(['""]?)(?<path>.*?)/(?<name>[^/\s'""]*)\1", RegexOptions.IgnoreCase);
			if( mc.Count > 0){
				Match m = mc[0];
				imgSrcValue += m.Groups["path"].Value + "/";
				imgSrcValue += m.Groups["name"].Value;
			}
			return imgSrcValue;
		} 
	
		protected void btnAdd_Click(object sender, EventArgs e)
        {
			///操作权限检测
			if( hasRightTo("CollectRuleExec","执行采集规则录入") ){
				foreach(string link in links){ 
					string contentHtml = getHtmlFromUrl(link,charSet);
					///获取标题字段
					Regex titleRegex = new Regex(viewUrlTitleStart+@"([\s\S]*?)"+viewUrlTitleEnd);
					Match titleMatch = titleRegex.Match(contentHtml);
					string titleStr = titleMatch.Groups[1].Value.ToLower().Replace("'","").Replace("<","&lt;").Replace(">","&gt;");	
					///获取来源字段
					Regex sourceRegex = new Regex(viewUrlSourceStart+@"([\s\S]*?)"+viewUrlSourceEnd);
					Match sourceMatch = sourceRegex.Match(contentHtml);
					string sourceStr = sourceMatch.Groups[1].Value.ToLower().Replace("'","").Replace("<","&lt;").Replace(">","&gt;");
					///获取发布时间字段
					Regex dateRegex = new Regex(viewUrlDateStart+@"([\s\S]*?)"+viewUrlDateEnd);
					Match dateMatch = dateRegex.Match(contentHtml);
					string dateStr = dateMatch.Groups[1].Value.ToLower().Replace("'","").Replace("<","&lt;").Replace(">","&gt;");	
					///获取作者字段
					Regex authorRegex = new Regex(viewUrlAuthorStart+@"([\s\S]*?)"+viewUrlAuthorEnd);
					Match authorMatch = authorRegex.Match(contentHtml);
					string authorStr = authorMatch.Groups[1].Value.ToLower().Replace("'","").Replace("<","&lt;").Replace(">","&gt;");	
					///获取正文字段
					Regex articleRegex = new Regex(viewUrlArticleStart+@"([\s\S]*?)"+viewUrlArticleEnd);
					Match articleMatch = articleRegex.Match(contentHtml);
					string articleStr = articleMatch.Groups[1].Value;
				
					string thumbnailImage = getImageUrl(articleStr);
					articleStr = articleStr.ToLower().Replace("'","");
				
					string briefInfor = articleStr.ToLower().Replace("<","&lt;").Replace(">","&gt;").Replace("img", "图片"); 
					if(briefInfor.Length>120)briefInfor = briefInfor.Substring(0,120);
				
					if(titleStr != "" && articleStr != "" && briefInfor != ""){
						string Values = "'"+titleStr+"','"+sourceStr+"','"+authorStr+"','"+classID+"','"+articleStr+"','"+briefInfor+"','"+thumbnailImage+"',True";
						///创建数据连接对象：
						MysqlHelp mh = new MysqlHelp();
						mh.Runsql("Insert Into Article4DeepSoon(Title,Source,Author,ClassID,Article,BriefInfor,thumbnailImage,isPass) Values ("+Values+")");
					}///end if
				}
				this.labelAddInfor.Text = "已将采集到的数据成功导入对应栏目!";
				Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','已将采集到的数据成功导入对应栏目!','OK')</script>");
			}
			else{
				Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning')</script>");
			}
		}///end btnAdd_Click
	}
	//End CollectRuleExec Class
	
	
	/* 
	类名: CollectRuleUpdate 
	功能：采集规则更新类
	作者：书红
	*/
	//Start CollectRuleUpdate Class
	public partial class CollectRuleUpdate : PageBase
    {
		///创建数据连接对象：
		MysqlHelp mh = new MysqlHelp();
		DataTable dt = new DataTable();
		string ID = null;
		
		///定义树节点的结构体
		struct ClassTreeNode{
			public string ID;
			public string Name;
			public string OutLinkHref;
			public int Level;
		}
		
		protected void Page_Load(object sender, EventArgs e)
        {
			ID = Request.QueryString["ID"];
			
			if(!IsPostBack){
				dt = mh.GetDatabysql("Select * From Class4DeepSoon Order By Id");
				///显示ID=?的节点+孩子节点，并设定层级初值level
				ClassTreeNode nd;
				nd.ID="0";               ///节点ID
				nd.Name="请选择所属栏目";        ///节点Name
				nd.OutLinkHref = "";     ///节点外链OutLinkHref
				nd.Level=0;              ///节点Level
				///添加栏目下拉菜单
				ListItem li=new ListItem(nd.Name,"Enable"+nd.ID);
				li.Attributes.Add("style","color:#1081BC;");
				this.dropListClassName.Items.Add(li);
				showNodes(nd);
				
				DeepSoonHelp dh = new DeepSoonHelp();
				if(ID != null && dh.notHasSQLInsertCode(ID)){
					///查询数据库
					dt = mh.GetDatabysql("Select * From CollectRule4DeepSoon Where ID="+ID);
					string ruleName = ""+dt.Rows[0]["Title"];
					string charSet = ""+dt.Rows[0]["CharSet"];
					string classId = ""+dt.Rows[0]["ClassId"];
					string entranceUrl = ""+dt.Rows[0]["EntranceUrl"];
					string listUrlStart = ""+dt.Rows[0]["ListUrlStart"];
					string listUrlEnd = ""+dt.Rows[0]["ListUrlEnd"];
					
					string viewUrlTitleStart = ""+dt.Rows[0]["ViewUrlTitleStart"];
					string viewUrlTitleEnd = ""+dt.Rows[0]["ViewUrlTitleEnd"];
					string viewUrlSourceStart = ""+dt.Rows[0]["ViewUrlSourceStart"];
					string viewUrlSourceEnd = ""+dt.Rows[0]["ViewUrlSourceEnd"];
					string viewUrlDateStart = ""+dt.Rows[0]["ViewUrlDateStart"];
					string viewUrlDateEnd = ""+dt.Rows[0]["ViewUrlDateEnd"];
					string viewUrlAuthorStart = ""+dt.Rows[0]["ViewUrlAuthorStart"];
					string viewUrlAuthorEnd = ""+dt.Rows[0]["ViewUrlAuthorEnd"];
					string viewUrlArticleStart = ""+dt.Rows[0]["ViewUrlContentStart"];
					string viewUrlArticleEnd = ""+dt.Rows[0]["ViewUrlContentEnd"];
					
					
					///初始化表单数据
					ListItem item=this.charSet.Items.FindByValue(charSet);
					if(item != null)
					{
						item.Selected = true;
					}
					ListItem classItem=this.dropListClassName.Items.FindByValue(classId);
					if(classItem != null)
					{
						classItem.Selected = true;
					}
					this.ruleName.Text = ruleName;
					this.entranceUrl.Text = entranceUrl;
					this.listUrlStart.Text = listUrlStart;
					this.listUrlEnd.Text = listUrlEnd;
					this.viewUrlTitleStart.Text = viewUrlTitleStart;
					this.viewUrlTitleEnd.Text = viewUrlTitleEnd;
					this.viewUrlSourceStart.Text = viewUrlSourceStart;
					this.viewUrlSourceEnd.Text = viewUrlSourceEnd;
					this.viewUrlDateStart.Text = viewUrlDateStart;
					this.viewUrlDateEnd.Text = viewUrlDateEnd;
					this.viewUrlAuthorStart.Text = viewUrlAuthorStart;
					this.viewUrlAuthorEnd.Text = viewUrlAuthorEnd;
					this.viewUrlArticleStart.Text = viewUrlArticleStart;
					this.viewUrlArticleEnd.Text = viewUrlArticleEnd;
				}
			}
        }
		
		protected void btnUpdate_Click(object sender, EventArgs e)
        {
			string ruleName = this.ruleName.Text.Replace("'", "");
			string charSet = this.charSet.Text.Replace("'", "");
			string classId = this.dropListClassName.SelectedItem.Value;
			string entranceUrl = this.entranceUrl.Text.Replace("'", "");
			
			string listUrlStart = this.listUrlStart.Text.Replace("'", "");
			string listUrlEnd = this.listUrlEnd.Text.Replace("'", "");
			
			string viewUrlTitleStart = this.viewUrlTitleStart.Text.Replace("'", "");
			string viewUrlTitleEnd = this.viewUrlTitleEnd.Text.Replace("'", "");
			string viewUrlSourceStart = this.viewUrlSourceStart.Text.Replace("'", "");
			string viewUrlSourceEnd = this.viewUrlSourceEnd.Text.Replace("'", "");
			string viewUrlDateStart = this.viewUrlDateStart.Text.Replace("'", "");
			string viewUrlDateEnd = this.viewUrlDateEnd.Text.Replace("'", "");
			string viewUrlAuthorStart = this.viewUrlAuthorStart.Text.Replace("'", "");
			string viewUrlAuthorEnd = this.viewUrlAuthorEnd.Text.Replace("'", "");
			string viewUrlArticleStart = this.viewUrlArticleStart.Text.Replace("'", "");
			string viewUrlArticleEnd = this.viewUrlArticleEnd.Text.Replace("'", "");
			
			bool classIdEnable = classId.Contains("Enable");
			
			if(classIdEnable){
				labelUpdateInfor.Text = "选择的导入栏目不合法,不允许外部栏目!";
				Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','选择的导入栏目不合法,不允许外部栏目!','Error')</script>");
			}
			else{
				if(ruleName != "" && charSet != "" && entranceUrl != "" &&listUrlStart != "" && listUrlEnd != "" && viewUrlTitleStart != "" && viewUrlTitleEnd != "" && viewUrlSourceStart != "" && viewUrlSourceEnd != "" && viewUrlDateStart != "" && viewUrlDateEnd != "" && viewUrlAuthorStart != "" && viewUrlAuthorEnd != "" && viewUrlArticleStart != ""  && viewUrlArticleEnd != "" ){
					///操作权限检测
					if( hasRightTo("CollectRuleUpdate","更新采集规则") ){
						///创建数据连接对象：
						MysqlHelp mh = new MysqlHelp();
						mh.Runsql("Update CollectRule4DeepSoon Set Title='"+ruleName+"',CharSet='"+charSet+"',ClassId='"+classId+"',EntranceUrl='"+entranceUrl+"',ListUrlStart='"+listUrlStart+"',ListUrlEnd='"+listUrlEnd+"',ViewUrlTitleStart='"+viewUrlTitleStart+"',ViewUrlTitleEnd='"+viewUrlTitleEnd+"',ViewUrlSourceStart='"+viewUrlSourceStart+"',viewUrlSourceEnd='"+viewUrlSourceEnd+"',ViewUrlDateStart='"+viewUrlDateStart+"',viewUrlDateEnd='"+viewUrlDateEnd+"',ViewUrlAuthorStart='"+viewUrlAuthorStart+"',ViewUrlAuthorEnd='"+viewUrlAuthorEnd+"',ViewUrlContentStart='"+viewUrlArticleStart+"',ViewUrlContentEnd='"+viewUrlArticleEnd+"' Where ID="+ID);
						labelUpdateInfor.Text = "采集规则已保存!";
						Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','采集规则已保存!','OK')</script>");
					}
					else{
						Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning')</script>");
					}
				}
				else {
					labelUpdateInfor.Text = "采集规则没有填写完整!";
					Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','采集规则没有填写完整!','Error')</script>");
				}
			}
			
		}
		
		///显示节点+孩子节点
		private void showNodes(ClassTreeNode node)
        {
			this.showNodesFunction(node);
			///this.myLabel.Text = treeStr;
			
		}
		///显示节点递归函数
		private void showNodesFunction(ClassTreeNode node)
        {			
			DataRow [] rows = dt.Select("fatherId = '"+node.ID+"'");///筛选node的孩子节点 
			string spaceStr = "";
			foreach(DataRow dr in rows)///循环孩子节点
            {
				ClassTreeNode childNd;
				childNd.ID = dr["id"].ToString();                    ///孩子节点ID
                childNd.Name = dr["name"].ToString();                ///孩子节点Name
				childNd.OutLinkHref = dr["outLinkHref"].ToString();  ///孩子节点外链OutLinkHref
				childNd.Level = node.Level+1; 
				spaceStr = "";
				///孩子节点Level
				for(int i=0;i<childNd.Level;i++){
					spaceStr += "　 ";
				}
				///添加栏目下拉菜单
				///判断当前节点是否有孩子节点
				bool isFather = dr["childID"].ToString().Contains(",");
				if(isFather){
					ListItem li=new ListItem(spaceStr+"├ "+childNd.Name+"*","Enable"+childNd.ID);
					li.Attributes.Add("style","color:#1081BC;");
					this.dropListClassName.Items.Add(li);
				}
				else{
					ListItem li=new ListItem(spaceStr+"├ "+childNd.Name+"",childNd.ID);
					this.dropListClassName.Items.Add(li);
				}
				this.showNodesFunction(childNd);//递归调用自身  
            }
		}
		
	}
	//End CollectRuleUpdate Class
	
	
	
}