﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Configuration;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls.WebParts;
using MySql.Data.MySqlClient;
using System.Text.RegularExpressions; 

using Security;
namespace Security
{
	/* 
	类名: ClassAdmin 
	功能：内容分类类
	作者：书红
	*/
	//Start ClassAdmin Class
    public partial class ClassAdmin : PageBase
    {
		MysqlHelp mh = null;
		DataTable dt = null;
		string treeStr = "";
		
		///定义树节点的结构体
		struct ClassTreeNode{
			public string ID;
			public string Name;
			public string OutLinkHref;
			public int Level;
		}
		
		protected void Page_Load(object sender, EventArgs e)
        {
			if (!IsPostBack) 
			{ 
				
			}
			
			btnDelAll.Attributes.Add("onclick","return confirm(\"清除所有频道栏目，数据无法恢复，您确定清空吗？\")") ;
			
			mh = new MysqlHelp();
			dt = mh.GetDatabysql("Select * From Class4DeepSoon Order By Id");
			
			    
            string delID = Request.QueryString["delID"];
			string delName = Request.QueryString["delName"];
			
			DeepSoonHelp dh = new DeepSoonHelp();
			if(dh.notHasSQLInsertCode(delID) && dh.notHasSQLInsertCode(delName) && delID != null && delName != null){
				///Response.Write("取得删除节点信息：ID="+delID+" Name="+delName+"<br>");
				
				///递归方式，删除相关ID
				ClassTreeNode DelNd;
				DelNd.ID = ""+delID;       ///节点ID
				DelNd.Name = ""+delName;   ///节点Name
				DelNd.OutLinkHref = "";    ///节点外链OutLinkHref
				DelNd.Level = 0;           ///节点深度Level
				///操作权限检测
				if( hasRightTo("ClassTreeDelete","删除分类") ){
					deleteNodes(DelNd);
				}
				else{
					Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning')</script>");
				}
			}
				
			///显示ID=?的节点+孩子节点，并设定层级初值level
			ClassTreeNode nd;
            nd.ID="0";               ///节点ID
            nd.Name="门户网";        ///节点Name
			nd.OutLinkHref = "";     ///节点外链OutLinkHref
			nd.Level=-1;              ///节点Level
			///操作权限检测
			if( hasRightTo("ClassTreeSelect","查看分类列表") ){
				showNodes(nd);
			}
			else{
				Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning')</script>");
			}
        }
		
		///显示节点+孩子节点
		private void showNodes(ClassTreeNode node)
        {
			this.showNodesFunction(node);
			this.myLabel.Text = treeStr;
			
		}
		///显示节点递归函数
		private void showNodesFunction(ClassTreeNode node)
        {			
			DataRow [] rows = dt.Select("fatherId = '"+node.ID+"'");///筛选node的孩子节点 
			foreach(DataRow dr in rows)///循环孩子节点
            {
				ClassTreeNode childNd;
				childNd.ID = dr["id"].ToString();                    ///孩子节点ID
                childNd.Name = dr["name"].ToString();                ///孩子节点Name
				childNd.OutLinkHref = dr["outLinkHref"].ToString();  ///孩子节点外链OutLinkHref
				childNd.Level = node.Level+1;                        ///孩子节点Level
				
				string isHiddenStr = dr["isHidden"].ToString();  ///孩子节点是否可见
				string isVisuableStr = "<img src='../images/True.png' title='前台导航栏可见'>";
				if(isHiddenStr=="True")isVisuableStr = "<img src='../images/False.png' title='导航栏不可见'>";
				string OutLinkHrefStr = dr["OutLinkHref"].ToString();  ///孩子节点是否有外链
				string OutLinkHrefStat = "&nbsp;";
				///获取栏目URL地址
				string viewURL = "../list-"+childNd.ID+"-0.aspx";
				if(OutLinkHrefStr != ""){
					OutLinkHrefStat = "<img src='../images/createlink.gif' title='是外链栏目'>";
					viewURL = OutLinkHrefStr;
				}
				
				///统计记录数
				DataTable IDSetDt=new DataTable();
				IDSetDt = mh.GetDatabysql("Select ChildID From Class4DeepSoon  Where ID='"+childNd.ID+"'");
				string IDSet = "(" +IDSetDt.Rows[0]["ChildID"].ToString()+")";
				DataTable countDt=new DataTable();
				countDt = mh.GetDatabysql("Select Count(ID) As CountNum From Article4DeepSoon Where ClassID in"+IDSet);
				string countResult = countDt.Rows[0]["CountNum"].ToString();
				
				treeStr += "<tr onMouseOver='this.style.backgroundColor=\"#F0F0F0\"' onMouseOut='this.style.backgroundColor=\"#FFFFFF\"' >";
				treeStr += "<td style='width:80px;'>"+childNd.ID+"</td><td>";
				for(int i=0;i<childNd.Level;i++){
					treeStr += "&nbsp;&nbsp;&nbsp;&nbsp;";
				}
				if(childNd.Level > 0)
					treeStr += "<img src='../images/nodeIcon.png' style='margin-bottom:-5px;'> ";
				else
					treeStr += "<img src='../images/listIcon.png' style='margin-bottom:-5px;'> "; 
				treeStr += childNd.Name + "<a href='../"+viewURL+"' target='_blank'>("+countResult+")</a></td><td style='width:40px;'>"+OutLinkHrefStat+"</td><td style='width:40px;'>"+isVisuableStr+"</td><td style='width:170px;'><a href='ClassAdd.aspx?addID="+childNd.ID+"&addName="+childNd.Name+"'>创建子栏目</a> | <a href='ClassUpdate.aspx?updateID="+childNd.ID+"&updateName="+childNd.Name+"'>修改</a>  | <a href='ClassAdmin.aspx?delID="+childNd.ID+"&delName="+childNd.Name+"' onclick='return confirm(\"删除栏目后无法恢复，确定删除吗？\")'>删除</a></td>";
				treeStr += "</tr>";
				this.showNodesFunction(childNd);//递归调用自身  
            }
		}		
		
		///删除节点及其包含的子节点
		private void deleteNodes(ClassTreeNode node)
        {
			Response.Write("<font color=red>删除"+node.Name+" ID="+node.ID+" 执行SQL：Delete from tree where ID="+node.Name+"</font><br>");
			///删除node记录：
			mh.Runsql("Delete From Class4DeepSoon Where ID="+node.ID);
			///重新搜索数据表
			dt = mh.GetDatabysql("Select * From Class4DeepSoon Order By Id");
			///更新数据库的childId字段
			for(int i=0;i<dt.Rows.Count;i++){
				string opId = dt.Rows[i]["Id"].ToString();
				string oldChildId = dt.Rows[i]["childId"].ToString();
				string newChildId = oldChildId.Replace(","+node.ID, "");
				mh.Runsql("Update Class4DeepSoon Set ChildId='"+newChildId+"' Where ID="+opId);
			}
			this.deleteNodesFunction(node);
			Response.Redirect("ClassAdmin.aspx");
		}
		///删除节点递归函数：
		private void deleteNodesFunction(ClassTreeNode node)
        {
			DataRow [] rows = dt.Select("fatherId = '"+node.ID+"'"); //筛选出属于父节点 “node”的孩子节点
            foreach(DataRow dr in rows) ///循环孩子节点
            {
                ClassTreeNode childNd;
				childNd.ID = dr["id"].ToString();                    ///孩子节点ID
                childNd.Name = dr["name"].ToString();                ///孩子节点Name
				childNd.OutLinkHref = dr["outLinkHref"].ToString();  ///孩子节点外链OutLinkHref
				childNd.Level = node.Level+1;                        ///孩子节点Level
				Response.Write("<font color=red>删除"+childNd.Name+" ID="+childNd.ID+" 执行SQL：Delete from tree where ID="+childNd.ID+"</font><br>");
				///删除nd记录：
				mh.Runsql("Delete From Class4DeepSoon Where ID="+childNd.ID);
				///重新搜索数据表
				dt = mh.GetDatabysql("Select * From Class4DeepSoon Order By Id");
				///更新数据库的childId字段
				for(int i=0;i<dt.Rows.Count;i++){
					string opId = dt.Rows[i]["Id"].ToString();
					string oldChildId = dt.Rows[i]["childId"].ToString();
					string newChildId = oldChildId.Replace(","+childNd.ID, "");
					mh.Runsql("Update Class4DeepSoon Set ChildId='"+newChildId+"' Where ID="+opId);
				}
				this.deleteNodesFunction(childNd);    ///递归调用自身
            }
		}
		
		
		protected void btnDelAll_Click(object sender, EventArgs e)
		{
			///操作权限检测
			if( hasRightTo("ClassTreeDelete","删除分类") ){
				mh.Runsql("Truncate Table Class4DeepSoon");
				Response.Redirect("ClassAdmin.aspx");
			}
			else{
				Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning')</script>");
			}
		}
    }
	//End ClassAdmin Class
	
	
	/* 
	类名: ClassAdd 
	功能：内容分类添加类
	作者：书红
	*/
	//Start ClassAdd Class
	public partial class ClassAdd : PageBase
    {
		MysqlHelp mh = null;
		DataTable dt = null;
		protected void Page_Load(object sender, EventArgs e)
		{
			if(!IsPostBack)
            {
			
            }
			///获取数据源
			mh = new MysqlHelp();
			dt = mh.GetDatabysql("Select * From Class4DeepSoon");
			
			string addID = Request.QueryString["addID"];
			string addName = Request.QueryString["addName"];
			
			DeepSoonHelp dh = new DeepSoonHelp();
			if(dh.notHasSQLInsertCode(addID) && dh.notHasSQLInsertCode(addName) && addID != null && addName != null){
			
				///初始化表单数据
				this.labelAddInfor.Text = "在【"+addName+"】下创建子栏目";
				this.txtFatherName.Text = addName;
				this.txtFatherID.Text = addID;
			}
			
        }
		
		///添加新节点时，更新其父节点的childID字段
		private void updateChildId4AddFunction(TreeNode node,string NodeId,string addChildId)
        {
			DataRow [] rows = dt.Select("Id = '"+NodeId+"'"); //筛选出当前节点的父亲节点数据
			///创建父亲节点
            foreach(DataRow dr in rows) //循环子节点集合
            {
				TreeNode nd = new TreeNode();
				nd.Value=dr["fatherId"].ToString();//父亲节点ID
				nd.Text=dr["name"].ToString();//父亲节点Name
				if(nd.Value != "0")///id=0表示到达最顶的根
				{
					///获取间接父亲节点的原childID值：
					DataTable fatherData = mh.GetDatabysql("Select childId From Class4DeepSoon Where Id="+nd.Value);
					string fatherChildID = ""+fatherData.Rows[0]["childID"];
					///新ChildId值：
					string newFatherChildID = fatherChildID+","+addChildId;
					Response.Write("<font color=red>更新间接父亲节点(Id="+nd.Value+")的childId: "+newFatherChildID+"</font><br>");
					mh.Runsql("Update Class4DeepSoon Set childId='"+newFatherChildID+"' Where Id="+nd.Value);
				
					this.updateChildId4AddFunction(nd,nd.Value,addChildId);    //递归调用自身
				}
            }
		}

		protected void btnAdd_Click(object sender, EventArgs e)
		{
			string menuName = this.txtName.Text.Replace("'", "");
			if(menuName.Length>20)menuName = menuName.Substring(0,20);
			string briefInformation = this.txtBriefInformation.Text.Replace("'", "");
			string fatherID = this.txtFatherID.Text;
			string outLinkHref = this.txtOutLinkHref.Text.Replace("'", "");
			if(outLinkHref.Length>250)outLinkHref = outLinkHref.Substring(0,250);
			string childID = "";
			string isHidden = this.dropIsHidden.SelectedItem.Value;
			string linkTarget = this.dropLinkTarget.SelectedItem.Value;
			string openArea = this.dropOpenArea.SelectedItem.Value;
			string themeFile = this.txtThemeFile.Text.Replace("'", "");
			
			if(menuName != "" && themeFile != ""){
				Regex reg = new Regex("^[\u4e00-\u9fa5a-zA-Z0-9]+$");
				if (reg.IsMatch(menuName)){///判断是否为汉字/字母/数字的组合
					
					///操作权限检测
					if( hasRightTo("ClassTreeAdd","添加分类") ){
						///添加新栏目：
						mh.Runsql("Insert Into Class4DeepSoon(Name,fatherID,OutLinkHref,isHidden,ThemeFile,linkTarget,openArea,BriefInformation) Values('"+menuName+"','"+fatherID+"','"+outLinkHref+"',"+isHidden+",'"+themeFile+"','"+linkTarget+"','"+openArea+"','"+briefInformation+"')");
						this.labelAddInfor.Text = "新栏目 "+menuName+" 已经成功添加!";
								
						Response.Write("更新新栏目自身的ChildID<br>");
						DataTable newNodeData = mh.GetDatabysql("Select * From Class4DeepSoon order by id desc limit 1");
						string currNodeID = ""+newNodeData.Rows[0]["Id"];
						mh.Runsql("Update Class4DeepSoon Set childId='"+currNodeID+"' Where Id="+currNodeID);
						Response.Write("自身ChildID="+currNodeID+"<br>");
				
						if(fatherID != "0"){///如果其直接父节点不是顶端根目录,其根节点ID=父亲节点的根节点ID
							DataTable rootIDData = mh.GetDatabysql("Select rootID From Class4DeepSoon where Id='"+fatherID+"'");
							string fatherNodRootID = ""+rootIDData.Rows[0]["rootID"];
							mh.Runsql("Update Class4DeepSoon Set rootID='"+fatherNodRootID+"' Where Id="+currNodeID);
						}
						else{
							mh.Runsql("Update Class4DeepSoon Set rootID='"+currNodeID+"' Where Id="+currNodeID);
						}
				
						Response.Write("新栏目的ID是"+currNodeID+" 其直接父亲节点是"+fatherID+" <br>");
						if(fatherID != "0"){///如果其直接父节点不是顶端根目录
							///获取直接父亲节点的原childID值：
							DataTable fatherData = mh.GetDatabysql("Select childId From Class4DeepSoon Where Id="+fatherID);
							string fatherChildID = ""+fatherData.Rows[0]["childID"];
							///新ChildId值：
							string newFatherChildID = fatherChildID+","+currNodeID;
							Response.Write("<font color=red>更新直接父亲节点(Id="+fatherID+")的childId: "+newFatherChildID+"</font><br>");
							mh.Runsql("Update Class4DeepSoon Set childId='"+newFatherChildID+"' Where Id="+fatherID);
						}
						///递归方式，修改间接父亲节点的childID
						TreeNode updateNd = new TreeNode();
						updateNd.Value=""+fatherID;//当前节点ID
						updateNd.Text=""+menuName;//当前节点Name
						this.updateChildId4AddFunction(updateNd,updateNd.Value,currNodeID);
				
						///添加成功，跳转到栏目树
						Response.Redirect("ClassAdmin.aspx");
					}
					else{
						Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning')</script>");
					}			
				}
				else{
					this.labelAddInfor.Text = "栏目名称只允许输入汉字/字母/数字的组合,不允许其他字符!";
					Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','栏目名称只允许输入汉字/字母/数字的组合,不允许其他字符!','Warning')</script>");
				}
			}
			else{
				this.labelAddInfor.Text = "新栏目名称不能为空!";
				Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','新栏目名称不能为空!','Error')</script>");
			}
		}

	}//end class
	//End ClassAdd Class
	
	
	/* 
	类名: ClassUpdate 
	功能：内容分类更新类
	作者：书红
	*/
	//Start ClassUpdate Class
	public partial class ClassUpdate : PageBase
    {
		MysqlHelp mh = null;
		DataTable dt = null;
		protected void Page_Load(object sender, EventArgs e)
		{
			if(!IsPostBack)
            {
				string updateID = Request.QueryString["updateID"];
				string updateName = Request.QueryString["updateName"];
				
				DeepSoonHelp dh = new DeepSoonHelp();
				if(dh.notHasSQLInsertCode(updateID) && dh.notHasSQLInsertCode(updateName) && updateID != null && updateName != null){			
					///获取数据源
					mh = new MysqlHelp();
					dt = mh.GetDatabysql("Select * From Class4DeepSoon Where ID="+updateID);
					///获取的栏目外链地址
					this.txtOutLinkHref.Text = dt.Rows[0]["OutLinkHref"].ToString();
					///获取的栏目菜单状态：可见/隐藏
					string isHidden = dt.Rows[0]["isHidden"].ToString();
					if(isHidden == "True")
						this.dropIsHidden.SelectedIndex = 1;
					else this.dropIsHidden.SelectedIndex = 0;
					///设定栏目链接的打开方式
					string linkTarget = dt.Rows[0]["linkTarget"].ToString();
					ListItem linkTargetItem=this.dropLinkTarget.Items.FindByValue(linkTarget);
					if(linkTargetItem != null)
					{
						linkTargetItem.Selected = true;
					}
					///设定栏目的维护权限
					string openArea = dt.Rows[0]["openArea"].ToString();
					ListItem opentAreaItem=this.dropOpenArea.Items.FindByValue(openArea);
					if(opentAreaItem != null)
					{
						opentAreaItem.Selected = true;
					}
					///获取栏目模板
					this.txtThemeFile.Text = dt.Rows[0]["ThemeFile"].ToString();
					///初始化表单数据
					this.labelUpdateInfor.Text = "修改【"+updateName+"】栏目信息";
					this.txtName.Text = updateName;
					this.txtBriefInformation.Text = dt.Rows[0]["BriefInformation"].ToString();
					this.txtID.Text = updateID;
				}///end if
            }			
        }
		

		protected void btnUpdate_Click(object sender, EventArgs e)
		{
			string menuName = this.txtName.Text.Replace("'", "");
			if(menuName.Length>20)menuName = menuName.Substring(0,20);	
			string briefInformation = this.txtBriefInformation.Text.Replace("'", "");
			string menuID = this.txtID.Text;
			string outLinkHref = this.txtOutLinkHref.Text.Replace("'", "");
			if(outLinkHref.Length>250)outLinkHref = outLinkHref.Substring(0,250);
			string isHidden = this.dropIsHidden.SelectedItem.Value;
			string linkTarget = this.dropLinkTarget.SelectedItem.Value;
			string openArea = this.dropOpenArea.SelectedItem.Value;
			string themeFile = this.txtThemeFile.Text.Replace("'", "");
			
			if(menuName!="" && menuID!="" && themeFile != ""){///如果没有空项
				Regex reg = new Regex("^[\u4e00-\u9fa5a-zA-Z0-9]+$");
				if (reg.IsMatch(menuName)){///判断是否为汉字/字母/数字的组合
					///操作权限检测
					if( hasRightTo("ClassTreeUpdate","更新分类") ){
						///创建数据连接对象：
						MysqlHelp mh = new MysqlHelp();
						///修改参数：
						mh.Runsql("Update Class4DeepSoon Set Name='"+menuName+"',BriefInformation='"+briefInformation+"',OutLinkHref='"+outLinkHref+"',isHidden="+isHidden+",ThemeFile='"+themeFile+"',linkTarget='"+linkTarget+"',openArea='"+openArea+"' Where ID="+menuID);
						this.labelUpdateInfor.Text="栏目信息已经更新!";
						Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','栏目信息已更新!','OK')</script>");
						///Response.Redirect("deepSoonTreeUpdate.aspx?updateID="+menuID+"&updateName="+menuName);
					}
					else{
						Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning')</script>");
					}	
				}
				else{
					this.labelUpdateInfor.Text = "栏目名称只允许输入汉字/字母/数字的组合，不允许其他字符!";
					Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','栏目名称只允许输入汉字/字母/数字的组合,不允许其他字符!','Warning')</script>");
				}
			}
			else {
				this.labelUpdateInfor.Text="请将必填项填写完整!";
				Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','请将必填项填写完整!','Error')</script>");
			}
			
		}

	}//end class
	//End ClassUpdate Class
	
	
	
}