﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Web;
using System.IO;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Configuration;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls.WebParts;
using MySql.Data.MySqlClient;
using System.Text.RegularExpressions; 

using Security;
namespace Security
{
	
	
	/* 
	类名: ArticleAdd 
	功能：文章添加类
	作者：书红
	*/
	//Start ArticleAdd Class
    public partial class ArticleAdd : PageBase
    {
		DataTable dt = null;
		string className = null;
		
		protected string attachmentFileStr = "";
		
		///定义树节点的结构体
		struct ClassTreeNode{
			public string ID;
			public string Name;
			public string OutLinkHref;
			public int Level;
		}
		
		protected void Page_Load(object sender, EventArgs e)
		{
			if(!IsPostBack)
            {
				MysqlHelp mh = new MysqlHelp();
				dt = mh.GetDatabysql("Select * From Class4DeepSoon Order By Id");
				///显示ID=?的节点+孩子节点，并设定层级初值level
				ClassTreeNode nd;
				nd.ID="0";               ///节点ID
				nd.Name="请选择所属栏目";        ///节点Name
				nd.OutLinkHref = "";     ///节点外链OutLinkHref
				nd.Level=0;              ///节点Level
				///添加栏目下拉菜单
				ListItem li=new ListItem(nd.Name,"Enable"+nd.ID);
				li.Attributes.Add("style","color:#1081BC;");
				this.dropListClassName.Items.Add(li);
				showNodes(nd);
				
				string classID = Request.QueryString["classID"];
				className = Request.QueryString["className"];
				
				DeepSoonHelp dh = new DeepSoonHelp();
				if(dh.notHasSQLInsertCode(classID) && dh.notHasSQLInsertCode(className) && classID != null && className != null){			
					///初始化表单数据
					ListItem item=this.dropListClassName.Items.FindByValue(classID);
					if(item != null)
					{
						item.Selected = true;
					}
					///this.labelAddInfor.Text = "<a href='deepSoonArticleAdmin.aspx?classID="+classID+"&className="+className+"'>文章管理</a> | <a href='DeepSoonArticleTree.aspx'>返回文章树</a>";
					this.txtAuthor.Text = base.strUser;
				}
				else{
					this.txtAuthor.Text = base.strUser;
				}
			}
			
			this.btnAdd.Attributes.Add("onClick", "hiddFieldArticle.value = document.getElementById('contentBox').contentWindow.document.body.innerHTML;var textBriefInfor;if(document.all){textBriefInfor=document.getElementById('contentBox').contentWindow.document.body.innerText;}else{textBriefInfor=document.getElementById('contentBox').contentWindow.document.body.textContent;}if(textBriefInfor.length > 120)textBriefInfor = textBriefInfor.substring(0,119);hiddFieldBriefInfor.value = textBriefInfor;"); 
			
        }
		
		
		protected void btnAdd_Click(object sender, EventArgs e)
		{
			string title = this.txtTitle.Text.Replace("'","’").Replace("\"","”");
			string source = this.txtSource.Text.Replace("'","’").Replace("\"","”");
			string author = this.txtAuthor.Text.Replace("'","’").Replace("\"","”");
			string classId = this.dropListClassName.SelectedItem.Value;
			string article = this.hiddFieldArticle.Value.Replace("'","");
			string briefInfor = this.hiddFieldBriefInfor.Value.Replace("'","’").Replace("\"","”"); 
			if(briefInfor.Length>120)briefInfor = briefInfor.Substring(0,120);
			briefInfor = Regex.Replace(briefInfor, @"\s*|\t|\r|\n", "", RegexOptions.IgnoreCase);
			briefInfor = Regex.Replace(briefInfor, "（", "(", RegexOptions.IgnoreCase);
			briefInfor = Regex.Replace(briefInfor, "）", ")", RegexOptions.IgnoreCase);		
			
			string thumbnailImageStyle = this.getThumbnailImageStyle.SelectedItem.Value;
			string thumbnailImageAddress = this.txtThumbnailImage.Text;
			string thumbnailImage = "";
			if(thumbnailImageStyle == "autoGet"){
				thumbnailImage = getImageUrl(this.hiddFieldArticle.Value);
				this.txtThumbnailImage.Text = thumbnailImage;
			}
			else{
				thumbnailImage = thumbnailImageAddress;
				this.txtThumbnailImage.Text = thumbnailImage;
			}
			
			bool isSlideShow = this.isSlideShow.Checked;
			bool isPushed = this.isPushed.Checked;
			bool isPassed = this.isPassed.Checked;
			
			string URLstr = this.txtURL.Text.Replace("'","’").Replace("\"","”");
			bool isSetURL = this.isSetURL.Checked;
			
			
			attachmentFileStr = Request.Form.Get("attachmentFile").ToString().ToLower().Replace("'","");
			
			bool classIdEnable = classId.Contains("Enable");
			
			if(classIdEnable){
				labelAddInfor.Text = "您选择的所属栏目不合法,不允许外部栏目!请重新选择所属栏目.";
				this.hiddenDbArticle.Value = article;
				Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您选择的所属栏目不合法,不允许外部栏目!请重新选择所属栏目.','Error')</script>");
			}
			else{
				if(title != "" && source != "" && author != "" && !classIdEnable && article != "" && briefInfor != ""){
					string Values = "'"+title+"','"+source+"','"+author+"','"+classId+"','"+article+"','"+briefInfor+"','"+thumbnailImage+"','"+URLstr+"',"+isSlideShow+","+isPassed+","+isPushed+","+isSetURL;
					///操作权限检测
					if( hasRightTo("ArticleAdd","添加文章") ){
						///创建数据连接对象：
						MysqlHelp mh = new MysqlHelp();
						mh.Runsql("Insert Into Article4DeepSoon(Title,Source,Author,ClassID,Article,BriefInfor,thumbnailImage,URL,isSlideShow,isPassed,isPushed,isSetURL) Values ("+Values+")");
						labelAddInfor.Text = "文章已添加！";
						
						///获取新添加的文章ID
						DataTable newArticleDt = new DataTable();
						newArticleDt = mh.GetDatabysql("Select ID From Article4DeepSoon Order By ID DESC Limit 1");
						string newArticleID = "";
						if(newArticleDt.Rows.Count>0){
							newArticleID = newArticleDt.Rows[0]["ID"].ToString();
						}
						
						///添加附件表记录
						if( attachmentFileStr.Length > 0 ){
							string attachmentFile = attachmentFileStr.Substring(0,attachmentFileStr.Length-1);
							string[] fileArray = attachmentFile.Split(new char[1]{'|'});
							foreach (string fileUrl in fileArray){
								string insertattAchmentFileSQL = "insert into attachmentFile4DeepSoon(uploadAuthor,fileUrl,ArticleID) values ('"+base.strUser+"','"+fileUrl+"','"+newArticleID+"')";
								mh.Runsql(insertattAchmentFileSQL);
							}
						}
						
						Response.Redirect("ArticleAdmin.aspx?ClassID="+classId+"&ClassName="+className);
						///Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','文章已添加!','OK')</script>");
					}
					else{
						Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning');</script>");
					}
				}
				else {
					labelAddInfor.Text = "文章信息没有填写完整,请输入必填项!";
					this.hiddenDbArticle.Value = article;
					Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','文章信息没有填写完整,请输入必填项!','Error')</script>");
				}
			}
		}
		
		/// 获取文中图片地址
		public static string getImageUrl(string content)
		{ 
			string imgSrcValue = "";
			MatchCollection mc = Regex.Matches(content, @"<img(?:(?!src).)*src=(['""]?)(?<path>.*?)/(?<name>[^/\s'""]*)\1", RegexOptions.IgnoreCase);
			if( mc.Count > 0){
				Match m = mc[0];
				imgSrcValue += m.Groups["path"].Value + "/";
				imgSrcValue += m.Groups["name"].Value;
			}
			return imgSrcValue;
		} 
		
		///显示节点+孩子节点
		private void showNodes(ClassTreeNode node)
        {
			this.showNodesFunction(node);
			///this.myLabel.Text = treeStr;
			
		}
		///显示节点递归函数
		private void showNodesFunction(ClassTreeNode node)
        {			
			DataRow [] rows = dt.Select("fatherId = '"+node.ID+"'");///筛选node的孩子节点 
			string spaceStr = "";
			foreach(DataRow dr in rows)///循环孩子节点
            {
				ClassTreeNode childNd;
				childNd.ID = dr["id"].ToString();                    ///孩子节点ID
                childNd.Name = dr["name"].ToString();                ///孩子节点Name
				childNd.OutLinkHref = dr["outLinkHref"].ToString();  ///孩子节点外链OutLinkHref
				childNd.Level = node.Level+1; 
				spaceStr = "";
				///孩子节点Level
				for(int i=0;i<childNd.Level;i++){
					spaceStr += "　 ";
				}
				///添加栏目下拉菜单
				///判断当前节点是否有孩子节点
				bool isFather = dr["childID"].ToString().Contains(",");
				if(isFather){
					ListItem li=new ListItem(spaceStr+"├ "+childNd.Name+"*","Enable"+childNd.ID);
					li.Attributes.Add("style","color:#1081BC;");
					this.dropListClassName.Items.Add(li);
				}
				else{
					ListItem li=new ListItem(spaceStr+"├ "+childNd.Name+"",childNd.ID);
					this.dropListClassName.Items.Add(li);
				}
				this.showNodesFunction(childNd);//递归调用自身  
            }
		}

	}
	//End ArticleAdd Class
	
	
	
	/* 
	类名: ArticleAdmin 
	功能：文章管理类
	作者：书红
	*/
	//Start ArticleAdmin Class
	public partial class ArticleAdmin : PageBase
    {
		string classID = null;
		string className = null;
		
		protected void Page_Load(object sender, EventArgs e)
        {			
			classID = Request.QueryString["ClassID"];
			className = Request.QueryString["ClassName"];
			
			this.labelAddArticleTag.Text="<img src='../images/addIcon.png' style='margin-bottom:-2px;'> <a href='ArticleAdd.aspx?ClassID="+classID+"&&ClassName="+className+"'>发布文章</a>";
			
			
			DeepSoonHelp dh = new DeepSoonHelp();
			if(dh.notHasSQLInsertCode(classID) && dh.notHasSQLInsertCode(className) && classID != null && className != null){			
				///初始化表单数据
				this.labelAdminTitle.Text = ""+className+"";
			}
			
			btnDelAll.Attributes.Add("onclick","return confirm(\"是否确认删除？\")") ;
			
			btnDelAll.Attributes.Add("onclick","return confirm(\"敬告：清除全站所有文章，数据无法恢复，您确定清空吗？\")") ;
			keyWord.Attributes.Add("onblur","if(this.value=='')value='搜索文章';");
			keyWord.Attributes.Add("onfocus","if(this.value=='搜索文章')value='';");
			keyWord.Attributes.Add("onkeydown","if (event.keyCode==13) {}");
			
			if (!IsPostBack) 
			{ 
				///操作权限检测
				if( hasRightTo("ArticleSelect","查看文章列表") ){
					GridviewBind();
				}
				else{
					Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning')</script>");
				}
			}
        }
		
		public string GetM(string strm)
		{
			if(strm == "False")
				return "<img src='../images/slideIconGray.png' title='设置幻灯' style='margin-bottom:-2px;'> 幻灯";
			else
				return "<img src='../images/slideIcon.png' title='取消幻灯' style='margin-bottom:-2px;'> 取消";
		}
		
		public string GetP(string strm)
		{
			if(strm == "False")
				return "<img src='../images/slideIconGray.png' title='设置推荐' style='margin-bottom:-2px;'> 推荐";
			else
				return "<img src='../images/slideIcon.png' title='取消推荐' style='margin-bottom:-2px;'> 取消";
		}
		
		public string GetS(string strm)
		{
			if(strm == "False")
				return "<img src='../images/isPassIcon.png' title='未审核' style='margin-bottom:-2px;'> 未审核";
			else
				return "<img src='../images/isPassIconGray.png' title='已审核' style='margin-bottom:-2px;'> <span class='grayFont'>已审核</span>";
		}
		
		public string GetStyle(string strm)
		{
			if(strm == "False")
				return "<img src='../images/docicon.png' title='普通文档' >";
			else
				return "<img src='../images/URLicon.png' title='外链文章'>";
		}
		
		protected void GridviewBind() 
		{ 
			///创建数据连接对象：
			MysqlHelp mh = new MysqlHelp();
			///先查询当前类的所有子类集：
			DataTable ChildIdDt=new DataTable();
			ChildIdDt = mh.GetDatabysql("Select ChildID From Class4DeepSoon Where ID = "+classID);
			string ChildIDSet = "("+ChildIdDt.Rows[0]["ChildID"].ToString()+")";
			///查询文章表中classID在子类集中的记录
			DataTable dt=new DataTable();
			dt = mh.GetDatabysql("Select Article4DeepSoon.ID,Title,Name,Source,Author,DateStr,isSlideShow,isPassed,isPushed,isSetURL From Article4DeepSoon,Class4DeepSoon Where ClassID in "+ChildIDSet+" and ClassID=Class4DeepSoon.ID and isDelete=false Order By ID DESC");
			myGridView.DataSource = dt;        
			myGridView.DataBind();
		}
	
		protected void myGridView_PageIndexChanging(object sender, GridViewPageEventArgs e)
		{
			myGridView.PageIndex = e.NewPageIndex;
			GridviewBind();//重新执行自定义的GridView数据绑定函数
			((TextBox)myGridView.BottomPagerRow.FindControl("txtGoPage")).Text = ""+(myGridView.PageIndex+1);
		}
		
		protected void myGridView_RowCommand(object sender, GridViewCommandEventArgs e) 
		{ 
			if(e.CommandName == "editArticle"){
				Response.Write("获取的ID"+e.CommandArgument.ToString() );
				Response.Redirect( "ArticleUpdate.aspx?ID="+e.CommandArgument.ToString() );
			}
			else if(e.CommandName == "deleteArticle"){
				///创建数据连接对象：
				MysqlHelp mh = new MysqlHelp();
				MySqlParameter[] updateParms ={new MySqlParameter("?ID",MySqlDbType.VarChar,8)};
				updateParms[0].Value = ""+e.CommandArgument.ToString();
				///操作权限检测
				if( hasRightTo("ArticleDelete","删除文章") ){
					mh.Runsql("Update Article4DeepSoon Set isDelete=true Where ID=?ID", updateParms);		
					GridviewBind();
					Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','文章已删除!','OK')</script>");
				}
				else{
					Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning')</script>");
				}
			}
			else if(e.CommandName == "headTitleArticle"){
				MysqlHelp mh = new MysqlHelp();
				DataTable dt = new DataTable();
				dt = mh.GetDatabysql("Select * From HeadTitle4DeepSoon");
				if(dt.Rows.Count>0){
					MySqlParameter[] updateHeadTitleParms ={new MySqlParameter("?ArticleID",MySqlDbType.VarChar,8)};
					updateHeadTitleParms[0].Value = ""+e.CommandArgument.ToString();
					///操作权限检测
					if( hasRightTo("ArticleHeadTitle","设置文章头条") ){
						mh.Runsql("Update HeadTitle4DeepSoon Set ArticleID=?ArticleID", updateHeadTitleParms);
						Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','文章已被设为头条!','OK')</script>");
					}
					else{
						Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning')</script>");
					}
				}
				else {
					mh.Runsql("insert into HeadTitle4DeepSoon(ArticleID) Values ("+e.CommandArgument.ToString()+")");
				}
				GridviewBind(); 
			}
			else if(e.CommandName == "slideShowArticle"){
				MysqlHelp mh = new MysqlHelp();
				string ArticleID = e.CommandArgument.ToString();
				DataTable ArticleDt = new DataTable();
				ArticleDt = mh.GetDatabysql("Select isSlideShow From Article4DeepSoon Where ID="+ArticleID);
				if(ArticleDt.Rows.Count>0){
					string isSlideShow = ArticleDt.Rows[0]["isSlideShow"].ToString();
					string isSlideShowNowValue = "False";
					if(isSlideShow == "False")isSlideShowNowValue="True";
					else isSlideShowNowValue = "False";
					///操作权限检测
					if( hasRightTo("ArticleSetIndexPic","设置文章幻灯") ){
						mh.Runsql( "Update Article4DeepSoon Set isSlideShow="+isSlideShowNowValue+" Where ID="+ArticleID );
						Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','文章已被设为幻灯显示!','OK')</script>");
					}
					else{
						Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning')</script>");
					}
				}
				GridviewBind(); 
			}
			else if(e.CommandName == "pushedArticle"){
				MysqlHelp mh = new MysqlHelp();
				string ArticleID = e.CommandArgument.ToString();
				DataTable ArticleDt = new DataTable();
				ArticleDt = mh.GetDatabysql("Select isPushed From Article4DeepSoon Where ID="+ArticleID);
				if(ArticleDt.Rows.Count>0){
					string isPushed = ArticleDt.Rows[0]["isPushed"].ToString();
					string isPushedNowValue = "False";
					if(isPushed == "False")isPushedNowValue="True";
					else isPushedNowValue = "False";
					///操作权限检测
					if( hasRightTo("ArticleHeadTitle","设置文章推荐") ){
						mh.Runsql( "Update Article4DeepSoon Set isPushed="+isPushedNowValue+" Where ID="+ArticleID );
						Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','文章已被设为推荐显示!','OK')</script>");
					}
					else{
						Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning')</script>");
					}
				}
				GridviewBind(); 
			}
			else if(e.CommandName == "setPassed"){
				MysqlHelp mh = new MysqlHelp();
				string ArticleID = e.CommandArgument.ToString();
				DataTable ArticleDt = new DataTable();
				ArticleDt = mh.GetDatabysql("Select isPassed From Article4DeepSoon Where ID="+ArticleID);
				if(ArticleDt.Rows.Count>0){
					string isPassed = ArticleDt.Rows[0]["isPassed"].ToString();
					string isPassedValue = "False";
					if(isPassed == "False")isPassedValue="True";
					else isPassedValue = "False";
					///操作权限检测
					if( hasRightTo("ArticleCheck","文章审核") ){
						mh.Runsql( "Update Article4DeepSoon Set isPassed="+isPassedValue+" Where ID="+ArticleID );
						Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','文章状态已更新!','OK')</script>");
					}
					else{
						Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning')</script>");
					}
				}
				GridviewBind(); 
			}
		}
	
		protected void myGridView_RowDataBound(object sender, GridViewRowEventArgs e)
		{
			if (e.Row.RowType == DataControlRowType.DataRow)
			{
				//当鼠标在某一行上方时激发
				e.Row.Attributes.Add("onmouseover", "curColor=this.style.backgroundColor;this.style.backgroundColor='#F0F0F0'");
				//当鼠标从某一行上方移开时激发
				e.Row.Attributes.Add("onmouseout", "this.style.backgroundColor=curColor");
			}
		}
	
		protected void btnDelAll_Click(object sender, EventArgs e) 
		{ 
			string sqlText = "("; 
			int countNum = 0;//统计用户选取的记录数目
			for (int i = 0; i < myGridView.Rows.Count; i++) 
			{ 
				//搜索第n行3列 
				CheckBox cbx = (CheckBox)myGridView.Rows[i].FindControl("cbxId"); 
				if (cbx.Checked == true) 
				{ 
					sqlText = sqlText + Convert.ToInt32(myGridView.DataKeys[i].Value) + ",";
					countNum ++;
				} 
			} 
			//去掉最后的逗号，并且加上右括号 
			sqlText = sqlText.Substring(0,sqlText.Length - 1) + ")"; 
			if(countNum>0){///如果选择不为空
				///操作权限检测
				if( hasRightTo("ArticleDelete","删除文章") ){
					sqlText = "Update Article4DeepSoon Set isDelete=true Where ID In" + sqlText; 
					MysqlHelp mh = new MysqlHelp();
					mh.Runsql(sqlText);
					Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','文章已删除!','OK')</script>");
				}
				else{
					Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning')</script>");
				}
			}
			GridviewBind(); 
		}
		
		protected void btnSelAll_Click(object sender, EventArgs e) 
		{ 
			for (int i = 0; i < myGridView.Rows.Count; i++) 
			{ 
				//搜索第n行3列 
				CheckBox cbx = (CheckBox)myGridView.Rows[i].FindControl("cbxId"); 
				cbx.Checked = true;
			}
		}
		
		protected void btnUnSelAll_Click(object sender, EventArgs e) 
		{ 
			for (int i = 0; i < myGridView.Rows.Count; i++) 
			{ 
				//搜索第n行3列 
				CheckBox cbx = (CheckBox)myGridView.Rows[i].FindControl("cbxId"); 
				cbx.Checked = false;
			}
		}

		/// <summary>
        /// DataTable中的数据导出到Excel并下载
        /// </summary>
        /// <param name="dt">要导出的DataTable</param>
        /// <param name="FileType">类型</param>
        /// <param name="FileName">Excel的文件名</param>
        public void CreateExcel(DataTable dt, string FileType, string FileName)
        {
            Response.Clear();
            Response.Charset = "UTF-8";
            Response.Buffer = true;
            Response.ContentEncoding = System.Text.Encoding.GetEncoding("GB2312");
            Response.AppendHeader("Content-Disposition", "attachment;filename=\"" + System.Web.HttpUtility.UrlEncode(FileName, System.Text.Encoding.UTF8) + ".xls\"");
            Response.ContentType = FileType;///application/x-xls
            string colHeaders = string.Empty;
            string ls_item = string.Empty;
            DataRow[] myRow = dt.Select();
            int i = 0;
            int cl = dt.Columns.Count;
			ls_item += "标题\t分类\t来源\t作者\t更新时间\n";
                
            foreach (DataRow row in myRow)
            {
				for (i = 0; i < cl; i++)
                {
					if (i == (cl - 1))
                    {
                        ls_item += row[i].ToString() + "\n";
                    }
                    else
                    {
                        ls_item += row[i].ToString() + "\t";
                    }
                }
                Response.Output.Write(ls_item);
                ls_item = string.Empty;
            }
            Response.Output.Flush();
            Response.End();
        }
 
		protected void btnExport_Click(object sender, EventArgs e) 
		{ 
			///创建数据连接对象：
			MysqlHelp mh = new MysqlHelp();
			///先查询当前类的所有子类集：
			DataTable ChildIdDt=new DataTable();
			ChildIdDt = mh.GetDatabysql("Select ChildID From Class4DeepSoon Where ID = "+classID);
			string ChildIDSet = "("+ChildIdDt.Rows[0]["ChildID"].ToString()+")";
			///查询文章表中classID在子类集中的记录
			DataTable dt=new DataTable();
			dt = mh.GetDatabysql("Select Title,Name,Source,Author,DateStr From Article4DeepSoon,Class4DeepSoon Where ClassID in "+ChildIDSet+" and ClassID=Class4DeepSoon.ID and isDelete=false and isPassed=true");
			CreateExcel(dt,"application/x-xls",className+"-数据表");
		}

		#region 转到触发方法
		protected void btnGo_Click(object sender, EventArgs e)
		{
			if(((TextBox)myGridView.BottomPagerRow.FindControl("txtGoPage")).Text != ""){
				myGridView.PageIndex = int.Parse(((TextBox)myGridView.BottomPagerRow.FindControl("txtGoPage")).Text) - 1;
				GridviewBind();   //重新绑定GridView
				((TextBox)myGridView.BottomPagerRow.FindControl("txtGoPage")).Text = ""+(myGridView.PageIndex+1);
			}
		}
		#endregion
		
		protected void btnSearch_Click(object sender, EventArgs e)
		{		
			string keyWord = this.keyWord.Text;
			if(keyWord != "")
				Response.Redirect("ArticleSearchResult.aspx?KeyWord="+keyWord);
		}
		
    }
	//End ArticleAdmin Class
	
	
	/* 
	类名: ArticleRecycle 
	功能：文章回收类
	作者：书红
	*/
	//Start ArticleRecycle Class
	public partial class ArticleRecycle : PageBase
    {
		protected void Page_Load(object sender, EventArgs e)
        {			
			btnDelAll.Attributes.Add("onclick","return confirm(\"敬告：数据一旦删除，无法恢复，您是否确认删除？\")") ;
			
			if (!IsPostBack) 
			{ 
				///操作权限检测
				if( hasRightTo("ArticleSelect","查看文章列表") ){
					GridviewBind();
				}
				else{
					Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning')</script>");
				}
			}
        }
		
		public string GetStyle(string strm)
		{
			if(strm == "False")
				return "<img src='../images/docicon.png' title='普通文档' >";
			else
				return "<img src='../images/URLicon.png' title='外链文章'>";
		}
		
		protected void GridviewBind() 
		{ 
			///创建数据连接对象：
			MysqlHelp mh = new MysqlHelp();
			///查询并显示数据：
			DataTable dt=new DataTable();
			dt = mh.GetDatabysql("Select ID,Title,Source,Author,DateStr,isSetURL From Article4DeepSoon Where isDelete=true Order By Article4DeepSoon.ID DESC");
			myGridView.DataSource = dt;        
			myGridView.DataBind();
		}
	
		protected void myGridView_PageIndexChanging(object sender, GridViewPageEventArgs e)
		{
			myGridView.PageIndex = e.NewPageIndex;
			GridviewBind();//重新执行自定义的GridView数据绑定函数
			((TextBox)myGridView.BottomPagerRow.FindControl("txtGoPage")).Text = ""+(myGridView.PageIndex+1);
		}
		
		protected void myGridView_RowCommand(object sender, GridViewCommandEventArgs e) 
		{ 
			if(e.CommandName == "recycleArticle"){
				///创建数据连接对象：
				MysqlHelp mh = new MysqlHelp();
				MySqlParameter[] updateParms ={new MySqlParameter("?ID",MySqlDbType.VarChar,4)};
				updateParms[0].Value = ""+e.CommandArgument.ToString();
				///操作权限检测
				if( hasRightTo("ArticleRecycle","文章恢复") ){
					mh.Runsql("Update Article4DeepSoon Set isDelete=false Where ID=?ID", updateParms);		
					GridviewBind();
					Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','文章已恢复!','OK')</script>");
				}
				else{
					Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning')</script>");
				}
			}
			else if(e.CommandName == "editArticle"){
				Response.Write("获取的ID"+e.CommandArgument.ToString() );
				Response.Redirect( "ArticleUpdate.aspx?ID="+e.CommandArgument.ToString() );
			}
			else if(e.CommandName == "deleteArticle"){
				///创建数据连接对象：
				MysqlHelp mh = new MysqlHelp();
				MySqlParameter[] updateParms ={new MySqlParameter("?ID",MySqlDbType.VarChar,4)};
				updateParms[0].Value = ""+e.CommandArgument.ToString();
				///操作权限检测
				if( hasRightTo("ArticleDelete","删除文章") ){
					mh.Runsql("Delete From Article4DeepSoon Where ID=?ID", updateParms);
					
					///删除文章用到的附件
					DataTable attachmentFileDt = new DataTable();
					attachmentFileDt = mh.GetDatabysql("Select fileUrl From attachmentFile4DeepSoon Where ArticleID=?ID",updateParms);
					if(attachmentFileDt.Rows.Count>0){
						for(int i = 0 ; i < attachmentFileDt.Rows.Count ; i++)
						{
							string fileUrl = attachmentFileDt.Rows[i]["fileUrl"].ToString();
							///删除服务器上的附件
							if (File.Exists(MapPath(fileUrl))){
								File.Delete(MapPath(fileUrl));
							}
						}
						///删除附件表里的记录
						mh.Runsql("Delete From attachmentFile4DeepSoon Where ArticleID=?ID", updateParms);
					}
					
					GridviewBind(); 
					Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','文章已彻底删除!','OK')</script>");
				}
				else{
					Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning')</script>");
				}
			}
		}
		
		protected void myGridView_RowDataBound(object sender, GridViewRowEventArgs e)
		{
			if (e.Row.RowType == DataControlRowType.DataRow)
			{
				//当鼠标在某一行上方时激发
				e.Row.Attributes.Add("onmouseover", "curColor=this.style.backgroundColor;this.style.backgroundColor='#F0F0F0'");
				//当鼠标从某一行上方移开时激发
				e.Row.Attributes.Add("onmouseout", "this.style.backgroundColor=curColor");
			}
		}
	
		protected void btnDelAll_Click(object sender, EventArgs e) 
		{ 
			string sqlText = "("; 
			int countNum = 0;//统计用户选取的记录数目
			for (int i = 0; i < myGridView.Rows.Count; i++) 
			{ 
				//搜索第n行3列 
				CheckBox cbx = (CheckBox)myGridView.Rows[i].FindControl("cbxId"); 
				if (cbx.Checked == true) 
				{ 
					sqlText = sqlText + Convert.ToInt32(myGridView.DataKeys[i].Value) + ",";
					countNum ++;
				} 
			} 
			//去掉最后的逗号，并且加上右括号 
			sqlText = sqlText.Substring(0,sqlText.Length - 1) + ")"; 
			if(countNum>0){///如果选择不为空
				///操作权限检测
				if( hasRightTo("ArticleDelete","删除文章") ){
					string delSql = "Delete From Article4DeepSoon Where ID in " + sqlText; 
					MysqlHelp mh = new MysqlHelp();
					mh.Runsql(delSql); 
					
					///删除文章用到的附件
					DataTable attachmentFileDt = new DataTable();
					attachmentFileDt = mh.GetDatabysql("Select *  From attachmentFile4DeepSoon Where ArticleID  In "+sqlText);
					if(attachmentFileDt.Rows.Count>0){
						for(int i = 0 ; i < attachmentFileDt.Rows.Count ; i++)
						{
							string fileUrl = attachmentFileDt.Rows[i]["fileUrl"].ToString();
							///删除服务器上的附件
							if (File.Exists(MapPath(fileUrl))){
								File.Delete(MapPath(fileUrl));
							}
						}
						///删除附件表里的记录
						mh.Runsql("Delete From attachmentFile4DeepSoon Where ArticleID In " + sqlText);
					}
					
					Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','文章已彻底删除!','OK')</script>");
				}
				else{
					Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning')</script>");
				}
			}
			GridviewBind(); 
		}

		protected void btnSelAll_Click(object sender, EventArgs e) 
		{ 
			for (int i = 0; i < myGridView.Rows.Count; i++) 
			{ 
				//搜索第n行3列 
				CheckBox cbx = (CheckBox)myGridView.Rows[i].FindControl("cbxId"); 
				cbx.Checked = true;
			}
		}
		
		protected void btnUnSelAll_Click(object sender, EventArgs e) 
		{ 
			for (int i = 0; i < myGridView.Rows.Count; i++) 
			{ 
				//搜索第n行3列 
				CheckBox cbx = (CheckBox)myGridView.Rows[i].FindControl("cbxId"); 
				cbx.Checked = false;
			}
		}
		
		#region 转到触发方法
		protected void btnGo_Click(object sender, EventArgs e)
		{
			if(((TextBox)myGridView.BottomPagerRow.FindControl("txtGoPage")).Text != ""){
				myGridView.PageIndex = int.Parse(((TextBox)myGridView.BottomPagerRow.FindControl("txtGoPage")).Text) - 1;
				GridviewBind();   //重新绑定GridView
				((TextBox)myGridView.BottomPagerRow.FindControl("txtGoPage")).Text = ""+(myGridView.PageIndex+1);
			}
		}
		#endregion
		
    }
	//End ArticleRecycle Class
	
	
	
	
	/* 
	类名: ArticleTree 
	功能：文章树类
	作者：书红
	*/
	//Start ArticleTree Class
	public partial class ArticleTree : PageBase
    {
		MysqlHelp mh = null;
		DataTable dt = null;
		string treeStr = "";
		
		///定义树节点的结构体
		struct ClassTreeNode{
			public string ID;
			public string Name;
			public string OutLinkHref;
			public int Level;
		}
		
		protected void Page_Load(object sender, EventArgs e)
        {
			if (!IsPostBack) 
			{ 
				
			}
			
			btnDelAll.Attributes.Add("onclick","return confirm(\"敬告：清除全站所有文章，数据无法恢复，您确定清空吗？\")") ;
			keyWord.Attributes.Add("onblur","if(this.value=='')value='搜索文章';");
			keyWord.Attributes.Add("onfocus","if(this.value=='搜索文章')value='';");
			keyWord.Attributes.Add("onkeydown","if (event.keyCode==13) {}");
			
			
			mh = new MysqlHelp();
			dt = mh.GetDatabysql("Select * From Class4DeepSoon Order By Id");
			
			    
            string delID = Request.QueryString["delClassID"];
			string delName = Request.QueryString["delClassName"];
			
			DeepSoonHelp dh = new DeepSoonHelp();
			if(dh.notHasSQLInsertCode(delID) && dh.notHasSQLInsertCode(delName)  && delID != null && delName != null){
				///Response.Write("清空文章节点信息：ID="+delID+" Name="+delName+"<br>");
				///操作权限检测
				if( hasRightTo("ArticleDelete","删除文章") ){
					mh.Runsql("Delete From Article4DeepSoon Where instr((Select ChildID From Class4DeepSoon Where ID = "+delID+" ),Article4DeepSoon.ClassID)>0");
					Response.Redirect("ArticleTree.aspx");
					Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','栏目的所有文章已删除!','OK')</script>");
				}
				else{
					Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning')</script>");
				}
			}
				
			///显示ID=?的节点+孩子节点，并设定层级初值level
			ClassTreeNode nd;
            nd.ID="0";               ///节点ID
            nd.Name="门户网";        ///节点Name
			nd.OutLinkHref = "";     ///节点外链OutLinkHref
			nd.Level=-1;              ///节点Level
			///操作权限检测
			if( hasRightTo("ClassTreeSelect","查看文章树") ){
				showNodes(nd);
			}
			else{
				Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning')</script>");
			}
			
        }
		
		///显示节点+孩子节点
		private void showNodes(ClassTreeNode node)
        {
			this.showNodesFunction(node);
			this.myLabel.Text = treeStr;
			
		}
		///显示节点递归函数
		private void showNodesFunction(ClassTreeNode node)
        {			
			DataRow [] rows = dt.Select("fatherId = '"+node.ID+"'");///筛选node的孩子节点 
			foreach(DataRow dr in rows)///循环孩子节点
            {
				ClassTreeNode childNd;
				childNd.ID = dr["id"].ToString();                    ///孩子节点ID
                childNd.Name = dr["name"].ToString();                ///孩子节点Name
				childNd.OutLinkHref = dr["outLinkHref"].ToString();  ///孩子节点外链OutLinkHref
				childNd.Level = node.Level+1;                        ///孩子节点Level
				
				string isHiddenStr = dr["isHidden"].ToString();  ///孩子节点是否可见
				string isVisuableStr = "<img src='../images/True.png' title='前台导航栏可见'>";
				if(isHiddenStr=="True")isVisuableStr = "<img src='../images/False.png' title='导航栏不可见'>";
				string OutLinkHrefStr = dr["OutLinkHref"].ToString();  ///孩子节点是否有外链
				string OutLinkHrefStat = "&nbsp;";
				///获取栏目URL地址
				string viewURL = "../../list-"+childNd.ID+"-0.aspx";
				if(OutLinkHrefStr != ""){
					OutLinkHrefStat = "<img src='../images/createlink.gif' title='是外链栏目'>";
					viewURL = OutLinkHrefStr;
				}
				
				///统计记录数
				DataTable IDSetDt=new DataTable();
				IDSetDt = mh.GetDatabysql("Select ChildID From Class4DeepSoon  Where ID='"+childNd.ID+"'");
				string IDSet = "(" +IDSetDt.Rows[0]["ChildID"].ToString()+")";
				DataTable countDt=new DataTable();
				countDt = mh.GetDatabysql("Select Count(ID) As CountNum From Article4DeepSoon Where ClassID in"+IDSet);
				string countResult = countDt.Rows[0]["CountNum"].ToString();
				
				treeStr += "<tr onMouseOver='this.style.backgroundColor=\"#F0F0F0\"' onMouseOut='this.style.backgroundColor=\"#FFFFFF\"' >";
				treeStr += "<td style='width:80px;'>"+childNd.ID+"</td><td>";
				
				for(int i=0;i<childNd.Level;i++){
					treeStr += "&nbsp;&nbsp;&nbsp;&nbsp;";
				}
				if(childNd.Level > 0)
					treeStr += "<img src='../images/nodeIcon.png' style='margin-bottom:-5px;'> ";
				else
					treeStr += "<img src='../images/listIcon.png' style='margin-bottom:-5px;'> ";
				///判断当前节点是否有孩子节点
				bool isFather = dr["childID"].ToString().Contains(",");
				if(isFather){
					treeStr += childNd.Name + "<a href='../../"+viewURL+"' target='_blank'>" + "("+countResult+")</a></td><td style='width:40px;'>"+OutLinkHrefStat+"</td><td style='width:40px;'>"+isVisuableStr+"</td><td style='width:160px;'><span class='grayFont'>添加文章</span> | <a href='ArticleAdmin.aspx?ClassID="+childNd.ID+"&ClassName="+childNd.Name+"' >管理</a> | <a href='ArticleTree.aspx?delClassID="+childNd.ID+"&delClassName="+childNd.Name+"' onclick='return confirm(\"敬告：栏目文章清空后无法恢复，确定清空吗？\")'>清空</a></td>";
				}
				else{
					treeStr += childNd.Name + "<a href='../../"+viewURL+"' target='_blank'>" + "("+countResult+")</a></td><td style='width:40px;'>"+OutLinkHrefStat+"</td><td style='width:40px;'>"+isVisuableStr+"</td><td style='width:160px;'><a href='ArticleAdd.aspx?ClassID="+childNd.ID+"&ClassName="+childNd.Name+"'>添加文章</a> | <a href='ArticleAdmin.aspx?ClassID="+childNd.ID+"&ClassName="+childNd.Name+"' >管理</a> | <a href='ArticleTree.aspx?delClassID="+childNd.ID+"&delClassName="+childNd.Name+"' onclick='return confirm(\"敬告：栏目文章清空后无法恢复，确定清空吗？\")'>清空</a></td>";
				}
				treeStr += "</tr>";
				
				this.showNodesFunction(childNd);//递归调用自身  
            }
		}
		
		
		protected void btnDelAll_Click(object sender, EventArgs e)
		{
			///操作权限检测
			if( hasRightTo("ArticleDelete","清空文章") ){
				mh.Runsql("Truncate Table Article4DeepSoon");
				Response.Redirect("ArticleTree.aspx");
				Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','已清空文章!','OK')</script>");
			}
			else{
				Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning')</script>");
			}
			
		}
		
		/// <summary>
        /// DataTable中的数据导出到Excel并下载
        /// </summary>
        /// <param name="dt">要导出的DataTable</param>
        /// <param name="FileType">类型</param>
        /// <param name="FileName">Excel的文件名</param>
        public void CreateExcel(DataTable dt, string FileType, string FileName)
        {
            Response.Clear();
            Response.Charset = "UTF-8";
            Response.Buffer = true;
            Response.ContentEncoding = System.Text.Encoding.GetEncoding("GB2312");
            Response.AppendHeader("Content-Disposition", "attachment;filename=\"" + System.Web.HttpUtility.UrlEncode(FileName, System.Text.Encoding.UTF8) + ".xls\"");
            Response.ContentType = FileType;///application/x-xls
			string colHeaders = string.Empty;
            string ls_item = string.Empty;
            DataRow[] myRow = dt.Select();
            int i = 0;
            int cl = dt.Columns.Count;
			ls_item += "标题\t分类\t来源\t作者\t更新时间\n";
                
            foreach (DataRow row in myRow)
            {
				for (i = 0; i < cl; i++)
                {
					if (i == (cl - 1))
                    {
                        ls_item += row[i].ToString() + "\n";
                    }
                    else
                    {
                        ls_item += row[i].ToString() + "\t";
                    }
                }
                Response.Output.Write(ls_item);
                ls_item = string.Empty;
            }
            Response.Output.Flush();
            Response.End();
        }
 
		protected void btnExport_Click(object sender, EventArgs e) 
		{ 
			///创建数据连接对象：
			MysqlHelp mh = new MysqlHelp();
			///查询文章表中classID在子类集中的记录
			DataTable dt=new DataTable();
			dt = mh.GetDatabysql("Select Title,Name,Source,Author,DateStr From Article4DeepSoon,Class4DeepSoon Where ClassID=Class4DeepSoon.ID and isDelete=false and isPassed=true");
			CreateExcel(dt,"application/x-xls","全站文章-数据表");
		}
		
		
		protected void btnSearch_Click(object sender, EventArgs e)
		{		
			string keyWord = this.keyWord.Text;
			if(keyWord != "")
				Response.Redirect("ArticleSearchResult.aspx?KeyWord="+keyWord);
		}
    }
	//End ArticleTree Class
	
	
	
	/* 
	类名: Articleunchecked 
	功能：文章审核类
	作者：书红
	*/
	//Start Articleunchecked Class
	public partial class Articleunchecked : PageBase
    {
		protected void Page_Load(object sender, EventArgs e)
        {			
			btnDelAll.Attributes.Add("onclick","return confirm(\"是否确认删除？\")") ;
			keyWord.Attributes.Add("onblur","if(this.value=='')value='搜索文章';");
			keyWord.Attributes.Add("onfocus","if(this.value=='搜索文章')value='';");
			keyWord.Attributes.Add("onkeydown","if (event.keyCode==13) {}");
			
			if (!IsPostBack) 
			{ 
				///操作权限检测
				if( hasRightTo("ArticleSelect","查看文章列表") ){
					GridviewBind();
				}
				else{
					Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning')</script>");
				}
			}
        }
		
		public string GetStyle(string strm)
		{
			if(strm == "False")
				return "<img src='../images/docicon.png' title='普通文档' >";
			else
				return "<img src='../images/URLicon.png' title='外链文章'>";
		}
		
		protected void GridviewBind() 
		{ 
			///创建数据连接对象：
			MysqlHelp mh = new MysqlHelp();
			///查询文章表中classID在子类集中的记录
			DataTable dt=new DataTable();
			dt = mh.GetDatabysql("Select Article4DeepSoon.ID,Title,Name,Source,Author,DateStr,isSlideShow,isPassed,isSetURL From Article4DeepSoon,Class4DeepSoon Where ClassID=Class4DeepSoon.ID and isPassed=false and isDelete=false Order By ID DESC");
			myGridView.DataSource = dt;        
			myGridView.DataBind();
		}
	
		protected void myGridView_PageIndexChanging(object sender, GridViewPageEventArgs e)
		{
			myGridView.PageIndex = e.NewPageIndex;
			GridviewBind();//重新执行自定义的GridView数据绑定函数
			((TextBox)myGridView.BottomPagerRow.FindControl("txtGoPage")).Text = ""+(myGridView.PageIndex+1);
		}
		
		protected void myGridView_RowCommand(object sender, GridViewCommandEventArgs e) 
		{ 
			if(e.CommandName == "editArticle"){
				Response.Write("获取的ID"+e.CommandArgument.ToString() );
				Response.Redirect( "ArticleUpdate.aspx?ID="+e.CommandArgument.ToString() );
			}
			else if(e.CommandName == "deleteArticle"){
				///创建数据连接对象：
				MysqlHelp mh = new MysqlHelp();
				MySqlParameter[] updateParms ={new MySqlParameter("?ID",MySqlDbType.VarChar,8)};
				updateParms[0].Value = ""+e.CommandArgument.ToString();
				///操作权限检测
				if( hasRightTo("ArticleDelete","删除文章") ){
					mh.Runsql("Update Article4DeepSoon Set isDelete=true Where ID=?ID", updateParms);		
					GridviewBind(); 
					Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','文章已删除!','OK')</script>");
				}
				else{
					Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning')</script>");
				}
			}
			else if(e.CommandName == "setPassed"){
				MysqlHelp mh = new MysqlHelp();
				string ArticleID = e.CommandArgument.ToString();
				///操作权限检测
				if( hasRightTo("ArticleCheck","文章审核") ){
					mh.Runsql( "Update Article4DeepSoon Set isPassed=true Where ID="+ArticleID );
					GridviewBind(); 
					Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','文章状态已更新!','OK')</script>");
				}
				else{
					Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning')</script>");
				}
			}
		}
		
		protected void myGridView_RowDataBound(object sender, GridViewRowEventArgs e)
		{
			if (e.Row.RowType == DataControlRowType.DataRow)
			{
				//当鼠标在某一行上方时激发
				e.Row.Attributes.Add("onmouseover", "curColor=this.style.backgroundColor;this.style.backgroundColor='#F0F0F0'");
				//当鼠标从某一行上方移开时激发
				e.Row.Attributes.Add("onmouseout", "this.style.backgroundColor=curColor");
			}
		}
		
		protected void btnDelAll_Click(object sender, EventArgs e) 
		{ 
			string sqlText = "("; 
			int countNum = 0;//统计用户选取的记录数目
			for (int i = 0; i < myGridView.Rows.Count; i++) 
			{ 
				//搜索第n行3列 
				CheckBox cbx = (CheckBox)myGridView.Rows[i].FindControl("cbxId"); 
				if (cbx.Checked == true) 
				{ 
					sqlText = sqlText + Convert.ToInt32(myGridView.DataKeys[i].Value) + ",";
					countNum ++;
				} 
			} 
			//去掉最后的逗号，并且加上右括号 
			sqlText = sqlText.Substring(0,sqlText.Length - 1) + ")"; 
			if(countNum>0){///如果选择不为空
				///操作权限检测
				if( hasRightTo("ArticleDelete","删除文章") ){
					sqlText = "Update Article4DeepSoon Set isDelete=true Where ID In" + sqlText; 
					MysqlHelp mh = new MysqlHelp();
					mh.Runsql(sqlText);
					Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','文章已删除!','OK')</script>");
				}
				else{
					Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning')</script>");
				} 
			}
			GridviewBind(); 
		}
		
		protected void btnSelAll_Click(object sender, EventArgs e) 
		{ 
			for (int i = 0; i < myGridView.Rows.Count; i++) 
			{ 
				//搜索第n行3列 
				CheckBox cbx = (CheckBox)myGridView.Rows[i].FindControl("cbxId"); 
				cbx.Checked = true;
			}
		}
		
		protected void btnUnSelAll_Click(object sender, EventArgs e) 
		{ 
			for (int i = 0; i < myGridView.Rows.Count; i++) 
			{ 
				//搜索第n行3列 
				CheckBox cbx = (CheckBox)myGridView.Rows[i].FindControl("cbxId"); 
				cbx.Checked = false;
			}
		}

		#region 转到触发方法
		protected void btnGo_Click(object sender, EventArgs e)
		{
			if(((TextBox)myGridView.BottomPagerRow.FindControl("txtGoPage")).Text != ""){
				myGridView.PageIndex = int.Parse(((TextBox)myGridView.BottomPagerRow.FindControl("txtGoPage")).Text) - 1;
				GridviewBind();   //重新绑定GridView
				((TextBox)myGridView.BottomPagerRow.FindControl("txtGoPage")).Text = ""+(myGridView.PageIndex+1);
			}
		}
		#endregion
		
		protected void btnSearch_Click(object sender, EventArgs e)
		{		
			string keyWord = this.keyWord.Text;
			if(keyWord != "")
				Response.Redirect("ArticleSearchResult.aspx?KeyWord="+keyWord);
		}
		
    }
	//End Articleunchecked Class
	
	
	/* 
	类名: ArticleUpdate 
	功能：文章更新类
	作者：书红
	*/
	//Start ArticleUpdate Class
	public partial class ArticleUpdate : PageBase
    {
		///创建数据连接对象：
		MysqlHelp mh = new MysqlHelp();
		DataTable articleDT = new DataTable();
		DataTable dt = new DataTable();
		string ID = null;
		
		protected string attachmentFileStr = "";
		
		///定义树节点的结构体
		struct ClassTreeNode{
			public string ID;
			public string Name;
			public string OutLinkHref;
			public int Level;
		}
		
		protected void Page_Load(object sender, EventArgs e)
		{
			ID = Request.QueryString["ID"];
			
			if(!IsPostBack)
            {
				dt = mh.GetDatabysql("Select * From Class4DeepSoon Order By Id");
				///显示ID=?的节点+孩子节点，并设定层级初值level
				ClassTreeNode nd;
				nd.ID="0";               ///节点ID
				nd.Name="请选择所属栏目";        ///节点Name
				nd.OutLinkHref = "";     ///节点外链OutLinkHref
				nd.Level=0;              ///节点Level
				///添加栏目下拉菜单
				ListItem li=new ListItem(nd.Name,"Enable"+nd.ID);
				li.Attributes.Add("style","color:#1081BC;");
				this.dropListClassName.Items.Add(li);
				showNodes(nd);
				
				DeepSoonHelp dh = new DeepSoonHelp();
				if( ID != null && dh.notHasSQLInsertCode(ID) ){
					///查询数据库
					articleDT = mh.GetDatabysql("Select * From Article4DeepSoon Where ID="+ID);
					string title = ""+articleDT.Rows[0]["Title"];
					string source = ""+articleDT.Rows[0]["Source"];
					string author = ""+articleDT.Rows[0]["Author"];
					string dateStr = ""+articleDT.Rows[0]["DateStr"];
					string classId = ""+articleDT.Rows[0]["ClassID"];
					string thumbnailImage = ""+articleDT.Rows[0]["thumbnailImage"];
					this.hiddenDbArticle.Value = ""+articleDT.Rows[0]["Article"];
					
					this.isSlideShow.Checked=(bool)articleDT.Rows[0]["isSlideShow"];
					this.isPushed.Checked=(bool)articleDT.Rows[0]["isPushed"];
					this.isPassed.Checked=(bool)articleDT.Rows[0]["isPassed"];
					
					this.txtURL.Text = ""+articleDT.Rows[0]["URL"];
					this.isSetURL.Checked=(bool)articleDT.Rows[0]["isSetURL"];
					
					///初始化表单数据
					ListItem item=this.dropListClassName.Items.FindByValue(classId);
					if(item != null)
					{
						item.Selected = true;
					}
					this.txtTitle.Text = title;
					this.txtSource.Text = source;
					this.txtAuthor.Text = author;
					this.txtDateStr.Text = dateStr;
					this.txtThumbnailImage.Text = thumbnailImage;
				
				}
			}
			
			this.btnUpdate.Attributes.Add("onClick", "hiddFieldArticle.value = document.getElementById('contentBox').contentWindow.document.body.innerHTML;var textBriefInfor;if(document.all){textBriefInfor=document.getElementById('contentBox').contentWindow.document.body.innerText;}else{textBriefInfor=document.getElementById('contentBox').contentWindow.document.body.textContent;}if(textBriefInfor.length > 120)textBriefInfor = textBriefInfor.substring(0,119);hiddFieldBriefInfor.value = textBriefInfor;");
			
        }
		
		protected void btnUpdate_Click(object sender, EventArgs e)
		{
			string title = this.txtTitle.Text.Replace("'", "’").Replace("\"","”");
			string source = this.txtSource.Text.Replace("'", "’").Replace("\"","”");
			string author = this.txtAuthor.Text.Replace("'", "’").Replace("\"","”");
			string classId = this.dropListClassName.SelectedItem.Value;
			string dateStr = this.txtDateStr.Text.Replace("'", "").Replace("\"","");
			string article = this.hiddFieldArticle.Value.Replace("'","");
			this.hiddenDbArticle.Value = article;
			string briefInfor = this.hiddFieldBriefInfor.Value.Replace("'","’").Replace("\"","”"); 
			if(briefInfor.Length>120)briefInfor = briefInfor.Substring(0,120);
			briefInfor = Regex.Replace(briefInfor, @"\s*|\t|\r|\n", "", RegexOptions.IgnoreCase);
			briefInfor = Regex.Replace(briefInfor, "（", "(", RegexOptions.IgnoreCase);
			briefInfor = Regex.Replace(briefInfor, "）", ")", RegexOptions.IgnoreCase);		
			
			string thumbnailImageStyle = this.getThumbnailImageStyle.SelectedItem.Value;
			string thumbnailImageAddress = this.txtThumbnailImage.Text;
			string thumbnailImage = "";
			if(thumbnailImageStyle == "autoGet"){
				thumbnailImage = getImageUrl(this.hiddFieldArticle.Value);
				this.txtThumbnailImage.Text = thumbnailImage;
			}
			else{
				thumbnailImage = thumbnailImageAddress;
				this.txtThumbnailImage.Text = thumbnailImage;
			}
			
			bool isSlideShow = this.isSlideShow.Checked;
			bool isPushed = this.isPushed.Checked;
			bool isPassed = this.isPassed.Checked;
			
			string URLstr = this.txtURL.Text.Replace("'", "’").Replace("\"","”");
			bool isSetURL = this.isSetURL.Checked;
			
			attachmentFileStr = Request.Form.Get("attachmentFile").ToString().ToLower().Replace("'","");
			
			///Response.Write("获取的图片地址"+classId);
			bool classIdEnable = classId.Contains("Enable");
			
			if(classIdEnable){
				labelUpdateInfor.Text = "您选择的所属栏目不合法,不允许外部栏目!请重新选择所属栏目.";
				this.hiddenDbArticle.Value = article;
				Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您选择的所属栏目不合法,不允许外部栏目!请重新选择所属栏目.','Error')</script>");
			}
			else{
				if(title != "" && source != "" && author != "" && article != "" && briefInfor != "" && dateStr != ""){
					///操作权限检测
					if( hasRightTo("ArticleUpdate","更新文章") ){
						mh.Runsql("Update Article4DeepSoon Set Title='"+title+"',Source='"+source+"',Author='"+author+"',ClassID='"+classId+"',DateStr='"+dateStr+"',Article='"+article+"',BriefInfor='"+briefInfor+"',thumbnailImage='"+thumbnailImage+"',URL='"+URLstr+"',isSlideShow="+isSlideShow+",isPushed="+isPushed+",isPassed="+isPassed+",isSetURL="+isSetURL+" Where ID="+ID);
						labelUpdateInfor.Text = "文章已经更新";
						
						///添加附件表记录
						if( attachmentFileStr.Length > 0 ){
							string attachmentFile = attachmentFileStr.Substring(0,attachmentFileStr.Length-1);
							string[] fileArray = attachmentFile.Split(new char[1]{'|'});
							foreach (string fileUrl in fileArray){
								string insertattAchmentFileSQL = "insert into attachmentFile4DeepSoon(uploadAuthor,fileUrl,ArticleID) values ('"+base.strUser+"','"+fileUrl+"','"+ID+"')";
								mh.Runsql(insertattAchmentFileSQL);
							}
						}
						
						Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','文章已更新!','OK')</script>");
					}
					else{
						Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning')</script>");
					}
				}
				else {
					labelUpdateInfor.Text = "文章信息没有填写完整,请输入必填项!";
					this.hiddenDbArticle.Value = article;
					Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','文章信息没有填写完整,请输入必填项!','Error')</script>");
				}
			}
		}
		
		/// 获取文中图片地址
		public static string getImageUrl(string content)
		{ 
			string imgSrcValue = "";
			MatchCollection mc = Regex.Matches(content, @"<img(?:(?!src).)*src=(['""]?)(?<path>.*?)/(?<name>[^/\s'""]*)\1", RegexOptions.IgnoreCase);
			if( mc.Count > 0){
				Match m = mc[0];
				imgSrcValue += m.Groups["path"].Value + "/";
				imgSrcValue += m.Groups["name"].Value;
			}
			return imgSrcValue;
		} 
		
		///显示节点+孩子节点
		private void showNodes(ClassTreeNode node)
        {
			this.showNodesFunction(node);
			///this.myLabel.Text = treeStr;
			
		}
		///显示节点递归函数
		private void showNodesFunction(ClassTreeNode node)
        {			
			DataRow [] rows = dt.Select("fatherId = '"+node.ID+"'");///筛选node的孩子节点 
			string spaceStr = "";
			foreach(DataRow dr in rows)///循环孩子节点
            {
				ClassTreeNode childNd;
				childNd.ID = dr["id"].ToString();                    ///孩子节点ID
                childNd.Name = dr["name"].ToString();                ///孩子节点Name
				childNd.OutLinkHref = dr["outLinkHref"].ToString();  ///孩子节点外链OutLinkHref
				childNd.Level = node.Level+1; 
				spaceStr = "";
				///孩子节点Level
				for(int i=0;i<childNd.Level;i++){
					spaceStr += "　 ";
				}
				///添加栏目下拉菜单
				///判断当前节点是否有孩子节点
				bool isFather = dr["childID"].ToString().Contains(",");
				if(isFather){
					ListItem li=new ListItem(spaceStr+"├ "+childNd.Name+"*","Enable"+childNd.ID);
					li.Attributes.Add("style","color:#1081BC;");
					this.dropListClassName.Items.Add(li);
				}
				else{
					ListItem li=new ListItem(spaceStr+"├ "+childNd.Name+"",childNd.ID);
					this.dropListClassName.Items.Add(li);
				}
				this.showNodesFunction(childNd);//递归调用自身  
            }
		}

	}//end class
	//End ArticleUpdate Class
	
	
	/* 
	类名: MyArticle 
	功能：我的文章类
	作者：书红
	*/
	//Start MyArticle Class
	 public partial class MyArticle : PageBase
    {
		protected void Page_Load(object sender, EventArgs e)
        {			
			btnDelAll.Attributes.Add("onclick","return confirm(\"是否确认删除？\")") ;
			
			btnDelAll.Attributes.Add("onclick","return confirm(\"敬告：清除全站所有文章，数据无法恢复，您确定清空吗？\")") ;
			keyWord.Attributes.Add("onblur","if(this.value=='')value='搜索文章';");
			keyWord.Attributes.Add("onfocus","if(this.value=='搜索文章')value='';");
			keyWord.Attributes.Add("onkeydown","if (event.keyCode==13) {}");
			
			if (!IsPostBack) 
			{ 
				///操作权限检测
				if( hasRightTo("ArticleSelect","查看文章列表") ){
					GridviewBind();
				}
				else{
					Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning')</script>");
				}
			}
        }
		
		public string GetM(string strm)
		{
			if(strm == "False")
				return "<img src='../images/slideIconGray.png' title='设置幻灯' style='margin-bottom:-2px;'> 幻灯";
			else
				return "<img src='../images/slideIcon.png' title='取消幻灯' style='margin-bottom:-2px;'> 取消";
		}
		
		public string GetP(string strm)
		{
			if(strm == "False")
				return "<img src='../images/slideIconGray.png' title='设置推荐' style='margin-bottom:-2px;'> 推荐";
			else
				return "<img src='../images/slideIcon.png' title='取消推荐' style='margin-bottom:-2px;'> 取消";
		}
		
		public string GetS(string strm)
		{
			if(strm == "False")
				return "<img src='../images/isPassIcon.png' title='未审核' style='margin-bottom:-2px;'> 未审核";
			else
				return "<img src='../images/isPassIconGray.png' title='已审核' style='margin-bottom:-2px;'> <span class='grayFont'>已审核</span>";
		}
		
		public string GetStyle(string strm)
		{
			if(strm == "False")
				return "<img src='../images/docicon.png' title='普通文档' >";
			else
				return "<img src='../images/URLicon.png' title='外链文章'>";
		}
		
		protected void GridviewBind() 
		{ 
			///创建数据连接对象：
			MysqlHelp mh = new MysqlHelp();
			///查询文章表中classID在子类集中的记录
			DataTable dt=new DataTable();
			dt = mh.GetDatabysql("Select Article4DeepSoon.ID,Title,Name,Source,Author,DateStr,isSlideShow,isPassed,isPushed,isSetURL From Article4DeepSoon,Class4DeepSoon Where Author='"+base.strUser+"' and ClassID=Class4DeepSoon.ID and isDelete=false Order By ID DESC");
			myGridView.DataSource = dt;        
			myGridView.DataBind();
		}
	
		protected void myGridView_PageIndexChanging(object sender, GridViewPageEventArgs e)
		{
			myGridView.PageIndex = e.NewPageIndex;
			GridviewBind();//重新执行自定义的GridView数据绑定函数
			((TextBox)myGridView.BottomPagerRow.FindControl("txtGoPage")).Text = ""+(myGridView.PageIndex+1);
		}
		
		protected void myGridView_RowCommand(object sender, GridViewCommandEventArgs e) 
		{ 
			if(e.CommandName == "editArticle"){
				Response.Write("获取的ID"+e.CommandArgument.ToString() );
				Response.Redirect( "ArticleUpdate.aspx?ID="+e.CommandArgument.ToString() );
			}
			else if(e.CommandName == "deleteArticle"){
				///创建数据连接对象：
				MysqlHelp mh = new MysqlHelp();
				MySqlParameter[] updateParms ={new MySqlParameter("?ID",MySqlDbType.VarChar,8)};
				updateParms[0].Value = ""+e.CommandArgument.ToString();
				///操作权限检测
				if( hasRightTo("ArticleDelete","删除文章") ){
					mh.Runsql("Update Article4DeepSoon Set isDelete=true Where ID=?ID", updateParms);		
					GridviewBind();
					Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','文章已删除!','OK')</script>");
				}
				else{
					Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning')</script>");
				}
			}
			else if(e.CommandName == "headTitleArticle"){
				MysqlHelp mh = new MysqlHelp();
				DataTable dt = new DataTable();
				dt = mh.GetDatabysql("Select * From HeadTitle4DeepSoon");
				if(dt.Rows.Count>0){
					MySqlParameter[] updateHeadTitleParms ={new MySqlParameter("?ArticleID",MySqlDbType.VarChar,8)};
					updateHeadTitleParms[0].Value = ""+e.CommandArgument.ToString();
					///操作权限检测
					if( hasRightTo("ArticleHeadTitle","设置文章头条") ){
						mh.Runsql("Update HeadTitle4DeepSoon Set ArticleID=?ArticleID", updateHeadTitleParms);
						Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','设置文章头条成功!','OK')</script>");
					}
					else{
						Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning')</script>");
					}
				}
				else {
					mh.Runsql("insert into HeadTitle4DeepSoon(ArticleID) Values ("+e.CommandArgument.ToString()+")");
				}
				GridviewBind(); 
			}
			else if(e.CommandName == "slideShowArticle"){
				MysqlHelp mh = new MysqlHelp();
				string ArticleID = e.CommandArgument.ToString();
				DataTable ArticleDt = new DataTable();
				ArticleDt = mh.GetDatabysql("Select isSlideShow From Article4DeepSoon Where ID="+ArticleID);
				if(ArticleDt.Rows.Count>0){
					string isSlideShow = ArticleDt.Rows[0]["isSlideShow"].ToString();
					string isSlideShowNowValue = "False";
					if(isSlideShow == "False")isSlideShowNowValue="True";
					else isSlideShowNowValue = "False";
					///操作权限检测
					if( hasRightTo("ArticleSetIndexPic","设置文章幻灯") ){
						mh.Runsql( "Update Article4DeepSoon Set isSlideShow="+isSlideShowNowValue+" Where ID="+ArticleID );
						Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','文章已被设为幻灯显示!','OK')</script>");
					}
					else{
						Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning')</script>");
					}
				}
				GridviewBind(); 
			}
			else if(e.CommandName == "pushedArticle"){
				MysqlHelp mh = new MysqlHelp();
				string ArticleID = e.CommandArgument.ToString();
				DataTable ArticleDt = new DataTable();
				ArticleDt = mh.GetDatabysql("Select isPushed From Article4DeepSoon Where ID="+ArticleID);
				if(ArticleDt.Rows.Count>0){
					string isPushed = ArticleDt.Rows[0]["isPushed"].ToString();
					string isPushedNowValue = "False";
					if(isPushed == "False")isPushedNowValue="True";
					else isPushedNowValue = "False";
					///操作权限检测
					if( hasRightTo("ArticleHeadTitle","设置文章推荐") ){
						mh.Runsql( "Update Article4DeepSoon Set isPushed="+isPushedNowValue+" Where ID="+ArticleID );
						Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','文章已被设为推荐显示!','OK')</script>");
					}
					else{
						Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning')</script>");
					}
				}
				GridviewBind(); 
			}
			else if(e.CommandName == "setPassed"){
				MysqlHelp mh = new MysqlHelp();
				string ArticleID = e.CommandArgument.ToString();
				DataTable ArticleDt = new DataTable();
				ArticleDt = mh.GetDatabysql("Select isPassed From Article4DeepSoon Where ID="+ArticleID);
				if(ArticleDt.Rows.Count>0){
					string isPassed = ArticleDt.Rows[0]["isPassed"].ToString();
					string isPassedValue = "False";
					if(isPassed == "False")isPassedValue="True";
					else isPassedValue = "False";
					///操作权限检测
					if( hasRightTo("ArticleCheck","审核文章") ){
						mh.Runsql( "Update Article4DeepSoon Set isPassed="+isPassedValue+" Where ID="+ArticleID );
						Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','文章状态已更新!','OK')</script>");
					}
					else{
						Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning')</script>");
					}
				}
				GridviewBind(); 
			}
		}
	
		protected void myGridView_RowDataBound(object sender, GridViewRowEventArgs e)
		{
			if (e.Row.RowType == DataControlRowType.DataRow)
			{
				//当鼠标在某一行上方时激发
				e.Row.Attributes.Add("onmouseover", "curColor=this.style.backgroundColor;this.style.backgroundColor='#F0F0F0'");
				//当鼠标从某一行上方移开时激发
				e.Row.Attributes.Add("onmouseout", "this.style.backgroundColor=curColor");
			}
		}
		
		protected void btnDelAll_Click(object sender, EventArgs e) 
		{ 
			string sqlText = "("; 
			int countNum = 0;//统计用户选取的记录数目
			for (int i = 0; i < myGridView.Rows.Count; i++) 
			{ 
				//搜索第n行3列 
				CheckBox cbx = (CheckBox)myGridView.Rows[i].FindControl("cbxId"); 
				if (cbx.Checked == true) 
				{ 
					sqlText = sqlText + Convert.ToInt32(myGridView.DataKeys[i].Value) + ",";
					countNum ++;
				} 
			} 
			//去掉最后的逗号，并且加上右括号 
			sqlText = sqlText.Substring(0,sqlText.Length - 1) + ")"; 
			if(countNum>0){///如果选择不为空
				sqlText = "Update Article4DeepSoon Set isDelete=true Where ID In" + sqlText; 
				MysqlHelp mh = new MysqlHelp();
				///操作权限检测
				if( hasRightTo("ArticleDelete","删除文章") ){
					mh.Runsql(sqlText);
					Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','文章已删除!','OK')</script>");
				}
				else{
					Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning')</script>");
				} 
			}
			GridviewBind(); 
		}
		
		protected void btnSelAll_Click(object sender, EventArgs e) 
		{ 
			for (int i = 0; i < myGridView.Rows.Count; i++) 
			{ 
				//搜索第n行3列 
				CheckBox cbx = (CheckBox)myGridView.Rows[i].FindControl("cbxId"); 
				cbx.Checked = true;
			}
		}
		
		protected void btnUnSelAll_Click(object sender, EventArgs e) 
		{ 
			for (int i = 0; i < myGridView.Rows.Count; i++) 
			{ 
				//搜索第n行3列 
				CheckBox cbx = (CheckBox)myGridView.Rows[i].FindControl("cbxId"); 
				cbx.Checked = false;
			}
		}


		#region 转到触发方法
		protected void btnGo_Click(object sender, EventArgs e)
		{
			if(((TextBox)myGridView.BottomPagerRow.FindControl("txtGoPage")).Text != ""){
				myGridView.PageIndex = int.Parse(((TextBox)myGridView.BottomPagerRow.FindControl("txtGoPage")).Text) - 1;
				GridviewBind();   //重新绑定GridView
				((TextBox)myGridView.BottomPagerRow.FindControl("txtGoPage")).Text = ""+(myGridView.PageIndex+1);
			}
		}
		#endregion
		
		
		/// <summary>
        /// DataTable中的数据导出到Excel并下载
        /// </summary>
        /// <param name="dt">要导出的DataTable</param>
        /// <param name="FileType">类型</param>
        /// <param name="FileName">Excel的文件名</param>
        public void CreateExcel(DataTable dt, string FileType, string FileName)
        {
            Response.Clear();
            Response.Charset = "UTF-8";
            Response.Buffer = true;
            Response.ContentEncoding = System.Text.Encoding.GetEncoding("GB2312");
            Response.AppendHeader("Content-Disposition", "attachment;filename=\"" + System.Web.HttpUtility.UrlEncode(FileName, System.Text.Encoding.UTF8) + ".xls\"");
            Response.ContentType = FileType;///application/x-xls
            string colHeaders = string.Empty;
            string ls_item = string.Empty;
            DataRow[] myRow = dt.Select();
            int i = 0;
            int cl = dt.Columns.Count;
			ls_item += "标题\t分类\t来源\t作者\t更新时间\n";
                
            foreach (DataRow row in myRow)
            {
				for (i = 0; i < cl; i++)
                {
					if (i == (cl - 1))
                    {
                        ls_item += row[i].ToString() + "\n";
                    }
                    else
                    {
                        ls_item += row[i].ToString() + "\t";
                    }
                }
                Response.Output.Write(ls_item);
                ls_item = string.Empty;
            }
            Response.Output.Flush();
            Response.End();
        }
 
		protected void btnExport_Click(object sender, EventArgs e) 
		{ 
			///创建数据连接对象：
			MysqlHelp mh = new MysqlHelp();
			DataTable dt=new DataTable();
			dt = mh.GetDatabysql("Select Title,Name,Source,Author,DateStr From Article4DeepSoon,Class4DeepSoon Where Author='"+base.strUser+"' and ClassID=Class4DeepSoon.ID and isDelete=false and isPassed=true Order By Article4DeepSoon.ID DESC");
			CreateExcel(dt,"application/x-xls","我的文章-数据表");
		}
		
		protected void btnSearch_Click(object sender, EventArgs e)
		{		
			string keyWord = this.keyWord.Text;
			if(keyWord != "")
				Response.Redirect("ArticleSearchResult.aspx?KeyWord="+keyWord);
		}
    }
	//End MyArticle Class
	
	
	/* 
	类名: ArticleSearchResult 
	功能：文章搜索类
	作者：书红
	*/
	//Start ArticleSearchResult Class
	 public partial class ArticleSearchResult : PageBase
    {
		string KeyWord = null;
		DeepSoonHelp dh = null;
		
		protected void Page_Load(object sender, EventArgs e)
        {		
			KeyWord = Request.QueryString["KeyWord"];
			if(KeyWord.Length>20)KeyWord = KeyWord.Substring(0,20);
			this.labelAdminTitle.Text = "[搜索结果] 搜索 <font color=#fb1105>"+KeyWord+"</font> 的结果";
			
			dh=new DeepSoonHelp();
			
			btnDelAll.Attributes.Add("onclick","return confirm(\"是否确认删除？\")") ;
			keyWord.Attributes.Add("onblur","if(this.value=='')value='搜索文章';");
			keyWord.Attributes.Add("onfocus","if(this.value=='搜索文章')value='';");
			keyWord.Attributes.Add("onkeydown","if (event.keyCode==13) {}");
			
			if (!IsPostBack) 
			{ 
				///操作权限检测
				if( hasRightTo("ArticleSelect","查看文章列表") && dh.notHasSQLInsertCode(KeyWord) ){
					GridviewBind();
				}
				else{
					Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning')</script>");
				}
			}
        }
		
		public string GetM(string strm)
		{
			if(strm == "False")
				return "<img src='../images/slideIconGray.png' title='设置幻灯' style='margin-bottom:-2px;'> 幻灯";
			else
				return "<img src='../images/slideIcon.png' title='取消幻灯' style='margin-bottom:-2px;'> 取消";
		}
		
		public string GetP(string strm)
		{
			if(strm == "False")
				return "<img src='../images/slideIconGray.png' title='设置推荐' style='margin-bottom:-2px;'> 推荐";
			else
				return "<img src='../images/slideIcon.png' title='取消推荐' style='margin-bottom:-2px;'> 取消";
		}
		
		public string GetS(string strm)
		{
			if(strm == "False")
				return "<img src='../images/isPassIcon.png' title='未审核' style='margin-bottom:-2px;'> 未审核";
			else
				return "<img src='../images/isPassIconGray.png' title='已审核' style='margin-bottom:-2px;'> <span class='grayFont'>已审核</span>";
		}
		
		public string GetStyle(string strm)
		{
			if(strm == "False")
				return "<img src='../images/docicon.png' title='普通文档' >";
			else
				return "<img src='../images/URLicon.png' title='外链文章'>";
		}
		
		public string GetTitle(string titleStr)
		{
			string Title = titleStr.Replace(KeyWord,"<font color=#fb1105>"+KeyWord+"</font>");
			return Title;
		}
		
		
		protected void GridviewBind() 
		{ 
			///创建数据连接对象：
			MysqlHelp mh = new MysqlHelp();
			///查询文章表中classID在子类集中的记录
			DataTable dt=new DataTable();
			dt = mh.GetDatabysql("Select Article4DeepSoon.ID,Title,Name,Source,Author,DateStr,isSlideShow,isPassed,isPushed,isSetURL From Article4DeepSoon,Class4DeepSoon Where Title like '%"+KeyWord+"%' and ClassID=Class4DeepSoon.ID and isDelete=false Order By ID DESC");
			myGridView.DataSource = dt;        
			myGridView.DataBind();
		}
	
		protected void myGridView_PageIndexChanging(object sender, GridViewPageEventArgs e)
		{
			myGridView.PageIndex = e.NewPageIndex;
			GridviewBind();//重新执行自定义的GridView数据绑定函数
			((TextBox)myGridView.BottomPagerRow.FindControl("txtGoPage")).Text = ""+(myGridView.PageIndex+1);
		}
		
		protected void myGridView_RowCommand(object sender, GridViewCommandEventArgs e) 
		{ 
			if(e.CommandName == "editArticle"){
				Response.Write("获取的ID"+e.CommandArgument.ToString() );
				Response.Redirect( "ArticleUpdate.aspx?ID="+e.CommandArgument.ToString() );
			}
			else if(e.CommandName == "deleteArticle"){
				///创建数据连接对象：
				MysqlHelp mh = new MysqlHelp();
				MySqlParameter[] updateParms ={new MySqlParameter("?ID",MySqlDbType.VarChar,8)};
				updateParms[0].Value = ""+e.CommandArgument.ToString();
				///操作权限检测
				if( hasRightTo("ArticleDelete","删除文章") ){
					mh.Runsql("Update Article4DeepSoon Set isDelete=true Where ID=?ID", updateParms);		
					GridviewBind();
					Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','文章已删除!','OK')</script>");
				}
				else{
					Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning')</script>");
				}
			}
			else if(e.CommandName == "headTitleArticle"){
				MysqlHelp mh = new MysqlHelp();
				DataTable dt = new DataTable();
				dt = mh.GetDatabysql("Select * From HeadTitle4DeepSoon");
				if(dt.Rows.Count>0){
					MySqlParameter[] updateHeadTitleParms ={new MySqlParameter("?ArticleID",MySqlDbType.VarChar,8)};
					updateHeadTitleParms[0].Value = ""+e.CommandArgument.ToString();
					///操作权限检测
					if( hasRightTo("ArticleHeadTitle","设置文章头条") ){
						mh.Runsql("Update HeadTitle4DeepSoon Set ArticleID=?ArticleID", updateHeadTitleParms);
						Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','设置文章头条成功!','OK')</script>");
					}
					else{
						Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning')</script>");
					}
				}
				else {
					mh.Runsql("insert into HeadTitle4DeepSoon(ArticleID) Values ("+e.CommandArgument.ToString()+")");
				}
				GridviewBind(); 
			}
			else if(e.CommandName == "slideShowArticle"){
				MysqlHelp mh = new MysqlHelp();
				string ArticleID = e.CommandArgument.ToString();
				DataTable ArticleDt = new DataTable();
				ArticleDt = mh.GetDatabysql("Select isSlideShow From Article4DeepSoon Where ID="+ArticleID);
				if(ArticleDt.Rows.Count>0){
					string isSlideShow = ArticleDt.Rows[0]["isSlideShow"].ToString();
					string isSlideShowNowValue = "False";
					if(isSlideShow == "False")isSlideShowNowValue="True";
					else isSlideShowNowValue = "False";
					///操作权限检测
					if( hasRightTo("ArticleSetIndexPic","设置文章幻灯") ){
						mh.Runsql( "Update Article4DeepSoon Set isSlideShow="+isSlideShowNowValue+" Where ID="+ArticleID );
						Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','文章已被设为幻灯显示!','OK')</script>");
					}
					else{
						Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning')</script>");
					}
				}
				GridviewBind(); 
			}
			else if(e.CommandName == "pushedArticle"){
				MysqlHelp mh = new MysqlHelp();
				string ArticleID = e.CommandArgument.ToString();
				DataTable ArticleDt = new DataTable();
				ArticleDt = mh.GetDatabysql("Select isPushed From Article4DeepSoon Where ID="+ArticleID);
				if(ArticleDt.Rows.Count>0){
					string isPushed = ArticleDt.Rows[0]["isPushed"].ToString();
					string isPushedNowValue = "False";
					if(isPushed == "False")isPushedNowValue="True";
					else isPushedNowValue = "False";
					///操作权限检测
					if( hasRightTo("ArticleHeadTitle","设置文章推荐") ){
						mh.Runsql( "Update Article4DeepSoon Set isPushed="+isPushedNowValue+" Where ID="+ArticleID );
						Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','文章已被设为推荐显示!','OK')</script>");
					}
					else{
						Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning')</script>");
					}
				}
				GridviewBind(); 
			}
			else if(e.CommandName == "setPassed"){
				MysqlHelp mh = new MysqlHelp();
				string ArticleID = e.CommandArgument.ToString();
				DataTable ArticleDt = new DataTable();
				ArticleDt = mh.GetDatabysql("Select isPassed From Article4DeepSoon Where ID="+ArticleID);
				if(ArticleDt.Rows.Count>0){
					string isPassed = ArticleDt.Rows[0]["isPassed"].ToString();
					string isPassedValue = "False";
					if(isPassed == "False")isPassedValue="True";
					else isPassedValue = "False";
					///操作权限检测
					if( hasRightTo("ArticleCheck","审核文章") ){
						mh.Runsql( "Update Article4DeepSoon Set isPassed="+isPassedValue+" Where ID="+ArticleID );
						Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','文章状态已更新!','OK')</script>");
					}
					else{
						Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning')</script>");
					}
				}
				GridviewBind(); 
			}
		}
	
		protected void myGridView_RowDataBound(object sender, GridViewRowEventArgs e)
		{
			if (e.Row.RowType == DataControlRowType.DataRow)
			{
				//当鼠标在某一行上方时激发
				e.Row.Attributes.Add("onmouseover", "curColor=this.style.backgroundColor;this.style.backgroundColor='#F0F0F0'");
				//当鼠标从某一行上方移开时激发
				e.Row.Attributes.Add("onmouseout", "this.style.backgroundColor=curColor");
			}
		}
		
		protected void btnDelAll_Click(object sender, EventArgs e) 
		{ 
			string sqlText = "("; 
			int countNum = 0;//统计用户选取的记录数目
			for (int i = 0; i < myGridView.Rows.Count; i++) 
			{ 
				//搜索第n行3列 
				CheckBox cbx = (CheckBox)myGridView.Rows[i].FindControl("cbxId"); 
				if (cbx.Checked == true) 
				{ 
					sqlText = sqlText + Convert.ToInt32(myGridView.DataKeys[i].Value) + ",";
					countNum ++;
				} 
			} 
			//去掉最后的逗号，并且加上右括号 
			sqlText = sqlText.Substring(0,sqlText.Length - 1) + ")"; 
			if(countNum>0){///如果选择不为空
				sqlText = "Update Article4DeepSoon Set isDelete=true Where ID In" + sqlText; 
				MysqlHelp mh = new MysqlHelp();
				///操作权限检测
				if( hasRightTo("ArticleDelete","删除文章") ){
					mh.Runsql(sqlText);
					Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','文章已删除!','OK')</script>");
				}
				else{
					Page.ClientScript.RegisterStartupScript(GetType(), "errorInfor", "<script language='JavaScript'>CxcDialog('提示框','您所在的用户组无权进行本操作!','Warning')</script>");
				} 
			}
			GridviewBind(); 
		}
		
		protected void btnSelAll_Click(object sender, EventArgs e) 
		{ 
			for (int i = 0; i < myGridView.Rows.Count; i++) 
			{ 
				//搜索第n行3列 
				CheckBox cbx = (CheckBox)myGridView.Rows[i].FindControl("cbxId"); 
				cbx.Checked = true;
			}
		}
		
		protected void btnUnSelAll_Click(object sender, EventArgs e) 
		{ 
			for (int i = 0; i < myGridView.Rows.Count; i++) 
			{ 
				//搜索第n行3列 
				CheckBox cbx = (CheckBox)myGridView.Rows[i].FindControl("cbxId"); 
				cbx.Checked = false;
			}
		}


		#region 转到触发方法
		protected void btnGo_Click(object sender, EventArgs e)
		{
			if(((TextBox)myGridView.BottomPagerRow.FindControl("txtGoPage")).Text != ""){
				myGridView.PageIndex = int.Parse(((TextBox)myGridView.BottomPagerRow.FindControl("txtGoPage")).Text) - 1;
				GridviewBind();   //重新绑定GridView
				((TextBox)myGridView.BottomPagerRow.FindControl("txtGoPage")).Text = ""+(myGridView.PageIndex+1);
			}
		}
		#endregion
		
		
		/// <summary>
        /// DataTable中的数据导出到Excel并下载
        /// </summary>
        /// <param name="dt">要导出的DataTable</param>
        /// <param name="FileType">类型</param>
        /// <param name="FileName">Excel的文件名</param>
        public void CreateExcel(DataTable dt, string FileType, string FileName)
        {
            Response.Clear();
            Response.Charset = "UTF-8";
            Response.Buffer = true;
            Response.ContentEncoding = System.Text.Encoding.GetEncoding("GB2312");
            Response.AppendHeader("Content-Disposition", "attachment;filename=\"" + System.Web.HttpUtility.UrlEncode(FileName, System.Text.Encoding.UTF8) + ".xls\"");
            Response.ContentType = FileType;///application/x-xls
            string colHeaders = string.Empty;
            string ls_item = string.Empty;
            DataRow[] myRow = dt.Select();
            int i = 0;
            int cl = dt.Columns.Count;
			ls_item += "标题\t分类\t来源\t作者\t更新时间\n";
                
            foreach (DataRow row in myRow)
            {
				for (i = 0; i < cl; i++)
                {
					if (i == (cl - 1))
                    {
                        ls_item += row[i].ToString() + "\n";
                    }
                    else
                    {
                        ls_item += row[i].ToString() + "\t";
                    }
                }
                Response.Output.Write(ls_item);
                ls_item = string.Empty;
            }
            Response.Output.Flush();
            Response.End();
        }
 
		protected void btnExport_Click(object sender, EventArgs e) 
		{ 
			///创建数据连接对象：
			MysqlHelp mh = new MysqlHelp();
			DataTable dt=new DataTable();
			dt = mh.GetDatabysql("Select Title,Name,Source,Author,DateStr From Article4DeepSoon,Class4DeepSoon Where Title like '%"+KeyWord+"%' and ClassID=Class4DeepSoon.ID and isDelete=false and isPassed=true Order By Article4DeepSoon.ID DESC");
			CreateExcel(dt,"application/x-xls","搜索结果-数据表");
		}
		
		protected void btnSearch_Click(object sender, EventArgs e)
		{		
			string keyWord = this.keyWord.Text;
			if(keyWord != "")
				Response.Redirect("ArticleSearchResult.aspx?KeyWord="+keyWord);
		}
		
    }
	//End ArticleSearchResult Class
	
	
}//end nameSpace