# Code of Conduct

The Deepgram developer community is filled with amazing, clever and creative people, and we're excited for you to join us. Our goal is to create safe and inclusive spaces, have meaningful conversations, and explore ways to make sure that every voice is heard and understood.

#### Being a Good Community Member

Because we prioritize creating a safe space for our members, we believe in actively working on how we, as individuals, can ensure a positive community environment through our own actions and mindsets.

Every supportive community starts with each member. We feel it’s important to be open to others, respectful, and supportive. As part of the Deepgram community, please begin by thinking carefully about and agreeing with the following statements:

- I will be welcoming to everyone at the table;
- I will be patient and open to learning from everyone around me;
- I will treat everyone with respect, because they deserve it;
- I will be mindful of the needs and boundaries of others;

We strive to create a space where we learn and grow together. Here are some other key things you can do to make the community great:

### BE HUMBLE

People come from all different places, and it’s best not to make assumptions about what they think or feel. Approach others with curiosity and openness. We **all** have a lot to learn from each other.

### BE HELPFUL

If someone asks for help, consider jumping in. You don’t have to be an expert to talk through a problem, suggest a resource, or help find a solution. We all have something to contribute.

### ENCOURAGE OTHERS

There’s no one path to have a career in technology or to this community. Let’s engage others in ways that create opportunities for learning and fun for all of us.

## Our Pledge

Everyone who participates in our community must agree to abide by our Code of Conduct. By agreeing, you help create a welcoming, respectful, and friendly community based on respect and trust. We are committed to creating a harassment-free community.

These rules will be strictly enforced in any and all of our official spaces, including direct messages, social media, and physical and virtual events. Everyone who participates in these spaces is required to agree to this community code. We also ask and expect community members to observe these rules anywhere the community is meeting (for example, online chats on unofficial platforms or event after-parties).

## Our Standards

### BE RESPECTFUL

Exercise consideration and respect in your speech and actions. Be willing to accept and give feedback gracefully.

Don’t make offensive comments related to gender, gender identity and expression, sexual orientation, disability, mental illness, neuro(a)typicality, physical appearance, body size, race, ethnicity, immigration status, religion, experience level, socioeconomic status, nationality, or other identity markers.

Additionally, don’t insult or demean others. This includes making unwelcome comments about a person’s lifestyle choices and practices, including things related to diet, health, parenting, drugs, or employment. It’s not okay to insult or demean others if it’s "just a joke."

### BE WELCOMING AND OPEN

Encourage others, be supportive and willing to listen, and be willing to learn from others’ perspectives and experiences. Lead with empathy and kindness.

Don’t engage in gatekeeping behaviors, like questioning the intelligence or knowledge of others as a way to prove their credentials. And don’t exclude people for prejudicial reasons.

### RESPECT PRIVACY

Do not publish private communications without consent. Additionally, never disclose private aspects of a person’s personal identity without consent, except as necessary to protect them from intentional abuse.

### RESPECT PERSONAL BOUNDARIES

Do not introduce gratuitous or off-topic sexual images, languages, or behavior in spaces where they are not appropriate. Never make physical contact or simulated physical contact without consent or after a request to stop. Additionally, do not continue to message others about anything if they ask you to stop or leave them alone.

#### BE A GOOD NEIGHBOR

Contribute to the community in a positive and thoughtful way. Consider what’s best for the overall community. Do not make threats of violence, intimidate others, incite violence or intimidation against others, incite self-harm, stalk, follow, or otherwise harass others. Be mindful of your surroundings and of your fellow participants.

Alert community leaders if you notice a dangerous situation, someone in distress, or violations of this Code of Conduct, even if they seem inconsequential.

# Additional rules for online spaces

For Deepgram’s official online spaces, like our YouTube & Twitch chats, we have some additional rules. Any of the following behaviors can result in a ban without warning.

### DON'T SPAM

Don't spam. We'll ban you.

### KEEP IT LEGAL

If it’s illegal, it’s not allowed on our websites or in our online spaces. Please don’t share links to pirated material or other nefarious things.

### NO TROLLING

Please be earnest. Don’t use excessive sarcasm to annoy or undermine other people. And don’t bait them with bad faith comments or abuse.

### PORNOGRAPHY AND OTHER NSFW STUFF

Please don’t post it or link to it. It doesn’t belong in our online spaces.

### FOUL AND GRAPHIC LANGUAGE

Please do not use excessive curse words. Additionally, do not use graphic sexual or violent language — again, think of our spaces as places for people of all ages.

# Enforcement & Reporting

If you are being harassed by a member of the Deepgram developer community, if you observe someone else being harassed, or you experience actions or behaviors that are contrary to our Code of Conduct, please report the behavior by contacting our team at [devrel@deepgram.com](mailto:devrel@deepgram.com).

## Enforcement Guidelines

Community leaders will follow these Community Impact Guidelines in determining the consequences for any action they deem in violation of this Code of Conduct:

### 1. Correction

**_Community Impact:_** Use of inappropriate language or other behavior deemed unprofessional or unwelcome in the community.

**_Consequence:_** A private, written warning from community leaders, providing clarity around the nature of the violation and an explanation of why the behavior was inappropriate. A public apology may be requested.

### 2. Warning

**_Community Impact:_** A violation through a single incident or series of actions.

**_Consequence:_** A warning with consequences for continued behavior. No interaction with the people involved, including unsolicited interaction with those enforcing the Code of Conduct, for a specified period of time. This includes avoiding interactions in community spaces as well as external channels like social media. Violating these terms may lead to a temporary or permanent ban.

### 3. Temporary Ban

**_Community Impact:_** A serious violation of community standards, including sustained inappropriate behavior.

**_Consequence:_** A temporary ban from any sort of interaction or public communication with the community for a specified period of time. No public or private interaction with the people involved, including unsolicited interaction with those enforcing the Code of Conduct, is allowed during this period. Violating these terms may lead to a permanent ban.

### 4. Permanent Ban

**_Community Impact:_** Demonstrating a pattern of violation of community standards, including sustained inappropriate behavior, harassment of an individual, or aggression toward or disparagement of classes of individuals.

**_Consequence:_** A permanent ban from any sort of public interaction within the community.

# Attribution

This Code of Conduct is adapted from:

- Contributor Covenant, version 2.0, available at https://www.contributor-covenant.org/version/2/0/code_of_conduct
- https://eventhandler.community/conduct/, which itself is inspired by Quest, who in turn provides credit to Scripto, the #botALLY Code of Conduct, the LGBTQ in Tech code of Conduct, and the XOXO Code of Conduct.

Community Impact Guidelines, which were copied from InnerSource Commons, were inspired by Mozilla’s code of conduct enforcement ladder.

For answers to common questions about this code of conduct, see the FAQ at https://www.contributor-covenant.org/faq. Translations are available at https://www.contributor-covenant.org/translations.
