# Contributing Guidelines

Pull requests are the easiest way to contribute changes to git repos at Github.
They are the preferred contribution method, as they offer a nice way for
commenting and amending the proposed changes.

* You need a local "fork" of the GitHub repo.
* Use a branch for your changes. That separates the changes in the pull request from your other changes and makes it easy to edit/amend commits in the pull request. When you're ready:
  - Make sure your fork is up to date.
  - Create and checkout the branch on your fork.
  - Edit changes and commit them locally.
  - Push them to your GitHub fork.
  - Visit GitHub and you should see a proposal to create a pull request.

* If you later need to add new commits to the pull request, you can simply commit the changes to the local branch and then use `git push` to automatically update the pull request.

* If you need to change something in the existing pull request, you can use `git push -f` to overwrite the original commits. That is easy and safe when using a feature branch.
