# Generated by Django 4.1 on 2022-09-18 22:47

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
from django.apps.registry import Apps
from django.db.backends.base.schema import BaseDatabaseSchemaEditor
import django.db.migrations.operations.special


def move_to_user(apps: Apps, schema_editor: BaseDatabaseSchemaEditor) -> None:
    """
    For ProjectMembers with a non-anonymous profile, move the profile to the user field. Delete any anonymous ones.
    """
    ProjectMember = apps.get_model("coreapp", "ProjectMember")
    for row in ProjectMember.objects.all():
        if row.profile.user:
            row.user = row.profile.user
            row.save()
        else:
            row.delete()


def delete_all_project_members(
    apps: Apps, schema_editor: BaseDatabaseSchemaEditor
) -> None:
    """
    Delete all ProjectMembers.
    """
    ProjectMember = apps.get_model("coreapp", "ProjectMember")
    ProjectMember.objects.all().delete()


class Migration(migrations.Migration):
    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("coreapp", "0025_profile_pseudonym"),
    ]

    operations = [
        migrations.RemoveConstraint(
            model_name="projectmember",
            name="unique_project_member",
        ),
        migrations.AddField(
            model_name="projectmember",
            name="user",
            field=models.ForeignKey(
                default=0,
                on_delete=django.db.models.deletion.CASCADE,
                to=settings.AUTH_USER_MODEL,
            ),
            preserve_default=False,
        ),
        migrations.RunPython(
            code=move_to_user,
            reverse_code=django.db.migrations.operations.special.RunPython.noop,
        ),
        migrations.RemoveField(
            model_name="projectmember",
            name="profile",
        ),
        migrations.AddConstraint(
            model_name="projectmember",
            constraint=models.UniqueConstraint(
                fields=("project", "user"), name="unique_project_member"
            ),
        ),
        migrations.RunPython(
            code=django.db.migrations.operations.special.RunPython.noop,
            reverse_code=delete_all_project_members,
        ),
    ]
