# Generated by Django 4.1 on 2022-08-30 11:04

import django.db.migrations.operations.special
from django.apps.registry import Apps
from django.db import migrations, models
from django.db.backends.base.schema import BaseDatabaseSchemaEditor
import coreapp.models.profile


def populate_pseudonym(apps: Apps, schema_editor: BaseDatabaseSchemaEditor) -> None:
    """
    Populate the pseudonym field for all existing users
    """
    Profile = apps.get_model("coreapp", "Profile")
    for profile in Profile.objects.all():
        # This assigns a pseudonym to *all* existing profiles, anonymous or no.
        # As logged in users will never have their pseudonym used, and pseudonyms aren't unique,
        # this shouldn't be a problem.
        profile.pseudonym = coreapp.models.profile.generate_pseudonym()
        profile.save()


class Migration(migrations.Migration):
    dependencies = [
        ("coreapp", "0024_remove_psyq_as_compiler"),
    ]

    operations = [
        migrations.AddField(
            model_name="profile",
            name="pseudonym",
            field=models.CharField(
                default=coreapp.models.profile.generate_pseudonym, max_length=150
            ),
        ),
        migrations.RunPython(
            code=populate_pseudonym,
            reverse_code=django.db.migrations.operations.special.RunPython.noop,
        ),
    ]
