# Generated by Django 4.0.4 on 2022-06-12 07:32

import django.db.migrations.operations.special
from django.apps.registry import Apps
from django.db import migrations
from django.db.backends.base.schema import BaseDatabaseSchemaEditor


def unnull_diff_label(apps: Apps, schema_editor: BaseDatabaseSchemaEditor) -> None:
    Scratch = apps.get_model("coreapp", "Scratch")
    for row in Scratch.objects.only("diff_label").filter(diff_label__isnull=True):
        row.diff_label = ""
        row.save(update_fields=["diff_label"])


class Migration(migrations.Migration):
    dependencies = [
        ("coreapp", "0021_diff_flags_default"),
    ]

    operations = [
        migrations.RunPython(
            code=unnull_diff_label,
            reverse_code=django.db.migrations.operations.special.RunPython.noop,
        ),
    ]
