# Generated by Django 3.2.6 on 2022-01-03 14:34

import django.db.migrations.operations.special
from django.apps.registry import Apps
from django.db import migrations, models
from django.db.backends.base.schema import BaseDatabaseSchemaEditor


def populate_name(apps: Apps, schema_editor: BaseDatabaseSchemaEditor) -> None:
    """
    Populate the name field for all existing scratches
    """
    Scratch = apps.get_model("coreapp", "Scratch")
    for row in Scratch.objects.all():
        if not row.name:
            row.name = "Untitled"
        row.save()


class Migration(migrations.Migration):
    dependencies = [
        ("coreapp", "0012_alter_scratch_name"),
    ]

    operations = [
        migrations.AlterModelOptions(
            name="scratch",
            options={"ordering": ["-creation_time"]},
        ),
        migrations.AlterField(
            model_name="scratch",
            name="name",
            field=models.CharField(default="Untitled", max_length=512),
        ),
        migrations.RunPython(
            code=populate_name,
            reverse_code=django.db.migrations.operations.special.RunPython.noop,
        ),
    ]
