# Generated by Django 3.2.4 on 2021-10-26 12:08

import django.db.migrations.operations.special
from django.apps.registry import Apps
from django.db import migrations, models
from django.db.backends.base.schema import BaseDatabaseSchemaEditor


def populate_compiler(apps: Apps, schema_editor: BaseDatabaseSchemaEditor) -> None:
    """
    Populate the compiler field for all existing scratches
    """
    Scratch = apps.get_model("coreapp", "Scratch")
    for row in Scratch.objects.all():
        row.compiler = row.compiler if row.compiler else "ido7.1"
        row.save()


class Migration(migrations.Migration):
    dependencies = [
        ("coreapp", "0007_rename_arch_scratch_platform"),
    ]

    operations = [
        migrations.AddField(
            model_name="scratch",
            name="max_score",
            field=models.IntegerField(default=-1),
        ),
        migrations.RemoveField(
            model_name="scratch",
            name="original_context",
        ),
        migrations.RenameField(
            model_name="compilation",
            old_name="cc_opts",
            new_name="compiler_flags",
        ),
        migrations.RenameField(
            model_name="scratch",
            old_name="cc_opts",
            new_name="compiler_flags",
        ),
        migrations.RunPython(
            code=populate_compiler,
            reverse_code=django.db.migrations.operations.special.RunPython.noop,
        ),
        migrations.AlterField(
            model_name="scratch",
            name="compiler",
            field=models.CharField(max_length=100),
        ),
    ]
