# Generated by Django 3.2.4 on 2021-08-26 10:41

from typing import List, Tuple

import django.db.models.deletion
from django.db import migrations, models

from ..models.scratch import gen_scratch_id


class Migration(migrations.Migration):
    initial = True

    dependencies: List[Tuple[str, str]] = []

    operations = [
        migrations.CreateModel(
            name="Asm",
            fields=[
                (
                    "hash",
                    models.CharField(max_length=64, primary_key=True, serialize=False),
                ),
                ("data", models.TextField()),
            ],
        ),
        migrations.CreateModel(
            name="Assembly",
            fields=[
                (
                    "hash",
                    models.CharField(max_length=64, primary_key=True, serialize=False),
                ),
                ("time", models.DateTimeField(auto_now_add=True)),
                ("arch", models.CharField(max_length=100)),
                ("as_opts", models.TextField(blank=True, max_length=1000, null=True)),
                ("elf_object", models.BinaryField(blank=True)),
                (
                    "source_asm",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="coreapp.asm"
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="Compilation",
            fields=[
                (
                    "hash",
                    models.CharField(max_length=64, primary_key=True, serialize=False),
                ),
                ("time", models.DateTimeField(auto_now_add=True)),
                ("compiler", models.CharField(max_length=100)),
                ("cc_opts", models.TextField(blank=True, max_length=1000, null=True)),
                ("source_code", models.TextField()),
                ("context", models.TextField(blank=True)),
                ("elf_object", models.BinaryField(blank=True)),
                ("stderr", models.TextField(blank=True, null=True)),
            ],
        ),
        migrations.CreateModel(
            name="Profile",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="Scratch",
            fields=[
                (
                    "slug",
                    models.SlugField(
                        default=gen_scratch_id, primary_key=True, serialize=False
                    ),
                ),
                ("creation_time", models.DateTimeField(auto_now_add=True)),
                ("last_updated", models.DateTimeField(auto_now=True)),
                ("compiler", models.CharField(blank=True, max_length=100)),
                ("cc_opts", models.TextField(blank=True, max_length=1000, null=True)),
                ("source_code", models.TextField(blank=True)),
                ("context", models.TextField(blank=True)),
                ("original_context", models.TextField(blank=True)),
                (
                    "owner",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="coreapp.profile",
                    ),
                ),
                (
                    "parent",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="coreapp.scratch",
                    ),
                ),
                (
                    "target_assembly",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="coreapp.assembly",
                    ),
                ),
            ],
        ),
    ]
