{*****************************************************************************

  Delphi Encryption Compendium (DEC Part I)
  Version 5.3 for Delphi 7 - 10.4 or higher/FPC 2.6 or higher

  Remarks:          Freeware, Copyright must be included

  Original Author:  (c) 2006 Hagen Reddmann, HaReddmann [at] T-Online [dot] de
  Modifications:    (c) 2008 Arvid Winkelsdorf, info [at] digivendo [dot] de
                    (c) 2017, 2021 decfpc

  Description:      Data Arrays

 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS ''AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*****************************************************************************}

unit DECData;

{$RANGECHECKS OFF}
{$WARNINGS OFF}

interface

const
  Square_SE: array[0..255] of Byte = (
    177, 206, 195, 149,  90, 173, 231,   2,  77,  68, 251, 145,  12, 135, 161,  80,
    203, 103,  84, 221,  70, 143, 225,  78, 240, 253, 252, 235, 249, 196,  26, 110,
     94, 245, 204, 141,  28,  86,  67, 254,   7,  97, 248, 117,  89, 255,   3,  34,
    138, 209,  19, 238, 136,   0,  14,  52,  21, 128, 148, 227, 237, 181,  83,  35,
     75,  71,  23, 167, 144,  53, 171, 216, 184, 223,  79,  87, 154, 146, 219,  27,
     60, 200, 153,   4, 142, 224, 215, 125, 133, 187,  64,  44,  58,  69, 241,  66,
    101,  32,  65,  24, 114,  37, 147, 112,  54,   5, 242,  11, 163, 121, 236,   8,
     39,  49,  50, 182, 124, 176,  10, 115,  91, 123, 183, 129, 210,  13, 106,  38,
    158,  88, 156, 131, 116, 179, 172,  48, 122, 105, 119,  15, 174,  33, 222, 208,
     46, 151,  16, 164, 152, 168, 212, 104,  45,  98,  41, 109,  22,  73, 118, 199,
    232, 193, 150,  55, 229, 202, 244, 233,  99,  18, 194, 166,  20, 188, 211,  40,
    175,  47, 230,  36,  82, 198, 160,   9, 189, 140, 207,  93,  17,  95,   1, 197,
    159,  61, 162, 155, 201,  59, 190,  81,  25,  31,  63,  92, 178, 239,  74, 205,
    191, 186, 111, 100, 217, 243,  62, 180, 170, 220, 213,   6, 192, 126, 246, 102,
    108, 132, 113,  56, 185,  29, 127, 157,  72, 139,  42, 218, 165,  51, 130,  57,
    214, 120, 134, 250, 228,  43, 169,  30, 137,  96, 107, 234,  85,  76, 247, 226);

  // by tol (to speed calculation up)
  Square_SEint: array[0..255] of LongWord = (
    177, 206, 195, 149,  90, 173, 231,   2,  77,  68, 251, 145,  12, 135, 161,  80,
    203, 103,  84, 221,  70, 143, 225,  78, 240, 253, 252, 235, 249, 196,  26, 110,
     94, 245, 204, 141,  28,  86,  67, 254,   7,  97, 248, 117,  89, 255,   3,  34,
    138, 209,  19, 238, 136,   0,  14,  52,  21, 128, 148, 227, 237, 181,  83,  35,
     75,  71,  23, 167, 144,  53, 171, 216, 184, 223,  79,  87, 154, 146, 219,  27,
     60, 200, 153,   4, 142, 224, 215, 125, 133, 187,  64,  44,  58,  69, 241,  66,
    101,  32,  65,  24, 114,  37, 147, 112,  54,   5, 242,  11, 163, 121, 236,   8,
     39,  49,  50, 182, 124, 176,  10, 115,  91, 123, 183, 129, 210,  13, 106,  38,
    158,  88, 156, 131, 116, 179, 172,  48, 122, 105, 119,  15, 174,  33, 222, 208,
     46, 151,  16, 164, 152, 168, 212, 104,  45,  98,  41, 109,  22,  73, 118, 199,
    232, 193, 150,  55, 229, 202, 244, 233,  99,  18, 194, 166,  20, 188, 211,  40,
    175,  47, 230,  36,  82, 198, 160,   9, 189, 140, 207,  93,  17,  95,   1, 197,
    159,  61, 162, 155, 201,  59, 190,  81,  25,  31,  63,  92, 178, 239,  74, 205,
    191, 186, 111, 100, 217, 243,  62, 180, 170, 220, 213,   6, 192, 126, 246, 102,
    108, 132, 113,  56, 185,  29, 127, 157,  72, 139,  42, 218, 165,  51, 130,  57,
    214, 120, 134, 250, 228,  43, 169,  30, 137,  96, 107, 234,  85,  76, 247, 226);


  Square_SD: array[0..255] of Byte = (
     53, 190,   7,  46,  83, 105, 219,  40, 111, 183, 118, 107,  12, 125,  54, 139,
    146, 188, 169,  50, 172,  56, 156,  66,  99, 200,  30,  79,  36, 229, 247, 201,
     97, 141,  47,  63, 179, 101, 127, 112, 175, 154, 234, 245,  91, 152, 144, 177,
    135, 113, 114, 237,  55,  69, 104, 163, 227, 239,  92, 197,  80, 193, 214, 202,
     90,  98,  95,  38,   9,  93,  20,  65, 232, 157, 206,  64, 253,   8,  23,  74,
     15, 199, 180,  62,  18, 252,  37,  75, 129,  44,   4, 120, 203, 187,  32, 189,
    249,  41, 153, 168, 211,  96, 223,  17, 151, 137, 126, 250, 224, 155,  31, 210,
    103, 226, 100, 119, 132,  43, 158, 138, 241, 109, 136, 121, 116,  87, 221, 230,
     57, 123, 238, 131, 225,  88, 242,  13,  52, 248,  48, 233, 185,  35,  84,  21,
     68,  11,  77, 102,  58,   3, 162, 145, 148,  82,  76, 195, 130, 231, 128, 192,
    182,  14, 194, 108, 147, 236, 171,  67, 149, 246, 216,  70, 134,   5, 140, 176,
    117,   0, 204, 133, 215,  61, 115, 122,  72, 228, 209,  89, 173, 184, 198, 208,
    220, 161, 170,   2,  29, 191, 181, 159,  81, 196, 165,  16,  34, 207,   1, 186,
    143,  49, 124, 174, 150, 218, 240,  86,  71, 212, 235,  78, 217,  19, 142,  73,
     85,  22, 255,  59, 244, 164, 178,   6, 160, 167, 251,  27, 110,  60,  51, 205,
     24,  94, 106, 213, 166,  33, 222, 254,  42,  28, 243,  10,  26,  25,  39,  45);

  Square_PHI: array[0..255] of LongWord = (
    $00000000,$03010102,$06020204,$05030306,$0C040408,$0F05050A,$0A06060C,$0907070E,
    $18080810,$1B090912,$1E0A0A14,$1D0B0B16,$140C0C18,$170D0D1A,$120E0E1C,$110F0F1E,
    $30101020,$33111122,$36121224,$35131326,$3C141428,$3F15152A,$3A16162C,$3917172E,
    $28181830,$2B191932,$2E1A1A34,$2D1B1B36,$241C1C38,$271D1D3A,$221E1E3C,$211F1F3E,
    $60202040,$63212142,$66222244,$65232346,$6C242448,$6F25254A,$6A26264C,$6927274E,
    $78282850,$7B292952,$7E2A2A54,$7D2B2B56,$742C2C58,$772D2D5A,$722E2E5C,$712F2F5E,
    $50303060,$53313162,$56323264,$55333366,$5C343468,$5F35356A,$5A36366C,$5937376E,
    $48383870,$4B393972,$4E3A3A74,$4D3B3B76,$443C3C78,$473D3D7A,$423E3E7C,$413F3F7E,
    $C0404080,$C3414182,$C6424284,$C5434386,$CC444488,$CF45458A,$CA46468C,$C947478E,
    $D8484890,$DB494992,$DE4A4A94,$DD4B4B96,$D44C4C98,$D74D4D9A,$D24E4E9C,$D14F4F9E,
    $F05050A0,$F35151A2,$F65252A4,$F55353A6,$FC5454A8,$FF5555AA,$FA5656AC,$F95757AE,
    $E85858B0,$EB5959B2,$EE5A5AB4,$ED5B5BB6,$E45C5CB8,$E75D5DBA,$E25E5EBC,$E15F5FBE,
    $A06060C0,$A36161C2,$A66262C4,$A56363C6,$AC6464C8,$AF6565CA,$AA6666CC,$A96767CE,
    $B86868D0,$BB6969D2,$BE6A6AD4,$BD6B6BD6,$B46C6CD8,$B76D6DDA,$B26E6EDC,$B16F6FDE,
    $907070E0,$937171E2,$967272E4,$957373E6,$9C7474E8,$9F7575EA,$9A7676EC,$997777EE,
    $887878F0,$8B7979F2,$8E7A7AF4,$8D7B7BF6,$847C7CF8,$877D7DFA,$827E7EFC,$817F7FFE,
    $758080F5,$768181F7,$738282F1,$708383F3,$798484FD,$7A8585FF,$7F8686F9,$7C8787FB,
    $6D8888E5,$6E8989E7,$6B8A8AE1,$688B8BE3,$618C8CED,$628D8DEF,$678E8EE9,$648F8FEB,
    $459090D5,$469191D7,$439292D1,$409393D3,$499494DD,$4A9595DF,$4F9696D9,$4C9797DB,
    $5D9898C5,$5E9999C7,$5B9A9AC1,$589B9BC3,$519C9CCD,$529D9DCF,$579E9EC9,$549F9FCB,
    $15A0A0B5,$16A1A1B7,$13A2A2B1,$10A3A3B3,$19A4A4BD,$1AA5A5BF,$1FA6A6B9,$1CA7A7BB,
    $0DA8A8A5,$0EA9A9A7,$0BAAAAA1,$08ABABA3,$01ACACAD,$02ADADAF,$07AEAEA9,$04AFAFAB,
    $25B0B095,$26B1B197,$23B2B291,$20B3B393,$29B4B49D,$2AB5B59F,$2FB6B699,$2CB7B79B,
    $3DB8B885,$3EB9B987,$3BBABA81,$38BBBB83,$31BCBC8D,$32BDBD8F,$37BEBE89,$34BFBF8B,
    $B5C0C075,$B6C1C177,$B3C2C271,$B0C3C373,$B9C4C47D,$BAC5C57F,$BFC6C679,$BCC7C77B,
    $ADC8C865,$AEC9C967,$ABCACA61,$A8CBCB63,$A1CCCC6D,$A2CDCD6F,$A7CECE69,$A4CFCF6B,
    $85D0D055,$86D1D157,$83D2D251,$80D3D353,$89D4D45D,$8AD5D55F,$8FD6D659,$8CD7D75B,
    $9DD8D845,$9ED9D947,$9BDADA41,$98DBDB43,$91DCDC4D,$92DDDD4F,$97DEDE49,$94DFDF4B,
    $D5E0E035,$D6E1E137,$D3E2E231,$D0E3E333,$D9E4E43D,$DAE5E53F,$DFE6E639,$DCE7E73B,
    $CDE8E825,$CEE9E927,$CBEAEA21,$C8EBEB23,$C1ECEC2D,$C2EDED2F,$C7EEEE29,$C4EFEF2B,
    $E5F0F015,$E6F1F117,$E3F2F211,$E0F3F313,$E9F4F41D,$EAF5F51F,$EFF6F619,$ECF7F71B,
    $FDF8F805,$FEF9F907,$FBFAFA01,$F8FBFB03,$F1FCFC0D,$F2FDFD0F,$F7FEFE09,$F4FFFF0B);

  // by tol: rotated PHI array (to speed calculation up)
  Square_PHIr: array[0..3, 0..255] of LongWord = (
   ($00000000,$03010102,$06020204,$05030306,$0C040408,$0F05050A,$0A06060C,$0907070E,
    $18080810,$1B090912,$1E0A0A14,$1D0B0B16,$140C0C18,$170D0D1A,$120E0E1C,$110F0F1E,
    $30101020,$33111122,$36121224,$35131326,$3C141428,$3F15152A,$3A16162C,$3917172E,
    $28181830,$2B191932,$2E1A1A34,$2D1B1B36,$241C1C38,$271D1D3A,$221E1E3C,$211F1F3E,
    $60202040,$63212142,$66222244,$65232346,$6C242448,$6F25254A,$6A26264C,$6927274E,
    $78282850,$7B292952,$7E2A2A54,$7D2B2B56,$742C2C58,$772D2D5A,$722E2E5C,$712F2F5E,
    $50303060,$53313162,$56323264,$55333366,$5C343468,$5F35356A,$5A36366C,$5937376E,
    $48383870,$4B393972,$4E3A3A74,$4D3B3B76,$443C3C78,$473D3D7A,$423E3E7C,$413F3F7E,
    $C0404080,$C3414182,$C6424284,$C5434386,$CC444488,$CF45458A,$CA46468C,$C947478E,
    $D8484890,$DB494992,$DE4A4A94,$DD4B4B96,$D44C4C98,$D74D4D9A,$D24E4E9C,$D14F4F9E,
    $F05050A0,$F35151A2,$F65252A4,$F55353A6,$FC5454A8,$FF5555AA,$FA5656AC,$F95757AE,
    $E85858B0,$EB5959B2,$EE5A5AB4,$ED5B5BB6,$E45C5CB8,$E75D5DBA,$E25E5EBC,$E15F5FBE,
    $A06060C0,$A36161C2,$A66262C4,$A56363C6,$AC6464C8,$AF6565CA,$AA6666CC,$A96767CE,
    $B86868D0,$BB6969D2,$BE6A6AD4,$BD6B6BD6,$B46C6CD8,$B76D6DDA,$B26E6EDC,$B16F6FDE,
    $907070E0,$937171E2,$967272E4,$957373E6,$9C7474E8,$9F7575EA,$9A7676EC,$997777EE,
    $887878F0,$8B7979F2,$8E7A7AF4,$8D7B7BF6,$847C7CF8,$877D7DFA,$827E7EFC,$817F7FFE,
    $758080F5,$768181F7,$738282F1,$708383F3,$798484FD,$7A8585FF,$7F8686F9,$7C8787FB,
    $6D8888E5,$6E8989E7,$6B8A8AE1,$688B8BE3,$618C8CED,$628D8DEF,$678E8EE9,$648F8FEB,
    $459090D5,$469191D7,$439292D1,$409393D3,$499494DD,$4A9595DF,$4F9696D9,$4C9797DB,
    $5D9898C5,$5E9999C7,$5B9A9AC1,$589B9BC3,$519C9CCD,$529D9DCF,$579E9EC9,$549F9FCB,
    $15A0A0B5,$16A1A1B7,$13A2A2B1,$10A3A3B3,$19A4A4BD,$1AA5A5BF,$1FA6A6B9,$1CA7A7BB,
    $0DA8A8A5,$0EA9A9A7,$0BAAAAA1,$08ABABA3,$01ACACAD,$02ADADAF,$07AEAEA9,$04AFAFAB,
    $25B0B095,$26B1B197,$23B2B291,$20B3B393,$29B4B49D,$2AB5B59F,$2FB6B699,$2CB7B79B,
    $3DB8B885,$3EB9B987,$3BBABA81,$38BBBB83,$31BCBC8D,$32BDBD8F,$37BEBE89,$34BFBF8B,
    $B5C0C075,$B6C1C177,$B3C2C271,$B0C3C373,$B9C4C47D,$BAC5C57F,$BFC6C679,$BCC7C77B,
    $ADC8C865,$AEC9C967,$ABCACA61,$A8CBCB63,$A1CCCC6D,$A2CDCD6F,$A7CECE69,$A4CFCF6B,
    $85D0D055,$86D1D157,$83D2D251,$80D3D353,$89D4D45D,$8AD5D55F,$8FD6D659,$8CD7D75B,
    $9DD8D845,$9ED9D947,$9BDADA41,$98DBDB43,$91DCDC4D,$92DDDD4F,$97DEDE49,$94DFDF4B,
    $D5E0E035,$D6E1E137,$D3E2E231,$D0E3E333,$D9E4E43D,$DAE5E53F,$DFE6E639,$DCE7E73B,
    $CDE8E825,$CEE9E927,$CBEAEA21,$C8EBEB23,$C1ECEC2D,$C2EDED2F,$C7EEEE29,$C4EFEF2B,
    $E5F0F015,$E6F1F117,$E3F2F211,$E0F3F313,$E9F4F41D,$EAF5F51F,$EFF6F619,$ECF7F71B,
    $FDF8F805,$FEF9F907,$FBFAFA01,$F8FBFB03,$F1FCFC0D,$F2FDFD0F,$F7FEFE09,$F4FFFF0B),
   ($00000000,$01010203,$02020406,$03030605,$0404080C,$05050A0F,$06060C0A,$07070E09,
    $08081018,$0909121B,$0A0A141E,$0B0B161D,$0C0C1814,$0D0D1A17,$0E0E1C12,$0F0F1E11,
    $10102030,$11112233,$12122436,$13132635,$1414283C,$15152A3F,$16162C3A,$17172E39,
    $18183028,$1919322B,$1A1A342E,$1B1B362D,$1C1C3824,$1D1D3A27,$1E1E3C22,$1F1F3E21,
    $20204060,$21214263,$22224466,$23234665,$2424486C,$25254A6F,$26264C6A,$27274E69,
    $28285078,$2929527B,$2A2A547E,$2B2B567D,$2C2C5874,$2D2D5A77,$2E2E5C72,$2F2F5E71,
    $30306050,$31316253,$32326456,$33336655,$3434685C,$35356A5F,$36366C5A,$37376E59,
    $38387048,$3939724B,$3A3A744E,$3B3B764D,$3C3C7844,$3D3D7A47,$3E3E7C42,$3F3F7E41,
    $404080C0,$414182C3,$424284C6,$434386C5,$444488CC,$45458ACF,$46468CCA,$47478EC9,
    $484890D8,$494992DB,$4A4A94DE,$4B4B96DD,$4C4C98D4,$4D4D9AD7,$4E4E9CD2,$4F4F9ED1,
    $5050A0F0,$5151A2F3,$5252A4F6,$5353A6F5,$5454A8FC,$5555AAFF,$5656ACFA,$5757AEF9,
    $5858B0E8,$5959B2EB,$5A5AB4EE,$5B5BB6ED,$5C5CB8E4,$5D5DBAE7,$5E5EBCE2,$5F5FBEE1,
    $6060C0A0,$6161C2A3,$6262C4A6,$6363C6A5,$6464C8AC,$6565CAAF,$6666CCAA,$6767CEA9,
    $6868D0B8,$6969D2BB,$6A6AD4BE,$6B6BD6BD,$6C6CD8B4,$6D6DDAB7,$6E6EDCB2,$6F6FDEB1,
    $7070E090,$7171E293,$7272E496,$7373E695,$7474E89C,$7575EA9F,$7676EC9A,$7777EE99,
    $7878F088,$7979F28B,$7A7AF48E,$7B7BF68D,$7C7CF884,$7D7DFA87,$7E7EFC82,$7F7FFE81,
    $8080F575,$8181F776,$8282F173,$8383F370,$8484FD79,$8585FF7A,$8686F97F,$8787FB7C,
    $8888E56D,$8989E76E,$8A8AE16B,$8B8BE368,$8C8CED61,$8D8DEF62,$8E8EE967,$8F8FEB64,
    $9090D545,$9191D746,$9292D143,$9393D340,$9494DD49,$9595DF4A,$9696D94F,$9797DB4C,
    $9898C55D,$9999C75E,$9A9AC15B,$9B9BC358,$9C9CCD51,$9D9DCF52,$9E9EC957,$9F9FCB54,
    $A0A0B515,$A1A1B716,$A2A2B113,$A3A3B310,$A4A4BD19,$A5A5BF1A,$A6A6B91F,$A7A7BB1C,
    $A8A8A50D,$A9A9A70E,$AAAAA10B,$ABABA308,$ACACAD01,$ADADAF02,$AEAEA907,$AFAFAB04,
    $B0B09525,$B1B19726,$B2B29123,$B3B39320,$B4B49D29,$B5B59F2A,$B6B6992F,$B7B79B2C,
    $B8B8853D,$B9B9873E,$BABA813B,$BBBB8338,$BCBC8D31,$BDBD8F32,$BEBE8937,$BFBF8B34,
    $C0C075B5,$C1C177B6,$C2C271B3,$C3C373B0,$C4C47DB9,$C5C57FBA,$C6C679BF,$C7C77BBC,
    $C8C865AD,$C9C967AE,$CACA61AB,$CBCB63A8,$CCCC6DA1,$CDCD6FA2,$CECE69A7,$CFCF6BA4,
    $D0D05585,$D1D15786,$D2D25183,$D3D35380,$D4D45D89,$D5D55F8A,$D6D6598F,$D7D75B8C,
    $D8D8459D,$D9D9479E,$DADA419B,$DBDB4398,$DCDC4D91,$DDDD4F92,$DEDE4997,$DFDF4B94,
    $E0E035D5,$E1E137D6,$E2E231D3,$E3E333D0,$E4E43DD9,$E5E53FDA,$E6E639DF,$E7E73BDC,
    $E8E825CD,$E9E927CE,$EAEA21CB,$EBEB23C8,$ECEC2DC1,$EDED2FC2,$EEEE29C7,$EFEF2BC4,
    $F0F015E5,$F1F117E6,$F2F211E3,$F3F313E0,$F4F41DE9,$F5F51FEA,$F6F619EF,$F7F71BEC,
    $F8F805FD,$F9F907FE,$FAFA01FB,$FBFB03F8,$FCFC0DF1,$FDFD0FF2,$FEFE09F7,$FFFF0BF4),
   ($00000000,$01020301,$02040602,$03060503,$04080C04,$050A0F05,$060C0A06,$070E0907,
    $08101808,$09121B09,$0A141E0A,$0B161D0B,$0C18140C,$0D1A170D,$0E1C120E,$0F1E110F,
    $10203010,$11223311,$12243612,$13263513,$14283C14,$152A3F15,$162C3A16,$172E3917,
    $18302818,$19322B19,$1A342E1A,$1B362D1B,$1C38241C,$1D3A271D,$1E3C221E,$1F3E211F,
    $20406020,$21426321,$22446622,$23466523,$24486C24,$254A6F25,$264C6A26,$274E6927,
    $28507828,$29527B29,$2A547E2A,$2B567D2B,$2C58742C,$2D5A772D,$2E5C722E,$2F5E712F,
    $30605030,$31625331,$32645632,$33665533,$34685C34,$356A5F35,$366C5A36,$376E5937,
    $38704838,$39724B39,$3A744E3A,$3B764D3B,$3C78443C,$3D7A473D,$3E7C423E,$3F7E413F,
    $4080C040,$4182C341,$4284C642,$4386C543,$4488CC44,$458ACF45,$468CCA46,$478EC947,
    $4890D848,$4992DB49,$4A94DE4A,$4B96DD4B,$4C98D44C,$4D9AD74D,$4E9CD24E,$4F9ED14F,
    $50A0F050,$51A2F351,$52A4F652,$53A6F553,$54A8FC54,$55AAFF55,$56ACFA56,$57AEF957,
    $58B0E858,$59B2EB59,$5AB4EE5A,$5BB6ED5B,$5CB8E45C,$5DBAE75D,$5EBCE25E,$5FBEE15F,
    $60C0A060,$61C2A361,$62C4A662,$63C6A563,$64C8AC64,$65CAAF65,$66CCAA66,$67CEA967,
    $68D0B868,$69D2BB69,$6AD4BE6A,$6BD6BD6B,$6CD8B46C,$6DDAB76D,$6EDCB26E,$6FDEB16F,
    $70E09070,$71E29371,$72E49672,$73E69573,$74E89C74,$75EA9F75,$76EC9A76,$77EE9977,
    $78F08878,$79F28B79,$7AF48E7A,$7BF68D7B,$7CF8847C,$7DFA877D,$7EFC827E,$7FFE817F,
    $80F57580,$81F77681,$82F17382,$83F37083,$84FD7984,$85FF7A85,$86F97F86,$87FB7C87,
    $88E56D88,$89E76E89,$8AE16B8A,$8BE3688B,$8CED618C,$8DEF628D,$8EE9678E,$8FEB648F,
    $90D54590,$91D74691,$92D14392,$93D34093,$94DD4994,$95DF4A95,$96D94F96,$97DB4C97,
    $98C55D98,$99C75E99,$9AC15B9A,$9BC3589B,$9CCD519C,$9DCF529D,$9EC9579E,$9FCB549F,
    $A0B515A0,$A1B716A1,$A2B113A2,$A3B310A3,$A4BD19A4,$A5BF1AA5,$A6B91FA6,$A7BB1CA7,
    $A8A50DA8,$A9A70EA9,$AAA10BAA,$ABA308AB,$ACAD01AC,$ADAF02AD,$AEA907AE,$AFAB04AF,
    $B09525B0,$B19726B1,$B29123B2,$B39320B3,$B49D29B4,$B59F2AB5,$B6992FB6,$B79B2CB7,
    $B8853DB8,$B9873EB9,$BA813BBA,$BB8338BB,$BC8D31BC,$BD8F32BD,$BE8937BE,$BF8B34BF,
    $C075B5C0,$C177B6C1,$C271B3C2,$C373B0C3,$C47DB9C4,$C57FBAC5,$C679BFC6,$C77BBCC7,
    $C865ADC8,$C967AEC9,$CA61ABCA,$CB63A8CB,$CC6DA1CC,$CD6FA2CD,$CE69A7CE,$CF6BA4CF,
    $D05585D0,$D15786D1,$D25183D2,$D35380D3,$D45D89D4,$D55F8AD5,$D6598FD6,$D75B8CD7,
    $D8459DD8,$D9479ED9,$DA419BDA,$DB4398DB,$DC4D91DC,$DD4F92DD,$DE4997DE,$DF4B94DF,
    $E035D5E0,$E137D6E1,$E231D3E2,$E333D0E3,$E43DD9E4,$E53FDAE5,$E639DFE6,$E73BDCE7,
    $E825CDE8,$E927CEE9,$EA21CBEA,$EB23C8EB,$EC2DC1EC,$ED2FC2ED,$EE29C7EE,$EF2BC4EF,
    $F015E5F0,$F117E6F1,$F211E3F2,$F313E0F3,$F41DE9F4,$F51FEAF5,$F619EFF6,$F71BECF7,
    $F805FDF8,$F907FEF9,$FA01FBFA,$FB03F8FB,$FC0DF1FC,$FD0FF2FD,$FE09F7FE,$FF0BF4FF),
   ($00000000,$02030101,$04060202,$06050303,$080C0404,$0A0F0505,$0C0A0606,$0E090707,
    $10180808,$121B0909,$141E0A0A,$161D0B0B,$18140C0C,$1A170D0D,$1C120E0E,$1E110F0F,
    $20301010,$22331111,$24361212,$26351313,$283C1414,$2A3F1515,$2C3A1616,$2E391717,
    $30281818,$322B1919,$342E1A1A,$362D1B1B,$38241C1C,$3A271D1D,$3C221E1E,$3E211F1F,
    $40602020,$42632121,$44662222,$46652323,$486C2424,$4A6F2525,$4C6A2626,$4E692727,
    $50782828,$527B2929,$547E2A2A,$567D2B2B,$58742C2C,$5A772D2D,$5C722E2E,$5E712F2F,
    $60503030,$62533131,$64563232,$66553333,$685C3434,$6A5F3535,$6C5A3636,$6E593737,
    $70483838,$724B3939,$744E3A3A,$764D3B3B,$78443C3C,$7A473D3D,$7C423E3E,$7E413F3F,
    $80C04040,$82C34141,$84C64242,$86C54343,$88CC4444,$8ACF4545,$8CCA4646,$8EC94747,
    $90D84848,$92DB4949,$94DE4A4A,$96DD4B4B,$98D44C4C,$9AD74D4D,$9CD24E4E,$9ED14F4F,
    $A0F05050,$A2F35151,$A4F65252,$A6F55353,$A8FC5454,$AAFF5555,$ACFA5656,$AEF95757,
    $B0E85858,$B2EB5959,$B4EE5A5A,$B6ED5B5B,$B8E45C5C,$BAE75D5D,$BCE25E5E,$BEE15F5F,
    $C0A06060,$C2A36161,$C4A66262,$C6A56363,$C8AC6464,$CAAF6565,$CCAA6666,$CEA96767,
    $D0B86868,$D2BB6969,$D4BE6A6A,$D6BD6B6B,$D8B46C6C,$DAB76D6D,$DCB26E6E,$DEB16F6F,
    $E0907070,$E2937171,$E4967272,$E6957373,$E89C7474,$EA9F7575,$EC9A7676,$EE997777,
    $F0887878,$F28B7979,$F48E7A7A,$F68D7B7B,$F8847C7C,$FA877D7D,$FC827E7E,$FE817F7F,
    $F5758080,$F7768181,$F1738282,$F3708383,$FD798484,$FF7A8585,$F97F8686,$FB7C8787,
    $E56D8888,$E76E8989,$E16B8A8A,$E3688B8B,$ED618C8C,$EF628D8D,$E9678E8E,$EB648F8F,
    $D5459090,$D7469191,$D1439292,$D3409393,$DD499494,$DF4A9595,$D94F9696,$DB4C9797,
    $C55D9898,$C75E9999,$C15B9A9A,$C3589B9B,$CD519C9C,$CF529D9D,$C9579E9E,$CB549F9F,
    $B515A0A0,$B716A1A1,$B113A2A2,$B310A3A3,$BD19A4A4,$BF1AA5A5,$B91FA6A6,$BB1CA7A7,
    $A50DA8A8,$A70EA9A9,$A10BAAAA,$A308ABAB,$AD01ACAC,$AF02ADAD,$A907AEAE,$AB04AFAF,
    $9525B0B0,$9726B1B1,$9123B2B2,$9320B3B3,$9D29B4B4,$9F2AB5B5,$992FB6B6,$9B2CB7B7,
    $853DB8B8,$873EB9B9,$813BBABA,$8338BBBB,$8D31BCBC,$8F32BDBD,$8937BEBE,$8B34BFBF,
    $75B5C0C0,$77B6C1C1,$71B3C2C2,$73B0C3C3,$7DB9C4C4,$7FBAC5C5,$79BFC6C6,$7BBCC7C7,
    $65ADC8C8,$67AEC9C9,$61ABCACA,$63A8CBCB,$6DA1CCCC,$6FA2CDCD,$69A7CECE,$6BA4CFCF,
    $5585D0D0,$5786D1D1,$5183D2D2,$5380D3D3,$5D89D4D4,$5F8AD5D5,$598FD6D6,$5B8CD7D7,
    $459DD8D8,$479ED9D9,$419BDADA,$4398DBDB,$4D91DCDC,$4F92DDDD,$4997DEDE,$4B94DFDF,
    $35D5E0E0,$37D6E1E1,$31D3E2E2,$33D0E3E3,$3DD9E4E4,$3FDAE5E5,$39DFE6E6,$3BDCE7E7,
    $25CDE8E8,$27CEE9E9,$21CBEAEA,$23C8EBEB,$2DC1ECEC,$2FC2EDED,$29C7EEEE,$2BC4EFEF,
    $15E5F0F0,$17E6F1F1,$11E3F2F2,$13E0F3F3,$1DE9F4F4,$1FEAF5F5,$19EFF6F6,$1BECF7F7,
    $05FDF8F8,$07FEF9F9,$01FBFAFA,$03F8FBFB,$0DF1FCFC,$0FF2FDFD,$09F7FEFE,$0BF4FFFF));


  Square_TE: array[0..3, 0..255] of LongWord = (
   ($26B1B197,$A7CECE69,$B0C3C373,$4A9595DF,$EE5A5AB4,$02ADADAF,$DCE7E73B,$06020204,
    $D74D4D9A,$CC444488,$F8FBFB03,$469191D7,$140C0C18,$7C8787FB,$16A1A1B7,$F05050A0,
    $A8CBCB63,$A96767CE,$FC5454A8,$92DDDD4F,$CA46468C,$648F8FEB,$D6E1E137,$D24E4E9C,
    $E5F0F015,$F2FDFD0F,$F1FCFC0D,$C8EBEB23,$FEF9F907,$B9C4C47D,$2E1A1A34,$B26E6EDC,
    $E25E5EBC,$EAF5F51F,$A1CCCC6D,$628D8DEF,$241C1C38,$FA5656AC,$C5434386,$F7FEFE09,
    $0907070E,$A36161C2,$FDF8F805,$9F7575EA,$EB5959B2,$F4FFFF0B,$05030306,$66222244,
    $6B8A8AE1,$86D1D157,$35131326,$C7EEEE29,$6D8888E5,$00000000,$120E0E1C,$5C343468,
    $3F15152A,$758080F5,$499494DD,$D0E3E333,$C2EDED2F,$2AB5B59F,$F55353A6,$65232346,
    $DD4B4B96,$C947478E,$3917172E,$1CA7A7BB,$459090D5,$5F35356A,$08ABABA3,$9DD8D845,
    $3DB8B885,$94DFDF4B,$D14F4F9E,$F95757AE,$5B9A9AC1,$439292D1,$98DBDB43,$2D1B1B36,
    $443C3C78,$ADC8C865,$5E9999C7,$0C040408,$678E8EE9,$D5E0E035,$8CD7D75B,$877D7DFA,
    $7A8585FF,$38BBBB83,$C0404080,$742C2C58,$4E3A3A74,$CF45458A,$E6F1F117,$C6424284,
    $AF6565CA,$60202040,$C3414182,$28181830,$967272E4,$6F25254A,$409393D3,$907070E0,
    $5A36366C,$0F05050A,$E3F2F211,$1D0B0B16,$10A3A3B3,$8B7979F2,$C1ECEC2D,$18080810,
    $6927274E,$53313162,$56323264,$2FB6B699,$847C7CF8,$25B0B095,$1E0A0A14,$957373E6,
    $ED5B5BB6,$8D7B7BF6,$2CB7B79B,$768181F7,$83D2D251,$170D0D1A,$BE6A6AD4,$6A26264C,
    $579E9EC9,$E85858B0,$519C9CCD,$708383F3,$9C7474E8,$20B3B393,$01ACACAD,$50303060,
    $8E7A7AF4,$BB6969D2,$997777EE,$110F0F1E,$07AEAEA9,$63212142,$97DEDE49,$85D0D055,
    $722E2E5C,$4C9797DB,$30101020,$19A4A4BD,$5D9898C5,$0DA8A8A5,$89D4D45D,$B86868D0,
    $772D2D5A,$A66262C4,$7B292952,$B76D6DDA,$3A16162C,$DB494992,$9A7676EC,$BCC7C77B,
    $CDE8E825,$B6C1C177,$4F9696D9,$5937376E,$DAE5E53F,$ABCACA61,$E9F4F41D,$CEE9E927,
    $A56363C6,$36121224,$B3C2C271,$1FA6A6B9,$3C141428,$31BCBC8D,$80D3D353,$78282850,
    $04AFAFAB,$712F2F5E,$DFE6E639,$6C242448,$F65252A4,$BFC6C679,$15A0A0B5,$1B090912,
    $32BDBD8F,$618C8CED,$A4CFCF6B,$E75D5DBA,$33111122,$E15F5FBE,$03010102,$BAC5C57F,
    $549F9FCB,$473D3D7A,$13A2A2B1,$589B9BC3,$AEC9C967,$4D3B3B76,$37BEBE89,$F35151A2,
    $2B191932,$211F1F3E,$413F3F7E,$E45C5CB8,$23B2B291,$C4EFEF2B,$DE4A4A94,$A2CDCD6F,
    $34BFBF8B,$3BBABA81,$B16F6FDE,$AC6464C8,$9ED9D947,$E0F3F313,$423E3E7C,$29B4B49D,
    $0BAAAAA1,$91DCDC4D,$8AD5D55F,$0A06060C,$B5C0C075,$827E7EFC,$EFF6F619,$AA6666CC,
    $B46C6CD8,$798484FD,$937171E2,$48383870,$3EB9B987,$271D1D3A,$817F7FFE,$529D9DCF,
    $D8484890,$688B8BE3,$7E2A2A54,$9BDADA41,$1AA5A5BF,$55333366,$738282F1,$4B393972,
    $8FD6D659,$887878F0,$7F8686F9,$FBFAFA01,$D9E4E43D,$7D2B2B56,$0EA9A9A7,$221E1E3C,
    $6E8989E7,$A06060C0,$BD6B6BD6,$CBEAEA21,$FF5555AA,$D44C4C98,$ECF7F71B,$D3E2E231),
   ($B1B19726,$CECE69A7,$C3C373B0,$9595DF4A,$5A5AB4EE,$ADADAF02,$E7E73BDC,$02020406,
    $4D4D9AD7,$444488CC,$FBFB03F8,$9191D746,$0C0C1814,$8787FB7C,$A1A1B716,$5050A0F0,
    $CBCB63A8,$6767CEA9,$5454A8FC,$DDDD4F92,$46468CCA,$8F8FEB64,$E1E137D6,$4E4E9CD2,
    $F0F015E5,$FDFD0FF2,$FCFC0DF1,$EBEB23C8,$F9F907FE,$C4C47DB9,$1A1A342E,$6E6EDCB2,
    $5E5EBCE2,$F5F51FEA,$CCCC6DA1,$8D8DEF62,$1C1C3824,$5656ACFA,$434386C5,$FEFE09F7,
    $07070E09,$6161C2A3,$F8F805FD,$7575EA9F,$5959B2EB,$FFFF0BF4,$03030605,$22224466,
    $8A8AE16B,$D1D15786,$13132635,$EEEE29C7,$8888E56D,$00000000,$0E0E1C12,$3434685C,
    $15152A3F,$8080F575,$9494DD49,$E3E333D0,$EDED2FC2,$B5B59F2A,$5353A6F5,$23234665,
    $4B4B96DD,$47478EC9,$17172E39,$A7A7BB1C,$9090D545,$35356A5F,$ABABA308,$D8D8459D,
    $B8B8853D,$DFDF4B94,$4F4F9ED1,$5757AEF9,$9A9AC15B,$9292D143,$DBDB4398,$1B1B362D,
    $3C3C7844,$C8C865AD,$9999C75E,$0404080C,$8E8EE967,$E0E035D5,$D7D75B8C,$7D7DFA87,
    $8585FF7A,$BBBB8338,$404080C0,$2C2C5874,$3A3A744E,$45458ACF,$F1F117E6,$424284C6,
    $6565CAAF,$20204060,$414182C3,$18183028,$7272E496,$25254A6F,$9393D340,$7070E090,
    $36366C5A,$05050A0F,$F2F211E3,$0B0B161D,$A3A3B310,$7979F28B,$ECEC2DC1,$08081018,
    $27274E69,$31316253,$32326456,$B6B6992F,$7C7CF884,$B0B09525,$0A0A141E,$7373E695,
    $5B5BB6ED,$7B7BF68D,$B7B79B2C,$8181F776,$D2D25183,$0D0D1A17,$6A6AD4BE,$26264C6A,
    $9E9EC957,$5858B0E8,$9C9CCD51,$8383F370,$7474E89C,$B3B39320,$ACACAD01,$30306050,
    $7A7AF48E,$6969D2BB,$7777EE99,$0F0F1E11,$AEAEA907,$21214263,$DEDE4997,$D0D05585,
    $2E2E5C72,$9797DB4C,$10102030,$A4A4BD19,$9898C55D,$A8A8A50D,$D4D45D89,$6868D0B8,
    $2D2D5A77,$6262C4A6,$2929527B,$6D6DDAB7,$16162C3A,$494992DB,$7676EC9A,$C7C77BBC,
    $E8E825CD,$C1C177B6,$9696D94F,$37376E59,$E5E53FDA,$CACA61AB,$F4F41DE9,$E9E927CE,
    $6363C6A5,$12122436,$C2C271B3,$A6A6B91F,$1414283C,$BCBC8D31,$D3D35380,$28285078,
    $AFAFAB04,$2F2F5E71,$E6E639DF,$2424486C,$5252A4F6,$C6C679BF,$A0A0B515,$0909121B,
    $BDBD8F32,$8C8CED61,$CFCF6BA4,$5D5DBAE7,$11112233,$5F5FBEE1,$01010203,$C5C57FBA,
    $9F9FCB54,$3D3D7A47,$A2A2B113,$9B9BC358,$C9C967AE,$3B3B764D,$BEBE8937,$5151A2F3,
    $1919322B,$1F1F3E21,$3F3F7E41,$5C5CB8E4,$B2B29123,$EFEF2BC4,$4A4A94DE,$CDCD6FA2,
    $BFBF8B34,$BABA813B,$6F6FDEB1,$6464C8AC,$D9D9479E,$F3F313E0,$3E3E7C42,$B4B49D29,
    $AAAAA10B,$DCDC4D91,$D5D55F8A,$06060C0A,$C0C075B5,$7E7EFC82,$F6F619EF,$6666CCAA,
    $6C6CD8B4,$8484FD79,$7171E293,$38387048,$B9B9873E,$1D1D3A27,$7F7FFE81,$9D9DCF52,
    $484890D8,$8B8BE368,$2A2A547E,$DADA419B,$A5A5BF1A,$33336655,$8282F173,$3939724B,
    $D6D6598F,$7878F088,$8686F97F,$FAFA01FB,$E4E43DD9,$2B2B567D,$A9A9A70E,$1E1E3C22,
    $8989E76E,$6060C0A0,$6B6BD6BD,$EAEA21CB,$5555AAFF,$4C4C98D4,$F7F71BEC,$E2E231D3),
   ($B19726B1,$CE69A7CE,$C373B0C3,$95DF4A95,$5AB4EE5A,$ADAF02AD,$E73BDCE7,$02040602,
    $4D9AD74D,$4488CC44,$FB03F8FB,$91D74691,$0C18140C,$87FB7C87,$A1B716A1,$50A0F050,
    $CB63A8CB,$67CEA967,$54A8FC54,$DD4F92DD,$468CCA46,$8FEB648F,$E137D6E1,$4E9CD24E,
    $F015E5F0,$FD0FF2FD,$FC0DF1FC,$EB23C8EB,$F907FEF9,$C47DB9C4,$1A342E1A,$6EDCB26E,
    $5EBCE25E,$F51FEAF5,$CC6DA1CC,$8DEF628D,$1C38241C,$56ACFA56,$4386C543,$FE09F7FE,
    $070E0907,$61C2A361,$F805FDF8,$75EA9F75,$59B2EB59,$FF0BF4FF,$03060503,$22446622,
    $8AE16B8A,$D15786D1,$13263513,$EE29C7EE,$88E56D88,$00000000,$0E1C120E,$34685C34,
    $152A3F15,$80F57580,$94DD4994,$E333D0E3,$ED2FC2ED,$B59F2AB5,$53A6F553,$23466523,
    $4B96DD4B,$478EC947,$172E3917,$A7BB1CA7,$90D54590,$356A5F35,$ABA308AB,$D8459DD8,
    $B8853DB8,$DF4B94DF,$4F9ED14F,$57AEF957,$9AC15B9A,$92D14392,$DB4398DB,$1B362D1B,
    $3C78443C,$C865ADC8,$99C75E99,$04080C04,$8EE9678E,$E035D5E0,$D75B8CD7,$7DFA877D,
    $85FF7A85,$BB8338BB,$4080C040,$2C58742C,$3A744E3A,$458ACF45,$F117E6F1,$4284C642,
    $65CAAF65,$20406020,$4182C341,$18302818,$72E49672,$254A6F25,$93D34093,$70E09070,
    $366C5A36,$050A0F05,$F211E3F2,$0B161D0B,$A3B310A3,$79F28B79,$EC2DC1EC,$08101808,
    $274E6927,$31625331,$32645632,$B6992FB6,$7CF8847C,$B09525B0,$0A141E0A,$73E69573,
    $5BB6ED5B,$7BF68D7B,$B79B2CB7,$81F77681,$D25183D2,$0D1A170D,$6AD4BE6A,$264C6A26,
    $9EC9579E,$58B0E858,$9CCD519C,$83F37083,$74E89C74,$B39320B3,$ACAD01AC,$30605030,
    $7AF48E7A,$69D2BB69,$77EE9977,$0F1E110F,$AEA907AE,$21426321,$DE4997DE,$D05585D0,
    $2E5C722E,$97DB4C97,$10203010,$A4BD19A4,$98C55D98,$A8A50DA8,$D45D89D4,$68D0B868,
    $2D5A772D,$62C4A662,$29527B29,$6DDAB76D,$162C3A16,$4992DB49,$76EC9A76,$C77BBCC7,
    $E825CDE8,$C177B6C1,$96D94F96,$376E5937,$E53FDAE5,$CA61ABCA,$F41DE9F4,$E927CEE9,
    $63C6A563,$12243612,$C271B3C2,$A6B91FA6,$14283C14,$BC8D31BC,$D35380D3,$28507828,
    $AFAB04AF,$2F5E712F,$E639DFE6,$24486C24,$52A4F652,$C679BFC6,$A0B515A0,$09121B09,
    $BD8F32BD,$8CED618C,$CF6BA4CF,$5DBAE75D,$11223311,$5FBEE15F,$01020301,$C57FBAC5,
    $9FCB549F,$3D7A473D,$A2B113A2,$9BC3589B,$C967AEC9,$3B764D3B,$BE8937BE,$51A2F351,
    $19322B19,$1F3E211F,$3F7E413F,$5CB8E45C,$B29123B2,$EF2BC4EF,$4A94DE4A,$CD6FA2CD,
    $BF8B34BF,$BA813BBA,$6FDEB16F,$64C8AC64,$D9479ED9,$F313E0F3,$3E7C423E,$B49D29B4,
    $AAA10BAA,$DC4D91DC,$D55F8AD5,$060C0A06,$C075B5C0,$7EFC827E,$F619EFF6,$66CCAA66,
    $6CD8B46C,$84FD7984,$71E29371,$38704838,$B9873EB9,$1D3A271D,$7FFE817F,$9DCF529D,
    $4890D848,$8BE3688B,$2A547E2A,$DA419BDA,$A5BF1AA5,$33665533,$82F17382,$39724B39,
    $D6598FD6,$78F08878,$86F97F86,$FA01FBFA,$E43DD9E4,$2B567D2B,$A9A70EA9,$1E3C221E,
    $89E76E89,$60C0A060,$6BD6BD6B,$EA21CBEA,$55AAFF55,$4C98D44C,$F71BECF7,$E231D3E2),
   ($9726B1B1,$69A7CECE,$73B0C3C3,$DF4A9595,$B4EE5A5A,$AF02ADAD,$3BDCE7E7,$04060202,
    $9AD74D4D,$88CC4444,$03F8FBFB,$D7469191,$18140C0C,$FB7C8787,$B716A1A1,$A0F05050,
    $63A8CBCB,$CEA96767,$A8FC5454,$4F92DDDD,$8CCA4646,$EB648F8F,$37D6E1E1,$9CD24E4E,
    $15E5F0F0,$0FF2FDFD,$0DF1FCFC,$23C8EBEB,$07FEF9F9,$7DB9C4C4,$342E1A1A,$DCB26E6E,
    $BCE25E5E,$1FEAF5F5,$6DA1CCCC,$EF628D8D,$38241C1C,$ACFA5656,$86C54343,$09F7FEFE,
    $0E090707,$C2A36161,$05FDF8F8,$EA9F7575,$B2EB5959,$0BF4FFFF,$06050303,$44662222,
    $E16B8A8A,$5786D1D1,$26351313,$29C7EEEE,$E56D8888,$00000000,$1C120E0E,$685C3434,
    $2A3F1515,$F5758080,$DD499494,$33D0E3E3,$2FC2EDED,$9F2AB5B5,$A6F55353,$46652323,
    $96DD4B4B,$8EC94747,$2E391717,$BB1CA7A7,$D5459090,$6A5F3535,$A308ABAB,$459DD8D8,
    $853DB8B8,$4B94DFDF,$9ED14F4F,$AEF95757,$C15B9A9A,$D1439292,$4398DBDB,$362D1B1B,
    $78443C3C,$65ADC8C8,$C75E9999,$080C0404,$E9678E8E,$35D5E0E0,$5B8CD7D7,$FA877D7D,
    $FF7A8585,$8338BBBB,$80C04040,$58742C2C,$744E3A3A,$8ACF4545,$17E6F1F1,$84C64242,
    $CAAF6565,$40602020,$82C34141,$30281818,$E4967272,$4A6F2525,$D3409393,$E0907070,
    $6C5A3636,$0A0F0505,$11E3F2F2,$161D0B0B,$B310A3A3,$F28B7979,$2DC1ECEC,$10180808,
    $4E692727,$62533131,$64563232,$992FB6B6,$F8847C7C,$9525B0B0,$141E0A0A,$E6957373,
    $B6ED5B5B,$F68D7B7B,$9B2CB7B7,$F7768181,$5183D2D2,$1A170D0D,$D4BE6A6A,$4C6A2626,
    $C9579E9E,$B0E85858,$CD519C9C,$F3708383,$E89C7474,$9320B3B3,$AD01ACAC,$60503030,
    $F48E7A7A,$D2BB6969,$EE997777,$1E110F0F,$A907AEAE,$42632121,$4997DEDE,$5585D0D0,
    $5C722E2E,$DB4C9797,$20301010,$BD19A4A4,$C55D9898,$A50DA8A8,$5D89D4D4,$D0B86868,
    $5A772D2D,$C4A66262,$527B2929,$DAB76D6D,$2C3A1616,$92DB4949,$EC9A7676,$7BBCC7C7,
    $25CDE8E8,$77B6C1C1,$D94F9696,$6E593737,$3FDAE5E5,$61ABCACA,$1DE9F4F4,$27CEE9E9,
    $C6A56363,$24361212,$71B3C2C2,$B91FA6A6,$283C1414,$8D31BCBC,$5380D3D3,$50782828,
    $AB04AFAF,$5E712F2F,$39DFE6E6,$486C2424,$A4F65252,$79BFC6C6,$B515A0A0,$121B0909,
    $8F32BDBD,$ED618C8C,$6BA4CFCF,$BAE75D5D,$22331111,$BEE15F5F,$02030101,$7FBAC5C5,
    $CB549F9F,$7A473D3D,$B113A2A2,$C3589B9B,$67AEC9C9,$764D3B3B,$8937BEBE,$A2F35151,
    $322B1919,$3E211F1F,$7E413F3F,$B8E45C5C,$9123B2B2,$2BC4EFEF,$94DE4A4A,$6FA2CDCD,
    $8B34BFBF,$813BBABA,$DEB16F6F,$C8AC6464,$479ED9D9,$13E0F3F3,$7C423E3E,$9D29B4B4,
    $A10BAAAA,$4D91DCDC,$5F8AD5D5,$0C0A0606,$75B5C0C0,$FC827E7E,$19EFF6F6,$CCAA6666,
    $D8B46C6C,$FD798484,$E2937171,$70483838,$873EB9B9,$3A271D1D,$FE817F7F,$CF529D9D,
    $90D84848,$E3688B8B,$547E2A2A,$419BDADA,$BF1AA5A5,$66553333,$F1738282,$724B3939,
    $598FD6D6,$F0887878,$F97F8686,$01FBFAFA,$3DD9E4E4,$567D2B2B,$A70EA9A9,$3C221E1E,
    $E76E8989,$C0A06060,$D6BD6B6B,$21CBEAEA,$AAFF5555,$98D44C4C,$1BECF7F7,$31D3E2E2));

  Square_TD: array[0..3, 0..255] of LongWord = (
   ($02BC68E3,$0C628555,$31233F2A,$F713AB61,$726DD498,$199ACB21,$61A4223C,$CD3D9D45,
    $23B4FD05,$5F07C42B,$C0012C9B,$0F80D93D,$745C6C48,$857E7FF9,$1FAB73F1,$0EDEEDB6,
    $ED6B3C28,$1A789749,$8D912A9F,$339F57C9,$AAA807A9,$7DED0DA5,$8F2D427C,$C9B04D76,
    $57E8914D,$CC63A9CE,$D296EEB4,$B6E12830,$B961F10D,$266719BD,$80AD9B41,$C76EA0C0,
    $41F28351,$34F0DB92,$FC1EA26F,$4CCE328F,$7333E013,$6DC6A769,$93646DE5,$FA2F1ABF,
    $B7BF1CBB,$B5037458,$4F2C6EE7,$96B7895D,$2A059CE8,$A3196644,$FB712E34,$6529F20F,
    $7A8281FE,$F12213B1,$EC3508A3,$7E0F51CD,$14A67AFF,$F893725C,$1297C22F,$C3E370F3,
    $1C492F99,$681543D1,$1B26A3C2,$B332CC88,$6F7ACF8A,$9F06E8B0,$1EF5477A,$DA79BBD2,
    $210895E6,$5CE59843,$0631B8D0,$AF7BE311,$5365417E,$102BAACC,$9CE4B4D8,$D4A75664,
    $59367CFB,$84204B72,$F64D9FEA,$DFAA5F6A,$CEDFC12D,$58684870,$81F3AFCA,$91D80506,
    $694B775A,$A528DE94,$4210DF39,$47C33B81,$A6CA82FC,$C5D2C823,$B26CF803,$9AD50C08,
    $40ACB7DA,$E109B97D,$2C342438,$A24752CF,$D174B2DC,$2B5BA863,$9555D535,$11759E47,
    $E2EBE515,$C630944B,$A8146F4A,$869C2391,$39CC6A4C,$4AFF8A5F,$4D900604,$BBDD99EE,
    $CA52111E,$18C4FFAA,$986964EB,$FFFCFE07,$015E348B,$BE0E7D56,$D99BE7BA,$32C16342,
    $7BDCB575,$17442697,$66CBAE67,$CB0C2595,$67959AEC,$D02A8657,$99375060,$05D3E4B8,
    $BA83AD65,$35AEEF19,$13C9F6A4,$A94A5BC1,$D61B3E87,$5E59F0A0,$5B8A1418,$3B7002AF,
    $76E004AB,$BF5049DD,$63184ADF,$56B6A5C6,$0A533D85,$371287FA,$A794B677,$7F516546,
    $09B161ED,$E9E6EC1B,$258545D5,$523B75F5,$3D41BA7F,$8842CE27,$434EEBB2,$97E9BDD6,
    $F39E7B52,$457F5362,$A0FB3A2C,$70D1BC7B,$6BF71FB9,$1D171B12,$C8EE79FD,$F07C273A,
    $D7450A0C,$7960DD96,$ABF63322,$891CFAAC,$5DBBACC8,$307D0BA1,$4BA1BED4,$940BE1BE,
    $540ACD25,$62467E54,$8211F3A2,$3EA3E617,$E6663526,$750258C3,$9B8B3883,$C2BD4478,
    $DC480302,$8BA0924F,$7CB3392E,$E584694E,$718F88F0,$27392D36,$3FFDD29C,$6E24FB01,
    $DD163789,$00000000,$E0578DF6,$6C9893E2,$15F84E74,$5AD42093,$E73801AD,$B45D40D3,
    $87C2171A,$2D6A10B3,$2FD67850,$3C1F8EF4,$A1A50EA7,$364CB371,$AE25D79A,$24DB715E,
    $50871D16,$D5F962EF,$9086318D,$161A121C,$CF81F5A6,$076F8C5B,$491DD637,$923A596E,
    $6477C684,$B83FC586,$F9CD46D7,$B0D090E0,$834FC729,$FD4096E4,$0B0D090E,$2056A16D,
    $22EAC98E,$2E884CDB,$8E7376F7,$BCB215B5,$C15F1810,$6AA92B32,$B18EA46B,$5554F9AE,
    $EE896040,$08EF5566,$442167E9,$BDEC213E,$77BE3020,$ADC78BF2,$29E7C080,$8CCF1E14,
    $4843E2BC,$8AFEA6C4,$D8C5D331,$60FA16B7,$9DBA8053,$F2C04FD9,$783EE91D,$3A2E3624,
    $DEF46BE1,$EFD754CB,$F4F1F709,$F5AFC382,$28B9F40B,$51D9299D,$38925EC7,$EB5A84F8,
    $E8B8D890,$0D3CB1DE,$048DD033,$03E25C68,$E4DA5DC5,$9E58DC3B,$469D0F0A,$D3C8DA3F,
    $DB278F59,$C48CFCA8,$AC99BF79,$4E725A6C,$FEA2CA8C,$E3B5D19E,$A476EA1F,$EA04B073),
   ($BC68E302,$6285550C,$233F2A31,$13AB61F7,$6DD49872,$9ACB2119,$A4223C61,$3D9D45CD,
    $B4FD0523,$07C42B5F,$012C9BC0,$80D93D0F,$5C6C4874,$7E7FF985,$AB73F11F,$DEEDB60E,
    $6B3C28ED,$7897491A,$912A9F8D,$9F57C933,$A807A9AA,$ED0DA57D,$2D427C8F,$B04D76C9,
    $E8914D57,$63A9CECC,$96EEB4D2,$E12830B6,$61F10DB9,$6719BD26,$AD9B4180,$6EA0C0C7,
    $F2835141,$F0DB9234,$1EA26FFC,$CE328F4C,$33E01373,$C6A7696D,$646DE593,$2F1ABFFA,
    $BF1CBBB7,$037458B5,$2C6EE74F,$B7895D96,$059CE82A,$196644A3,$712E34FB,$29F20F65,
    $8281FE7A,$2213B1F1,$3508A3EC,$0F51CD7E,$A67AFF14,$93725CF8,$97C22F12,$E370F3C3,
    $492F991C,$1543D168,$26A3C21B,$32CC88B3,$7ACF8A6F,$06E8B09F,$F5477A1E,$79BBD2DA,
    $0895E621,$E598435C,$31B8D006,$7BE311AF,$65417E53,$2BAACC10,$E4B4D89C,$A75664D4,
    $367CFB59,$204B7284,$4D9FEAF6,$AA5F6ADF,$DFC12DCE,$68487058,$F3AFCA81,$D8050691,
    $4B775A69,$28DE94A5,$10DF3942,$C33B8147,$CA82FCA6,$D2C823C5,$6CF803B2,$D50C089A,
    $ACB7DA40,$09B97DE1,$3424382C,$4752CFA2,$74B2DCD1,$5BA8632B,$55D53595,$759E4711,
    $EBE515E2,$30944BC6,$146F4AA8,$9C239186,$CC6A4C39,$FF8A5F4A,$9006044D,$DD99EEBB,
    $52111ECA,$C4FFAA18,$6964EB98,$FCFE07FF,$5E348B01,$0E7D56BE,$9BE7BAD9,$C1634232,
    $DCB5757B,$44269717,$CBAE6766,$0C2595CB,$959AEC67,$2A8657D0,$37506099,$D3E4B805,
    $83AD65BA,$AEEF1935,$C9F6A413,$4A5BC1A9,$1B3E87D6,$59F0A05E,$8A14185B,$7002AF3B,
    $E004AB76,$5049DDBF,$184ADF63,$B6A5C656,$533D850A,$1287FA37,$94B677A7,$5165467F,
    $B161ED09,$E6EC1BE9,$8545D525,$3B75F552,$41BA7F3D,$42CE2788,$4EEBB243,$E9BDD697,
    $9E7B52F3,$7F536245,$FB3A2CA0,$D1BC7B70,$F71FB96B,$171B121D,$EE79FDC8,$7C273AF0,
    $450A0CD7,$60DD9679,$F63322AB,$1CFAAC89,$BBACC85D,$7D0BA130,$A1BED44B,$0BE1BE94,
    $0ACD2554,$467E5462,$11F3A282,$A3E6173E,$663526E6,$0258C375,$8B38839B,$BD4478C2,
    $480302DC,$A0924F8B,$B3392E7C,$84694EE5,$8F88F071,$392D3627,$FDD29C3F,$24FB016E,
    $163789DD,$00000000,$578DF6E0,$9893E26C,$F84E7415,$D420935A,$3801ADE7,$5D40D3B4,
    $C2171A87,$6A10B32D,$D678502F,$1F8EF43C,$A50EA7A1,$4CB37136,$25D79AAE,$DB715E24,
    $871D1650,$F962EFD5,$86318D90,$1A121C16,$81F5A6CF,$6F8C5B07,$1DD63749,$3A596E92,
    $77C68464,$3FC586B8,$CD46D7F9,$D090E0B0,$4FC72983,$4096E4FD,$0D090E0B,$56A16D20,
    $EAC98E22,$884CDB2E,$7376F78E,$B215B5BC,$5F1810C1,$A92B326A,$8EA46BB1,$54F9AE55,
    $896040EE,$EF556608,$2167E944,$EC213EBD,$BE302077,$C78BF2AD,$E7C08029,$CF1E148C,
    $43E2BC48,$FEA6C48A,$C5D331D8,$FA16B760,$BA80539D,$C04FD9F2,$3EE91D78,$2E36243A,
    $F46BE1DE,$D754CBEF,$F1F709F4,$AFC382F5,$B9F40B28,$D9299D51,$925EC738,$5A84F8EB,
    $B8D890E8,$3CB1DE0D,$8DD03304,$E25C6803,$DA5DC5E4,$58DC3B9E,$9D0F0A46,$C8DA3FD3,
    $278F59DB,$8CFCA8C4,$99BF79AC,$725A6C4E,$A2CA8CFE,$B5D19EE3,$76EA1FA4,$04B073EA),
   ($68E302BC,$85550C62,$3F2A3123,$AB61F713,$D498726D,$CB21199A,$223C61A4,$9D45CD3D,
    $FD0523B4,$C42B5F07,$2C9BC001,$D93D0F80,$6C48745C,$7FF9857E,$73F11FAB,$EDB60EDE,
    $3C28ED6B,$97491A78,$2A9F8D91,$57C9339F,$07A9AAA8,$0DA57DED,$427C8F2D,$4D76C9B0,
    $914D57E8,$A9CECC63,$EEB4D296,$2830B6E1,$F10DB961,$19BD2667,$9B4180AD,$A0C0C76E,
    $835141F2,$DB9234F0,$A26FFC1E,$328F4CCE,$E0137333,$A7696DC6,$6DE59364,$1ABFFA2F,
    $1CBBB7BF,$7458B503,$6EE74F2C,$895D96B7,$9CE82A05,$6644A319,$2E34FB71,$F20F6529,
    $81FE7A82,$13B1F122,$08A3EC35,$51CD7E0F,$7AFF14A6,$725CF893,$C22F1297,$70F3C3E3,
    $2F991C49,$43D16815,$A3C21B26,$CC88B332,$CF8A6F7A,$E8B09F06,$477A1EF5,$BBD2DA79,
    $95E62108,$98435CE5,$B8D00631,$E311AF7B,$417E5365,$AACC102B,$B4D89CE4,$5664D4A7,
    $7CFB5936,$4B728420,$9FEAF64D,$5F6ADFAA,$C12DCEDF,$48705868,$AFCA81F3,$050691D8,
    $775A694B,$DE94A528,$DF394210,$3B8147C3,$82FCA6CA,$C823C5D2,$F803B26C,$0C089AD5,
    $B7DA40AC,$B97DE109,$24382C34,$52CFA247,$B2DCD174,$A8632B5B,$D5359555,$9E471175,
    $E515E2EB,$944BC630,$6F4AA814,$2391869C,$6A4C39CC,$8A5F4AFF,$06044D90,$99EEBBDD,
    $111ECA52,$FFAA18C4,$64EB9869,$FE07FFFC,$348B015E,$7D56BE0E,$E7BAD99B,$634232C1,
    $B5757BDC,$26971744,$AE6766CB,$2595CB0C,$9AEC6795,$8657D02A,$50609937,$E4B805D3,
    $AD65BA83,$EF1935AE,$F6A413C9,$5BC1A94A,$3E87D61B,$F0A05E59,$14185B8A,$02AF3B70,
    $04AB76E0,$49DDBF50,$4ADF6318,$A5C656B6,$3D850A53,$87FA3712,$B677A794,$65467F51,
    $61ED09B1,$EC1BE9E6,$45D52585,$75F5523B,$BA7F3D41,$CE278842,$EBB2434E,$BDD697E9,
    $7B52F39E,$5362457F,$3A2CA0FB,$BC7B70D1,$1FB96BF7,$1B121D17,$79FDC8EE,$273AF07C,
    $0A0CD745,$DD967960,$3322ABF6,$FAAC891C,$ACC85DBB,$0BA1307D,$BED44BA1,$E1BE940B,
    $CD25540A,$7E546246,$F3A28211,$E6173EA3,$3526E666,$58C37502,$38839B8B,$4478C2BD,
    $0302DC48,$924F8BA0,$392E7CB3,$694EE584,$88F0718F,$2D362739,$D29C3FFD,$FB016E24,
    $3789DD16,$00000000,$8DF6E057,$93E26C98,$4E7415F8,$20935AD4,$01ADE738,$40D3B45D,
    $171A87C2,$10B32D6A,$78502FD6,$8EF43C1F,$0EA7A1A5,$B371364C,$D79AAE25,$715E24DB,
    $1D165087,$62EFD5F9,$318D9086,$121C161A,$F5A6CF81,$8C5B076F,$D637491D,$596E923A,
    $C6846477,$C586B83F,$46D7F9CD,$90E0B0D0,$C729834F,$96E4FD40,$090E0B0D,$A16D2056,
    $C98E22EA,$4CDB2E88,$76F78E73,$15B5BCB2,$1810C15F,$2B326AA9,$A46BB18E,$F9AE5554,
    $6040EE89,$556608EF,$67E94421,$213EBDEC,$302077BE,$8BF2ADC7,$C08029E7,$1E148CCF,
    $E2BC4843,$A6C48AFE,$D331D8C5,$16B760FA,$80539DBA,$4FD9F2C0,$E91D783E,$36243A2E,
    $6BE1DEF4,$54CBEFD7,$F709F4F1,$C382F5AF,$F40B28B9,$299D51D9,$5EC73892,$84F8EB5A,
    $D890E8B8,$B1DE0D3C,$D033048D,$5C6803E2,$5DC5E4DA,$DC3B9E58,$0F0A469D,$DA3FD3C8,
    $8F59DB27,$FCA8C48C,$BF79AC99,$5A6C4E72,$CA8CFEA2,$D19EE3B5,$EA1FA476,$B073EA04),
   ($E302BC68,$550C6285,$2A31233F,$61F713AB,$98726DD4,$21199ACB,$3C61A422,$45CD3D9D,
    $0523B4FD,$2B5F07C4,$9BC0012C,$3D0F80D9,$48745C6C,$F9857E7F,$F11FAB73,$B60EDEED,
    $28ED6B3C,$491A7897,$9F8D912A,$C9339F57,$A9AAA807,$A57DED0D,$7C8F2D42,$76C9B04D,
    $4D57E891,$CECC63A9,$B4D296EE,$30B6E128,$0DB961F1,$BD266719,$4180AD9B,$C0C76EA0,
    $5141F283,$9234F0DB,$6FFC1EA2,$8F4CCE32,$137333E0,$696DC6A7,$E593646D,$BFFA2F1A,
    $BBB7BF1C,$58B50374,$E74F2C6E,$5D96B789,$E82A059C,$44A31966,$34FB712E,$0F6529F2,
    $FE7A8281,$B1F12213,$A3EC3508,$CD7E0F51,$FF14A67A,$5CF89372,$2F1297C2,$F3C3E370,
    $991C492F,$D1681543,$C21B26A3,$88B332CC,$8A6F7ACF,$B09F06E8,$7A1EF547,$D2DA79BB,
    $E6210895,$435CE598,$D00631B8,$11AF7BE3,$7E536541,$CC102BAA,$D89CE4B4,$64D4A756,
    $FB59367C,$7284204B,$EAF64D9F,$6ADFAA5F,$2DCEDFC1,$70586848,$CA81F3AF,$0691D805,
    $5A694B77,$94A528DE,$394210DF,$8147C33B,$FCA6CA82,$23C5D2C8,$03B26CF8,$089AD50C,
    $DA40ACB7,$7DE109B9,$382C3424,$CFA24752,$DCD174B2,$632B5BA8,$359555D5,$4711759E,
    $15E2EBE5,$4BC63094,$4AA8146F,$91869C23,$4C39CC6A,$5F4AFF8A,$044D9006,$EEBBDD99,
    $1ECA5211,$AA18C4FF,$EB986964,$07FFFCFE,$8B015E34,$56BE0E7D,$BAD99BE7,$4232C163,
    $757BDCB5,$97174426,$6766CBAE,$95CB0C25,$EC67959A,$57D02A86,$60993750,$B805D3E4,
    $65BA83AD,$1935AEEF,$A413C9F6,$C1A94A5B,$87D61B3E,$A05E59F0,$185B8A14,$AF3B7002,
    $AB76E004,$DDBF5049,$DF63184A,$C656B6A5,$850A533D,$FA371287,$77A794B6,$467F5165,
    $ED09B161,$1BE9E6EC,$D5258545,$F5523B75,$7F3D41BA,$278842CE,$B2434EEB,$D697E9BD,
    $52F39E7B,$62457F53,$2CA0FB3A,$7B70D1BC,$B96BF71F,$121D171B,$FDC8EE79,$3AF07C27,
    $0CD7450A,$967960DD,$22ABF633,$AC891CFA,$C85DBBAC,$A1307D0B,$D44BA1BE,$BE940BE1,
    $25540ACD,$5462467E,$A28211F3,$173EA3E6,$26E66635,$C3750258,$839B8B38,$78C2BD44,
    $02DC4803,$4F8BA092,$2E7CB339,$4EE58469,$F0718F88,$3627392D,$9C3FFDD2,$016E24FB,
    $89DD1637,$00000000,$F6E0578D,$E26C9893,$7415F84E,$935AD420,$ADE73801,$D3B45D40,
    $1A87C217,$B32D6A10,$502FD678,$F43C1F8E,$A7A1A50E,$71364CB3,$9AAE25D7,$5E24DB71,
    $1650871D,$EFD5F962,$8D908631,$1C161A12,$A6CF81F5,$5B076F8C,$37491DD6,$6E923A59,
    $846477C6,$86B83FC5,$D7F9CD46,$E0B0D090,$29834FC7,$E4FD4096,$0E0B0D09,$6D2056A1,
    $8E22EAC9,$DB2E884C,$F78E7376,$B5BCB215,$10C15F18,$326AA92B,$6BB18EA4,$AE5554F9,
    $40EE8960,$6608EF55,$E9442167,$3EBDEC21,$2077BE30,$F2ADC78B,$8029E7C0,$148CCF1E,
    $BC4843E2,$C48AFEA6,$31D8C5D3,$B760FA16,$539DBA80,$D9F2C04F,$1D783EE9,$243A2E36,
    $E1DEF46B,$CBEFD754,$09F4F1F7,$82F5AFC3,$0B28B9F4,$9D51D929,$C738925E,$F8EB5A84,
    $90E8B8D8,$DE0D3CB1,$33048DD0,$6803E25C,$C5E4DA5D,$3B9E58DC,$0A469D0F,$3FD3C8DA,
    $59DB278F,$A8C48CFC,$79AC99BF,$6C4E725A,$8CFEA2CA,$9EE3B5D1,$1FA476EA,$73EA04B0));

  Cast256_Data: array[0..3, 0..255] of LongWord = (
   ($30FB40D4,$9FA0FF0B,$6BECCD2F,$3F258C7A,$1E213F2F,$9C004DD3,$6003E540,$CF9FC949,
    $BFD4AF27,$88BBBDB5,$E2034090,$98D09675,$6E63A0E0,$15C361D2,$C2E7661D,$22D4FF8E,
    $28683B6F,$C07FD059,$FF2379C8,$775F50E2,$43C340D3,$DF2F8656,$887CA41A,$A2D2BD2D,
    $A1C9E0D6,$346C4819,$61B76D87,$22540F2F,$2ABE32E1,$AA54166B,$22568E3A,$A2D341D0,
    $66DB40C8,$A784392F,$004DFF2F,$2DB9D2DE,$97943FAC,$4A97C1D8,$527644B7,$B5F437A7,
    $B82CBAEF,$D751D159,$6FF7F0ED,$5A097A1F,$827B68D0,$90ECF52E,$22B0C054,$BC8E5935,
    $4B6D2F7F,$50BB64A2,$D2664910,$BEE5812D,$B7332290,$E93B159F,$B48EE411,$4BFF345D,
    $FD45C240,$AD31973F,$C4F6D02E,$55FC8165,$D5B1CAAD,$A1AC2DAE,$A2D4B76D,$C19B0C50,
    $882240F2,$0C6E4F38,$A4E4BFD7,$4F5BA272,$564C1D2F,$C59C5319,$B949E354,$B04669FE,
    $B1B6AB8A,$C71358DD,$6385C545,$110F935D,$57538AD5,$6A390493,$E63D37E0,$2A54F6B3,
    $3A787D5F,$6276A0B5,$19A6FCDF,$7A42206A,$29F9D4D5,$F61B1891,$BB72275E,$AA508167,
    $38901091,$C6B505EB,$84C7CB8C,$2AD75A0F,$874A1427,$A2D1936B,$2AD286AF,$AA56D291,
    $D7894360,$425C750D,$93B39E26,$187184C9,$6C00B32D,$73E2BB14,$A0BEBC3C,$54623779,
    $64459EAB,$3F328B82,$7718CF82,$59A2CEA6,$04EE002E,$89FE78E6,$3FAB0950,$325FF6C2,
    $81383F05,$6963C5C8,$76CB5AD6,$D49974C9,$CA180DCF,$380782D5,$C7FA5CF6,$8AC31511,
    $35E79E13,$47DA91D0,$F40F9086,$A7E2419E,$31366241,$051EF495,$AA573B04,$4A805D8D,
    $548300D0,$00322A3C,$BF64CDDF,$BA57A68E,$75C6372B,$50AFD341,$A7C13275,$915A0BF5,
    $6B54BFAB,$2B0B1426,$AB4CC9D7,$449CCD82,$F7FBF265,$AB85C5F3,$1B55DB94,$AAD4E324,
    $CFA4BD3F,$2DEAA3E2,$9E204D02,$C8BD25AC,$EADF55B3,$D5BD9E98,$E31231B2,$2AD5AD6C,
    $954329DE,$ADBE4528,$D8710F69,$AA51C90F,$AA786BF6,$22513F1E,$AA51A79B,$2AD344CC,
    $7B5A41F0,$D37CFBAD,$1B069505,$41ECE491,$B4C332E6,$032268D4,$C9600ACC,$CE387E6D,
    $BF6BB16C,$6A70FB78,$0D03D9C9,$D4DF39DE,$E01063DA,$4736F464,$5AD328D8,$B347CC96,
    $75BB0FC3,$98511BFB,$4FFBCC35,$B58BCF6A,$E11F0ABC,$BFC5FE4A,$A70AEC10,$AC39570A,
    $3F04442F,$6188B153,$E0397A2E,$5727CB79,$9CEB418F,$1CACD68D,$2AD37C96,$0175CB9D,
    $C69DFF09,$C75B65F0,$D9DB40D8,$EC0E7779,$4744EAD4,$B11C3274,$DD24CB9E,$7E1C54BD,
    $F01144F9,$D2240EB1,$9675B3FD,$A3AC3755,$D47C27AF,$51C85F4D,$56907596,$A5BB15E6,
    $580304F0,$CA042CF1,$011A37EA,$8DBFAADB,$35BA3E4A,$3526FFA0,$C37B4D09,$BC306ED9,
    $98A52666,$5648F725,$FF5E569D,$0CED63D0,$7C63B2CF,$700B45E1,$D5EA50F1,$85A92872,
    $AF1FBDA7,$D4234870,$A7870BF3,$2D3B4D79,$42E04198,$0CD0EDE7,$26470DB8,$F881814C,
    $474D6AD7,$7C0C5E5C,$D1231959,$381B7298,$F5D2F4DB,$AB838653,$6E2F1E23,$83719C9E,
    $BD91E046,$9A56456E,$DC39200C,$20C8C571,$962BDA1C,$E1E696FF,$B141AB08,$7CCA89B9,
    $1A69E783,$02CC4843,$A2F7C579,$429EF47D,$427B169C,$5AC9F049,$DD8F0F00,$5C8165BF),
   ($1F201094,$EF0BA75B,$69E3CF7E,$393F4380,$FE61CF7A,$EEC5207A,$55889C94,$72FC0651,
    $ADA7EF79,$4E1D7235,$D55A63CE,$DE0436BA,$99C430EF,$5F0C0794,$18DCDB7D,$A1D6EFF3,
    $A0B52F7B,$59E83605,$EE15B094,$E9FFD909,$DC440086,$EF944459,$BA83CCB3,$E0C3CDFB,
    $D1DA4181,$3B092AB1,$F997F1C1,$A5E6CF7B,$01420DDB,$E4E7EF5B,$25A1FF41,$E180F806,
    $1FC41080,$179BEE7A,$D37AC6A9,$FE5830A4,$98DE8B7F,$77E83F4E,$79929269,$24FA9F7B,
    $E113C85B,$ACC40083,$D7503525,$F7EA615F,$62143154,$0D554B63,$5D681121,$C866C359,
    $3D63CF73,$CEE234C0,$D4D87E87,$5C672B21,$071F6181,$39F7627F,$361E3084,$E4EB573B,
    $602F64A4,$D63ACD9C,$1BBC4635,$9E81032D,$2701F50C,$99847AB4,$A0E3DF79,$BA6CF38C,
    $10843094,$2537A95E,$F46F6FFE,$A1FF3B1F,$208CFB6A,$8F458C74,$D9E0A227,$4EC73A34,
    $FC884F69,$3E4DE8DF,$EF0E0088,$3559648D,$8A45388C,$1D804366,$721D9BFD,$A58684BB,
    $E8256333,$844E8212,$128D8098,$FED33FB4,$CE280AE1,$27E19BA5,$D5A6C252,$E49754BD,
    $C5D655DD,$EB667064,$77840B4D,$A1B6A801,$84DB26A9,$E0B56714,$21F043B7,$E5D05860,
    $54F03084,$066FF472,$A31AA153,$DADC4755,$B5625DBF,$68561BE6,$83CA6B94,$2D6ED23B,
    $ECCF01DB,$A6D3D0BA,$B6803D5C,$AF77A709,$33B4A34C,$397BC8D6,$5EE22B95,$5F0E5304,
    $81ED6F61,$20E74364,$B45E1378,$DE18639B,$881CA122,$B96726D1,$8049A7E8,$22B7DA7B,
    $5E552D25,$5272D237,$79D2951C,$C60D894C,$488CB402,$1BA4FE5B,$A4B09F6B,$1CA815CF,
    $A20C3005,$8871DF63,$B9DE2FCB,$0CC6C9E9,$0BEEFF53,$E3214517,$B4542835,$9F63293C,
    $EE41E729,$6E1D2D7C,$50045286,$1E6685F3,$F33401C6,$30A22C95,$31A70850,$60930F13,
    $73F98417,$A1269859,$EC645C44,$52C877A9,$CDFF33A6,$A02B1741,$7CBAD9A2,$2180036F,
    $50D99C08,$CB3F4861,$C26BD765,$64A3F6AB,$80342676,$25A75E7B,$E4E6D1FC,$20C710E6,
    $CDF0B680,$17844D3B,$31EEF84D,$7E0824E4,$2CCB49EB,$846A3BAE,$8FF77888,$EE5D60F6,
    $7AF75673,$2FDD5CDB,$A11631C1,$30F66F43,$B3FAEC54,$157FD7FA,$EF8579CC,$D152DE58,
    $DB2FFD5E,$8F32CE19,$306AF97A,$02F03EF8,$99319AD5,$C242FA0F,$A7E3EBB0,$C68E4906,
    $B8DA230C,$80823028,$DCDEF3C8,$D35FB171,$088A1BC8,$BEC0C560,$61A3C9E8,$BCA8F54D,
    $C72FEFFA,$22822E99,$82C570B4,$D8D94E89,$8B1C34BC,$301E16E6,$273BE979,$B0FFEAA6,
    $61D9B8C6,$00B24869,$B7FFCE3F,$08DC283B,$43DAF65A,$F7E19798,$7619B72F,$8F1C9BA4,
    $DC8637A0,$16A7D3B1,$9FC393B7,$A7136EEB,$C6BCC63E,$1A513742,$EF6828BC,$520365D6,
    $2D6A77AB,$3527ED4B,$821FD216,$095C6E2E,$DB92F2FB,$5EEA29CB,$145892F5,$91584F7F,
    $5483697B,$2667A8CC,$85196048,$8C4BACEA,$833860D4,$0D23E0F9,$6C387E8A,$0AE6D249,
    $B284600C,$D835731D,$DCB1C647,$AC4C56EA,$3EBD81B3,$230EABB0,$6438BC87,$F0B5B1FA,
    $8F5EA2B3,$FC184642,$0A036B7A,$4FB089BD,$649DA589,$A345415E,$5C038323,$3E5D3BB9,
    $43D79572,$7E6DD07C,$06DFDF1E,$6C6CC4EF,$7160A539,$73BFBE70,$83877605,$4523ECF1),
   ($8DEFC240,$25FA5D9F,$EB903DBF,$E810C907,$47607FFF,$369FE44B,$8C1FC644,$AECECA90,
    $BEB1F9BF,$EEFBCAEA,$E8CF1950,$51DF07AE,$920E8806,$F0AD0548,$E13C8D83,$927010D5,
    $11107D9F,$07647DB9,$B2E3E4D4,$3D4F285E,$B9AFA820,$FADE82E0,$A067268B,$8272792E,
    $553FB2C0,$489AE22B,$D4EF9794,$125E3FBC,$21FFFCEE,$825B1BFD,$9255C5ED,$1257A240,
    $4E1A8302,$BAE07FFF,$528246E7,$8E57140E,$3373F7BF,$8C9F8188,$A6FC4EE8,$C982B5A5,
    $A8C01DB7,$579FC264,$67094F31,$F2BD3F5F,$40FFF7C1,$1FB78DFC,$8E6BD2C1,$437BE59B,
    $99B03DBF,$B5DBC64B,$638DC0E6,$55819D99,$A197C81C,$4A012D6E,$C5884A28,$CCC36F71,
    $B843C213,$6C0743F1,$8309893C,$0FEDDD5F,$2F7FE850,$D7C07F7E,$02507FBF,$5AFB9A04,
    $A747D2D0,$1651192E,$AF70BF3E,$58C31380,$5F98302E,$727CC3C4,$0A0FB402,$0F7FEF82,
    $8C96FDAD,$5D2C2AAE,$8EE99A49,$50DA88B8,$8427F4A0,$1EAC5790,$796FB449,$8252DC15,
    $EFBD7D9B,$A672597D,$ADA840D8,$45F54504,$FA5D7403,$E83EC305,$4F91751A,$925669C2,
    $23EFE941,$A903F12E,$60270DF2,$0276E4B6,$94FD6574,$927985B2,$8276DBCB,$02778176,
    $F8AF918D,$4E48F79E,$8F616DDF,$E29D840E,$842F7D83,$340CE5C8,$96BBB682,$93B4B148,
    $EF303CAB,$984FAF28,$779FAF9B,$92DC560D,$224D1E20,$8437AA88,$7D29DC96,$2756D3DC,
    $8B907CEE,$B51FD240,$E7C07CE3,$E566B4A1,$C3E9615E,$3CF8209D,$6094D1E3,$CD9CA341,
    $5C76460E,$00EA983B,$D4D67881,$FD47572C,$F76CEDD9,$BDA8229C,$127DADAA,$438A074E,
    $1F97C090,$081BDB8A,$93A07EBE,$B938CA15,$97B03CFF,$3DC2C0F8,$8D1AB2EC,$64380E51,
    $68CC7BFB,$D90F2788,$12490181,$5DE5FFD4,$DD7EF86A,$76A2E214,$B9A40368,$925D958F,
    $4B39FFFA,$BA39AEE9,$A4FFD30B,$FAF7933B,$6D498623,$193CBCFA,$27627545,$825CF47A,
    $61BD8BA0,$D11E42D1,$CEAD04F4,$127EA392,$10428DB7,$8272A972,$9270C4A8,$127DE50B,
    $285BA1C8,$3C62F44F,$35C0EAA5,$E805D231,$428929FB,$B4FCDF82,$4FB66A53,$0E7DC15B,
    $1F081FAB,$108618AE,$FCFD086D,$F9FF2889,$694BCC11,$236A5CAE,$12DECA4D,$2C3F8CC5,
    $D2D02DFE,$F8EF5896,$E4CF52DA,$95155B67,$494A488C,$B9B6A80C,$5C8F82BC,$89D36B45,
    $3A609437,$EC00C9A9,$44715253,$0A874B49,$D773BC40,$7C34671C,$02717EF6,$4FEB5536,
    $A2D02FFF,$D2BF60C4,$D43F03C0,$50B4EF6D,$07478CD1,$006E1888,$A2E53F55,$B9E6D4BC,
    $A2048016,$97573833,$D7207D67,$DE0F8F3D,$72F87B33,$ABCC4F33,$7688C55D,$7B00A6B0,
    $947B0001,$570075D2,$F9BB88F8,$8942019E,$4264A5FF,$856302E0,$72DBD92B,$EE971B69,
    $6EA22FDE,$5F08AE2B,$AF7A616D,$E5C98767,$CF1FEBD2,$61EFC8C2,$F1AC2571,$CC8239C2,
    $67214CB8,$B1E583D1,$B7DC3E62,$7F10BDCE,$F90A5C38,$0FF0443D,$606E6DC6,$60543A49,
    $5727C148,$2BE98A1D,$8AB41738,$20E1BE24,$AF96DA0F,$68458425,$99833BE5,$600D457D,
    $282F9350,$8334B362,$D91D1120,$2B6D8DA0,$642B1E31,$9C305A00,$52BCE688,$1B03588A,
    $F7BAEFD5,$4142ED9C,$A4315C11,$83323EC5,$DFEF4636,$A133C501,$E9D3531C,$EE353783),
   ($9DB30420,$1FB6E9DE,$A7BE7BEF,$D273A298,$4A4F7BDB,$64AD8C57,$85510443,$FA020ED1,
    $7E287AFF,$E60FB663,$095F35A1,$79EBF120,$FD059D43,$6497B7B1,$F3641F63,$241E4ADF,
    $28147F5F,$4FA2B8CD,$C9430040,$0CC32220,$FDD30B30,$C0A5374F,$1D2D00D9,$24147B15,
    $EE4D111A,$0FCA5167,$71FF904C,$2D195FFE,$1A05645F,$0C13FEFE,$081B08CA,$05170121,
    $80530100,$E83E5EFE,$AC9AF4F8,$7FE72701,$D2B8EE5F,$06DF4261,$BB9E9B8A,$7293EA25,
    $CE84FFDF,$F5718801,$3DD64B04,$A26F263B,$7ED48400,$547EEBE6,$446D4CA0,$6CF3D6F5,
    $2649ABDF,$AEA0C7F5,$36338CC1,$503F7E93,$D3772061,$11B638E1,$72500E03,$F80EB2BB,
    $ABE0502E,$EC8D77DE,$57971E81,$E14F6746,$C9335400,$6920318F,$081DBB99,$FFC304A5,
    $4D351805,$7F3D5CE3,$A6C866C6,$5D5BCCA9,$DAEC6FEA,$9F926F91,$9F46222F,$3991467D,
    $A5BF6D8E,$1143C44F,$43958302,$D0214EEB,$022083B8,$3FB6180C,$18F8931E,$281658E6,
    $26486E3E,$8BD78A70,$7477E4C1,$B506E07C,$F32D0A25,$79098B02,$E4EABB81,$28123B23,
    $69DEAD38,$1574CA16,$DF871B62,$211C40B7,$A51A9EF9,$0014377B,$041E8AC8,$09114003,
    $BD59E4D2,$E3D156D5,$4FE876D5,$2F91A340,$557BE8DE,$00EAE4A7,$0CE5C2EC,$4DB4BBA6,
    $E756BDFF,$DD3369AC,$EC17B035,$06572327,$99AFC8B0,$56C8C391,$6B65811C,$5E146119,
    $6E85CB75,$BE07C002,$C2325577,$893FF4EC,$5BBFC92D,$D0EC3B25,$B7801AB7,$8D6D3B24,
    $20C763EF,$C366A5FC,$9C382880,$0ACE3205,$AAC9548A,$ECA1D7C7,$041AFA32,$1D16625A,
    $6701902C,$9B757A54,$31D477F7,$9126B031,$36CC6FDB,$C70B8B46,$D9E66A48,$56E55A79,
    $026A4CEB,$52437EFF,$2F8F76B4,$0DF980A5,$8674CDE3,$EDDA04EB,$17A9BE04,$2C18F4DF,
    $B7747F9D,$AB2AF7B4,$EFC34D20,$2E096B7C,$1741A254,$E5B6A035,$213D42F6,$2C1C7C26,
    $61C2F50F,$6552DAF9,$D2C231F8,$25130F69,$D8167FA2,$0418F2C8,$001A96A6,$0D1526AB,
    $63315C21,$5E0A72EC,$49BAFEFD,$187908D9,$8D0DBD86,$311170A7,$3E9B640C,$CC3E10D7,
    $D5CAD3B6,$0CAEC388,$F73001E1,$6C728AFF,$71EAE2A1,$1F9AF36E,$CFCBD12F,$C1DE8417,
    $AC07BE6B,$CB44A1D8,$8B9B0F56,$013988C3,$B1C52FCA,$B4BE31CD,$D8782806,$12A3A4E2,
    $6F7DE532,$58FD7EB6,$D01EE900,$24ADFFC2,$F4990FC5,$9711AAC5,$001D7B95,$82E5E7D2,
    $109873F6,$00613096,$C32D9521,$ADA121FF,$29908415,$7FBB977F,$AF9EB3DB,$29C9ED2A,
    $5CE2A465,$A730F32C,$D0AA3FE8,$8A5CC091,$D49E2CE7,$0CE454A9,$D60ACD86,$015F1919,
    $77079103,$DEA03AF6,$78A8565E,$DEE356DF,$21F05CBE,$8B75E387,$B3C50651,$B8A5C3EF,
    $D8EEB6D2,$E523BE77,$C2154529,$2F69EFDF,$AFE67AFB,$F470C4B2,$F3E0EB5B,$D6CC9876,
    $39E4460C,$1FDA8538,$1987832F,$CA007367,$A99144F8,$296B299E,$492FC295,$9266BEAB,
    $B5676E69,$9BD3DDDA,$DF7E052F,$DB25701C,$1B5E51EE,$F65324E6,$6AFCE36C,$0316CC04,
    $8644213E,$B7DC59D0,$7965291F,$CCD6FD43,$41823979,$932BCDF6,$B657C34D,$4EDFD282,
    $7AE5290C,$3CB9536B,$851E20FE,$9833557E,$13ECF0B0,$D3FFB372,$3F85C5C1,$0AEF7ED2));

  Blowfish_Data: array[0..3, 0..255] of LongWord = (
   ($D1310BA6,$98DFB5AC,$2FFD72DB,$D01ADFB7,$B8E1AFED,$6A267E96,$BA7C9045,$F12C7F99,
    $24A19947,$B3916CF7,$0801F2E2,$858EFC16,$636920D8,$71574E69,$A458FEA3,$F4933D7E,
    $0D95748F,$728EB658,$718BCD58,$82154AEE,$7B54A41D,$C25A59B5,$9C30D539,$2AF26013,
    $C5D1B023,$286085F0,$CA417918,$B8DB38EF,$8E79DCB0,$603A180E,$6C9E0E8B,$B01E8A3E,
    $D71577C1,$BD314B27,$78AF2FDA,$55605C60,$E65525F3,$AA55AB94,$57489862,$63E81440,
    $55CA396A,$2AAB10B6,$B4CC5C34,$1141E8CE,$A15486AF,$7C72E993,$B3EE1411,$636FBC2A,
    $2BA9C55D,$741831F6,$CE5C3E16,$9B87931E,$AFD6BA33,$6C24CF5C,$7A325381,$28958677,
    $3B8F4898,$6B4BB9AF,$C4BFE81B,$66282193,$61D809CC,$FB21A991,$487CAC60,$5DEC8032,
    $EF845D5D,$E98575B1,$DC262302,$EB651B88,$23893E81,$D396ACC5,$0F6D6FF3,$83F44239,
    $2E0B4482,$A4842004,$69C8F04A,$9E1F9B5E,$21C66842,$F6E96C9A,$670C9C61,$ABD388F0,
    $6A51A0D2,$D8542F68,$960FA728,$AB5133A3,$6EEF0B6C,$137A3BE4,$BA3BF050,$7EFB2A98,
    $A1F1651D,$39AF0176,$66CA593E,$82430E88,$8CEE8619,$456F9FB4,$7D84A5C3,$3B8B5EBE,
    $E06F75D8,$85C12073,$401A449F,$56C16AA6,$4ED3AA62,$363F7706,$1BFEDF72,$429B023D,
    $37D0D724,$D00A1248,$DB0FEAD3,$49F1C09B,$075372C9,$80991B7B,$25D479D8,$F6E8DEF7,
    $E3FE501A,$B6794C3B,$976CE0BD,$04C006BA,$C1A94FB6,$409F60C4,$5E5C9EC2,$196A2463,
    $68FB6FAF,$3E6C53B5,$1339B2EB,$3B52EC6F,$6DFC511F,$9B30952C,$CC814544,$AF5EBD09,
    $BEE3D004,$DE334AFD,$660F2807,$192E4BB3,$C0CBA857,$45C8740F,$D20B5F39,$B9D3FBDB,
    $5579C0BD,$1A60320A,$D6A100C6,$402C7279,$679F25FE,$FB1FA3CC,$8EA5E9F8,$DB3222F8,
    $3C7516DF,$FD616B15,$2F501EC8,$AD0552AB,$323DB5FA,$FD238760,$53317B48,$3E00DF82,
    $9E5C57BB,$CA6F8CA0,$1A87562E,$DF1769DB,$D542A8F6,$287EFFC3,$AC6732C6,$8C4F5573,
    $695B27B0,$BBCA58C8,$E1FFA35D,$B8F011A0,$10FA3D98,$FD2183B8,$4AFCB56C,$2DD1D35B,
    $9A53E479,$B6F84565,$D28E49BC,$4BFB9790,$E1DDF2DA,$A4CB7E33,$62FB1341,$CEE4C6E8,
    $EF20CADA,$36774C01,$D07E9EFE,$2BF11FB4,$95DBDA4D,$AE909198,$EAAD8E71,$6B93D5A0,
    $D08ED1D0,$AFC725E0,$8E3C5B2F,$8E7594B7,$8FF6E2FB,$F2122B64,$8888B812,$900DF01C,
    $4FAD5EA0,$688FC31C,$D1CFF191,$B3A8C1AD,$2F2F2218,$BE0E1777,$EA752DFE,$8B021FA1,
    $E5A0CC0F,$B56F74E8,$18ACF3D6,$CE89E299,$B4A84FE0,$FD13E0B7,$7CC43B81,$D2ADA8D9,
    $165FA266,$80957705,$93CC7314,$211A1477,$E6AD2065,$77B5FA86,$C75442F5,$FB9D35CF,
    $EBCDAF0C,$7B3E89A0,$D6411BD3,$AE1E7E49,$00250E2D,$2071B35E,$226800BB,$57B8E0AF,
    $2464369B,$F009B91E,$5563911D,$59DFA6AA,$78C14389,$D95A537F,$207D5BA2,$02E5B9C5,
    $83260376,$6295CFA9,$11C81968,$4E734A41,$B3472DCA,$7B14A94A,$1B510052,$9A532915,
    $D60F573F,$BC9BC6E4,$2B60A476,$81E67400,$08BA6FB5,$571BE91F,$F296EC6B,$2A0DD915,
    $B6636521,$E7B9F9B6,$FF34052E,$C5855664,$53B02D5D,$A99F8FA1,$08BA4799,$6E85076A),
   ($4B7A70E9,$B5B32944,$DB75092E,$C4192623,$AD6EA6B0,$49A7DF7D,$9CEE60B8,$8FEDB266,
    $ECAA8C71,$699A17FF,$5664526C,$C2B19EE1,$193602A5,$75094C29,$A0591340,$E4183A3E,
    $3F54989A,$5B429D65,$6B8FE4D6,$99F73FD6,$A1D29C07,$EFE830F5,$4D2D38E6,$F0255DC1,
    $4CDD2086,$8470EB26,$6382E9C6,$021ECC5E,$09686B3F,$3EBAEFC9,$3C971814,$6B6A70A1,
    $687F3584,$52A0E286,$B79C5305,$AA500737,$3E07841C,$7FDEAE5C,$8E7D44EC,$5716F2B8,
    $B03ADA37,$F0500C0D,$F01C1F04,$0200B3FF,$AE0CF51A,$3CB574B2,$25837A58,$DC0921BD,
    $D19113F9,$7CA92FF6,$94324773,$22F54701,$3AE5E581,$37C2DADC,$C8B57634,$9AF3DDA7,
    $A9446146,$0FD0030E,$ECC8C73E,$A4751E41,$E238CD99,$3BEA0E2F,$3280BBA1,$183EB331,
    $4E548B38,$4F6DB908,$6F420D03,$F60A04BF,$2CB81290,$24977C79,$5679B072,$BCAF89AF,
    $DE9A771F,$D9930810,$B38BAE12,$DCCF3F2E,$5512721F,$2E6B7124,$501ADDE6,$9F84CD87,
    $7A584718,$7408DA17,$BC9F9ABC,$E94B7D8C,$EC7AEC3A,$DB851DFA,$63094366,$C464C3D2,
    $EF1C1847,$3215D908,$DD433B37,$24C2BA16,$12A14D43,$2A65C451,$50940002,$133AE4DD,
    $71DFF89E,$10314E55,$81AC77D6,$5F11199B,$043556F1,$D7A3C76B,$3C11183B,$5924A509,
    $F28FE6ED,$97F1FBFA,$9EBABF2C,$1E153C6E,$86E34570,$EAE96FB1,$860E5E0A,$5A3E2AB3,
    $771FE71C,$4E3D06FA,$2965DCB9,$99E71D0F,$803E89D6,$5266C825,$2E4CC978,$9C10B36A,
    $C6150EBA,$94E2EA78,$A5FC3C53,$1E0A2DF4,$F2F74EA7,$361D2B3D,$1939260F,$19C27960,
    $5223A708,$F71312B6,$EBADFE6E,$EAC31F66,$E3BC4595,$A67BC883,$B17F37D1,$018CFF28,
    $C332DDEF,$BE6C5AA5,$65582185,$68AB9802,$EECEA50F,$DB2F953B,$2AEF7DAD,$5B6E2F84,
    $1521B628,$29076170,$ECDD4775,$619F1510,$13CCA830,$EB61BD96,$0334FE1E,$AA0363CF,
    $B5735C90,$4C70A239,$D59E9E0B,$CBAADE14,$EECC86BC,$60622CA7,$9CAB5CAB,$B2F3846E,
    $648B1EAF,$19BDF0CA,$A02369B9,$655ABB50,$40685A32,$3C2AB4B3,$319EE9D5,$C021B8F7,
    $9B540B19,$875FA099,$95F7997E,$623D7DA8,$F837889A,$97E32D77,$11ED935F,$16681281,
    $0E358829,$C7E61FD6,$96DEDFA1,$7858BA99,$57F584A5,$1B227263,$9B83C3FF,$1AC24696,
    $CDB30AEB,$532E3054,$8FD948E4,$6DBC3128,$58EBF2EF,$34C6FFEA,$FE28ED61,$EE7C3C73,
    $5D4A14D9,$E864B7E3,$42105D14,$203E13E0,$45EEE2B6,$A3AAABEA,$DB6C4F15,$FACB4FD0,
    $C742F442,$EF6ABBB5,$654F3B1D,$41CD2105,$D81E799E,$86854DC7,$E44B476A,$3D816250,
    $CF62A1F2,$5B8D2646,$FC8883A0,$C1C7B6A3,$7F1524C3,$69CB7492,$47848A0B,$5692B285,
    $095BBF00,$AD19489D,$1462B174,$23820E00,$58428D2A,$0C55F5EA,$1DADF43E,$233F7061,
    $3372F092,$8D937E41,$D65FECF1,$6C223BDB,$7CDE3759,$CBEE7460,$4085F2A7,$CE77326E,
    $A6078084,$19F8509E,$E8EFD855,$61D99735,$A969A7AA,$C50C06C2,$5A04ABFC,$800BCADC,
    $9E447A2E,$C3453484,$FDD56705,$0E1E9EC9,$DB73DBD3,$105588CD,$675FDA79,$E3674340,
    $C5C43465,$713E38D8,$3D28F89E,$F16DFF20,$153E21E7,$8FB03D4A,$E6E39F2B,$DB83ADF7),
   ($E93D5A68,$948140F7,$F64C261C,$94692934,$411520F7,$7602D4F7,$BCF46B2E,$D4A20068,
    $D4082471,$3320F46A,$43B7D4B7,$500061AF,$1E39F62E,$97244546,$14214F74,$BF8B8840,
    $4D95FC1D,$96B591AF,$70F4DDD3,$66A02F45,$BFBC09EC,$03BD9785,$7FAC6DD0,$31CB8504,
    $96EB27B3,$55FD3941,$DA2547E6,$ABCA0A9A,$28507825,$530429F4,$0A2C86DA,$E9B66DFB,
    $68DC1462,$D7486900,$680EC0A4,$27A18DEE,$4F3FFEA2,$E887AD8C,$B58CE006,$7AF4D6B6,
    $AACE1E7C,$D3375FEC,$CE78A399,$406B2A42,$20FE9E35,$D9F385B9,$EE39D7AB,$3B124E8B,
    $1DC9FAF7,$4B6D1856,$26A36631,$EAE397B2,$3A6EFA74,$DD5B4332,$6841E7F7,$CA7820FB,
    $FB0AF54E,$D8FEB397,$454056AC,$BA489527,$55533A3A,$20838D87,$FE6BA9B7,$D096954B,
    $55A867BC,$A1159A58,$CCA92963,$99E1DB33,$A62A4A56,$3F3125F9,$5EF47E1C,$9029317C,
    $FDF8E802,$04272F70,$80BB155C,$05282CE3,$95C11548,$E4C66D22,$48C1133F,$C70F86DC,
    $07F9C9EE,$41041F0F,$404779A4,$5D886E17,$325F51EB,$D59BC0D1,$F2BCC18F,$41113564,
    $257B7834,$602A9C60,$DFF8E8A3,$1F636C1B,$0E12B4C2,$02E1329E,$AF664FD1,$CAD18115,
    $6B2395E0,$333E92E1,$3B240B62,$EEBEB922,$85B2A20E,$E6BA0D99,$DE720C8C,$2DA2F728,
    $D0127845,$95B794FD,$647D0862,$E7CCF5F0,$5449A36F,$877D48FA,$C39DFD27,$F33E8D1E,
    $0A476341,$992EFF74,$3A6F6EAB,$F4F8FD37,$A812DC60,$A1EBDDF8,$991BE14C,$DB6E6B0D,
    $C67B5510,$6D672C37,$2765D43B,$DCD0E804,$F1290DC7,$CC00FFA3,$B5390F92,$690FED0B,
    $667B9FFB,$CEDB7D9C,$A091CF0B,$D9155EA3,$BB132F88,$515BAD24,$7B9479BF,$763BD6EB,
    $37392EB3,$CC115979,$8026E297,$F42E312D,$6842ADA7,$C66A2B3B,$12754CCC,$782EF11C,
    $6A124237,$B79251E7,$06A1BBE6,$4BFB6350,$1A6B1018,$11CAEDFA,$3D25BDD8,$E2E1C3C9,
    $44421659,$0A121386,$D90CEC6E,$D5ABEA2A,$64AF674E,$DA86A85F,$BEBFE988,$64E4C3FE,
    $9DBC8057,$F0F7C086,$60787BF8,$6003604D,$D1FD8346,$F6381FB0,$7745AE04,$D736FCCC,
    $83426B33,$F01EAB71,$B0804187,$3C005E5F,$77A057BE,$BDE8AE24,$55464299,$BF582E61,
    $4E58F48F,$F2DDFDA2,$F474EF38,$8789BDC2,$5366F9C3,$C8B38E74,$B475F255,$46FCD9B9,
    $7AEB2661,$8B1DDF84,$846A0E79,$915F95E2,$466E598E,$20B45770,$8CD55591,$C902DE4C,
    $B90BACE1,$BB8205D0,$11A86248,$7574A99E,$B77F19B6,$E0A9DC09,$662D09A1,$C4324633,
    $E85A1F02,$09F0BE8C,$4A99A025,$1D6EFE10,$1AB93D1D,$0BA5A4DF,$A186F20F,$2868F169,
    $DCB7DA83,$573906FE,$A1E2CE9B,$4FCD7F52,$50115E01,$A70683FA,$A002B5C4,$0DE6D027,
    $9AF88C27,$773F8641,$C3604C06,$61A806B5,$F0177A28,$C0F586E0,$006058AA,$30DC7D62,
    $11E69ED7,$2338EA63,$53C2DD94,$C2C21634,$BBCBEE56,$90BCB6DE,$EBFC7DA1,$CE591D76,
    $6F05E409,$4B7C0188,$39720A3D,$7C927C24,$86E3725F,$724D9DB9,$1AC15BB4,$D39EB8FC,
    $ED545578,$08FCA5B5,$D83D7CD3,$4DAD0FC4,$1E50EF5E,$B161E6F8,$A28514D9,$6C51133C,
    $6FD5C7E7,$56E14EC4,$362ABFCE,$DDC6C837,$D79A3234,$92638212,$670EFA8E,$406000E0),
   ($3A39CE37,$D3FAF5CF,$ABC27737,$5AC52D1B,$5CB0679E,$4FA33742,$D3822740,$99BC9BBE,
    $D5118E9D,$BF0F7315,$D62D1C7E,$C700C47B,$B78C1B6B,$21A19045,$B26EB1BE,$6A366EB4,
    $5748AB2F,$BC946E79,$C6A376D2,$6549C2C8,$530FF8EE,$468DDE7D,$D5730A1D,$4CD04DC6,
    $2939BBDB,$A9BA4650,$AC9526E8,$BE5EE304,$A1FAD5F0,$6A2D519A,$63EF8CE2,$9A86EE22,
    $C089C2B8,$43242EF6,$A51E03AA,$9CF2D0A4,$83C061BA,$9BE96A4D,$8FE51550,$BA645BD6,
    $2826A2F9,$A73A3AE1,$4BA99586,$EF5562E9,$C72FEFD3,$F752F7DA,$3F046F69,$77FA0A59,
    $80E4A915,$87B08601,$9B09E6AD,$3B3EE593,$E990FD5A,$9E34D797,$2CF0B7D9,$022B8B51,
    $96D5AC3A,$017DA67D,$D1CF3ED6,$7C7D2D28,$1F9F25CF,$ADF2B89B,$5AD6B472,$5A88F54C,
    $E029AC71,$E019A5E6,$47B0ACFD,$ED93FA9B,$E8D3C48D,$283B57CC,$F8D56629,$79132E28,
    $785F0191,$ED756055,$F7960E44,$E3D35E8C,$15056DD4,$88F46DBA,$03A16125,$0564F0BD,
    $C3EB9E15,$3C9057A2,$97271AEC,$A93A072A,$1B3F6D9B,$1E6321F5,$F59C66FB,$26DCF319,
    $7533D928,$B155FDF5,$03563482,$8ABA3CBB,$28517711,$C20AD9F8,$ABCC5167,$CCAD925F,
    $4DE81751,$3830DC8E,$379D5862,$9320F991,$EA7A90C2,$FB3E7BCE,$5121CE64,$774FBE32,
    $A8B6E37E,$C3293D46,$48DE5369,$6413E680,$A2AE0810,$DD6DB224,$69852DFD,$09072166,
    $B39A460A,$6445C0DD,$586CDECF,$1C20C8AE,$5BBEF7DD,$1B588D40,$CCD2017F,$6BB4E3BB,
    $DDA26A7E,$3A59FF45,$3E350A44,$BCB4CDD5,$72EACEA8,$FA6484BB,$8D6612AE,$BF3C6F47,
    $D29BE463,$542F5D9E,$AEC2771B,$F64E6370,$740E0D8D,$E75B1357,$F8721671,$AF537D5D,
    $4040CB08,$4EB4E2CC,$34D2466A,$0115AF84,$E1B00428,$95983A1D,$06B89FB4,$CE6EA048,
    $6F3F3B82,$3520AB82,$011A1D4B,$277227F8,$611560B1,$E7933FDC,$BB3A792B,$344525BD,
    $A08839E1,$51CE794B,$2F32C9B7,$A01FBAC9,$E01CC87E,$BCC7D1F6,$CF0111C3,$A1E8AAC7,
    $1A908749,$D44FBD9A,$D0DADECB,$D50ADA38,$0339C32A,$C6913667,$8DF9317C,$E0B12B4F,
    $F79E59B7,$43F5BB3A,$F2D519FF,$27D9459C,$BF97222C,$15E6FC2A,$0F91FC71,$9B941525,
    $FAE59361,$CEB69CEB,$C2A86459,$12BAA8D1,$B6C1075E,$E3056A0C,$10D25065,$CB03A442,
    $E0EC6E0E,$1698DB3B,$4C98A0BE,$3278E964,$9F1F9532,$E0D392DF,$D3A0342B,$8971F21E,
    $1B0A7441,$4BA3348C,$C5BE7120,$C37632D8,$DF359F8D,$9B992F2E,$E60B6F47,$0FE3F11D,
    $E54CDA54,$1EDAD891,$CE6279CF,$CD3E7E6F,$1618B166,$FD2C1D05,$848FD2C5,$F6FB2299,
    $F523F357,$A6327623,$93A83531,$56CCCD02,$ACF08162,$5A75EBB5,$6E163697,$88D273CC,
    $DE966292,$81B949D0,$4C50901B,$71C65614,$E6C6C7BD,$327A140A,$45E1D006,$C3F27B9A,
    $C9AA53FD,$62A80F00,$BB25BFE2,$35BDD2F6,$71126905,$B2040222,$B6CBCF7C,$CD769C2B,
    $53113EC0,$1640E3D3,$38ABBD60,$2547ADF0,$BA38209C,$F746CE76,$77AFA1C5,$20756060,
    $85CBFE4E,$8AE88DD8,$7AAAF9B0,$4CF9AA7E,$1948C25C,$02FB8A8C,$01C36AE4,$D6EBE1F9,
    $90D4F869,$A65CDEA0,$3F09252D,$C208E69F,$B74E6132,$CE77E25B,$578FDFE3,$3AC372E6));

  Blowfish_Key: array[0..17] of LongWord = (
    $243F6A88,$85A308D3,$13198A2E,$03707344,$A4093822,$299F31D0,
    $082EFA98,$EC4E6C89,$452821E6,$38D01377,$BE5466CF,$34E90C6C,
    $C0AC29B7,$C97C50DD,$3F84D5B5,$B5470917,$9216D5D9,$8979FB1B);

  Mars_Data: array[0..511] of LongWord = (
    $09D0C479,$28C8FFE0,$84AA6C39,$9DAD7287,$7DFF9BE3,$D4268361,$C96DA1D4,$7974CC93,
    $85D0582E,$2A4B5705,$1CA16A62,$C3BD279D,$0F1F25E5,$5160372F,$C695C1FB,$4D7FF1E4,
    $AE5F6BF4,$0D72EE46,$FF23DE8A,$B1CF8E83,$F14902E2,$3E981E42,$8BF53EB6,$7F4BF8AC,
    $83631F83,$25970205,$76AFE784,$3A7931D4,$4F846450,$5C64C3F6,$210A5F18,$C6986A26,
    $28F4E826,$3A60A81C,$D340A664,$7EA820C4,$526687C5,$7EDDD12B,$32A11D1D,$9C9EF086,
    $80F6E831,$AB6F04AD,$56FB9B53,$8B2E095C,$B68556AE,$D2250B0D,$294A7721,$E21FB253,
    $AE136749,$E82AAE86,$93365104,$99404A66,$78A784DC,$B69BA84B,$04046793,$23DB5C1E,
    $46CAE1D6,$2FE28134,$5A223942,$1863CD5B,$C190C6E3,$07DFB846,$6EB88816,$2D0DCC4A,
    $A4CCAE59,$3798670D,$CBFA9493,$4F481D45,$EAFC8CA8,$DB1129D6,$B0449E20,$0F5407FB,
    $6167D9A8,$D1F45763,$4DAA96C3,$3BEC5958,$ABABA014,$B6CCD201,$38D6279F,$02682215,
    $8F376CD5,$092C237E,$BFC56593,$32889D2C,$854B3E95,$05BB9B43,$7DCD5DCD,$A02E926C,
    $FAE527E5,$36A1C330,$3412E1AE,$F257F462,$3C4F1D71,$30A2E809,$68E5F551,$9C61BA44,
    $5DED0AB8,$75CE09C8,$9654F93E,$698C0CCA,$243CB3E4,$2B062B97,$0F3B8D9E,$00E050DF,
    $FC5D6166,$E35F9288,$C079550D,$0591AEE8,$8E531E74,$75FE3578,$2F6D829A,$F60B21AE,
    $95E8EB8D,$6699486B,$901D7D9B,$FD6D6E31,$1090ACEF,$E0670DD8,$DAB2E692,$CD6D4365,
    $E5393514,$3AF345F0,$6241FC4D,$460DA3A3,$7BCF3729,$8BF1D1E0,$14AAC070,$1587ED55,
    $3AFD7D3E,$D2F29E01,$29A9D1F6,$EFB10C53,$CF3B870F,$B414935C,$664465ED,$024ACAC7,
    $59A744C1,$1D2936A7,$DC580AA6,$CF574CA8,$040A7A10,$6CD81807,$8A98BE4C,$ACCEA063,
    $C33E92B5,$D1E0E03D,$B322517E,$2092BD13,$386B2C4A,$52E8DD58,$58656DFB,$50820371,
    $41811896,$E337EF7E,$D39FB119,$C97F0DF6,$68FEA01B,$A150A6E5,$55258962,$EB6FF41B,
    $D7C9CD7A,$A619CD9E,$BCF09576,$2672C073,$F003FB3C,$4AB7A50B,$1484126A,$487BA9B1,
    $A64FC9C6,$F6957D49,$38B06A75,$DD805FCD,$63D094CF,$F51C999E,$1AA4D343,$B8495294,
    $CE9F8E99,$BFFCD770,$C7C275CC,$378453A7,$7B21BE33,$397F41BD,$4E94D131,$92CC1F98,
    $5915EA51,$99F861B7,$C9980A88,$1D74FD5F,$B0A495F8,$614DEED0,$B5778EEA,$5941792D,
    $FA90C1F8,$33F824B4,$C4965372,$3FF6D550,$4CA5FEC0,$8630E964,$5B3FBBD6,$7DA26A48,
    $B203231A,$04297514,$2D639306,$2EB13149,$16A45272,$532459A0,$8E5F4872,$F966C7D9,
    $07128DC0,$0D44DB62,$AFC8D52D,$06316131,$D838E7CE,$1BC41D00,$3A2E8C0F,$EA83837E,
    $B984737D,$13BA4891,$C4F8B949,$A6D6ACB3,$A215CDCE,$8359838B,$6BD1AA31,$F579DD52,
    $21B93F93,$F5176781,$187DFDDE,$E94AEB76,$2B38FD54,$431DE1DA,$AB394825,$9AD3048F,
    $DFEA32AA,$659473E3,$623F7863,$F3346C59,$AB3AB685,$3346A90B,$6B56443E,$C6DE01F8,
    $8D421FC0,$9B0ED10C,$88F1A1E9,$54C1F029,$7DEAD57B,$8D7BA426,$4CF5178A,$551A7CCA,
    $1A9A5F08,$FCD651B9,$25605182,$E11FC6C3,$B6FD9676,$337B3027,$B7C8EB14,$9E5FD030,
    $6B57E354,$AD913CF7,$7E16688D,$58872A69,$2C2FC7DF,$E389CCC6,$30738DF1,$0824A734,
    $E1797A8B,$A4A8D57B,$5B5D193B,$C8A8309B,$73F9A978,$73398D32,$0F59573E,$E9DF2B03,
    $E8A5B6C8,$848D0704,$98DF93C2,$720A1DC3,$684F259A,$943BA848,$A6370152,$863B5EA3,
    $D17B978B,$6D9B58EF,$0A700DD4,$A73D36BF,$8E6A0829,$8695BC14,$E35B3447,$933AC568,
    $8894B022,$2F511C27,$DDFBCC3C,$006662B6,$117C83FE,$4E12B414,$C2BCA766,$3A2FEC10,
    $F4562420,$55792E2A,$46F5D857,$CEDA25CE,$C3601D3B,$6C00AB46,$EFAC9C28,$B3C35047,
    $611DFEE3,$257C3207,$FDD58482,$3B14D84F,$23BECB64,$A075F3A3,$088F8EAD,$07ADF158,
    $7796943C,$FACABF3D,$C09730CD,$F7679969,$DA44E9ED,$2C854C12,$35935FA3,$2F057D9F,
    $690624F8,$1CB0BAFD,$7B0DBDC6,$810F23BB,$FA929A1A,$6D969A17,$6742979B,$74AC7D05,
    $010E65C4,$86A3D963,$F907B5A0,$D0042BD3,$158D7D03,$287A8255,$BBA8366F,$096EDC33,
    $21916A7B,$77B56B86,$951622F9,$A6C5E650,$8CEA17D1,$CD8C62BC,$A3D63433,$358A68FD,
    $0F9B9D3C,$D6AA295B,$FE33384A,$C000738E,$CD67EB2F,$E2EB6DC2,$97338B02,$06C9F246,
    $419CF1AD,$2B83C045,$3723F18A,$CB5B3089,$160BEAD7,$5D494656,$35F8A74B,$1E4E6C9E,
    $000399BD,$67466880,$B4174831,$ACF423B2,$CA815AB3,$5A6395E7,$302A67C5,$8BDB446B,
    $108F8FA4,$10223EDA,$92B8B48B,$7F38D0EE,$AB2701D4,$0262D415,$AF224A30,$B3D88ABA,
    $F8B2C3AF,$DAF7EF70,$CC97D3B7,$E9614B6C,$2BAEBFF4,$70F687CF,$386C9156,$CE092EE5,
    $01E87DA6,$6CE91E6A,$BB7BCC84,$C7922C20,$9D3B71FD,$060E41C6,$D7590F15,$4E03BB47,
    $183C198E,$63EEB240,$2DDBF49A,$6D5CBA54,$923750AF,$F9E14236,$7838162B,$59726C72,
    $81B66760,$BB2926C1,$48A0CE0D,$A6C0496D,$AD43507B,$718D496A,$9DF057AF,$44B1BDE6,
    $054356DC,$DE7CED35,$D51A138B,$62088CC9,$35830311,$C96EFCA2,$686F86EC,$8E77CB68,
    $63E1D6B8,$C80F9778,$79C491FD,$1B4C67F2,$72698D7D,$5E368C31,$F7D95E2E,$A1D3493F,
    $DCD9433E,$896F1552,$4BC4CA7A,$A6D1BAF4,$A5A96DCC,$0BEF8B46,$A169FDA7,$74DF40B7,
    $4E208804,$9A756607,$038E87C8,$20211E44,$8B7AD4BF,$C6403F35,$1848E36D,$80BDB038,
    $1E62891C,$643D2107,$BF04D6F8,$21092C8C,$F644F389,$0778404E,$7B78ADB8,$A2C52D53,
    $42157ABE,$A2253E2E,$7BF3F4AE,$80F594F9,$953194E7,$77EB92ED,$B3816930,$DA8D9336,
    $BF447469,$F26D9483,$EE6FAED5,$71371235,$DE425F73,$B4E59F43,$7DBE2D4E,$2D37B185,
    $49DC9A63,$98C39D98,$1301C9A2,$389B1BBF,$0C18588D,$A421C1BA,$7AA3865C,$71E08558,
    $3C5CFCAA,$7D239CA4,$0297D9DD,$D7DC2830,$4B37802B,$7428AB54,$AEEE0347,$4B3FBB85,
    $692F2F08,$134E578E,$36D9E0BF,$AE8B5FCF,$EDB93ECF,$2B27248E,$170EB1EF,$7DC57FD6,
    $1E760F16,$B1136601,$864E1B9B,$D7EA7319,$3AB871BD,$CFA4D76F,$E31BD782,$0DBEB469,
    $ABB96061,$5370F85D,$FFB07E37,$DA30D0FB,$EBC977B6,$0B98B40F,$3A4D0FE6,$DF4FC26B,
    $159CF22A,$C298D6E2,$2B78EF6A,$61A94AC0,$AB561187,$14EEA0F0,$DF0D4164,$19AF70EE);

  Mars_Key: array[0..6] of LongWord =
   ($09D0C479,$28C8FFE0,$84AA6C39,$9DAD7287,$7DFF9BE3,$D4268361,$C96DA1D4);

  Rijndael_S: array[0..1, 0..255] of Byte = (
   ($63,$7C,$77,$7B,$F2,$6B,$6F,$C5,$30,$01,$67,$2B,$FE,$D7,$AB,$76,
    $CA,$82,$C9,$7D,$FA,$59,$47,$F0,$AD,$D4,$A2,$AF,$9C,$A4,$72,$C0,
    $B7,$FD,$93,$26,$36,$3F,$F7,$CC,$34,$A5,$E5,$F1,$71,$D8,$31,$15,
    $04,$C7,$23,$C3,$18,$96,$05,$9A,$07,$12,$80,$E2,$EB,$27,$B2,$75,
    $09,$83,$2C,$1A,$1B,$6E,$5A,$A0,$52,$3B,$D6,$B3,$29,$E3,$2F,$84,
    $53,$D1,$00,$ED,$20,$FC,$B1,$5B,$6A,$CB,$BE,$39,$4A,$4C,$58,$CF,
    $D0,$EF,$AA,$FB,$43,$4D,$33,$85,$45,$F9,$02,$7F,$50,$3C,$9F,$A8,
    $51,$A3,$40,$8F,$92,$9D,$38,$F5,$BC,$B6,$DA,$21,$10,$FF,$F3,$D2,
    $CD,$0C,$13,$EC,$5F,$97,$44,$17,$C4,$A7,$7E,$3D,$64,$5D,$19,$73,
    $60,$81,$4F,$DC,$22,$2A,$90,$88,$46,$EE,$B8,$14,$DE,$5E,$0B,$DB,
    $E0,$32,$3A,$0A,$49,$06,$24,$5C,$C2,$D3,$AC,$62,$91,$95,$E4,$79,
    $E7,$C8,$37,$6D,$8D,$D5,$4E,$A9,$6C,$56,$F4,$EA,$65,$7A,$AE,$08,
    $BA,$78,$25,$2E,$1C,$A6,$B4,$C6,$E8,$DD,$74,$1F,$4B,$BD,$8B,$8A,
    $70,$3E,$B5,$66,$48,$03,$F6,$0E,$61,$35,$57,$B9,$86,$C1,$1D,$9E,
    $E1,$F8,$98,$11,$69,$D9,$8E,$94,$9B,$1E,$87,$E9,$CE,$55,$28,$DF,
    $8C,$A1,$89,$0D,$BF,$E6,$42,$68,$41,$99,$2D,$0F,$B0,$54,$BB,$16),
   ($52,$09,$6A,$D5,$30,$36,$A5,$38,$BF,$40,$A3,$9E,$81,$F3,$D7,$FB,
    $7C,$E3,$39,$82,$9B,$2F,$FF,$87,$34,$8E,$43,$44,$C4,$DE,$E9,$CB,
    $54,$7B,$94,$32,$A6,$C2,$23,$3D,$EE,$4C,$95,$0B,$42,$FA,$C3,$4E,
    $08,$2E,$A1,$66,$28,$D9,$24,$B2,$76,$5B,$A2,$49,$6D,$8B,$D1,$25,
    $72,$F8,$F6,$64,$86,$68,$98,$16,$D4,$A4,$5C,$CC,$5D,$65,$B6,$92,
    $6C,$70,$48,$50,$FD,$ED,$B9,$DA,$5E,$15,$46,$57,$A7,$8D,$9D,$84,
    $90,$D8,$AB,$00,$8C,$BC,$D3,$0A,$F7,$E4,$58,$05,$B8,$B3,$45,$06,
    $D0,$2C,$1E,$8F,$CA,$3F,$0F,$02,$C1,$AF,$BD,$03,$01,$13,$8A,$6B,
    $3A,$91,$11,$41,$4F,$67,$DC,$EA,$97,$F2,$CF,$CE,$F0,$B4,$E6,$73,
    $96,$AC,$74,$22,$E7,$AD,$35,$85,$E2,$F9,$37,$E8,$1C,$75,$DF,$6E,
    $47,$F1,$1A,$71,$1D,$29,$C5,$89,$6F,$B7,$62,$0E,$AA,$18,$BE,$1B,
    $FC,$56,$3E,$4B,$C6,$D2,$79,$20,$9A,$DB,$C0,$FE,$78,$CD,$5A,$F4,
    $1F,$DD,$A8,$33,$88,$07,$C7,$31,$B1,$12,$10,$59,$27,$80,$EC,$5F,
    $60,$51,$7F,$A9,$19,$B5,$4A,$0D,$2D,$E5,$7A,$9F,$93,$C9,$9C,$EF,
    $A0,$E0,$3B,$4D,$AE,$2A,$F5,$B0,$C8,$EB,$BB,$3C,$83,$53,$99,$61,
    $17,$2B,$04,$7E,$BA,$77,$D6,$26,$E1,$69,$14,$63,$55,$21,$0C,$7D));

  Rijndael_T: array[0..7, 0..255] of LongWord = (
   ($A56363C6,$847C7CF8,$997777EE,$8D7B7BF6,$0DF2F2FF,$BD6B6BD6,$B16F6FDE,$54C5C591,
    $50303060,$03010102,$A96767CE,$7D2B2B56,$19FEFEE7,$62D7D7B5,$E6ABAB4D,$9A7676EC,
    $45CACA8F,$9D82821F,$40C9C989,$877D7DFA,$15FAFAEF,$EB5959B2,$C947478E,$0BF0F0FB,
    $ECADAD41,$67D4D4B3,$FDA2A25F,$EAAFAF45,$BF9C9C23,$F7A4A453,$967272E4,$5BC0C09B,
    $C2B7B775,$1CFDFDE1,$AE93933D,$6A26264C,$5A36366C,$413F3F7E,$02F7F7F5,$4FCCCC83,
    $5C343468,$F4A5A551,$34E5E5D1,$08F1F1F9,$937171E2,$73D8D8AB,$53313162,$3F15152A,
    $0C040408,$52C7C795,$65232346,$5EC3C39D,$28181830,$A1969637,$0F05050A,$B59A9A2F,
    $0907070E,$36121224,$9B80801B,$3DE2E2DF,$26EBEBCD,$6927274E,$CDB2B27F,$9F7575EA,
    $1B090912,$9E83831D,$742C2C58,$2E1A1A34,$2D1B1B36,$B26E6EDC,$EE5A5AB4,$FBA0A05B,
    $F65252A4,$4D3B3B76,$61D6D6B7,$CEB3B37D,$7B292952,$3EE3E3DD,$712F2F5E,$97848413,
    $F55353A6,$68D1D1B9,$00000000,$2CEDEDC1,$60202040,$1FFCFCE3,$C8B1B179,$ED5B5BB6,
    $BE6A6AD4,$46CBCB8D,$D9BEBE67,$4B393972,$DE4A4A94,$D44C4C98,$E85858B0,$4ACFCF85,
    $6BD0D0BB,$2AEFEFC5,$E5AAAA4F,$16FBFBED,$C5434386,$D74D4D9A,$55333366,$94858511,
    $CF45458A,$10F9F9E9,$06020204,$817F7FFE,$F05050A0,$443C3C78,$BA9F9F25,$E3A8A84B,
    $F35151A2,$FEA3A35D,$C0404080,$8A8F8F05,$AD92923F,$BC9D9D21,$48383870,$04F5F5F1,
    $DFBCBC63,$C1B6B677,$75DADAAF,$63212142,$30101020,$1AFFFFE5,$0EF3F3FD,$6DD2D2BF,
    $4CCDCD81,$140C0C18,$35131326,$2FECECC3,$E15F5FBE,$A2979735,$CC444488,$3917172E,
    $57C4C493,$F2A7A755,$827E7EFC,$473D3D7A,$AC6464C8,$E75D5DBA,$2B191932,$957373E6,
    $A06060C0,$98818119,$D14F4F9E,$7FDCDCA3,$66222244,$7E2A2A54,$AB90903B,$8388880B,
    $CA46468C,$29EEEEC7,$D3B8B86B,$3C141428,$79DEDEA7,$E25E5EBC,$1D0B0B16,$76DBDBAD,
    $3BE0E0DB,$56323264,$4E3A3A74,$1E0A0A14,$DB494992,$0A06060C,$6C242448,$E45C5CB8,
    $5DC2C29F,$6ED3D3BD,$EFACAC43,$A66262C4,$A8919139,$A4959531,$37E4E4D3,$8B7979F2,
    $32E7E7D5,$43C8C88B,$5937376E,$B76D6DDA,$8C8D8D01,$64D5D5B1,$D24E4E9C,$E0A9A949,
    $B46C6CD8,$FA5656AC,$07F4F4F3,$25EAEACF,$AF6565CA,$8E7A7AF4,$E9AEAE47,$18080810,
    $D5BABA6F,$887878F0,$6F25254A,$722E2E5C,$241C1C38,$F1A6A657,$C7B4B473,$51C6C697,
    $23E8E8CB,$7CDDDDA1,$9C7474E8,$211F1F3E,$DD4B4B96,$DCBDBD61,$868B8B0D,$858A8A0F,
    $907070E0,$423E3E7C,$C4B5B571,$AA6666CC,$D8484890,$05030306,$01F6F6F7,$120E0E1C,
    $A36161C2,$5F35356A,$F95757AE,$D0B9B969,$91868617,$58C1C199,$271D1D3A,$B99E9E27,
    $38E1E1D9,$13F8F8EB,$B398982B,$33111122,$BB6969D2,$70D9D9A9,$898E8E07,$A7949433,
    $B69B9B2D,$221E1E3C,$92878715,$20E9E9C9,$49CECE87,$FF5555AA,$78282850,$7ADFDFA5,
    $8F8C8C03,$F8A1A159,$80898909,$170D0D1A,$DABFBF65,$31E6E6D7,$C6424284,$B86868D0,
    $C3414182,$B0999929,$772D2D5A,$110F0F1E,$CBB0B07B,$FC5454A8,$D6BBBB6D,$3A16162C),
   ($6363C6A5,$7C7CF884,$7777EE99,$7B7BF68D,$F2F2FF0D,$6B6BD6BD,$6F6FDEB1,$C5C59154,
    $30306050,$01010203,$6767CEA9,$2B2B567D,$FEFEE719,$D7D7B562,$ABAB4DE6,$7676EC9A,
    $CACA8F45,$82821F9D,$C9C98940,$7D7DFA87,$FAFAEF15,$5959B2EB,$47478EC9,$F0F0FB0B,
    $ADAD41EC,$D4D4B367,$A2A25FFD,$AFAF45EA,$9C9C23BF,$A4A453F7,$7272E496,$C0C09B5B,
    $B7B775C2,$FDFDE11C,$93933DAE,$26264C6A,$36366C5A,$3F3F7E41,$F7F7F502,$CCCC834F,
    $3434685C,$A5A551F4,$E5E5D134,$F1F1F908,$7171E293,$D8D8AB73,$31316253,$15152A3F,
    $0404080C,$C7C79552,$23234665,$C3C39D5E,$18183028,$969637A1,$05050A0F,$9A9A2FB5,
    $07070E09,$12122436,$80801B9B,$E2E2DF3D,$EBEBCD26,$27274E69,$B2B27FCD,$7575EA9F,
    $0909121B,$83831D9E,$2C2C5874,$1A1A342E,$1B1B362D,$6E6EDCB2,$5A5AB4EE,$A0A05BFB,
    $5252A4F6,$3B3B764D,$D6D6B761,$B3B37DCE,$2929527B,$E3E3DD3E,$2F2F5E71,$84841397,
    $5353A6F5,$D1D1B968,$00000000,$EDEDC12C,$20204060,$FCFCE31F,$B1B179C8,$5B5BB6ED,
    $6A6AD4BE,$CBCB8D46,$BEBE67D9,$3939724B,$4A4A94DE,$4C4C98D4,$5858B0E8,$CFCF854A,
    $D0D0BB6B,$EFEFC52A,$AAAA4FE5,$FBFBED16,$434386C5,$4D4D9AD7,$33336655,$85851194,
    $45458ACF,$F9F9E910,$02020406,$7F7FFE81,$5050A0F0,$3C3C7844,$9F9F25BA,$A8A84BE3,
    $5151A2F3,$A3A35DFE,$404080C0,$8F8F058A,$92923FAD,$9D9D21BC,$38387048,$F5F5F104,
    $BCBC63DF,$B6B677C1,$DADAAF75,$21214263,$10102030,$FFFFE51A,$F3F3FD0E,$D2D2BF6D,
    $CDCD814C,$0C0C1814,$13132635,$ECECC32F,$5F5FBEE1,$979735A2,$444488CC,$17172E39,
    $C4C49357,$A7A755F2,$7E7EFC82,$3D3D7A47,$6464C8AC,$5D5DBAE7,$1919322B,$7373E695,
    $6060C0A0,$81811998,$4F4F9ED1,$DCDCA37F,$22224466,$2A2A547E,$90903BAB,$88880B83,
    $46468CCA,$EEEEC729,$B8B86BD3,$1414283C,$DEDEA779,$5E5EBCE2,$0B0B161D,$DBDBAD76,
    $E0E0DB3B,$32326456,$3A3A744E,$0A0A141E,$494992DB,$06060C0A,$2424486C,$5C5CB8E4,
    $C2C29F5D,$D3D3BD6E,$ACAC43EF,$6262C4A6,$919139A8,$959531A4,$E4E4D337,$7979F28B,
    $E7E7D532,$C8C88B43,$37376E59,$6D6DDAB7,$8D8D018C,$D5D5B164,$4E4E9CD2,$A9A949E0,
    $6C6CD8B4,$5656ACFA,$F4F4F307,$EAEACF25,$6565CAAF,$7A7AF48E,$AEAE47E9,$08081018,
    $BABA6FD5,$7878F088,$25254A6F,$2E2E5C72,$1C1C3824,$A6A657F1,$B4B473C7,$C6C69751,
    $E8E8CB23,$DDDDA17C,$7474E89C,$1F1F3E21,$4B4B96DD,$BDBD61DC,$8B8B0D86,$8A8A0F85,
    $7070E090,$3E3E7C42,$B5B571C4,$6666CCAA,$484890D8,$03030605,$F6F6F701,$0E0E1C12,
    $6161C2A3,$35356A5F,$5757AEF9,$B9B969D0,$86861791,$C1C19958,$1D1D3A27,$9E9E27B9,
    $E1E1D938,$F8F8EB13,$98982BB3,$11112233,$6969D2BB,$D9D9A970,$8E8E0789,$949433A7,
    $9B9B2DB6,$1E1E3C22,$87871592,$E9E9C920,$CECE8749,$5555AAFF,$28285078,$DFDFA57A,
    $8C8C038F,$A1A159F8,$89890980,$0D0D1A17,$BFBF65DA,$E6E6D731,$424284C6,$6868D0B8,
    $414182C3,$999929B0,$2D2D5A77,$0F0F1E11,$B0B07BCB,$5454A8FC,$BBBB6DD6,$16162C3A),
   ($63C6A563,$7CF8847C,$77EE9977,$7BF68D7B,$F2FF0DF2,$6BD6BD6B,$6FDEB16F,$C59154C5,
    $30605030,$01020301,$67CEA967,$2B567D2B,$FEE719FE,$D7B562D7,$AB4DE6AB,$76EC9A76,
    $CA8F45CA,$821F9D82,$C98940C9,$7DFA877D,$FAEF15FA,$59B2EB59,$478EC947,$F0FB0BF0,
    $AD41ECAD,$D4B367D4,$A25FFDA2,$AF45EAAF,$9C23BF9C,$A453F7A4,$72E49672,$C09B5BC0,
    $B775C2B7,$FDE11CFD,$933DAE93,$264C6A26,$366C5A36,$3F7E413F,$F7F502F7,$CC834FCC,
    $34685C34,$A551F4A5,$E5D134E5,$F1F908F1,$71E29371,$D8AB73D8,$31625331,$152A3F15,
    $04080C04,$C79552C7,$23466523,$C39D5EC3,$18302818,$9637A196,$050A0F05,$9A2FB59A,
    $070E0907,$12243612,$801B9B80,$E2DF3DE2,$EBCD26EB,$274E6927,$B27FCDB2,$75EA9F75,
    $09121B09,$831D9E83,$2C58742C,$1A342E1A,$1B362D1B,$6EDCB26E,$5AB4EE5A,$A05BFBA0,
    $52A4F652,$3B764D3B,$D6B761D6,$B37DCEB3,$29527B29,$E3DD3EE3,$2F5E712F,$84139784,
    $53A6F553,$D1B968D1,$00000000,$EDC12CED,$20406020,$FCE31FFC,$B179C8B1,$5BB6ED5B,
    $6AD4BE6A,$CB8D46CB,$BE67D9BE,$39724B39,$4A94DE4A,$4C98D44C,$58B0E858,$CF854ACF,
    $D0BB6BD0,$EFC52AEF,$AA4FE5AA,$FBED16FB,$4386C543,$4D9AD74D,$33665533,$85119485,
    $458ACF45,$F9E910F9,$02040602,$7FFE817F,$50A0F050,$3C78443C,$9F25BA9F,$A84BE3A8,
    $51A2F351,$A35DFEA3,$4080C040,$8F058A8F,$923FAD92,$9D21BC9D,$38704838,$F5F104F5,
    $BC63DFBC,$B677C1B6,$DAAF75DA,$21426321,$10203010,$FFE51AFF,$F3FD0EF3,$D2BF6DD2,
    $CD814CCD,$0C18140C,$13263513,$ECC32FEC,$5FBEE15F,$9735A297,$4488CC44,$172E3917,
    $C49357C4,$A755F2A7,$7EFC827E,$3D7A473D,$64C8AC64,$5DBAE75D,$19322B19,$73E69573,
    $60C0A060,$81199881,$4F9ED14F,$DCA37FDC,$22446622,$2A547E2A,$903BAB90,$880B8388,
    $468CCA46,$EEC729EE,$B86BD3B8,$14283C14,$DEA779DE,$5EBCE25E,$0B161D0B,$DBAD76DB,
    $E0DB3BE0,$32645632,$3A744E3A,$0A141E0A,$4992DB49,$060C0A06,$24486C24,$5CB8E45C,
    $C29F5DC2,$D3BD6ED3,$AC43EFAC,$62C4A662,$9139A891,$9531A495,$E4D337E4,$79F28B79,
    $E7D532E7,$C88B43C8,$376E5937,$6DDAB76D,$8D018C8D,$D5B164D5,$4E9CD24E,$A949E0A9,
    $6CD8B46C,$56ACFA56,$F4F307F4,$EACF25EA,$65CAAF65,$7AF48E7A,$AE47E9AE,$08101808,
    $BA6FD5BA,$78F08878,$254A6F25,$2E5C722E,$1C38241C,$A657F1A6,$B473C7B4,$C69751C6,
    $E8CB23E8,$DDA17CDD,$74E89C74,$1F3E211F,$4B96DD4B,$BD61DCBD,$8B0D868B,$8A0F858A,
    $70E09070,$3E7C423E,$B571C4B5,$66CCAA66,$4890D848,$03060503,$F6F701F6,$0E1C120E,
    $61C2A361,$356A5F35,$57AEF957,$B969D0B9,$86179186,$C19958C1,$1D3A271D,$9E27B99E,
    $E1D938E1,$F8EB13F8,$982BB398,$11223311,$69D2BB69,$D9A970D9,$8E07898E,$9433A794,
    $9B2DB69B,$1E3C221E,$87159287,$E9C920E9,$CE8749CE,$55AAFF55,$28507828,$DFA57ADF,
    $8C038F8C,$A159F8A1,$89098089,$0D1A170D,$BF65DABF,$E6D731E6,$4284C642,$68D0B868,
    $4182C341,$9929B099,$2D5A772D,$0F1E110F,$B07BCBB0,$54A8FC54,$BB6DD6BB,$162C3A16),
   ($C6A56363,$F8847C7C,$EE997777,$F68D7B7B,$FF0DF2F2,$D6BD6B6B,$DEB16F6F,$9154C5C5,
    $60503030,$02030101,$CEA96767,$567D2B2B,$E719FEFE,$B562D7D7,$4DE6ABAB,$EC9A7676,
    $8F45CACA,$1F9D8282,$8940C9C9,$FA877D7D,$EF15FAFA,$B2EB5959,$8EC94747,$FB0BF0F0,
    $41ECADAD,$B367D4D4,$5FFDA2A2,$45EAAFAF,$23BF9C9C,$53F7A4A4,$E4967272,$9B5BC0C0,
    $75C2B7B7,$E11CFDFD,$3DAE9393,$4C6A2626,$6C5A3636,$7E413F3F,$F502F7F7,$834FCCCC,
    $685C3434,$51F4A5A5,$D134E5E5,$F908F1F1,$E2937171,$AB73D8D8,$62533131,$2A3F1515,
    $080C0404,$9552C7C7,$46652323,$9D5EC3C3,$30281818,$37A19696,$0A0F0505,$2FB59A9A,
    $0E090707,$24361212,$1B9B8080,$DF3DE2E2,$CD26EBEB,$4E692727,$7FCDB2B2,$EA9F7575,
    $121B0909,$1D9E8383,$58742C2C,$342E1A1A,$362D1B1B,$DCB26E6E,$B4EE5A5A,$5BFBA0A0,
    $A4F65252,$764D3B3B,$B761D6D6,$7DCEB3B3,$527B2929,$DD3EE3E3,$5E712F2F,$13978484,
    $A6F55353,$B968D1D1,$00000000,$C12CEDED,$40602020,$E31FFCFC,$79C8B1B1,$B6ED5B5B,
    $D4BE6A6A,$8D46CBCB,$67D9BEBE,$724B3939,$94DE4A4A,$98D44C4C,$B0E85858,$854ACFCF,
    $BB6BD0D0,$C52AEFEF,$4FE5AAAA,$ED16FBFB,$86C54343,$9AD74D4D,$66553333,$11948585,
    $8ACF4545,$E910F9F9,$04060202,$FE817F7F,$A0F05050,$78443C3C,$25BA9F9F,$4BE3A8A8,
    $A2F35151,$5DFEA3A3,$80C04040,$058A8F8F,$3FAD9292,$21BC9D9D,$70483838,$F104F5F5,
    $63DFBCBC,$77C1B6B6,$AF75DADA,$42632121,$20301010,$E51AFFFF,$FD0EF3F3,$BF6DD2D2,
    $814CCDCD,$18140C0C,$26351313,$C32FECEC,$BEE15F5F,$35A29797,$88CC4444,$2E391717,
    $9357C4C4,$55F2A7A7,$FC827E7E,$7A473D3D,$C8AC6464,$BAE75D5D,$322B1919,$E6957373,
    $C0A06060,$19988181,$9ED14F4F,$A37FDCDC,$44662222,$547E2A2A,$3BAB9090,$0B838888,
    $8CCA4646,$C729EEEE,$6BD3B8B8,$283C1414,$A779DEDE,$BCE25E5E,$161D0B0B,$AD76DBDB,
    $DB3BE0E0,$64563232,$744E3A3A,$141E0A0A,$92DB4949,$0C0A0606,$486C2424,$B8E45C5C,
    $9F5DC2C2,$BD6ED3D3,$43EFACAC,$C4A66262,$39A89191,$31A49595,$D337E4E4,$F28B7979,
    $D532E7E7,$8B43C8C8,$6E593737,$DAB76D6D,$018C8D8D,$B164D5D5,$9CD24E4E,$49E0A9A9,
    $D8B46C6C,$ACFA5656,$F307F4F4,$CF25EAEA,$CAAF6565,$F48E7A7A,$47E9AEAE,$10180808,
    $6FD5BABA,$F0887878,$4A6F2525,$5C722E2E,$38241C1C,$57F1A6A6,$73C7B4B4,$9751C6C6,
    $CB23E8E8,$A17CDDDD,$E89C7474,$3E211F1F,$96DD4B4B,$61DCBDBD,$0D868B8B,$0F858A8A,
    $E0907070,$7C423E3E,$71C4B5B5,$CCAA6666,$90D84848,$06050303,$F701F6F6,$1C120E0E,
    $C2A36161,$6A5F3535,$AEF95757,$69D0B9B9,$17918686,$9958C1C1,$3A271D1D,$27B99E9E,
    $D938E1E1,$EB13F8F8,$2BB39898,$22331111,$D2BB6969,$A970D9D9,$07898E8E,$33A79494,
    $2DB69B9B,$3C221E1E,$15928787,$C920E9E9,$8749CECE,$AAFF5555,$50782828,$A57ADFDF,
    $038F8C8C,$59F8A1A1,$09808989,$1A170D0D,$65DABFBF,$D731E6E6,$84C64242,$D0B86868,
    $82C34141,$29B09999,$5A772D2D,$1E110F0F,$7BCBB0B0,$A8FC5454,$6DD6BBBB,$2C3A1616),
   ($50A7F451,$5365417E,$C3A4171A,$965E273A,$CB6BAB3B,$F1459D1F,$AB58FAAC,$9303E34B,
    $55FA3020,$F66D76AD,$9176CC88,$254C02F5,$FCD7E54F,$D7CB2AC5,$80443526,$8FA362B5,
    $495AB1DE,$671BBA25,$980EEA45,$E1C0FE5D,$02752FC3,$12F04C81,$A397468D,$C6F9D36B,
    $E75F8F03,$959C9215,$EB7A6DBF,$DA595295,$2D83BED4,$D3217458,$2969E049,$44C8C98E,
    $6A89C275,$78798EF4,$6B3E5899,$DD71B927,$B64FE1BE,$17AD88F0,$66AC20C9,$B43ACE7D,
    $184ADF63,$82311AE5,$60335197,$457F5362,$E07764B1,$84AE6BBB,$1CA081FE,$942B08F9,
    $58684870,$19FD458F,$876CDE94,$B7F87B52,$23D373AB,$E2024B72,$578F1FE3,$2AAB5566,
    $0728EBB2,$03C2B52F,$9A7BC586,$A50837D3,$F2872830,$B2A5BF23,$BA6A0302,$5C8216ED,
    $2B1CCF8A,$92B479A7,$F0F207F3,$A1E2694E,$CDF4DA65,$D5BE0506,$1F6234D1,$8AFEA6C4,
    $9D532E34,$A055F3A2,$32E18A05,$75EBF6A4,$39EC830B,$AAEF6040,$069F715E,$51106EBD,
    $F98A213E,$3D06DD96,$AE053EDD,$46BDE64D,$B58D5491,$055DC471,$6FD40604,$FF155060,
    $24FB9819,$97E9BDD6,$CC434089,$779ED967,$BD42E8B0,$888B8907,$385B19E7,$DBEEC879,
    $470A7CA1,$E90F427C,$C91E84F8,$00000000,$83868009,$48ED2B32,$AC70111E,$4E725A6C,
    $FBFF0EFD,$5638850F,$1ED5AE3D,$27392D36,$64D90F0A,$21A65C68,$D1545B9B,$3A2E3624,
    $B1670A0C,$0FE75793,$D296EEB4,$9E919B1B,$4FC5C080,$A220DC61,$694B775A,$161A121C,
    $0ABA93E2,$E52AA0C0,$43E0223C,$1D171B12,$0B0D090E,$ADC78BF2,$B9A8B62D,$C8A91E14,
    $8519F157,$4C0775AF,$BBDD99EE,$FD607FA3,$9F2601F7,$BCF5725C,$C53B6644,$347EFB5B,
    $7629438B,$DCC623CB,$68FCEDB6,$63F1E4B8,$CADC31D7,$10856342,$40229713,$2011C684,
    $7D244A85,$F83DBBD2,$1132F9AE,$6DA129C7,$4B2F9E1D,$F330B2DC,$EC52860D,$D0E3C177,
    $6C16B32B,$99B970A9,$FA489411,$2264E947,$C48CFCA8,$1A3FF0A0,$D82C7D56,$EF903322,
    $C74E4987,$C1D138D9,$FEA2CA8C,$360BD498,$CF81F5A6,$28DE7AA5,$268EB7DA,$A4BFAD3F,
    $E49D3A2C,$0D927850,$9BCC5F6A,$62467E54,$C2138DF6,$E8B8D890,$5EF7392E,$F5AFC382,
    $BE805D9F,$7C93D069,$A92DD56F,$B31225CF,$3B99ACC8,$A77D1810,$6E639CE8,$7BBB3BDB,
    $097826CD,$F418596E,$01B79AEC,$A89A4F83,$656E95E6,$7EE6FFAA,$08CFBC21,$E6E815EF,
    $D99BE7BA,$CE366F4A,$D4099FEA,$D67CB029,$AFB2A431,$31233F2A,$3094A5C6,$C066A235,
    $37BC4E74,$A6CA82FC,$B0D090E0,$15D8A733,$4A9804F1,$F7DAEC41,$0E50CD7F,$2FF69117,
    $8DD64D76,$4DB0EF43,$544DAACC,$DF0496E4,$E3B5D19E,$1B886A4C,$B81F2CC1,$7F516546,
    $04EA5E9D,$5D358C01,$737487FA,$2E410BFB,$5A1D67B3,$52D2DB92,$335610E9,$1347D66D,
    $8C61D79A,$7A0CA137,$8E14F859,$893C13EB,$EE27A9CE,$35C961B7,$EDE51CE1,$3CB1477A,
    $59DFD29C,$3F73F255,$79CE1418,$BF37C773,$EACDF753,$5BAAFD5F,$146F3DDF,$86DB4478,
    $81F3AFCA,$3EC468B9,$2C342438,$5F40A3C2,$72C31D16,$0C25E2BC,$8B493C28,$41950DFF,
    $7101A839,$DEB30C08,$9CE4B4D8,$90C15664,$6184CB7B,$70B632D5,$745C6C48,$4257B8D0),
   ($A7F45150,$65417E53,$A4171AC3,$5E273A96,$6BAB3BCB,$459D1FF1,$58FAACAB,$03E34B93,
    $FA302055,$6D76ADF6,$76CC8891,$4C02F525,$D7E54FFC,$CB2AC5D7,$44352680,$A362B58F,
    $5AB1DE49,$1BBA2567,$0EEA4598,$C0FE5DE1,$752FC302,$F04C8112,$97468DA3,$F9D36BC6,
    $5F8F03E7,$9C921595,$7A6DBFEB,$595295DA,$83BED42D,$217458D3,$69E04929,$C8C98E44,
    $89C2756A,$798EF478,$3E58996B,$71B927DD,$4FE1BEB6,$AD88F017,$AC20C966,$3ACE7DB4,
    $4ADF6318,$311AE582,$33519760,$7F536245,$7764B1E0,$AE6BBB84,$A081FE1C,$2B08F994,
    $68487058,$FD458F19,$6CDE9487,$F87B52B7,$D373AB23,$024B72E2,$8F1FE357,$AB55662A,
    $28EBB207,$C2B52F03,$7BC5869A,$0837D3A5,$872830F2,$A5BF23B2,$6A0302BA,$8216ED5C,
    $1CCF8A2B,$B479A792,$F207F3F0,$E2694EA1,$F4DA65CD,$BE0506D5,$6234D11F,$FEA6C48A,
    $532E349D,$55F3A2A0,$E18A0532,$EBF6A475,$EC830B39,$EF6040AA,$9F715E06,$106EBD51,
    $8A213EF9,$06DD963D,$053EDDAE,$BDE64D46,$8D5491B5,$5DC47105,$D406046F,$155060FF,
    $FB981924,$E9BDD697,$434089CC,$9ED96777,$42E8B0BD,$8B890788,$5B19E738,$EEC879DB,
    $0A7CA147,$0F427CE9,$1E84F8C9,$00000000,$86800983,$ED2B3248,$70111EAC,$725A6C4E,
    $FF0EFDFB,$38850F56,$D5AE3D1E,$392D3627,$D90F0A64,$A65C6821,$545B9BD1,$2E36243A,
    $670A0CB1,$E757930F,$96EEB4D2,$919B1B9E,$C5C0804F,$20DC61A2,$4B775A69,$1A121C16,
    $BA93E20A,$2AA0C0E5,$E0223C43,$171B121D,$0D090E0B,$C78BF2AD,$A8B62DB9,$A91E14C8,
    $19F15785,$0775AF4C,$DD99EEBB,$607FA3FD,$2601F79F,$F5725CBC,$3B6644C5,$7EFB5B34,
    $29438B76,$C623CBDC,$FCEDB668,$F1E4B863,$DC31D7CA,$85634210,$22971340,$11C68420,
    $244A857D,$3DBBD2F8,$32F9AE11,$A129C76D,$2F9E1D4B,$30B2DCF3,$52860DEC,$E3C177D0,
    $16B32B6C,$B970A999,$489411FA,$64E94722,$8CFCA8C4,$3FF0A01A,$2C7D56D8,$903322EF,
    $4E4987C7,$D138D9C1,$A2CA8CFE,$0BD49836,$81F5A6CF,$DE7AA528,$8EB7DA26,$BFAD3FA4,
    $9D3A2CE4,$9278500D,$CC5F6A9B,$467E5462,$138DF6C2,$B8D890E8,$F7392E5E,$AFC382F5,
    $805D9FBE,$93D0697C,$2DD56FA9,$1225CFB3,$99ACC83B,$7D1810A7,$639CE86E,$BB3BDB7B,
    $7826CD09,$18596EF4,$B79AEC01,$9A4F83A8,$6E95E665,$E6FFAA7E,$CFBC2108,$E815EFE6,
    $9BE7BAD9,$366F4ACE,$099FEAD4,$7CB029D6,$B2A431AF,$233F2A31,$94A5C630,$66A235C0,
    $BC4E7437,$CA82FCA6,$D090E0B0,$D8A73315,$9804F14A,$DAEC41F7,$50CD7F0E,$F691172F,
    $D64D768D,$B0EF434D,$4DAACC54,$0496E4DF,$B5D19EE3,$886A4C1B,$1F2CC1B8,$5165467F,
    $EA5E9D04,$358C015D,$7487FA73,$410BFB2E,$1D67B35A,$D2DB9252,$5610E933,$47D66D13,
    $61D79A8C,$0CA1377A,$14F8598E,$3C13EB89,$27A9CEEE,$C961B735,$E51CE1ED,$B1477A3C,
    $DFD29C59,$73F2553F,$CE141879,$37C773BF,$CDF753EA,$AAFD5F5B,$6F3DDF14,$DB447886,
    $F3AFCA81,$C468B93E,$3424382C,$40A3C25F,$C31D1672,$25E2BC0C,$493C288B,$950DFF41,
    $01A83971,$B30C08DE,$E4B4D89C,$C1566490,$84CB7B61,$B632D570,$5C6C4874,$57B8D042),
   ($F45150A7,$417E5365,$171AC3A4,$273A965E,$AB3BCB6B,$9D1FF145,$FAACAB58,$E34B9303,
    $302055FA,$76ADF66D,$CC889176,$02F5254C,$E54FFCD7,$2AC5D7CB,$35268044,$62B58FA3,
    $B1DE495A,$BA25671B,$EA45980E,$FE5DE1C0,$2FC30275,$4C8112F0,$468DA397,$D36BC6F9,
    $8F03E75F,$9215959C,$6DBFEB7A,$5295DA59,$BED42D83,$7458D321,$E0492969,$C98E44C8,
    $C2756A89,$8EF47879,$58996B3E,$B927DD71,$E1BEB64F,$88F017AD,$20C966AC,$CE7DB43A,
    $DF63184A,$1AE58231,$51976033,$5362457F,$64B1E077,$6BBB84AE,$81FE1CA0,$08F9942B,
    $48705868,$458F19FD,$DE94876C,$7B52B7F8,$73AB23D3,$4B72E202,$1FE3578F,$55662AAB,
    $EBB20728,$B52F03C2,$C5869A7B,$37D3A508,$2830F287,$BF23B2A5,$0302BA6A,$16ED5C82,
    $CF8A2B1C,$79A792B4,$07F3F0F2,$694EA1E2,$DA65CDF4,$0506D5BE,$34D11F62,$A6C48AFE,
    $2E349D53,$F3A2A055,$8A0532E1,$F6A475EB,$830B39EC,$6040AAEF,$715E069F,$6EBD5110,
    $213EF98A,$DD963D06,$3EDDAE05,$E64D46BD,$5491B58D,$C471055D,$06046FD4,$5060FF15,
    $981924FB,$BDD697E9,$4089CC43,$D967779E,$E8B0BD42,$8907888B,$19E7385B,$C879DBEE,
    $7CA1470A,$427CE90F,$84F8C91E,$00000000,$80098386,$2B3248ED,$111EAC70,$5A6C4E72,
    $0EFDFBFF,$850F5638,$AE3D1ED5,$2D362739,$0F0A64D9,$5C6821A6,$5B9BD154,$36243A2E,
    $0A0CB167,$57930FE7,$EEB4D296,$9B1B9E91,$C0804FC5,$DC61A220,$775A694B,$121C161A,
    $93E20ABA,$A0C0E52A,$223C43E0,$1B121D17,$090E0B0D,$8BF2ADC7,$B62DB9A8,$1E14C8A9,
    $F1578519,$75AF4C07,$99EEBBDD,$7FA3FD60,$01F79F26,$725CBCF5,$6644C53B,$FB5B347E,
    $438B7629,$23CBDCC6,$EDB668FC,$E4B863F1,$31D7CADC,$63421085,$97134022,$C6842011,
    $4A857D24,$BBD2F83D,$F9AE1132,$29C76DA1,$9E1D4B2F,$B2DCF330,$860DEC52,$C177D0E3,
    $B32B6C16,$70A999B9,$9411FA48,$E9472264,$FCA8C48C,$F0A01A3F,$7D56D82C,$3322EF90,
    $4987C74E,$38D9C1D1,$CA8CFEA2,$D498360B,$F5A6CF81,$7AA528DE,$B7DA268E,$AD3FA4BF,
    $3A2CE49D,$78500D92,$5F6A9BCC,$7E546246,$8DF6C213,$D890E8B8,$392E5EF7,$C382F5AF,
    $5D9FBE80,$D0697C93,$D56FA92D,$25CFB312,$ACC83B99,$1810A77D,$9CE86E63,$3BDB7BBB,
    $26CD0978,$596EF418,$9AEC01B7,$4F83A89A,$95E6656E,$FFAA7EE6,$BC2108CF,$15EFE6E8,
    $E7BAD99B,$6F4ACE36,$9FEAD409,$B029D67C,$A431AFB2,$3F2A3123,$A5C63094,$A235C066,
    $4E7437BC,$82FCA6CA,$90E0B0D0,$A73315D8,$04F14A98,$EC41F7DA,$CD7F0E50,$91172FF6,
    $4D768DD6,$EF434DB0,$AACC544D,$96E4DF04,$D19EE3B5,$6A4C1B88,$2CC1B81F,$65467F51,
    $5E9D04EA,$8C015D35,$87FA7374,$0BFB2E41,$67B35A1D,$DB9252D2,$10E93356,$D66D1347,
    $D79A8C61,$A1377A0C,$F8598E14,$13EB893C,$A9CEEE27,$61B735C9,$1CE1EDE5,$477A3CB1,
    $D29C59DF,$F2553F73,$141879CE,$C773BF37,$F753EACD,$FD5F5BAA,$3DDF146F,$447886DB,
    $AFCA81F3,$68B93EC4,$24382C34,$A3C25F40,$1D1672C3,$E2BC0C25,$3C288B49,$0DFF4195,
    $A8397101,$0C08DEB3,$B4D89CE4,$566490C1,$CB7B6184,$32D570B6,$6C48745C,$B8D04257),
   ($5150A7F4,$7E536541,$1AC3A417,$3A965E27,$3BCB6BAB,$1FF1459D,$ACAB58FA,$4B9303E3,
    $2055FA30,$ADF66D76,$889176CC,$F5254C02,$4FFCD7E5,$C5D7CB2A,$26804435,$B58FA362,
    $DE495AB1,$25671BBA,$45980EEA,$5DE1C0FE,$C302752F,$8112F04C,$8DA39746,$6BC6F9D3,
    $03E75F8F,$15959C92,$BFEB7A6D,$95DA5952,$D42D83BE,$58D32174,$492969E0,$8E44C8C9,
    $756A89C2,$F478798E,$996B3E58,$27DD71B9,$BEB64FE1,$F017AD88,$C966AC20,$7DB43ACE,
    $63184ADF,$E582311A,$97603351,$62457F53,$B1E07764,$BB84AE6B,$FE1CA081,$F9942B08,
    $70586848,$8F19FD45,$94876CDE,$52B7F87B,$AB23D373,$72E2024B,$E3578F1F,$662AAB55,
    $B20728EB,$2F03C2B5,$869A7BC5,$D3A50837,$30F28728,$23B2A5BF,$02BA6A03,$ED5C8216,
    $8A2B1CCF,$A792B479,$F3F0F207,$4EA1E269,$65CDF4DA,$06D5BE05,$D11F6234,$C48AFEA6,
    $349D532E,$A2A055F3,$0532E18A,$A475EBF6,$0B39EC83,$40AAEF60,$5E069F71,$BD51106E,
    $3EF98A21,$963D06DD,$DDAE053E,$4D46BDE6,$91B58D54,$71055DC4,$046FD406,$60FF1550,
    $1924FB98,$D697E9BD,$89CC4340,$67779ED9,$B0BD42E8,$07888B89,$E7385B19,$79DBEEC8,
    $A1470A7C,$7CE90F42,$F8C91E84,$00000000,$09838680,$3248ED2B,$1EAC7011,$6C4E725A,
    $FDFBFF0E,$0F563885,$3D1ED5AE,$3627392D,$0A64D90F,$6821A65C,$9BD1545B,$243A2E36,
    $0CB1670A,$930FE757,$B4D296EE,$1B9E919B,$804FC5C0,$61A220DC,$5A694B77,$1C161A12,
    $E20ABA93,$C0E52AA0,$3C43E022,$121D171B,$0E0B0D09,$F2ADC78B,$2DB9A8B6,$14C8A91E,
    $578519F1,$AF4C0775,$EEBBDD99,$A3FD607F,$F79F2601,$5CBCF572,$44C53B66,$5B347EFB,
    $8B762943,$CBDCC623,$B668FCED,$B863F1E4,$D7CADC31,$42108563,$13402297,$842011C6,
    $857D244A,$D2F83DBB,$AE1132F9,$C76DA129,$1D4B2F9E,$DCF330B2,$0DEC5286,$77D0E3C1,
    $2B6C16B3,$A999B970,$11FA4894,$472264E9,$A8C48CFC,$A01A3FF0,$56D82C7D,$22EF9033,
    $87C74E49,$D9C1D138,$8CFEA2CA,$98360BD4,$A6CF81F5,$A528DE7A,$DA268EB7,$3FA4BFAD,
    $2CE49D3A,$500D9278,$6A9BCC5F,$5462467E,$F6C2138D,$90E8B8D8,$2E5EF739,$82F5AFC3,
    $9FBE805D,$697C93D0,$6FA92DD5,$CFB31225,$C83B99AC,$10A77D18,$E86E639C,$DB7BBB3B,
    $CD097826,$6EF41859,$EC01B79A,$83A89A4F,$E6656E95,$AA7EE6FF,$2108CFBC,$EFE6E815,
    $BAD99BE7,$4ACE366F,$EAD4099F,$29D67CB0,$31AFB2A4,$2A31233F,$C63094A5,$35C066A2,
    $7437BC4E,$FCA6CA82,$E0B0D090,$3315D8A7,$F14A9804,$41F7DAEC,$7F0E50CD,$172FF691,
    $768DD64D,$434DB0EF,$CC544DAA,$E4DF0496,$9EE3B5D1,$4C1B886A,$C1B81F2C,$467F5165,
    $9D04EA5E,$015D358C,$FA737487,$FB2E410B,$B35A1D67,$9252D2DB,$E9335610,$6D1347D6,
    $9A8C61D7,$377A0CA1,$598E14F8,$EB893C13,$CEEE27A9,$B735C961,$E1EDE51C,$7A3CB147,
    $9C59DFD2,$553F73F2,$1879CE14,$73BF37C7,$53EACDF7,$5F5BAAFD,$DF146F3D,$7886DB44,
    $CA81F3AF,$B93EC468,$382C3424,$C25F40A3,$1672C31D,$BC0C25E2,$288B493C,$FF41950D,
    $397101A8,$08DEB30C,$D89CE4B4,$6490C156,$7B6184CB,$D570B632,$48745C6C,$D04257B8));
{
  Rijndael_Key: array[0..255] of LongWord = (
    $00000000,$0B0D090E,$161A121C,$1D171B12,$2C342438,$27392D36,$3A2E3624,$31233F2A,
    $58684870,$5365417E,$4E725A6C,$457F5362,$745C6C48,$7F516546,$62467E54,$694B775A,
    $B0D090E0,$BBDD99EE,$A6CA82FC,$ADC78BF2,$9CE4B4D8,$97E9BDD6,$8AFEA6C4,$81F3AFCA,
    $E8B8D890,$E3B5D19E,$FEA2CA8C,$F5AFC382,$C48CFCA8,$CF81F5A6,$D296EEB4,$D99BE7BA,
    $7BBB3BDB,$70B632D5,$6DA129C7,$66AC20C9,$578F1FE3,$5C8216ED,$41950DFF,$4A9804F1,
    $23D373AB,$28DE7AA5,$35C961B7,$3EC468B9,$0FE75793,$04EA5E9D,$19FD458F,$12F04C81,
    $CB6BAB3B,$C066A235,$DD71B927,$D67CB029,$E75F8F03,$EC52860D,$F1459D1F,$FA489411,
    $9303E34B,$980EEA45,$8519F157,$8E14F859,$BF37C773,$B43ACE7D,$A92DD56F,$A220DC61,
    $F66D76AD,$FD607FA3,$E07764B1,$EB7A6DBF,$DA595295,$D1545B9B,$CC434089,$C74E4987,
    $AE053EDD,$A50837D3,$B81F2CC1,$B31225CF,$82311AE5,$893C13EB,$942B08F9,$9F2601F7,
    $46BDE64D,$4DB0EF43,$50A7F451,$5BAAFD5F,$6A89C275,$6184CB7B,$7C93D069,$779ED967,
    $1ED5AE3D,$15D8A733,$08CFBC21,$03C2B52F,$32E18A05,$39EC830B,$24FB9819,$2FF69117,
    $8DD64D76,$86DB4478,$9BCC5F6A,$90C15664,$A1E2694E,$AAEF6040,$B7F87B52,$BCF5725C,
    $D5BE0506,$DEB30C08,$C3A4171A,$C8A91E14,$F98A213E,$F2872830,$EF903322,$E49D3A2C,
    $3D06DD96,$360BD498,$2B1CCF8A,$2011C684,$1132F9AE,$1A3FF0A0,$0728EBB2,$0C25E2BC,
    $656E95E6,$6E639CE8,$737487FA,$78798EF4,$495AB1DE,$4257B8D0,$5F40A3C2,$544DAACC,
    $F7DAEC41,$FCD7E54F,$E1C0FE5D,$EACDF753,$DBEEC879,$D0E3C177,$CDF4DA65,$C6F9D36B,
    $AFB2A431,$A4BFAD3F,$B9A8B62D,$B2A5BF23,$83868009,$888B8907,$959C9215,$9E919B1B,
    $470A7CA1,$4C0775AF,$51106EBD,$5A1D67B3,$6B3E5899,$60335197,$7D244A85,$7629438B,
    $1F6234D1,$146F3DDF,$097826CD,$02752FC3,$335610E9,$385B19E7,$254C02F5,$2E410BFB,
    $8C61D79A,$876CDE94,$9A7BC586,$9176CC88,$A055F3A2,$AB58FAAC,$B64FE1BE,$BD42E8B0,
    $D4099FEA,$DF0496E4,$C2138DF6,$C91E84F8,$F83DBBD2,$F330B2DC,$EE27A9CE,$E52AA0C0,
    $3CB1477A,$37BC4E74,$2AAB5566,$21A65C68,$10856342,$1B886A4C,$069F715E,$0D927850,
    $64D90F0A,$6FD40604,$72C31D16,$79CE1418,$48ED2B32,$43E0223C,$5EF7392E,$55FA3020,
    $01B79AEC,$0ABA93E2,$17AD88F0,$1CA081FE,$2D83BED4,$268EB7DA,$3B99ACC8,$3094A5C6,
    $59DFD29C,$52D2DB92,$4FC5C080,$44C8C98E,$75EBF6A4,$7EE6FFAA,$63F1E4B8,$68FCEDB6,
    $B1670A0C,$BA6A0302,$A77D1810,$AC70111E,$9D532E34,$965E273A,$8B493C28,$80443526,
    $E90F427C,$E2024B72,$FF155060,$F418596E,$C53B6644,$CE366F4A,$D3217458,$D82C7D56,
    $7A0CA137,$7101A839,$6C16B32B,$671BBA25,$5638850F,$5D358C01,$40229713,$4B2F9E1D,
    $2264E947,$2969E049,$347EFB5B,$3F73F255,$0E50CD7F,$055DC471,$184ADF63,$1347D66D,
    $CADC31D7,$C1D138D9,$DCC623CB,$D7CB2AC5,$E6E815EF,$EDE51CE1,$F0F207F3,$FBFF0EFD,
    $92B479A7,$99B970A9,$84AE6BBB,$8FA362B5,$BE805D9F,$B58D5491,$A89A4F83,$A397468D);
}

  Twofish_8x8: array[0..1, 0..255] of Byte = (
   ($A9,$67,$B3,$E8,$04,$FD,$A3,$76,$9A,$92,$80,$78,$E4,$DD,$D1,$38,
    $0D,$C6,$35,$98,$18,$F7,$EC,$6C,$43,$75,$37,$26,$FA,$13,$94,$48,
    $F2,$D0,$8B,$30,$84,$54,$DF,$23,$19,$5B,$3D,$59,$F3,$AE,$A2,$82,
    $63,$01,$83,$2E,$D9,$51,$9B,$7C,$A6,$EB,$A5,$BE,$16,$0C,$E3,$61,
    $C0,$8C,$3A,$F5,$73,$2C,$25,$0B,$BB,$4E,$89,$6B,$53,$6A,$B4,$F1,
    $E1,$E6,$BD,$45,$E2,$F4,$B6,$66,$CC,$95,$03,$56,$D4,$1C,$1E,$D7,
    $FB,$C3,$8E,$B5,$E9,$CF,$BF,$BA,$EA,$77,$39,$AF,$33,$C9,$62,$71,
    $81,$79,$09,$AD,$24,$CD,$F9,$D8,$E5,$C5,$B9,$4D,$44,$08,$86,$E7,
    $A1,$1D,$AA,$ED,$06,$70,$B2,$D2,$41,$7B,$A0,$11,$31,$C2,$27,$90,
    $20,$F6,$60,$FF,$96,$5C,$B1,$AB,$9E,$9C,$52,$1B,$5F,$93,$0A,$EF,
    $91,$85,$49,$EE,$2D,$4F,$8F,$3B,$47,$87,$6D,$46,$D6,$3E,$69,$64,
    $2A,$CE,$CB,$2F,$FC,$97,$05,$7A,$AC,$7F,$D5,$1A,$4B,$0E,$A7,$5A,
    $28,$14,$3F,$29,$88,$3C,$4C,$02,$B8,$DA,$B0,$17,$55,$1F,$8A,$7D,
    $57,$C7,$8D,$74,$B7,$C4,$9F,$72,$7E,$15,$22,$12,$58,$07,$99,$34,
    $6E,$50,$DE,$68,$65,$BC,$DB,$F8,$C8,$A8,$2B,$40,$DC,$FE,$32,$A4,
    $CA,$10,$21,$F0,$D3,$5D,$0F,$00,$6F,$9D,$36,$42,$4A,$5E,$C1,$E0),
   ($75,$F3,$C6,$F4,$DB,$7B,$FB,$C8,$4A,$D3,$E6,$6B,$45,$7D,$E8,$4B,
    $D6,$32,$D8,$FD,$37,$71,$F1,$E1,$30,$0F,$F8,$1B,$87,$FA,$06,$3F,
    $5E,$BA,$AE,$5B,$8A,$00,$BC,$9D,$6D,$C1,$B1,$0E,$80,$5D,$D2,$D5,
    $A0,$84,$07,$14,$B5,$90,$2C,$A3,$B2,$73,$4C,$54,$92,$74,$36,$51,
    $38,$B0,$BD,$5A,$FC,$60,$62,$96,$6C,$42,$F7,$10,$7C,$28,$27,$8C,
    $13,$95,$9C,$C7,$24,$46,$3B,$70,$CA,$E3,$85,$CB,$11,$D0,$93,$B8,
    $A6,$83,$20,$FF,$9F,$77,$C3,$CC,$03,$6F,$08,$BF,$40,$E7,$2B,$E2,
    $79,$0C,$AA,$82,$41,$3A,$EA,$B9,$E4,$9A,$A4,$97,$7E,$DA,$7A,$17,
    $66,$94,$A1,$1D,$3D,$F0,$DE,$B3,$0B,$72,$A7,$1C,$EF,$D1,$53,$3E,
    $8F,$33,$26,$5F,$EC,$76,$2A,$49,$81,$88,$EE,$21,$C4,$1A,$EB,$D9,
    $C5,$39,$99,$CD,$AD,$31,$8B,$01,$18,$23,$DD,$1F,$4E,$2D,$F9,$48,
    $4F,$F2,$65,$8E,$78,$5C,$58,$19,$8D,$E5,$98,$57,$67,$7F,$05,$64,
    $AF,$63,$B6,$FE,$F5,$B7,$3C,$A5,$CE,$E9,$68,$44,$E0,$4D,$43,$69,
    $29,$2E,$AC,$15,$59,$A8,$0A,$9E,$6E,$47,$DF,$34,$35,$6A,$CF,$DC,
    $22,$C9,$C0,$9B,$89,$D4,$ED,$AB,$12,$A2,$0D,$52,$BB,$02,$2F,$A9,
    $D7,$61,$1E,$B4,$50,$04,$F6,$C2,$16,$25,$86,$56,$55,$09,$BE,$91));

  Twofish_Data: array[0..3, 0..255] of LongWord = (
  ($BCBC3275,$ECEC21F3,$202043C6,$B3B3C9F4,$DADA03DB,$02028B7B,$E2E22BFB,$9E9EFAC8,
   $C9C9EC4A,$D4D409D3,$18186BE6,$1E1E9F6B,$98980E45,$B2B2387D,$A6A6D2E8,$2626B74B,
   $3C3C57D6,$93938A32,$8282EED8,$525298FD,$7B7BD437,$BBBB3771,$5B5B97F1,$474783E1,
   $24243C30,$5151E20F,$BABAC6F8,$4A4AF31B,$BFBF4887,$0D0D70FA,$B0B0B306,$7575DE3F,
   $D2D2FD5E,$7D7D20BA,$666631AE,$3A3AA35B,$59591C8A,$00000000,$CDCD93BC,$1A1AE09D,
   $AEAE2C6D,$7F7FABC1,$2B2BC7B1,$BEBEB90E,$E0E0A080,$8A8A105D,$3B3B52D2,$6464BAD5,
   $D8D888A0,$E7E7A584,$5F5FE807,$1B1B1114,$2C2CC2B5,$FCFCB490,$3131272C,$808065A3,
   $73732AB2,$0C0C8173,$79795F4C,$6B6B4154,$4B4B0292,$53536974,$94948F36,$83831F51,
   $2A2A3638,$C4C49CB0,$2222C8BD,$D5D5F85A,$BDBDC3FC,$48487860,$FFFFCE62,$4C4C0796,
   $4141776C,$C7C7E642,$EBEB24F7,$1C1C1410,$5D5D637C,$36362228,$6767C027,$E9E9AF8C,
   $4444F913,$1414EA95,$F5F5BB9C,$CFCF18C7,$3F3F2D24,$C0C0E346,$7272DB3B,$54546C70,
   $29294CCA,$F0F035E3,$0808FE85,$C6C617CB,$F3F34F11,$8C8CE4D0,$A4A45993,$CACA96B8,
   $68683BA6,$B8B84D83,$38382820,$E5E52EFF,$ADAD569F,$0B0B8477,$C8C81DC3,$9999FFCC,
   $5858ED03,$19199A6F,$0E0E0A08,$95957EBF,$70705040,$F7F730E7,$6E6ECF2B,$1F1F6EE2,
   $B5B53D79,$09090F0C,$616134AA,$57571682,$9F9F0B41,$9D9D803A,$111164EA,$2525CDB9,
   $AFAFDDE4,$4545089A,$DFDF8DA4,$A3A35C97,$EAEAD57E,$353558DA,$EDEDD07A,$4343FC17,
   $F8F8CB66,$FBFBB194,$3737D3A1,$FAFA401D,$C2C2683D,$B4B4CCF0,$32325DDE,$9C9C71B3,
   $5656E70B,$E3E3DA72,$878760A7,$15151B1C,$F9F93AEF,$6363BFD1,$3434A953,$9A9A853E,
   $B1B1428F,$7C7CD133,$88889B26,$3D3DA65F,$A1A1D7EC,$E4E4DF76,$8181942A,$91910149,
   $0F0FFB81,$EEEEAA88,$161661EE,$D7D77321,$9797F5C4,$A5A5A81A,$FEFE3FEB,$6D6DB5D9,
   $7878AEC5,$C5C56D39,$1D1DE599,$7676A4CD,$3E3EDCAD,$CBCB6731,$B6B6478B,$EFEF5B01,
   $12121E18,$6060C523,$6A6AB0DD,$4D4DF61F,$CECEE94E,$DEDE7C2D,$55559DF9,$7E7E5A48,
   $2121B24F,$03037AF2,$A0A02665,$5E5E198E,$5A5A6678,$65654B5C,$62624E58,$FDFD4519,
   $0606F48D,$404086E5,$F2F2BE98,$3333AC57,$17179067,$05058E7F,$E8E85E05,$4F4F7D64,
   $89896AAF,$10109563,$74742FB6,$0A0A75FE,$5C5C92F5,$9B9B74B7,$2D2D333C,$3030D6A5,
   $2E2E49CE,$494989E9,$46467268,$77775544,$A8A8D8E0,$9696044D,$2828BD43,$A9A92969,
   $D9D97929,$8686912E,$D1D187AC,$F4F44A15,$8D8D1559,$D6D682A8,$B9B9BC0A,$42420D9E,
   $F6F6C16E,$2F2FB847,$DDDD06DF,$23233934,$CCCC6235,$F1F1C46A,$C1C112CF,$8585EBDC,
   $8F8F9E22,$7171A1C9,$9090F0C0,$AAAA539B,$0101F189,$8B8BE1D4,$4E4E8CED,$8E8E6FAB,
   $ABABA212,$6F6F3EA2,$E6E6540D,$DBDBF252,$92927BBB,$B7B7B602,$6969CA2F,$3939D9A9,
   $D3D30CD7,$A7A72361,$A2A2AD1E,$C3C399B4,$6C6C4450,$07070504,$04047FF6,$272746C2,
   $ACACA716,$D0D07625,$50501386,$DCDCF756,$84841A55,$E1E15109,$7A7A25BE,$1313EF91),
  ($A9D93939,$67901717,$B3719C9C,$E8D2A6A6,$04050707,$FD985252,$A3658080,$76DFE4E4,
   $9A084545,$92024B4B,$80A0E0E0,$78665A5A,$E4DDAFAF,$DDB06A6A,$D1BF6363,$38362A2A,
   $0D54E6E6,$C6432020,$3562CCCC,$98BEF2F2,$181E1212,$F724EBEB,$ECD7A1A1,$6C774141,
   $43BD2828,$7532BCBC,$37D47B7B,$269B8888,$FA700D0D,$13F94444,$94B1FBFB,$485A7E7E,
   $F27A0303,$D0E48C8C,$8B47B6B6,$303C2424,$84A5E7E7,$54416B6B,$DF06DDDD,$23C56060,
   $1945FDFD,$5BA33A3A,$3D68C2C2,$59158D8D,$F321ECEC,$AE316666,$A23E6F6F,$82165757,
   $63951010,$015BEFEF,$834DB8B8,$2E918686,$D9B56D6D,$511F8383,$9B53AAAA,$7C635D5D,
   $A63B6868,$EB3FFEFE,$A5D63030,$BE257A7A,$16A7ACAC,$0C0F0909,$E335F0F0,$6123A7A7,
   $C0F09090,$8CAFE9E9,$3A809D9D,$F5925C5C,$73810C0C,$2C273131,$2576D0D0,$0BE75656,
   $BB7B9292,$4EE9CECE,$89F10101,$6B9F1E1E,$53A93434,$6AC4F1F1,$B499C3C3,$F1975B5B,
   $E1834747,$E66B1818,$BDC82222,$450E9898,$E26E1F1F,$F4C9B3B3,$B62F7474,$66CBF8F8,
   $CCFF9999,$95EA1414,$03ED5858,$56F7DCDC,$D4E18B8B,$1C1B1515,$1EADA2A2,$D70CD3D3,
   $FB2BE2E2,$C31DC8C8,$8E195E5E,$B5C22C2C,$E9894949,$CF12C1C1,$BF7E9595,$BA207D7D,
   $EA641111,$77840B0B,$396DC5C5,$AF6A8989,$33D17C7C,$C9A17171,$62CEFFFF,$7137BBBB,
   $81FB0F0F,$793DB5B5,$0951E1E1,$ADDC3E3E,$242D3F3F,$CDA47676,$F99D5555,$D8EE8282,
   $E5864040,$C5AE7878,$B9CD2525,$4D049696,$44557777,$080A0E0E,$86135050,$E730F7F7,
   $A1D33737,$1D40FAFA,$AA346161,$ED8C4E4E,$06B3B0B0,$706C5454,$B22A7373,$D2523B3B,
   $410B9F9F,$7B8B0202,$A088D8D8,$114FF3F3,$3167CBCB,$C2462727,$27C06767,$90B4FCFC,
   $20283838,$F67F0404,$60784848,$FF2EE5E5,$96074C4C,$5C4B6565,$B1C72B2B,$AB6F8E8E,
   $9E0D4242,$9CBBF5F5,$52F2DBDB,$1BF34A4A,$5FA63D3D,$9359A4A4,$0ABCB9B9,$EF3AF9F9,
   $91EF1313,$85FE0808,$49019191,$EE611616,$2D7CDEDE,$4FB22121,$8F42B1B1,$3BDB7272,
   $47B82F2F,$8748BFBF,$6D2CAEAE,$46E3C0C0,$D6573C3C,$3E859A9A,$6929A9A9,$647D4F4F,
   $2A948181,$CE492E2E,$CB17C6C6,$2FCA6969,$FCC3BDBD,$975CA3A3,$055EE8E8,$7AD0EDED,
   $AC87D1D1,$7F8E0505,$D5BA6464,$1AA8A5A5,$4BB72626,$0EB9BEBE,$A7608787,$5AF8D5D5,
   $28223636,$14111B1B,$3FDE7575,$2979D9D9,$88AAEEEE,$3C332D2D,$4C5F7979,$02B6B7B7,
   $B896CACA,$DA583535,$B09CC4C4,$17FC4343,$551A8484,$1FF64D4D,$8A1C5959,$7D38B2B2,
   $57AC3333,$C718CFCF,$8DF40606,$74695353,$B7749B9B,$C4F59797,$9F56ADAD,$72DAE3E3,
   $7ED5EAEA,$154AF4F4,$229E8F8F,$12A2ABAB,$584E6262,$07E85F5F,$99E51D1D,$34392323,
   $6EC1F6F6,$50446C6C,$DE5D3232,$68724646,$6526A0A0,$BC93CDCD,$DB03DADA,$F8C6BABA,
   $C8FA9E9E,$A882D6D6,$2BCF6E6E,$40507070,$DCEB8585,$FE750A0A,$328A9393,$A48DDFDF,
   $CA4C2929,$10141C1C,$2173D7D7,$F0CCB4B4,$D309D4D4,$5D108A8A,$0FE25151,$00000000,
   $6F9A1919,$9DE01A1A,$368F9494,$42E6C7C7,$4AECC9C9,$5EFDD2D2,$C1AB7F7F,$E0D8A8A8),
  ($BC75BC32,$ECF3EC21,$20C62043,$B3F4B3C9,$DADBDA03,$027B028B,$E2FBE22B,$9EC89EFA,
   $C94AC9EC,$D4D3D409,$18E6186B,$1E6B1E9F,$9845980E,$B27DB238,$A6E8A6D2,$264B26B7,
   $3CD63C57,$9332938A,$82D882EE,$52FD5298,$7B377BD4,$BB71BB37,$5BF15B97,$47E14783,
   $2430243C,$510F51E2,$BAF8BAC6,$4A1B4AF3,$BF87BF48,$0DFA0D70,$B006B0B3,$753F75DE,
   $D25ED2FD,$7DBA7D20,$66AE6631,$3A5B3AA3,$598A591C,$00000000,$CDBCCD93,$1A9D1AE0,
   $AE6DAE2C,$7FC17FAB,$2BB12BC7,$BE0EBEB9,$E080E0A0,$8A5D8A10,$3BD23B52,$64D564BA,
   $D8A0D888,$E784E7A5,$5F075FE8,$1B141B11,$2CB52CC2,$FC90FCB4,$312C3127,$80A38065,
   $73B2732A,$0C730C81,$794C795F,$6B546B41,$4B924B02,$53745369,$9436948F,$8351831F,
   $2A382A36,$C4B0C49C,$22BD22C8,$D55AD5F8,$BDFCBDC3,$48604878,$FF62FFCE,$4C964C07,
   $416C4177,$C742C7E6,$EBF7EB24,$1C101C14,$5D7C5D63,$36283622,$672767C0,$E98CE9AF,
   $441344F9,$149514EA,$F59CF5BB,$CFC7CF18,$3F243F2D,$C046C0E3,$723B72DB,$5470546C,
   $29CA294C,$F0E3F035,$088508FE,$C6CBC617,$F311F34F,$8CD08CE4,$A493A459,$CAB8CA96,
   $68A6683B,$B883B84D,$38203828,$E5FFE52E,$AD9FAD56,$0B770B84,$C8C3C81D,$99CC99FF,
   $580358ED,$196F199A,$0E080E0A,$95BF957E,$70407050,$F7E7F730,$6E2B6ECF,$1FE21F6E,
   $B579B53D,$090C090F,$61AA6134,$57825716,$9F419F0B,$9D3A9D80,$11EA1164,$25B925CD,
   $AFE4AFDD,$459A4508,$DFA4DF8D,$A397A35C,$EA7EEAD5,$35DA3558,$ED7AEDD0,$431743FC,
   $F866F8CB,$FB94FBB1,$37A137D3,$FA1DFA40,$C23DC268,$B4F0B4CC,$32DE325D,$9CB39C71,
   $560B56E7,$E372E3DA,$87A78760,$151C151B,$F9EFF93A,$63D163BF,$345334A9,$9A3E9A85,
   $B18FB142,$7C337CD1,$8826889B,$3D5F3DA6,$A1ECA1D7,$E476E4DF,$812A8194,$91499101,
   $0F810FFB,$EE88EEAA,$16EE1661,$D721D773,$97C497F5,$A51AA5A8,$FEEBFE3F,$6DD96DB5,
   $78C578AE,$C539C56D,$1D991DE5,$76CD76A4,$3EAD3EDC,$CB31CB67,$B68BB647,$EF01EF5B,
   $1218121E,$602360C5,$6ADD6AB0,$4D1F4DF6,$CE4ECEE9,$DE2DDE7C,$55F9559D,$7E487E5A,
   $214F21B2,$03F2037A,$A065A026,$5E8E5E19,$5A785A66,$655C654B,$6258624E,$FD19FD45,
   $068D06F4,$40E54086,$F298F2BE,$335733AC,$17671790,$057F058E,$E805E85E,$4F644F7D,
   $89AF896A,$10631095,$74B6742F,$0AFE0A75,$5CF55C92,$9BB79B74,$2D3C2D33,$30A530D6,
   $2ECE2E49,$49E94989,$46684672,$77447755,$A8E0A8D8,$964D9604,$284328BD,$A969A929,
   $D929D979,$862E8691,$D1ACD187,$F415F44A,$8D598D15,$D6A8D682,$B90AB9BC,$429E420D,
   $F66EF6C1,$2F472FB8,$DDDFDD06,$23342339,$CC35CC62,$F16AF1C4,$C1CFC112,$85DC85EB,
   $8F228F9E,$71C971A1,$90C090F0,$AA9BAA53,$018901F1,$8BD48BE1,$4EED4E8C,$8EAB8E6F,
   $AB12ABA2,$6FA26F3E,$E60DE654,$DB52DBF2,$92BB927B,$B702B7B6,$692F69CA,$39A939D9,
   $D3D7D30C,$A761A723,$A21EA2AD,$C3B4C399,$6C506C44,$07040705,$04F6047F,$27C22746,
   $AC16ACA7,$D025D076,$50865013,$DC56DCF7,$8455841A,$E109E151,$7ABE7A25,$139113EF),
  ($D939A9D9,$90176790,$719CB371,$D2A6E8D2,$05070405,$9852FD98,$6580A365,$DFE476DF,
   $08459A08,$024B9202,$A0E080A0,$665A7866,$DDAFE4DD,$B06ADDB0,$BF63D1BF,$362A3836,
   $54E60D54,$4320C643,$62CC3562,$BEF298BE,$1E12181E,$24EBF724,$D7A1ECD7,$77416C77,
   $BD2843BD,$32BC7532,$D47B37D4,$9B88269B,$700DFA70,$F94413F9,$B1FB94B1,$5A7E485A,
   $7A03F27A,$E48CD0E4,$47B68B47,$3C24303C,$A5E784A5,$416B5441,$06DDDF06,$C56023C5,
   $45FD1945,$A33A5BA3,$68C23D68,$158D5915,$21ECF321,$3166AE31,$3E6FA23E,$16578216,
   $95106395,$5BEF015B,$4DB8834D,$91862E91,$B56DD9B5,$1F83511F,$53AA9B53,$635D7C63,
   $3B68A63B,$3FFEEB3F,$D630A5D6,$257ABE25,$A7AC16A7,$0F090C0F,$35F0E335,$23A76123,
   $F090C0F0,$AFE98CAF,$809D3A80,$925CF592,$810C7381,$27312C27,$76D02576,$E7560BE7,
   $7B92BB7B,$E9CE4EE9,$F10189F1,$9F1E6B9F,$A93453A9,$C4F16AC4,$99C3B499,$975BF197,
   $8347E183,$6B18E66B,$C822BDC8,$0E98450E,$6E1FE26E,$C9B3F4C9,$2F74B62F,$CBF866CB,
   $FF99CCFF,$EA1495EA,$ED5803ED,$F7DC56F7,$E18BD4E1,$1B151C1B,$ADA21EAD,$0CD3D70C,
   $2BE2FB2B,$1DC8C31D,$195E8E19,$C22CB5C2,$8949E989,$12C1CF12,$7E95BF7E,$207DBA20,
   $6411EA64,$840B7784,$6DC5396D,$6A89AF6A,$D17C33D1,$A171C9A1,$CEFF62CE,$37BB7137,
   $FB0F81FB,$3DB5793D,$51E10951,$DC3EADDC,$2D3F242D,$A476CDA4,$9D55F99D,$EE82D8EE,
   $8640E586,$AE78C5AE,$CD25B9CD,$04964D04,$55774455,$0A0E080A,$13508613,$30F7E730,
   $D337A1D3,$40FA1D40,$3461AA34,$8C4EED8C,$B3B006B3,$6C54706C,$2A73B22A,$523BD252,
   $0B9F410B,$8B027B8B,$88D8A088,$4FF3114F,$67CB3167,$4627C246,$C06727C0,$B4FC90B4,
   $28382028,$7F04F67F,$78486078,$2EE5FF2E,$074C9607,$4B655C4B,$C72BB1C7,$6F8EAB6F,
   $0D429E0D,$BBF59CBB,$F2DB52F2,$F34A1BF3,$A63D5FA6,$59A49359,$BCB90ABC,$3AF9EF3A,
   $EF1391EF,$FE0885FE,$01914901,$6116EE61,$7CDE2D7C,$B2214FB2,$42B18F42,$DB723BDB,
   $B82F47B8,$48BF8748,$2CAE6D2C,$E3C046E3,$573CD657,$859A3E85,$29A96929,$7D4F647D,
   $94812A94,$492ECE49,$17C6CB17,$CA692FCA,$C3BDFCC3,$5CA3975C,$5EE8055E,$D0ED7AD0,
   $87D1AC87,$8E057F8E,$BA64D5BA,$A8A51AA8,$B7264BB7,$B9BE0EB9,$6087A760,$F8D55AF8,
   $22362822,$111B1411,$DE753FDE,$79D92979,$AAEE88AA,$332D3C33,$5F794C5F,$B6B702B6,
   $96CAB896,$5835DA58,$9CC4B09C,$FC4317FC,$1A84551A,$F64D1FF6,$1C598A1C,$38B27D38,
   $AC3357AC,$18CFC718,$F4068DF4,$69537469,$749BB774,$F597C4F5,$56AD9F56,$DAE372DA,
   $D5EA7ED5,$4AF4154A,$9E8F229E,$A2AB12A2,$4E62584E,$E85F07E8,$E51D99E5,$39233439,
   $C1F66EC1,$446C5044,$5D32DE5D,$72466872,$26A06526,$93CDBC93,$03DADB03,$C6BAF8C6,
   $FA9EC8FA,$82D6A882,$CF6E2BCF,$50704050,$EB85DCEB,$750AFE75,$8A93328A,$8DDFA48D,
   $4C29CA4C,$141C1014,$73D72173,$CCB4F0CC,$09D4D309,$108A5D10,$E2510FE2,$00000000,
   $9A196F9A,$E01A9DE0,$8F94368F,$E6C742E6,$ECC94AEC,$FDD25EFD,$AB7FC1AB,$D8A8E0D8));

  Cast128_Data: array[0..3, 0..255] of LongWord = (
   ($30FB40D4,$9FA0FF0B,$6BECCD2F,$3F258C7A,$1E213F2F,$9C004DD3,$6003E540,$CF9FC949,
    $BFD4AF27,$88BBBDB5,$E2034090,$98D09675,$6E63A0E0,$15C361D2,$C2E7661D,$22D4FF8E,
    $28683B6F,$C07FD059,$FF2379C8,$775F50E2,$43C340D3,$DF2F8656,$887CA41A,$A2D2BD2D,
    $A1C9E0D6,$346C4819,$61B76D87,$22540F2F,$2ABE32E1,$AA54166B,$22568E3A,$A2D341D0,
    $66DB40C8,$A784392F,$004DFF2F,$2DB9D2DE,$97943FAC,$4A97C1D8,$527644B7,$B5F437A7,
    $B82CBAEF,$D751D159,$6FF7F0ED,$5A097A1F,$827B68D0,$90ECF52E,$22B0C054,$BC8E5935,
    $4B6D2F7F,$50BB64A2,$D2664910,$BEE5812D,$B7332290,$E93B159F,$B48EE411,$4BFF345D,
    $FD45C240,$AD31973F,$C4F6D02E,$55FC8165,$D5B1CAAD,$A1AC2DAE,$A2D4B76D,$C19B0C50,
    $882240F2,$0C6E4F38,$A4E4BFD7,$4F5BA272,$564C1D2F,$C59C5319,$B949E354,$B04669FE,
    $B1B6AB8A,$C71358DD,$6385C545,$110F935D,$57538AD5,$6A390493,$E63D37E0,$2A54F6B3,
    $3A787D5F,$6276A0B5,$19A6FCDF,$7A42206A,$29F9D4D5,$F61B1891,$BB72275E,$AA508167,
    $38901091,$C6B505EB,$84C7CB8C,$2AD75A0F,$874A1427,$A2D1936B,$2AD286AF,$AA56D291,
    $D7894360,$425C750D,$93B39E26,$187184C9,$6C00B32D,$73E2BB14,$A0BEBC3C,$54623779,
    $64459EAB,$3F328B82,$7718CF82,$59A2CEA6,$04EE002E,$89FE78E6,$3FAB0950,$325FF6C2,
    $81383F05,$6963C5C8,$76CB5AD6,$D49974C9,$CA180DCF,$380782D5,$C7FA5CF6,$8AC31511,
    $35E79E13,$47DA91D0,$F40F9086,$A7E2419E,$31366241,$051EF495,$AA573B04,$4A805D8D,
    $548300D0,$00322A3C,$BF64CDDF,$BA57A68E,$75C6372B,$50AFD341,$A7C13275,$915A0BF5,
    $6B54BFAB,$2B0B1426,$AB4CC9D7,$449CCD82,$F7FBF265,$AB85C5F3,$1B55DB94,$AAD4E324,
    $CFA4BD3F,$2DEAA3E2,$9E204D02,$C8BD25AC,$EADF55B3,$D5BD9E98,$E31231B2,$2AD5AD6C,
    $954329DE,$ADBE4528,$D8710F69,$AA51C90F,$AA786BF6,$22513F1E,$AA51A79B,$2AD344CC,
    $7B5A41F0,$D37CFBAD,$1B069505,$41ECE491,$B4C332E6,$032268D4,$C9600ACC,$CE387E6D,
    $BF6BB16C,$6A70FB78,$0D03D9C9,$D4DF39DE,$E01063DA,$4736F464,$5AD328D8,$B347CC96,
    $75BB0FC3,$98511BFB,$4FFBCC35,$B58BCF6A,$E11F0ABC,$BFC5FE4A,$A70AEC10,$AC39570A,
    $3F04442F,$6188B153,$E0397A2E,$5727CB79,$9CEB418F,$1CACD68D,$2AD37C96,$0175CB9D,
    $C69DFF09,$C75B65F0,$D9DB40D8,$EC0E7779,$4744EAD4,$B11C3274,$DD24CB9E,$7E1C54BD,
    $F01144F9,$D2240EB1,$9675B3FD,$A3AC3755,$D47C27AF,$51C85F4D,$56907596,$A5BB15E6,
    $580304F0,$CA042CF1,$011A37EA,$8DBFAADB,$35BA3E4A,$3526FFA0,$C37B4D09,$BC306ED9,
    $98A52666,$5648F725,$FF5E569D,$0CED63D0,$7C63B2CF,$700B45E1,$D5EA50F1,$85A92872,
    $AF1FBDA7,$D4234870,$A7870BF3,$2D3B4D79,$42E04198,$0CD0EDE7,$26470DB8,$F881814C,
    $474D6AD7,$7C0C5E5C,$D1231959,$381B7298,$F5D2F4DB,$AB838653,$6E2F1E23,$83719C9E,
    $BD91E046,$9A56456E,$DC39200C,$20C8C571,$962BDA1C,$E1E696FF,$B141AB08,$7CCA89B9,
    $1A69E783,$02CC4843,$A2F7C579,$429EF47D,$427B169C,$5AC9F049,$DD8F0F00,$5C8165BF),
   ($1F201094,$EF0BA75B,$69E3CF7E,$393F4380,$FE61CF7A,$EEC5207A,$55889C94,$72FC0651,
    $ADA7EF79,$4E1D7235,$D55A63CE,$DE0436BA,$99C430EF,$5F0C0794,$18DCDB7D,$A1D6EFF3,
    $A0B52F7B,$59E83605,$EE15B094,$E9FFD909,$DC440086,$EF944459,$BA83CCB3,$E0C3CDFB,
    $D1DA4181,$3B092AB1,$F997F1C1,$A5E6CF7B,$01420DDB,$E4E7EF5B,$25A1FF41,$E180F806,
    $1FC41080,$179BEE7A,$D37AC6A9,$FE5830A4,$98DE8B7F,$77E83F4E,$79929269,$24FA9F7B,
    $E113C85B,$ACC40083,$D7503525,$F7EA615F,$62143154,$0D554B63,$5D681121,$C866C359,
    $3D63CF73,$CEE234C0,$D4D87E87,$5C672B21,$071F6181,$39F7627F,$361E3084,$E4EB573B,
    $602F64A4,$D63ACD9C,$1BBC4635,$9E81032D,$2701F50C,$99847AB4,$A0E3DF79,$BA6CF38C,
    $10843094,$2537A95E,$F46F6FFE,$A1FF3B1F,$208CFB6A,$8F458C74,$D9E0A227,$4EC73A34,
    $FC884F69,$3E4DE8DF,$EF0E0088,$3559648D,$8A45388C,$1D804366,$721D9BFD,$A58684BB,
    $E8256333,$844E8212,$128D8098,$FED33FB4,$CE280AE1,$27E19BA5,$D5A6C252,$E49754BD,
    $C5D655DD,$EB667064,$77840B4D,$A1B6A801,$84DB26A9,$E0B56714,$21F043B7,$E5D05860,
    $54F03084,$066FF472,$A31AA153,$DADC4755,$B5625DBF,$68561BE6,$83CA6B94,$2D6ED23B,
    $ECCF01DB,$A6D3D0BA,$B6803D5C,$AF77A709,$33B4A34C,$397BC8D6,$5EE22B95,$5F0E5304,
    $81ED6F61,$20E74364,$B45E1378,$DE18639B,$881CA122,$B96726D1,$8049A7E8,$22B7DA7B,
    $5E552D25,$5272D237,$79D2951C,$C60D894C,$488CB402,$1BA4FE5B,$A4B09F6B,$1CA815CF,
    $A20C3005,$8871DF63,$B9DE2FCB,$0CC6C9E9,$0BEEFF53,$E3214517,$B4542835,$9F63293C,
    $EE41E729,$6E1D2D7C,$50045286,$1E6685F3,$F33401C6,$30A22C95,$31A70850,$60930F13,
    $73F98417,$A1269859,$EC645C44,$52C877A9,$CDFF33A6,$A02B1741,$7CBAD9A2,$2180036F,
    $50D99C08,$CB3F4861,$C26BD765,$64A3F6AB,$80342676,$25A75E7B,$E4E6D1FC,$20C710E6,
    $CDF0B680,$17844D3B,$31EEF84D,$7E0824E4,$2CCB49EB,$846A3BAE,$8FF77888,$EE5D60F6,
    $7AF75673,$2FDD5CDB,$A11631C1,$30F66F43,$B3FAEC54,$157FD7FA,$EF8579CC,$D152DE58,
    $DB2FFD5E,$8F32CE19,$306AF97A,$02F03EF8,$99319AD5,$C242FA0F,$A7E3EBB0,$C68E4906,
    $B8DA230C,$80823028,$DCDEF3C8,$D35FB171,$088A1BC8,$BEC0C560,$61A3C9E8,$BCA8F54D,
    $C72FEFFA,$22822E99,$82C570B4,$D8D94E89,$8B1C34BC,$301E16E6,$273BE979,$B0FFEAA6,
    $61D9B8C6,$00B24869,$B7FFCE3F,$08DC283B,$43DAF65A,$F7E19798,$7619B72F,$8F1C9BA4,
    $DC8637A0,$16A7D3B1,$9FC393B7,$A7136EEB,$C6BCC63E,$1A513742,$EF6828BC,$520365D6,
    $2D6A77AB,$3527ED4B,$821FD216,$095C6E2E,$DB92F2FB,$5EEA29CB,$145892F5,$91584F7F,
    $5483697B,$2667A8CC,$85196048,$8C4BACEA,$833860D4,$0D23E0F9,$6C387E8A,$0AE6D249,
    $B284600C,$D835731D,$DCB1C647,$AC4C56EA,$3EBD81B3,$230EABB0,$6438BC87,$F0B5B1FA,
    $8F5EA2B3,$FC184642,$0A036B7A,$4FB089BD,$649DA589,$A345415E,$5C038323,$3E5D3BB9,
    $43D79572,$7E6DD07C,$06DFDF1E,$6C6CC4EF,$7160A539,$73BFBE70,$83877605,$4523ECF1),
   ($8DEFC240,$25FA5D9F,$EB903DBF,$E810C907,$47607FFF,$369FE44B,$8C1FC644,$AECECA90,
    $BEB1F9BF,$EEFBCAEA,$E8CF1950,$51DF07AE,$920E8806,$F0AD0548,$E13C8D83,$927010D5,
    $11107D9F,$07647DB9,$B2E3E4D4,$3D4F285E,$B9AFA820,$FADE82E0,$A067268B,$8272792E,
    $553FB2C0,$489AE22B,$D4EF9794,$125E3FBC,$21FFFCEE,$825B1BFD,$9255C5ED,$1257A240,
    $4E1A8302,$BAE07FFF,$528246E7,$8E57140E,$3373F7BF,$8C9F8188,$A6FC4EE8,$C982B5A5,
    $A8C01DB7,$579FC264,$67094F31,$F2BD3F5F,$40FFF7C1,$1FB78DFC,$8E6BD2C1,$437BE59B,
    $99B03DBF,$B5DBC64B,$638DC0E6,$55819D99,$A197C81C,$4A012D6E,$C5884A28,$CCC36F71,
    $B843C213,$6C0743F1,$8309893C,$0FEDDD5F,$2F7FE850,$D7C07F7E,$02507FBF,$5AFB9A04,
    $A747D2D0,$1651192E,$AF70BF3E,$58C31380,$5F98302E,$727CC3C4,$0A0FB402,$0F7FEF82,
    $8C96FDAD,$5D2C2AAE,$8EE99A49,$50DA88B8,$8427F4A0,$1EAC5790,$796FB449,$8252DC15,
    $EFBD7D9B,$A672597D,$ADA840D8,$45F54504,$FA5D7403,$E83EC305,$4F91751A,$925669C2,
    $23EFE941,$A903F12E,$60270DF2,$0276E4B6,$94FD6574,$927985B2,$8276DBCB,$02778176,
    $F8AF918D,$4E48F79E,$8F616DDF,$E29D840E,$842F7D83,$340CE5C8,$96BBB682,$93B4B148,
    $EF303CAB,$984FAF28,$779FAF9B,$92DC560D,$224D1E20,$8437AA88,$7D29DC96,$2756D3DC,
    $8B907CEE,$B51FD240,$E7C07CE3,$E566B4A1,$C3E9615E,$3CF8209D,$6094D1E3,$CD9CA341,
    $5C76460E,$00EA983B,$D4D67881,$FD47572C,$F76CEDD9,$BDA8229C,$127DADAA,$438A074E,
    $1F97C090,$081BDB8A,$93A07EBE,$B938CA15,$97B03CFF,$3DC2C0F8,$8D1AB2EC,$64380E51,
    $68CC7BFB,$D90F2788,$12490181,$5DE5FFD4,$DD7EF86A,$76A2E214,$B9A40368,$925D958F,
    $4B39FFFA,$BA39AEE9,$A4FFD30B,$FAF7933B,$6D498623,$193CBCFA,$27627545,$825CF47A,
    $61BD8BA0,$D11E42D1,$CEAD04F4,$127EA392,$10428DB7,$8272A972,$9270C4A8,$127DE50B,
    $285BA1C8,$3C62F44F,$35C0EAA5,$E805D231,$428929FB,$B4FCDF82,$4FB66A53,$0E7DC15B,
    $1F081FAB,$108618AE,$FCFD086D,$F9FF2889,$694BCC11,$236A5CAE,$12DECA4D,$2C3F8CC5,
    $D2D02DFE,$F8EF5896,$E4CF52DA,$95155B67,$494A488C,$B9B6A80C,$5C8F82BC,$89D36B45,
    $3A609437,$EC00C9A9,$44715253,$0A874B49,$D773BC40,$7C34671C,$02717EF6,$4FEB5536,
    $A2D02FFF,$D2BF60C4,$D43F03C0,$50B4EF6D,$07478CD1,$006E1888,$A2E53F55,$B9E6D4BC,
    $A2048016,$97573833,$D7207D67,$DE0F8F3D,$72F87B33,$ABCC4F33,$7688C55D,$7B00A6B0,
    $947B0001,$570075D2,$F9BB88F8,$8942019E,$4264A5FF,$856302E0,$72DBD92B,$EE971B69,
    $6EA22FDE,$5F08AE2B,$AF7A616D,$E5C98767,$CF1FEBD2,$61EFC8C2,$F1AC2571,$CC8239C2,
    $67214CB8,$B1E583D1,$B7DC3E62,$7F10BDCE,$F90A5C38,$0FF0443D,$606E6DC6,$60543A49,
    $5727C148,$2BE98A1D,$8AB41738,$20E1BE24,$AF96DA0F,$68458425,$99833BE5,$600D457D,
    $282F9350,$8334B362,$D91D1120,$2B6D8DA0,$642B1E31,$9C305A00,$52BCE688,$1B03588A,
    $F7BAEFD5,$4142ED9C,$A4315C11,$83323EC5,$DFEF4636,$A133C501,$E9D3531C,$EE353783),
   ($9DB30420,$1FB6E9DE,$A7BE7BEF,$D273A298,$4A4F7BDB,$64AD8C57,$85510443,$FA020ED1,
    $7E287AFF,$E60FB663,$095F35A1,$79EBF120,$FD059D43,$6497B7B1,$F3641F63,$241E4ADF,
    $28147F5F,$4FA2B8CD,$C9430040,$0CC32220,$FDD30B30,$C0A5374F,$1D2D00D9,$24147B15,
    $EE4D111A,$0FCA5167,$71FF904C,$2D195FFE,$1A05645F,$0C13FEFE,$081B08CA,$05170121,
    $80530100,$E83E5EFE,$AC9AF4F8,$7FE72701,$D2B8EE5F,$06DF4261,$BB9E9B8A,$7293EA25,
    $CE84FFDF,$F5718801,$3DD64B04,$A26F263B,$7ED48400,$547EEBE6,$446D4CA0,$6CF3D6F5,
    $2649ABDF,$AEA0C7F5,$36338CC1,$503F7E93,$D3772061,$11B638E1,$72500E03,$F80EB2BB,
    $ABE0502E,$EC8D77DE,$57971E81,$E14F6746,$C9335400,$6920318F,$081DBB99,$FFC304A5,
    $4D351805,$7F3D5CE3,$A6C866C6,$5D5BCCA9,$DAEC6FEA,$9F926F91,$9F46222F,$3991467D,
    $A5BF6D8E,$1143C44F,$43958302,$D0214EEB,$022083B8,$3FB6180C,$18F8931E,$281658E6,
    $26486E3E,$8BD78A70,$7477E4C1,$B506E07C,$F32D0A25,$79098B02,$E4EABB81,$28123B23,
    $69DEAD38,$1574CA16,$DF871B62,$211C40B7,$A51A9EF9,$0014377B,$041E8AC8,$09114003,
    $BD59E4D2,$E3D156D5,$4FE876D5,$2F91A340,$557BE8DE,$00EAE4A7,$0CE5C2EC,$4DB4BBA6,
    $E756BDFF,$DD3369AC,$EC17B035,$06572327,$99AFC8B0,$56C8C391,$6B65811C,$5E146119,
    $6E85CB75,$BE07C002,$C2325577,$893FF4EC,$5BBFC92D,$D0EC3B25,$B7801AB7,$8D6D3B24,
    $20C763EF,$C366A5FC,$9C382880,$0ACE3205,$AAC9548A,$ECA1D7C7,$041AFA32,$1D16625A,
    $6701902C,$9B757A54,$31D477F7,$9126B031,$36CC6FDB,$C70B8B46,$D9E66A48,$56E55A79,
    $026A4CEB,$52437EFF,$2F8F76B4,$0DF980A5,$8674CDE3,$EDDA04EB,$17A9BE04,$2C18F4DF,
    $B7747F9D,$AB2AF7B4,$EFC34D20,$2E096B7C,$1741A254,$E5B6A035,$213D42F6,$2C1C7C26,
    $61C2F50F,$6552DAF9,$D2C231F8,$25130F69,$D8167FA2,$0418F2C8,$001A96A6,$0D1526AB,
    $63315C21,$5E0A72EC,$49BAFEFD,$187908D9,$8D0DBD86,$311170A7,$3E9B640C,$CC3E10D7,
    $D5CAD3B6,$0CAEC388,$F73001E1,$6C728AFF,$71EAE2A1,$1F9AF36E,$CFCBD12F,$C1DE8417,
    $AC07BE6B,$CB44A1D8,$8B9B0F56,$013988C3,$B1C52FCA,$B4BE31CD,$D8782806,$12A3A4E2,
    $6F7DE532,$58FD7EB6,$D01EE900,$24ADFFC2,$F4990FC5,$9711AAC5,$001D7B95,$82E5E7D2,
    $109873F6,$00613096,$C32D9521,$ADA121FF,$29908415,$7FBB977F,$AF9EB3DB,$29C9ED2A,
    $5CE2A465,$A730F32C,$D0AA3FE8,$8A5CC091,$D49E2CE7,$0CE454A9,$D60ACD86,$015F1919,
    $77079103,$DEA03AF6,$78A8565E,$DEE356DF,$21F05CBE,$8B75E387,$B3C50651,$B8A5C3EF,
    $D8EEB6D2,$E523BE77,$C2154529,$2F69EFDF,$AFE67AFB,$F470C4B2,$F3E0EB5B,$D6CC9876,
    $39E4460C,$1FDA8538,$1987832F,$CA007367,$A99144F8,$296B299E,$492FC295,$9266BEAB,
    $B5676E69,$9BD3DDDA,$DF7E052F,$DB25701C,$1B5E51EE,$F65324E6,$6AFCE36C,$0316CC04,
    $8644213E,$B7DC59D0,$7965291F,$CCD6FD43,$41823979,$932BCDF6,$B657C34D,$4EDFD282,
    $7AE5290C,$3CB9536B,$851E20FE,$9833557E,$13ECF0B0,$D3FFB372,$3F85C5C1,$0AEF7ED2));

  Cast128_Key: array[0..3, 0..255] of LongWord = (
   ($7EC90C04,$2C6E74B9,$9B0E66DF,$A6337911,$B86A7FFF,$1DD358F5,$44DD9D44,$1731167F,
    $08FBF1FA,$E7F511CC,$D2051B00,$735ABA00,$2AB722D8,$386381CB,$ACF6243A,$69BEFD7A,
    $E6A2E77F,$F0C720CD,$C4494816,$CCF5C180,$38851640,$15B0A848,$E68B18CB,$4CAADEFF,
    $5F480A01,$0412B2AA,$259814FC,$41D0EFE2,$4E40B48D,$248EB6FB,$8DBA1CFE,$41A99B02,
    $1A550A04,$BA8F65CB,$7251F4E7,$95A51725,$C106ECD7,$97A5980A,$C539B9AA,$4D79FE6A,
    $F2F3F763,$68AF8040,$ED0C9E56,$11B4958B,$E1EB5A88,$8709E6B0,$D7E07156,$4E29FEA7,
    $6366E52D,$02D1C000,$C4AC8E05,$9377F571,$0C05372A,$578535F2,$2261BE02,$D642A0C9,
    $DF13A280,$74B55BD2,$682199C0,$D421E5EC,$53FB3CE8,$C8ADEDB3,$28A87FC9,$3D959981,
    $5C1FF900,$FE38D399,$0C4EFF0B,$062407EA,$AA2F4FB1,$4FB96976,$90C79505,$B0A8A774,
    $EF55A1FF,$E59CA2C2,$A6B62D27,$E66A4263,$DF65001F,$0EC50966,$DFDD55BC,$29DE0655,
    $911E739A,$17AF8975,$32C7911C,$89F89468,$0D01E980,$524755F4,$03B63CC9,$0CC844B2,
    $BCF3F0AA,$87AC36E9,$E53A7426,$01B3D82B,$1A9E7449,$64EE2D7E,$CDDBB1DA,$01C94910,
    $B868BF80,$0D26F3FD,$9342EDE7,$04A5C284,$636737B6,$50F5B616,$F24766E3,$8ECA36C1,
    $136E05DB,$FEF18391,$FB887A37,$D6E7F7D4,$C7FB7DC9,$3063FCDF,$B6F589DE,$EC2941DA,
    $26E46695,$B7566419,$F654EFC5,$D08D58B7,$48925401,$C1BACB7F,$E5FF550F,$B6083049,
    $5BB5D0E8,$87D72E5A,$AB6A6EE1,$223A66CE,$C62BF3CD,$9E0885F9,$68CB3E47,$086C010F,
    $A21DE820,$D18B69DE,$F3F65777,$FA02C3F6,$407EDAC3,$CBB3D550,$1793084D,$B0D70EBA,
    $0AB378D5,$D951FB0C,$DED7DA56,$4124BBE4,$94CA0B56,$0F5755D1,$E0E1E56E,$6184B5BE,
    $580A249F,$94F74BC0,$E327888E,$9F7B5561,$C3DC0280,$05687715,$646C6BD7,$44904DB3,
    $66B4F0A3,$C0F1648A,$697ED5AF,$49E92FF6,$309E374F,$2CB6356A,$85808573,$4991F840,
    $76F0AE02,$083BE84D,$28421C9A,$44489406,$736E4CB8,$C1092910,$8BC95FC6,$7D869CF4,
    $134F616F,$2E77118D,$B31B2BE1,$AA90B472,$3CA5D717,$7D161BBA,$9CAD9010,$AF462BA2,
    $9FE459D2,$45D34559,$D9F2DA13,$DBC65487,$F3E4F94E,$176D486F,$097C13EA,$631DA5C7,
    $445F7382,$175683F4,$CDC66A97,$70BE0288,$B3CDCF72,$6E5DD2F3,$20936079,$459B80A5,
    $BE60E2DB,$A9C23101,$EBA5315C,$224E42F2,$1C5C1572,$F6721B2C,$1AD2FFF3,$8C25404E,
    $324ED72F,$4067B7FD,$0523138E,$5CA3BC78,$DC0FD66E,$75922283,$784D6B17,$58EBB16E,
    $44094F85,$3F481D87,$FCFEAE7B,$77B5FF76,$8C2302BF,$AAF47556,$5F46B02A,$2B092801,
    $3D38F5F7,$0CA81F36,$52AF4A8A,$66D5E7C0,$DF3B0874,$95055110,$1B5AD7A8,$F61ED5AD,
    $6CF6E479,$20758184,$D0CEFA65,$88F7BE58,$4A046826,$0FF6F8F3,$A09C7F70,$5346ABA0,
    $5CE96C28,$E176EDA3,$6BAC307F,$376829D2,$85360FA9,$17E3FE2A,$24B79767,$F5A96B20,
    $D6CD2595,$68FF1EBF,$7555442C,$F19F06BE,$F9E0659A,$EEB9491D,$34010718,$BB30CAB8,
    $E822FE15,$88570983,$750E6249,$DA627E55,$5E76FFA8,$B1534546,$6D47DE08,$EFE9E7D4),
   ($F6FA8F9D,$2CAC6CE1,$4CA34867,$E2337F7C,$95DB08E7,$016843B4,$ECED5CBC,$325553AC,
    $BF9F0960,$DFA1E2ED,$83F0579D,$63ED86B9,$1AB6A6B8,$DE5EBE39,$F38FF732,$8989B138,
    $33F14961,$C01937BD,$F506C6DA,$E4625E7E,$A308EA99,$4E23E33C,$79CBD7CC,$48A14367,
    $A3149619,$FEC94BD5,$A114174A,$EAA01866,$A084DB2D,$09A8486F,$A888614A,$2900AF98,
    $01665991,$E1992863,$C8F30C60,$2E78EF3C,$D0D51932,$CF0FEC14,$F7CA07D2,$D0A82072,
    $FD41197E,$9305A6B0,$E86BE3DA,$74BED3CD,$372DA53C,$4C7F4448,$DAB5D440,$6DBA0EC3,
    $083919A7,$9FBAEED9,$49DBCFB0,$4E670C53,$5C3D9C01,$64BDB941,$2C0E636A,$BA7DD9CD,
    $EA6F7388,$E70BC762,$35F29ADB,$5C4CDD8D,$F0D48D8C,$B88153E2,$08A19866,$1AE2EAC8,
    $284CAF89,$AA928223,$9334BE53,$3B3A21BF,$16434BE3,$9AEA3906,$EFE8C36E,$F890CDD9,
    $80226DAE,$C340A4A3,$DF7E9C09,$A694A807,$5B7C5ECC,$221DB3A6,$9A69A02F,$68818A54,
    $CEB2296F,$53C0843A,$FE893655,$25BFE68A,$B4628ABC,$CF222EBF,$25AC6F48,$A9A99387,
    $53BDDB65,$E76FFBE7,$E967FD78,$0BA93563,$8E342BC1,$E8A11BE9,$4980740D,$C8087DFC,
    $8DE4BF99,$A11101A0,$7FD37975,$DA5A26C0,$E81F994F,$9528CD89,$FD339FED,$B87834BF,
    $5F04456D,$22258698,$C9C4C83B,$2DC156BE,$4F628DAA,$57F55EC5,$E2220ABE,$D2916EBF,
    $4EC75B95,$24F2C3C0,$42D15D99,$CD0D7FA0,$7B6E27FF,$A8DC8AF0,$7345C106,$F41E232F,
    $35162386,$E6EA8926,$3333B094,$157EC6F2,$372B74AF,$692573E4,$E9A9D848,$F3160289,
    $3A62EF1D,$A787E238,$F3A5F676,$74364853,$20951063,$4576698D,$B6FAD407,$592AF950,
    $36F73523,$4CFB6E87,$7DA4CEC0,$6C152DAA,$CB0396A8,$C50DFE5D,$FCD707AB,$0921C42F,
    $89DFF0BB,$5FE2BE78,$448F4F33,$754613C9,$2B05D08D,$48B9D585,$DC049441,$C8098F9B,
    $7DEDE786,$C39A3373,$42410005,$6A091751,$0EF3C8A6,$890072D6,$28207682,$A9A9F7BE,
    $BF32679D,$D45B5B75,$B353FD00,$CBB0E358,$830F220A,$1F8FB214,$D372CF08,$CC3C4A13,
    $8CF63166,$061C87BE,$88C98F88,$6062E397,$47CF8E7A,$B6C85283,$3CC2ACFB,$3FC06976,
    $4E8F0252,$64D8314D,$DA3870E3,$1E665459,$C10908F0,$513021A5,$6C5B68B7,$822F8AA0,
    $3007CD3E,$74719EEF,$DC872681,$073340D4,$7E432FD9,$0C5EC241,$8809286C,$F592D891,
    $08A930F6,$957EF305,$B7FBFFBD,$C266E96F,$6FE4AC98,$B173ECC0,$BC60B42A,$953498DA,
    $FBA1AE12,$2D4BD736,$0F25FAAB,$A4F3FCEB,$E2969123,$257F0C3D,$9348AF49,$361400BC,
    $E8816F4A,$3814F200,$A3F94043,$9C7A54C2,$BC704F57,$DA41E7F9,$C25AD33A,$54F4A084,
    $B17F5505,$59357CBE,$EDBD15C8,$7F97C5AB,$BA5AC7B5,$B6F6DEAF,$3A479C3A,$5302DA25,
    $653D7E6A,$54268D49,$51A477EA,$5017D55B,$D7D25D88,$44136C76,$0404A8C8,$B8E5A121,
    $B81A928A,$60ED5869,$97C55B96,$EAEC991B,$29935913,$01FDB7F1,$088E8DFA,$9AB6F6F5,
    $3B4CBF9F,$4A5DE3AB,$E6051D35,$A0E1D855,$D36B4CF1,$F544EDEB,$B0E93524,$BEBB8FBD,
    $A2D762CF,$49C92F54,$38B5F331,$7128A454,$48392905,$A65B1DB8,$851C97BD,$D675CF2F),
   ($85E04019,$332BF567,$662DBFFF,$CFC65693,$2A8D7F6F,$AB9BC912,$DE6008A1,$2028DA1F,
    $0227BCE7,$4D642916,$18FAC300,$50F18B82,$2CB2CB11,$B232E75C,$4B3695F2,$B28707DE,
    $A05FBCF6,$CD4181E9,$E150210C,$E24EF1BD,$B168C381,$FDE4E789,$5C79B0D8,$1E8BFD43,
    $4D495001,$38BE4341,$913CEE1D,$92A79C3F,$089766BE,$BAEEADF4,$1286BECF,$B6EACB19,
    $2660C200,$7565BDE4,$64241F7A,$8248DCA9,$C3B3AD66,$28136086,$0BD8DFA8,$356D1CF2,
    $107789BE,$B3B2E9CE,$0502AA8F,$0BC0351E,$166BF52A,$EB12FF82,$E3486911,$D34D7516,
    $4E7B3AFF,$5F43671B,$9CF6E037,$4981AC83,$334266CE,$8C9341B7,$D0D854C0,$CB3A6C88,
    $47BC2829,$4725BA37,$A66AD22B,$7AD61F1E,$0C5CBAFA,$4437F107,$B6E79962,$42D2D816,
    $0A961288,$E1A5C06E,$13749E67,$72FC081A,$B1D139F7,$F9583745,$CF19DF58,$BEC3F756,
    $C06EBA30,$07211B24,$45C28829,$C95E317F,$BC8EC511,$38BC46E9,$C6E6FA14,$BAE8584A,
    $AD4EBC46,$468F508B,$7829435F,$F124183B,$821DBA9F,$AFF60FF4,$EA2C4E6D,$16E39264,
    $92544A8B,$009B4FC3,$ABA68CED,$9AC96F78,$06A5B79A,$B2856E6E,$1AEC3CA9,$BE838688,
    $0E0804E9,$55F1BE56,$E7E5363B,$B3A1F25D,$F7DEBB85,$61FE033C,$16746233,$3C034C28,
    $DA6D0C74,$79AAC56C,$3CE4E1AD,$51F0C802,$98F8F35A,$1626A49F,$EED82B29,$1D382FE3,
    $0C4FB99A,$BB325778,$3EC6D97B,$6E77A6A9,$CB658B5C,$D45230C7,$2BD1408B,$60C03EB7,
    $B9068D78,$A33754F4,$F430C87D,$C8A71302,$B96D8C32,$EBD4E7BE,$BE8B9D2D,$7979FB06,
    $E7225308,$8B75CF77,$11EF8DA4,$E083C858,$8D6B786F,$5A6317A6,$FA5CF7A0,$5DDA0033,
    $F28EBFB0,$F5B9C310,$A0EAC280,$08B9767A,$A3D9D2B0,$79D34217,$021A718D,$9AC6336A,
    $2711FD60,$438050E3,$069908A8,$3D7FEDC4,$826D2BEF,$4EEB8476,$488DCF25,$36C9D566,
    $28E74E41,$C2610ACA,$3D49A9CF,$BAE3B9DF,$B65F8DE6,$92AEAF64,$3AC7D5E6,$9EA80509,
    $F22B017D,$A4173F70,$DD1E16C3,$15E0D7F9,$50B1B887,$2B9F4FD5,$625ABA82,$6A017962,
    $2EC01B9C,$15488AA9,$D716E740,$40055A2C,$93D29A22,$E32DBF9A,$058745B9,$3453DC1E,
    $D699296E,$496CFF6F,$1C9F4986,$DFE2ED07,$B87242D1,$19DE7EAE,$053E561A,$15AD6F8C,
    $66626C1C,$7154C24C,$EA082B2A,$93EB2939,$17DCB0F0,$58D4F2AE,$9EA294FB,$52CF564C,
    $9883FE66,$2EC40581,$763953C3,$01D6692E,$D3A0C108,$A1E7160E,$E4F2DFA6,$693ED285,
    $74904698,$4C2B0EDD,$4F757656,$5D393378,$A132234F,$3D321C5D,$C3F5E194,$4B269301,
    $C79F022F,$3C997E7E,$5E4F9504,$3FFAFBBD,$76F7AD0E,$296693F4,$3D1FCE6F,$C61E45BE,
    $D3B5AB34,$F72BF9B7,$1B0434C0,$4E72B567,$5592A33D,$B5229301,$CFD2A87F,$60AEB767,
    $1814386B,$30BCC33D,$38A0C07D,$FD1606F2,$C363519B,$589DD390,$5479F8E6,$1CB8D647,
    $97FD61A9,$EA7759F4,$2D57539D,$569A58CF,$E84E63AD,$462E1B78,$6580F87E,$F3817914,
    $91DA55F4,$40A230F3,$D1988F35,$B6E318D2,$3FFA50BC,$3D40F021,$C3C0BDAE,$4958C24C,
    $518F36B2,$84B1D370,$0FEDCE83,$878DDADA,$F2A279C7,$94E01BE8,$90716F4B,$954B8AA3),
   ($E216300D,$BBDDFFFC,$A7EBDABD,$35648095,$7789F8B7,$E6C1121B,$0E241600,$052CE8B5,
    $11A9CFB0,$E5952F11,$ECE7990A,$9386D174,$2A42931C,$76E38111,$B12DEF3A,$37DDDDFC,
    $DE9ADEB1,$0A0CC32C,$BE197029,$84A00940,$BB243A0F,$B4D137CF,$B44E79F0,$049EEDFD,
    $0B15A15D,$480D3168,$8BBBDE5A,$669DED42,$C7ECE831,$3F8F95E7,$72DF191B,$7580330D,
    $94074251,$5C7DCDFA,$ABBE6D63,$AA402164,$B301D40A,$02E7D1CA,$53571DAE,$7A3182A2,
    $12A8DDEC,$FDAA335D,$176F43E8,$71FB46D4,$38129022,$CE949AD4,$B84769AD,$965BD862,
    $82F3D055,$66FB9767,$15B80B4E,$1D5B47A0,$4CFDE06F,$C28EC4B8,$57E8726E,$647A78FC,
    $99865D44,$608BD593,$6C200E03,$39DC5FF6,$5D0B00A3,$AE63AFF2,$7E8BD632,$70108C0C,
    $BBD35049,$2998DF04,$980CF42A,$9B6DF491,$9E7EDD53,$06918548,$58CB7E07,$3B74EF2E,
    $522FFFB1,$D24708CC,$1C7E27CD,$A4EB215B,$3CF1D2E2,$19B47A38,$424F7618,$35856039,
    $9D17DEE7,$27EB35E6,$C9AFF67B,$36BAF5B8,$09C467CD,$C18910B1,$E11DBF7B,$06CD1AF8,
    $7170C608,$2D5E3354,$D4DE495A,$64C6D006,$BCC0C62C,$3DD00DB3,$708F8F34,$77D51B42,
    $264F620F,$24B8D2BF,$15C1B79E,$46A52564,$F8D7E54E,$3E378160,$7895CDA5,$859C15A5,
    $E6459788,$C37BC75F,$DB07BA0C,$0676A3AB,$7F229B1E,$31842E7B,$24259FD7,$F8BEF472,
    $835FFCB8,$6DF4C1F2,$96F5B195,$FD0AF0FC,$B0FE134C,$E2506D3D,$4F9B12EA,$F215F225,
    $A223736F,$9FB4C428,$25D04979,$34C713F8,$C4618187,$EA7A6E98,$7CD16EFC,$1436876C,
    $F1544107,$BEDEEE14,$56E9AF27,$A04AA441,$3CF7C899,$92ECBAE6,$DD67016D,$151682EB,
    $A842EEDF,$FDBA60B4,$F1907B75,$20E3030F,$24D8C29E,$E139673B,$EFA63FB8,$71873054,
    $B6F2CF3B,$9F326442,$CB15A4CC,$B01A4504,$F1E47D8D,$844A1BE5,$BAE7DFDC,$42CBDA70,
    $CD7DAE0A,$57E85B7A,$D53F5AF6,$20CF4D8C,$CEA4D428,$79D130A4,$3486EBFB,$33D3CDDC,
    $77853B53,$37EFFCB5,$C5068778,$E580B3E6,$4E68B8F4,$C5C8B37E,$0D809EA2,$398FEB7C,
    $132A4F94,$43B7950E,$2FEE7D1C,$223613BD,$DD06CAA2,$37DF932B,$C4248289,$ACF3EBC3,
    $5715F6B7,$EF3478DD,$F267616F,$C148CBE4,$9052815E,$5E410FAB,$B48A2465,$2EDA7FA4,
    $E87B40E4,$E98EA084,$5889E9E1,$EFD390FC,$DD07D35B,$DB485694,$38D7E5B2,$57720101,
    $730EDEBC,$5B643113,$94917E4F,$503C2FBA,$646F1282,$7523D24A,$E0779695,$F9C17A8F,
    $7A5B2121,$D187B896,$29263A4D,$BA510CDF,$81F47C9F,$AD1163ED,$EA7B5965,$1A00726E,
    $11403092,$00DA6D77,$4A0CDD61,$AD1F4603,$605BDFB0,$9EEDC364,$22EBE6A8,$CEE7D28A,
    $A0E736A0,$5564A6B9,$10853209,$C7EB8F37,$2DE705CA,$8951570F,$DF09822B,$BD691A6C,
    $AA12E4F2,$87451C0F,$E0F6A27A,$3ADA4819,$4CF1764F,$0D771C2B,$67CDB156,$350D8384,
    $5938FA0F,$42399EF3,$36997B07,$0E84093D,$4AA93E61,$8360D87B,$1FA98B0C,$1149382C,
    $E97625A5,$0614D1B7,$0E25244B,$0C768347,$589E8D82,$0D2059D1,$A466BB1E,$F8DA0A82,
    $04F19130,$BA6E4EC0,$99265164,$1EE7230D,$50B2AD80,$EAEE6801,$8DB2A283,$EA8BF59E));

  Gost_Data: array[0..3, 0..255] of LongWord = (
   ($00072000,$00075000,$00074800,$00071000,$00076800,$00074000,$00070000,$00077000,
    $00073000,$00075800,$00070800,$00076000,$00073800,$00077800,$00072800,$00071800,
    $0005A000,$0005D000,$0005C800,$00059000,$0005E800,$0005C000,$00058000,$0005F000,
    $0005B000,$0005D800,$00058800,$0005E000,$0005B800,$0005F800,$0005A800,$00059800,
    $00022000,$00025000,$00024800,$00021000,$00026800,$00024000,$00020000,$00027000,
    $00023000,$00025800,$00020800,$00026000,$00023800,$00027800,$00022800,$00021800,
    $00062000,$00065000,$00064800,$00061000,$00066800,$00064000,$00060000,$00067000,
    $00063000,$00065800,$00060800,$00066000,$00063800,$00067800,$00062800,$00061800,
    $00032000,$00035000,$00034800,$00031000,$00036800,$00034000,$00030000,$00037000,
    $00033000,$00035800,$00030800,$00036000,$00033800,$00037800,$00032800,$00031800,
    $0006A000,$0006D000,$0006C800,$00069000,$0006E800,$0006C000,$00068000,$0006F000,
    $0006B000,$0006D800,$00068800,$0006E000,$0006B800,$0006F800,$0006A800,$00069800,
    $0007A000,$0007D000,$0007C800,$00079000,$0007E800,$0007C000,$00078000,$0007F000,
    $0007B000,$0007D800,$00078800,$0007E000,$0007B800,$0007F800,$0007A800,$00079800,
    $00052000,$00055000,$00054800,$00051000,$00056800,$00054000,$00050000,$00057000,
    $00053000,$00055800,$00050800,$00056000,$00053800,$00057800,$00052800,$00051800,
    $00012000,$00015000,$00014800,$00011000,$00016800,$00014000,$00010000,$00017000,
    $00013000,$00015800,$00010800,$00016000,$00013800,$00017800,$00012800,$00011800,
    $0001A000,$0001D000,$0001C800,$00019000,$0001E800,$0001C000,$00018000,$0001F000,
    $0001B000,$0001D800,$00018800,$0001E000,$0001B800,$0001F800,$0001A800,$00019800,
    $00042000,$00045000,$00044800,$00041000,$00046800,$00044000,$00040000,$00047000,
    $00043000,$00045800,$00040800,$00046000,$00043800,$00047800,$00042800,$00041800,
    $0000A000,$0000D000,$0000C800,$00009000,$0000E800,$0000C000,$00008000,$0000F000,
    $0000B000,$0000D800,$00008800,$0000E000,$0000B800,$0000F800,$0000A800,$00009800,
    $00002000,$00005000,$00004800,$00001000,$00006800,$00004000,$00000000,$00007000,
    $00003000,$00005800,$00000800,$00006000,$00003800,$00007800,$00002800,$00001800,
    $0003A000,$0003D000,$0003C800,$00039000,$0003E800,$0003C000,$00038000,$0003F000,
    $0003B000,$0003D800,$00038800,$0003E000,$0003B800,$0003F800,$0003A800,$00039800,
    $0002A000,$0002D000,$0002C800,$00029000,$0002E800,$0002C000,$00028000,$0002F000,
    $0002B000,$0002D800,$00028800,$0002E000,$0002B800,$0002F800,$0002A800,$00029800,
    $0004A000,$0004D000,$0004C800,$00049000,$0004E800,$0004C000,$00048000,$0004F000,
    $0004B000,$0004D800,$00048800,$0004E000,$0004B800,$0004F800,$0004A800,$00049800),
   ($03A80000,$03C00000,$03880000,$03E80000,$03D00000,$03980000,$03A00000,$03900000,
    $03F00000,$03F80000,$03E00000,$03B80000,$03B00000,$03800000,$03C80000,$03D80000,
    $06A80000,$06C00000,$06880000,$06E80000,$06D00000,$06980000,$06A00000,$06900000,
    $06F00000,$06F80000,$06E00000,$06B80000,$06B00000,$06800000,$06C80000,$06D80000,
    $05280000,$05400000,$05080000,$05680000,$05500000,$05180000,$05200000,$05100000,
    $05700000,$05780000,$05600000,$05380000,$05300000,$05000000,$05480000,$05580000,
    $00A80000,$00C00000,$00880000,$00E80000,$00D00000,$00980000,$00A00000,$00900000,
    $00F00000,$00F80000,$00E00000,$00B80000,$00B00000,$00800000,$00C80000,$00D80000,
    $00280000,$00400000,$00080000,$00680000,$00500000,$00180000,$00200000,$00100000,
    $00700000,$00780000,$00600000,$00380000,$00300000,$00000000,$00480000,$00580000,
    $04280000,$04400000,$04080000,$04680000,$04500000,$04180000,$04200000,$04100000,
    $04700000,$04780000,$04600000,$04380000,$04300000,$04000000,$04480000,$04580000,
    $04A80000,$04C00000,$04880000,$04E80000,$04D00000,$04980000,$04A00000,$04900000,
    $04F00000,$04F80000,$04E00000,$04B80000,$04B00000,$04800000,$04C80000,$04D80000,
    $07A80000,$07C00000,$07880000,$07E80000,$07D00000,$07980000,$07A00000,$07900000,
    $07F00000,$07F80000,$07E00000,$07B80000,$07B00000,$07800000,$07C80000,$07D80000,
    $07280000,$07400000,$07080000,$07680000,$07500000,$07180000,$07200000,$07100000,
    $07700000,$07780000,$07600000,$07380000,$07300000,$07000000,$07480000,$07580000,
    $02280000,$02400000,$02080000,$02680000,$02500000,$02180000,$02200000,$02100000,
    $02700000,$02780000,$02600000,$02380000,$02300000,$02000000,$02480000,$02580000,
    $03280000,$03400000,$03080000,$03680000,$03500000,$03180000,$03200000,$03100000,
    $03700000,$03780000,$03600000,$03380000,$03300000,$03000000,$03480000,$03580000,
    $06280000,$06400000,$06080000,$06680000,$06500000,$06180000,$06200000,$06100000,
    $06700000,$06780000,$06600000,$06380000,$06300000,$06000000,$06480000,$06580000,
    $05A80000,$05C00000,$05880000,$05E80000,$05D00000,$05980000,$05A00000,$05900000,
    $05F00000,$05F80000,$05E00000,$05B80000,$05B00000,$05800000,$05C80000,$05D80000,
    $01280000,$01400000,$01080000,$01680000,$01500000,$01180000,$01200000,$01100000,
    $01700000,$01780000,$01600000,$01380000,$01300000,$01000000,$01480000,$01580000,
    $02A80000,$02C00000,$02880000,$02E80000,$02D00000,$02980000,$02A00000,$02900000,
    $02F00000,$02F80000,$02E00000,$02B80000,$02B00000,$02800000,$02C80000,$02D80000,
    $01A80000,$01C00000,$01880000,$01E80000,$01D00000,$01980000,$01A00000,$01900000,
    $01F00000,$01F80000,$01E00000,$01B80000,$01B00000,$01800000,$01C80000,$01D80000),
   ($30000002,$60000002,$38000002,$08000002,$28000002,$78000002,$68000002,$40000002,
    $20000002,$50000002,$48000002,$70000002,$00000002,$18000002,$58000002,$10000002,
    $B0000005,$E0000005,$B8000005,$88000005,$A8000005,$F8000005,$E8000005,$C0000005,
    $A0000005,$D0000005,$C8000005,$F0000005,$80000005,$98000005,$D8000005,$90000005,
    $30000005,$60000005,$38000005,$08000005,$28000005,$78000005,$68000005,$40000005,
    $20000005,$50000005,$48000005,$70000005,$00000005,$18000005,$58000005,$10000005,
    $30000000,$60000000,$38000000,$08000000,$28000000,$78000000,$68000000,$40000000,
    $20000000,$50000000,$48000000,$70000000,$00000000,$18000000,$58000000,$10000000,
    $B0000003,$E0000003,$B8000003,$88000003,$A8000003,$F8000003,$E8000003,$C0000003,
    $A0000003,$D0000003,$C8000003,$F0000003,$80000003,$98000003,$D8000003,$90000003,
    $30000001,$60000001,$38000001,$08000001,$28000001,$78000001,$68000001,$40000001,
    $20000001,$50000001,$48000001,$70000001,$00000001,$18000001,$58000001,$10000001,
    $B0000000,$E0000000,$B8000000,$88000000,$A8000000,$F8000000,$E8000000,$C0000000,
    $A0000000,$D0000000,$C8000000,$F0000000,$80000000,$98000000,$D8000000,$90000000,
    $B0000006,$E0000006,$B8000006,$88000006,$A8000006,$F8000006,$E8000006,$C0000006,
    $A0000006,$D0000006,$C8000006,$F0000006,$80000006,$98000006,$D8000006,$90000006,
    $B0000001,$E0000001,$B8000001,$88000001,$A8000001,$F8000001,$E8000001,$C0000001,
    $A0000001,$D0000001,$C8000001,$F0000001,$80000001,$98000001,$D8000001,$90000001,
    $30000003,$60000003,$38000003,$08000003,$28000003,$78000003,$68000003,$40000003,
    $20000003,$50000003,$48000003,$70000003,$00000003,$18000003,$58000003,$10000003,
    $30000004,$60000004,$38000004,$08000004,$28000004,$78000004,$68000004,$40000004,
    $20000004,$50000004,$48000004,$70000004,$00000004,$18000004,$58000004,$10000004,
    $B0000002,$E0000002,$B8000002,$88000002,$A8000002,$F8000002,$E8000002,$C0000002,
    $A0000002,$D0000002,$C8000002,$F0000002,$80000002,$98000002,$D8000002,$90000002,
    $B0000004,$E0000004,$B8000004,$88000004,$A8000004,$F8000004,$E8000004,$C0000004,
    $A0000004,$D0000004,$C8000004,$F0000004,$80000004,$98000004,$D8000004,$90000004,
    $30000006,$60000006,$38000006,$08000006,$28000006,$78000006,$68000006,$40000006,
    $20000006,$50000006,$48000006,$70000006,$00000006,$18000006,$58000006,$10000006,
    $B0000007,$E0000007,$B8000007,$88000007,$A8000007,$F8000007,$E8000007,$C0000007,
    $A0000007,$D0000007,$C8000007,$F0000007,$80000007,$98000007,$D8000007,$90000007,
    $30000007,$60000007,$38000007,$08000007,$28000007,$78000007,$68000007,$40000007,
    $20000007,$50000007,$48000007,$70000007,$00000007,$18000007,$58000007,$10000007),
   ($000000E8,$000000D8,$000000A0,$00000088,$00000098,$000000F8,$000000A8,$000000C8,
    $00000080,$000000D0,$000000F0,$000000B8,$000000B0,$000000C0,$00000090,$000000E0,
    $000007E8,$000007D8,$000007A0,$00000788,$00000798,$000007F8,$000007A8,$000007C8,
    $00000780,$000007D0,$000007F0,$000007B8,$000007B0,$000007C0,$00000790,$000007E0,
    $000006E8,$000006D8,$000006A0,$00000688,$00000698,$000006F8,$000006A8,$000006C8,
    $00000680,$000006D0,$000006F0,$000006B8,$000006B0,$000006C0,$00000690,$000006E0,
    $00000068,$00000058,$00000020,$00000008,$00000018,$00000078,$00000028,$00000048,
    $00000000,$00000050,$00000070,$00000038,$00000030,$00000040,$00000010,$00000060,
    $000002E8,$000002D8,$000002A0,$00000288,$00000298,$000002F8,$000002A8,$000002C8,
    $00000280,$000002D0,$000002F0,$000002B8,$000002B0,$000002C0,$00000290,$000002E0,
    $000003E8,$000003D8,$000003A0,$00000388,$00000398,$000003F8,$000003A8,$000003C8,
    $00000380,$000003D0,$000003F0,$000003B8,$000003B0,$000003C0,$00000390,$000003E0,
    $00000568,$00000558,$00000520,$00000508,$00000518,$00000578,$00000528,$00000548,
    $00000500,$00000550,$00000570,$00000538,$00000530,$00000540,$00000510,$00000560,
    $00000268,$00000258,$00000220,$00000208,$00000218,$00000278,$00000228,$00000248,
    $00000200,$00000250,$00000270,$00000238,$00000230,$00000240,$00000210,$00000260,
    $000004E8,$000004D8,$000004A0,$00000488,$00000498,$000004F8,$000004A8,$000004C8,
    $00000480,$000004D0,$000004F0,$000004B8,$000004B0,$000004C0,$00000490,$000004E0,
    $00000168,$00000158,$00000120,$00000108,$00000118,$00000178,$00000128,$00000148,
    $00000100,$00000150,$00000170,$00000138,$00000130,$00000140,$00000110,$00000160,
    $000001E8,$000001D8,$000001A0,$00000188,$00000198,$000001F8,$000001A8,$000001C8,
    $00000180,$000001D0,$000001F0,$000001B8,$000001B0,$000001C0,$00000190,$000001E0,
    $00000768,$00000758,$00000720,$00000708,$00000718,$00000778,$00000728,$00000748,
    $00000700,$00000750,$00000770,$00000738,$00000730,$00000740,$00000710,$00000760,
    $00000368,$00000358,$00000320,$00000308,$00000318,$00000378,$00000328,$00000348,
    $00000300,$00000350,$00000370,$00000338,$00000330,$00000340,$00000310,$00000360,
    $000005E8,$000005D8,$000005A0,$00000588,$00000598,$000005F8,$000005A8,$000005C8,
    $00000580,$000005D0,$000005F0,$000005B8,$000005B0,$000005C0,$00000590,$000005E0,
    $00000468,$00000458,$00000420,$00000408,$00000418,$00000478,$00000428,$00000448,
    $00000400,$00000450,$00000470,$00000438,$00000430,$00000440,$00000410,$00000460,
    $00000668,$00000658,$00000620,$00000608,$00000618,$00000678,$00000628,$00000648,
    $00000600,$00000650,$00000670,$00000638,$00000630,$00000640,$00000610,$00000660));

  Q128_Data: array[0..1023] of LongWord = (
    $D6D92632,$5E84404D,$4F341282,$71654B06,$D48D6A0B,$245BECC4,$C8F84D80,$22C620C9,
    $66AA8B02,$0AC697FF,$8B755A36,$2577931C,$438D17B6,$BB7B1BD1,$E0A8F51E,$F4FD583D,
    $BECEEB95,$7945C1AE,$29CE9628,$3D7965CD,$80CFBDB9,$2F535A25,$7666A9BD,$6DF2324B,
    $98731A06,$E4D32444,$265FAF55,$41895427,$F2D2C55E,$8151930F,$77A888A3,$9CBA9A32,
    $A7EC629C,$55DCF904,$B35B9179,$1AB8E42E,$A0EF8027,$DB4C5CDE,$9FC2A9D3,$A9512439,
    $9C08CB5C,$4BFD92B6,$C23EDA7F,$037833E1,$40177A91,$BAE53567,$774AD665,$3CB744D3,
    $6E8A01AA,$65D2B8E3,$0507A12A,$EF69C3CB,$230801D7,$0BBAE78F,$62630B36,$ED6D805A,
    $5AAF9EBF,$721D78E7,$D33CD9DE,$6618DA6C,$9DC6EA42,$0D272B82,$3559EF65,$DCFDEF0B,
    $865271B4,$3621DC84,$885D667F,$92E58251,$2E9D7B3B,$E9165100,$99BD3B18,$B1ED8386,
    $84563225,$446CABCB,$7E462315,$A2BBCC1E,$3BE4A9C0,$320A0276,$416B0AE1,$C6A755E3,
    $5C8003DC,$36C38242,$97E2237B,$2AE6AA61,$8A5925EE,$3B56F8AE,$26BDF193,$96CE5CA3,
    $E51D055A,$AD2AF563,$2B9ADA11,$9F70F8BD,$3F9F789A,$89934761,$A8CF0A8F,$C78B2A3B,
    $8F5E84C4,$B8B1795E,$AFCCE834,$D9AA4189,$C28C8B11,$7636A615,$F2609430,$ECA3A144,
    $7869BE76,$12C8612E,$D18ACB21,$CC61C21C,$EDDFD134,$AD7AFACB,$7F6A5CCD,$0C0B545A,
    $584983E8,$04998F9C,$969E530B,$E21EE7E1,$FFF5EEDC,$FE3BCFC2,$97007DBD,$66FA84AA,
    $A375ED00,$3509E0CD,$1B76C530,$70193B76,$86E020DA,$C9366C9E,$49F9D127,$AE52C682,
    $260FA0FD,$E380C957,$CE358E25,$02044391,$AEB09844,$F31CE440,$F0D686CF,$8CC4E9E3,
    $BE2CB553,$1E933ADC,$C312A5A7,$1D0957FB,$A1C3FFFF,$BD5486B2,$E8D8701E,$6E685F6C,
    $1BC4945E,$062F9D63,$84063D8D,$C1F4B8F0,$A7BC6D34,$C4F319DA,$F81452A1,$4CAE7FA5,
    $1DBB0695,$AA9B46B6,$6BDDAF28,$61F96611,$9A27563F,$C2DC84B9,$6530E625,$E7494963,
    $6FF671DA,$B8532798,$C06A9646,$CC839CDA,$9EEED60B,$A70E3C5A,$F0868967,$02544C39,
    $87CC5F02,$B3B9CFBF,$F6F91BAC,$DCADE0A3,$8B9704F0,$6CDE4D93,$64AEC893,$3E515984,
    $7BF3D351,$3EB30742,$BE9EE43D,$B15FD2E8,$2C7B666C,$01CE211E,$3B06F706,$05E5FFEC,
    $24E9BDAA,$FDA1A2E5,$E04AABD8,$E9A4006E,$019E2EB6,$8D0AC8FD,$73D359F9,$6A43819E,
    $00500FA8,$DA302CAE,$C0D8C728,$62D15A58,$61A969B9,$1E216BB2,$0892DBC6,$3A7A8776,
    $34259F15,$79A79F68,$F96822D1,$7F88020B,$AF9CE79C,$017C7070,$F8445D09,$EE15B3BB,
    $E3629791,$20203D9E,$53413509,$25279CB4,$DF378D84,$8921160F,$A89F0527,$413B0549,
    $AD98A40D,$FB8E3F86,$00000000,$D717072C,$E6353913,$ACB4DBD5,$1F0D146A,$C411471C,
    $B9CD092E,$41D95B8F,$74D0BB42,$86027E1C,$DA827DC0,$57D8BA95,$12986E86,$9BB97889,
    $C9843DF0,$122A3FE8,$556EA86A,$D8346F3F,$693BB27F,$53113AA1,$2850B89E,$0CE90A9C,
    $FB3C6EE8,$7A6DFDE7,$917FEF76,$2A54FB0F,$E2ACB68F,$E4832BEC,$2E7F25FD,$110203A1,
    $AACB491E,$18ECA817,$9E5C8765,$14B7F3E5,$C146E99E,$2E2F2A55,$47A6C944,$23BA50B9,
    $D2F2F8C0,$FBDE302E,$A494517D,$B5740C1A,$72AF2989,$EE45BC13,$03283C49,$6FA67E72,
    $F767351A,$1A5ABAE8,$197286A1,$E71946CB,$0F7367BB,$DD33CE15,$31C060F9,$67D6FB72,
    $AEE097EC,$28E2E9F0,$E7AB17A5,$BA076BA1,$2595CDDA,$D43F3B65,$25C5C272,$C81A1346,
    $177D916A,$9B5B264F,$E166D400,$9EBED9A3,$7EF4727B,$611B38D7,$5DFC73AC,$0C5B5BF2,
    $8DE8963B,$C7DB2593,$31223E3F,$D7470884,$606748A7,$FFA5E174,$F3FEBA86,$40F52457,
    $A3C7BC6E,$DC4FBE65,$6233049E,$C26ED5D7,$4F8643EC,$468AB69C,$53A36BCF,$558CF6AC,
    $95043E2C,$1B26CA98,$4867FF91,$85C81C93,$B60C3FFB,$897119A7,$4AD1ED6E,$7480B4EA,
    $0BEAE827,$D0F6BB51,$58198C40,$6989E311,$5F1A6EFB,$696BBDD7,$6847C20F,$6C6C1CFD,
    $1EC33574,$F64B4AC2,$F41F06FB,$00B2516E,$644C9655,$8C94E64B,$6648D5C4,$A2EBC3B6,
    $4C1C2ECB,$F7856BDC,$7ADFAC89,$4837F039,$AE02C92A,$35BBB1A3,$E461752A,$F7D56474,
    $D210A606,$718715C0,$A4C45ED5,$BAB53ACF,$1C252823,$CB807E61,$CDAFE302,$AA791870,
    $0B58B949,$A00DDEE1,$60D519C9,$E1848AC6,$D9481F4F,$F148A879,$64FEC73B,$3C551A15,
    $E5AF5434,$4D605EBB,$A55A7063,$3C0515BD,$1DEB093D,$0D957AEC,$3EE308EA,$CCD39372,
    $D38E88B0,$FA401E98,$8F0E8B6C,$B023A298,$9207DC97,$7C126F2C,$D8863E51,$CD4DBDC4,
    $382ECB4F,$6A138E36,$631F7B46,$19228909,$1C75278B,$50DB582E,$90039F06,$A9B37AFF,
    $06CDC3A5,$210C4246,$8FECD5AA,$B227E109,$3D9B3B0B,$B92F57E8,$23EA5F11,$7839B1DE,
    $CAAC01B9,$127A3040,$F282CAF6,$9A950751,$8E22F4B4,$FC6F83FB,$56F4C54D,$BCCAA804,
    $0F91397D,$60851661,$807DECD7,$EADC338F,$51457698,$9F20F715,$E4317A82,$D7A55642,
    $F2309B98,$3F2D29F4,$EB121291,$DBAE0218,$99ED34B0,$FD13F38B,$91CDBE18,$C9666336,
    $7B118D97,$042BDEF2,$ED3D8FF2,$179FCFAC,$63AD2A28,$32B85318,$CDFFECAA,$724D774F,
    $21EE1C80,$42A1686E,$2A04F4A7,$95B66F42,$DE4BFDF4,$D240A9AE,$4A81E2C6,$A82D5449,
    $7D3E10F4,$614B377F,$FAA2405E,$3FCF7732,$90B1CE68,$FC8DDD3D,$8DB89993,$16E3BFDC,
    $B30B9ED1,$8229A0EE,$4EAA3C34,$B10FDD40,$56A4CAE5,$84E4634B,$D16895E7,$6E3850C4,
    $95543184,$58ABDD2E,$BE7CBAFB,$C8A84228,$DAD27268,$DB1C5376,$71D71A68,$BDB6D874,
    $EBF04C57,$DFD5D342,$852A4255,$D66B775C,$B4087C6A,$CBD071C9,$EB421D39,$DD819F7B,
    $4FD64C44,$305E4E4F,$7D8C419A,$D014E597,$DEA9A332,$1C97794D,$45A28AD5,$628155F0,
    $912FE0DE,$43DD181E,$FAF24FF6,$4EFA339C,$9399F221,$0EED490D,$B4BA2D04,$A193F057,
    $942841F4,$E136DBA8,$E7FB180D,$F5337923,$30BC1089,$BC9AA7AC,$CFFBAF3B,$6560E98D,
    $33942CC0,$0A969857,$5788B53D,$20703236,$31906F51,$A75E33F2,$5987A2F6,$6B3FF1EE,
    $C5DF6602,$A25992D8,$6AF1D0F0,$1651EEB2,$5FA83F95,$D8D631F9,$788BE0B0,$B6BE6E95,
    $A121A139,$19C0D7CF,$095CFAD8,$09BEA41E,$872E01C4,$C7397B55,$990F6A76,$1601E11A,
    $17CFC004,$3BB4A668,$8ABB7B28,$809FB211,$94CA1F32,$B277EEA1,$CFABA093,$5965FC30,
    $9AC508F9,$7F3A5365,$EF8B9D0D,$37EFFD9A,$949A109A,$9F92A67B,$90E1C1C0,$F8F60C67,
    $8A092A46,$F8A603CF,$F9382D79,$6F142F1C,$5AFF9117,$ACE4D47D,$FE899EAC,$13564F98,
    $D2A2F768,$76D4F8D3,$A2099D70,$08C2D46E,$42133900,$07E1BC7D,$F4AD5795,$EEF7ED7D,
    $932BA34F,$33267DAE,$CAFC0E11,$2FB104E3,$503906E8,$172D9EC2,$F61B456A,$6EDA0E02,
    $4E4862F2,$C56D376C,$526D4AD1,$E9465EA8,$448EF50D,$EA3E6D49,$3952BB3F,$2ECD7493,
    $AC068ABB,$59D7AD5E,$877E0E6C,$A397B3C6,$069DCC0D,$D63B78F4,$7CF031EA,$180EF6D1,
    $CA1E50D7,$DF85DCEA,$8C76B88D,$EA6E62E1,$090CF570,$E54D0AF2,$B2C5BFCF,$14E7FC4D,
    $B7204023,$7EA47DD3,$52DF1BBF,$6582B74B,$ECF3AEEC,$C03A99EE,$7E162CBD,$3A98D9B0,
    $0DC57544,$A325E2A8,$D5434B15,$E687687D,$6817CDA7,$6D406325,$4714982A,$102E7C79,
    $BC28F6C2,$78DBEF18,$2AB6A5C9,$C3A0F4C9,$7D6E1F5C,$9C58C4F4,$82CBFE28,$21BE1328,
    $576AEBFB,$8E72FB1C,$A6724C2A,$4638E7F2,$2B7884D7,$40477539,$5442D7B2,$EA8C3C27,
    $1455AD23,$2773D08D,$387EC4E7,$3AC8D618,$4B4FC3D8,$18BCA7BF,$83B78E58,$53F36467,
    $2723DF25,$4C4C2163,$8598133B,$1FBF4504,$2FE10B4B,$297CC746,$46DAB934,$56469423,
    $641C99FD,$4CFE700D,$8B25559E,$5D1E2D6A,$BC78F96A,$24B9B202,$EF39CC63,$C116E636,
    $989144C0,$EFDB92A5,$5D4E22C2,$68A59CC9,$77F8870B,$7A3DF24F,$7CA03E42,$FD43FC23,
    $70FB65B0,$905390AE,$443CA463,$6D106C8D,$1529DD53,$38CC9589,$5935F398,$2F03558D,
    $B8E176F6,$B073AD30,$5E661E8B,$11520C09,$573AE453,$8C26B725,$DDD190D3,$97507215,
    $27C181E3,$0557AE82,$F3AEB52E,$D51344BD,$9D96E5EA,$42F167C6,$A6C01D44,$982315AE,
    $2B288B7F,$A171AE91,$97B22CD3,$919DB1B0,$13B4115E,$7684F77B,$C342AA0F,$08208AA8,
    $08708500,$E5FF5B9C,$4E186D5A,$2800B736,$D5A115D3,$C4A31672,$159B8C3D,$FE6BC06A,
    $967C0DCD,$07B1B3D5,$433F46D8,$E8887FB6,$4668E85A,$45F2857D,$2BCAD5B9,$D4DD65A3,
    $72FF2621,$B99D0686,$8EC0AA72,$2DE548DA,$E01AA470,$8355D09E,$5E361123,$E66536BB,
    $5F4A6153,$5DAC7C04,$23580E7F,$B52403B2,$93C9FD89,$B6EE613D,$C6F75A4B,$3A2A88DE,
    $70AB6A18,$4D305113,$C3F0FB61,$22247E0F,$49A9DE8F,$8D5AC755,$95E660EA,$C088C880,
    $C6450B25,$F7373AB2,$F1AAF6BF,$3CE74B7B,$FDF1AD4D,$634F74EE,$ABE736C6,$436F4970,
    $4A63BC00,$94784E5C,$27918E4B,$300E41E7,$9BE97721,$DBFE0DB0,$ED8FDE9C,$81E3C261,
    $FED99104,$33C42368,$5ED44FE5,$0753ED13,$47F6C6EC,$704934DE,$2CC93702,$02B612FF,
    $3F7D265C,$A4760FBB,$1A0AB540,$09EEABB6,$ADC8ABA5,$13E41EF6,$88BF38B9,$D91810E7,
    $523D4579,$6734A5B4,$370DA35C,$DC1FB1CD,$04C98034,$2DB54772,$4DD20FD5,$86B02F72,
    $BB994517,$D044EA3F,$D1DAC489,$4885A157,$3902B497,$C1A4B758,$0FC136D5,$FF17B01A,
    $5B83E167,$7A8FA321,$1579D2FB,$EBA043FF,$50690940,$802DE37F,$A6224382,$6B8DA080,
    $0A74C691,$7432E584,$528F1417,$A5E8210D,$88EF3711,$9A775997,$0CB90534,$292CC8EE,
    $47449782,$20C26358,$C615048D,$AA2917D8,$494B8049,$84B46CE3,$73610897,$7BA3DCF9,
    $4510DBBB,$68F59361,$8279AF46,$BD04891A,$CE87DF4B,$553EA7C2,$CB322F0F,$5C625D1A,
    $4F641D2A,$325A0DDE,$A50A7FCB,$11B052CF,$1D595853,$F563768B,$98C14B68,$3D296A65,
    $DE1BF25C,$3671D32C,$E3329839,$F581284D,$37BFF232,$DEF9AC9A,$8E90A5DA,$754E95F4,
    $5B31B009,$B4EA22AC,$713544AE,$CE65818D,$067F92CB,$39E0EA51,$B0C1FC5E,$C84A1CEE,
    $6AA1DF58,$E9F40FC6,$F1FAF917,$13064030,$05B5F044,$424336A8,$0A24C939,$C44148B4,
    $6F4420B4,$047BD15A,$39B0E5F9,$8BC70B58,$0E5F1863,$D1389A4F,$AF2EB6F2,$C9D43258,
    $107E73D1,$89C348C9,$9CEA959A,$11E05D67,$BB2B1479,$73835651,$F34CEBE8,$D36CD676,
    $4540D413,$5CD00C74,$31723197,$EEA7E2D5,$0F236813,$81B3CDC9,$7FD80DA3,$D7F559EA,
    $03CA628F,$3DCB34A3,$33767206,$2C2B69C4,$51F727F6,$829BF180,$039A6D27,$56169B8B,
    $4D82007D,$9D24B484,$BDE6D7DC,$389C9A21,$69D9ECB9,$B792114D,$44DEFAA5,$8FBCDA02,
    $92B58DF9,$962C0265,$CF19F1FD,$7462EA2C,$227471A7,$C53D38C4,$9257D33F,$32E85CB0,
    $ABB7396E,$30EC1F21,$58FBD286,$5B61BFA1,$240BE36C,$B7704F8B,$A69012EC,$1F5D1BC2,
    $8305DF36,$299E9980,$5FF8303D,$C58F69AA,$7DDC4E32,$E6D767D5,$880D69D7,$D46F34CD,
    $FF47BFB2,$22962F61,$A9E37557,$FA101130,$83E781F0,$CF49FE55,$FCDDD295,$2D07161C,
    $E83A2ED8,$CA4E5F7F,$75FCC49A,$7915CE06,$54F086DC,$A9012B91,$0EBD46A5,$DF67822C,
    $D9FA4E21,$AF7EB95A,$81019CA7,$F118A7D1,$00E25EC6,$9B0B29E7,$E2FCB927,$EC11F02A,
    $857A4DFD,$3497CE7B,$1B949BF6,$9D74BB2C,$CC31CDB4,$E3D0C6FF,$BF00CA8B,$36938DEA,
    $16B3B074,$CED7D0E3,$6037470F,$CD1DB26C,$6DA23DE3,$BBC94ABF,$5A1DCFD1,$C76974FD,
    $A05DD149,$F034D809,$A4260013,$B091F3F6,$A5B82EA5,$6786F4DA,$4BAD9D1E,$1E71641A,
    $B59652DC,$BA576409,$B1BD8C2E,$2D5719B4,$7331073F,$AC568513,$B97F5840,$BF50C523,
    $0703E2BB,$6764AA1C,$20926CF0,$012C7FD8,$1CC776E5,$9E0C88CD,$995F65DE,$F44F0953,
    $E86A2170,$1FEF4AAC,$7C426084,$771AD9CD,$2C9938AA,$B8032830,$4A33B3A8,$751E9A5C,
    $DD63C1BD,$79F790C0,$51157930,$D5F11A7B,$D8646097,$CB6220A7,$D689299A,$879C50AA,
    $B7C21EE5,$4B1FCC70,$0B08B6E1,$28B2E658,$B295B067,$AB056800,$75ACCB32,$BFB29BE5,
    $F5D127E5,$6C8E423B,$6B6FFE46,$215C4DEE,$F9DA73BF,$7B41823F,$48D5AEFF,$1405A28B,
    $BFE2944D,$347590BD,$B45873C2,$B65C3053,$A0BF8F8F,$937BACE7,$1AE8EB86,$40A52BFF,
    $E24EE849,$D3DE8718,$6C3C1355,$1990D867,$54A08974,$375DACF4,$508B5786,$63FD2580,
    $F98A7C17,$34C7C1D3,$D0A6B4F9,$3E01562C,$185EF979,$5412D81A,$B5C65D74,$26EDFE3B,
    $35EBBE0B,$02E61D57,$15CB8395,$0E0F17CB,$FC3F8C53,$5A4DC079,$E0F8FAB6,$5BD3EECF,
    $E1D4856E,$8AEB7480,$5C3252B2,$AB5567A8,$FB6C6140,$B3E9C017,$EC41FF82,$F064D7A1,
    $491B8FE1,$A87D5BE1,$10CC22BF,$F6A91404,$0D77242A,$DA602306,$51A7285E,$109C2D17);

  Misty_Data7: array[0..$7F] of Byte =
   ($1B,$32,$33,$5A,$3B,$10,$17,$54,$5B,$1A,$72,$73,$6B,$2C,$66,$49,
    $1F,$24,$13,$6C,$37,$2E,$3F,$4A,$5D,$0F,$40,$56,$25,$51,$1C,$04,
    $0B,$46,$20,$0D,$7B,$35,$44,$42,$2B,$1E,$41,$14,$4B,$79,$15,$6F,
    $0E,$55,$09,$36,$74,$0C,$67,$53,$28,$0A,$7E,$38,$02,$07,$60,$29,
    $19,$12,$65,$2F,$30,$39,$08,$68,$5F,$78,$2A,$4C,$64,$45,$75,$3D,
    $59,$48,$03,$57,$7C,$4F,$62,$3C,$1D,$21,$5E,$27,$6A,$70,$4D,$3A,
    $01,$6D,$6E,$63,$18,$77,$23,$05,$26,$76,$00,$31,$2D,$7A,$7F,$61,
    $50,$22,$11,$06,$47,$16,$52,$4E,$71,$3E,$69,$43,$34,$5C,$58,$7D);

  Misty_Data9: array[0..$1FF] of Word =
   ($01C3,$00CB,$0153,$019F,$01E3,$00E9,$00FB,$0035,
    $0181,$00B9,$0117,$01EB,$0133,$0009,$002D,$00D3,
    $00C7,$014A,$0037,$007E,$00EB,$0164,$0193,$01D8,
    $00A3,$011E,$0055,$002C,$001D,$01A2,$0163,$0118,
    $014B,$0152,$01D2,$000F,$002B,$0030,$013A,$00E5,
    $0111,$0138,$018E,$0063,$00E3,$00C8,$01F4,$001B,
    $0001,$009D,$00F8,$01A0,$016D,$01F3,$001C,$0146,
    $007D,$00D1,$0082,$01EA,$0183,$012D,$00F4,$019E,
    $01D3,$00DD,$01E2,$0128,$01E0,$00EC,$0059,$0091,
    $0011,$012F,$0026,$00DC,$00B0,$018C,$010F,$01F7,
    $00E7,$016C,$00B6,$00F9,$00D8,$0151,$0101,$014C,
    $0103,$00B8,$0154,$012B,$01AE,$0017,$0071,$000C,
    $0047,$0058,$007F,$01A4,$0134,$0129,$0084,$015D,
    $019D,$01B2,$01A3,$0048,$007C,$0051,$01CA,$0023,
    $013D,$01A7,$0165,$003B,$0042,$00DA,$0192,$00CE,
    $00C1,$006B,$009F,$01F1,$012C,$0184,$00FA,$0196,
    $01E1,$0169,$017D,$0031,$0180,$010A,$0094,$01DA,
    $0186,$013E,$011C,$0060,$0175,$01CF,$0067,$0119,
    $0065,$0068,$0099,$0150,$0008,$0007,$017C,$00B7,
    $0024,$0019,$00DE,$0127,$00DB,$00E4,$01A9,$0052,
    $0109,$0090,$019C,$01C1,$0028,$01B3,$0135,$016A,
    $0176,$00DF,$01E5,$0188,$00C5,$016E,$01DE,$01B1,
    $00C3,$01DF,$0036,$00EE,$01EE,$00F0,$0093,$0049,
    $009A,$01B6,$0069,$0081,$0125,$000B,$005E,$00B4,
    $0149,$01C7,$0174,$003E,$013B,$01B7,$008E,$01C6,
    $00AE,$0010,$0095,$01EF,$004E,$00F2,$01FD,$0085,
    $00FD,$00F6,$00A0,$016F,$0083,$008A,$0156,$009B,
    $013C,$0107,$0167,$0098,$01D0,$01E9,$0003,$01FE,
    $00BD,$0122,$0089,$00D2,$018F,$0012,$0033,$006A,
    $0142,$00ED,$0170,$011B,$00E2,$014F,$0158,$0131,
    $0147,$005D,$0113,$01CD,$0079,$0161,$01A5,$0179,
    $009E,$01B4,$00CC,$0022,$0132,$001A,$00E8,$0004,
    $0187,$01ED,$0197,$0039,$01BF,$01D7,$0027,$018B,
    $00C6,$009C,$00D0,$014E,$006C,$0034,$01F2,$006E,
    $00CA,$0025,$00BA,$0191,$00FE,$0013,$0106,$002F,
    $01AD,$0172,$01DB,$00C0,$010B,$01D6,$00F5,$01EC,
    $010D,$0076,$0114,$01AB,$0075,$010C,$01E4,$0159,
    $0054,$011F,$004B,$00C4,$01BE,$00F7,$0029,$00A4,
    $000E,$01F0,$0077,$004D,$017A,$0086,$008B,$00B3,
    $0171,$00BF,$010E,$0104,$0097,$015B,$0160,$0168,
    $00D7,$00BB,$0066,$01CE,$00FC,$0092,$01C5,$006F,
    $0016,$004A,$00A1,$0139,$00AF,$00F1,$0190,$000A,
    $01AA,$0143,$017B,$0056,$018D,$0166,$00D4,$01FB,
    $014D,$0194,$019A,$0087,$01F8,$0123,$00A7,$01B8,
    $0141,$003C,$01F9,$0140,$002A,$0155,$011A,$01A1,
    $0198,$00D5,$0126,$01AF,$0061,$012E,$0157,$01DC,
    $0072,$018A,$00AA,$0096,$0115,$00EF,$0045,$007B,
    $008D,$0145,$0053,$005F,$0178,$00B2,$002E,$0020,
    $01D5,$003F,$01C9,$01E7,$01AC,$0044,$0038,$0014,
    $00B1,$016B,$00AB,$00B5,$005A,$0182,$01C8,$01D4,
    $0018,$0177,$0064,$00CF,$006D,$0100,$0199,$0130,
    $015A,$0005,$0120,$01BB,$01BD,$00E0,$004F,$00D6,
    $013F,$01C4,$012A,$0015,$0006,$00FF,$019B,$00A6,
    $0043,$0088,$0050,$015F,$01E8,$0121,$0073,$017E,
    $00BC,$00C2,$00C9,$0173,$0189,$01F5,$0074,$01CC,
    $01E6,$01A8,$0195,$001F,$0041,$000D,$01BA,$0032,
    $003D,$01D1,$0080,$00A8,$0057,$01B9,$0162,$0148,
    $00D9,$0105,$0062,$007A,$0021,$01FF,$0112,$0108,
    $01C0,$00A9,$011D,$01B0,$01A6,$00CD,$00F3,$005C,
    $0102,$005B,$01D9,$0144,$01F6,$00AD,$00A5,$003A,
    $01CB,$0136,$017F,$0046,$00E1,$001E,$01DD,$00E6,
    $0137,$01FA,$0185,$008C,$008F,$0040,$01B5,$00BE,
    $0078,$0000,$00AC,$0110,$015E,$0124,$0002,$01BC,
    $00A2,$00EA,$0070,$01FC,$0116,$015C,$004C,$01C2);

  RC2_Data: array[0..255] of Byte =
   ($D9,$78,$F9,$C4,$19,$DD,$B5,$ED,$28,$E9,$FD,$79,$4A,$A0,$D8,$9D,
    $C6,$7E,$37,$83,$2B,$76,$53,$8E,$62,$4C,$64,$88,$44,$8B,$FB,$A2,
    $17,$9A,$59,$F5,$87,$B3,$4F,$13,$61,$45,$6D,$8D,$09,$81,$7D,$32,
    $BD,$8F,$40,$EB,$86,$B7,$7B,$0B,$F0,$95,$21,$22,$5C,$6B,$4E,$82,
    $54,$D6,$65,$93,$CE,$60,$B2,$1C,$73,$56,$C0,$14,$A7,$8C,$F1,$DC,
    $12,$75,$CA,$1F,$3B,$BE,$E4,$D1,$42,$3D,$D4,$30,$A3,$3C,$B6,$26,
    $6F,$BF,$0E,$DA,$46,$69,$07,$57,$27,$F2,$1D,$9B,$BC,$94,$43,$03,
    $F8,$11,$C7,$F6,$90,$EF,$3E,$E7,$06,$C3,$D5,$2F,$C8,$66,$1E,$D7,
    $08,$E8,$EA,$DE,$80,$52,$EE,$F7,$84,$AA,$72,$AC,$35,$4D,$6A,$2A,
    $96,$1A,$D2,$71,$5A,$15,$49,$74,$4B,$9F,$D0,$5E,$04,$18,$A4,$EC,
    $C2,$E0,$41,$6E,$0F,$51,$CB,$CC,$24,$91,$AF,$50,$A1,$F4,$70,$39,
    $99,$7C,$3A,$85,$23,$B8,$B4,$7A,$FC,$02,$36,$5B,$25,$55,$97,$31,
    $2D,$5D,$FA,$98,$E3,$8A,$92,$AE,$05,$DF,$29,$10,$67,$6C,$BA,$C9,
    $D3,$00,$E6,$CF,$E1,$9E,$A8,$2C,$63,$16,$01,$3F,$58,$E2,$89,$A9,
    $0D,$38,$34,$1B,$AB,$33,$FF,$B0,$BB,$48,$0C,$5F,$B9,$B1,$CD,$2E,
    $C5,$F3,$DB,$47,$E5,$A5,$9C,$77,$0A,$A6,$20,$68,$FE,$7F,$C1,$AD);

  Shark_SE: array[0..255] of Byte = (
   177, 206, 195, 149,  90, 173, 231,   2,  77,  68, 251, 145,  12, 135, 161,  80,
   203, 103,  84, 221,  70, 143, 225,  78, 240, 253, 252, 235, 249, 196,  26, 110,
    94, 245, 204, 141,  28,  86,  67, 254,   7,  97, 248, 117,  89, 255,   3,  34,
   138, 209,  19, 238, 136,   0,  14,  52,  21, 128, 148, 227, 237, 181,  83,  35,
    75,  71,  23, 167, 144,  53, 171, 216, 184, 223,  79,  87, 154, 146, 219,  27,
    60, 200, 153,   4, 142, 224, 215, 125, 133, 187,  64,  44,  58,  69, 241,  66,
   101,  32,  65,  24, 114,  37, 147, 112,  54,   5, 242,  11, 163, 121, 236,   8,
    39,  49,  50, 182, 124, 176,  10, 115,  91, 123, 183, 129, 210,  13, 106,  38,
   158,  88, 156, 131, 116, 179, 172,  48, 122, 105, 119,  15, 174,  33, 222, 208,
    46, 151,  16, 164, 152, 168, 212, 104,  45,  98,  41, 109,  22,  73, 118, 199,
   232, 193, 150,  55, 229, 202, 244, 233,  99,  18, 194, 166,  20, 188, 211,  40,
   175,  47, 230,  36,  82, 198, 160,   9, 189, 140, 207,  93,  17,  95,   1, 197,
   159,  61, 162, 155, 201,  59, 190,  81,  25,  31,  63,  92, 178, 239,  74, 205,
   191, 186, 111, 100, 217, 243,  62, 180, 170, 220, 213,   6, 192, 126, 246, 102,
   108, 132, 113,  56, 185,  29, 127, 157,  72, 139,  42, 218, 165,  51, 130,  57,
   214, 120, 134, 250, 228,  43, 169,  30, 137,  96, 107, 234,  85,  76, 247, 226);

  Shark_SD: array[0..255] of Byte = (
    53, 190,   7,  46,  83, 105, 219,  40, 111, 183, 118, 107,  12, 125,  54, 139,
   146, 188, 169,  50, 172,  56, 156,  66,  99, 200,  30,  79,  36, 229, 247, 201,
    97, 141,  47,  63, 179, 101, 127, 112, 175, 154, 234, 245,  91, 152, 144, 177,
   135, 113, 114, 237,  55,  69, 104, 163, 227, 239,  92, 197,  80, 193, 214, 202,
    90,  98,  95,  38,   9,  93,  20,  65, 232, 157, 206,  64, 253,   8,  23,  74,
    15, 199, 180,  62,  18, 252,  37,  75, 129,  44,   4, 120, 203, 187,  32, 189,
   249,  41, 153, 168, 211,  96, 223,  17, 151, 137, 126, 250, 224, 155,  31, 210,
   103, 226, 100, 119, 132,  43, 158, 138, 241, 109, 136, 121, 116,  87, 221, 230,
    57, 123, 238, 131, 225,  88, 242,  13,  52, 248,  48, 233, 185,  35,  84,  21,
    68,  11,  77, 102,  58,   3, 162, 145, 148,  82,  76, 195, 130, 231, 128, 192,
   182,  14, 194, 108, 147, 236, 171,  67, 149, 246, 216,  70, 134,   5, 140, 176,
   117,   0, 204, 133, 215,  61, 115, 122,  72, 228, 209,  89, 173, 184, 198, 208,
   220, 161, 170,   2,  29, 191, 181, 159,  81, 196, 165,  16,  34, 207,   1, 186,
   143,  49, 124, 174, 150, 218, 240,  86,  71, 212, 235,  78, 217,  19, 142,  73,
    85,  22, 255,  59, 244, 164, 178,   6, 160, 167, 251,  27, 110,  60,  51, 205,
    24,  94, 106, 213, 166,  33, 222, 254,  42,  28, 243,  10,  26,  25,  39,  45);

  Shark_G: array[0..7, 0..7] of Byte = (
   ($CE,$95,$57,$82,$8A,$19,$B0,$01),($E7,$FE,$05,$D2,$52,$C1,$88,$F1),
   ($B9,$DA,$4D,$D1,$9E,$17,$83,$86),($D0,$9D,$26,$2C,$5D,$9F,$6D,$75),
   ($52,$A9,$07,$6C,$B9,$8F,$70,$17),($87,$28,$3A,$5A,$F4,$33,$0B,$6C),
   ($74,$51,$15,$CF,$09,$A4,$62,$09),($0B,$31,$7F,$86,$BE,$05,$83,$34));

  Shark_I: array[0..7, 0..7] of Byte = (
   ($E7,$30,$90,$85,$D0,$4B,$91,$41),($53,$95,$9B,$A5,$96,$BC,$A1,$68),
   ($02,$45,$F7,$65,$5C,$1F,$B6,$52),($A2,$CA,$22,$94,$44,$63,$2A,$A2),
   ($FC,$67,$8E,$10,$29,$75,$85,$71),($24,$45,$A2,$CF,$2F,$22,$C1,$0E),
   ($A1,$F1,$71,$40,$91,$27,$18,$A5),($56,$F4,$AF,$32,$D2,$A4,$DC,$71));

  {$IF NOT DEFINED(CPU64) AND NOT DEFINED(CPU64BITS) AND NOT DEFINED(ENDIAN_BIG)}
  Shark_CE: array[0..7, 0..511] of LongWord = (
  ($16F3A365,$060D838F,$5CAE56F6,$A68857EE,$3C2C4D89,$EBF51635,$88E85BDC,$652174BE,
   $86C17921,$0D4E9A80,$CFFA58A1,$27BA7D33,$A237B530,$88D9E104,$A4FBE816,$693B8755,
   $26B254A0,$DAC95918,$FB336AF3,$45C2E369,$7B3E4EF4,$A96E1FB8,$35EB7EF0,$B7578F14,
   $32056F74,$839AF80B,$C71F277A,$AE37F55C,$FDFF37D5,$A4208538,$AD3CDB6F,$35991E74,
   $B32A07D1,$BA191594,$2E572B7B,$5344D177,$103FFE43,$E7EFE5DE,$41DE5E5B,$A3796FDC,
   $5FC882E5,$2CF9643C,$48196D22,$FFDBF6FD,$BBCF780A,$33949DFB,$D0CEC8BD,$7D15679D,
   $024498B1,$5F5E229C,$62C683CE,$12236347,$3041F7C5,$DCC4DA97,$9032DA44,$0B43190F,
   $DFC5A6E2,$C05598ED,$7753F4B8,$9E5FD31A,$C0F136FE,$9AFA8243,$F3D61528,$CC4F6B06,
   $3BC25C0D,$DF38612A,$EDC0C996,$43CF60E6,$F855BEE0,$CFB3D0BB,$ECE28534,$96E071A8,
   $D909FBC4,$21B7FEBC,$B4C41655,$8ED4628B,$B04CD3C2,$30682646,$94BA1FD3,$B5FF5DC2,
   $4B7FB931,$75AAC52F,$37AFE641,$E809AD88,$8D42D2E9,$0EB2213D,$61A057DD,$98525095,
   $70BDE53C,$AA92A405,$C63D6BD8,$7B18E412,$F67C9C1D,$A7DC3E85,$87E33583,$D8618BCE,
   $A79D3C05,$E34AB487,$73DB312F,$20E397D7,$1D7008AD,$05F13832,$7FB68B63,$17D25B75,
   $0366D413,$8A7133D2,$00000000,$00000000,$96FE8762,$EAA17F5E,$75176C09,$C101F186,
   $0488C597,$BEBC44CD,$8C609E4B,$DB9D3073,$DA6F2FD7,$ABC6CD6E,$1F34901C,$5AAF1AAE,
   $89CA177E,$B00E65F0,$ABF08649,$D47B7825,$5B404772,$924520F1,$D5644188,$1686321E,
   $3F4A999A,$618425E7,$0D4FF6EE,$E21EDDEC,$A0732D81,$D787C398,$E407FAEF,$1F6DF9C7,
   $676C0AFB,$79B036C4,$27901802,$0FE64856,$D602959B,$9CF701CC,$AE5A0F7C,$BFE82DA6,
   $CB729D36,$990639FE,$E525B64D,$CA42E889,$8249BCB6,$B3F2DE4D,$E643625E,$4033DB5B,
   $4C91A8B5,$4167B230,$C397E2ED,$108BB191,$58269361,$18341323,$927642F5,$541D3B93,
   $FA112651,$90EDF227,$45569BCC,$1DC52B11,$BAED34A8,$E6BB8CB5,$BD03252C,$D276FBAA,
   $1A9E1929,$313C4F2D,$E9480C01,$FD73242B,$6A23FC15,$9BAEEB28,$EEA61D85,$C9BE5334,
   $63E4CF6C,$C70C7209,$3D0E012B,$3EDA077B,$46304FDF,$97B418C3,$111DB2E1,$32C0F490,
   $E3E9EB6B,$2BA08ED8,$A9B41EF8,$8B255AB9,$50C3ECBA,$91B99B4C,$E2CBA7C9,$FE8F9F96,
   $8AACC36D,$3A7F5622,$2318DD95,$B15A0C9B,$14B73BD4,$5953A113,$640ADEE8,$F3C10516,
   $2ADFEEEC,$EDF895BA,$CC9C8CB2,$ADCB4EE1,$911096E6,$DE6C0841,$8E2406FA,$84C312EF,
   $D1EC841F,$A83A76D3,$EF845127,$1C91427A,$A6BF70A7,$3665A5C9,$797AD645,$F6303D24,
   $5904DFC3,$CD1B026D,$53A538A9,$1BC8A89E,$DB4D6375,$7EE9DC20,$8F064A58,$51EC03A1,
   $686764A4,$C4F0C9B4,$9A933D2E,$DD90B3FC,$6CEFA133,$7A4C8D79,$5D8C1A54,$73A746A0,
   $BC21698E,$0759EAE4,$4474D76E,$C8EA3A5F,$2BFDA24E,$38D784F4,$78589AE7,$231F2C6A,
   $D4460D2A,$C3A92350,$F75ED0BF,$72F32FCB,$0F0B6E5F,$BD40FF70,$DEE7EA40,$157A89A3,
   $85A7AD32,$873FA952,$60821B7F,$4D7D41DB,$4ED53004,$1E3990AC,$3AE010AF,$0A177064,
   $F1928D99,$9311499A,$223A9137,$64751DD5,$5569658F,$FA2ACECF,$7A1C0256,$7C410EF6,
   $332723D6,$56B5E945,$B2084B73,$6F3604DA,$9D7D2CAA,$E95DC4E3,$C8144925,$13770A2C,
   $A5D9A4B4,$BC14961B,$B8A9AC19,$B9E5AE29,$C55BBFCB,$F169D7C0,$C479F369,$2446C68E,
   $3986C4BC,$806643B6,$719FA99E,$7FBDB54B,$B7A2C246,$04A55159,$215C4524,$EE042E07,
   $B5E65AF7,$5BFB73C5,$2C13B3CA,$0C1AF3EB,$EB0C94B0,$A22D06B7,$127B66F2,$B8B1C742,
   $E86A40A3,$285C3565,$207E0986,$3B2B3F49,$9C5F6008,$3C72D5AD,$EA2ED812,$770217F9,
   $439AC6EA,$FC274D40,$C1D37A5C,$4FD5930D,$FE99E3C6,$2E51B6EA,$05AA8935,$6B935583,
   $F2F4598A,$19607A48,$9BB1718C,$08BFA2B2,$97DCCBC0,$3F8E6E10,$812F68A5,$3983ED9F,
   $664E4659,$AC9F278A,$98D7A59F,$82CE9160,$7E94C7C1,$C2FD4A3B,$836BF014,$66DDCF03,
   $06CC5D26,$E1E26651,$E1AD73DA,$74FEAC44,$BF47BD9D,$8D28D936,$34C93252,$62789E5A,
   $93540E57,$81322ADD,$4FF77CA6,$CB1681E2,$6EAB3982,$2512AFE5,$B6808EE4,$D18A4017,
   $560FB19C,$705BFD1D,$7671B81A,$4B70C254,$D720D939,$49D81082,$AC1E97CD,$E0B60F3A,
   $6B01B0B7,$4E81FA66,$E7612EFC,$951CCA15,$F0B0C13B,$463E58D4,$9E1BF8B9,$632CF731,
   $09C73379,$5CA29921,$D3A81CAE,$F764544F,$AF7843DE,$6AC73CE8,$DD813E53,$9F0BBA71,
   $24F6CC11,$85977B84,$BE65F13F,$5807C878,$0E2922FD,$686FEE3E,$CDBEC010,$78E45FAF,
   $B98BE0BB,$6CCABF67,$69452806,$11DFD8FA,$5287740B,$CEE7B9D0,$25D480B3,$50B86ACA,
   $A315F992,$5DF6F04A,$A896525A,$5E0A4BF7,$0B83ABC8,$03FCBBBD,$1E16DCBE,$8F800BE0,
   $17D1EFC7,$D32292C1,$B16E9F60,$E5473708,$D28A500C,$224B4501,$FFBBAF64,$FB7EA7A4,
   $368DAAE3,$3D26BCC6,$2F7567D9,$866BC039,$0C6DBA4C,$3731CCA2,$9F39B41B,$B603E67F,
   $E08F3F78,$A1D1BD0A,$2D31FF68,$D935E2A5,$6DCDED91,$AF639C37,$AAD2CAEB,$0154696B,
   $800D2407,$ECACFCD1,$6F897520,$F03DBEAB,$A1516123,$02A8D2D6,$D82BB766,$F498EFF2,
   $FCDD7B77,$710F9476,$F43804AC,$F8821C19,$5EEACE47,$F9D67572,$F977F242,$1A9CC1F5,
   $8485E190,$5210B81C,$13592A50,$6D9ED60C,$CED81403,$F2956C7D,$19F8CD3A,$BB4D7CFF,
   $CA50D194,$4C2928B0,$18DA8198,$6E626DB1,$1BBC558B,$E4135E63,$7CD05F70,$9DA368A7,
   $572DFD3E,$A574EC53,$3163BB67,$09EBCBD9,$DCA372F1,$4A24AB3F,$4712037D,$429B098D,
   $99F5E93D,$57E1802E,$8B8E8FCF,$EF50476C,$4A5DF593,$A085D461,$07EE1184,$34CD771F,
   $C9360587,$C6581B62,$F51A480E,$2DAD0D57,$08E57FDB,$898D886F,$0AA1E76A,$D6D3AAF3,
   $40FC12F9,$76567E92,$3E68D538,$B4AB34A9,$289B765D,$B2A6B726,$15957776,$8C7CB05D,
   $38A4881E,$554952F8,$01224CA2,$D52F114E,$95985371,$60D04C8C,$29B93AFF,$6789A668,
   $544B292D,$2F05DF81,$5A620BD0,$476A31BF,$72F97D8D,$F5CC8699,$7DF213D2,$488C79E9,
   $51E1A018,$44968A02,$6528924A,$26EE1458,$1C52440F,$D0DE297C,$C2B5AE4F,$C5A4A0DF,
   $42B88A48,$29085C0E,$743520AB,$142EE0C8,$493B2180,$2AF4E7B3,$4DB3E417,$9448A37E),
  ($05BA30CE,$E2795BA1,$F5E0FBDD,$65B5D634,$64DD8C55,$2D7D7F14,$ADD1C20B,$EEFBF778,
   $F11968E7,$1EB0FBD1,$CE30CD8D,$E6073F45,$CCB67E90,$21FFD3CD,$A750A262,$DF0941CF,
   $B75EF18A,$C61DF5B1,$9DC337C6,$C5C7DEFA,$073C83D3,$2581B729,$167173CF,$A5E97513,
   $381526B9,$DD3673BD,$F91EBB93,$E8BAA1EE,$F625EB34,$3B314CF8,$D5FC5DF8,$579D4BC8,
   $E7681B28,$BB598EC2,$80708794,$C8A06B1A,$6E5CEC3C,$1C8FC9A3,$0807D374,$F60A5A3F,
   $3A9395A4,$1ACE9F35,$7AAB2CEE,$7E9E5038,$D0466D36,$B5E41069,$B92602D9,$8CEA6EE3,
   $8AF1E7FD,$F952DDAD,$1BCC9075,$B19A748D,$B2E4C144,$2464AE10,$F4A35829,$FCC9A070,
   $A06C21B1,$FA88F6E6,$D105CEC2,$2C98662D,$D77AEEE5,$9065A740,$AAED41D8,$CB7A4051,
   $4AB9D923,$55A279BA,$98790708,$27BE855B,$52B059BF,$BABC97FB,$DDFB8E8C,$A19711F7,
   $CB8AFD43,$047E64E4,$C90C4E5E,$C386886C,$281B7551,$C422C7C3,$15B46326,$FB6DEFDF,
   $B5D84297,$01E51939,$9C809432,$5CBBA8BE,$09447080,$6F762C7B,$D4BFFE0C,$CEE13D8C,
   $FF619BB4,$54476083,$BC9C3217,$6E933542,$0E78F353,$4AF79B52,$B49BE163,$98996F7D,
   $6823CC1B,$A07208CE,$3012F5CD,$2B3C2982,$FDE728A9,$93BF8C0B,$E62BB8DC,$2225F886,
   $CF736E79,$7F7B4901,$00000000,$00000000,$9F4584DB,$023F3272,$5BF4293F,$D5CABB80,
   $E1173B0F,$07A44FAF,$4CC6F904,$E95FB8D7,$04F9933A,$7B052DE5,$7716CF54,$6AED51A6,
   $E8534B8F,$68D263D4,$BE1A810A,$A96BD9CA,$DB84AEAB,$1D6AD09A,$1DB3B052,$0D67B5E0,
   $ABAEE22C,$52063615,$93BBC495,$8F3045A8,$4647996D,$D8AD0E60,$EAD5F892,$AF2A8F5C,
   $BF5922FE,$3017AF8E,$F2DC780E,$4034611D,$D2C0DE2B,$721CFCE1,$1A8F3381,$28E602C9,
   $2F27F682,$E1A370EA,$AF577116,$29031BF0,$100E53E8,$1914B47E,$60241F6F,$567852F1,
   $9BBC17E1,$793A1F97,$1809809C,$EF1EEE41,$14F7C0D2,$6211999B,$7E52BFD4,$059B7DDD,
   $D841BE42,$43EE4A56,$E910E87B,$F1AE1590,$95C4E4B2,$33CD84C5,$BBA0B1C4,$4B12826B,
   $D3837DDF,$EB608AA5,$796E3C07,$201ACAF4,$2CE2E66B,$BF27EA26,$570A6971,$58C5CC5A,
   $5E4E19F1,$37B3E021,$215F05D1,$AB54EBB8,$26638602,$8ED55C91,$2BDE65B8,$9AA65D0F,
   $C4B1ADE4,$D7F589F2,$34EB66F7,$50390467,$23D9B6CC,$6CAC0730,$81332460,$51DC1D5E,
   $272025F6,$17A92AD5,$13CB4301,$47902EB2,$8F4BD733,$1B2B860C,$702A4C87,$4F6CE68F,
   $6167BC9B,$CF0424B5,$0143A3F4,$997C7644,$B121D1AD,$7AE034DC,$C6371EF9,$100D657A,
   $FCA48B5D,$0AC3FA4F,$1288E0F5,$DEEC58F6,$2DA1459F,$265B9C62,$8DCD642E,$DCD36A84,
   $51754956,$E4380D37,$ECAAD8B5,$13D74E31,$417B1ABE,$FD2CB949,$83B5977D,$9624F1D6,
   $A6130196,$4675378B,$497CC9CA,$0B26E376,$47043A99,$41D17824,$B0627259,$E39C4298,
   $FE223840,$CD3B16C7,$AC9261FF,$7787813C,$24E5351F,$492DB019,$C84FEDAA,$5AFAFE28,
   $583139D6,$8B4E214C,$4BFA7AD7,$CCDE0FFE,$194A2368,$76629805,$E5EEA835,$7CA1624A,
   $3E6A069E,$61CBB2D0,$913D7788,$48C8A920,$114DF01C,$8068C23A,$0F3B50A7,$D38BED16,
   $201CA625,$32289DFC,$5649CA85,$C1B9BA1E,$874C0447,$ED21DC33,$42BE0A57,$A3A82385,
   $7D97AF3D,$5B1FE711,$A2EA92AC,$3D701A6E,$67189CBC,$73F9E5D8,$E05498FB,$9ED839EB,
   $E2D22BE6,$5920D563,$1F35034F,$CA9F5968,$73EF5C6E,$11E87C43,$366DD5EA,$97C1E8EF,
   $C0483EDE,$ACF0A417,$BAE31230,$D26EF42F,$067F2027,$BCFDC16D,$993AA4FC,$BEC2F31F,
   $8C8EC7DA,$45AF1CC0,$0A816069,$31F2B6B7,$F39FDBFA,$D9481759,$E4AD0BC1,$E5DD140E,
   $3CECB583,$A6335E58,$DCB82D78,$38EB67B3,$229A1538,$F5D07174,$B61D527E,$5F6183F5,
   $82F63489,$0F588792,$92F86761,$164C33EC,$3956854D,$444A05F9,$A495B28B,$818DDB03,
   $EF6FC85C,$4D53D4FD,$0CFE404E,$8D0F77DA,$DAC70D5F,$8416A6DE,$DF7D3D91,$666FFD7F,
   $FADBAB7A,$B63E3B22,$C38D2E37,$F2743EDB,$A3A93158,$A40C6C2A,$558CDA6C,$9F3D20D2,
   $6BE6DCF2,$FEF69202,$4E404A19,$2EA7545F,$31515639,$B2405FC6,$53F3FA4B,$23C0E1BF,
   $3BD03650,$83B2E971,$54CF7998,$06415696,$CDF5DD64,$B883A589,$43FDA9A3,$3AD455C1,
   $483F6A3E,$925A9532,$94874746,$AAB1F281,$974257AF,$F435684D,$907ED47C,$D1B4DF64,
   $69606FEF,$390E7E8A,$25A696EB,$D051C65D,$659E2FA1,$B4010950,$A86BF2C5,$0C82ACD9,
   $72ACFF9A,$88940A07,$76556CA0,$F39127E2,$5F0DBA05,$AECF9665,$2A9DC64C,$03DA2B4B,
   $3DAF1677,$3F4F281C,$74D3DFBD,$3469CB6A,$5CC8AAEC,$F04B0CA9,$44C12A70,$1F55E2E8,
   $5AB78ACB,$4CB6CDC4,$E3918812,$C05CA327,$A9285131,$95FEDA9D,$782D9FF3,$B966BCB0,
   $8934F714,$A7D64761,$7169EF73,$D61090CB,$F85D1867,$71C6D7AA,$329446D0,$ECC4C50A,
   $4038B94A,$6450CF0D,$6D99FCD5,$420B536F,$33D7E524,$75B8B34E,$7CD40CC9,$C2639155,
   $D9021DB6,$DA923C12,$C5F20E10,$4E89FFB6,$D6394D11,$0919D104,$EDE97B41,$8AAB3875,
   $0BC2C39D,$A88EC0F3,$4F03E9ED,$B7DB221B,$0286B31D,$C7F8EC88,$FB98088E,$2F424D66,
   $9AFFB415,$E04669D3,$887754E0,$3EAA3125,$03C510E9,$5E849ACC,$8E0874C7,$8257F048,
   $B3A762B0,$BD18D854,$848914AE,$B3A546FF,$7F111C20,$9CE70B99,$1732D03B,$3C950357,
   $7BE88F1A,$E7E2267C,$A12F8245,$63F480A2,$8BB24409,$602EABE9,$1CF013A6,$941BC3A4,
   $6AA57F06,$678AE446,$59729A22,$12325708,$9601F45B,$6D491E09,$2958D6A5,$5D5EB187,
   $0DBDE3BA,$1473019E,$F76648C0,$A24D3ABC,$6F1F4FC8,$85F3BFE7,$63E10F86,$08FCC83D,
   $860FA7B3,$745DAA77,$62A2AC72,$9180BE79,$F05ACB13,$87CC8D95,$2E645576,$78DF06AE,
   $A5D6117F,$18F1AD47,$C10B9D2A,$358CD253,$372E761E,$0EBD9EAB,$BDDF91E3,$F7EF4306,
   $4D855AF0,$7023CE93,$EE2C6BA8,$D42FA2B9,$EB965B66,$3656F918,$CAC95EB7,$9D0212A0,
   $85CAB75A,$2AD930BB,$45828984,$862994AC,$5036EAA2,$7D447B73,$AE14D2E2,$B07F6DB4,
   $C2CE8DC3,$6B08489F,$9E06272F,$9B434436,$75907C49,$AD15BD2E,$6CDA5F21,$DB77252B,
   $665B3F48,$EA85939C,$35A8C503,$C9457223,$B865A12D,$159618A7,$5D8B0918,$69377AED,
   $C774BD0D,$8971133E,$1E76A0BB,$53E32F2C,$3F29A56A,$F8B7C494,$DE3E9E65,$FF138B3B),
  ($FDABECC6,$7C6A2EB5,$752BBEA0,$401CDA0A,$56DC57C4,$19252171,$01D70787,$56DEC6D3,
   $73C6AC58,$41C751FF,$A92CB5F9,$C9067697,$AAA0BC85,$3391C917,$0E742AFE,$AE0A9A4C,
   $162A62F4,$AA8CA972,$2935DF99,$5AA19391,$FE27E5BA,$86FD9135,$1D3F538E,$FFCA074B,
   $24CDFC1B,$0E3CB65D,$7FE9885D,$4384B2E0,$8DE149E2,$C73AC0CA,$45972EB4,$48E5BC76,
   $6EF9FFD6,$BE0D56B4,$C0EF5F50,$200E6D05,$597F7ABD,$E1F17DEE,$0C2F2405,$0243E31F,
   $2741F567,$F4AB09DD,$47CC204F,$E4ACC525,$B83CC272,$348F92C3,$1F645D75,$53837E18,
   $CF4C7229,$D8DA319A,$ECBB9B4D,$81E3CAE1,$EB818E32,$D6E687C7,$8E6D409E,$3DAD7F4A,
   $F053CF44,$28F70B79,$437A3C4C,$493E3783,$461B27C8,$B27203F6,$FFF0E23D,$D02357E6,
   $6F2EF851,$E8D39067,$D49E335F,$26CBBD24,$7B5F945E,$EE164046,$49B80AB1,$4AA65F69,
   $5487593F,$B56C5822,$570B5043,$4FFBE7A2,$3C93B411,$0ABA8563,$E5F5A4CC,$78EC1D8B,
   $15A66B88,$501B16F2,$D27321A7,$271036D1,$F769DA3B,$7FF2465F,$BED1D08A,$35541936,
   $7A8893D9,$B8C88695,$E2CFB1B3,$2FE950AD,$094E3F81,$F90FD76A,$EEE095B6,$2DAAB3B2,
   $5C1E6139,$1ABD499B,$28E2D81E,$0C7F5542,$79049AA5,$425F3915,$95BF01E8,$C3BCF3F4,
   $526A4BC7,$B4B7D3D7,$00000000,$00000000,$2AB9D6E5,$A0362C11,$8C364E65,$91E40619,
   $6B98E452,$454162C1,$6A4FE3D5,$139FA412,$06ED12F8,$01DB8BF5,$B648E88C,$9A85088F,
   $9CF13E69,$3AB3249E,$E143B8CF,$D57EEF2D,$4CD91135,$B1EA6B1C,$E9DA80C9,$7AAFFE94,
   $04B61C03,$AD92F2A6,$207BE018,$A3AE44FB,$65ECCEAC,$EB4BF88D,$9F7D3715,$C0249B1E,
   $1A0546F1,$A8CF4A6D,$8B0C5B1A,$C6E14B3F,$BBB0CB0E,$CE182D43,$17FD6573,$FC526FA1,
   $C2B451AB,$8C471456,$025B0EFB,$AC497953,$185E480A,$0486333E,$5031453C,$18FEAA84,
   $2C54C41D,$A1EDA7E4,$14716C0F,$06C5D021,$1EB35AF2,$055DB8CB,$412132B7,$E5774ED0,
   $B413E677,$36CC71DC,$67B7C057,$470281DE,$251AFB9C,$58E2708E,$1CE85409,$A914C198,
   $40F63530,$B3A98803,$BF06D70D,$638ADFE5,$3A7EA6E9,$0B610E96,$86F47898,$927C6EF3,
   $719DA2A3,$ED8E28AC,$CBFA6E2A,$7548C33C,$35DD8B90,$F3B55209,$C4594353,$8D9C9FA3,
   $A68F9880,$31D22A08,$2E0FCAE6,$0DA4DEB7,$C8766756,$8FDF7CBC,$3BA9A16E,$5DBFC845,
   $CE9B75AE,$8E04F749,$E094BF48,$83A029FE,$32E79EEF,$A4B01F2F,$486F0D36,$1C7899BA,
   $AB77BB02,$654F0FC4,$FB46FE3E,$7DB1A540,$134B7970,$51C09D07,$A50391FC,$CB459588,
   $8242649B,$3FEE9C55,$1BD24176,$FE118CBE,$C13858D7,$76D0ABD6,$316B9793,$5E27A0AF,
   $8395631C,$69305A86,$9A1C2C91,$3B68AF6B,$9BCB2B16,$6DB669B8,$3825A812,$A72877C5,
   $F532D4C0,$D3BB3F0C,$97E40F13,$6FF58AA7,$9EAA3092,$96FA5DCD,$E80D874E,$2C713847,
   $81CE6DE7,$C57923D5,$FA91F9B9,$2B6F6393,$365182EC,$0922ED89,$AC4DAE7D,$324A42E2,
   $74FCB927,$16C21CD9,$9468066F,$95623527,$EF379231,$7B747561,$6D75F6AA,$449AE934,
   $21ACE79F,$F5708228,$23F7E964,$5939FB7B,$E318B634,$7937967E,$F208C1BF,$84BE722A,
   $30BC9014,$08F9667C,$7DB286A6,$EFCDCBB3,$3EC8BAEA,$A6F3FC30,$6301DC54,$EA907378,
   $B9EBC5F5,$62515410,$F3DFC638,$D260B4F9,$AE16A086,$9E033BB1,$90DE1A6C,$38F0C781,
   $93521310,$C2677801,$EA5689B5,$80384114,$B0A5FA74,$9B5E837A,$2D83C39A,$F7336137,
   $A0628A78,$3009A1FD,$E7AEAA37,$D4A564D8,$05611B84,$FB4C3475,$2FD8CD61,$5B7A1864,
   $CA2D69AD,$239605EF,$0FA32D79,$F8D45C9F,$704AA524,$BB50EE7F,$96330894,$392B4C74,
   $2220EEE3,$0FE73DA8,$B2FEF48F,$3717FA29,$33309968,$F26ED9FC,$ED6C9CCA,$D73D0C32,
   $C363562C,$DA99D285,$DB3D1E26,$DE1FE1BB,$DF8B0225,$738D131D,$F6BEDDBC,$292C808C,
   $62D6DBD3,$BC4EB5AB,$0AC236FD,$039868EA,$B79FEF0B,$CC5BCE5C,$4A3403CD,$B031E0E9,
   $87237F1F,$C4A2A820,$58A87D3A,$B72FBB3D,$08993806,$AFD111B9,$857871E4,$68EBD173,
   $A4D4967B,$9D9B535B,$69C3EAA9,$E9081B92,$D3A42620,$71CEF002,$80196A60,$93A7E506,
   $DC070B59,$891AAC9D,$7E3E8FDA,$155A7433,$51E642BB,$4E206C57,$9847226A,$9721D638,
   $6CA2F12D,$12442FE7,$DE5C05A2,$2553D5CE,$2696F2E0,$A275CF0E,$D8B1175A,$24885E3B,
   $A7589F07,$670CECDB,$CD177CD2,$749348C9,$AD9AA9FA,$64948431,$FC7CEB41,$2AB4E866,
   $4BE3044A,$E6EF263A,$4D0E16B2,$E734ADCF,$8ADB5C9D,$903F8DEC,$3F1FBD6D,$F02D3AE3,
   $D96610DD,$725698E8,$4E821FCE,$1DA3124F,$7211ABDF,$1719972C,$6660C7D0,$11DC470D,
   $7770B05B,$EC55A359,$6814ED2E,$BFD6DD41,$073A157F,$57054D26,$44402933,$1E3B7AA5,
   $3786856B,$5FFC2B5A,$B329F308,$61C93CFA,$84AF7663,$3E3517A0,$2B6ED162,$F6E8EAC2,
   $608DD528,$1007CCF8,$A1B58DFF,$66D7672E,$D0282F5C,$8B594F82,$42AD3BCB,$1FE0F150,
   $4F551849,$4B7DD49C,$5DC966BE,$4C638F48,$BD5DD9F6,$CFC3A6B6,$615AD2AF,$46D90A2B,
   $F4E5D347,$8565F9DF,$92851497,$94B9BED2,$038C097C,$FA97BF80,$7C658121,$B9130D60,
   $D7123A23,$DC5C02A4,$CCC07B55,$224D8E1A,$F8CAF742,$87261AC0,$C9A160D1,$D901BA6F,
   $10C7700C,$AB572287,$C6024DA8,$21D5E6F0,$BA67CC89,$98C6EB90,$E679ADB0,$827BA20B,
   $BC8ADE71,$991D6065,$0B15317A,$5546AE39,$340A8C17,$A56B94DA,$129C7EF7,$071E5BD4,
   $5F926845,$E02AF61B,$8FBA4719,$6B73B999,$DDD00CDE,$DFC46A4E,$C7D54A2F,$770B2023,
   $F184C8C3,$7E29CDAA,$76A7B7DC,$BA8B658A,$A2398483,$9C40D8AE,$A8FBB27E,$9FD8B044,
   $C58E44D4,$DB425970,$53BD4C40,$E2691504,$88805266,$3C76F4BF,$39F2AF95,$F1F6B116,
   $0DF82382,$549D25CC,$5B247446,$4DB804BD,$D6C53DA4,$8A82C477,$19894F8D,$5258F5ED,
   $91091DEB,$6E2E0152,$999025ED,$C1FF10EB,$643BC92B,$BD953E5E,$AFC1A701,$C8DDFD62,
   $3D44B396,$5C6443B0,$9D2639EE,$6C6DE24D,$78D39D22,$1481FFC6,$F91DF0C5,$D1F8DC13,
   $A3EE8304,$CA9E1E7D,$D1FF28DB,$DD878951,$B5C4E1F0,$6012B70F,$5AF373C1,$1B66C26E,
   $55505EB8,$E3B29EF1,$D54934D8,$70157BF7,$E422A34B,$2E32DB58,$895755E1,$6AA8326C,
   $5E456FC2,$B6F430C8,$1110778B,$FD89E454,$DAEA19A1,$88C12768,$B172FDF3,$CD8045A9),
  ($6655B742,$99183E61,$A50D6860,$B2872032,$060528EF,$0946F63B,$141EF07D,$36612B9A,
   $DD49579B,$0634DA84,$486C8A57,$FC9C9E9B,$744E6FD0,$A63FE3C0,$D8B46BF9,$F1515758,
   $CD5197FF,$3E82559F,$2BC40177,$92E12D26,$5A7752C5,$C3BB433A,$5183267A,$21C3852A,
   $CF528F09,$39130725,$2DC12998,$9BA7DB1D,$873E055E,$C58F99BE,$8F32656C,$D9D42449,
   $8CCA71E1,$27F75FAE,$A8FC3430,$59B91019,$CAAFB36B,$CE768AF9,$F0887E03,$9D930199,
   $F3706A8E,$63B07A7E,$A70E7096,$B5167288,$E967D22E,$40CC1A28,$79BF3380,$4D01D3EB,
   $6456AFB4,$9E896CDB,$C75EEF3B,$2548BAD2,$AB0420BD,$A79A6BFE,$BB1CE0D9,$9F2CE4E5,
   $82C3393C,$32EA1462,$F7765A97,$6D67DEFF,$B31080EB,$83775912,$4E69A2B8,$F5DA68A0,
   $98D4819C,$11967434,$4D91B635,$0BF91347,$7DB90399,$43D6776A,$7FBA1B6F,$444725D0,
   $2E393D15,$6584A0FA,$121BD892,$3F27DDA1,$DAB7730F,$F6C005E2,$73B04B44,$56CB3CA6,
   $F1737278,$642128C4,$35D589CE,$BF4AE9F1,$EE99F6BA,$B038C54E,$9123EDD5,$F47FE09E,
   $69A7F3E4,$75B75CF0,$1FEA84C2,$D419ED8A,$B4EEA47F,$73838674,$EF62FAC1,$498AEC13,
   $8EC96917,$20660D14,$3FDAF10A,$A48006BC,$55851663,$2F1421AB,$92DBF958,$0A5C9B79,
   $567D02EE,$D1375A4C,$00000000,$00000000,$17E6E4F0,$C842507D,$9320F523,$F3EEB224,
   $C8ACAB9D,$C9E7D843,$DCB25BE0,$FF86F3D9,$78443FFB,$B4B3FAB6,$31D3B9D7,$B19D4D70,
   $26355D27,$79DF1D0D,$23C86145,$8EBA90D1,$3BDCC113,$AA57A23D,$83383547,$CB583D3F,
   $50782A01,$D871AC77,$9F2AA508,$E162AB52,$1018C064,$38B68F1B,$1A17B8A0,$237C6056,
   $3DD9E9FC,$A3115406,$FF7A3AA5,$713C6308,$D54537A9,$1A6F6773,$D94F6782,$08E37E05,
   $80C021CA,$357B46D8,$283C15FA,$6CC256C1,$15E5FC06,$CFD302C7,$7E411714,$BDF50C8D,
   $6FA2DB0B,$7CF1AACB,$E56D8205,$5240035E,$6DA1C3FD,$7B60F871,$DF4A4F6D,$01A5883E,
   $19EFAC2D,$DD5F1BB1,$3824D59E,$5474D9DA,$DB4C7F74,$0F722CBF,$459DD607,$17A2AEB0,
   $CB54BF10,$37C4A3A4,$853D1DA8,$C21ECB04,$A2F34CF4,$4273FF54,$1BECB4DB,$DACE490B,
   $F5754261,$6AF68C45,$342E85B5,$46F8C0AC,$6E59D770,$85438396,$F8841E31,$81C8BC6E,
   $84C611D3,$3BACE259,$479ECEF1,$1033FC0A,$080C6032,$1C5BBDF7,$B6EDBC89,$7412D4CE,
   $70485FC9,$A8E84741,$37D69138,$B8DBBB4B,$020318F6,$079152BA,$6BA4EB12,$72260E4A,
   $60509FAD,$905EC85A,$1E1188B9,$2DABC4D7,$89374D83,$D092D272,$B8E4F454,$610F9F02,
   $4B949EDA,$02BFE57C,$29C71981,$95707F9C,$BCE2C44D,$6FD83B83,$3E21FD71,$5D322FE1,
   $5F8A6EA7,$34DECEE6,$5E7162DC,$CD6CE7BB,$4A6F92A1,$FB0DCC21,$8ACF590E,$2EB1A995,
   $C6A5E340,$DCFA938F,$BAE7ECA2,$669ECDB8,$0E0948DD,$151D4BCC,$9726C53A,$FD3916A5,
   $77B67B5D,$581C9827,$0A0F78C4,$1BCAEF4D,$527B32F7,$DFE0FECD,$0C0A502B,$128C1976,
   $B113981D,$84E60BA8,$86C50925,$3C3DB0E3,$FB7C0ABC,$7FEBC789,$B0E89466,$7D5422F5,
   $8B345575,$D70380C8,$A308408F,$BBC1D609,$0BF474BF,$E278C610,$AAFF2CC6,$5E2842A3,
   $2A3F0D0C,$6B53047B,$05FD3C62,$F7658DDC,$F28B66F5,$9A025323,$685CFF9F,$8C0575AD,
   $FD792253,$76AD31B2,$BEE1DCBB,$68496939,$243645D1,$7E4E4FB7,$D6BD2324,$E44C1C94,
   $EA9FC6A3,$BEEF61CF,$BF1AD0C0,$91FB4064,$4997862C,$052EB7C6,$7BBC2B76,$4A908151,
   $FC822E28,$8F1F18EF,$5B8C5EBE,$3A096A67,$4466DA7C,$EE1087ED,$53803E8C,$2652D790,
   $203075C8,$7099EB36,$CCAA9B84,$C7307CC2,$E16BB21C,$5C97A7DF,$AEF91CDF,$50FFE622,
   $B716B0F2,$8DA0FD93,$61AB93D6,$69ECE107,$161DE88B,$31F07920,$D3401F46,$13299148,
   $94DED1B7,$031A6D42,$813B2DB1,$CCC96F85,$D14307B0,$14B8C3F2,$FA8706C7,$8659EED4,
   $7C420FE2,$BA645E37,$88CC41F8,$2920FB2F,$25CD49AA,$87FC66EA,$4398FEE8,$1EE4588B,
   $0FF244A6,$ECAF6291,$DEB14316,$F817A163,$A0F05402,$45E2ADEE,$27CE515C,$806D3450,
   $ACFA0429,$576EB498,$E090BE67,$A5258E82,$21CB79B3,$892BC26B,$63A88B20,$6E7DB3BD,
   $ED61E237,$4E1BBEA9,$39DFD9E5,$ADC6F087,$6A5FE769,$8B942717,$764D7726,$A1AEB17A,
   $A4F6641B,$4B35096F,$C55DF7CD,$22D9E868,$E76E9AF3,$55D151E4,$BD19C836,$966A12DE,
   $90D8E1AE,$0DCDC9C3,$4C6ABA4E,$F24B3A1A,$1814A056,$24ED32EC,$724B473F,$AF7915FB,
   $57860E95,$28857311,$2FC2316E,$9C3689A7,$EB64CAD8,$475D4892,$E6959688,$AC6378B9,
   $A907384B,$A00B3944,$13E0D4E9,$C695F4FC,$C957A7E6,$3055F11E,$2C3A25E3,$6215F240,
   $8D317D9A,$DE4576F3,$F48E4E1A,$9344A518,$6C5ACF86,$82D2D12C,$9B2C9511,$EFB50FD3,
   $4665C28A,$E981D557,$75B563AB,$5F8DCA9D,$33D0A121,$B60C1FCA,$03F8148D,$FE237BE7,
   $547E1A18,$D6A608F6,$E89CDE55,$B97E3375,$1DE99C34,$D388BF30,$E368AAEA,$5B06F565,
   $07FE2494,$F0F4DF66,$9AD7996A,$1607268E,$AD010852,$AEDC9DC5,$4060EA65,$E0C7236C,
   $D2BB133D,$EA9BB815,$FE8136DE,$888E4A55,$3C22E587,$5AA37D5B,$11E3CC1F,$C104A646,
   $71B353B2,$515A6E1C,$58744A33,$C42A1180,$22336D3E,$7708B98C,$1C12904F,$2A3A966D,
   $B515A804,$8A31AF29,$D0B80BCB,$ED0AEAAF,$C15BC7D4,$2C0E4CE9,$4F92AEC3,$0C6841FD,
   $B91FF82F,$98BDB65F,$9CD2B185,$1F41D0B5,$7A47270D,$B322A80C,$9D29BDFE,$E6F3F9E8,
   $B2EB8C90,$7AC5704F,$AF0210A4,$A94DCF7F,$F97F124A,$787A9533,$C4A6FBB6,$DB6BC135,
   $96DDC941,$048B3FF8,$992F8DE7,$E8245D69,$D4BE3BD2,$E3DD4E2E,$5C727A2A,$CAFDB501,
   $EC9AEE4C,$B7A997F4,$4263F293,$E75671D6,$C358DF22,$2B9F1E53,$9ED1A973,$18D0820F,
   $E4968E7E,$ABF22A03,$E293A691,$A2B4DC38,$65ADA3CF,$673B4586,$01FB0C7B,$F9B2295D,
   $C2A3D359,$D22D370E,$6253875B,$97CF9AE0,$04063019,$0ED7A481,$3028B5AC,$482F642D,
   $CEA98372,$C0A12E78,$322BAD5A,$4FBE3697,$419BE61E,$19750A31,$362D9D43,$41699216,
   $C0A0CBAF,$D5BC65B4,$09F76C49,$E5E994AA,$0DF15C50,$EB3E302B,$F68D56EC,$94D5F7A2,
   $3A27CD68,$53E58B60,$598F4648,$3D9838DD,$67AEBB39,$60AA173C,$D7462F5F,$1DFE35C9,
   $A6F57CED,$4CA45BD5,$A10B5879,$BC5084B3,$9525DDCC,$FAA8441F,$5D897651,$334F9C5C),
  ($83ADF27E,$DA1687A8,$578D9F22,$E35C9378,$1637FA40,$303CA453,$74B20375,$A088321F,
   $9ACB95E9,$C9863F3A,$7D0B0ED4,$5FCF47C5,$E1280B4B,$4AA211E4,$871D1289,$E1A4C9BA,
   $59F03A4F,$49266647,$E3707BCA,$ADFB36ED,$1F8EF7E1,$CF7BD189,$8F882792,$9735559E,
   $F84E6CDC,$5932A976,$F547818A,$9DC792BE,$85456208,$06FDEEB3,$1EA2CF5B,$46AD3877,
   $1543B27B,$5EB36AA4,$D1BCB511,$8B2EB33C,$E598EBBC,$71105FF6,$6F8C1463,$5441AD84,
   $646D6943,$4C5FFF57,$F633C9B1,$F3485C49,$9D0F3D25,$9CBBBFDF,$67192178,$22D031A0,
   $2213A4ED,$CA024899,$63A9C18F,$19627FB2,$DA5DC831,$9330E1EF,$19666797,$1390B892,
   $9893E568,$2EDF1833,$D3E4C590,$6C779435,$8281CAC4,$53C06E56,$6B3CF494,$6FF3E396,
   $61F1B10E,$FE3B58BB,$60DD89B4,$77EDB145,$D0908DAB,$02F85AC2,$712EDB38,$12EC95F3,
   $FEA6FCAA,$85D9C06D,$6285F935,$90B4964C,$26A3441A,$F1B0068B,$5D40DAB8,$72942855,
   $C5D33FD0,$5C4B3066,$AD9B837F,$5D371D07,$2167ECD6,$A48D866E,$504937EE,$B661139D,
   $A4228EDE,$A27068DD,$E4B4D306,$F8C6B608,$3EE91B37,$6BF657E7,$8B38C765,$AC871B8C,
   $B4FDE4E8,$4EA7A595,$97C278BF,$0D7304F2,$38018B41,$B71D3EFC,$5BA84ACE,$AE7F414E,
   $33E0F661,$AF036C2F,$00000000,$00000000,$7F537E55,$B89660CC,$F1F7617D,$A675DCAC,
   $4426BD2F,$610490C7,$3094BE5A,$C18CA2D8,$CD460ACB,$2ADAAC42,$1A122FAC,$7D1F7665,
   $654151F9,$C58916A9,$7897D699,$EDABE029,$204BD46C,$2D5B6F90,$32CCCEDB,$26D585D1,
   $25D70C21,$9F3FC87C,$DD9960FD,$C60D610A,$C33BAFA6,$80A0597D,$F9625466,$D0E44088,
   $367C2E2C,$1D67CBC3,$480368C3,$2C2742F1,$012C38BA,$89D6E9FE,$2D42393A,$E9AE5458,
   $392DB3FB,$3ECBD702,$E89106EA,$B5E5643E,$DEED28C6,$A882AFFD,$DB71F08B,$1AE60811,
   $B215749E,$924CCC8E,$B1613CA5,$FCC30279,$13AB220D,$825803BF,$3B75C37A,$D992F00B,
   $F2832946,$C8FA125B,$2BAAA94C,$35453D43,$8CFC6FA9,$F9BA9B69,$FB3A24E7,$37BD6781,
   $4FC7C00F,$791AC214,$24FB349B,$16E92182,$EBE54ED1,$DB6AAAC9,$533D7FD5,$D8EEDD6A,
   $725A9303,$7C635B04,$07C4A8CC,$553D80E5,$184A5F2D,$9A46516C,$F46BB930,$14117B40,
   $8EA41F28,$1EE3BC60,$5A847274,$27A9A8B0,$9BE7AD53,$4050D6C4,$9F574DA4,$7BE298D6,
   $56A1A798,$6A8A7A86,$0C25D5EC,$4D23D236,$A1BE5693,$1014CF31,$059CD84D,$B264A7EC,
   $959A083E,$EA2A23FB,$4EEBF8B5,$F0CC2BEA,$0895351B,$76919C24,$12871AB7,$0B8EEA41,
   $76EA73F4,$47D11516,$42CE2D59,$BDEFF9DC,$A50EB664,$2BA68123,$3D9D530C,$05799910,
   $02587081,$E7592709,$A8075B32,$EF53BAEB,$DCB55847,$4FDB88F4,$0374483B,$6E8FCEF7,
   $C9F6EA3C,$1168E250,$B3394C24,$1B9A2570,$8DD05713,$706C7297,$467ECDAE,$865DB7CE,
   $EAC9766B,$52BC4337,$3A59FBC0,$504419F5,$84695AB2,$8F2B074D,$2C6E0180,$6078BDA6,
   $233F9C57,$43D4A167,$2F1A49BB,$0EF77351,$FF8AC410,$0C0F2993,$8960B7E4,$4BDE3C85,
   $A92B6388,$66855315,$41BA6562,$D360372B,$9006D073,$584E8417,$7002E382,$9B3A7C0D,
   $492F5079,$A5F1AB0F,$1DD68760,$2822F680,$CE3242F0,$445562B5,$0E7DA56D,$AA7AF53F,
   $E9BD3E50,$3C338DC0,$04B0E0F7,$3BB24E12,$C4FF076A,$D59DD998,$0ACD459A,$91C8BB2D,
   $96EE4005,$84A5ED0C,$AEEFCB44,$33B8D3F0,$D7542567,$57C5DA27,$C6A777EB,$32C4FE91,
   $43E215E3,$34391022,$B5D1DC52,$C7714C6B,$51650F54,$3FB7FA63,$2E367101,$87219AAF,
   $7376ABB9,$F5B5B2FA,$F3AF11FC,$412CFBA5,$06E89076,$DCEB691B,$C78B4F51,$BB12176F,
   $35086617,$73E80534,$3FC5238D,$E220BE19,$D50C55E6,$B09CFD2E,$171BC2FA,$B9EA4DAD,
   $4D9FB08E,$9E43E51D,$93729848,$36C14AE0,$B6A59469,$A9FE829C,$55D5EFA3,$0405B471,
   $7ACFA618,$0AF2C720,$A2CA1EA8,$7E9B01C6,$6EA02CD9,$DD97447A,$ED0DDEA7,$0781C3D2,
   $278F7CA0,$7866EF75,$912AE8C9,$D1986DE9,$4A5B1842,$CB7E65F8,$CF1E7A4A,$CD838B4B,
   $663519C2,$AB06D85E,$ACB7BBC5,$D4E1F4F9,$D929800A,$FDBF2F18,$9E7B751E,$F2347128,
   $2A8691F6,$BC93D4BD,$81F582FF,$3D4FA0A1,$AFC3F3FE,$BA6E3A0E,$40965DD8,$5AB6DED5,
   $FDD2B491,$EB560E9A,$C217971C,$0976B083,$10DF6A36,$ECD7CD48,$0F519DD7,$23AC1CC1,
   $FA161C5D,$BE6B8E7F,$CA82A207,$7FE72CA7,$58DC02F5,$C0F08FB9,$F71FF10B,$7A9EB5B7,
   $99BFDDD2,$A709F1CD,$54F9D719,$8DD35D8F,$3CB16BB6,$8CAF70EE,$BA804185,$E4DD50AA,
   $7BE39EA2,$83242EDE,$C8DAD286,$98BE0BAE,$EE79969C,$690E0D25,$5F18AA39,$95CD0F5C,
   $BF1C99C8,$56B9F746,$D805B8B0,$7469C6E6,$B9F409BE,$8A529E5D,$6A10CC2E,$E6250A68,
   $F0DB59C7,$2FA33552,$4B7720F8,$42A88C06,$BBAC793F,$6D0BB954,$0BE17D20,$181E52D3,
   $925EA0F2,$BF17A31E,$37501696,$94B1223D,$450A8595,$E8D27939,$A756C6E5,$CCFFA62A,
   $BC68D1F3,$383639B1,$C04FE79D,$EE2F978A,$CC6A3271,$A30C45BC,$E6ECA387,$1F9F9101,
   $BD44E949,$B1E0D04F,$E25C4370,$242DDF13,$9C23059F,$156D5621,$69648415,$88AAC49F,
   $FCFE8C2B,$6280E764,$BE30A172,$DF6F1EB8,$D2C8FD2A,$E5A17DCB,$EF55AE26,$E0D8E4DB,
   $94B63084,$63FCCA05,$1CFABFDA,$A1F41F7E,$759E3BCF,$295EDBE1,$C163DF27,$67F97E74,
   $B8D83104,$038477A3,$D6781DDD,$DE1333D9,$6CF85C58,$3ACE6373,$7C27366E,$D619AE3B,
   $28DEE177,$5BCAF3B4,$6DD464E2,$B3188A8D,$5E349283,$1C1BE6A2,$6848BCAF,$017C2D61,
   $EC21E61D,$8E572A2C,$CBAE9ABD,$F631C559,$AB731309,$81DC741C,$09B90DA1,$FF4775DA,
   $80D9BA45,$B499495F,$4752F514,$0F8B5E30,$D4206D5C,$394A14D0,$77C64B4E,$CE07FCE8,
   $1B3E1716,$F4C99F9B,$0D09ED56,$C4F53BC8,$884C8F5E,$C208D57B,$AA5F2BB3,$080A9DE2,
   $7E7F46EF,$31408932,$34245EAD,$FA3EECCA,$B789ACD3,$20286B62,$B04D041F,$7515EB87,
   $5211476F,$51383494,$11F3528C,$650124B6,$4CB38834,$17950CE3,$A67AFE5F,$45294FD4,
   $DFC1107C,$21544603,$31B886E0,$485A4B26,$86312A33,$68722044,$79BBEE23,$647D09D7,
   $8A14FFDF,$2551F272,$146F8AC1,$D765835A,$29F2D9CD,$D21C1A4A,$A0926E29,$99C226CF,
   $5C6CE202,$FB42C1AB,$E00433F1,$C374F81A,$E7C09B3D,$964978FF,$A3E62612,$F74DE838),
  ($B0592C6A,$74B87B36,$FFB4B81C,$3D82D75D,$15267825,$88842467,$7ED4E5DE,$DAF2D8A7,
   $0E53F9C7,$FEB11865,$59226B06,$BD2D1AEA,$DBABB191,$26CE87F6,$EB66BD0A,$32772ECB,
   $C5104C8C,$D4BBF82B,$0C4E03A1,$05535772,$32D0F6FD,$EF5BE62A,$5D186ACA,$BE1C84C4,
   $65A1643C,$ACC7E4A5,$19687B84,$8DD77315,$3C830F3A,$11EAFE4F,$A358AFE5,$04EF8E68,
   $534B930D,$40AD9CA1,$855A5C0E,$E44191D4,$809420F1,$6001D20B,$173B8243,$73666B70,
   $E728BEAB,$372479B9,$5F0590AC,$45FECBD3,$1301838F,$7057F55E,$A1455583,$FF0DC17F,
   $10E804DA,$0CC467B8,$FA7AC4E3,$B9C29482,$754960E6,$A003831D,$BE0AD5AD,$8A096353,
   $D9B64BF7,$DD2CC8E1,$52BFEE3E,$C7DC4150,$21D17572,$9F0C1374,$4C041323,$35A93E8D,
   $2D9F76D3,$9A5F4406,$BC172FCB,$71EB2C44,$14D20516,$0FF5F996,$B4632DA6,$7789E518,
   $E97B476C,$C99561DC,$6BF29DFB,$5276FCC0,$4BD795BA,$4A0B3245,$9E2FDDEC,$9274ADD6,
   $4799961B,$4F586537,$4DF06E10,$B2D8E37C,$5685EFF2,$C4EDDF7E,$E2E6C254,$B3643A66,
   $6A06E0C8,$D5072131,$111C79E9,$8BB5BA49,$6455190F,$2BB63954,$0627FBAA,$F8D3D139,
   $F3FABBBD,$38D1802F,$729AE67F,$DFA18FD5,$E88F3A5F,$4EE4BC2D,$12F5FEBC,$F72628AF,
   $189C06B7,$0AA6AEE4,$00000000,$00000000,$8EC7D936,$9EB0CA6E,$4257EAE4,$CB1826E8,
   $20250841,$187DCE85,$5EF1ED9F,$C28F1622,$F1E741DB,$C333CF38,$F8673E85,$4220DB95,
   $76A0E7B3,$DC9011FB,$9395A37E,$10562755,$C70DB6EA,$2F59B73C,$89145FAF,$E112C6A6,
   $0DBA7E92,$82228A83,$681B1AAE,$2EE56E26,$CB43B54B,$2A0AE04E,$F4293D24,$47738CE7,
   $D22BCECF,$A7DD935B,$CD644EE1,$D2D93177,$91885918,$EBB46842,$BBC4A952,$0E49208C,
   $79076347,$A550D46F,$FC5D3F49,$411145BB,$2E76F186,$E6CCD6E0,$E4C139FE,$4BB7EB5F,
   $7F2098ED,$5D830556,$394D73C5,$95AABD90,$DF91B05D,$25FF19D8,$AEE2D177,$86CD04EB,
   $043A01CC,$03319E2E,$371E8A02,$6B1BA5F5,$1B7581E2,$76353C02,$23CC8F14,$64EE5C63,
   $D03634A9,$5C3FDC4C,$9C32278A,$6996E2C1,$BA30D461,$8938FD7D,$A48B297C,$7B4D82A0,
   $F20EC68E,$BFA05DDE,$1D527A48,$8EE6ED3B,$2F828CB5,$61BD0B11,$88E0229C,$66631B57,
   $CC9033D2,$55A8EC86,$837DA7A4,$1C9240ED,$9FDBA0DF,$15057027,$C4E431BF,$53CA25DA,
   $6E3CE104,$D636BF1F,$ED4146A0,$CAA4FFF2,$A0B128B0,$787C1C8E,$CAB7C878,$AD7B3DBF,
   $A57F544F,$FC3C5F51,$41BE6DB1,$B78BB40E,$B67ED7C0,$8C6BAA0F,$4E19E945,$CE4B719A,
   $A93157EE,$F96F0823,$ACFF2B11,$7D2F4BFC,$FB8EB9D0,$3EB34973,$2238F227,$E39F8192,
   $D7E5B230,$239DD084,$8747A668,$1FA3DEC3,$F99343B6,$C5510664,$466DEB28,$C829B8C6,
   $AAD8D0BB,$85FC9AC5,$EEA8C1F5,$B6376D14,$8AFDD8FA,$9D815440,$F7C0BA71,$3BE01E01,
   $2BB88D79,$628C953F,$3F6A886F,$6D796CA9,$AD0B5622,$FA5E960D,$2A4CF04A,$E5FD48CE,
   $81605DC2,$E7700FFA,$6C211B62,$2DD4F008,$78F31E74,$2221099E,$D1C2499A,$DB4E01BD,
   $16CFFF70,$F417B681,$EA92C039,$B506F33A,$6FC89C37,$514762EE,$25EB74BE,$9C3D8D5A,
   $5CEC17F9,$396D5935,$E53544CD,$CCC636AE,$B78AAAF3,$0B1A77FE,$3AA4F490,$E9392F76,
   $6DD56651,$AAA52DF9,$5B3F9160,$46CF55FD,$D611CF03,$A4EC0D75,$619B65F0,$AFF67A8B,
   $E312BF67,$3415E797,$0B9D8538,$7AF15BBA,$09807F5E,$811314AD,$01F47D33,$8771DDF1,
   $3D777209,$969B23BE,$6272E2A5,$D365E86D,$736E9B4C,$58D05224,$FDA9427A,$C660984A,
   $63869F96,$5414359C,$95B258D4,$E885F66C,$8CDA2350,$65528579,$907C242B,$6CC5B5B3,
   $944625E7,$6FF42B9D,$F5DD4017,$C0025116,$DE65CD6E,$A28EC429,$84AE213D,$63304C25,
   $07D38699,$7FA20CC8,$29A5771F,$996EDA28,$241F098D,$1B4C50AB,$28510A2C,$1E1F07D9,
   $4470114E,$33CBF7D1,$E6DCC398,$B055A448,$86B3DB5B,$98D20332,$36EAF731,$EC6A7804,
   $DA5FCCA2,$A1BF5A07,$FE40C52F,$BAF30AAC,$1A81FCD1,$F144E1F3,$2602F3EB,$E0AE1FBC,
   $30CD0C9B,$14B9A93D,$DC783708,$596C8B3E,$33248BCE,$682A3BDB,$556C68A7,$B87E4D98,
   $A696D31A,$80AFCDB7,$67BC9E5A,$5725ABB2,$9A15DC20,$914533F8,$7B1A9921,$5EB29B78,
   $AF16AC44,$01BCD91A,$5ACBEC53,$C1BE880C,$99FC5B75,$EDD6A11E,$AB2CAD88,$028D4734,
   $B244D60C,$8F5A3421,$ECB53B93,$4DD52203,$54981594,$3F0F9069,$CE8DC9B4,$AE4AA391,
   $483E12EF,$3698A0A3,$B9D95334,$F5AB6F9B,$B3B0AB3F,$082BE9D0,$C95E4F2D,$D1E8AF59,
   $D5F84856,$D87F9F93,$3B5089A3,$6E48F287,$70871C19,$2443C0C2,$49CA6FDC,$B1E97D52,
   $03E98755,$7C9392E6,$A2ACD2D6,$839E5399,$8F33A405,$19C1179F,$DD8C4A3B,$DE1D56CF,
   $D3DFB3FC,$20AC4EAA,$8B09A5C9,$1AF089B1,$58D61635,$3A5CC71B,$F0133CE8,$444212C9,
   $B82D2E07,$72DAB26A,$43A397D7,$4C69FB19,$B1AD5159,$F3C9A6C7,$2C6B0BE0,$1D2E99F7,
   $45846C7D,$B4BA2A20,$8D2E5E63,$E2235888,$606F18C3,$2887A77A,$C6F9CBD9,$A8286ACD,
   $D40C3565,$5F0E4262,$9DC65AB9,$EEE73F30,$8289DA97,$9BE39D1C,$9BE1A113,$1634EE09,
   $3E9EF55C,$EA08B158,$9261DE4D,$9727FAA4,$C337B726,$2C682912,$E10F4501,$CFF7A880,
   $34F70D57,$17883713,$74BD1DD5,$27725EEC,$EF5CBCC6,$3146B0E5,$1CA6077B,$099730CA,
   $1EBBFD1D,$F2757FDD,$98082646,$6AA77CEF,$5156696B,$BB4FD3B6,$C8AA321E,$569972A8,
   $7173612A,$A3321D33,$C0DE3073,$50FBBBF4,$D84236C4,$5A5D1510,$0A69F80B,$FD80864B,
   $A762AE29,$07DE1046,$7D3D628B,$A6614A41,$C12A4D40,$D78A6605,$27F68ED8,$67DFC24D,
   $F634C742,$BC91C3F0,$6648E369,$D0547643,$4FED9476,$493AAC6B,$38B90EF6,$12DB6061,
   $69EF679D,$A994B3D7,$7CC91FB8,$211097B0,$404A1082,$30FA69FF,$50A21458,$3C3E0E47,
   $1F4F802E,$7504A22C,$05CE7CFF,$844043DF,$B5975095,$F0F838E9,$A8C52ADD,$7E1ED5D2,
   $35037064,$90F9EAE2,$0874026D,$0662C95C,$965BDF81,$9416648A,$BDE352F8,$F69AF1B5,
   $BFFEA89E,$0D78BEA2,$CF79B487,$293B7E60,$7AEEE412,$D9C34689,$021DFA66,$FBE24F17,
   $97AFA2B2,$1367B97B,$C2C3CA15,$AB19F4E3,$E0FB3832,$48867571,$313971A8,$93C874CC,
   $0FA784F4,$79C0C594,$4A23E889,$CD7AEFB4,$577192C1,$439C028F,$77549A80,$5BE1CC0A),
  ($78656928,$714D28D7,$84F64F7C,$C88A7C6B,$AB89AACA,$EC43CAC5,$10DC16A3,$777FA381,
   $E4213B5C,$0F7D5C87,$F3A1EF51,$73F051E5,$C330D541,$EA714193,$E016C4F3,$95E5F3DA,
   $95A0E173,$63D37380,$8FF379D6,$9825D66F,$48F45338,$E8CC38A1,$25F06BB0,$A840B0C0,
   $5F748735,$944135C3,$247AD31C,$74661CAA,$ACD56864,$E7B16426,$6E6F0589,$D1E689DF,
   $C1D150EC,$A73DEC47,$427BDD3E,$64453ECF,$5B43789A,$0ED99A9E,$C05BE840,$7B1B402D,
   $6FE5BD25,$0DC025B5,$4E22293A,$3F183A28,$160A6CA1,$A0ABA108,$05BD4703,$46BE0337,
   $B2B10F6E,$86DF6E94,$9DCEEAD8,$A216D83A,$EDC5885B,$129E5B57,$9C445274,$7E307450,
   $A8E297CB,$7D29CB7B,$0EB871A9,$1611A933,$5EFE3F99,$486799A9,$5828459B,$9FB39B20,
   $D10D464F,$D0424FC6,$F79610FE,$E968FEB8,$64E08B8F,$5D6F8FB1,$AE34EDC9,$AAFDC9F2,
   $8BC48679,$02BD7932,$BB55BC69,$9B3C6944,$2AC2A2B5,$6277B599,$0DD34CA8,$877BA88D,
   $A531DB63,$FA5263F6,$974164DE,$2E9FDE54,$D8E9F548,$CDA14816,$76DD1881,$675C81E4,
   $743C9D2C,$2A102C30,$7DD82E2B,$37F32BE0,$901DA670,$256D70B7,$BD83C66B,$4CE86BCD,
   $0B0536AA,$50AFAA04,$9F2F6F75,$EF5A75EE,$44ADA73C,$B3913C46,$D9634DE4,$1187E47C,
   $EB13F259,$C54A59DE,$00000000,$00000000,$BF6243C6,$01A4C619,$BC097EC7,$90CEC7A7,
   $91971EDC,$F94BDCDD,$814B087F,$8E347F5C,$60D77420,$C7F720EC,$F61CA852,$354E52D2,
   $497EEB94,$34EA94CB,$4D49143B,$AE723B96,$FE72A3F9,$F48BF968,$CD88A4E8,$FC60E8A0,
   $409A5893,$2909931B,$1FEEDFA6,$BD48A6D8,$7181DA2F,$6CAE2F07,$79EFD184,$AD6B84BD,
   $55FB0933,$18C833AD,$CC021C44,$204644CA,$269B56B1,$392AB17E,$857CF7D0,$14ACD001,
   $6236F18D,$8ABB8D38,$204D2CB3,$EEFEB3F7,$75B62580,$F636805A,$CB5EDEEA,$2BB4EA29,
   $DFB537E6,$C653E6F5,$B5EDCDC0,$8D2DC077,$156151A0,$31C1A0B6,$2EF55D1A,$F8EF1AC4,
   $D65184E1,$DBB0E125,$51CCF69C,$82509CF0,$4FA89196,$E33E9642,$352C7D13,$DF3F1341,
   $3E294BB9,$8F90B945,$66010E22,$10232265,$4A15D695,$A5809575,$1C85E2A7,$2C22A766,
   $C46C17EF,$E183EF70,$F22B57FD,$AFD6FD8F,$BADF04C5,$471AC52E,$02E185AD,$4D4CADD4,
   $036B3D01,$916A01BE,$FFF81B55,$28AD5502,$C2BA6DED,$3657EDF9,$5AC9C036,$D2FF36F4,
   $A26D19CD,$F1A0CD15,$5D950298,$D90D9817,$CAD46646,$F7924643,$BEE8FB6A,$DD826A73,
   $D3ECC3E2,$9D0EE212,$18B21D08,$B6BA083B,$C5E6AF43,$3DA5431A,$33FA0711,$08EB11C8,
   $5C1FBA34,$052B347D,$45271F90,$6FB7902C,$52A7CB9D,$133A9D4E,$FA455C56,$6E135635,
   $4CC3AC97,$725497FC,$29A99FB4,$F31DB427,$39758917,$846217A6,$6A58FA26,$4B7E2682,
   $F8A4D9FB,$235FFBE1,$F92E6157,$FF79578B,$6933C727,$DA14273C,$DD54B24B,$8B1F4B21,
   $6C8E8024,$9CAA240B,$086E0BAB,$C1C5ABBA,$8A4E3ED5,$DE9BD558,$A3E7A161,$2D86617F,
   $942A59DF,$BFF5DFEA,$C9BF5B47,$66F847FD,$AD5FD0C8,$3B97C84C,$F1406AFC,$3EBCFC31,
   $0F32C905,$CA370559,$2F7FE5B6,$24C9B6AE,$6D043888,$408C8861,$88AFBB78,$93D7788C,
   $EA994AF5,$196CF5B4,$0437FFAF,$9A98AF5D,$0A8F8E06,$8C89066E,$1156AE0F,$AB590FEB,
   $06D67A02,$D7D40289,$9873ADDB,$E4A8DB0D,$83AA8DD2,$C378D288,$892503D4,$4FF1D4E6,
   $B9B439C4,$D670C490,$FD199EF8,$65E1F8D6,$96CBDC72,$F2B9723E,$CF692145,$B12C4574,
   $63BC4921,$569D2152,$2D9E601B,$69851B7A,$50464E30,$5E76309A,$EF240DF6,$5FD2F683,
   $E2F7415E,$D8A95E0E,$F0CAD250,$E29A505B,$D4B0014C,$96FC4CF1,$E9F277F4,$8806F40A,
   $3FA3F315,$53B6152F,$B686F0C1,$1C47C1C9,$DA0870E5,$80EDE5C2,$8D12FC7B,$D5697BBB,
   $72EAE72E,$FDC42EB9,$075CC2AE,$0BF2AEE3,$47C69A3D,$22FB3DF8,$C835E3EB,$BADEEB97,
   $018AB8AC,$DC26AC6A,$A08C9C60,$BCEC60C1,$E6C0BEF1,$4231F153,$9EA5D7D9,$337CD984,
   $0C59F404,$5B5D04E7,$4B9F6E39,$79A6391F,$80C1B0D3,$5212D336,$2C14D8B7,$B5A3B710,
   $232611B2,$7F94B249,$B1DA326F,$17B56F2A,$879D727D,$59E07DD5,$7C529687,$EBD5878A,
   $7757A02D,$BB7A2D8E,$34A6C5BF,$0319BF2B,$DB82C849,$5CCB49A8,$09E4B307,$1DE307D0,
   $E19C7C5F,$49C35FB0,$571A8C9E,$55849E79,$7F39AB86,$7ABF8634,$37CDF8BE,$9273BE95,
   $13B72BA2,$E615A23F,$92FC23DD,$6821DD63,$B33BB7C2,$5AF9C2FE,$68B97F8B,$06328B56,
   $8E79C17A,$44037A05,$EEAEB55A,$83F45AE9,$DCDE0AE7,$5739E74B,$1A5398A5,$FBF6A5EF,
   $2711EE1D,$E50C1D14,$DE3F8F4A,$1A754A9F,$F4FD2DFF,$7802FF06,$4110E03F,$F52F3F71,
   $A4BB63CF,$2674CF9C,$A10624CC,$60CACCAB,$700B6283,$B088836D,$7EB3132A,$A6992A5E,
   $9A922876,$A9E476D9,$A65AE662,$6B386248,$3CC8CE14,$C2DC1491,$AFBE5565,$76DB6598,
   $21C7941F,$32D81F9D,$73605F82,$21E282D3,$B70C486D,$C0616DA3,$1E64670A,$616E0AB2,
   $CEE399E9,$6D0AE91E,$1BD92009,$27D00985,$464C2291,$FEDD9192,$311B82BC,$45A7BC1C,
   $E878CF58,$54205860,$A9682F67,$A10F6711,$30913A10,$99811076,$14EBE90C,$EDE70CDC,
   $C7072AEE,$70E9EECE,$8220357E,$1F5E7EE2,$28232718,$2F3B184D,$D2667B4E,$41284E78,
   $F5779553,$A424536C,$22ACA91E,$A3B21E23,$36474012,$4E5512FF,$3D4276B8,$1EFAB8FB,
   $56903432,$89A23213,$B0508AC3,$CB93C340,$AA031266,$306566AF,$D53AB9E0,$4ADAE09B,
   $3B940CBA,$C92EBA72,$8C9844D7,$094FD7D1,$678BB68E,$CC058E0F,$3270BFBD,$D4CDBDA2,
   $B83E8168,$0A5668FA,$B467756C,$510B6C1D,$43F16592,$B86392A5,$E37DF9F2,$048FF264,
   $123D930E,$3A330E55,$FBCFE4FA,$B235FA5F,$FC932654,$B9C754BC,$7A84EC85,$3C018503,
   $D087FEE3,$0C64E3AC,$7B0E5429,$E0272969,$D7DB3C4D,$07964D4F,$656A3323,$814923DB,
   $99F91577,$388E7767,$1938A5A4,$6A9CA451,$615DCC8C,$1BD18C86,$93769B71,$B4077109,
   $3A1EB416,$15081618,$59A2FD37,$4395374A,$5471B19F,$C4EE9FC7,$38FF31BB,$5844BBCC,
   $532D7331,$CF1C3124,$A7D05ECE,$B71ECE22,$C68D9242,$ACCF42A4,$6BD2428A,$97588AE8,
   $9B1890DA,$75C2DAB3,$E74A065D,$9E175D39,$1D0F5A0B,$F0040B0C,$EC4F30F7,$CEB8F73D,
   $2B481A19,$BE5119F3,$E5AB83F0,$D35BF0ED,$1780D40D,$7C8D0D62,$8617CAD1,$85C6D1BF),
  ($7B66F2A4,$B1C74212,$D7A59FC1,$CE916098,$2406FA70,$C312EF8E,$D81403D5,$956C7DCE,
   $18DD9520,$5A0C9B23,$1A480E8B,$AD0D57F5,$87740B01,$E7B9D052,$2ED81268,$0217F9EA,
   $F8CD3A06,$4D7CFF19,$572B7B67,$44D1772E,$E65AF72E,$FB73C5B5,$84512705,$91427AEF,
   $E4CF6C85,$0C720963,$732D8117,$87C398A0,$FE87620E,$A17F5E96,$8E8FCF1D,$50476C8B,
   $9C8CB225,$CB4EE1CC,$91A8B59A,$67B2304C,$D2CAEBCD,$54696BAA,$6BF01437,$DDCF0383,
   $79F3690F,$46C68EC4,$CBA7C942,$8F9F96E2,$F5E93DB9,$E1802E99,$C179215A,$4E9A8086,
   $6764A427,$F0C9B468,$94C7C196,$FD4A3B7E,$83ABC8A2,$FCBBBD0B,$63BB6784,$EBCBD931,
   $C882E546,$F9643C5F,$41F7C5FC,$C4DA9730,$13B3CA97,$1AF3EB2C,$3E4EF4FB,$6E1FB87B,
   $4498B1F0,$5E229C02,$2C4D89C3,$F516353C,$F97D8DA9,$CC869972,$E57FDB2A,$8D886F08,
   $612EFC2F,$1CCA15E7,$FC12F9A5,$567E9240,$32DA44EB,$43190F90,$AD73DACA,$FEAC44E1,
   $65F13F8C,$07C878BE,$E3358322,$618BCE87,$DFEEEC72,$F895BA2A,$3A913758,$751DD522,
   $21698E7C,$59EAE4BC,$BA1FD3FE,$FF5DC294,$39B41B5C,$03E67F9F,$D1EFC7C9,$2292C117,
   $808EE4A6,$8A4017B6,$8F3F78B2,$D1BD0AE0,$BC558BF6,$135E631B,$28924A60,$EE145865,
   $AE56F6CE,$8857EE5C,$00000000,$00000000,$CA177EED,$0E65F089,$269361DB,$34132358,
   $CEC8BD4E,$15679DD0,$16DCBE9B,$800BE01E,$CF780AE1,$949DFBBB,$DB312FD1,$E397D773,
   $1126513C,$EDF227FA,$2723D674,$B5E94533,$B73BD441,$53A11314,$C683CEFD,$23634762,
   $8A500CBE,$4B4501D2,$6E9F603B,$473708B1,$E010AF26,$1770643A,$8C1A54B6,$A746A05D,
   $933D2E31,$90B3FC9A,$31FF68EF,$35E2A52D,$68D53833,$AB34A93E,$20D939D3,$D81082D7,
   $D480B3C5,$B86ACA25,$4528065F,$DFD8FA69,$D615286E,$4F6B06F3,$EB7EF091,$578F1435,
   $056F740C,$9AF80B32,$BDE53C59,$92A40570,$196D228F,$DBF6FD48,$04DFC3A3,$1B026D59,
   $9E19298E,$3C4F2D1A,$A538A979,$C8A89E53,$3CDB6F50,$991E74AD,$5C4524D0,$042E0721,
   $DCCBC076,$8E6E1097,$E285348D,$E071A8EC,$FDA24E0A,$D784F42B,$821B7F0D,$7D41DB60,
   $5DF5937F,$85D4614A,$ED34A899,$BB8CB5BA,$0B6E5FB7,$40FF700F,$1BF8B924,$2CF7319E,
   $EC841F36,$3A76D3D1,$40477253,$4520F15B,$7008AD13,$F138321D,$25B64DDF,$42E889E5,
   $BF70A7F2,$65A5C9A6,$FF37D5A1,$208538FD,$1C025683,$410EF67A,$3D6BD8FF,$18E412C6,
   $5F6008D4,$72D5AD9C,$B41EF845,$255AB9A9,$AA89356D,$93558305,$71B81ABC,$70C25476,
   $084B73B3,$3604DAB2,$4B292DE4,$05DF8154,$49BCB64F,$F2DE4D82,$813E5309,$0BBA71DD,
   $D05F7066,$A368A77C,$DE5E5BDD,$796FDC41,$064A5808,$EC03A18F,$B88A4855,$085C0E42,
   $9AC6EA2D,$274D4043,$6DBA4C3F,$31CCA20C,$540E5763,$322ADD93,$1E97CD28,$B60F3AAC,
   $95777639,$7CB05D15,$6C0AFB90,$B036C467,$96525A3D,$0A4BF7A8,$480C01E0,$73242BE9,
   $0FB19C14,$5BFD1D56,$F08649B5,$7B7825AB,$09FBC41C,$B7FEBCD9,$01B0B7AF,$81FA666B,
   $B68B63EE,$D25B757F,$F3A365B1,$0D838F16,$620BD02B,$6A31BF5A,$8DAAE319,$26BCC636,
   $592A50DC,$9ED60C13,$36058748,$581B62C9,$77F242B4,$9CC1F5F9,$2F68A5C7,$83ED9F81,
   $2DFD3E6C,$74EC5357,$55BEE0CC,$B3D0BBF8,$0D2407BF,$ACFCD180,$7AD6450B,$303D2479,
   $E7EA4081,$7A89A3DE,$5BBFCB77,$69D7C0C5,$14492530,$770A2CC8,$DD7B77D9,$0F9476FC,
   $23FC15D7,$AEEB286A,$E85BDC95,$2174BE88,$52440F6B,$DE297C1C,$98537186,$D04C8C95,
   $3520AB4C,$2EE0C874,$F6CC11BD,$977B8424,$85E190AA,$10B81C84,$B5AE4FEA,$A4A0DFC2,
   $2BB76664,$98EFF2D8,$5161236F,$A8D2D6A1,$C4165556,$D4628BB4,$4CD3C243,$682646B0,
   $0C94B010,$2D06B7EB,$DA81987E,$626DB118,$50D194C0,$2928B0CA,$07FAEFA7,$6DF9C7E4,
   $F77CA612,$1681E24F,$A4881ED6,$4952F838,$03252C04,$76FBAABD,$7843DEA0,$C73CE8AF,
   $5A0F7CD8,$E82DA6AE,$0ADEE818,$C1051664,$E1A01889,$968A0251,$1F277A87,$37F55CC7,
   $A9AC1969,$E5AE29B8,$8BE0BB11,$CABF67B9,$3B2180F7,$F4E7B349,$4D6375EC,$E9DC20DB,
   $CDED914A,$639C376D,$AB3982C2,$12AFE56E,$336AF344,$C2E369FB,$9B765D82,$A6B72628,
   $D9A4B47A,$14961BA5,$88C59715,$BC44CD04,$A1E76ADA,$D3AAF30A,$47BD9DF4,$28D936BF,
   $34901CE3,$AF1AAE1F,$224CA278,$2F114E01,$90180235,$E6485627,$A372F171,$24AB3FDC,
   $A057DD75,$52509561,$6F2FD794,$C6CD6EDA,$E9EB6B3A,$A08ED8E3,$AFE64161,$09AD8837,
   $9FA99E21,$BDB54B71,$F213D21E,$8C79E97D,$C0C996F5,$CF60E6ED,$7D2CAAAC,$5DC4E39D,
   $928D999E,$11499AF1,$53F4B8C4,$5FD31A77,$176C0934,$01F18675,$569BCCC8,$C52B1145,
   $4E4659E8,$9F278A66,$897520BA,$3DBEAB6F,$C7337952,$A2992109,$12037D38,$9B098D47,
   $B254A04D,$C9591826,$FBE81602,$3B8755A4,$A61D857D,$BE5334EE,$99E3C629,$51B6EAFE,
   $2A07D1CB,$191594B3,$589AE773,$1F2C6A78,$A7AD32D2,$3FA95285,$6A40A398,$5C3565E8,
   $42D2E9F8,$B2213D8D,$3FFE4354,$EFE5DE10,$9D3C058A,$4AB487A7,$EE11849D,$CD771F07,
   $B1718C49,$BFA2B29B,$FA58A1AD,$BA7D33CF,$2922FDCF,$6FEE3E0E,$A81CAEC6,$64544FD3,
   $37B530E7,$D9E104A2,$5ED0BF7B,$F32FCBF7,$B0C13BE6,$3E58D4F0,$304FDF40,$B418C346,
   $7FB93107,$AAC52F4B,$7C9C1D03,$DC3E85F6,$D37A5C62,$D5930DC1,$729D36B8,$0639FECB,
   $1DB2E12C,$C0F49011,$BBAF6451,$7EA7A4FF,$15F9929F,$F6F04AA3,$86C4BCAE,$6643B639,
   $1096E693,$6C084191,$4A999A4B,$8425E73F,$66D41388,$7133D203,$C25C0D5E,$38612A3B,
   $C3ECBAF1,$B99B4C50,$7642F51B,$1D3B9392,$ACC36D65,$7F56228A,$609E4B80,$9D30738C,
   $B3E417E2,$48A37E4D,$97E2ED92,$8BB191C3,$69658F9C,$2ACECF55,$0E012BBB,$DA077B3D,
   $A2C246DE,$A55159B7,$43625E57,$33DB5BE6,$3804ACF3,$821C19F4,$D530046A,$3990AC4E,
   $EACE473E,$D675725E,$C93252E9,$789E5A34,$64418823,$86321ED5,$F136FE1A,$FA8243C0,
   $BEC0105D,$E45FAFCD,$7E0986A8,$2B3F4920,$460D2A5B,$A92350D4,$4FF6EE47,$1EDDEC0D,
   $B93AFFFA,$89A66829,$F4598A16,$607A48F2,$7567D91F,$6BC0392F,$74D76EB0,$EA3A5F44,
   $C5A6E2F9,$5598EDDF,$EFA13332,$4C8D796C,$02959BAB,$F701CCD6,$CC5D26E5,$E2665106));

 Shark_CD: array[0..7, 0..511] of LongWord = (
  ($5E55AFF3,$E6126AF0,$310B0835,$4B6C893F,$EBFC8D57,$AA4C0E84,$F3B3090D,$FB9B5C7B,
   $CCBA5CE2,$4508A6A9,$4DC6BDE9,$E5D1D206,$5288EDDE,$34834375,$E46B250C,$B684505D,
   $5A1E91E8,$A8CEDE20,$F9FA6ACC,$40B89B46,$FAB080BA,$8EE1EC1A,$408E0A45,$DE77D6B7,
   $2E455802,$9A3E184C,$3F0955EF,$BE93FAD2,$AF39B909,$3AE76CE3,$6F5EA7C6,$AD7EE3CF,
   $CFF0B694,$8B51D1F5,$3C43BF99,$70CA8D8E,$B2A8F6C9,$CCDBA7F8,$B5A922A4,$4C5E6474,
   $541CCC32,$5D31ADCD,$8C3456A7,$9B7F701E,$ECFD593A,$2AC9CD08,$58C18E1F,$8FA08448,
   $745BC9EA,$32F0C66C,$CBBB888F,$C58D6525,$4B529C05,$8C633CBE,$8AA0774B,$F2CD9EA6,
   $CA2E7D0E,$2CBA4811,$C9649778,$E2E33F4D,$AC73537F,$F4BE1BBF,$379F29D9,$22DE6787,
   $79137E46,$0956C2DD,$78868BC7,$E061EFE9,$0F97A85B,$1CC85ED9,$67C8DBF0,$31337E9A,
   $E36AF161,$360193D1,$6383E5EB,$7FEFCA4A,$3241E243,$8535FE63,$ED68ACBB,$C3FEE03C,
   $A570DAC8,$81C4ABDE,$FB25753B,$67D6C12E,$164DD980,$A4282112,$A13BE4D3,$CF181F0E,
   $F86F9F4D,$A98FB672,$F66DC297,$5C70C59F,$C2B80138,$B0F7D544,$EE2246CD,$0DA79760,
   $411BFFC4,$3740FB83,$114C0DED,$24ADE29E,$E0201B17,$F858E48D,$FDB154D7,$0E642F96,
   $531D185F,$DDB46E41,$B33D0348,$25EC8ACC,$B1E21CBF,$0282D0A4,$8B3582CA,$1BFAB392,
   $DEBCBB79,$AFFC336B,$F0F9E37B,$35C22B27,$1393121A,$03C3B8F6,$19DA71DB,$B8E07FCB,
   $3DD64A18,$99FDA0BA,$034AEA76,$CE59775C,$80E9148A,$49EE599B,$C6F33F23,$FE2B6194,
   $044B3E1B,$4EDCB4D0,$887F68BC,$D5A3C4CE,$E2FF04E0,$DF36BEE5,$C766CAA2,$171C4CA0,
   $C8F162F9,$0BD41279,$EFB7B34C,$E490BA54,$72CFE806,$5B4228D4,$A9AD98E5,$5355825B,
   $1B056E2C,$9F8E25A3,$10D9F86C,$CD9ACFAA,$DC63A48E,$88926903,$558939B3,$B40680F9,
   $95EE277C,$239F0FD5,$34D5C3AF,$EC8710DB,$83A3FEFC,$87B72EC7,$6C144DB0,$63279493,
   $DF294EF8,$46CB1E5F,$1492C677,$83467B7A,$08967C36,$9C4D9D55,$9BEC7AA6,$D6607C38,
   $6517C407,$165D24F2,$69CA862A,$C4CC0D77,$360ADC58,$CBE94AB3,$9030ECE6,$84749631,
   $56C3D3C5,$7A5FF7A5,$FEFBBEA1,$C03D58CA,$1A909BAD,$76B90897,$D9BD6F14,$2F79F0E7,
   $3AD79E75,$19786336,$D7BF32CE,$DA86830A,$D0BEE6A3,$5A034086,$C0671ECF,$97998F2C,
   $8F7EBCD1,$55260742,$184F845A,$51D752FF,$0A4963C1,$BB23C73D,$4E8C579F,$2B88A55A,
   $665D2E71,$D80453AE,$8537DF10,$EE05C07F,$48187673,$423A4BE2,$947BD2FD,$CAA822E1,
   $29448C6F,$1ABBDBC0,$6216106A,$96D8E77E,$CE654315,$6266FCC1,$7E12AA2B,$89D30151,
   $2FD0AD83,$73093578,$0701D46D,$8085C38C,$B7763D53,$6B303E1C,$9A798F27,$3F57510C,
   $6ECB5247,$4449CEFB,$22981A2F,$48AF31C9,$9FA744BD,$98BCC8E8,$069421EC,$69B2EEB8,
   $B077E93E,$EBB5FD90,$150733F6,$6A71564E,$E1B5EE96,$116FC9B9,$937A0690,$4A2DE16D,
   $BBAB7F7E,$B9A11799,$57562644,$9368DA91,$9E32B13C,$718BE5DC,$2599CE42,$C82AF245,
   $F7F83716,$B547E8AB,$D62AC74F,$33B1AE3E,$4550C1DF,$799C4F53,$38088182,$3E16395E,
   $7010F7F1,$7C2C72BC,$28D179EE,$F38CF6F4,$0CDD422D,$D2912985,$5B8B6469,$41F9F314,
   $D3F40CD5,$945A37DA,$090389B7,$757AB061,$4AC76984,$6554118A,$D261F954,$7D6D1AEE,
   $A2710EA5,$01416852,$735A1D87,$B27505E0,$B8E19508,$77F860C5,$E721CF7A,$78DD2701,
   $DAF78562,$E12087BB,$21D2F059,$86F64695,$2746D1B5,$EF44A82D,$8EEB4950,$BC112A76,
   $4F19A21E,$C2BF886E,$C5B9D555,$307216C8,$87E8C0E7,$C96B9A17,$92EFF311,$A31ACC59,
   $817CE10B,$A0D974AF,$F16C16FA,$DCF50613,$7711239C,$FCA9B130,$3E9CA06E,$57A4D7E6,
   $D8289A95,$C64EDDD3,$309EFDB4,$A25BA40B,$7BCC61B1,$2E3898B5,$0E025DDA,$F5FF73ED,
   $A7AFC53F,$A6AAF1B6,$C42C20D4,$D9453BFC,$AAE77293,$9D0CF507,$FF6E4B20,$290A75FE,
   $05DECB9A,$A7EB99E4,$230DEFAE,$A1981CFD,$F226FC8C,$12AC714F,$AB728712,$743BD833,
   $33D417C2,$6C02D357,$0195F581,$E9372D34,$BFE04165,$F77DA349,$A4E52F49,$68F386EA,
   $240C3BC3,$211DDF71,$5057F229,$13ED191D,$A3E4FB24,$E8764566,$425115B2,$F9198CDF,
   $BD3F5E92,$D013F921,$E6B43AFB,$91EA0A35,$84A22A91,$0732ED4B,$1206E79B,$EAF495C2,
   $0BDC9640,$5214EA09,$00000000,$00000000,$D12B1322,$B3346DB2,$4C534868,$0CE6FF32,
   $7CCDB5DC,$AEBD5B39,$6A806C5C,$0A957A2B,$1C04BA41,$1F0BE62F,$D4F5D8B8,$14DFF456,
   $615CFA1C,$58819022,$3540362E,$05B03DEF,$6B1599DD,$E3A2571F,$F52728E1,$9229B2C3,
   $A8386D64,$BA62AF6F,$26D32434,$06738519,$E8B66721,$641579D8,$9731388B,$04F155BD,
   $B9746089,$9ECF4DF1,$867D3566,$205CB723,$43C4E033,$102EA1EB,$0D48B7AC,$3BA604B1,
   $BA3E8AFF,$50963AAD,$CD2FA963,$AC3F8B9D,$F4B2DD60,$7B1E9FF7,$1D914FC0,$F63CCB1B,
   $C1F2EB4E,$7EAEA218,$E5FED08D,$5FB37D69,$9CEDAECB,$56E5BFB4,$685F73AB,$2DFB2043,
   $DDF6510F,$61A54437,$204705D8,$6FC16BA1,$FC24A156,$E75302A2,$2B9B9398,$3DD581A8,
   $75CE3C6B,$DBC7EB58,$44C5345E,$90AB6267,$C32DF4B9,$59C0F870,$59547B9E,$6697A97C,
   $D5602D39,$FDE8D962,$AEAC4C88,$D3D041D7,$478FDE28,$5EF2153B,$2A0E6619,$D4E2AC9C,
   $BE75B4E4,$1E4A8E7D,$8DA1A326,$72485D2A,$EA6978D6,$437B23B0,$7684D61D,$159E9C04,
   $5FC05A72,$0F2547C4,$99336551,$F10E2650,$89EA9D3D,$3C94E9FA,$9D785B4A,$BFD29280,
   $DB6270E3,$0817AA8F,$7F875FAA,$60E42C65,$98A690D0,$18390B64,$7D58405D,$478A760D,
   $5D1F4585,$284B1DAC,$60C90F9D,$B1B6BD16,$1F4E5037,$D1529173,$17D82C01,$4D1F0C26,
   $7A599430,$C70FB581,$91A51967,$6D43BB05,$82360B7D,$6E8003F3,$ADE6A6FE,$1D89368B,
   $A63A30BE,$4F9DDC82,$96A4CD0A,$EDC67889,$498D83F2,$AB0D66D6,$2D0FB274,$54676F10,
   $5C8AB004,$C17C3098,$1EDBA5B6,$3865BC47,$BCAAAB13,$3924D415,$71850270,$951B5F88,
   $6D81B831,$8A10B9A7,$2C9A47F5,$BD504224,$B43CD725,$A5694940,$64823186,$FF6A09C6,
   $E92392A0,$8D2254EC,$461A2BA9,$B7C5380F,$B6E3C8D2,$82071328,$399D7403,$D721146A,
   $51C207A8,$FADA3429,$A0AE1152,$262F323A,$3B426BF4,$F04F4E02,$02DF1FF7,$276E5A68),
  ($FD16E203,$3B4016DB,$1174530A,$9A7574C5,$C02EC8D3,$90012E69,$D780E076,$F44580E3,
   $49ECA14B,$F81DEC2B,$A6E3D7EF,$26CAE3E8,$0C41F6AB,$0962419E,$70EBD951,$54D1EB40,
   $0188EEC8,$865E884B,$A406FE8A,$DF76067E,$E594FBA0,$29849412,$6869C0F2,$46156989,
   $BBD6724E,$B5DDD6B3,$9E6C413D,$0C586CC8,$54D904EA,$6B0AD970,$EC62B109,$A135621E,
   $087EA461,$0EEF7E47,$DFFE4417,$FAAAFEA4,$80342331,$E0AD344E,$3D382AD0,$AB4138B2,
   $8E90FCFF,$10739046,$218561B9,$BE0885A2,$7D22C132,$DBED2295,$7FC7E857,$2251C703,
   $BA5E9C86,$33835EF8,$F4E0A8AA,$B3F1E0D7,$2432DDBB,$3FDB3230,$A3546BED,$A719547A,
   $CB3DAB1F,$E10C3DF3,$8AAFAE35,$17FEAF9F,$154B01C0,$9DF84B1C,$93A5595E,$8364A51D,
   $74D48B9B,$535CD499,$4B09882E,$01A109BD,$B0C51182,$C4D0C529,$E1ABA96A,$2E09ABCB,
   $CDE7D0B0,$1F3DE7BC,$1D35A5A1,$9317355B,$50E65620,$6C87E6A9,$42FFC287,$8910FFB1,
   $275F1A16,$40395FED,$DA49F815,$7B794936,$98B63A92,$F269B687,$DBC116DD,$FD27C17D,
   $9BDBFD3F,$8D8BDB5A,$14C3EF08,$1BA6C357,$C6F4B37C,$6E30F426,$036DC7AD,$7FE26DDD,
   $57B4C347,$14E8B4AD,$25BA3373,$B985BA7B,$8C75D59A,$E9CF75D0,$5898F241,$626898EE,
   $339CF51E,$5B9F9CBA,$BFE92084,$B250E96A,$C1A6261B,$165FA622,$9C896858,$F5E4895E,
   $2DC49712,$B76AC43C,$9612E55C,$02B7128F,$5BF535EC,$1D8AF533,$28732B10,$36B973AE,
   $E02347A2,$A8572380,$4192052A,$F6F2926C,$D0D27511,$8C2AD2E7,$3A6ABFB7,$D32E6AB6,
   $FC9E0CCB,$BD1E9E90,$DD1B6D72,$03161B32,$F23AD305,$4DC03A98,$05B7BC02,$81D3B792,
   $B572AD80,$450372BB,$3CB0C418,$2D1FB0F9,$388F96D2,$2A928F20,$D6080EBE,$721B08A8,
   $563C2D8F,$92B63CE6,$1A6730C6,$EB78675F,$538B918D,$13658B74,$B14DFF4A,$428E4D62,
   $09F64AA9,$88B1F60C,$D2375C74,$75963771,$9140703B,$7AD8408B,$ADF0B423,$57C7F072,
   $121994A7,$E5971918,$E6F93C0D,$5666F9CF,$0DC91863,$8F3CC9D5,$86EE589E,$1E9CEE01,
   $9FE4AFF5,$8A06E483,$6EB3BB5D,$B824B3C6,$AC785AEB,$D1997839,$CAB545D7,$6752B5B8,
   $F0DFFA60,$B47CDF0E,$190AF76B,$949A0A82,$69E12E3A,$C04BE1C2,$90C89EF3,$FC86C8C0,
   $5D2F4E43,$E3BB2F7C,$1FD08CC4,$6AABD0CD,$A2DC8525,$2147DC31,$B8BBB5E3,$CA3FBB6E,
   $60176493,$48FA17CE,$17AE28A5,$6444AE8A,$73861EFC,$2B33869D,$E771D2C5,$D0387184,
   $DE76AADF,$7CF476EF,$13917A6F,$63C99153,$65A0D891,$C929A05C,$362B491C,$DA4C2B28,
   $06DA7BAF,$FE31DA4F,$22E8A614,$C1EAE87F,$37A3A7D4,$5C12A363,$C9D8827A,$18B0D865,
   $840B71FB,$E7200B97,$BD0C09E1,$4BEC0CFC,$43772C4F,$0F4E77FA,$B9335B2B,$4C613325,
   $D3BFB2BC,$F3C8BF3A,$4A8166E6,$87FF81F6,$7A705455,$A3827091,$82D10A54,$1911D1D8,
   $FE7B25AE,$44A27B06,$D9243FB8,$049B24EB,$B3A8D62F,$BB32A8F4,$8B2740FD,$91A027D4,
   $B22038E7,$3D6C20BF,$CF02F9D5,$E681022A,$45AD57E0,$F17FADB5,$F78D6F07,$CC138D0A,
   $2B1EECBD,$495B1E73,$200D8F71,$38560DE9,$AB2ACF8C,$A9F62A3D,$236048DC,$47B46034,
   $46C0904D,$8E9DC068,$3907781A,$ACCC076B,$F15714A8,$32225745,$3E55ED7D,$D4A3556F,
   $E34E800F,$D7B54E5D,$32141BD6,$DDC114F1,$1BEFDE0E,$6D26EF14,$DC9383BA,$85489379,
   $9A5313F7,$0BD55311,$07529567,$786F5204,$F3B23DCD,$CB9EB2D3,$3179DC7B,$A223792C,
   $D15A9BD9,$0A745AAC,$0B1363CC,$710D139A,$89C26998,$681CC242,$5FCA6726,$1A07CAEA,
   $D8ACD170,$82C5ACA0,$7BF8BA9D,$25DCF8DA,$6DDE7CF0,$C7C6DE1B,$B4FA4348,$C35DFAF0,
   $EF0F76A4,$DED70FC3,$A9CFE6E9,$504ACFAB,$FBCC99AC,$C571CC94,$A1B14288,$5EA5B1EC,
   $AF159D46,$AE7B15E4,$2EA950BF,$C888A9E1,$0A9B8D04,$F7539BD1,$8F181237,$962D180D,
   $59101C89,$E43610A5,$4425B928,$772125FE,$979A0B94,$84E99AC4,$26D7F4DE,$C667D7A6,
   $C3430F7E,$EFE343B4,$755C6553,$D5025CD2,$E85DE3C3,$A6B85DC7,$A8470821,$D61447E0,
   $6F3B5595,$3E7A3B8D,$3FDD03B5,$52FDDD24,$4EBE342C,$8072BE2F,$188219A3,$12C482C9,
   $C8506CB2,$9EEE502E,$720EF034,$AD6D0ED6,$A58E1042,$59288E35,$1626C66D,$E21A26C1,
   $30F132B3,$247DF167,$0EA4DFCE,$F0DEA408,$2C4C79DA,$31344C77,$64283659,$4F772817,
   $4C5B1D49,$79CE5BB9,$00000000,$00000000,$9D018690,$73BA0115,$993ED45A,$74373ECC,
   $B79784E5,$BCBF972D,$2F21BE77,$4ED621AA,$EB30246E,$D95A301A,$5E4289EE,$9C5942A1,
   $637AA33E,$37187A13,$EDEA5FC1,$276BEA55,$10FCBDC2,$1C2BFC8E,$5551EA22,$ED54513B,
   $E9D50D0B,$20E6D58C,$B61F6A2D,$3AE11F66,$81BCCDF9,$66F3BC05,$77B94C36,$2CBEB944,
   $CC6F3E78,$99636FF7,$52037F45,$953B033F,$29FBC5D8,$B0E7FBE5,$CE8A171D,$60DF8A61,
   $8DFD3B52,$6F91FD9B,$7631A2FE,$AAE0310F,$6A8CE997,$BFA98C1F,$D4ED27DB,$8BA7ED3E,
   $8766B656,$98C2664A,$4F36DAE4,$062C3664,$3BE2517F,$5570E2FD,$516EB8E8,$EAD96EE2,
   $6C569238,$41985650,$34CE6079,$23F0CEBE,$6745F1F4,$309545CA,$78957D30,$5A3E9507,
   $85839F33,$617E83DC,$94F7CC39,$FB0BF719,$F929B0C9,$3CCD2902,$401AEBE2,$70AC1A27,
   $619F8A5B,$CEA49F85,$6B04075F,$39F70454,$D565C913,$0DF96575,$47487E85,$08C34823,
   $71633799,$D28F630B,$1E58620C,$ECF55886,$FFF3CB66,$C2FCF34D,$C4119A19,$978C11B0,
   $C2CBE1B6,$69BDCBFF,$F8A15E01,$BA93A149,$E2C66EC7,$51EBC616,$043F52CA,$078D3FD9,
   $EE87986C,$58898788,$F60581CF,$4A4D0541,$C77C5DB4,$E86E7C6D,$884A8750,$EE424A09,
   $BC84E729,$CDB284B7,$5CA7A08B,$65E5A737,$AAA22144,$2FA8A276,$A76B3927,$A0946BA3,
   $35468EB1,$A5AE46F5,$F5684662,$35AF689C,$AE9D738E,$28259DAF,$2A960275,$CF059638,
   $66CD1F3C,$B6CBCD81,$48644F83,$7E436460,$5A7DDB24,$9BD47D78,$FA447764,$432F44DF,
   $8359E49C,$9F4F5993,$957F22F1,$7D557F52,$0F2C3106,$76802C43,$791D93F8,$DC601D4C,
   $922DB796,$053A2D56,$C59974D1,$11D299FB,$02E52965,$F9BCE596,$A039AC40,$D8FB39A7,
   $BE61CE4C,$340E6121,$EAB8CAA6,$5F04B851,$7CAA2FFA,$5DB3AADE,$1CBD4B69,$1549BD10,
   $4DD3F381,$FF90D3F2,$E41C1568,$AFDA1C59,$62F24DF6,$B146F258,$7E4F069F,$A40F4F48),
  ($F8F0F94C,$A1A35CEB,$0F3F095D,$2C203D65,$4084A2A7,$1A2BDAEE,$4D7BCC68,$D3240457,
   $94A9ADC4,$F785BEA5,$6206949C,$F2EB5445,$0475CED1,$3F5E334D,$835D1F60,$5994299B,
   $AC204794,$785B7989,$CF461A41,$025DA6A2,$F01A901B,$DF1F3A71,$8BB77637,$27284F01,
   $694C5310,$E1955A6D,$D9D261AC,$24A1BAF2,$9FE36A48,$E4FBB08D,$F7CFF011,$8D83618E,
   $ABF5279E,$2AC72276,$E68EEBF6,$F9E32621,$D3F86F69,$BF323FB4,$B8745BEB,$BB888605,
   $7ACD2F65,$70DAFE1E,$1F1EDBF3,$D0ADF1A4,$2B089625,$1E91635F,$864818F8,$EE2791B8,
   $C56C1484,$99CE23E4,$FF259946,$F33F0714,$1CBE7528,$BD6F9916,$61A63A47,$9F293CF7,
   $EA114C70,$B80173F6,$D54DC62A,$6543EF25,$A0BFE012,$39B92C5E,$7187E8E9,$63A4F036,
   $2CDDF62F,$4C0D38A0,$39E92319,$07334C42,$C3D9BDC7,$43BFF375,$5F9A7954,$CA862B4A,
   $E8D12BE2,$5D2E902A,$0B4AC78C,$137E0E28,$30638307,$F162A1B6,$3E3C4313,$55AF17BD,
   $1DDEBC61,$35821278,$E52E452D,$94214E93,$DB12063E,$C18E592E,$490E02B9,$EC7A371A,
   $DA72CF77,$4963D240,$0C9FA786,$41E255D7,$4244C535,$FF043932,$0160C949,$88ED8B6E,
   $9E83A301,$6C163BE3,$B09E32BC,$C534E09F,$D78DA1B8,$806C0CF9,$9B96A499,$DBA583C0,
   $11411BE7,$746047AF,$C6CCBA5F,$F40C4B56,$ECA4E533,$6270A367,$7492EF71,$D4174815,
   $1B6B1522,$EFF3C2E9,$72274632,$0E669884,$9AF66DD0,$534808AE,$18CBBBF9,$8231AA5B,
   $F3BA3EC0,$B2DD52C3,$3F5C8A5A,$DD429CD3,$E39BEC6E,$4E509E02,$16947BED,$26FC1C50,
   $54D0BED8,$D9F82562,$4BCE652B,$0955D4C6,$FDE5FED4,$1610E4C8,$03A0AEDB,$6DC268B2,
   $C079131C,$2E7D9BC7,$14541C7F,$C3D3FF8C,$BBD4F530,$D64AEEB7,$E15B8BFC,$AB7F7DDE,
   $32A3E495,$144D426A,$A5AAE78A,$8E0A947D,$31034A4E,$798F2AD8,$6FF9FA53,$3BE48AFC,
   $07D5600A,$529C5BFF,$4EDB62B3,$BEE66CE5,$DCC76634,$931202D1,$C8937A4B,$50C1FD5D,
   $0E5FC014,$A4CDB60B,$F17A5952,$57F2B11F,$A8558945,$47054AC4,$D13808FB,$5A1DDC68,
   $75F22638,$5CFAC37B,$897711A5,$C207ACDD,$64B33DDF,$289A84D4,$46310BE4,$C05A0A7F,
   $50A57009,$E6A6162F,$A4CA2EC3,$06E71F13,$279731A3,$5F733688,$70E721A0,$EB497B58,
   $98360A42,$B667EB72,$A60A4951,$E3C8FCCF,$CD867DD3,$E772457E,$682C9A59,$6978D103,
   $204251A9,$0DEF6D77,$0DFF6ECF,$C90FDEB9,$823DD629,$D179A2F5,$5D5A1EC6,$2FA9C896,
   $4AAEAC62,$81B85FA8,$A27F8780,$DC96CF82,$23E2FF72,$602D05C5,$12E1B53C,$19A22F1D,
   $02C06792,$E52FE3DC,$1E7E12BA,$58407ACA,$BEC1F2A8,$61F95694,$4751C2AD,$48B78111,
   $7C788626,$AAAB2E8F,$6B8C3482,$04BAB9B1,$921C0487,$2DF46E34,$C40CDDCD,$1123A88A,
   $E2FB2527,$C6BD156C,$95C9648D,$7F6835CB,$85E8B623,$83E5F90A,$7EB8E1B4,$4F84CD53,
   $F9903005,$294ED785,$E44E8C64,$1CCCC5FD,$C2B9748E,$CB52781B,$796D81BE,$1D1896AC,
   $6E99331A,$B3090192,$4591A53F,$AD9862CD,$90DC6315,$C8DB8DE8,$FE45500F,$7BD28C7A,
   $19AB72B0,$0ADC2135,$B33E9C67,$A8F6882D,$CA531DD9,$B5EE1E81,$B25E552E,$201B0343,
   $91BCAA5C,$40360686,$17F4B2A4,$AE11973E,$FC85379D,$9EFD6FA6,$B91492A2,$33650D6B,
   $F2DAF789,$3A30D9AD,$BD615C73,$0C3B3E26,$098AA01E,$F651EDF4,$E7EE22BF,$710EAD4F,
   $765288E3,$3138ABC9,$AEE02006,$9D749A55,$51C5B940,$6E4B9D41,$BC01953A,$84D6B548,
   $4FBBABFA,$360BE78B,$AA95EED7,$A22AA918,$D42D0F63,$EDAE644B,$3576849F,$46D11995,
   $486ECBF0,$6497BC74,$29C8F1B7,$FBBE8083,$8817D8EC,$4AEA27B3,$6C595488,$5626E24E,
   $F6AF3958,$056EEAE0,$67139304,$4558EC66,$FA309EDE,$448CBF37,$CCE6B49A,$6F9FCE10,
   $65D3F496,$A0770FBA,$1A0BDC6B,$671E4987,$06B5A943,$DA71D091,$D6ED68F1,$08818797,
   $37B6E30D,$A3FEFA49,$3CFC2481,$B080F461,$DE0701A6,$763DE10D,$B1FEFBF5,$4DD96BF1,
   $41E46BEE,$92C65180,$80FDB1BB,$34564129,$584F195E,$981A70B5,$CB33D490,$3D0395EF,
   $25575631,$BA5CD554,$1534D536,$4B3E74E2,$3A498DC2,$6AF124F0,$08EA6957,$7EBC669A,
   $EB718539,$30ECF898,$2E1D91BD,$A922DB7C,$63665DD5,$7A06DF2B,$A1DF295B,$B154A730,
   $1021D2AE,$FC8DCCC1,$A935400C,$CFE8C1AA,$B74B52B6,$97A8BB60,$8FC2B8E6,$18767C4C,
   $9709031F,$9A47D617,$00000000,$00000000,$D8B2A8E5,$AC4C319C,$773241AA,$B9D520A7,
   $6D399DC1,$DECB6920,$B62B9BFF,$1F45300E,$592FD017,$10F7FBDB,$9956C30B,$3E8A601C,
   $212298E0,$8502E619,$5BEFB785,$F5D81807,$A31F4EC9,$547B44EC,$33C32DDC,$9CA0C904,
   $F46F5ECA,$E041093C,$C119DA55,$A69010A9,$7FD828FD,$C769463D,$2DBD3F66,$C4E0B3CE,
   $44F16C76,$2575E9A3,$9D230DDA,$01D45351,$B4EBFC6D,$FA6AD3D2,$E9B1E2AB,$D5C31B44,
   $7BADE62C,$F8377570,$819D78F2,$BCBBCA47,$26F7F8EA,$D79EBDE6,$4C1B0521,$5BC98F39,
   $7D184F6F,$2246A5E1,$9669CA56,$12AA5D79,$BAB43C79,$5EA765D9,$9C43C493,$8939D83F,
   $24379F78,$32B15E3A,$BFA13BE1,$E914DDFA,$8EA271AF,$909BF722,$28A838FE,$73530BED,
   $D058C1B2,$D2F05706,$DF67C8EF,$FED06A63,$57701003,$B43A4DD0,$937CCDCE,$A519E55A,
   $8C62163D,$75B414FE,$8AD7BF7E,$AFC5C46F,$E03B42B5,$2392F6B0,$3D9CEDC8,$386D7F0F,
   $2F7D58F4,$21CF5012,$0A2A0EC5,$9B938546,$55B07791,$5115AE0C,$EF044BE8,$0FB2CBD5,
   $EDC42C7A,$EA9D2809,$FB505797,$CC613459,$5EFAB01D,$426BA024,$AF80E94F,$1599113B,
   $5A8F7ECC,$7D359369,$5265179B,$0389F5F3,$EE6482A1,$875F40BB,$780D48F7,$95F51DC2,
   $C7AC7316,$7CE1C038,$34164DD6,$CE3C92FB,$66735A4D,$CDB56708,$CE26D308,$8AB02DCC,
   $13817C75,$914FA473,$5305DED2,$8B647E9D,$C9F3B302,$D82C7633,$B58B3524,$728758BC,
   $2282363B,$E8C08EAB,$3889EA50,$8FDEC72C,$36D62A44,$2B137127,$5610D94A,$3CD7C6BE,
   $D298A620,$37DFB4DA,$73478F7B,$868B13EA,$05150798,$B7B3B823,$84887F6A,$0B087264,
   $DDA7AF7D,$1BFF89BF,$43240C7C,$77E9B25C,$AD408EDD,$F0B6F2E7,$60C6F30E,$17C4B799,
   $6AECFDCB,$8C5732DF,$F50F9783,$68AC8252,$8728D1B1,$66CA1AD6,$A76A8018,$6B2577A1,
   $3B29448B,$E21CAF9E,$5C3AD78F,$A74443F8,$8D02DF74,$FD599F90,$2A685F6C,$967CE831),
  ($BA3AF751,$FA7B9775,$769C2D13,$03EF98CB,$7072359E,$7191CE06,$FF7516A8,$BAB18B6B,
   $FBC1065E,$E6E5EF4E,$B1D0DBF4,$7BEC74A3,$07C31C4A,$656B4FB9,$9FC86304,$4E8520F9,
   $D16DAE58,$8FD8DF31,$E60A7244,$90A93FC1,$B449CFC5,$30AD09F2,$91BB5B90,$8453BE7E,
   $C08FEAAD,$1D68A3D1,$04B410F6,$5C546425,$8A9E3707,$8061383C,$CCA6DA42,$F9940FBE,
   $A982BBDF,$46E1D97D,$56F7AD77,$FC505216,$F35C2647,$5E4D2704,$CA48C2CF,$8BEA5973,
   $A34593BD,$D06323DF,$6A7A5DCE,$62B65130,$4966D116,$A436B071,$1EBC78A6,$4F73FB13,
   $11E244F5,$92B07CE0,$C2D5E2D6,$33429139,$15565403,$CEE418C5,$CEFCD239,$D7BE3D56,
   $5F4789A9,$53ED8328,$0D043428,$F3E9B51B,$D8DD8A86,$20650E0F,$D21AA2E4,$B6E7F4AD,
   $3189C491,$6D0FB63D,$AC1BAFEE,$0DA0A42C,$EFBA569A,$3F14EEFF,$1A086850,$13279F36,
   $A6DC878C,$9B225E8E,$715F3159,$6684D772,$24DF9092,$A3EBAEF8,$D4F4BA69,$C499A260,
   $93E153EB,$AA798C96,$29DBA4BA,$50021BE3,$FD2F1ED3,$949BB983,$F8B60AE2,$DFDAC4D2,
   $7B98193B,$F0062DD0,$09B024DE,$AFBDD13E,$89E93BBB,$B95E13A0,$86B707E8,$649D9453,
   $0C2930EF,$E4FCAC6F,$C43BFA5B,$413CC7F4,$F49F3A0D,$3B2668BD,$8D5D2B4D,$E50A7785,
   $9A517735,$05C45DA8,$6ECE4D38,$3EE23515,$A11F9BC6,$FE491137,$536EB946,$B7112F47,
   $6DB94184,$07DD1E89,$AD36AB29,$1AB5BD58,$0BEA2CA5,$8197E3D6,$12954849,$AB8F577C,
   $CB65C608,$9CFF4007,$5243BD81,$A0043633,$D783B6D5,$FDA689FC,$E2BE62B2,$CCFD5BE4,
   $6B575909,$75A34844,$012D04C7,$17151974,$3B4EECF3,$FB8D4C9F,$7F2C09CD,$AC5249F5,
   $90965F57,$9346A70A,$1B256C97,$04328642,$B564CB02,$27B81086,$2E18B8F0,$3569545A,
   $DD449EB7,$6B24735E,$59A99124,$2193D5E5,$A268977A,$C7763AAB,$3ED7F8C2,$B0CC31CE,
   $78EF1587,$C939064C,$80591F65,$16E3C29E,$85C00B54,$5DA2BFCF,$9EE567C3,$5990398D,
   $F02B2AFB,$67720C98,$32FEC82D,$54309DA1,$D6AEB212,$EAB39088,$0AC72862,$9682FAA2,
   $D5D9BEAE,$D38CBB14,$682055B5,$4C9C63D8,$4F88C99B,$D648E6BC,$8E2A27F1,$DC355C19,
   $6C944543,$10C807FD,$DF1E96CC,$450E41B6,$40D6F5C8,$0B8B614F,$54ADA50C,$D27A60FE,
   $F2712280,$49583E70,$268598E9,$8DC19C10,$1F917C61,$5866E267,$4638ED45,$79F53782,
   $3839E04F,$C2B26703,$8F072336,$CB20456D,$197F64EC,$2A18B4AA,$E3936675,$DBE84290,
   $879A032F,$73888D27,$214684A3,$E8AAD3A9,$4715E982,$6EE02EF6,$E57D7EF8,$A996145D,
   $F99B0E25,$C8CFDDA6,$ECCD5A26,$062BC563,$3410D0A0,$264ECB6C,$089D2019,$B8A8C84A,
   $5D1D81D2,$7DC7B1C0,$3914E488,$D5A77E77,$05991431,$4B417D51,$9755431D,$F62DE8B3,
   $5134B13D,$993B1DAF,$7D7601B6,$82787B1D,$6190716B,$E321B2E6,$A4868FF7,$B5086C66,
   $3C8DF0B9,$9EE60326,$AF6CA352,$349F8FB0,$690D5172,$5B897AAC,$DC699A70,$7C316A2A,
   $B860FF2A,$D451A59D,$F1062E3C,$706715EC,$FC021A14,$838EA0F7,$4462E53E,$57DF056A,
   $94224FA1,$CF12C32F,$BB17F396,$ED6E8E01,$677E69E6,$915FE42B,$3DA0F47E,$89F31A52,
   $7AB51DFC,$E71334A4,$6409655A,$A860CFB7,$BDF9EB1B,$9F10D8CC,$4CFFC527,$EF77CD20,
   $4DD2C1E0,$F862D454,$4B3CD96D,$8A1C8299,$88C43F7C,$AE4B0AD4,$D040AA9F,$98CDC645,
   $AAF5B763,$7FDEF2E1,$28F6A07D,$47170297,$EA2342AB,$745593AE,$CD8BDE85,$EE8116CA,
   $06EE188D,$727E56CD,$2F35BC37,$227C4D2E,$8BB333C0,$97742148,$A5AB8B30,$A21D7512,
   $7E010D0A,$BB475081,$B0FDDF33,$6CF96DD7,$EE97525D,$2801F78B,$41FBF10F,$1C9E783B,
   $4A11DDAA,$9D099BED,$30A4C056,$7A1AAF49,$43A1F974,$32B44AD3,$99267B89,$3CFB7634,
   $C93FCE73,$B2D572EF,$EB0E466C,$63408ADA,$FE58126F,$ADA4921F,$72283DE5,$5FBBFCEE,
   $5C308515,$6AD2A8B4,$2D6FB44C,$0C567FC6,$7C5B0571,$956D6269,$428CFDB3,$25A153A7,
   $F6C53276,$150C5A55,$E0E46AC9,$E2D7690C,$62E77DD7,$DA1E997A,$E1C96E0E,$F5C27078,
   $B94DFBED,$C344BCE9,$9D926B7F,$60AF1211,$D337A623,$A1F2EDD9,$0E733894,$CAD69E87,
   $D9F08E41,$3770177B,$C812CAB4,$A5C06B9B,$3767DC1C,$1F71E0F0,$5E6A8D6E,$44F89A5C,
   $1CE670DD,$6159C9FB,$5019B5FA,$8E2E04DB,$BCD4EFDC,$8805C1B8,$967847DA,$E138F1C7,
   $84ED0F93,$4AB7A6BB,$00000000,$00000000,$8203171E,$38C9F076,$2C42B08B,$1B4366B2,
   $C74CF6E7,$7803EC68,$3A63E834,$EC9855EB,$E4507A3F,$BE830D29,$74C62568,$2DC5AA23,
   $BE8EE7A7,$A62FF350,$1DCB741A,$764CD08F,$A7F1834B,$8C3747FA,$5BF3995F,$0FB9E70D,
   $B38AD38F,$55C6464B,$162158BF,$F7DB3359,$2231881F,$D195F835,$B73EC379,$0992226E,
   $77B129D4,$14FA81BF,$73053922,$48AEE59A,$C3F8E611,$2457884D,$206B8064,$FFBFCADD,
   $25F29455,$B4FEB78C,$66536D21,$864AFD5F,$C661F220,$6F16F51C,$79C21140,$DE2C1F38,
   $DBAA863A,$195A2593,$025A087B,$2E2A32E8,$33D3CCEA,$432584D5,$F5B23ECA,$2C3371C9,
   $3FFAFC05,$A7D928BA,$B2A7D748,$42D35F3F,$10CF4032,$85A56594,$364AD8DB,$0864F984,
   $8C702F8A,$F21F6EF1,$FAEC0299,$F1F0F63A,$147B50C4,$D9F101B1,$832E13D9,$2FDCE902,
   $E9544E17,$4D6AB832,$170C5C78,$E0CE2A2D,$A8AFBF18,$51F4C009,$ABD8B3A4,$68CBEB95,
   $4EA5CD5C,$C15DFFC8,$F7E836B1,$02194321,$EDE05EE1,$113EDC17,$DE33920B,$521B58C2,
   $27A89C2E,$9AD48564,$C516FE9C,$5629DE80,$9CBF6FB8,$77BA0B65,$AE41A795,$238A96C4,
   $9B7C73F2,$12D144DC,$950F4B66,$D807DA5B,$588495E3,$3686CC91,$5ADE9D98,$18ACFE79,
   $E8794AD0,$5A7FA146,$231C8CD8,$C680E141,$B613C7BE,$1E873B1A,$60BD75AC,$F434AB92,
   $63CA7910,$CD0B800E,$13B84C8E,$BC9A4E08,$1852602B,$3D0DADDE,$454FE1F9,$40CA1C1E,
   $C1A2EE6A,$0A7DBAA5,$2AACA806,$693D307F,$DA8782FD,$0E4F3CE7,$92CC572C,$BD6C95E2,
   $75EB21AF,$3AD0B357,$2B81ACC1,$7E28290B,$81741BA2,$01F6DBEA,$E7277683,$87BC26B5,
   $03770CBC,$393F2B9C,$0F5E3C53,$DDC387F3,$57DAA9B0,$EB454B62,$484BD5D1,$B323A905,
   $BFA3E360,$B13AEA24,$353DD467,$315BD218,$980B7F4E,$2BEE6F40,$A0329F01,$E95C0843,
   $5580A1CB,$C56F798A,$6524619D,$BF75D6C3,$6FE349FF,$29F72C61,$CFD1D6FE,$C0AB2422),
  ($E957943C,$561FC423,$69079288,$014287CA,$DFCD1D21,$2F086129,$A044FD99,$C537D4AE,
   $D7C8A457,$F1E8C3BF,$5CDF9BFB,$2971998A,$2CE9E460,$23FA649A,$56A6716A,$3AA9E9C3,
   $AA3D1708,$D6EFA4E7,$FDA5B5EB,$705A24B1,$B170A9FC,$101E0CE2,$0E814CAA,$7CA82102,
   $1931ED13,$0BC97ADA,$778C59CE,$34DF1711,$9226D2BF,$D35020EF,$805006B4,$575D43E9,
   $9B1DB840,$91ACEBEC,$3B5945D9,$549B3F42,$3925163E,$99A3ED9D,$369A891D,$7917A50A,
   $B4B6DC4E,$E372343C,$D949E8FD,$8D40E2BD,$D0728202,$CFBC29BE,$7108AC12,$96979485,
   $B30CFA1B,$DD26DE3D,$D8773B74,$115C8B28,$C480A3D5,$E9F9C92C,$4116D0D3,$4DC8B21B,
   $4F979C79,$31609319,$0342806E,$5124BB4A,$DEF3CEA8,$B31408BC,$F158AAA6,$C1CAD76C,
   $E1522D4A,$88FF66B5,$76B28A47,$A8C37E84,$896B6C4B,$15A188EA,$0684F5DC,$A2488394,
   $5919EE49,$DA1DA154,$45EE76E8,$22B8E350,$25D28E9F,$6106AF99,$4792250F,$EF80318F,
   $CFC79ACD,$663DD0F0,$26900EF1,$302214D3,$61022BFE,$DFA2255C,$8CAD19F9,$E6CDB034,
   $6A4512E6,$50663C80,$74CED9A0,$65FBAC5B,$C9436F11,$C4755364,$0B473918,$8FC419DC,
   $9961EBA7,$5C943933,$6EBDB4DD,$3F166DCB,$15CCF25E,$BA598907,$BECF36DF,$F0AA4475,
   $BB09436D,$03C67CAB,$AEC5B133,$B99FF5AC,$75F00A29,$F9E7C5CE,$D6F677DE,$6DF4AA2A,
   $F5A00C9D,$AEBA8627,$EC91E18E,$A573FCFD,$B5880FC7,$7F6E5DA9,$E86947B5,$CA03ADB6,
   $ACB9E2D4,$74A72773,$4CD51C17,$60442853,$1CF798A1,$F8A54204,$8A29EC25,$448533A0,
   $436A8334,$80F060C4,$9A236BC9,$0DB08279,$CEF94944,$FA21B965,$1DC94B28,$64B92B91,
   $94A22763,$7118A37B,$9CA79E15,$AFF801ED,$2B53C235,$1DAE8E9B,$0A79EA91,$13D87049,
   $335CFCAF,$8A7B9DD4,$F95D13D0,$1F2A75FA,$2E95B787,$EEC2B645,$23567B43,$C34E2C0D,
   $3120AF48,$47434F0B,$BD8DB6B1,$A18EFF3F,$502284B6,$98E16A57,$CC851AA3,$37196BBA,
   $6240AB90,$8E869E16,$BA3790E4,$9FDA153E,$86D4F368,$F515C07D,$2FAB640E,$72DEDFD0,
   $DDB14EC6,$E230B3F6,$180F3E9A,$97D5134F,$66B80DAB,$E1F6CF5D,$E5AA8B71,$E78F37FE,
   $6F836754,$A30A045E,$F21A2AC8,$90EE6C26,$A4BC5BA2,$AA4785E5,$FA1F93BE,$4E0ECEB0,
   $A3067DF7,$94136FE4,$E49458F8,$7B935E6B,$EB2BC7DB,$9B2716FC,$1276D40B,$840D6306,
   $959CF4EA,$ED04CAEE,$7F89E0B8,$EA3FB587,$5DE14872,$B56DF01F,$100A87EC,$4935B1D9,
   $916452D1,$82749BA5,$C87DBC98,$58693AF1,$8855BFC2,$89BDE17F,$A6C00845,$677F573A,
   $168E7230,$EB7D324D,$D20ED1E5,$0284FB61,$0CFD1F4D,$B190F3DD,$EEEDB269,$684B2E22,
   $8ED14A1E,$2BF562EB,$0FBF9F23,$E0B44897,$EDAF3207,$396F9568,$B84BC303,$52E2C7E1,
   $17B0A1B9,$77615BD8,$DC8F9D4F,$7E2CDA63,$6CC1E73A,$F22EBF14,$985F382E,$C08850A6,
   $E210AD24,$D9DBDDFF,$2DD737E9,$BFE60D0F,$822C5553,$9A659136,$A97F9766,$87CB1FAD,
   $2811425B,$4C8A35D1,$F863C059,$83361C6F,$FB214037,$D212A725,$D330026C,$9E9892F4,
   $E32E7EAD,$45C7B46A,$7374FFF5,$5BAF465A,$DA0B6893,$DC6459F7,$7833C6ED,$D46B5F86,
   $F066792F,$5DD6BEF9,$816ED53D,$CB412A7C,$C5BE705C,$75E5A0B9,$3DDDB005,$F6D3BCD6,
   $A7FEDBCC,$FB633EAF,$11345465,$D529D84C,$536004D8,$C9C5D11D,$301E7CC1,$DB5F269E,
   $C07805EE,$86899867,$BCB36538,$3D9296AA,$64C45E4C,$2CCE1D82,$1A736D7D,$5AEDC190,
   $B6CA8FA9,$2E4AE6E3,$905A8158,$1E68F230,$0805B976,$DEE0A296,$027C53E7,$CD38D2DF,
   $87EA20E1,$6909A9E8,$C6FCF032,$24C11BF3,$13480782,$18110A93,$3E9F306B,$A7F7079C,
   $8B173FAC,$D8995A35,$7B714683,$854FE4CC,$FFD9E60C,$BD62F66E,$E06CFEC3,$14E30F20,
   $6DFF34B3,$6E32D681,$FEE73585,$217E9FFB,$3A679650,$C88756D7,$1E8BCB46,$359D90DB,
   $14F221D7,$2645E092,$511C573F,$04FD03C2,$46ACF686,$739C581A,$65FA8DC5,$B0D27417,
   $D48A2439,$A0CC78F5,$4B6F3A42,$5E10C252,$37A45A94,$E50BCC9F,$D14C518B,$53A0402B,
   $B2322992,$413AB7A8,$97E0A70D,$203C1831,$6B7BC16F,$CC7A5515,$58273DC0,$4601C8C1,
   $44D0A561,$BEA48AC5,$F7DC5F7A,$638254F8,$5798A2E3,$A6B58056,$D5B4F7B0,$3CD01160,
   $B04E7A75,$8C026577,$8D93CA70,$7AD1D9A1,$5F9D1B95,$785522C0,$2268A8CA,$5F524598,
   $CA01EF7F,$9551E82E,$00000000,$00000000,$7CCB60D6,$BB1B0ECD,$CB3F3CF6,$094D81BB,
   $35D80973,$28331E40,$54DA228D,$F7913B1C,$3CE3638C,$6ACFD543,$A84144EF,$1BD77638,
   $9EDBCDF2,$62C0D332,$2A6D11BC,$81B2E70E,$C33A8580,$D7AD232D,$381BC5B7,$05BF8408,
   $9D994D9C,$33E46878,$9FE51E7B,$FEDCBAA7,$93180136,$4F4C497A,$EA151452,$073B7F69,
   $F324F941,$0CF205B3,$84A8A08F,$382D12A2,$425450BD,$1CEC0951,$525ED751,$55D9B888,
   $BFF1E556,$6CB62DE0,$4028035A,$D1D4DB8E,$AFFB62BA,$25839C39,$AB03C481,$4AF3CD72,
   $85967306,$A4317B37,$C146D667,$1A95F1F2,$2014FB2D,$926A9747,$8FEF9997,$B7E90B7E,
   $B975108A,$CEFEAE74,$07BA2655,$3E54EA01,$292F91D2,$D0965C44,$CDBBC92A,$AB05022F,
   $24EC5D16,$FD1AC60C,$4DEBCF9E,$FC5841C6,$5EA3C81C,$E4494B55,$E6E80B1F,$B6AB8CB4,
   $3FA1E3E2,$3BEB6E09,$05C675B2,$F36C38DE,$013ED389,$9C1C6995,$5A5B6E27,$8B391A1E,
   $FC9B6662,$EC464D24,$4EA94FF0,$AD7CFA8C,$482DBA2C,$0F347918,$68394101,$9D5EEE5F,
   $7EB73331,$7623DC12,$F49EDF14,$32A6EFB2,$0DC3CCC4,$2D8C9A48,$B7F45C20,$B2568F76,
   $212A28A4,$0E76FED2,$790D1564,$48773613,$637E7819,$129AF783,$A238AE7E,$080F0671,
   $A582882B,$365BEC70,$093B6AFF,$42FCCB03,$70367F9B,$0A8BFD10,$F6E28CF3,$FF9E3D6D,
   $AD87315D,$E8BB4EE6,$724A2C7C,$C7B32FCF,$C7C223BB,$B8DD7266,$491369A5,$9328108D,
   $831286DA,$0679F8A3,$7DF5B35F,$27076758,$1FB518CF,$A981F94E,$55E4F104,$6B8D5289,
   $32622F26,$1667F441,$E7D6D896,$2AB7E521,$27AEDD78,$AC3E7D46,$6786DE22,$7DEAA6C8,
   $5B65BDAE,$1725738B,$C2045609,$4BB14AB8,$A17A2E10,$592BBD3B,$4A51E9CB,$C20CABC7,
   $04F8A63B,$6F70514B,$96DE7484,$BC2071A4,$7A4F950A,$19538D59,$EFD361E0,$F45747B7,
   $603CF877,$43BE4CC9,$1B4DBEF4,$C6F1A805,$34E6DAFA,$B42F77D5,$DB35BB1A,$40783062),
  ($2DEB0A4E,$F5A96C29,$EE653C51,$211C9DF6,$BEEEF596,$04DE5DDC,$7457C19F,$E1E5B06F,
   $14A54FB6,$74CA30F0,$C5457D85,$C296F9F7,$484D10B0,$7D4EE08A,$BF9B13AD,$AE87F2D0,
   $0E89AFB7,$8DF4BB48,$D9A2D61E,$2D8B7A67,$BD712ADB,$0F3559C8,$2F013338,$541BC731,
   $636D5164,$9EC4848B,$60F28E29,$952F809F,$B28D6357,$28984D8C,$C38E361F,$D4B5F1DF,
   $7076B373,$5674135F,$042172EC,$B791A330,$D4B4A6E4,$AB94C53B,$9305FFD8,$F17731F5,
   $801E1DCF,$39C7A621,$3BA47C8E,$20D1F7C1,$F95FACAA,$5E3DA912,$E5B80731,$B1202A82,
   $6DE4FED3,$13303FC3,$5314168A,$2E29C43E,$0D1670FA,$861FBF5C,$F3F771F1,$6458B16A,
   $DCF642C9,$3043765B,$B825BE0C,$12FD55F4,$D65E9F92,$0A266E23,$2636312E,$6595DB5D,
   $87A0B06E,$85BD0105,$0842E42D,$9BD7B360,$0175E63B,$AA59AF0C,$854A8918,$240FAA1D,
   $F82A4A91,$F464061E,$A6282CE1,$5C527D7C,$8AB6C094,$03A2BE59,$76BDF8E9,$40571B77,
   $1F7874D6,$E4F68784,$32937E98,$115FEBAD,$442E8671,$5108F0DA,$3C1AD12F,$9CAB50E5,
   $5640825D,$33E1C802,$D8D73025,$87D2D56B,$9A32FDCE,$C0F92D99,$126E042C,$62E938D8,
   $A0E3677B,$4A717554,$039FDF4D,$0BEB0414,$9CF9B654,$D6DA25B1,$FAC073E7,$55D6AD06,
   $C7AF44F3,$632452EF,$5B56F2A7,$B5FE775E,$B0675A21,$892AE694,$7C1525B2,$7A32030F,
   $73E96C3E,$5D9F174B,$10843D5A,$C35B93C0,$E8AE77CB,$373F95DE,$455B604A,$FB515FD6,
   $8BC326AF,$A9FB1155,$64D3FCC5,$22BE23AF,$5E026670,$A8367B62,$B9505837,$B8A4FAF8,
   $2362A5F9,$785DD761,$18C6D977,$588C20A0,$77C81ED2,$EA0EB47B,$36B20C74,$A6CE489D,
   $37C7EA4F,$0C97E791,$9D8C506F,$7C838ABD,$A5B7F3AC,$57B97968,$7ADE6E28,$6C110B27,
   $AE6AC8CC,$C785CE1C,$8C7D8B0E,$1581B671,$98D8C4B8,$614B8681,$0FFC498C,$27AD1444,
   $7EFF1CC4,$DB80A817,$42E5CDEB,$472BF8F2,$3AD19AB5,$8A8858CD,$A75DCADA,$F60BD270,
   $FC0B387D,$43F5A52E,$AF1F2EF7,$6DDC6110,$46C4BF07,$F0BA5BC2,$F068AEBC,$6FB3B57E,
   $6E7B219E,$18DB3BD7,$0BDD3B60,$903CB774,$A9D4656D,$7BFF6938,$D27FED7E,$BDB7CD13,
   $6B2FB549,$051337EB,$9E138F22,$77688EA9,$21889C8F,$D9EF7C79,$34583502,$077CE385,
   $CC727F93,$F318E59B,$BACF877A,$B34FFEEC,$FD7EDE46,$E9AC0A22,$71035548,$FC2DBC53,
   $5F77804B,$026FD46E,$CAB93409,$E53BEDB3,$ADF51781,$CC6ECA08,$A1968140,$E028DA58,
   $0AA8DD5B,$3A651878,$F28297CA,$CE011E66,$69C58C3F,$A4A19CF3,$F11D4887,$C5EA1A72,
   $24DC0858,$C4277045,$29CA78A2,$4238CF19,$FF94E730,$481EA13A,$C011E952,$DF5EF5CB,
   $EC8F0527,$80AE36EE,$47B1593C,$5AE3F4CE,$7834575E,$CDA3A03F,$7F8AFAFF,$71D9071B,
   $4C6C625C,$CADF43BA,$06CB4B9A,$16230828,$D30A0B45,$17EE621F,$C8530D7F,$448946AB,
   $3F850E62,$974054F1,$20FD7AB4,$73B6D375,$131BE217,$C8B097D4,$B6AC11BB,$9F09EEBC,
   $1D924DA0,$45442C9C,$E4CDE10A,$1B79858E,$5CE85F06,$0984D07A,$417A12A6,$4CC0FCE6,
   $57356466,$99B8670E,$352DD339,$AD254C89,$8381C282,$322CA235,$2743D715,$CFCC7451,
   $4E865B2A,$6B6DE8A2,$AB3E5C1B,$DA4DC220,$65A61AFE,$88E78CA3,$816BFBF4,$939E092D,
   $99AD2283,$CB12298D,$C926EB44,$EED0E9A7,$82F424B9,$98750D39,$164F76C0,$D5789BE8,
   $58C92DEA,$BE15734A,$2A55A7EF,$49D3CB0D,$7941B165,$67FA0F33,$DB48EF68,$8C39D17F,
   $508BC9C7,$25C2C02A,$6218B75F,$349D2B87,$AA4BBA20,$70146D2C,$D095D408,$1C05660B,
   $2E74D503,$FE42683D,$DD83A4F2,$9A1AD957,$19B33F4C,$F2D58FAC,$394E45F8,$81635CD9,
   $D1E03233,$B65CC907,$9F666919,$DD3121A5,$09370216,$318E1C6C,$EF10DA6A,$8B4532FA,
   $BBBA6141,$191651E0,$61876812,$3F762F93,$6C9118E8,$B96990CF,$8E97B278,$B4331D69,
   $F449DC50,$D822164E,$5261F0B1,$84706B32,$1E0D92ED,$4EAF2888,$11F1DB61,$69023CCC,
   $AC80F1BA,$66376504,$89291FD9,$0849BA4D,$FBB595DC,$FF8F020A,$91EFC6AE,$50C59AED,
   $055494D7,$1DC80C3C,$8FE25443,$1E6AB265,$3EF0E859,$3D19FBFD,$909A2095,$FA9C35E1,
   $CE9846E5,$52AA4E83,$A37CB836,$419A7140,$D72B79A9,$A07FC12F,$C4309BBE,$68CF56FB,
   $D5C140DF,$01CD6A37,$54AABB2B,$9253631A,$7D60C389,$D06BAC03,$674C2388,$295527BB,
   $221743C2,$D204786D,$00000000,$00000000,$729C8A05,$F7C6B847,$4AA729C6,$DCFC4B92,
   $2B2041D4,$E38A6401,$6F0EC7A5,$B28294DB,$E9DB91F0,$9D663AD2,$DE1C7BBF,$91F1DD43,
   $4D198467,$6086ECB6,$CD0799A8,$59414A97,$E0EC93E6,$ACE826BE,$BC04CCE0,$A56CF6C4,
   $F53C3A6B,$727BB942,$25A9EE63,$6E7EDF49,$DA3D0953,$26607E73,$95CEB442,$E75439DD,
   $F6A3E526,$7990BD56,$96516B0F,$ECBF3DC9,$4BD2CFFD,$76A5E49E,$EA444EBD,$968D3EC6,
   $927019E3,$5B2E9EF9,$9B471BF5,$6AA08295,$33E698A3,$BB0644A1,$6639C5B3,$830C88B7,
   $FEE1010B,$E2470E36,$307947EE,$B0ED40B5,$B7D9F780,$355041B0,$843F6F23,$8E560511,
   $173A90FB,$7F2134E4,$EDFAE31C,$2AF799E2,$752227A4,$4BBC1F63,$CFEDA0DE,$F8F3E18F,
   $E206AA90,$0D5A8DA6,$0C6396C1,$2C461050,$15D0A98D,$DE939FFC,$6A5A5372,$AF4A98E7,
   $51FE2FFC,$8F9B6F26,$3D6F3714,$36F2FFE9,$68B06A04,$0EF833FF,$400FF49D,$E69953EA,
   $B112BC1A,$23734998,$B44628CD,$3EBB45A4,$310CA1D5,$1AB4EFB9,$86D55655,$2FE4AE09,
   $A2095E0D,$EBC3DE4C,$1B59063A,$536724B4,$97248D34,$46E692C5,$383BA3C3,$2B3AF3D5,
   $DF699D84,$3BA8724F,$4FF3BD11,$C13447AE,$94BB5279,$4D0D96D1,$A4C21597,$FDE0D664,
   $4938F68B,$D7174F86,$C2FBD024,$7EEC5ED3,$8D086D35,$BFD8197D,$CBCCD232,$4F6242BF,
   $E3734CAB,$A70322AA,$5D9DB93D,$A3DD7F76,$B533CEF6,$94E2EAA8,$59BCCBD1,$144CDC46,
   $7BAB8813,$C648A42B,$1A2CE001,$F93E8BB8,$E627D87C,$BACB2E96,$07BEADA1,$BC7AA724,
   $C6DAA2C8,$C97DFDE3,$02EA3976,$A1B2AB18,$5A23149C,$1FA7D852,$C1640F69,$75075AC7,
   $28BF9E99,$E8616015,$885CF9E2,$A2101541,$1CE7AB9B,$EF1D8390,$E19975DD,$06B189B2,
   $55DF5D10,$380ACC16,$E7523E47,$1092819A,$F7D6031D,$D3C9125A,$A8A18356,$D1A6C634,
   $2C9EEC75,$5FF0C325,$B3F8856C,$82C1E280,$43902BD0,$ED7257FE,$EB31A886,$3CD491CA),
  ($FAD9E7DF,$94AF9EB6,$03C94DDD,$9208AE5E,$7158480B,$1D8DE8D6,$BA147AF8,$FD093CD2,
   $E6597CCF,$A45CEB22,$7BF113DA,$9BBDE6E7,$65FFFE5C,$E4EDF4B4,$4E8D2A2F,$7125622E,
   $8F68430D,$1791B81B,$902195C0,$B56A63D1,$30D2EE67,$A980832B,$84862397,$4C0A7FB3,
   $1DC7A05B,$ED58BC0D,$5C4D0637,$5955D7F0,$806FCF4E,$D2B9B1C8,$F910AA02,$06A730E8,
   $46AA0768,$B8B60BD8,$FCBE7D90,$45BF370A,$5EC370A1,$16F6B037,$8B81AFD4,$89227660,
   $D0EC08E7,$DCCCC1B5,$62DF5F58,$E8569491,$A41A977E,$82592E81,$4FCA1164,$AC8EABB7,
   $92AFE356,$FAC90416,$331BA3BA,$3B882D75,$CEE2E561,$A39CD3E6,$D7CCA9E3,$D077A190,
   $534A8A74,$9C7DDE23,$F3B9F1D3,$80973ED9,$209CB4E9,$CE535132,$B6DABB66,$AA299B5F,
   $6DD8D31B,$2D7E9D42,$0D89FAD5,$8A8B6E14,$3FD56224,$6CA88AF8,$13871753,$F5DB7C47,
   $9BCFF55A,$EEF1A479,$6636B381,$76E55AEA,$A33A367A,$8EE24EA4,$C44BBEB0,$25ACDDD7,
   $AA5A2076,$9ADAEECB,$5083C7A9,$0E75707D,$94C87919,$2BD9ADAA,$DFEB84A4,$19E4C866,
   $F070BC0E,$129F9087,$AFF4F7E4,$D9C2E929,$B9DD3725,$6F01928C,$64B8C517,$39463D2D,
   $E4D70A59,$EBFF8CE5,$418AA66C,$B40D6BFD,$3B3C8EFD,$F21B4483,$E5903112,$3654457C,
   $05AED792,$431807E2,$3E92596F,$B1034361,$FE300B06,$0A1C50CD,$B79D802D,$778252C6,
   $0720A104,$0CBB6025,$1AE7015F,$E1E3DC28,$8128F405,$0F127851,$AB1D1B3D,$47712752,
   $9CEF545E,$E24AC45C,$A0F37BA7,$1CEAE0FA,$FDF946DB,$9814FE93,$CC6C93F7,$EC3FB421,
   $75B1A4D2,$833E26AD,$176EFB8A,$6B68B23C,$FB9EDC94,$4904572F,$AC3DBA39,$4BCA4777,
   $93E8D81D,$2762CD8F,$04E9ECD9,$9EB3CE7B,$27BC15ED,$C2E83117,$357C39F5,$EA9884C9,
   $6BBF4954,$FC6E34FE,$21DB8FA2,$13F898AB,$C782F36D,$B7A47389,$B0BD2129,$7B3932E3,
   $C9C24465,$AF27B3C3,$1629C0C1,$B6C37BA5,$5D0A3D7C,$84FE1E69,$59E3D1A5,$1A4DD012,
   $677188CA,$AB4E9373,$546A2B70,$90C6BE06,$EA97BD51,$F37C4CAF,$96460F8F,$647ACA6D,
   $D325453A,$4EC46FEB,$4C035CB9,$3E8605E9,$D68B92A8,$0DDC6809,$DC22C979,$8BEC6638,
   $104E5A8E,$67D3D219,$45634AB5,$2ABEA586,$0BEE609A,$5B9BC7A8,$D2627E71,$936FA672,
   $49AD8B2B,$7D9E020B,$8DE6359B,$5832DFDC,$58A4EAEE,$C7E6198B,$797F654C,$D41E8120,
   $C22C24FF,$F4BC746B,$CB4C32F3,$E084D404,$2A35EF38,$48635F03,$DB02687D,$8757061D,
   $73D63E9D,$522E8F11,$E819CBC7,$BCDF2B68,$6E119EC6,$BF76331C,$A9936DAB,$08D24095,
   $C8857F2E,$728C7A5A,$06679A4F,$D110A9BC,$26FB2EA6,$1F43F88E,$B89A0C6E,$B2AA5B15,
   $7D968995,$4AAD4F5B,$D542DF75,$9FD4C657,$4B23FDBD,$323D65CC,$F6172641,$C38F393B,
   $994183CC,$A152C3BE,$82E1B9D8,$9D1AD60F,$E3F7AB5D,$E744ECC0,$B513F6BB,$38213501,
   $9E6122C8,$ADE9A39B,$343B02BE,$37334D50,$5B6DA733,$55EEB7D5,$7CD1B2DE,$970686C2,
   $D405E43E,$427F0FCE,$701F7340,$C026214F,$83A68293,$40B11F96,$57A366AD,$02CE1058,
   $CFA5DE2A,$7E371A7F,$EDB71C55,$FFC72C8A,$9166AE8B,$68C1AA48,$890FD942,$C68111A7,
   $E71E4784,$79F722BB,$A8D456E0,$D579890C,$9F261983,$70426A02,$EF396AC3,$B0644B4D,
   $F8579149,$DB0CF971,$8AC6949F,$5489BFF9,$AEB3CCAF,$046920B0,$9806B887,$7CF90A27,
   $7F18FF03,$050E289C,$47ED3C23,$651DC241,$74F69F99,$5E95EF34,$EE7E5188,$6DCF82D4,
   $729105D6,$8F854688,$2212C27F,$81F036F5,$970134C4,$B9D103F4,$A27D0D31,$5349873D,
   $BB5341B3,$20A2F54B,$6C9FE850,$F0D554DB,$28BB99AE,$07C038C4,$1C809B10,$30F37594,
   $9DA86F15,$3FE10DC5,$7AB62891,$46162F7E,$325C98F1,$E623E4EC,$3C1C2FF9,$FEA024A6,
   $B23357BF,$349A5524,$63986413,$35FD5D08,$AD7A8172,$96618EEE,$5F844BEA,$CB5D79AE,
   $6AF8721F,$21C5FD67,$0CCEC19E,$5720A78D,$958F4252,$F6726433,$2532637B,$8D4B56D0,
   $15E08D1C,$24CBD5FB,$E2B09016,$3AEF2559,$DA455336,$5AFCCF84,$F5DE6B9C,$51879765,
   $C36B1FB4,$2917BDF2,$605129CE,$A7F5F356,$A1B440EC,$C1412963,$CA0B09B8,$3D2F1D9D,
   $37F24F63,$A53BE30E,$A55DAC35,$5FF2E718,$1F49D6CD,$A2FBDBCA,$442471FE,$F7156C1F,
   $61161285,$7A5E3ACF,$8E2F7846,$CA3A7182,$8848E209,$1B2AD83E,$E179DDCB,$A8E78B07,
   $4A64C6F6,$EF96AC55,$00000000,$00000000,$38F5C320,$6013EADD,$1BA03A14,$3C4815B1,
   $78385E07,$09B548B9,$ECF0271E,$226CE513,$BEFD9621,$63BAF2A9,$2D154E3C,$44D83F26,
   $A694E1E8,$CDFA4946,$7678E90F,$113688F3,$8CA10ED0,$85991645,$0F078C43,$C52809D3,
   $552D103B,$4D6D779F,$F7501D0A,$1E24F0A2,$D1AB33AC,$0167082C,$0960160C,$1438A06F,
   $14A7B657,$F9601C62,$48EAB060,$A035CB92,$24755830,$50E09F49,$FF77304D,$D7B79954,
   $B454CDF0,$E58AFC98,$86085501,$03A91874,$6F56A58D,$62DDFA85,$DEACBFEF,$C44F01FF,
   $192E4C82,$73EB7276,$2EDC03E1,$D6D09178,$4304D0FA,$FBAE0C3A,$2C527577,$9973F6BF,
   $A7D3DAA3,$105180DF,$4243EBB1,$2605C5A3,$85C118DC,$91A1B62A,$08272D47,$C99369F6,
   $F2FECA98,$5D3CF740,$F1378745,$CF34591E,$D98C1EEB,$C8F461DA,$2F9B38AA,$0B7B58E1,
   $4D4467F2,$E32DCC70,$E03EE680,$754C429E,$51C4FCE2,$D3DEB9E4,$68760489,$6E669AA0,
   $C1E56922,$66B4DA35,$028E7696,$4FA367C7,$110961C5,$BA781B80,$520DB13F,$41D617BA,
   $9A88CE11,$335A6DE0,$56E45DE6,$DF65D9C1,$773FD244,$CC9D416A,$2355F934,$5C5BFF6C,
   $12C02C18,$2870B5DE,$D8CB25A0,$155FA843,$36B57428,$78902A97,$186977C9,$AE40BBEF,
   $5A2A9C78,$88457E4C,$C6C5C826,$6A0FBA10,$1E0EED86,$7F501253,$F49950D7,$8C2C5EFC,
   $CD2BA8BC,$31947DB8,$BC73E0B7,$2C19956E,$3D5B14B2,$230BED3F,$40CD9D27,$69A6A264,
   $0AA95BD1,$86300E31,$69313FC2,$B3CD5339,$0E40B708,$1883C04A,$BD34DBFC,$F1B25CF7,
   $3A7BB5B6,$2FB08D1A,$7E5FC448,$D8A5E105,$01473B4B,$DDABC999,$874F6E4A,$DE02D1ED,
   $39B2F86B,$BDB82344,$DD65F232,$5647AFA1,$EBD0861A,$2ED78536,$B3746CF4,$E9319CBD,
   $B1FA1A62,$A692FB7A,$3195D52C,$742B4AB2,$2B72D473,$95C8969A,$E95EF08C,$6174E2F1,
   $C50C85FB,$F807144E,$BFBAAD6A,$BE113B30,$29FCA2E5,$DA6BF15D,$C0A25269,$BB1F13AC),
  ($F9E37BF9,$C22B27F0,$0955EF09,$93FAD23F,$A22A91A2,$32ED4B84,$CC61B1CC,$3898B57B,
   $AD98E5AD,$55825BA9,$9421EC94,$B2EEB806,$CE3C6BCE,$C7EB5875,$1F45851F,$4B1DAC5D,
   $4705D847,$C16BA120,$1A2BA91A,$C5380F46,$909BAD90,$B908971A,$763D5376,$303E1CB7,
   $53486853,$E6FF324C,$61F95461,$6D1AEED2,$6AF1616A,$0193D1E3,$F0B694F0,$51D1F5CF,
   $2728E127,$29B2C3F5,$EB4950EB,$112A768E,$6F9F4D6F,$8FB672F8,$5BC9EA5B,$F0C66C74,
   $2FA9632F,$3F8B9DCD,$DBA5B6DB,$65BC471E,$967C3696,$4D9D5508,$18767318,$3A4BE248,
   $144DB014,$2794936C,$99CE4299,$2AF24525,$75B4E475,$4A8E7DBE,$3A30BE3A,$9DDC82A6,
   $4C0DED4C,$ADE29E11,$C6BDE9C6,$D1D2064D,$E04165E0,$7DA349BF,$E8C0E7E8,$6B9A1787,
   $F6510FF6,$A54437DD,$2392A023,$2254ECE9,$BD6F14BD,$79F0E7D9,$798F2779,$57510C9A,
   $2B13222B,$346DB2D1,$C76984C7,$54118A4A,$83E5EB83,$EFCA4A63,$43BF9943,$CA8D8E3C,
   $BCBB79BC,$FC336BDE,$45580245,$3E184C2E,$06E79B06,$F495C212,$025DDA02,$FF73ED0E,
   $CFE806CF,$4228D472,$A744BDA7,$BCC8E89F,$C5345EC5,$AB626744,$C90F9DC9,$B6BD1660,
   $A3FEFCA3,$B72EC783,$32B13C32,$8BE5DC9E,$A1A326A1,$485D2A8D,$A4CD0AA4,$C6788996,
   $1BFFC41B,$40FB8341,$BA5CE2BA,$08A6A9CC,$E52F49E5,$F386EAA4,$EFF311EF,$1ACC5992,
   $1599DD15,$A2571F6B,$46D1B546,$44A82D27,$6DC2976D,$70C59FF6,$BB888FBB,$8D6525CB,
   $3E8AFF3E,$963AADBA,$8AB0048A,$7C30985C,$EC7AA6EC,$607C389B,$7BD2FD7B,$A822E194,
   $BEE6A3BE,$034086D0,$65431565,$66FCC1CE,$FED08DFE,$B37D69E5,$AE1152AE,$2F323AA0,
   $137E4613,$56C2DD79,$1CCC321C,$31ADCD54,$F5D8B8F5,$DFF456D4,$8B64698B,$F9F3145B,
   $E4FB24E4,$764566A3,$E77293E7,$0CF507AA,$4AEA764A,$59775C03,$FA6ACCFA,$B89B46F9,
   $602D3960,$E8D962D5,$6270E362,$17AA8FDB,$66CAA266,$1C4CA0C7,$7A06907A,$2DE16D93,
   $C05A72C0,$2547C45F,$59943059,$0FB5817A,$8939B389,$0680F955,$08818208,$16395E38,
   $26FC8C26,$AC714FF2,$11239C11,$A9B13077,$3D03483D,$EC8ACCB3,$0B08350B,$6C893F31,
   $70DAC870,$C4ABDEA5,$2E7D0E2E,$BA4811CA,$31388B31,$F155BD97,$21CF7A21,$DD2701E7,
   $0ADC580A,$E94AB336,$4963C149,$23C73D0A,$7D35667D,$5CB72386,$9A47F59A,$5042242C,
   $5115B251,$198CDF42,$6E4B206E,$0A75FEFF,$D64A18D6,$FDA0BA3D,$1E91E81E,$CEDE205A,
   $AC4C88AC,$D041D7AE,$875FAA87,$E42C657F,$FF04E0FF,$36BEE5E2,$B5EE96B5,$6FC9B9E1,
   $671ECF67,$998F2CC0,$12AA2B12,$D301517E,$F2EB4EF2,$AEA218C1,$C207A8C2,$DA342951,
   $868BC786,$61EFE978,$3456A734,$7F701E8C,$04BA4104,$0BE62F1C,$DD422DDD,$9129850C,
   $25753B25,$D6C12EFB,$64977864,$E33F4DC9,$B66721B6,$1579D8E8,$E19508E1,$F860C5B8,
   $30ECE630,$74963190,$8C579F8C,$88A55A4E,$74608974,$CF4DF1B9,$81B83181,$10B9A76D,
   $33655133,$0E265099,$A51967A5,$43BB0591,$63A48E63,$926903DC,$50C1DF50,$9C4F5345,
   $72871272,$3BD833AB,$9CA06E9C,$A4D7E63E,$1D185F1D,$B46E4153,$55AFF355,$126AF05E,
   $AAAB13AA,$24D415BC,$B2DD60B2,$1E9FF7F4,$37DF1037,$05C07F85,$92C67792,$467B7A14,
   $F78562F7,$2087BBDA,$5CFA1C5C,$81902261,$A0774BA0,$CD9EA68A,$2246CD22,$A79760EE,
   $88EDDE88,$83437552,$201B1720,$58E48DE0,$B9D555B9,$7216C8C5,$95F58195,$372D3401,
   $AB7F7EAB,$A11799BB,$EE277CEE,$9F0FD595,$0FB2740F,$676F102D,$84D61D84,$9E9C0476,
   $CB5247CB,$49CEFB6E,$F162F9F1,$D41279C8,$D82C01D8,$1F0C2617,$547B9E54,$97A97C59,
   $39B90939,$E76CE3AF,$93121A93,$C3B8F613,$9EFDB49E,$5BA40B30,$B43AFBB4,$EA0A35E6,
   $F40CD5F4,$5A37DAD3,$DC9640DC,$14EA090B,$A922A4A9,$5E6474B5,$68ACBB68,$FEE03CED,
   $E3C8D2E3,$071328B6,$24A15624,$5302A2FC,$01D46D01,$85C38C07,$FBBEA1FB,$3D58CAFE,
   $6B250C6B,$84505DE4,$B154D7B1,$642F96FD,$19A21E19,$BF886E4F,$D417C2D4,$02D35733,
   $56264456,$68DA9157,$D5C3AFD5,$8710DB34,$8D83F28D,$0D66D649,$6978D669,$7B23B0EA,
   $85027085,$1B5F8871,$914FC091,$3CCB1B1D,$5D2E715D,$0453AE66,$294EF829,$CB1E5FDF,
   $D2F059D2,$F6469521,$40362E40,$B03DEF35,$529C0552,$633CBE4B,$B80138B8,$F7D544C2,
   $0389B703,$7AB06109,$00000000,$00000000,$A8F6C9A8,$DBA7F8B2,$41E24341,$35FE6332,
   $9D74039D,$21146A39,$9B93989B,$D581A82B,$D0AD83D0,$0935782F,$C3D3C5C3,$5FF7A556,
   $981A2F98,$AF31C922,$B7B34CB7,$90BA54EF,$4E50374E,$5291731F,$2DF4B92D,$C0F870C3,
   $5EA7C65E,$7EE3CF6F,$DA71DBDA,$E07FCB19,$289A9528,$4EDDD3D8,$3F5E923F,$13F921BD,
   $6C16FA6C,$F50613F1,$0DEFAE0D,$981CFD23,$FC8D57FC,$4C0E84EB,$E21CBFE2,$82D0A4B1,
   $E6A6FEE6,$89368BAD,$785B4A78,$D292809D,$F83716F8,$47E8ABF7,$056E2C05,$8E25A31B,
   $4F845A4F,$D752FF18,$CA862ACA,$CC0D7769,$3CD7253C,$694940B4,$C4E033C4,$2EA1EB43,
   $9F29D99F,$DE678737,$3BE4D33B,$181F0EA1,$710EA571,$416852A2,$386D6438,$62AF6FA8,
   $C18E1FC1,$A0844858,$C8DBF0C8,$337E9A67,$10F7F110,$2C72BC70,$CDB5DCCD,$BD5B397C,
   $16106A16,$D8E77E62,$BF32CEBF,$86830AD7,$426BF442,$4F4E023B,$EDAECBED,$E5BFB49C,
   $58405D58,$8A760D7D,$0E66190E,$E2AC9C2A,$77E93E77,$B5FD90B0,$4B3E1B4B,$DCB4D004,
   $2C20D42C,$453BFCC4,$57F22957,$ED191D50,$B080BAB0,$E1EC1AFA,$E9148AE9,$EE599B80,
   $7EBCD17E,$2607428F,$17C40717,$5D24F265,$82318682,$6A09C664,$48B7AC48,$A604B10D,
   $73537F73,$BE1BBFAC,$4DD9804D,$28211216,$5A1D875A,$7505E073,$D32434D3,$73851926,
   $7CE10B7C,$D974AF81,$DECB9ADE,$EB99E405,$B3090DB3,$9B5C7BF3,$3582CA35,$FAB3928B,
   $360B7D36,$8003F382,$EA9D3DEA,$94E9FA89,$2AC74F2A,$B1AE3ED6,$D9F86CD9,$9ACFAA10,
   $A690D0A6,$390B6498,$8FDE288F,$F2153B47,$0733F607,$71564E15,$7F68BC7F,$A3C4CE88,
   $AFC53FAF,$AAF1B6A7,$0C3BC30C,$1DDF7124,$8E0A458E,$77D6B740,$F33F23F3,$2B6194C6,
   $FD593AFD,$C9CD08EC,$97A85B97,$C85ED90F,$D179EED1,$8CF6F428,$806C5C80,$957A2B6A,
   $448C6F44,$BBDBC029,$D79E75D7,$7863363A,$DF1FF7DF,$6E5A6802,$5F73AB5F,$FB204368));
 {$ELSE} // 64-bit or Big Endian
 Shark_CE: array[0..7, 0..255] of UInt64 = (
   // box 0
  ($060D838F16F3A365,$A68857EE5CAE56F6,$EBF516353C2C4D89,$652174BE88E85BDC,
   $0D4E9A8086C17921,$27BA7D33CFFA58A1,$88D9E104A237B530,$693B8755A4FBE816,
   $DAC9591826B254A0,$45C2E369FB336AF3,$A96E1FB87B3E4EF4,$B7578F1435EB7EF0,
   $839AF80B32056F74,$AE37F55CC71F277A,$A4208538FDFF37D5,$35991E74AD3CDB6F,
   $BA191594B32A07D1,$5344D1772E572B7B,$E7EFE5DE103FFE43,$A3796FDC41DE5E5B,
   $2CF9643C5FC882E5,$FFDBF6FD48196D22,$33949DFBBBCF780A,$7D15679DD0CEC8BD,
   $5F5E229C024498B1,$1223634762C683CE,$DCC4DA973041F7C5,$0B43190F9032DA44,
   $C05598EDDFC5A6E2,$9E5FD31A7753F4B8,$9AFA8243C0F136FE,$CC4F6B06F3D61528,
   $DF38612A3BC25C0D,$43CF60E6EDC0C996,$CFB3D0BBF855BEE0,$96E071A8ECE28534,
   $21B7FEBCD909FBC4,$8ED4628BB4C41655,$30682646B04CD3C2,$B5FF5DC294BA1FD3,
   $75AAC52F4B7FB931,$E809AD8837AFE641,$0EB2213D8D42D2E9,$9852509561A057DD,
   $AA92A40570BDE53C,$7B18E412C63D6BD8,$A7DC3E85F67C9C1D,$D8618BCE87E33583,
   $E34AB487A79D3C05,$20E397D773DB312F,$05F138321D7008AD,$17D25B757FB68B63,
   $8A7133D20366D413,$0000000000000000,$EAA17F5E96FE8762,$C101F18675176C09,
   $BEBC44CD0488C597,$DB9D30738C609E4B,$ABC6CD6EDA6F2FD7,$5AAF1AAE1F34901C,
   $B00E65F089CA177E,$D47B7825ABF08649,$924520F15B404772,$1686321ED5644188,
   $618425E73F4A999A,$E21EDDEC0D4FF6EE,$D787C398A0732D81,$1F6DF9C7E407FAEF,
   $79B036C4676C0AFB,$0FE6485627901802,$9CF701CCD602959B,$BFE82DA6AE5A0F7C,
   $990639FECB729D36,$CA42E889E525B64D,$B3F2DE4D8249BCB6,$4033DB5BE643625E,
   $4167B2304C91A8B5,$108BB191C397E2ED,$1834132358269361,$541D3B93927642F5,
   $90EDF227FA112651,$1DC52B1145569BCC,$E6BB8CB5BAED34A8,$D276FBAABD03252C,
   $313C4F2D1A9E1929,$FD73242BE9480C01,$9BAEEB286A23FC15,$C9BE5334EEA61D85,
   $C70C720963E4CF6C,$3EDA077B3D0E012B,$97B418C346304FDF,$32C0F490111DB2E1,
   $2BA08ED8E3E9EB6B,$8B255AB9A9B41EF8,$91B99B4C50C3ECBA,$FE8F9F96E2CBA7C9,
   $3A7F56228AACC36D,$B15A0C9B2318DD95,$5953A11314B73BD4,$F3C10516640ADEE8,
   $EDF895BA2ADFEEEC,$ADCB4EE1CC9C8CB2,$DE6C0841911096E6,$84C312EF8E2406FA,
   $A83A76D3D1EC841F,$1C91427AEF845127,$3665A5C9A6BF70A7,$F6303D24797AD645,
   $CD1B026D5904DFC3,$1BC8A89E53A538A9,$7EE9DC20DB4D6375,$51EC03A18F064A58,
   $C4F0C9B4686764A4,$DD90B3FC9A933D2E,$7A4C8D796CEFA133,$73A746A05D8C1A54,
   $0759EAE4BC21698E,$C8EA3A5F4474D76E,$38D784F42BFDA24E,$231F2C6A78589AE7,
   $C3A92350D4460D2A,$72F32FCBF75ED0BF,$BD40FF700F0B6E5F,$157A89A3DEE7EA40,
   $873FA95285A7AD32,$4D7D41DB60821B7F,$1E3990AC4ED53004,$0A1770643AE010AF,
   $9311499AF1928D99,$64751DD5223A9137,$FA2ACECF5569658F,$7C410EF67A1C0256,
   $56B5E945332723D6,$6F3604DAB2084B73,$E95DC4E39D7D2CAA,$13770A2CC8144925,
   $BC14961BA5D9A4B4,$B9E5AE29B8A9AC19,$F169D7C0C55BBFCB,$2446C68EC479F369,
   $806643B63986C4BC,$7FBDB54B719FA99E,$04A55159B7A2C246,$EE042E07215C4524,
   $5BFB73C5B5E65AF7,$0C1AF3EB2C13B3CA,$A22D06B7EB0C94B0,$B8B1C742127B66F2,
   $285C3565E86A40A3,$3B2B3F49207E0986,$3C72D5AD9C5F6008,$770217F9EA2ED812,
   $FC274D40439AC6EA,$4FD5930DC1D37A5C,$2E51B6EAFE99E3C6,$6B93558305AA8935,
   $19607A48F2F4598A,$08BFA2B29BB1718C,$3F8E6E1097DCCBC0,$3983ED9F812F68A5,
   $AC9F278A664E4659,$82CE916098D7A59F,$C2FD4A3B7E94C7C1,$66DDCF03836BF014,
   $E1E2665106CC5D26,$74FEAC44E1AD73DA,$8D28D936BF47BD9D,$62789E5A34C93252,
   $81322ADD93540E57,$CB1681E24FF77CA6,$2512AFE56EAB3982,$D18A4017B6808EE4,
   $705BFD1D560FB19C,$4B70C2547671B81A,$49D81082D720D939,$E0B60F3AAC1E97CD,
   $4E81FA666B01B0B7,$951CCA15E7612EFC,$463E58D4F0B0C13B,$632CF7319E1BF8B9,
   $5CA2992109C73379,$F764544FD3A81CAE,$6AC73CE8AF7843DE,$9F0BBA71DD813E53,
   $85977B8424F6CC11,$5807C878BE65F13F,$686FEE3E0E2922FD,$78E45FAFCDBEC010,
   $6CCABF67B98BE0BB,$11DFD8FA69452806,$CEE7B9D05287740B,$50B86ACA25D480B3,
   $5DF6F04AA315F992,$5E0A4BF7A896525A,$03FCBBBD0B83ABC8,$8F800BE01E16DCBE,
   $D32292C117D1EFC7,$E5473708B16E9F60,$224B4501D28A500C,$FB7EA7A4FFBBAF64,
   $3D26BCC6368DAAE3,$866BC0392F7567D9,$3731CCA20C6DBA4C,$B603E67F9F39B41B,
   $A1D1BD0AE08F3F78,$D935E2A52D31FF68,$AF639C376DCDED91,$0154696BAAD2CAEB,
   $ECACFCD1800D2407,$F03DBEAB6F897520,$02A8D2D6A1516123,$F498EFF2D82BB766,
   $710F9476FCDD7B77,$F8821C19F43804AC,$F9D675725EEACE47,$1A9CC1F5F977F242,
   $5210B81C8485E190,$6D9ED60C13592A50,$F2956C7DCED81403,$BB4D7CFF19F8CD3A,
   $4C2928B0CA50D194,$6E626DB118DA8198,$E4135E631BBC558B,$9DA368A77CD05F70,
   $A574EC53572DFD3E,$09EBCBD93163BB67,$4A24AB3FDCA372F1,$429B098D4712037D,
   $57E1802E99F5E93D,$EF50476C8B8E8FCF,$A085D4614A5DF593,$34CD771F07EE1184,
   $C6581B62C9360587,$2DAD0D57F51A480E,$898D886F08E57FDB,$D6D3AAF30AA1E76A,
   $76567E9240FC12F9,$B4AB34A93E68D538,$B2A6B726289B765D,$8C7CB05D15957776,
   $554952F838A4881E,$D52F114E01224CA2,$60D04C8C95985371,$6789A66829B93AFF,
   $2F05DF81544B292D,$476A31BF5A620BD0,$F5CC869972F97D8D,$488C79E97DF213D2,
   $44968A0251E1A018,$26EE14586528924A,$D0DE297C1C52440F,$C5A4A0DFC2B5AE4F,
   $29085C0E42B88A48,$142EE0C8743520AB,$2AF4E7B3493B2180,$9448A37E4DB3E417),
   // box 1
  ($E2795BA105BA30CE,$65B5D634F5E0FBDD,$2D7D7F1464DD8C55,$EEFBF778ADD1C20B,
   $1EB0FBD1F11968E7,$E6073F45CE30CD8D,$21FFD3CDCCB67E90,$DF0941CFA750A262,
   $C61DF5B1B75EF18A,$C5C7DEFA9DC337C6,$2581B729073C83D3,$A5E97513167173CF,
   $DD3673BD381526B9,$E8BAA1EEF91EBB93,$3B314CF8F625EB34,$579D4BC8D5FC5DF8,
   $BB598EC2E7681B28,$C8A06B1A80708794,$1C8FC9A36E5CEC3C,$F60A5A3F0807D374,
   $1ACE9F353A9395A4,$7E9E50387AAB2CEE,$B5E41069D0466D36,$8CEA6EE3B92602D9,
   $F952DDAD8AF1E7FD,$B19A748D1BCC9075,$2464AE10B2E4C144,$FCC9A070F4A35829,
   $FA88F6E6A06C21B1,$2C98662DD105CEC2,$9065A740D77AEEE5,$CB7A4051AAED41D8,
   $55A279BA4AB9D923,$27BE855B98790708,$BABC97FB52B059BF,$A19711F7DDFB8E8C,
   $047E64E4CB8AFD43,$C386886CC90C4E5E,$C422C7C3281B7551,$FB6DEFDF15B46326,
   $01E51939B5D84297,$5CBBA8BE9C809432,$6F762C7B09447080,$CEE13D8CD4BFFE0C,
   $54476083FF619BB4,$6E933542BC9C3217,$4AF79B520E78F353,$98996F7DB49BE163,
   $A07208CE6823CC1B,$2B3C29823012F5CD,$93BF8C0BFDE728A9,$2225F886E62BB8DC,
   $7F7B4901CF736E79,$0000000000000000,$023F32729F4584DB,$D5CABB805BF4293F,
   $07A44FAFE1173B0F,$E95FB8D74CC6F904,$7B052DE504F9933A,$6AED51A67716CF54,
   $68D263D4E8534B8F,$A96BD9CABE1A810A,$1D6AD09ADB84AEAB,$0D67B5E01DB3B052,
   $52063615ABAEE22C,$8F3045A893BBC495,$D8AD0E604647996D,$AF2A8F5CEAD5F892,
   $3017AF8EBF5922FE,$4034611DF2DC780E,$721CFCE1D2C0DE2B,$28E602C91A8F3381,
   $E1A370EA2F27F682,$29031BF0AF577116,$1914B47E100E53E8,$567852F160241F6F,
   $793A1F979BBC17E1,$EF1EEE411809809C,$6211999B14F7C0D2,$059B7DDD7E52BFD4,
   $43EE4A56D841BE42,$F1AE1590E910E87B,$33CD84C595C4E4B2,$4B12826BBBA0B1C4,
   $EB608AA5D3837DDF,$201ACAF4796E3C07,$BF27EA262CE2E66B,$58C5CC5A570A6971,
   $37B3E0215E4E19F1,$AB54EBB8215F05D1,$8ED55C9126638602,$9AA65D0F2BDE65B8,
   $D7F589F2C4B1ADE4,$5039046734EB66F7,$6CAC073023D9B6CC,$51DC1D5E81332460,
   $17A92AD5272025F6,$47902EB213CB4301,$1B2B860C8F4BD733,$4F6CE68F702A4C87,
   $CF0424B56167BC9B,$997C76440143A3F4,$7AE034DCB121D1AD,$100D657AC6371EF9,
   $0AC3FA4FFCA48B5D,$DEEC58F61288E0F5,$265B9C622DA1459F,$DCD36A848DCD642E,
   $E4380D3751754956,$13D74E31ECAAD8B5,$FD2CB949417B1ABE,$9624F1D683B5977D,
   $4675378BA6130196,$0B26E376497CC9CA,$41D1782447043A99,$E39C4298B0627259,
   $CD3B16C7FE223840,$7787813CAC9261FF,$492DB01924E5351F,$5AFAFE28C84FEDAA,
   $8B4E214C583139D6,$CCDE0FFE4BFA7AD7,$76629805194A2368,$7CA1624AE5EEA835,
   $61CBB2D03E6A069E,$48C8A920913D7788,$8068C23A114DF01C,$D38BED160F3B50A7,
   $32289DFC201CA625,$C1B9BA1E5649CA85,$ED21DC33874C0447,$A3A8238542BE0A57,
   $5B1FE7117D97AF3D,$3D701A6EA2EA92AC,$73F9E5D867189CBC,$9ED839EBE05498FB,
   $5920D563E2D22BE6,$CA9F59681F35034F,$11E87C4373EF5C6E,$97C1E8EF366DD5EA,
   $ACF0A417C0483EDE,$D26EF42FBAE31230,$BCFDC16D067F2027,$BEC2F31F993AA4FC,
   $45AF1CC08C8EC7DA,$31F2B6B70A816069,$D9481759F39FDBFA,$E5DD140EE4AD0BC1,
   $A6335E583CECB583,$38EB67B3DCB82D78,$F5D07174229A1538,$5F6183F5B61D527E,
   $0F58879282F63489,$164C33EC92F86761,$444A05F93956854D,$818DDB03A495B28B,
   $4D53D4FDEF6FC85C,$8D0F77DA0CFE404E,$8416A6DEDAC70D5F,$666FFD7FDF7D3D91,
   $B63E3B22FADBAB7A,$F2743EDBC38D2E37,$A40C6C2AA3A93158,$9F3D20D2558CDA6C,
   $FEF692026BE6DCF2,$2EA7545F4E404A19,$B2405FC631515639,$23C0E1BF53F3FA4B,
   $83B2E9713BD03650,$0641569654CF7998,$B883A589CDF5DD64,$3AD455C143FDA9A3,
   $925A9532483F6A3E,$AAB1F28194874746,$F435684D974257AF,$D1B4DF64907ED47C,
   $390E7E8A69606FEF,$D051C65D25A696EB,$B4010950659E2FA1,$0C82ACD9A86BF2C5,
   $88940A0772ACFF9A,$F39127E276556CA0,$AECF96655F0DBA05,$03DA2B4B2A9DC64C,
   $3F4F281C3DAF1677,$3469CB6A74D3DFBD,$F04B0CA95CC8AAEC,$1F55E2E844C12A70,
   $4CB6CDC45AB78ACB,$C05CA327E3918812,$95FEDA9DA9285131,$B966BCB0782D9FF3,
   $A7D647618934F714,$D61090CB7169EF73,$71C6D7AAF85D1867,$ECC4C50A329446D0,
   $6450CF0D4038B94A,$420B536F6D99FCD5,$75B8B34E33D7E524,$C26391557CD40CC9,
   $DA923C12D9021DB6,$4E89FFB6C5F20E10,$0919D104D6394D11,$8AAB3875EDE97B41,
   $A88EC0F30BC2C39D,$B7DB221B4F03E9ED,$C7F8EC880286B31D,$2F424D66FB98088E,
   $E04669D39AFFB415,$3EAA3125887754E0,$5E849ACC03C510E9,$8257F0488E0874C7,
   $BD18D854B3A762B0,$B3A546FF848914AE,$9CE70B997F111C20,$3C9503571732D03B,
   $E7E2267C7BE88F1A,$63F480A2A12F8245,$602EABE98BB24409,$941BC3A41CF013A6,
   $678AE4466AA57F06,$1232570859729A22,$6D491E099601F45B,$5D5EB1872958D6A5,
   $1473019E0DBDE3BA,$A24D3ABCF76648C0,$85F3BFE76F1F4FC8,$08FCC83D63E10F86,
   $745DAA77860FA7B3,$9180BE7962A2AC72,$87CC8D95F05ACB13,$78DF06AE2E645576,
   $18F1AD47A5D6117F,$358CD253C10B9D2A,$0EBD9EAB372E761E,$F7EF4306BDDF91E3,
   $7023CE934D855AF0,$D42FA2B9EE2C6BA8,$3656F918EB965B66,$9D0212A0CAC95EB7,
   $2AD930BB85CAB75A,$862994AC45828984,$7D447B735036EAA2,$B07F6DB4AE14D2E2,
   $6B08489FC2CE8DC3,$9B4344369E06272F,$AD15BD2E75907C49,$DB77252B6CDA5F21,
   $EA85939C665B3F48,$C945722335A8C503,$159618A7B865A12D,$69377AED5D8B0918,
   $8971133EC774BD0D,$53E32F2C1E76A0BB,$F8B7C4943F29A56A,$FF138B3BDE3E9E65),
   // box 2
  ($7C6A2EB5FDABECC6,$401CDA0A752BBEA0,$1925217156DC57C4,$56DEC6D301D70787,
   $41C751FF73C6AC58,$C9067697A92CB5F9,$3391C917AAA0BC85,$AE0A9A4C0E742AFE,
   $AA8CA972162A62F4,$5AA193912935DF99,$86FD9135FE27E5BA,$FFCA074B1D3F538E,
   $0E3CB65D24CDFC1B,$4384B2E07FE9885D,$C73AC0CA8DE149E2,$48E5BC7645972EB4,
   $BE0D56B46EF9FFD6,$200E6D05C0EF5F50,$E1F17DEE597F7ABD,$0243E31F0C2F2405,
   $F4AB09DD2741F567,$E4ACC52547CC204F,$348F92C3B83CC272,$53837E181F645D75,
   $D8DA319ACF4C7229,$81E3CAE1ECBB9B4D,$D6E687C7EB818E32,$3DAD7F4A8E6D409E,
   $28F70B79F053CF44,$493E3783437A3C4C,$B27203F6461B27C8,$D02357E6FFF0E23D,
   $E8D390676F2EF851,$26CBBD24D49E335F,$EE1640467B5F945E,$4AA65F6949B80AB1,
   $B56C58225487593F,$4FFBE7A2570B5043,$0ABA85633C93B411,$78EC1D8BE5F5A4CC,
   $501B16F215A66B88,$271036D1D27321A7,$7FF2465FF769DA3B,$35541936BED1D08A,
   $B8C886957A8893D9,$2FE950ADE2CFB1B3,$F90FD76A094E3F81,$2DAAB3B2EEE095B6,
   $1ABD499B5C1E6139,$0C7F554228E2D81E,$425F391579049AA5,$C3BCF3F495BF01E8,
   $B4B7D3D7526A4BC7,$0000000000000000,$A0362C112AB9D6E5,$91E406198C364E65,
   $454162C16B98E452,$139FA4126A4FE3D5,$01DB8BF506ED12F8,$9A85088FB648E88C,
   $3AB3249E9CF13E69,$D57EEF2DE143B8CF,$B1EA6B1C4CD91135,$7AAFFE94E9DA80C9,
   $AD92F2A604B61C03,$A3AE44FB207BE018,$EB4BF88D65ECCEAC,$C0249B1E9F7D3715,
   $A8CF4A6D1A0546F1,$C6E14B3F8B0C5B1A,$CE182D43BBB0CB0E,$FC526FA117FD6573,
   $8C471456C2B451AB,$AC497953025B0EFB,$0486333E185E480A,$18FEAA845031453C,
   $A1EDA7E42C54C41D,$06C5D02114716C0F,$055DB8CB1EB35AF2,$E5774ED0412132B7,
   $36CC71DCB413E677,$470281DE67B7C057,$58E2708E251AFB9C,$A914C1981CE85409,
   $B3A9880340F63530,$638ADFE5BF06D70D,$0B610E963A7EA6E9,$927C6EF386F47898,
   $ED8E28AC719DA2A3,$7548C33CCBFA6E2A,$F3B5520935DD8B90,$8D9C9FA3C4594353,
   $31D22A08A68F9880,$0DA4DEB72E0FCAE6,$8FDF7CBCC8766756,$5DBFC8453BA9A16E,
   $8E04F749CE9B75AE,$83A029FEE094BF48,$A4B01F2F32E79EEF,$1C7899BA486F0D36,
   $654F0FC4AB77BB02,$7DB1A540FB46FE3E,$51C09D07134B7970,$CB459588A50391FC,
   $3FEE9C558242649B,$FE118CBE1BD24176,$76D0ABD6C13858D7,$5E27A0AF316B9793,
   $69305A868395631C,$3B68AF6B9A1C2C91,$6DB669B89BCB2B16,$A72877C53825A812,
   $D3BB3F0CF532D4C0,$6FF58AA797E40F13,$96FA5DCD9EAA3092,$2C713847E80D874E,
   $C57923D581CE6DE7,$2B6F6393FA91F9B9,$0922ED89365182EC,$324A42E2AC4DAE7D,
   $16C21CD974FCB927,$956235279468066F,$7B747561EF379231,$449AE9346D75F6AA,
   $F570822821ACE79F,$5939FB7B23F7E964,$7937967EE318B634,$84BE722AF208C1BF,
   $08F9667C30BC9014,$EFCDCBB37DB286A6,$A6F3FC303EC8BAEA,$EA9073786301DC54,
   $62515410B9EBC5F5,$D260B4F9F3DFC638,$9E033BB1AE16A086,$38F0C78190DE1A6C,
   $C267780193521310,$80384114EA5689B5,$9B5E837AB0A5FA74,$F73361372D83C39A,
   $3009A1FDA0628A78,$D4A564D8E7AEAA37,$FB4C347505611B84,$5B7A18642FD8CD61,
   $239605EFCA2D69AD,$F8D45C9F0FA32D79,$BB50EE7F704AA524,$392B4C7496330894,
   $0FE73DA82220EEE3,$3717FA29B2FEF48F,$F26ED9FC33309968,$D73D0C32ED6C9CCA,
   $DA99D285C363562C,$DE1FE1BBDB3D1E26,$738D131DDF8B0225,$292C808CF6BEDDBC,
   $BC4EB5AB62D6DBD3,$039868EA0AC236FD,$CC5BCE5CB79FEF0B,$B031E0E94A3403CD,
   $C4A2A82087237F1F,$B72FBB3D58A87D3A,$AFD111B908993806,$68EBD173857871E4,
   $9D9B535BA4D4967B,$E9081B9269C3EAA9,$71CEF002D3A42620,$93A7E50680196A60,
   $891AAC9DDC070B59,$155A74337E3E8FDA,$4E206C5751E642BB,$9721D6389847226A,
   $12442FE76CA2F12D,$2553D5CEDE5C05A2,$A275CF0E2696F2E0,$24885E3BD8B1175A,
   $670CECDBA7589F07,$749348C9CD177CD2,$64948431AD9AA9FA,$2AB4E866FC7CEB41,
   $E6EF263A4BE3044A,$E734ADCF4D0E16B2,$903F8DEC8ADB5C9D,$F02D3AE33F1FBD6D,
   $725698E8D96610DD,$1DA3124F4E821FCE,$1719972C7211ABDF,$11DC470D6660C7D0,
   $EC55A3597770B05B,$BFD6DD416814ED2E,$57054D26073A157F,$1E3B7AA544402933,
   $5FFC2B5A3786856B,$61C93CFAB329F308,$3E3517A084AF7663,$F6E8EAC22B6ED162,
   $1007CCF8608DD528,$66D7672EA1B58DFF,$8B594F82D0282F5C,$1FE0F15042AD3BCB,
   $4B7DD49C4F551849,$4C638F485DC966BE,$CFC3A6B6BD5DD9F6,$46D90A2B615AD2AF,
   $8565F9DFF4E5D347,$94B9BED292851497,$FA97BF80038C097C,$B9130D607C658121,
   $DC5C02A4D7123A23,$224D8E1ACCC07B55,$87261AC0F8CAF742,$D901BA6FC9A160D1,
   $AB57228710C7700C,$21D5E6F0C6024DA8,$98C6EB90BA67CC89,$827BA20BE679ADB0,
   $991D6065BC8ADE71,$5546AE390B15317A,$A56B94DA340A8C17,$071E5BD4129C7EF7,
   $E02AF61B5F926845,$6B73B9998FBA4719,$DFC46A4EDDD00CDE,$770B2023C7D54A2F,
   $7E29CDAAF184C8C3,$BA8B658A76A7B7DC,$9C40D8AEA2398483,$9FD8B044A8FBB27E,
   $DB425970C58E44D4,$E269150453BD4C40,$3C76F4BF88805266,$F1F6B11639F2AF95,
   $549D25CC0DF82382,$4DB804BD5B247446,$8A82C477D6C53DA4,$5258F5ED19894F8D,
   $6E2E015291091DEB,$C1FF10EB999025ED,$BD953E5E643BC92B,$C8DDFD62AFC1A701,
   $5C6443B03D44B396,$6C6DE24D9D2639EE,$1481FFC678D39D22,$D1F8DC13F91DF0C5,
   $CA9E1E7DA3EE8304,$DD878951D1FF28DB,$6012B70FB5C4E1F0,$1B66C26E5AF373C1,
   $E3B29EF155505EB8,$70157BF7D54934D8,$2E32DB58E422A34B,$6AA8326C895755E1,
   $B6F430C85E456FC2,$FD89E4541110778B,$88C12768DAEA19A1,$CD8045A9B172FDF3),
   // box 3
  ($99183E616655B742,$B2872032A50D6860,$0946F63B060528EF,$36612B9A141EF07D,
   $0634DA84DD49579B,$FC9C9E9B486C8A57,$A63FE3C0744E6FD0,$F1515758D8B46BF9,
   $3E82559FCD5197FF,$92E12D262BC40177,$C3BB433A5A7752C5,$21C3852A5183267A,
   $39130725CF528F09,$9BA7DB1D2DC12998,$C58F99BE873E055E,$D9D424498F32656C,
   $27F75FAE8CCA71E1,$59B91019A8FC3430,$CE768AF9CAAFB36B,$9D930199F0887E03,
   $63B07A7EF3706A8E,$B5167288A70E7096,$40CC1A28E967D22E,$4D01D3EB79BF3380,
   $9E896CDB6456AFB4,$2548BAD2C75EEF3B,$A79A6BFEAB0420BD,$9F2CE4E5BB1CE0D9,
   $32EA146282C3393C,$6D67DEFFF7765A97,$83775912B31080EB,$F5DA68A04E69A2B8,
   $1196743498D4819C,$0BF913474D91B635,$43D6776A7DB90399,$444725D07FBA1B6F,
   $6584A0FA2E393D15,$3F27DDA1121BD892,$F6C005E2DAB7730F,$56CB3CA673B04B44,
   $642128C4F1737278,$BF4AE9F135D589CE,$B038C54EEE99F6BA,$F47FE09E9123EDD5,
   $75B75CF069A7F3E4,$D419ED8A1FEA84C2,$73838674B4EEA47F,$498AEC13EF62FAC1,
   $20660D148EC96917,$A48006BC3FDAF10A,$2F1421AB55851663,$0A5C9B7992DBF958,
   $D1375A4C567D02EE,$0000000000000000,$C842507D17E6E4F0,$F3EEB2249320F523,
   $C9E7D843C8ACAB9D,$FF86F3D9DCB25BE0,$B4B3FAB678443FFB,$B19D4D7031D3B9D7,
   $79DF1D0D26355D27,$8EBA90D123C86145,$AA57A23D3BDCC113,$CB583D3F83383547,
   $D871AC7750782A01,$E162AB529F2AA508,$38B68F1B1018C064,$237C60561A17B8A0,
   $A31154063DD9E9FC,$713C6308FF7A3AA5,$1A6F6773D54537A9,$08E37E05D94F6782,
   $357B46D880C021CA,$6CC256C1283C15FA,$CFD302C715E5FC06,$BDF50C8D7E411714,
   $7CF1AACB6FA2DB0B,$5240035EE56D8205,$7B60F8716DA1C3FD,$01A5883EDF4A4F6D,
   $DD5F1BB119EFAC2D,$5474D9DA3824D59E,$0F722CBFDB4C7F74,$17A2AEB0459DD607,
   $37C4A3A4CB54BF10,$C21ECB04853D1DA8,$4273FF54A2F34CF4,$DACE490B1BECB4DB,
   $6AF68C45F5754261,$46F8C0AC342E85B5,$854383966E59D770,$81C8BC6EF8841E31,
   $3BACE25984C611D3,$1033FC0A479ECEF1,$1C5BBDF7080C6032,$7412D4CEB6EDBC89,
   $A8E8474170485FC9,$B8DBBB4B37D69138,$079152BA020318F6,$72260E4A6BA4EB12,
   $905EC85A60509FAD,$2DABC4D71E1188B9,$D092D27289374D83,$610F9F02B8E4F454,
   $02BFE57C4B949EDA,$95707F9C29C71981,$6FD83B83BCE2C44D,$5D322FE13E21FD71,
   $34DECEE65F8A6EA7,$CD6CE7BB5E7162DC,$FB0DCC214A6F92A1,$2EB1A9958ACF590E,
   $DCFA938FC6A5E340,$669ECDB8BAE7ECA2,$151D4BCC0E0948DD,$FD3916A59726C53A,
   $581C982777B67B5D,$1BCAEF4D0A0F78C4,$DFE0FECD527B32F7,$128C19760C0A502B,
   $84E60BA8B113981D,$3C3DB0E386C50925,$7FEBC789FB7C0ABC,$7D5422F5B0E89466,
   $D70380C88B345575,$BBC1D609A308408F,$E278C6100BF474BF,$5E2842A3AAFF2CC6,
   $6B53047B2A3F0D0C,$F7658DDC05FD3C62,$9A025323F28B66F5,$8C0575AD685CFF9F,
   $76AD31B2FD792253,$68496939BEE1DCBB,$7E4E4FB7243645D1,$E44C1C94D6BD2324,
   $BEEF61CFEA9FC6A3,$91FB4064BF1AD0C0,$052EB7C64997862C,$4A9081517BBC2B76,
   $8F1F18EFFC822E28,$3A096A675B8C5EBE,$EE1087ED4466DA7C,$2652D79053803E8C,
   $7099EB36203075C8,$C7307CC2CCAA9B84,$5C97A7DFE16BB21C,$50FFE622AEF91CDF,
   $8DA0FD93B716B0F2,$69ECE10761AB93D6,$31F07920161DE88B,$13299148D3401F46,
   $031A6D4294DED1B7,$CCC96F85813B2DB1,$14B8C3F2D14307B0,$8659EED4FA8706C7,
   $BA645E377C420FE2,$2920FB2F88CC41F8,$87FC66EA25CD49AA,$1EE4588B4398FEE8,
   $ECAF62910FF244A6,$F817A163DEB14316,$45E2ADEEA0F05402,$806D345027CE515C,
   $576EB498ACFA0429,$A5258E82E090BE67,$892BC26B21CB79B3,$6E7DB3BD63A88B20,
   $4E1BBEA9ED61E237,$ADC6F08739DFD9E5,$8B9427176A5FE769,$A1AEB17A764D7726,
   $4B35096FA4F6641B,$22D9E868C55DF7CD,$55D151E4E76E9AF3,$966A12DEBD19C836,
   $0DCDC9C390D8E1AE,$F24B3A1A4C6ABA4E,$24ED32EC1814A056,$AF7915FB724B473F,
   $2885731157860E95,$9C3689A72FC2316E,$475D4892EB64CAD8,$AC6378B9E6959688,
   $A00B3944A907384B,$C695F4FC13E0D4E9,$3055F11EC957A7E6,$6215F2402C3A25E3,
   $DE4576F38D317D9A,$9344A518F48E4E1A,$82D2D12C6C5ACF86,$EFB50FD39B2C9511,
   $E981D5574665C28A,$5F8DCA9D75B563AB,$B60C1FCA33D0A121,$FE237BE703F8148D,
   $D6A608F6547E1A18,$B97E3375E89CDE55,$D388BF301DE99C34,$5B06F565E368AAEA,
   $F0F4DF6607FE2494,$1607268E9AD7996A,$AEDC9DC5AD010852,$E0C7236C4060EA65,
   $EA9BB815D2BB133D,$888E4A55FE8136DE,$5AA37D5B3C22E587,$C104A64611E3CC1F,
   $515A6E1C71B353B2,$C42A118058744A33,$7708B98C22336D3E,$2A3A966D1C12904F,
   $8A31AF29B515A804,$ED0AEAAFD0B80BCB,$2C0E4CE9C15BC7D4,$0C6841FD4F92AEC3,
   $98BDB65FB91FF82F,$1F41D0B59CD2B185,$B322A80C7A47270D,$E6F3F9E89D29BDFE,
   $7AC5704FB2EB8C90,$A94DCF7FAF0210A4,$787A9533F97F124A,$DB6BC135C4A6FBB6,
   $048B3FF896DDC941,$E8245D69992F8DE7,$E3DD4E2ED4BE3BD2,$CAFDB5015C727A2A,
   $B7A997F4EC9AEE4C,$E75671D64263F293,$2B9F1E53C358DF22,$18D0820F9ED1A973,
   $ABF22A03E4968E7E,$A2B4DC38E293A691,$673B458665ADA3CF,$F9B2295D01FB0C7B,
   $D22D370EC2A3D359,$97CF9AE06253875B,$0ED7A48104063019,$482F642D3028B5AC,
   $C0A12E78CEA98372,$4FBE3697322BAD5A,$19750A31419BE61E,$41699216362D9D43,
   $D5BC65B4C0A0CBAF,$E5E994AA09F76C49,$EB3E302B0DF15C50,$94D5F7A2F68D56EC,
   $53E58B603A27CD68,$3D9838DD598F4648,$60AA173C67AEBB39,$1DFE35C9D7462F5F,
   $4CA45BD5A6F57CED,$BC5084B3A10B5879,$FAA8441F9525DDCC,$334F9C5C5D897651),
   // box 4
  ($DA1687A883ADF27E,$E35C9378578D9F22,$303CA4531637FA40,$A088321F74B20375,
   $C9863F3A9ACB95E9,$5FCF47C57D0B0ED4,$4AA211E4E1280B4B,$E1A4C9BA871D1289,
   $4926664759F03A4F,$ADFB36EDE3707BCA,$CF7BD1891F8EF7E1,$9735559E8F882792,
   $5932A976F84E6CDC,$9DC792BEF547818A,$06FDEEB385456208,$46AD38771EA2CF5B,
   $5EB36AA41543B27B,$8B2EB33CD1BCB511,$71105FF6E598EBBC,$5441AD846F8C1463,
   $4C5FFF57646D6943,$F3485C49F633C9B1,$9CBBBFDF9D0F3D25,$22D031A067192178,
   $CA0248992213A4ED,$19627FB263A9C18F,$9330E1EFDA5DC831,$1390B89219666797,
   $2EDF18339893E568,$6C779435D3E4C590,$53C06E568281CAC4,$6FF3E3966B3CF494,
   $FE3B58BB61F1B10E,$77EDB14560DD89B4,$02F85AC2D0908DAB,$12EC95F3712EDB38,
   $85D9C06DFEA6FCAA,$90B4964C6285F935,$F1B0068B26A3441A,$729428555D40DAB8,
   $5C4B3066C5D33FD0,$5D371D07AD9B837F,$A48D866E2167ECD6,$B661139D504937EE,
   $A27068DDA4228EDE,$F8C6B608E4B4D306,$6BF657E73EE91B37,$AC871B8C8B38C765,
   $4EA7A595B4FDE4E8,$0D7304F297C278BF,$B71D3EFC38018B41,$AE7F414E5BA84ACE,
   $AF036C2F33E0F661,$0000000000000000,$B89660CC7F537E55,$A675DCACF1F7617D,
   $610490C74426BD2F,$C18CA2D83094BE5A,$2ADAAC42CD460ACB,$7D1F76651A122FAC,
   $C58916A9654151F9,$EDABE0297897D699,$2D5B6F90204BD46C,$26D585D132CCCEDB,
   $9F3FC87C25D70C21,$C60D610ADD9960FD,$80A0597DC33BAFA6,$D0E44088F9625466,
   $1D67CBC3367C2E2C,$2C2742F1480368C3,$89D6E9FE012C38BA,$E9AE54582D42393A,
   $3ECBD702392DB3FB,$B5E5643EE89106EA,$A882AFFDDEED28C6,$1AE60811DB71F08B,
   $924CCC8EB215749E,$FCC30279B1613CA5,$825803BF13AB220D,$D992F00B3B75C37A,
   $C8FA125BF2832946,$35453D432BAAA94C,$F9BA9B698CFC6FA9,$37BD6781FB3A24E7,
   $791AC2144FC7C00F,$16E9218224FB349B,$DB6AAAC9EBE54ED1,$D8EEDD6A533D7FD5,
   $7C635B04725A9303,$553D80E507C4A8CC,$9A46516C184A5F2D,$14117B40F46BB930,
   $1EE3BC608EA41F28,$27A9A8B05A847274,$4050D6C49BE7AD53,$7BE298D69F574DA4,
   $6A8A7A8656A1A798,$4D23D2360C25D5EC,$1014CF31A1BE5693,$B264A7EC059CD84D,
   $EA2A23FB959A083E,$F0CC2BEA4EEBF8B5,$76919C240895351B,$0B8EEA4112871AB7,
   $47D1151676EA73F4,$BDEFF9DC42CE2D59,$2BA68123A50EB664,$057999103D9D530C,
   $E759270902587081,$EF53BAEBA8075B32,$4FDB88F4DCB55847,$6E8FCEF70374483B,
   $1168E250C9F6EA3C,$1B9A2570B3394C24,$706C72978DD05713,$865DB7CE467ECDAE,
   $52BC4337EAC9766B,$504419F53A59FBC0,$8F2B074D84695AB2,$6078BDA62C6E0180,
   $43D4A167233F9C57,$0EF773512F1A49BB,$0C0F2993FF8AC410,$4BDE3C858960B7E4,
   $66855315A92B6388,$D360372B41BA6562,$584E84179006D073,$9B3A7C0D7002E382,
   $A5F1AB0F492F5079,$2822F6801DD68760,$445562B5CE3242F0,$AA7AF53F0E7DA56D,
   $3C338DC0E9BD3E50,$3BB24E1204B0E0F7,$D59DD998C4FF076A,$91C8BB2D0ACD459A,
   $84A5ED0C96EE4005,$33B8D3F0AEEFCB44,$57C5DA27D7542567,$32C4FE91C6A777EB,
   $3439102243E215E3,$C7714C6BB5D1DC52,$3FB7FA6351650F54,$87219AAF2E367101,
   $F5B5B2FA7376ABB9,$412CFBA5F3AF11FC,$DCEB691B06E89076,$BB12176FC78B4F51,
   $73E8053435086617,$E220BE193FC5238D,$B09CFD2ED50C55E6,$B9EA4DAD171BC2FA,
   $9E43E51D4D9FB08E,$36C14AE093729848,$A9FE829CB6A59469,$0405B47155D5EFA3,
   $0AF2C7207ACFA618,$7E9B01C6A2CA1EA8,$DD97447A6EA02CD9,$0781C3D2ED0DDEA7,
   $7866EF75278F7CA0,$D1986DE9912AE8C9,$CB7E65F84A5B1842,$CD838B4BCF1E7A4A,
   $AB06D85E663519C2,$D4E1F4F9ACB7BBC5,$FDBF2F18D929800A,$F23471289E7B751E,
   $BC93D4BD2A8691F6,$3D4FA0A181F582FF,$BA6E3A0EAFC3F3FE,$5AB6DED540965DD8,
   $EB560E9AFDD2B491,$0976B083C217971C,$ECD7CD4810DF6A36,$23AC1CC10F519DD7,
   $BE6B8E7FFA161C5D,$7FE72CA7CA82A207,$C0F08FB958DC02F5,$7A9EB5B7F71FF10B,
   $A709F1CD99BFDDD2,$8DD35D8F54F9D719,$8CAF70EE3CB16BB6,$E4DD50AABA804185,
   $83242EDE7BE39EA2,$98BE0BAEC8DAD286,$690E0D25EE79969C,$95CD0F5C5F18AA39,
   $56B9F746BF1C99C8,$7469C6E6D805B8B0,$8A529E5DB9F409BE,$E6250A686A10CC2E,
   $2FA33552F0DB59C7,$42A88C064B7720F8,$6D0BB954BBAC793F,$181E52D30BE17D20,
   $BF17A31E925EA0F2,$94B1223D37501696,$E8D27939450A8595,$CCFFA62AA756C6E5,
   $383639B1BC68D1F3,$EE2F978AC04FE79D,$A30C45BCCC6A3271,$1F9F9101E6ECA387,
   $B1E0D04FBD44E949,$242DDF13E25C4370,$156D56219C23059F,$88AAC49F69648415,
   $6280E764FCFE8C2B,$DF6F1EB8BE30A172,$E5A17DCBD2C8FD2A,$E0D8E4DBEF55AE26,
   $63FCCA0594B63084,$A1F41F7E1CFABFDA,$295EDBE1759E3BCF,$67F97E74C163DF27,
   $038477A3B8D83104,$DE1333D9D6781DDD,$3ACE63736CF85C58,$D619AE3B7C27366E,
   $5BCAF3B428DEE177,$B3188A8D6DD464E2,$1C1BE6A25E349283,$017C2D616848BCAF,
   $8E572A2CEC21E61D,$F631C559CBAE9ABD,$81DC741CAB731309,$FF4775DA09B90DA1,
   $B499495F80D9BA45,$0F8B5E304752F514,$394A14D0D4206D5C,$CE07FCE877C64B4E,
   $F4C99F9B1B3E1716,$C4F53BC80D09ED56,$C208D57B884C8F5E,$080A9DE2AA5F2BB3,
   $314089327E7F46EF,$FA3EECCA34245EAD,$20286B62B789ACD3,$7515EB87B04D041F,
   $513834945211476F,$650124B611F3528C,$17950CE34CB38834,$45294FD4A67AFE5F,
   $21544603DFC1107C,$485A4B2631B886E0,$6872204486312A33,$647D09D779BBEE23,
   $2551F2728A14FFDF,$D765835A146F8AC1,$D21C1A4A29F2D9CD,$99C226CFA0926E29,
   $FB42C1AB5C6CE202,$C374F81AE00433F1,$964978FFE7C09B3D,$F74DE838A3E62612),
   // box 5
  ($74B87B36B0592C6A,$3D82D75DFFB4B81C,$8884246715267825,$DAF2D8A77ED4E5DE,
   $FEB118650E53F9C7,$BD2D1AEA59226B06,$26CE87F6DBABB191,$32772ECBEB66BD0A,
   $D4BBF82BC5104C8C,$055357720C4E03A1,$EF5BE62A32D0F6FD,$BE1C84C45D186ACA,
   $ACC7E4A565A1643C,$8DD7731519687B84,$11EAFE4F3C830F3A,$04EF8E68A358AFE5,
   $40AD9CA1534B930D,$E44191D4855A5C0E,$6001D20B809420F1,$73666B70173B8243,
   $372479B9E728BEAB,$45FECBD35F0590AC,$7057F55E1301838F,$FF0DC17FA1455583,
   $0CC467B810E804DA,$B9C29482FA7AC4E3,$A003831D754960E6,$8A096353BE0AD5AD,
   $DD2CC8E1D9B64BF7,$C7DC415052BFEE3E,$9F0C137421D17572,$35A93E8D4C041323,
   $9A5F44062D9F76D3,$71EB2C44BC172FCB,$0FF5F99614D20516,$7789E518B4632DA6,
   $C99561DCE97B476C,$5276FCC06BF29DFB,$4A0B32454BD795BA,$9274ADD69E2FDDEC,
   $4F5865374799961B,$B2D8E37C4DF06E10,$C4EDDF7E5685EFF2,$B3643A66E2E6C254,
   $D50721316A06E0C8,$8BB5BA49111C79E9,$2BB639546455190F,$F8D3D1390627FBAA,
   $38D1802FF3FABBBD,$DFA18FD5729AE67F,$4EE4BC2DE88F3A5F,$F72628AF12F5FEBC,
   $0AA6AEE4189C06B7,$0000000000000000,$9EB0CA6E8EC7D936,$CB1826E84257EAE4,
   $187DCE8520250841,$C28F16225EF1ED9F,$C333CF38F1E741DB,$4220DB95F8673E85,
   $DC9011FB76A0E7B3,$105627559395A37E,$2F59B73CC70DB6EA,$E112C6A689145FAF,
   $82228A830DBA7E92,$2EE56E26681B1AAE,$2A0AE04ECB43B54B,$47738CE7F4293D24,
   $A7DD935BD22BCECF,$D2D93177CD644EE1,$EBB4684291885918,$0E49208CBBC4A952,
   $A550D46F79076347,$411145BBFC5D3F49,$E6CCD6E02E76F186,$4BB7EB5FE4C139FE,
   $5D8305567F2098ED,$95AABD90394D73C5,$25FF19D8DF91B05D,$86CD04EBAEE2D177,
   $03319E2E043A01CC,$6B1BA5F5371E8A02,$76353C021B7581E2,$64EE5C6323CC8F14,
   $5C3FDC4CD03634A9,$6996E2C19C32278A,$8938FD7DBA30D461,$7B4D82A0A48B297C,
   $BFA05DDEF20EC68E,$8EE6ED3B1D527A48,$61BD0B112F828CB5,$66631B5788E0229C,
   $55A8EC86CC9033D2,$1C9240ED837DA7A4,$150570279FDBA0DF,$53CA25DAC4E431BF,
   $D636BF1F6E3CE104,$CAA4FFF2ED4146A0,$787C1C8EA0B128B0,$AD7B3DBFCAB7C878,
   $FC3C5F51A57F544F,$B78BB40E41BE6DB1,$8C6BAA0FB67ED7C0,$CE4B719A4E19E945,
   $F96F0823A93157EE,$7D2F4BFCACFF2B11,$3EB34973FB8EB9D0,$E39F81922238F227,
   $239DD084D7E5B230,$1FA3DEC38747A668,$C5510664F99343B6,$C829B8C6466DEB28,
   $85FC9AC5AAD8D0BB,$B6376D14EEA8C1F5,$9D8154408AFDD8FA,$3BE01E01F7C0BA71,
   $628C953F2BB88D79,$6D796CA93F6A886F,$FA5E960DAD0B5622,$E5FD48CE2A4CF04A,
   $E7700FFA81605DC2,$2DD4F0086C211B62,$2221099E78F31E74,$DB4E01BDD1C2499A,
   $F417B68116CFFF70,$B506F33AEA92C039,$514762EE6FC89C37,$9C3D8D5A25EB74BE,
   $396D59355CEC17F9,$CCC636AEE53544CD,$0B1A77FEB78AAAF3,$E9392F763AA4F490,
   $AAA52DF96DD56651,$46CF55FD5B3F9160,$A4EC0D75D611CF03,$AFF67A8B619B65F0,
   $3415E797E312BF67,$7AF15BBA0B9D8538,$811314AD09807F5E,$8771DDF101F47D33,
   $969B23BE3D777209,$D365E86D6272E2A5,$58D05224736E9B4C,$C660984AFDA9427A,
   $5414359C63869F96,$E885F66C95B258D4,$655285798CDA2350,$6CC5B5B3907C242B,
   $6FF42B9D944625E7,$C0025116F5DD4017,$A28EC429DE65CD6E,$63304C2584AE213D,
   $7FA20CC807D38699,$996EDA2829A5771F,$1B4C50AB241F098D,$1E1F07D928510A2C,
   $33CBF7D14470114E,$B055A448E6DCC398,$98D2033286B3DB5B,$EC6A780436EAF731,
   $A1BF5A07DA5FCCA2,$BAF30AACFE40C52F,$F144E1F31A81FCD1,$E0AE1FBC2602F3EB,
   $14B9A93D30CD0C9B,$596C8B3EDC783708,$682A3BDB33248BCE,$B87E4D98556C68A7,
   $80AFCDB7A696D31A,$5725ABB267BC9E5A,$914533F89A15DC20,$5EB29B787B1A9921,
   $01BCD91AAF16AC44,$C1BE880C5ACBEC53,$EDD6A11E99FC5B75,$028D4734AB2CAD88,
   $8F5A3421B244D60C,$4DD52203ECB53B93,$3F0F906954981594,$AE4AA391CE8DC9B4,
   $3698A0A3483E12EF,$F5AB6F9BB9D95334,$082BE9D0B3B0AB3F,$D1E8AF59C95E4F2D,
   $D87F9F93D5F84856,$6E48F2873B5089A3,$2443C0C270871C19,$B1E97D5249CA6FDC,
   $7C9392E603E98755,$839E5399A2ACD2D6,$19C1179F8F33A405,$DE1D56CFDD8C4A3B,
   $20AC4EAAD3DFB3FC,$1AF089B18B09A5C9,$3A5CC71B58D61635,$444212C9F0133CE8,
   $72DAB26AB82D2E07,$4C69FB1943A397D7,$F3C9A6C7B1AD5159,$1D2E99F72C6B0BE0,
   $B4BA2A2045846C7D,$E22358888D2E5E63,$2887A77A606F18C3,$A8286ACDC6F9CBD9,
   $5F0E4262D40C3565,$EEE73F309DC65AB9,$9BE39D1C8289DA97,$1634EE099BE1A113,
   $EA08B1583E9EF55C,$9727FAA49261DE4D,$2C682912C337B726,$CFF7A880E10F4501,
   $1788371334F70D57,$27725EEC74BD1DD5,$3146B0E5EF5CBCC6,$099730CA1CA6077B,
   $F2757FDD1EBBFD1D,$6AA77CEF98082646,$BB4FD3B65156696B,$569972A8C8AA321E,
   $A3321D337173612A,$50FBBBF4C0DE3073,$5A5D1510D84236C4,$FD80864B0A69F80B,
   $07DE1046A762AE29,$A6614A417D3D628B,$D78A6605C12A4D40,$67DFC24D27F68ED8,
   $BC91C3F0F634C742,$D05476436648E369,$493AAC6B4FED9476,$12DB606138B90EF6,
   $A994B3D769EF679D,$211097B07CC91FB8,$30FA69FF404A1082,$3C3E0E4750A21458,
   $7504A22C1F4F802E,$844043DF05CE7CFF,$F0F838E9B5975095,$7E1ED5D2A8C52ADD,
   $90F9EAE235037064,$0662C95C0874026D,$9416648A965BDF81,$F69AF1B5BDE352F8,
   $0D78BEA2BFFEA89E,$293B7E60CF79B487,$D9C346897AEEE412,$FBE24F17021DFA66,
   $1367B97B97AFA2B2,$AB19F4E3C2C3CA15,$48867571E0FB3832,$93C874CC313971A8,
   $79C0C5940FA784F4,$CD7AEFB44A23E889,$439C028F577192C1,$5BE1CC0A77549A80),
   // box 6
  ($714D28D778656928,$C88A7C6B84F64F7C,$EC43CAC5AB89AACA,$777FA38110DC16A3,
   $0F7D5C87E4213B5C,$73F051E5F3A1EF51,$EA714193C330D541,$95E5F3DAE016C4F3,
   $63D3738095A0E173,$9825D66F8FF379D6,$E8CC38A148F45338,$A840B0C025F06BB0,
   $944135C35F748735,$74661CAA247AD31C,$E7B16426ACD56864,$D1E689DF6E6F0589,
   $A73DEC47C1D150EC,$64453ECF427BDD3E,$0ED99A9E5B43789A,$7B1B402DC05BE840,
   $0DC025B56FE5BD25,$3F183A284E22293A,$A0ABA108160A6CA1,$46BE033705BD4703,
   $86DF6E94B2B10F6E,$A216D83A9DCEEAD8,$129E5B57EDC5885B,$7E3074509C445274,
   $7D29CB7BA8E297CB,$1611A9330EB871A9,$486799A95EFE3F99,$9FB39B205828459B,
   $D0424FC6D10D464F,$E968FEB8F79610FE,$5D6F8FB164E08B8F,$AAFDC9F2AE34EDC9,
   $02BD79328BC48679,$9B3C6944BB55BC69,$6277B5992AC2A2B5,$877BA88D0DD34CA8,
   $FA5263F6A531DB63,$2E9FDE54974164DE,$CDA14816D8E9F548,$675C81E476DD1881,
   $2A102C30743C9D2C,$37F32BE07DD82E2B,$256D70B7901DA670,$4CE86BCDBD83C66B,
   $50AFAA040B0536AA,$EF5A75EE9F2F6F75,$B3913C4644ADA73C,$1187E47CD9634DE4,
   $C54A59DEEB13F259,$0000000000000000,$01A4C619BF6243C6,$90CEC7A7BC097EC7,
   $F94BDCDD91971EDC,$8E347F5C814B087F,$C7F720EC60D77420,$354E52D2F61CA852,
   $34EA94CB497EEB94,$AE723B964D49143B,$F48BF968FE72A3F9,$FC60E8A0CD88A4E8,
   $2909931B409A5893,$BD48A6D81FEEDFA6,$6CAE2F077181DA2F,$AD6B84BD79EFD184,
   $18C833AD55FB0933,$204644CACC021C44,$392AB17E269B56B1,$14ACD001857CF7D0,
   $8ABB8D386236F18D,$EEFEB3F7204D2CB3,$F636805A75B62580,$2BB4EA29CB5EDEEA,
   $C653E6F5DFB537E6,$8D2DC077B5EDCDC0,$31C1A0B6156151A0,$F8EF1AC42EF55D1A,
   $DBB0E125D65184E1,$82509CF051CCF69C,$E33E96424FA89196,$DF3F1341352C7D13,
   $8F90B9453E294BB9,$1023226566010E22,$A58095754A15D695,$2C22A7661C85E2A7,
   $E183EF70C46C17EF,$AFD6FD8FF22B57FD,$471AC52EBADF04C5,$4D4CADD402E185AD,
   $916A01BE036B3D01,$28AD5502FFF81B55,$3657EDF9C2BA6DED,$D2FF36F45AC9C036,
   $F1A0CD15A26D19CD,$D90D98175D950298,$F7924643CAD46646,$DD826A73BEE8FB6A,
   $9D0EE212D3ECC3E2,$B6BA083B18B21D08,$3DA5431AC5E6AF43,$08EB11C833FA0711,
   $052B347D5C1FBA34,$6FB7902C45271F90,$133A9D4E52A7CB9D,$6E135635FA455C56,
   $725497FC4CC3AC97,$F31DB42729A99FB4,$846217A639758917,$4B7E26826A58FA26,
   $235FFBE1F8A4D9FB,$FF79578BF92E6157,$DA14273C6933C727,$8B1F4B21DD54B24B,
   $9CAA240B6C8E8024,$C1C5ABBA086E0BAB,$DE9BD5588A4E3ED5,$2D86617FA3E7A161,
   $BFF5DFEA942A59DF,$66F847FDC9BF5B47,$3B97C84CAD5FD0C8,$3EBCFC31F1406AFC,
   $CA3705590F32C905,$24C9B6AE2F7FE5B6,$408C88616D043888,$93D7788C88AFBB78,
   $196CF5B4EA994AF5,$9A98AF5D0437FFAF,$8C89066E0A8F8E06,$AB590FEB1156AE0F,
   $D7D4028906D67A02,$E4A8DB0D9873ADDB,$C378D28883AA8DD2,$4FF1D4E6892503D4,
   $D670C490B9B439C4,$65E1F8D6FD199EF8,$F2B9723E96CBDC72,$B12C4574CF692145,
   $569D215263BC4921,$69851B7A2D9E601B,$5E76309A50464E30,$5FD2F683EF240DF6,
   $D8A95E0EE2F7415E,$E29A505BF0CAD250,$96FC4CF1D4B0014C,$8806F40AE9F277F4,
   $53B6152F3FA3F315,$1C47C1C9B686F0C1,$80EDE5C2DA0870E5,$D5697BBB8D12FC7B,
   $FDC42EB972EAE72E,$0BF2AEE3075CC2AE,$22FB3DF847C69A3D,$BADEEB97C835E3EB,
   $DC26AC6A018AB8AC,$BCEC60C1A08C9C60,$4231F153E6C0BEF1,$337CD9849EA5D7D9,
   $5B5D04E70C59F404,$79A6391F4B9F6E39,$5212D33680C1B0D3,$B5A3B7102C14D8B7,
   $7F94B249232611B2,$17B56F2AB1DA326F,$59E07DD5879D727D,$EBD5878A7C529687,
   $BB7A2D8E7757A02D,$0319BF2B34A6C5BF,$5CCB49A8DB82C849,$1DE307D009E4B307,
   $49C35FB0E19C7C5F,$55849E79571A8C9E,$7ABF86347F39AB86,$9273BE9537CDF8BE,
   $E615A23F13B72BA2,$6821DD6392FC23DD,$5AF9C2FEB33BB7C2,$06328B5668B97F8B,
   $44037A058E79C17A,$83F45AE9EEAEB55A,$5739E74BDCDE0AE7,$FBF6A5EF1A5398A5,
   $E50C1D142711EE1D,$1A754A9FDE3F8F4A,$7802FF06F4FD2DFF,$F52F3F714110E03F,
   $2674CF9CA4BB63CF,$60CACCABA10624CC,$B088836D700B6283,$A6992A5E7EB3132A,
   $A9E476D99A922876,$6B386248A65AE662,$C2DC14913CC8CE14,$76DB6598AFBE5565,
   $32D81F9D21C7941F,$21E282D373605F82,$C0616DA3B70C486D,$616E0AB21E64670A,
   $6D0AE91ECEE399E9,$27D009851BD92009,$FEDD9192464C2291,$45A7BC1C311B82BC,
   $54205860E878CF58,$A10F6711A9682F67,$9981107630913A10,$EDE70CDC14EBE90C,
   $70E9EECEC7072AEE,$1F5E7EE28220357E,$2F3B184D28232718,$41284E78D2667B4E,
   $A424536CF5779553,$A3B21E2322ACA91E,$4E5512FF36474012,$1EFAB8FB3D4276B8,
   $89A2321356903432,$CB93C340B0508AC3,$306566AFAA031266,$4ADAE09BD53AB9E0,
   $C92EBA723B940CBA,$094FD7D18C9844D7,$CC058E0F678BB68E,$D4CDBDA23270BFBD,
   $0A5668FAB83E8168,$510B6C1DB467756C,$B86392A543F16592,$048FF264E37DF9F2,
   $3A330E55123D930E,$B235FA5FFBCFE4FA,$B9C754BCFC932654,$3C0185037A84EC85,
   $0C64E3ACD087FEE3,$E02729697B0E5429,$07964D4FD7DB3C4D,$814923DB656A3323,
   $388E776799F91577,$6A9CA4511938A5A4,$1BD18C86615DCC8C,$B407710993769B71,
   $150816183A1EB416,$4395374A59A2FD37,$C4EE9FC75471B19F,$5844BBCC38FF31BB,
   $CF1C3124532D7331,$B71ECE22A7D05ECE,$ACCF42A4C68D9242,$97588AE86BD2428A,
   $75C2DAB39B1890DA,$9E175D39E74A065D,$F0040B0C1D0F5A0B,$CEB8F73DEC4F30F7,
   $BE5119F32B481A19,$D35BF0EDE5AB83F0,$7C8D0D621780D40D,$85C6D1BF8617CAD1),
   // box 7
  ($B1C742127B66F2A4,$CE916098D7A59FC1,$C312EF8E2406FA70,$956C7DCED81403D5,
   $5A0C9B2318DD9520,$AD0D57F51A480E8B,$E7B9D05287740B01,$0217F9EA2ED81268,
   $4D7CFF19F8CD3A06,$44D1772E572B7B67,$FB73C5B5E65AF72E,$91427AEF84512705,
   $0C720963E4CF6C85,$87C398A0732D8117,$A17F5E96FE87620E,$50476C8B8E8FCF1D,
   $CB4EE1CC9C8CB225,$67B2304C91A8B59A,$54696BAAD2CAEBCD,$DDCF03836BF01437,
   $46C68EC479F3690F,$8F9F96E2CBA7C942,$E1802E99F5E93DB9,$4E9A8086C179215A,
   $F0C9B4686764A427,$FD4A3B7E94C7C196,$FCBBBD0B83ABC8A2,$EBCBD93163BB6784,
   $F9643C5FC882E546,$C4DA973041F7C5FC,$1AF3EB2C13B3CA97,$6E1FB87B3E4EF4FB,
   $5E229C024498B1F0,$F516353C2C4D89C3,$CC869972F97D8DA9,$8D886F08E57FDB2A,
   $1CCA15E7612EFC2F,$567E9240FC12F9A5,$43190F9032DA44EB,$FEAC44E1AD73DACA,
   $07C878BE65F13F8C,$618BCE87E3358322,$F895BA2ADFEEEC72,$751DD5223A913758,
   $59EAE4BC21698E7C,$FF5DC294BA1FD3FE,$03E67F9F39B41B5C,$2292C117D1EFC7C9,
   $8A4017B6808EE4A6,$D1BD0AE08F3F78B2,$135E631BBC558BF6,$EE14586528924A60,
   $8857EE5CAE56F6CE,$0000000000000000,$0E65F089CA177EED,$34132358269361DB,
   $15679DD0CEC8BD4E,$800BE01E16DCBE9B,$949DFBBBCF780AE1,$E397D773DB312FD1,
   $EDF227FA1126513C,$B5E945332723D674,$53A11314B73BD441,$23634762C683CEFD,
   $4B4501D28A500CBE,$473708B16E9F603B,$1770643AE010AF26,$A746A05D8C1A54B6,
   $90B3FC9A933D2E31,$35E2A52D31FF68EF,$AB34A93E68D53833,$D81082D720D939D3,
   $B86ACA25D480B3C5,$DFD8FA694528065F,$4F6B06F3D615286E,$578F1435EB7EF091,
   $9AF80B32056F740C,$92A40570BDE53C59,$DBF6FD48196D228F,$1B026D5904DFC3A3,
   $3C4F2D1A9E19298E,$C8A89E53A538A979,$991E74AD3CDB6F50,$042E07215C4524D0,
   $8E6E1097DCCBC076,$E071A8ECE285348D,$D784F42BFDA24E0A,$7D41DB60821B7F0D,
   $85D4614A5DF5937F,$BB8CB5BAED34A899,$40FF700F0B6E5FB7,$2CF7319E1BF8B924,
   $3A76D3D1EC841F36,$4520F15B40477253,$F138321D7008AD13,$42E889E525B64DDF,
   $65A5C9A6BF70A7F2,$208538FDFF37D5A1,$410EF67A1C025683,$18E412C63D6BD8FF,
   $72D5AD9C5F6008D4,$255AB9A9B41EF845,$93558305AA89356D,$70C2547671B81ABC,
   $3604DAB2084B73B3,$05DF81544B292DE4,$F2DE4D8249BCB64F,$0BBA71DD813E5309,
   $A368A77CD05F7066,$796FDC41DE5E5BDD,$EC03A18F064A5808,$085C0E42B88A4855,
   $274D40439AC6EA2D,$31CCA20C6DBA4C3F,$322ADD93540E5763,$B60F3AAC1E97CD28,
   $7CB05D1595777639,$B036C4676C0AFB90,$0A4BF7A896525A3D,$73242BE9480C01E0,
   $5BFD1D560FB19C14,$7B7825ABF08649B5,$B7FEBCD909FBC41C,$81FA666B01B0B7AF,
   $D25B757FB68B63EE,$0D838F16F3A365B1,$6A31BF5A620BD02B,$26BCC6368DAAE319,
   $9ED60C13592A50DC,$581B62C936058748,$9CC1F5F977F242B4,$83ED9F812F68A5C7,
   $74EC53572DFD3E6C,$B3D0BBF855BEE0CC,$ACFCD1800D2407BF,$303D24797AD6450B,
   $7A89A3DEE7EA4081,$69D7C0C55BBFCB77,$770A2CC814492530,$0F9476FCDD7B77D9,
   $AEEB286A23FC15D7,$2174BE88E85BDC95,$DE297C1C52440F6B,$D04C8C9598537186,
   $2EE0C8743520AB4C,$977B8424F6CC11BD,$10B81C8485E190AA,$A4A0DFC2B5AE4FEA,
   $98EFF2D82BB76664,$A8D2D6A15161236F,$D4628BB4C4165556,$682646B04CD3C243,
   $2D06B7EB0C94B010,$626DB118DA81987E,$2928B0CA50D194C0,$6DF9C7E407FAEFA7,
   $1681E24FF77CA612,$4952F838A4881ED6,$76FBAABD03252C04,$C73CE8AF7843DEA0,
   $E82DA6AE5A0F7CD8,$C10516640ADEE818,$968A0251E1A01889,$37F55CC71F277A87,
   $E5AE29B8A9AC1969,$CABF67B98BE0BB11,$F4E7B3493B2180F7,$E9DC20DB4D6375EC,
   $639C376DCDED914A,$12AFE56EAB3982C2,$C2E369FB336AF344,$A6B726289B765D82,
   $14961BA5D9A4B47A,$BC44CD0488C59715,$D3AAF30AA1E76ADA,$28D936BF47BD9DF4,
   $AF1AAE1F34901CE3,$2F114E01224CA278,$E648562790180235,$24AB3FDCA372F171,
   $52509561A057DD75,$C6CD6EDA6F2FD794,$A08ED8E3E9EB6B3A,$09AD8837AFE64161,
   $BDB54B719FA99E21,$8C79E97DF213D21E,$CF60E6EDC0C996F5,$5DC4E39D7D2CAAAC,
   $11499AF1928D999E,$5FD31A7753F4B8C4,$01F18675176C0934,$C52B1145569BCCC8,
   $9F278A664E4659E8,$3DBEAB6F897520BA,$A2992109C7337952,$9B098D4712037D38,
   $C9591826B254A04D,$3B8755A4FBE81602,$BE5334EEA61D857D,$51B6EAFE99E3C629,
   $191594B32A07D1CB,$1F2C6A78589AE773,$3FA95285A7AD32D2,$5C3565E86A40A398,
   $B2213D8D42D2E9F8,$EFE5DE103FFE4354,$4AB487A79D3C058A,$CD771F07EE11849D,
   $BFA2B29BB1718C49,$BA7D33CFFA58A1AD,$6FEE3E0E2922FDCF,$64544FD3A81CAEC6,
   $D9E104A237B530E7,$F32FCBF75ED0BF7B,$3E58D4F0B0C13BE6,$B418C346304FDF40,
   $AAC52F4B7FB93107,$DC3E85F67C9C1D03,$D5930DC1D37A5C62,$0639FECB729D36B8,
   $C0F490111DB2E12C,$7EA7A4FFBBAF6451,$F6F04AA315F9929F,$6643B63986C4BCAE,
   $6C0841911096E693,$8425E73F4A999A4B,$7133D20366D41388,$38612A3BC25C0D5E,
   $B99B4C50C3ECBAF1,$1D3B93927642F51B,$7F56228AACC36D65,$9D30738C609E4B80,
   $48A37E4DB3E417E2,$8BB191C397E2ED92,$2ACECF5569658F9C,$DA077B3D0E012BBB,
   $A55159B7A2C246DE,$33DB5BE643625E57,$821C19F43804ACF3,$3990AC4ED530046A,
   $D675725EEACE473E,$789E5A34C93252E9,$86321ED564418823,$FA8243C0F136FE1A,
   $E45FAFCDBEC0105D,$2B3F49207E0986A8,$A92350D4460D2A5B,$1EDDEC0D4FF6EE47,
   $89A66829B93AFFFA,$607A48F2F4598A16,$6BC0392F7567D91F,$EA3A5F4474D76EB0,
   $5598EDDFC5A6E2F9,$4C8D796CEFA13332,$F701CCD602959BAB,$E2665106CC5D26E5));

 Shark_CD: array[0..7, 0..255] of UInt64 = (
   // box 0
  ($E6126AF05E55AFF3,$4B6C893F310B0835,$AA4C0E84EBFC8D57,$FB9B5C7BF3B3090D,
   $4508A6A9CCBA5CE2,$E5D1D2064DC6BDE9,$348343755288EDDE,$B684505DE46B250C,
   $A8CEDE205A1E91E8,$40B89B46F9FA6ACC,$8EE1EC1AFAB080BA,$DE77D6B7408E0A45,
   $9A3E184C2E455802,$BE93FAD23F0955EF,$3AE76CE3AF39B909,$AD7EE3CF6F5EA7C6,
   $8B51D1F5CFF0B694,$70CA8D8E3C43BF99,$CCDBA7F8B2A8F6C9,$4C5E6474B5A922A4,
   $5D31ADCD541CCC32,$9B7F701E8C3456A7,$2AC9CD08ECFD593A,$8FA0844858C18E1F,
   $32F0C66C745BC9EA,$C58D6525CBBB888F,$8C633CBE4B529C05,$F2CD9EA68AA0774B,
   $2CBA4811CA2E7D0E,$E2E33F4DC9649778,$F4BE1BBFAC73537F,$22DE6787379F29D9,
   $0956C2DD79137E46,$E061EFE978868BC7,$1CC85ED90F97A85B,$31337E9A67C8DBF0,
   $360193D1E36AF161,$7FEFCA4A6383E5EB,$8535FE633241E243,$C3FEE03CED68ACBB,
   $81C4ABDEA570DAC8,$67D6C12EFB25753B,$A4282112164DD980,$CF181F0EA13BE4D3,
   $A98FB672F86F9F4D,$5C70C59FF66DC297,$B0F7D544C2B80138,$0DA79760EE2246CD,
   $3740FB83411BFFC4,$24ADE29E114C0DED,$F858E48DE0201B17,$0E642F96FDB154D7,
   $DDB46E41531D185F,$25EC8ACCB33D0348,$0282D0A4B1E21CBF,$1BFAB3928B3582CA,
   $AFFC336BDEBCBB79,$35C22B27F0F9E37B,$03C3B8F61393121A,$B8E07FCB19DA71DB,
   $99FDA0BA3DD64A18,$CE59775C034AEA76,$49EE599B80E9148A,$FE2B6194C6F33F23,
   $4EDCB4D0044B3E1B,$D5A3C4CE887F68BC,$DF36BEE5E2FF04E0,$171C4CA0C766CAA2,
   $0BD41279C8F162F9,$E490BA54EFB7B34C,$5B4228D472CFE806,$5355825BA9AD98E5,
   $9F8E25A31B056E2C,$CD9ACFAA10D9F86C,$88926903DC63A48E,$B40680F9558939B3,
   $239F0FD595EE277C,$EC8710DB34D5C3AF,$87B72EC783A3FEFC,$632794936C144DB0,
   $46CB1E5FDF294EF8,$83467B7A1492C677,$9C4D9D5508967C36,$D6607C389BEC7AA6,
   $165D24F26517C407,$C4CC0D7769CA862A,$CBE94AB3360ADC58,$847496319030ECE6,
   $7A5FF7A556C3D3C5,$C03D58CAFEFBBEA1,$76B908971A909BAD,$2F79F0E7D9BD6F14,
   $197863363AD79E75,$DA86830AD7BF32CE,$5A034086D0BEE6A3,$97998F2CC0671ECF,
   $552607428F7EBCD1,$51D752FF184F845A,$BB23C73D0A4963C1,$2B88A55A4E8C579F,
   $D80453AE665D2E71,$EE05C07F8537DF10,$423A4BE248187673,$CAA822E1947BD2FD,
   $1ABBDBC029448C6F,$96D8E77E6216106A,$6266FCC1CE654315,$89D301517E12AA2B,
   $730935782FD0AD83,$8085C38C0701D46D,$6B303E1CB7763D53,$3F57510C9A798F27,
   $4449CEFB6ECB5247,$48AF31C922981A2F,$98BCC8E89FA744BD,$69B2EEB8069421EC,
   $EBB5FD90B077E93E,$6A71564E150733F6,$116FC9B9E1B5EE96,$4A2DE16D937A0690,
   $B9A11799BBAB7F7E,$9368DA9157562644,$718BE5DC9E32B13C,$C82AF2452599CE42,
   $B547E8ABF7F83716,$33B1AE3ED62AC74F,$799C4F534550C1DF,$3E16395E38088182,
   $7C2C72BC7010F7F1,$F38CF6F428D179EE,$D29129850CDD422D,$41F9F3145B8B6469,
   $945A37DAD3F40CD5,$757AB061090389B7,$6554118A4AC76984,$7D6D1AEED261F954,
   $01416852A2710EA5,$B27505E0735A1D87,$77F860C5B8E19508,$78DD2701E721CF7A,
   $E12087BBDAF78562,$86F6469521D2F059,$EF44A82D2746D1B5,$BC112A768EEB4950,
   $C2BF886E4F19A21E,$307216C8C5B9D555,$C96B9A1787E8C0E7,$A31ACC5992EFF311,
   $A0D974AF817CE10B,$DCF50613F16C16FA,$FCA9B1307711239C,$57A4D7E63E9CA06E,
   $C64EDDD3D8289A95,$A25BA40B309EFDB4,$2E3898B57BCC61B1,$F5FF73ED0E025DDA,
   $A6AAF1B6A7AFC53F,$D9453BFCC42C20D4,$9D0CF507AAE77293,$290A75FEFF6E4B20,
   $A7EB99E405DECB9A,$A1981CFD230DEFAE,$12AC714FF226FC8C,$743BD833AB728712,
   $6C02D35733D417C2,$E9372D340195F581,$F77DA349BFE04165,$68F386EAA4E52F49,
   $211DDF71240C3BC3,$13ED191D5057F229,$E8764566A3E4FB24,$F9198CDF425115B2,
   $D013F921BD3F5E92,$91EA0A35E6B43AFB,$0732ED4B84A22A91,$EAF495C21206E79B,
   $5214EA090BDC9640,$0000000000000000,$B3346DB2D12B1322,$0CE6FF324C534868,
   $AEBD5B397CCDB5DC,$0A957A2B6A806C5C,$1F0BE62F1C04BA41,$14DFF456D4F5D8B8,
   $58819022615CFA1C,$05B03DEF3540362E,$E3A2571F6B1599DD,$9229B2C3F52728E1,
   $BA62AF6FA8386D64,$0673851926D32434,$641579D8E8B66721,$04F155BD9731388B,
   $9ECF4DF1B9746089,$205CB723867D3566,$102EA1EB43C4E033,$3BA604B10D48B7AC,
   $50963AADBA3E8AFF,$AC3F8B9DCD2FA963,$7B1E9FF7F4B2DD60,$F63CCB1B1D914FC0,
   $7EAEA218C1F2EB4E,$5FB37D69E5FED08D,$56E5BFB49CEDAECB,$2DFB2043685F73AB,
   $61A54437DDF6510F,$6FC16BA1204705D8,$E75302A2FC24A156,$3DD581A82B9B9398,
   $DBC7EB5875CE3C6B,$90AB626744C5345E,$59C0F870C32DF4B9,$6697A97C59547B9E,
   $FDE8D962D5602D39,$D3D041D7AEAC4C88,$5EF2153B478FDE28,$D4E2AC9C2A0E6619,
   $1E4A8E7DBE75B4E4,$72485D2A8DA1A326,$437B23B0EA6978D6,$159E9C047684D61D,
   $0F2547C45FC05A72,$F10E265099336551,$3C94E9FA89EA9D3D,$BFD292809D785B4A,
   $0817AA8FDB6270E3,$60E42C657F875FAA,$18390B6498A690D0,$478A760D7D58405D,
   $284B1DAC5D1F4585,$B1B6BD1660C90F9D,$D15291731F4E5037,$4D1F0C2617D82C01,
   $C70FB5817A599430,$6D43BB0591A51967,$6E8003F382360B7D,$1D89368BADE6A6FE,
   $4F9DDC82A63A30BE,$EDC6788996A4CD0A,$AB0D66D6498D83F2,$54676F102D0FB274,
   $C17C30985C8AB004,$3865BC471EDBA5B6,$3924D415BCAAAB13,$951B5F8871850270,
   $8A10B9A76D81B831,$BD5042242C9A47F5,$A5694940B43CD725,$FF6A09C664823186,
   $8D2254ECE92392A0,$B7C5380F461A2BA9,$82071328B6E3C8D2,$D721146A399D7403,
   $FADA342951C207A8,$262F323AA0AE1152,$F04F4E023B426BF4,$276E5A6802DF1FF7),
   // box 1
  ($3B4016DBFD16E203,$9A7574C51174530A,$90012E69C02EC8D3,$F44580E3D780E076,
   $F81DEC2B49ECA14B,$26CAE3E8A6E3D7EF,$0962419E0C41F6AB,$54D1EB4070EBD951,
   $865E884B0188EEC8,$DF76067EA406FE8A,$29849412E594FBA0,$461569896869C0F2,
   $B5DDD6B3BBD6724E,$0C586CC89E6C413D,$6B0AD97054D904EA,$A135621EEC62B109,
   $0EEF7E47087EA461,$FAAAFEA4DFFE4417,$E0AD344E80342331,$AB4138B23D382AD0,
   $107390468E90FCFF,$BE0885A2218561B9,$DBED22957D22C132,$2251C7037FC7E857,
   $33835EF8BA5E9C86,$B3F1E0D7F4E0A8AA,$3FDB32302432DDBB,$A719547AA3546BED,
   $E10C3DF3CB3DAB1F,$17FEAF9F8AAFAE35,$9DF84B1C154B01C0,$8364A51D93A5595E,
   $535CD49974D48B9B,$01A109BD4B09882E,$C4D0C529B0C51182,$2E09ABCBE1ABA96A,
   $1F3DE7BCCDE7D0B0,$9317355B1D35A5A1,$6C87E6A950E65620,$8910FFB142FFC287,
   $40395FED275F1A16,$7B794936DA49F815,$F269B68798B63A92,$FD27C17DDBC116DD,
   $8D8BDB5A9BDBFD3F,$1BA6C35714C3EF08,$6E30F426C6F4B37C,$7FE26DDD036DC7AD,
   $14E8B4AD57B4C347,$B985BA7B25BA3373,$E9CF75D08C75D59A,$626898EE5898F241,
   $5B9F9CBA339CF51E,$B250E96ABFE92084,$165FA622C1A6261B,$F5E4895E9C896858,
   $B76AC43C2DC49712,$02B7128F9612E55C,$1D8AF5335BF535EC,$36B973AE28732B10,
   $A8572380E02347A2,$F6F2926C4192052A,$8C2AD2E7D0D27511,$D32E6AB63A6ABFB7,
   $BD1E9E90FC9E0CCB,$03161B32DD1B6D72,$4DC03A98F23AD305,$81D3B79205B7BC02,
   $450372BBB572AD80,$2D1FB0F93CB0C418,$2A928F20388F96D2,$721B08A8D6080EBE,
   $92B63CE6563C2D8F,$EB78675F1A6730C6,$13658B74538B918D,$428E4D62B14DFF4A,
   $88B1F60C09F64AA9,$75963771D2375C74,$7AD8408B9140703B,$57C7F072ADF0B423,
   $E5971918121994A7,$5666F9CFE6F93C0D,$8F3CC9D50DC91863,$1E9CEE0186EE589E,
   $8A06E4839FE4AFF5,$B824B3C66EB3BB5D,$D1997839AC785AEB,$6752B5B8CAB545D7,
   $B47CDF0EF0DFFA60,$949A0A82190AF76B,$C04BE1C269E12E3A,$FC86C8C090C89EF3,
   $E3BB2F7C5D2F4E43,$6AABD0CD1FD08CC4,$2147DC31A2DC8525,$CA3FBB6EB8BBB5E3,
   $48FA17CE60176493,$6444AE8A17AE28A5,$2B33869D73861EFC,$D0387184E771D2C5,
   $7CF476EFDE76AADF,$63C9915313917A6F,$C929A05C65A0D891,$DA4C2B28362B491C,
   $FE31DA4F06DA7BAF,$C1EAE87F22E8A614,$5C12A36337A3A7D4,$18B0D865C9D8827A,
   $E7200B97840B71FB,$4BEC0CFCBD0C09E1,$0F4E77FA43772C4F,$4C613325B9335B2B,
   $F3C8BF3AD3BFB2BC,$87FF81F64A8166E6,$A38270917A705455,$1911D1D882D10A54,
   $44A27B06FE7B25AE,$049B24EBD9243FB8,$BB32A8F4B3A8D62F,$91A027D48B2740FD,
   $3D6C20BFB22038E7,$E681022ACF02F9D5,$F17FADB545AD57E0,$CC138D0AF78D6F07,
   $495B1E732B1EECBD,$38560DE9200D8F71,$A9F62A3DAB2ACF8C,$47B46034236048DC,
   $8E9DC06846C0904D,$ACCC076B3907781A,$32225745F15714A8,$D4A3556F3E55ED7D,
   $D7B54E5DE34E800F,$DDC114F132141BD6,$6D26EF141BEFDE0E,$85489379DC9383BA,
   $0BD553119A5313F7,$786F520407529567,$CB9EB2D3F3B23DCD,$A223792C3179DC7B,
   $0A745AACD15A9BD9,$710D139A0B1363CC,$681CC24289C26998,$1A07CAEA5FCA6726,
   $82C5ACA0D8ACD170,$25DCF8DA7BF8BA9D,$C7C6DE1B6DDE7CF0,$C35DFAF0B4FA4348,
   $DED70FC3EF0F76A4,$504ACFABA9CFE6E9,$C571CC94FBCC99AC,$5EA5B1ECA1B14288,
   $AE7B15E4AF159D46,$C888A9E12EA950BF,$F7539BD10A9B8D04,$962D180D8F181237,
   $E43610A559101C89,$772125FE4425B928,$84E99AC4979A0B94,$C667D7A626D7F4DE,
   $EFE343B4C3430F7E,$D5025CD2755C6553,$A6B85DC7E85DE3C3,$D61447E0A8470821,
   $3E7A3B8D6F3B5595,$52FDDD243FDD03B5,$8072BE2F4EBE342C,$12C482C9188219A3,
   $9EEE502EC8506CB2,$AD6D0ED6720EF034,$59288E35A58E1042,$E21A26C11626C66D,
   $247DF16730F132B3,$F0DEA4080EA4DFCE,$31344C772C4C79DA,$4F77281764283659,
   $79CE5BB94C5B1D49,$0000000000000000,$73BA01159D018690,$74373ECC993ED45A,
   $BCBF972DB79784E5,$4ED621AA2F21BE77,$D95A301AEB30246E,$9C5942A15E4289EE,
   $37187A13637AA33E,$276BEA55EDEA5FC1,$1C2BFC8E10FCBDC2,$ED54513B5551EA22,
   $20E6D58CE9D50D0B,$3AE11F66B61F6A2D,$66F3BC0581BCCDF9,$2CBEB94477B94C36,
   $99636FF7CC6F3E78,$953B033F52037F45,$B0E7FBE529FBC5D8,$60DF8A61CE8A171D,
   $6F91FD9B8DFD3B52,$AAE0310F7631A2FE,$BFA98C1F6A8CE997,$8BA7ED3ED4ED27DB,
   $98C2664A8766B656,$062C36644F36DAE4,$5570E2FD3BE2517F,$EAD96EE2516EB8E8,
   $419856506C569238,$23F0CEBE34CE6079,$309545CA6745F1F4,$5A3E950778957D30,
   $617E83DC85839F33,$FB0BF71994F7CC39,$3CCD2902F929B0C9,$70AC1A27401AEBE2,
   $CEA49F85619F8A5B,$39F704546B04075F,$0DF96575D565C913,$08C3482347487E85,
   $D28F630B71633799,$ECF558861E58620C,$C2FCF34DFFF3CB66,$978C11B0C4119A19,
   $69BDCBFFC2CBE1B6,$BA93A149F8A15E01,$51EBC616E2C66EC7,$078D3FD9043F52CA,
   $58898788EE87986C,$4A4D0541F60581CF,$E86E7C6DC77C5DB4,$EE424A09884A8750,
   $CDB284B7BC84E729,$65E5A7375CA7A08B,$2FA8A276AAA22144,$A0946BA3A76B3927,
   $A5AE46F535468EB1,$35AF689CF5684662,$28259DAFAE9D738E,$CF0596382A960275,
   $B6CBCD8166CD1F3C,$7E43646048644F83,$9BD47D785A7DDB24,$432F44DFFA447764,
   $9F4F59938359E49C,$7D557F52957F22F1,$76802C430F2C3106,$DC601D4C791D93F8,
   $053A2D56922DB796,$11D299FBC59974D1,$F9BCE59602E52965,$D8FB39A7A039AC40,
   $340E6121BE61CE4C,$5F04B851EAB8CAA6,$5DB3AADE7CAA2FFA,$1549BD101CBD4B69,
   $FF90D3F24DD3F381,$AFDA1C59E41C1568,$B146F25862F24DF6,$A40F4F487E4F069F),
   // box 2
  ($A1A35CEBF8F0F94C,$2C203D650F3F095D,$1A2BDAEE4084A2A7,$D32404574D7BCC68,
   $F785BEA594A9ADC4,$F2EB54456206949C,$3F5E334D0475CED1,$5994299B835D1F60,
   $785B7989AC204794,$025DA6A2CF461A41,$DF1F3A71F01A901B,$27284F018BB77637,
   $E1955A6D694C5310,$24A1BAF2D9D261AC,$E4FBB08D9FE36A48,$8D83618EF7CFF011,
   $2AC72276ABF5279E,$F9E32621E68EEBF6,$BF323FB4D3F86F69,$BB888605B8745BEB,
   $70DAFE1E7ACD2F65,$D0ADF1A41F1EDBF3,$1E91635F2B089625,$EE2791B8864818F8,
   $99CE23E4C56C1484,$F33F0714FF259946,$BD6F99161CBE7528,$9F293CF761A63A47,
   $B80173F6EA114C70,$6543EF25D54DC62A,$39B92C5EA0BFE012,$63A4F0367187E8E9,
   $4C0D38A02CDDF62F,$07334C4239E92319,$43BFF375C3D9BDC7,$CA862B4A5F9A7954,
   $5D2E902AE8D12BE2,$137E0E280B4AC78C,$F162A1B630638307,$55AF17BD3E3C4313,
   $358212781DDEBC61,$94214E93E52E452D,$C18E592EDB12063E,$EC7A371A490E02B9,
   $4963D240DA72CF77,$41E255D70C9FA786,$FF0439324244C535,$88ED8B6E0160C949,
   $6C163BE39E83A301,$C534E09FB09E32BC,$806C0CF9D78DA1B8,$DBA583C09B96A499,
   $746047AF11411BE7,$F40C4B56C6CCBA5F,$6270A367ECA4E533,$D41748157492EF71,
   $EFF3C2E91B6B1522,$0E66988472274632,$534808AE9AF66DD0,$8231AA5B18CBBBF9,
   $B2DD52C3F3BA3EC0,$DD429CD33F5C8A5A,$4E509E02E39BEC6E,$26FC1C5016947BED,
   $D9F8256254D0BED8,$0955D4C64BCE652B,$1610E4C8FDE5FED4,$6DC268B203A0AEDB,
   $2E7D9BC7C079131C,$C3D3FF8C14541C7F,$D64AEEB7BBD4F530,$AB7F7DDEE15B8BFC,
   $144D426A32A3E495,$8E0A947DA5AAE78A,$798F2AD831034A4E,$3BE48AFC6FF9FA53,
   $529C5BFF07D5600A,$BEE66CE54EDB62B3,$931202D1DCC76634,$50C1FD5DC8937A4B,
   $A4CDB60B0E5FC014,$57F2B11FF17A5952,$47054AC4A8558945,$5A1DDC68D13808FB,
   $5CFAC37B75F22638,$C207ACDD897711A5,$289A84D464B33DDF,$C05A0A7F46310BE4,
   $E6A6162F50A57009,$06E71F13A4CA2EC3,$5F733688279731A3,$EB497B5870E721A0,
   $B667EB7298360A42,$E3C8FCCFA60A4951,$E772457ECD867DD3,$6978D103682C9A59,
   $0DEF6D77204251A9,$C90FDEB90DFF6ECF,$D179A2F5823DD629,$2FA9C8965D5A1EC6,
   $81B85FA84AAEAC62,$DC96CF82A27F8780,$602D05C523E2FF72,$19A22F1D12E1B53C,
   $E52FE3DC02C06792,$58407ACA1E7E12BA,$61F95694BEC1F2A8,$48B781114751C2AD,
   $AAAB2E8F7C788626,$04BAB9B16B8C3482,$2DF46E34921C0487,$1123A88AC40CDDCD,
   $C6BD156CE2FB2527,$7F6835CB95C9648D,$83E5F90A85E8B623,$4F84CD537EB8E1B4,
   $294ED785F9903005,$1CCCC5FDE44E8C64,$CB52781BC2B9748E,$1D1896AC796D81BE,
   $B30901926E99331A,$AD9862CD4591A53F,$C8DB8DE890DC6315,$7BD28C7AFE45500F,
   $0ADC213519AB72B0,$A8F6882DB33E9C67,$B5EE1E81CA531DD9,$201B0343B25E552E,
   $4036068691BCAA5C,$AE11973E17F4B2A4,$9EFD6FA6FC85379D,$33650D6BB91492A2,
   $3A30D9ADF2DAF789,$0C3B3E26BD615C73,$F651EDF4098AA01E,$710EAD4FE7EE22BF,
   $3138ABC9765288E3,$9D749A55AEE02006,$6E4B9D4151C5B940,$84D6B548BC01953A,
   $360BE78B4FBBABFA,$A22AA918AA95EED7,$EDAE644BD42D0F63,$46D119953576849F,
   $6497BC74486ECBF0,$FBBE808329C8F1B7,$4AEA27B38817D8EC,$5626E24E6C595488,
   $056EEAE0F6AF3958,$4558EC6667139304,$448CBF37FA309EDE,$6F9FCE10CCE6B49A,
   $A0770FBA65D3F496,$671E49871A0BDC6B,$DA71D09106B5A943,$08818797D6ED68F1,
   $A3FEFA4937B6E30D,$B080F4613CFC2481,$763DE10DDE0701A6,$4DD96BF1B1FEFBF5,
   $92C6518041E46BEE,$3456412980FDB1BB,$981A70B5584F195E,$3D0395EFCB33D490,
   $BA5CD55425575631,$4B3E74E21534D536,$6AF124F03A498DC2,$7EBC669A08EA6957,
   $30ECF898EB718539,$A922DB7C2E1D91BD,$7A06DF2B63665DD5,$B154A730A1DF295B,
   $FC8DCCC11021D2AE,$CFE8C1AAA935400C,$97A8BB60B74B52B6,$18767C4C8FC2B8E6,
   $9A47D6179709031F,$0000000000000000,$AC4C319CD8B2A8E5,$B9D520A7773241AA,
   $DECB69206D399DC1,$1F45300EB62B9BFF,$10F7FBDB592FD017,$3E8A601C9956C30B,
   $8502E619212298E0,$F5D818075BEFB785,$547B44ECA31F4EC9,$9CA0C90433C32DDC,
   $E041093CF46F5ECA,$A69010A9C119DA55,$C769463D7FD828FD,$C4E0B3CE2DBD3F66,
   $2575E9A344F16C76,$01D453519D230DDA,$FA6AD3D2B4EBFC6D,$D5C31B44E9B1E2AB,
   $F83775707BADE62C,$BCBBCA47819D78F2,$D79EBDE626F7F8EA,$5BC98F394C1B0521,
   $2246A5E17D184F6F,$12AA5D799669CA56,$5EA765D9BAB43C79,$8939D83F9C43C493,
   $32B15E3A24379F78,$E914DDFABFA13BE1,$909BF7228EA271AF,$73530BED28A838FE,
   $D2F05706D058C1B2,$FED06A63DF67C8EF,$B43A4DD057701003,$A519E55A937CCDCE,
   $75B414FE8C62163D,$AFC5C46F8AD7BF7E,$2392F6B0E03B42B5,$386D7F0F3D9CEDC8,
   $21CF50122F7D58F4,$9B9385460A2A0EC5,$5115AE0C55B07791,$0FB2CBD5EF044BE8,
   $EA9D2809EDC42C7A,$CC613459FB505797,$426BA0245EFAB01D,$1599113BAF80E94F,
   $7D3593695A8F7ECC,$0389F5F35265179B,$875F40BBEE6482A1,$95F51DC2780D48F7,
   $7CE1C038C7AC7316,$CE3C92FB34164DD6,$CDB5670866735A4D,$8AB02DCCCE26D308,
   $914FA47313817C75,$8B647E9D5305DED2,$D82C7633C9F3B302,$728758BCB58B3524,
   $E8C08EAB2282363B,$8FDEC72C3889EA50,$2B13712736D62A44,$3CD7C6BE5610D94A,
   $37DFB4DAD298A620,$868B13EA73478F7B,$B7B3B82305150798,$0B08726484887F6A,
   $1BFF89BFDDA7AF7D,$77E9B25C43240C7C,$F0B6F2E7AD408EDD,$17C4B79960C6F30E,
   $8C5732DF6AECFDCB,$68AC8252F50F9783,$66CA1AD68728D1B1,$6B2577A1A76A8018,
   $E21CAF9E3B29448B,$A74443F85C3AD78F,$FD599F908D02DF74,$967CE8312A685F6C),
   // box 3
  ($FA7B9775BA3AF751,$03EF98CB769C2D13,$7191CE067072359E,$BAB18B6BFF7516A8,
   $E6E5EF4EFBC1065E,$7BEC74A3B1D0DBF4,$656B4FB907C31C4A,$4E8520F99FC86304,
   $8FD8DF31D16DAE58,$90A93FC1E60A7244,$30AD09F2B449CFC5,$8453BE7E91BB5B90,
   $1D68A3D1C08FEAAD,$5C54642504B410F6,$8061383C8A9E3707,$F9940FBECCA6DA42,
   $46E1D97DA982BBDF,$FC50521656F7AD77,$5E4D2704F35C2647,$8BEA5973CA48C2CF,
   $D06323DFA34593BD,$62B651306A7A5DCE,$A436B0714966D116,$4F73FB131EBC78A6,
   $92B07CE011E244F5,$33429139C2D5E2D6,$CEE418C515565403,$D7BE3D56CEFCD239,
   $53ED83285F4789A9,$F3E9B51B0D043428,$20650E0FD8DD8A86,$B6E7F4ADD21AA2E4,
   $6D0FB63D3189C491,$0DA0A42CAC1BAFEE,$3F14EEFFEFBA569A,$13279F361A086850,
   $9B225E8EA6DC878C,$6684D772715F3159,$A3EBAEF824DF9092,$C499A260D4F4BA69,
   $AA798C9693E153EB,$50021BE329DBA4BA,$949BB983FD2F1ED3,$DFDAC4D2F8B60AE2,
   $F0062DD07B98193B,$AFBDD13E09B024DE,$B95E13A089E93BBB,$649D945386B707E8,
   $E4FCAC6F0C2930EF,$413CC7F4C43BFA5B,$3B2668BDF49F3A0D,$E50A77858D5D2B4D,
   $05C45DA89A517735,$3EE235156ECE4D38,$FE491137A11F9BC6,$B7112F47536EB946,
   $07DD1E896DB94184,$1AB5BD58AD36AB29,$8197E3D60BEA2CA5,$AB8F577C12954849,
   $9CFF4007CB65C608,$A00436335243BD81,$FDA689FCD783B6D5,$CCFD5BE4E2BE62B2,
   $75A348446B575909,$17151974012D04C7,$FB8D4C9F3B4EECF3,$AC5249F57F2C09CD,
   $9346A70A90965F57,$043286421B256C97,$27B81086B564CB02,$3569545A2E18B8F0,
   $6B24735EDD449EB7,$2193D5E559A99124,$C7763AABA268977A,$B0CC31CE3ED7F8C2,
   $C939064C78EF1587,$16E3C29E80591F65,$5DA2BFCF85C00B54,$5990398D9EE567C3,
   $67720C98F02B2AFB,$54309DA132FEC82D,$EAB39088D6AEB212,$9682FAA20AC72862,
   $D38CBB14D5D9BEAE,$4C9C63D8682055B5,$D648E6BC4F88C99B,$DC355C198E2A27F1,
   $10C807FD6C944543,$450E41B6DF1E96CC,$0B8B614F40D6F5C8,$D27A60FE54ADA50C,
   $49583E70F2712280,$8DC19C10268598E9,$5866E2671F917C61,$79F537824638ED45,
   $C2B267033839E04F,$CB20456D8F072336,$2A18B4AA197F64EC,$DBE84290E3936675,
   $73888D27879A032F,$E8AAD3A9214684A3,$6EE02EF64715E982,$A996145DE57D7EF8,
   $C8CFDDA6F99B0E25,$062BC563ECCD5A26,$264ECB6C3410D0A0,$B8A8C84A089D2019,
   $7DC7B1C05D1D81D2,$D5A77E773914E488,$4B417D5105991431,$F62DE8B39755431D,
   $993B1DAF5134B13D,$82787B1D7D7601B6,$E321B2E66190716B,$B5086C66A4868FF7,
   $9EE603263C8DF0B9,$349F8FB0AF6CA352,$5B897AAC690D5172,$7C316A2ADC699A70,
   $D451A59DB860FF2A,$706715ECF1062E3C,$838EA0F7FC021A14,$57DF056A4462E53E,
   $CF12C32F94224FA1,$ED6E8E01BB17F396,$915FE42B677E69E6,$89F31A523DA0F47E,
   $E71334A47AB51DFC,$A860CFB76409655A,$9F10D8CCBDF9EB1B,$EF77CD204CFFC527,
   $F862D4544DD2C1E0,$8A1C82994B3CD96D,$AE4B0AD488C43F7C,$98CDC645D040AA9F,
   $7FDEF2E1AAF5B763,$4717029728F6A07D,$745593AEEA2342AB,$EE8116CACD8BDE85,
   $727E56CD06EE188D,$227C4D2E2F35BC37,$977421488BB333C0,$A21D7512A5AB8B30,
   $BB4750817E010D0A,$6CF96DD7B0FDDF33,$2801F78BEE97525D,$1C9E783B41FBF10F,
   $9D099BED4A11DDAA,$7A1AAF4930A4C056,$32B44AD343A1F974,$3CFB763499267B89,
   $B2D572EFC93FCE73,$63408ADAEB0E466C,$ADA4921FFE58126F,$5FBBFCEE72283DE5,
   $6AD2A8B45C308515,$0C567FC62D6FB44C,$956D62697C5B0571,$25A153A7428CFDB3,
   $150C5A55F6C53276,$E2D7690CE0E46AC9,$DA1E997A62E77DD7,$F5C27078E1C96E0E,
   $C344BCE9B94DFBED,$60AF12119D926B7F,$A1F2EDD9D337A623,$CAD69E870E733894,
   $3770177BD9F08E41,$A5C06B9BC812CAB4,$1F71E0F03767DC1C,$44F89A5C5E6A8D6E,
   $6159C9FB1CE670DD,$8E2E04DB5019B5FA,$8805C1B8BCD4EFDC,$E138F1C7967847DA,
   $4AB7A6BB84ED0F93,$0000000000000000,$38C9F0768203171E,$1B4366B22C42B08B,
   $7803EC68C74CF6E7,$EC9855EB3A63E834,$BE830D29E4507A3F,$2DC5AA2374C62568,
   $A62FF350BE8EE7A7,$764CD08F1DCB741A,$8C3747FAA7F1834B,$0FB9E70D5BF3995F,
   $55C6464BB38AD38F,$F7DB3359162158BF,$D195F8352231881F,$0992226EB73EC379,
   $14FA81BF77B129D4,$48AEE59A73053922,$2457884DC3F8E611,$FFBFCADD206B8064,
   $B4FEB78C25F29455,$864AFD5F66536D21,$6F16F51CC661F220,$DE2C1F3879C21140,
   $195A2593DBAA863A,$2E2A32E8025A087B,$432584D533D3CCEA,$2C3371C9F5B23ECA,
   $A7D928BA3FFAFC05,$42D35F3FB2A7D748,$85A5659410CF4032,$0864F984364AD8DB,
   $F21F6EF18C702F8A,$F1F0F63AFAEC0299,$D9F101B1147B50C4,$2FDCE902832E13D9,
   $4D6AB832E9544E17,$E0CE2A2D170C5C78,$51F4C009A8AFBF18,$68CBEB95ABD8B3A4,
   $C15DFFC84EA5CD5C,$02194321F7E836B1,$113EDC17EDE05EE1,$521B58C2DE33920B,
   $9AD4856427A89C2E,$5629DE80C516FE9C,$77BA0B659CBF6FB8,$238A96C4AE41A795,
   $12D144DC9B7C73F2,$D807DA5B950F4B66,$3686CC91588495E3,$18ACFE795ADE9D98,
   $5A7FA146E8794AD0,$C680E141231C8CD8,$1E873B1AB613C7BE,$F434AB9260BD75AC,
   $CD0B800E63CA7910,$BC9A4E0813B84C8E,$3D0DADDE1852602B,$40CA1C1E454FE1F9,
   $0A7DBAA5C1A2EE6A,$693D307F2AACA806,$0E4F3CE7DA8782FD,$BD6C95E292CC572C,
   $3AD0B35775EB21AF,$7E28290B2B81ACC1,$01F6DBEA81741BA2,$87BC26B5E7277683,
   $393F2B9C03770CBC,$DDC387F30F5E3C53,$EB454B6257DAA9B0,$B323A905484BD5D1,
   $B13AEA24BFA3E360,$315BD218353DD467,$2BEE6F40980B7F4E,$E95C0843A0329F01,
   $C56F798A5580A1CB,$BF75D6C36524619D,$29F72C616FE349FF,$C0AB2422CFD1D6FE),
   // box 4
  ($561FC423E957943C,$014287CA69079288,$2F086129DFCD1D21,$C537D4AEA044FD99,
   $F1E8C3BFD7C8A457,$2971998A5CDF9BFB,$23FA649A2CE9E460,$3AA9E9C356A6716A,
   $D6EFA4E7AA3D1708,$705A24B1FDA5B5EB,$101E0CE2B170A9FC,$7CA821020E814CAA,
   $0BC97ADA1931ED13,$34DF1711778C59CE,$D35020EF9226D2BF,$575D43E9805006B4,
   $91ACEBEC9B1DB840,$549B3F423B5945D9,$99A3ED9D3925163E,$7917A50A369A891D,
   $E372343CB4B6DC4E,$8D40E2BDD949E8FD,$CFBC29BED0728202,$969794857108AC12,
   $DD26DE3DB30CFA1B,$115C8B28D8773B74,$E9F9C92CC480A3D5,$4DC8B21B4116D0D3,
   $316093194F979C79,$5124BB4A0342806E,$B31408BCDEF3CEA8,$C1CAD76CF158AAA6,
   $88FF66B5E1522D4A,$A8C37E8476B28A47,$15A188EA896B6C4B,$A24883940684F5DC,
   $DA1DA1545919EE49,$22B8E35045EE76E8,$6106AF9925D28E9F,$EF80318F4792250F,
   $663DD0F0CFC79ACD,$302214D326900EF1,$DFA2255C61022BFE,$E6CDB0348CAD19F9,
   $50663C806A4512E6,$65FBAC5B74CED9A0,$C4755364C9436F11,$8FC419DC0B473918,
   $5C9439339961EBA7,$3F166DCB6EBDB4DD,$BA59890715CCF25E,$F0AA4475BECF36DF,
   $03C67CABBB09436D,$B99FF5ACAEC5B133,$F9E7C5CE75F00A29,$6DF4AA2AD6F677DE,
   $AEBA8627F5A00C9D,$A573FCFDEC91E18E,$7F6E5DA9B5880FC7,$CA03ADB6E86947B5,
   $74A72773ACB9E2D4,$604428534CD51C17,$F8A542041CF798A1,$448533A08A29EC25,
   $80F060C4436A8334,$0DB082799A236BC9,$FA21B965CEF94944,$64B92B911DC94B28,
   $7118A37B94A22763,$AFF801ED9CA79E15,$1DAE8E9B2B53C235,$13D870490A79EA91,
   $8A7B9DD4335CFCAF,$1F2A75FAF95D13D0,$EEC2B6452E95B787,$C34E2C0D23567B43,
   $47434F0B3120AF48,$A18EFF3FBD8DB6B1,$98E16A57502284B6,$37196BBACC851AA3,
   $8E869E166240AB90,$9FDA153EBA3790E4,$F515C07D86D4F368,$72DEDFD02FAB640E,
   $E230B3F6DDB14EC6,$97D5134F180F3E9A,$E1F6CF5D66B80DAB,$E78F37FEE5AA8B71,
   $A30A045E6F836754,$90EE6C26F21A2AC8,$AA4785E5A4BC5BA2,$4E0ECEB0FA1F93BE,
   $94136FE4A3067DF7,$7B935E6BE49458F8,$9B2716FCEB2BC7DB,$840D63061276D40B,
   $ED04CAEE959CF4EA,$EA3FB5877F89E0B8,$B56DF01F5DE14872,$4935B1D9100A87EC,
   $82749BA5916452D1,$58693AF1C87DBC98,$89BDE17F8855BFC2,$677F573AA6C00845,
   $EB7D324D168E7230,$0284FB61D20ED1E5,$B190F3DD0CFD1F4D,$684B2E22EEEDB269,
   $2BF562EB8ED14A1E,$E0B448970FBF9F23,$396F9568EDAF3207,$52E2C7E1B84BC303,
   $77615BD817B0A1B9,$7E2CDA63DC8F9D4F,$F22EBF146CC1E73A,$C08850A6985F382E,
   $D9DBDDFFE210AD24,$BFE60D0F2DD737E9,$9A659136822C5553,$87CB1FADA97F9766,
   $4C8A35D12811425B,$83361C6FF863C059,$D212A725FB214037,$9E9892F4D330026C,
   $45C7B46AE32E7EAD,$5BAF465A7374FFF5,$DC6459F7DA0B6893,$D46B5F867833C6ED,
   $5DD6BEF9F066792F,$CB412A7C816ED53D,$75E5A0B9C5BE705C,$F6D3BCD63DDDB005,
   $FB633EAFA7FEDBCC,$D529D84C11345465,$C9C5D11D536004D8,$DB5F269E301E7CC1,
   $86899867C07805EE,$3D9296AABCB36538,$2CCE1D8264C45E4C,$5AEDC1901A736D7D,
   $2E4AE6E3B6CA8FA9,$1E68F230905A8158,$DEE0A2960805B976,$CD38D2DF027C53E7,
   $6909A9E887EA20E1,$24C11BF3C6FCF032,$18110A9313480782,$A7F7079C3E9F306B,
   $D8995A358B173FAC,$854FE4CC7B714683,$BD62F66EFFD9E60C,$14E30F20E06CFEC3,
   $6E32D6816DFF34B3,$217E9FFBFEE73585,$C88756D73A679650,$359D90DB1E8BCB46,
   $2645E09214F221D7,$04FD03C2511C573F,$739C581A46ACF686,$B0D2741765FA8DC5,
   $A0CC78F5D48A2439,$5E10C2524B6F3A42,$E50BCC9F37A45A94,$53A0402BD14C518B,
   $413AB7A8B2322992,$203C183197E0A70D,$CC7A55156B7BC16F,$4601C8C158273DC0,
   $BEA48AC544D0A561,$638254F8F7DC5F7A,$A6B580565798A2E3,$3CD01160D5B4F7B0,
   $8C026577B04E7A75,$7AD1D9A18D93CA70,$785522C05F9D1B95,$5F5245982268A8CA,
   $9551E82ECA01EF7F,$0000000000000000,$BB1B0ECD7CCB60D6,$094D81BBCB3F3CF6,
   $28331E4035D80973,$F7913B1C54DA228D,$6ACFD5433CE3638C,$1BD77638A84144EF,
   $62C0D3329EDBCDF2,$81B2E70E2A6D11BC,$D7AD232DC33A8580,$05BF8408381BC5B7,
   $33E468789D994D9C,$FEDCBAA79FE51E7B,$4F4C497A93180136,$073B7F69EA151452,
   $0CF205B3F324F941,$382D12A284A8A08F,$1CEC0951425450BD,$55D9B888525ED751,
   $6CB62DE0BFF1E556,$D1D4DB8E4028035A,$25839C39AFFB62BA,$4AF3CD72AB03C481,
   $A4317B3785967306,$1A95F1F2C146D667,$926A97472014FB2D,$B7E90B7E8FEF9997,
   $CEFEAE74B975108A,$3E54EA0107BA2655,$D0965C44292F91D2,$AB05022FCDBBC92A,
   $FD1AC60C24EC5D16,$FC5841C64DEBCF9E,$E4494B555EA3C81C,$B6AB8CB4E6E80B1F,
   $3BEB6E093FA1E3E2,$F36C38DE05C675B2,$9C1C6995013ED389,$8B391A1E5A5B6E27,
   $EC464D24FC9B6662,$AD7CFA8C4EA94FF0,$0F347918482DBA2C,$9D5EEE5F68394101,
   $7623DC127EB73331,$32A6EFB2F49EDF14,$2D8C9A480DC3CCC4,$B2568F76B7F45C20,
   $0E76FED2212A28A4,$48773613790D1564,$129AF783637E7819,$080F0671A238AE7E,
   $365BEC70A582882B,$42FCCB03093B6AFF,$0A8BFD1070367F9B,$FF9E3D6DF6E28CF3,
   $E8BB4EE6AD87315D,$C7B32FCF724A2C7C,$B8DD7266C7C223BB,$9328108D491369A5,
   $0679F8A3831286DA,$270767587DF5B35F,$A981F94E1FB518CF,$6B8D528955E4F104,
   $1667F44132622F26,$2AB7E521E7D6D896,$AC3E7D4627AEDD78,$7DEAA6C86786DE22,
   $1725738B5B65BDAE,$4BB14AB8C2045609,$592BBD3BA17A2E10,$C20CABC74A51E9CB,
   $6F70514B04F8A63B,$BC2071A496DE7484,$19538D597A4F950A,$F45747B7EFD361E0,
   $43BE4CC9603CF877,$C6F1A8051B4DBEF4,$B42F77D534E6DAFA,$40783062DB35BB1A),
   // box 5
  ($F5A96C292DEB0A4E,$211C9DF6EE653C51,$04DE5DDCBEEEF596,$E1E5B06F7457C19F,
   $74CA30F014A54FB6,$C296F9F7C5457D85,$7D4EE08A484D10B0,$AE87F2D0BF9B13AD,
   $8DF4BB480E89AFB7,$2D8B7A67D9A2D61E,$0F3559C8BD712ADB,$541BC7312F013338,
   $9EC4848B636D5164,$952F809F60F28E29,$28984D8CB28D6357,$D4B5F1DFC38E361F,
   $5674135F7076B373,$B791A330042172EC,$AB94C53BD4B4A6E4,$F17731F59305FFD8,
   $39C7A621801E1DCF,$20D1F7C13BA47C8E,$5E3DA912F95FACAA,$B1202A82E5B80731,
   $13303FC36DE4FED3,$2E29C43E5314168A,$861FBF5C0D1670FA,$6458B16AF3F771F1,
   $3043765BDCF642C9,$12FD55F4B825BE0C,$0A266E23D65E9F92,$6595DB5D2636312E,
   $85BD010587A0B06E,$9BD7B3600842E42D,$AA59AF0C0175E63B,$240FAA1D854A8918,
   $F464061EF82A4A91,$5C527D7CA6282CE1,$03A2BE598AB6C094,$40571B7776BDF8E9,
   $E4F687841F7874D6,$115FEBAD32937E98,$5108F0DA442E8671,$9CAB50E53C1AD12F,
   $33E1C8025640825D,$87D2D56BD8D73025,$C0F92D999A32FDCE,$62E938D8126E042C,
   $4A717554A0E3677B,$0BEB0414039FDF4D,$D6DA25B19CF9B654,$55D6AD06FAC073E7,
   $632452EFC7AF44F3,$B5FE775E5B56F2A7,$892AE694B0675A21,$7A32030F7C1525B2,
   $5D9F174B73E96C3E,$C35B93C010843D5A,$373F95DEE8AE77CB,$FB515FD6455B604A,
   $A9FB11558BC326AF,$22BE23AF64D3FCC5,$A8367B625E026670,$B8A4FAF8B9505837,
   $785DD7612362A5F9,$588C20A018C6D977,$EA0EB47B77C81ED2,$A6CE489D36B20C74,
   $0C97E79137C7EA4F,$7C838ABD9D8C506F,$57B97968A5B7F3AC,$6C110B277ADE6E28,
   $C785CE1CAE6AC8CC,$1581B6718C7D8B0E,$614B868198D8C4B8,$27AD14440FFC498C,
   $DB80A8177EFF1CC4,$472BF8F242E5CDEB,$8A8858CD3AD19AB5,$F60BD270A75DCADA,
   $43F5A52EFC0B387D,$6DDC6110AF1F2EF7,$F0BA5BC246C4BF07,$6FB3B57EF068AEBC,
   $18DB3BD76E7B219E,$903CB7740BDD3B60,$7BFF6938A9D4656D,$BDB7CD13D27FED7E,
   $051337EB6B2FB549,$77688EA99E138F22,$D9EF7C7921889C8F,$077CE38534583502,
   $F318E59BCC727F93,$B34FFEECBACF877A,$E9AC0A22FD7EDE46,$FC2DBC5371035548,
   $026FD46E5F77804B,$E53BEDB3CAB93409,$CC6ECA08ADF51781,$E028DA58A1968140,
   $3A6518780AA8DD5B,$CE011E66F28297CA,$A4A19CF369C58C3F,$C5EA1A72F11D4887,
   $C427704524DC0858,$4238CF1929CA78A2,$481EA13AFF94E730,$DF5EF5CBC011E952,
   $80AE36EEEC8F0527,$5AE3F4CE47B1593C,$CDA3A03F7834575E,$71D9071B7F8AFAFF,
   $CADF43BA4C6C625C,$1623082806CB4B9A,$17EE621FD30A0B45,$448946ABC8530D7F,
   $974054F13F850E62,$73B6D37520FD7AB4,$C8B097D4131BE217,$9F09EEBCB6AC11BB,
   $45442C9C1D924DA0,$1B79858EE4CDE10A,$0984D07A5CE85F06,$4CC0FCE6417A12A6,
   $99B8670E57356466,$AD254C89352DD339,$322CA2358381C282,$CFCC74512743D715,
   $6B6DE8A24E865B2A,$DA4DC220AB3E5C1B,$88E78CA365A61AFE,$939E092D816BFBF4,
   $CB12298D99AD2283,$EED0E9A7C926EB44,$98750D3982F424B9,$D5789BE8164F76C0,
   $BE15734A58C92DEA,$49D3CB0D2A55A7EF,$67FA0F337941B165,$8C39D17FDB48EF68,
   $25C2C02A508BC9C7,$349D2B876218B75F,$70146D2CAA4BBA20,$1C05660BD095D408,
   $FE42683D2E74D503,$9A1AD957DD83A4F2,$F2D58FAC19B33F4C,$81635CD9394E45F8,
   $B65CC907D1E03233,$DD3121A59F666919,$318E1C6C09370216,$8B4532FAEF10DA6A,
   $191651E0BBBA6141,$3F762F9361876812,$B96990CF6C9118E8,$B4331D698E97B278,
   $D822164EF449DC50,$84706B325261F0B1,$4EAF28881E0D92ED,$69023CCC11F1DB61,
   $66376504AC80F1BA,$0849BA4D89291FD9,$FF8F020AFBB595DC,$50C59AED91EFC6AE,
   $1DC80C3C055494D7,$1E6AB2658FE25443,$3D19FBFD3EF0E859,$FA9C35E1909A2095,
   $52AA4E83CE9846E5,$419A7140A37CB836,$A07FC12FD72B79A9,$68CF56FBC4309BBE,
   $01CD6A37D5C140DF,$9253631A54AABB2B,$D06BAC037D60C389,$295527BB674C2388,
   $D204786D221743C2,$0000000000000000,$F7C6B847729C8A05,$DCFC4B924AA729C6,
   $E38A64012B2041D4,$B28294DB6F0EC7A5,$9D663AD2E9DB91F0,$91F1DD43DE1C7BBF,
   $6086ECB64D198467,$59414A97CD0799A8,$ACE826BEE0EC93E6,$A56CF6C4BC04CCE0,
   $727BB942F53C3A6B,$6E7EDF4925A9EE63,$26607E73DA3D0953,$E75439DD95CEB442,
   $7990BD56F6A3E526,$ECBF3DC996516B0F,$76A5E49E4BD2CFFD,$968D3EC6EA444EBD,
   $5B2E9EF9927019E3,$6AA082959B471BF5,$BB0644A133E698A3,$830C88B76639C5B3,
   $E2470E36FEE1010B,$B0ED40B5307947EE,$355041B0B7D9F780,$8E560511843F6F23,
   $7F2134E4173A90FB,$2AF799E2EDFAE31C,$4BBC1F63752227A4,$F8F3E18FCFEDA0DE,
   $0D5A8DA6E206AA90,$2C4610500C6396C1,$DE939FFC15D0A98D,$AF4A98E76A5A5372,
   $8F9B6F2651FE2FFC,$36F2FFE93D6F3714,$0EF833FF68B06A04,$E69953EA400FF49D,
   $23734998B112BC1A,$3EBB45A4B44628CD,$1AB4EFB9310CA1D5,$2FE4AE0986D55655,
   $EBC3DE4CA2095E0D,$536724B41B59063A,$46E692C597248D34,$2B3AF3D5383BA3C3,
   $3BA8724FDF699D84,$C13447AE4FF3BD11,$4D0D96D194BB5279,$FDE0D664A4C21597,
   $D7174F864938F68B,$7EEC5ED3C2FBD024,$BFD8197D8D086D35,$4F6242BFCBCCD232,
   $A70322AAE3734CAB,$A3DD7F765D9DB93D,$94E2EAA8B533CEF6,$144CDC4659BCCBD1,
   $C648A42B7BAB8813,$F93E8BB81A2CE001,$BACB2E96E627D87C,$BC7AA72407BEADA1,
   $C97DFDE3C6DAA2C8,$A1B2AB1802EA3976,$1FA7D8525A23149C,$75075AC7C1640F69,
   $E861601528BF9E99,$A2101541885CF9E2,$EF1D83901CE7AB9B,$06B189B2E19975DD,
   $380ACC1655DF5D10,$1092819AE7523E47,$D3C9125AF7D6031D,$D1A6C634A8A18356,
   $5FF0C3252C9EEC75,$82C1E280B3F8856C,$ED7257FE43902BD0,$3CD491CAEB31A886),
   // box 6
  ($94AF9EB6FAD9E7DF,$9208AE5E03C94DDD,$1D8DE8D67158480B,$FD093CD2BA147AF8,
   $A45CEB22E6597CCF,$9BBDE6E77BF113DA,$E4EDF4B465FFFE5C,$7125622E4E8D2A2F,
   $1791B81B8F68430D,$B56A63D1902195C0,$A980832B30D2EE67,$4C0A7FB384862397,
   $ED58BC0D1DC7A05B,$5955D7F05C4D0637,$D2B9B1C8806FCF4E,$06A730E8F910AA02,
   $B8B60BD846AA0768,$45BF370AFCBE7D90,$16F6B0375EC370A1,$892276608B81AFD4,
   $DCCCC1B5D0EC08E7,$E856949162DF5F58,$82592E81A41A977E,$AC8EABB74FCA1164,
   $FAC9041692AFE356,$3B882D75331BA3BA,$A39CD3E6CEE2E561,$D077A190D7CCA9E3,
   $9C7DDE23534A8A74,$80973ED9F3B9F1D3,$CE535132209CB4E9,$AA299B5FB6DABB66,
   $2D7E9D426DD8D31B,$8A8B6E140D89FAD5,$6CA88AF83FD56224,$F5DB7C4713871753,
   $EEF1A4799BCFF55A,$76E55AEA6636B381,$8EE24EA4A33A367A,$25ACDDD7C44BBEB0,
   $9ADAEECBAA5A2076,$0E75707D5083C7A9,$2BD9ADAA94C87919,$19E4C866DFEB84A4,
   $129F9087F070BC0E,$D9C2E929AFF4F7E4,$6F01928CB9DD3725,$39463D2D64B8C517,
   $EBFF8CE5E4D70A59,$B40D6BFD418AA66C,$F21B44833B3C8EFD,$3654457CE5903112,
   $431807E205AED792,$B10343613E92596F,$0A1C50CDFE300B06,$778252C6B79D802D,
   $0CBB60250720A104,$E1E3DC281AE7015F,$0F1278518128F405,$47712752AB1D1B3D,
   $E24AC45C9CEF545E,$1CEAE0FAA0F37BA7,$9814FE93FDF946DB,$EC3FB421CC6C93F7,
   $833E26AD75B1A4D2,$6B68B23C176EFB8A,$4904572FFB9EDC94,$4BCA4777AC3DBA39,
   $2762CD8F93E8D81D,$9EB3CE7B04E9ECD9,$C2E8311727BC15ED,$EA9884C9357C39F5,
   $FC6E34FE6BBF4954,$13F898AB21DB8FA2,$B7A47389C782F36D,$7B3932E3B0BD2129,
   $AF27B3C3C9C24465,$B6C37BA51629C0C1,$84FE1E695D0A3D7C,$1A4DD01259E3D1A5,
   $AB4E9373677188CA,$90C6BE06546A2B70,$F37C4CAFEA97BD51,$647ACA6D96460F8F,
   $4EC46FEBD325453A,$3E8605E94C035CB9,$0DDC6809D68B92A8,$8BEC6638DC22C979,
   $67D3D219104E5A8E,$2ABEA58645634AB5,$5B9BC7A80BEE609A,$936FA672D2627E71,
   $7D9E020B49AD8B2B,$5832DFDC8DE6359B,$C7E6198B58A4EAEE,$D41E8120797F654C,
   $F4BC746BC22C24FF,$E084D404CB4C32F3,$48635F032A35EF38,$8757061DDB02687D,
   $522E8F1173D63E9D,$BCDF2B68E819CBC7,$BF76331C6E119EC6,$08D24095A9936DAB,
   $728C7A5AC8857F2E,$D110A9BC06679A4F,$1F43F88E26FB2EA6,$B2AA5B15B89A0C6E,
   $4AAD4F5B7D968995,$9FD4C657D542DF75,$323D65CC4B23FDBD,$C38F393BF6172641,
   $A152C3BE994183CC,$9D1AD60F82E1B9D8,$E744ECC0E3F7AB5D,$38213501B513F6BB,
   $ADE9A39B9E6122C8,$37334D50343B02BE,$55EEB7D55B6DA733,$970686C27CD1B2DE,
   $427F0FCED405E43E,$C026214F701F7340,$40B11F9683A68293,$02CE105857A366AD,
   $7E371A7FCFA5DE2A,$FFC72C8AEDB71C55,$68C1AA489166AE8B,$C68111A7890FD942,
   $79F722BBE71E4784,$D579890CA8D456E0,$70426A029F261983,$B0644B4DEF396AC3,
   $DB0CF971F8579149,$5489BFF98AC6949F,$046920B0AEB3CCAF,$7CF90A279806B887,
   $050E289C7F18FF03,$651DC24147ED3C23,$5E95EF3474F69F99,$6DCF82D4EE7E5188,
   $8F854688729105D6,$81F036F52212C27F,$B9D103F4970134C4,$5349873DA27D0D31,
   $20A2F54BBB5341B3,$F0D554DB6C9FE850,$07C038C428BB99AE,$30F375941C809B10,
   $3FE10DC59DA86F15,$46162F7E7AB62891,$E623E4EC325C98F1,$FEA024A63C1C2FF9,
   $349A5524B23357BF,$35FD5D0863986413,$96618EEEAD7A8172,$CB5D79AE5F844BEA,
   $21C5FD676AF8721F,$5720A78D0CCEC19E,$F6726433958F4252,$8D4B56D02532637B,
   $24CBD5FB15E08D1C,$3AEF2559E2B09016,$5AFCCF84DA455336,$51879765F5DE6B9C,
   $2917BDF2C36B1FB4,$A7F5F356605129CE,$C1412963A1B440EC,$3D2F1D9DCA0B09B8,
   $A53BE30E37F24F63,$5FF2E718A55DAC35,$A2FBDBCA1F49D6CD,$F7156C1F442471FE,
   $7A5E3ACF61161285,$CA3A71828E2F7846,$1B2AD83E8848E209,$A8E78B07E179DDCB,
   $EF96AC554A64C6F6,$0000000000000000,$6013EADD38F5C320,$3C4815B11BA03A14,
   $09B548B978385E07,$226CE513ECF0271E,$63BAF2A9BEFD9621,$44D83F262D154E3C,
   $CDFA4946A694E1E8,$113688F37678E90F,$859916458CA10ED0,$C52809D30F078C43,
   $4D6D779F552D103B,$1E24F0A2F7501D0A,$0167082CD1AB33AC,$1438A06F0960160C,
   $F9601C6214A7B657,$A035CB9248EAB060,$50E09F4924755830,$D7B79954FF77304D,
   $E58AFC98B454CDF0,$03A9187486085501,$62DDFA856F56A58D,$C44F01FFDEACBFEF,
   $73EB7276192E4C82,$D6D091782EDC03E1,$FBAE0C3A4304D0FA,$9973F6BF2C527577,
   $105180DFA7D3DAA3,$2605C5A34243EBB1,$91A1B62A85C118DC,$C99369F608272D47,
   $5D3CF740F2FECA98,$CF34591EF1378745,$C8F461DAD98C1EEB,$0B7B58E12F9B38AA,
   $E32DCC704D4467F2,$754C429EE03EE680,$D3DEB9E451C4FCE2,$6E669AA068760489,
   $66B4DA35C1E56922,$4FA367C7028E7696,$BA781B80110961C5,$41D617BA520DB13F,
   $335A6DE09A88CE11,$DF65D9C156E45DE6,$CC9D416A773FD244,$5C5BFF6C2355F934,
   $2870B5DE12C02C18,$155FA843D8CB25A0,$78902A9736B57428,$AE40BBEF186977C9,
   $88457E4C5A2A9C78,$6A0FBA10C6C5C826,$7F5012531E0EED86,$8C2C5EFCF49950D7,
   $31947DB8CD2BA8BC,$2C19956EBC73E0B7,$230BED3F3D5B14B2,$69A6A26440CD9D27,
   $86300E310AA95BD1,$B3CD533969313FC2,$1883C04A0E40B708,$F1B25CF7BD34DBFC,
   $2FB08D1A3A7BB5B6,$D8A5E1057E5FC448,$DDABC99901473B4B,$DE02D1ED874F6E4A,
   $BDB8234439B2F86B,$5647AFA1DD65F232,$2ED78536EBD0861A,$E9319CBDB3746CF4,
   $A692FB7AB1FA1A62,$742B4AB23195D52C,$95C8969A2B72D473,$6174E2F1E95EF08C,
   $F807144EC50C85FB,$BE113B30BFBAAD6A,$DA6BF15D29FCA2E5,$BB1F13ACC0A25269),
   // box 7
  ($C22B27F0F9E37BF9,$93FAD23F0955EF09,$32ED4B84A22A91A2,$3898B57BCC61B1CC,
   $55825BA9AD98E5AD,$B2EEB8069421EC94,$C7EB5875CE3C6BCE,$4B1DAC5D1F45851F,
   $C16BA1204705D847,$C5380F461A2BA91A,$B908971A909BAD90,$303E1CB7763D5376,
   $E6FF324C53486853,$6D1AEED261F95461,$0193D1E36AF1616A,$51D1F5CFF0B694F0,
   $29B2C3F52728E127,$112A768EEB4950EB,$8FB672F86F9F4D6F,$F0C66C745BC9EA5B,
   $3F8B9DCD2FA9632F,$65BC471EDBA5B6DB,$4D9D5508967C3696,$3A4BE24818767318,
   $2794936C144DB014,$2AF2452599CE4299,$4A8E7DBE75B4E475,$9DDC82A63A30BE3A,
   $ADE29E114C0DED4C,$D1D2064DC6BDE9C6,$7DA349BFE04165E0,$6B9A1787E8C0E7E8,
   $A54437DDF6510FF6,$2254ECE92392A023,$79F0E7D9BD6F14BD,$57510C9A798F2779,
   $346DB2D12B13222B,$54118A4AC76984C7,$EFCA4A6383E5EB83,$CA8D8E3C43BF9943,
   $FC336BDEBCBB79BC,$3E184C2E45580245,$F495C21206E79B06,$FF73ED0E025DDA02,
   $4228D472CFE806CF,$BCC8E89FA744BDA7,$AB626744C5345EC5,$B6BD1660C90F9DC9,
   $B72EC783A3FEFCA3,$8BE5DC9E32B13C32,$485D2A8DA1A326A1,$C6788996A4CD0AA4,
   $40FB83411BFFC41B,$08A6A9CCBA5CE2BA,$F386EAA4E52F49E5,$1ACC5992EFF311EF,
   $A2571F6B1599DD15,$44A82D2746D1B546,$70C59FF66DC2976D,$8D6525CBBB888FBB,
   $963AADBA3E8AFF3E,$7C30985C8AB0048A,$607C389BEC7AA6EC,$A822E1947BD2FD7B,
   $034086D0BEE6A3BE,$66FCC1CE65431565,$B37D69E5FED08DFE,$2F323AA0AE1152AE,
   $56C2DD79137E4613,$31ADCD541CCC321C,$DFF456D4F5D8B8F5,$F9F3145B8B64698B,
   $764566A3E4FB24E4,$0CF507AAE77293E7,$59775C034AEA764A,$B89B46F9FA6ACCFA,
   $E8D962D5602D3960,$17AA8FDB6270E362,$1C4CA0C766CAA266,$2DE16D937A06907A,
   $2547C45FC05A72C0,$0FB5817A59943059,$0680F9558939B389,$16395E3808818208,
   $AC714FF226FC8C26,$A9B1307711239C11,$EC8ACCB33D03483D,$6C893F310B08350B,
   $C4ABDEA570DAC870,$BA4811CA2E7D0E2E,$F155BD9731388B31,$DD2701E721CF7A21,
   $E94AB3360ADC580A,$23C73D0A4963C149,$5CB723867D35667D,$5042242C9A47F59A,
   $198CDF425115B251,$0A75FEFF6E4B206E,$FDA0BA3DD64A18D6,$CEDE205A1E91E81E,
   $D041D7AEAC4C88AC,$E42C657F875FAA87,$36BEE5E2FF04E0FF,$6FC9B9E1B5EE96B5,
   $998F2CC0671ECF67,$D301517E12AA2B12,$AEA218C1F2EB4EF2,$DA342951C207A8C2,
   $61EFE978868BC786,$7F701E8C3456A734,$0BE62F1C04BA4104,$9129850CDD422DDD,
   $D6C12EFB25753B25,$E33F4DC964977864,$1579D8E8B66721B6,$F860C5B8E19508E1,
   $7496319030ECE630,$88A55A4E8C579F8C,$CF4DF1B974608974,$10B9A76D81B83181,
   $0E26509933655133,$43BB0591A51967A5,$926903DC63A48E63,$9C4F534550C1DF50,
   $3BD833AB72871272,$A4D7E63E9CA06E9C,$B46E41531D185F1D,$126AF05E55AFF355,
   $24D415BCAAAB13AA,$1E9FF7F4B2DD60B2,$05C07F8537DF1037,$467B7A1492C67792,
   $2087BBDAF78562F7,$819022615CFA1C5C,$CD9EA68AA0774BA0,$A79760EE2246CD22,
   $8343755288EDDE88,$58E48DE0201B1720,$7216C8C5B9D555B9,$372D340195F58195,
   $A11799BBAB7F7EAB,$9F0FD595EE277CEE,$676F102D0FB2740F,$9E9C047684D61D84,
   $49CEFB6ECB5247CB,$D41279C8F162F9F1,$1F0C2617D82C01D8,$97A97C59547B9E54,
   $E76CE3AF39B90939,$C3B8F61393121A93,$5BA40B309EFDB49E,$EA0A35E6B43AFBB4,
   $5A37DAD3F40CD5F4,$14EA090BDC9640DC,$5E6474B5A922A4A9,$FEE03CED68ACBB68,
   $071328B6E3C8D2E3,$5302A2FC24A15624,$85C38C0701D46D01,$3D58CAFEFBBEA1FB,
   $84505DE46B250C6B,$642F96FDB154D7B1,$BF886E4F19A21E19,$02D35733D417C2D4,
   $68DA915756264456,$8710DB34D5C3AFD5,$0D66D6498D83F28D,$7B23B0EA6978D669,
   $1B5F887185027085,$3CCB1B1D914FC091,$0453AE665D2E715D,$CB1E5FDF294EF829,
   $F6469521D2F059D2,$B03DEF3540362E40,$633CBE4B529C0552,$F7D544C2B80138B8,
   $7AB061090389B703,$0000000000000000,$DBA7F8B2A8F6C9A8,$35FE633241E24341,
   $21146A399D74039D,$D581A82B9B93989B,$0935782FD0AD83D0,$5FF7A556C3D3C5C3,
   $AF31C922981A2F98,$90BA54EFB7B34CB7,$5291731F4E50374E,$C0F870C32DF4B92D,
   $7EE3CF6F5EA7C65E,$E07FCB19DA71DBDA,$4EDDD3D8289A9528,$13F921BD3F5E923F,
   $F50613F16C16FA6C,$981CFD230DEFAE0D,$4C0E84EBFC8D57FC,$82D0A4B1E21CBFE2,
   $89368BADE6A6FEE6,$D292809D785B4A78,$47E8ABF7F83716F8,$8E25A31B056E2C05,
   $D752FF184F845A4F,$CC0D7769CA862ACA,$694940B43CD7253C,$2EA1EB43C4E033C4,
   $DE6787379F29D99F,$181F0EA13BE4D33B,$416852A2710EA571,$62AF6FA8386D6438,
   $A0844858C18E1FC1,$337E9A67C8DBF0C8,$2C72BC7010F7F110,$BD5B397CCDB5DCCD,
   $D8E77E6216106A16,$86830AD7BF32CEBF,$4F4E023B426BF442,$E5BFB49CEDAECBED,
   $8A760D7D58405D58,$E2AC9C2A0E66190E,$B5FD90B077E93E77,$DCB4D0044B3E1B4B,
   $453BFCC42C20D42C,$ED191D5057F22957,$E1EC1AFAB080BAB0,$EE599B80E9148AE9,
   $2607428F7EBCD17E,$5D24F26517C40717,$6A09C66482318682,$A604B10D48B7AC48,
   $BE1BBFAC73537F73,$282112164DD9804D,$7505E0735A1D875A,$73851926D32434D3,
   $D974AF817CE10B7C,$EB99E405DECB9ADE,$9B5C7BF3B3090DB3,$FAB3928B3582CA35,
   $8003F382360B7D36,$94E9FA89EA9D3DEA,$B1AE3ED62AC74F2A,$9ACFAA10D9F86CD9,
   $390B6498A690D0A6,$F2153B478FDE288F,$71564E150733F607,$A3C4CE887F68BC7F,
   $AAF1B6A7AFC53FAF,$1DDF71240C3BC30C,$77D6B7408E0A458E,$2B6194C6F33F23F3,
   $C9CD08ECFD593AFD,$C85ED90F97A85B97,$8CF6F428D179EED1,$957A2B6A806C5C80,
   $BBDBC029448C6F44,$7863363AD79E75D7,$6E5A6802DF1FF7DF,$FB2043685F73AB5F));
 {$IFEND}

  Skipjack_Data: array[0..255] of Byte = (
    $A3,$D7,$09,$83,$F8,$48,$F6,$F4,$B3,$21,$15,$78,$99,$B1,$AF,$F9,
    $E7,$2D,$4D,$8A,$CE,$4C,$CA,$2E,$52,$95,$D9,$1E,$4E,$38,$44,$28,
    $0A,$DF,$02,$A0,$17,$F1,$60,$68,$12,$B7,$7A,$C3,$E9,$FA,$3D,$53,
    $96,$84,$6B,$BA,$F2,$63,$9A,$19,$7C,$AE,$E5,$F5,$F7,$16,$6A,$A2,
    $39,$B6,$7B,$0F,$C1,$93,$81,$1B,$EE,$B4,$1A,$EA,$D0,$91,$2F,$B8,
    $55,$B9,$DA,$85,$3F,$41,$BF,$E0,$5A,$58,$80,$5F,$66,$0B,$D8,$90,
    $35,$D5,$C0,$A7,$33,$06,$65,$69,$45,$00,$94,$56,$6D,$98,$9B,$76,
    $97,$FC,$B2,$C2,$B0,$FE,$DB,$20,$E1,$EB,$D6,$E4,$DD,$47,$4A,$1D,
    $42,$ED,$9E,$6E,$49,$3C,$CD,$43,$27,$D2,$07,$D4,$DE,$C7,$67,$18,
    $89,$CB,$30,$1F,$8D,$C6,$8F,$AA,$C8,$74,$DC,$C9,$5D,$5C,$31,$A4,
    $70,$88,$61,$2C,$9F,$0D,$2B,$87,$50,$82,$54,$64,$26,$7D,$03,$40,
    $34,$4B,$1C,$73,$D1,$C4,$FD,$3B,$CC,$FB,$7F,$AB,$E6,$3E,$5B,$A5,
    $AD,$04,$23,$9C,$14,$51,$22,$F0,$29,$79,$71,$7E,$FF,$8C,$0E,$E2,
    $0C,$EF,$BC,$72,$75,$6F,$37,$A1,$EC,$D3,$8E,$62,$8B,$86,$10,$E8,
    $08,$77,$11,$BE,$92,$4F,$24,$C5,$32,$36,$9D,$CF,$F3,$A6,$BB,$AC,
    $5E,$6C,$A9,$13,$57,$25,$B5,$E3,$BD,$A8,$3A,$01,$05,$59,$2A,$46);

  DES_PC1: array[0..55] of Byte =
   (56, 48, 40, 32, 24, 16,  8,  0, 57, 49, 41, 33, 25, 17,
     9,  1, 58, 50, 42, 34, 26,	18, 10,  2, 59, 51, 43, 35,
    62, 54, 46, 38, 30, 22, 14,	 6, 61, 53, 45, 37, 29, 21,
    13,  5, 60, 52, 44, 36, 28,	20, 12,  4, 27, 19, 11,  3);

  DES_PC2: array[0..47] of Byte =
   (13, 16, 10, 23,  0,  4,  2, 27, 14,  5, 20,  9,
    22, 18, 11,  3, 25,  7, 15,  6, 26, 19, 12,  1,
    40, 51, 30, 36, 46, 54, 29, 39, 50, 44, 32, 47,
    43, 48, 38, 55, 33, 52, 45, 41, 49, 35, 28, 31);

  DES_Data: array[0..7, 0..63] of LongWord = (
   ($00200000,$04200002,$04000802,$00000000,$00000800,$04000802,$00200802,$04200800,
    $04200802,$00200000,$00000000,$04000002,$00000002,$04000000,$04200002,$00000802,
    $04000800,$00200802,$00200002,$04000800,$04000002,$04200000,$04200800,$00200002,
    $04200000,$00000800,$00000802,$04200802,$00200800,$00000002,$04000000,$00200800,
    $04000000,$00200800,$00200000,$04000802,$04000802,$04200002,$04200002,$00000002,
    $00200002,$04000000,$04000800,$00200000,$04200800,$00000802,$00200802,$04200800,
    $00000802,$04000002,$04200802,$04200000,$00200800,$00000000,$00000002,$04200802,
    $00000000,$00200802,$04200000,$00000800,$04000002,$04000800,$00000800,$00200002),
   ($00000100,$02080100,$02080000,$42000100,$00080000,$00000100,$40000000,$02080000,
    $40080100,$00080000,$02000100,$40080100,$42000100,$42080000,$00080100,$40000000,
    $02000000,$40080000,$40080000,$00000000,$40000100,$42080100,$42080100,$02000100,
    $42080000,$40000100,$00000000,$42000000,$02080100,$02000000,$42000000,$00080100,
    $00080000,$42000100,$00000100,$02000000,$40000000,$02080000,$42000100,$40080100,
    $02000100,$40000000,$42080000,$02080100,$40080100,$00000100,$02000000,$42080000,
    $42080100,$00080100,$42000000,$42080100,$02080000,$00000000,$40080000,$42000000,
    $00080100,$02000100,$40000100,$00080000,$00000000,$40080000,$02080100,$40000100),
   ($00000208,$08020200,$00000000,$08020008,$08000200,$00000000,$00020208,$08000200,
    $00020008,$08000008,$08000008,$00020000,$08020208,$00020008,$08020000,$00000208,
    $08000000,$00000008,$08020200,$00000200,$00020200,$08020000,$08020008,$00020208,
    $08000208,$00020200,$00020000,$08000208,$00000008,$08020208,$00000200,$08000000,
    $08020200,$08000000,$00020008,$00000208,$00020000,$08020200,$08000200,$00000000,
    $00000200,$00020008,$08020208,$08000200,$08000008,$00000200,$00000000,$08020008,
    $08000208,$00020000,$08000000,$08020208,$00000008,$00020208,$00020200,$08000008,
    $08020000,$08000208,$00000208,$08020000,$00020208,$00000008,$08020008,$00020200),
   ($01010400,$00000000,$00010000,$01010404,$01010004,$00010404,$00000004,$00010000,
    $00000400,$01010400,$01010404,$00000400,$01000404,$01010004,$01000000,$00000004,
    $00000404,$01000400,$01000400,$00010400,$00010400,$01010000,$01010000,$01000404,
    $00010004,$01000004,$01000004,$00010004,$00000000,$00000404,$00010404,$01000000,
    $00010000,$01010404,$00000004,$01010000,$01010400,$01000000,$01000000,$00000400,
    $01010004,$00010000,$00010400,$01000004,$00000400,$00000004,$01000404,$00010404,
    $01010404,$00010004,$01010000,$01000404,$01000004,$00000404,$00010404,$01010400,
    $00000404,$01000400,$01000400,$00000000,$00010004,$00010400,$00000000,$01010004),
   ($10001040,$00001000,$00040000,$10041040,$10000000,$10001040,$00000040,$10000000,
    $00040040,$10040000,$10041040,$00041000,$10041000,$00041040,$00001000,$00000040,
    $10040000,$10000040,$10001000,$00001040,$00041000,$00040040,$10040040,$10041000,
    $00001040,$00000000,$00000000,$10040040,$10000040,$10001000,$00041040,$00040000,
    $00041040,$00040000,$10041000,$00001000,$00000040,$10040040,$00001000,$00041040,
    $10001000,$00000040,$10000040,$10040000,$10040040,$10000000,$00040000,$10001040,
    $00000000,$10041040,$00040040,$10000040,$10040000,$10001000,$10001040,$00000000,
    $10041040,$00041000,$00041000,$00001040,$00001040,$00040040,$10000000,$10041000),
   ($20000010,$20400000,$00004000,$20404010,$20400000,$00000010,$20404010,$00400000,
    $20004000,$00404010,$00400000,$20000010,$00400010,$20004000,$20000000,$00004010,
    $00000000,$00400010,$20004010,$00004000,$00404000,$20004010,$00000010,$20400010,
    $20400010,$00000000,$00404010,$20404000,$00004010,$00404000,$20404000,$20000000,
    $20004000,$00000010,$20400010,$00404000,$20404010,$00400000,$00004010,$20000010,
    $00400000,$20004000,$20000000,$00004010,$20000010,$20404010,$00404000,$20400000,
    $00404010,$20404000,$00000000,$20400010,$00000010,$00004000,$20400000,$00404010,
    $00004000,$00400010,$20004010,$00000000,$20404000,$20000000,$00400010,$20004010),
   ($00802001,$00002081,$00002081,$00000080,$00802080,$00800081,$00800001,$00002001,
    $00000000,$00802000,$00802000,$00802081,$00000081,$00000000,$00800080,$00800001,
    $00000001,$00002000,$00800000,$00802001,$00000080,$00800000,$00002001,$00002080,
    $00800081,$00000001,$00002080,$00800080,$00002000,$00802080,$00802081,$00000081,
    $00800080,$00800001,$00802000,$00802081,$00000081,$00000000,$00000000,$00802000,
    $00002080,$00800080,$00800081,$00000001,$00802001,$00002081,$00002081,$00000080,
    $00802081,$00000081,$00000001,$00002000,$00800001,$00002001,$00802080,$00800081,
    $00002001,$00002080,$00800000,$00802001,$00000080,$00800000,$00002000,$00802080),
   ($80108020,$80008000,$00008000,$00108020,$00100000,$00000020,$80100020,$80008020,
    $80000020,$80108020,$80108000,$80000000,$80008000,$00100000,$00000020,$80100020,
    $00108000,$00100020,$80008020,$00000000,$80000000,$00008000,$00108020,$80100000,
    $00100020,$80000020,$00000000,$00108000,$00008020,$80108000,$80100000,$00008020,
    $00000000,$00108020,$80100020,$00100000,$80008020,$80100000,$80108000,$00008000,
    $80100000,$80008000,$00000020,$80108020,$00108020,$00000020,$00008000,$80000000,
    $00008020,$80108000,$00100000,$80000020,$00100020,$80008020,$80000020,$00100020,
    $00108000,$00000000,$80008000,$00008020,$80000000,$80100020,$80108020,$00108000));

  NewDES_Data: array[0..255] of Byte = (
    32,137,239,188,102,125,221, 72,212, 68, 81, 37, 86,237,147,149,
    70,229, 17,124,115,207, 33, 20,122,143, 25,215, 51,183,138,142,
   146,211,110,173,  1,228,189, 14,103, 78,162, 36,253,167,116,255,
   158, 45,185, 50, 98,168,250,235, 54,141,195,247,240, 63,148,  2,
   224,169,214,180, 62, 22,117,108, 19,172,161,159,160, 47, 43,171,
   194,175,178, 56,196,112, 23,220, 89, 21,164,130,157,  8, 85,251,
   216, 44, 94,179,226, 38, 90,119, 40,202, 34,206, 35, 69,231,246,
    29,109, 74, 71,176,  6, 60,145, 65, 13, 77,151, 12,127, 95,199,
    57,101,  5,232,150,210,129, 24,181, 10,121,187, 48,193,139,252,
   219, 64, 88,233, 96,128, 80, 53,191,144,218, 11,106,132,155,104,
    91,136, 31, 42,243, 66,126,135, 30, 26, 87,186,182,154,242,123,
    82,166,208, 39,152,190,113,205,114,105,225, 84, 73,163, 99,111,
   204, 61,200,217,170, 15,198, 28,192,254,134,234,222,  7,236,248,
   201, 41,177,156, 92,131, 67,249,245,184,203,  9,241,  0, 27, 46,
   133,174, 75, 18, 93,209,100,120, 76,213, 16, 83,  4,107,140, 52,
   58, 55,  3,244, 97,197,238,227,118, 49, 79,230,223,165,153, 59);

// .Hash

  MD2_PISubst: array[Byte] of LongWord = (
     41,  46,  67, 201, 162, 216, 124,   1,  61,  54,  84, 161, 236, 240,   6,  19,
     98, 167,   5, 243, 192, 199, 115, 140, 152, 147,  43, 217, 188,  76, 130, 202,
     30, 155,  87,  60, 253, 212, 224,  22, 103,  66, 111,  24, 138,  23, 229,  18,
    190,  78, 196, 214, 218, 158, 222,  73, 160, 251, 245, 142, 187,  47, 238, 122,
    169, 104, 121, 145,  21, 178,   7,  63, 148, 194,  16, 137,  11,  34,  95,  33,
    128, 127,  93, 154,  90, 144,  50,  39,  53,  62, 204, 231, 191, 247, 151,   3,
    255,  25,  48, 179,  72, 165, 181, 209, 215,  94, 146,  42, 172,  86, 170, 198,
     79, 184,  56, 210, 150, 164, 125, 182, 118, 252, 107, 226, 156, 116,   4, 241,
     69, 157, 112,  89, 100, 113, 135,  32, 134,  91, 207, 101, 230,  45, 168,   2,
     27,  96,  37, 173, 174, 176, 185, 246,  28,  70,  97, 105,  52,  64, 126,  15,
     85,  71, 163,  35, 221,  81, 175,  58, 195,  92, 249, 206, 186, 197, 234,  38,
     44,  83,  13, 110, 133,  40, 132,   9, 211, 223, 205, 244,  65, 129,  77,  82,
    106, 220,  55, 200, 108, 193, 171, 250,  36, 225, 123,   8,  12, 189, 177,  74,
    120, 136, 149, 139, 227,  99, 232, 109, 233, 203, 213, 254,  59,   0,  29,  57,
    242, 239, 183,  14, 102,  88, 208, 228, 166, 119, 114, 248, 235, 117,  75,  10,
     49,  68,  80, 180, 143, 237,  31,  26, 219, 153, 141,  51, 159,  17, 131,  20);

  Haval_Data: array[0..127] of LongWord =
   ($452821E6,$38D01377,$BE5466CF,$34E90C6C,$C0AC29B7,$C97C50DD,$3F84D5B5,$B5470917,
    $9216D5D9,$8979FB1B,$D1310BA6,$98DFB5AC,$2FFD72DB,$D01ADFB7,$B8E1AFED,$6A267E96,
    $BA7C9045,$F12C7F99,$24A19947,$B3916CF7,$0801F2E2,$858EFC16,$636920D8,$71574E69,
    $A458FEA3,$F4933D7E,$0D95748F,$728EB658,$718BCD58,$82154AEE,$7B54A41D,$C25A59B5,
    $9C30D539,$2AF26013,$C5D1B023,$286085F0,$CA417918,$B8DB38EF,$8E79DCB0,$603A180E,
    $6C9E0E8B,$B01E8A3E,$D71577C1,$BD314B27,$78AF2FDA,$55605C60,$E65525F3,$AA55AB94,
    $57489862,$63E81440,$55CA396A,$2AAB10B6,$B4CC5C34,$1141E8CE,$A15486AF,$7C72E993,
    $B3EE1411,$636FBC2A,$2BA9C55D,$741831F6,$CE5C3E16,$9B87931E,$AFD6BA33,$6C24CF5C,
    $7A325381,$28958677,$3B8F4898,$6B4BB9AF,$C4BFE81B,$66282193,$61D809CC,$FB21A991,
    $487CAC60,$5DEC8032,$EF845D5D,$E98575B1,$DC262302,$EB651B88,$23893E81,$D396ACC5,
    $0F6D6FF3,$83F44239,$2E0B4482,$A4842004,$69C8F04A,$9E1F9B5E,$21C66842,$F6E96C9A,
    $670C9C61,$ABD388F0,$6A51A0D2,$D8542F68,$960FA728,$AB5133A3,$6EEF0B6C,$137A3BE4,
    $BA3BF050,$7EFB2A98,$A1F1651D,$39AF0176,$66CA593E,$82430E88,$8CEE8619,$456F9FB4,
    $7D84A5C3,$3B8B5EBE,$E06F75D8,$85C12073,$401A449F,$56C16AA6,$4ED3AA62,$363F7706,
    $1BFEDF72,$429B023D,$37D0D724,$D00A1248,$DB0FEAD3,$49F1C09B,$075372C9,$80991B7B,
    $25D479D8,$F6E8DEF7,$E3FE501A,$B6794C3B,$976CE0BD,$04C006BA,$C1A94FB6,$409F60C4);

  Haval_Offset: array[0..127] of Byte =
   (  5, 14, 26, 18, 11, 28,  7, 16,  0, 23, 20, 22,  1, 10,  4,  8,
     30,  3, 21,  9, 17, 24, 29,  6, 19, 12, 15, 13,  2, 25, 31, 27,
     19,  9,  4, 20, 28, 17,  8, 22, 29, 14, 25, 12, 24, 30, 16, 26,
     31, 15,  7,  3,  1,  0, 18, 27, 13,  6, 21, 10, 23, 11,  5,  2,
     24,  4,  0, 14,  2,  7, 28, 23, 26,  6, 30, 20, 18, 25, 19,  3,
     22, 11, 31, 21,  8, 27, 12,  9,  1, 29,  5, 15, 17, 10, 16, 13,
     27,  3, 21, 26, 17, 11, 20, 29, 19,  0, 12,  7, 13,  8, 31, 10,
      5,  9, 14, 30, 18,  6, 28, 24,  2, 23, 16, 22,  4,  1, 25, 15);

  Snefru_Data: array[0..15, 0..255] of LongWord = (
   ($64F9001B,$FEDDCDF6,$7C8FF1E2,$11D71514,$8B8C18D3,$DDDF881E,$6EAB5056,$88CED8E1,
    $49148959,$69C56FD5,$B7994F03,$0FBCEE3E,$3C264940,$21557E58,$E14B3FC2,$2E5CF591,
    $DCEFF8CE,$092A1648,$BE812936,$FF7B0C6A,$D5251037,$AFA448F1,$7DAFC95A,$1EA69C3F,
    $A417ABE7,$5890E423,$B0CB70C0,$C85025F7,$244D97E3,$1FF3595F,$C4EC6396,$59181E17,
    $E635B477,$354E7DBF,$796F7753,$66EB52CC,$77C3F995,$32E3A927,$80CCAED6,$4E2BE89D,
    $375BBD28,$AD1A3D05,$2B1B42B3,$16C44C71,$4D54BFA8,$E57DDC7A,$EC6D8144,$5A71046B,
    $D8229650,$87FC8F24,$CBC60E09,$B6390366,$D9F76092,$D393A70B,$1D31A08A,$9CD971C9,
    $5C1EF445,$86FAB694,$FDB44165,$8EAAFCBE,$4BCAC6EB,$FB7A94E5,$5789D04E,$FA13CF35,
    $236B8DA9,$4133F000,$6224261C,$F412F23B,$E75E56A4,$30022116,$BAF17F1F,$D09872F9,
    $C1A3699C,$F1E802AA,$0DD145DC,$4FDCE093,$8D8412F0,$6CD0F376,$3DE6B73D,$84BA737F,
    $B43A30F2,$44569F69,$00E4EACA,$B58DE3B0,$959113C8,$D62EFEE9,$90861F83,$CED69874,
    $2F793CEE,$E8571C30,$483665D1,$AB07B031,$914C844F,$15BF3BE8,$2C3F2A9A,$9EB95FD4,
    $92E7472D,$2297CC5B,$EE5F2782,$5377B562,$DB8EBBCF,$F961DEDD,$C59B5C60,$1BD3910D,
    $26D206AD,$B28514D8,$5ECF6B52,$7FEA78BB,$504879AC,$ED34A884,$36E51D3C,$1753741D,
    $8C47CAED,$9D0A40EF,$3145E221,$DA27EB70,$DF730BA3,$183C8789,$739AC0A6,$9A58DFC6,
    $54B134C1,$AC3E242E,$CC493902,$7B2DDA99,$8F15BC01,$29FD38C7,$27D5318F,$604AAFF5,
    $F29C6818,$C38AA2EC,$1019D4C3,$A8FB936E,$20ED7B39,$0B686119,$89A0906F,$1CC7829E,
    $9952EF4B,$850E9E8C,$CD063A90,$67002F8E,$CFAC8CB7,$EAA24B11,$988B4E6C,$46F066DF,
    $CA7EEC08,$C7BBA664,$831D17BD,$63F575E6,$9764350E,$47870D42,$026CA4A2,$8167D587,
    $61B6ADAB,$AA6564D2,$70DA237B,$25E1C74A,$A1C901A0,$0EB0A5DA,$7670F741,$51C05AEA,
    $933DFA32,$0759FF1A,$56010AB8,$5FDECB78,$3F32EDF8,$AEBEDBB9,$39F8326D,$D20858C5,
    $9B638BE4,$A572C80A,$28E0A19F,$432099FC,$3A37C3CD,$BF95C585,$B392C12A,$6AA707D7,
    $52F66A61,$12D483B1,$96435B5E,$3E75802B,$3BA52B33,$A99F51A5,$BDA1E157,$78C2E70C,
    $FCAE7CE0,$D1602267,$2AFFAC4D,$4A510947,$0AB2B83A,$7A04E579,$340DFD80,$B916E922,
    $E29D5E9B,$F5624AF4,$4CA9D9AF,$6BBD2CFE,$E3B7F620,$C2746E07,$5B42B9B6,$A06919BC,
    $F0F2C40F,$72217AB5,$14C19DF3,$F3802DAE,$E094BEB4,$A2101AFF,$0529575D,$55CDB27C,
    $A33BDDB2,$6528B37D,$740C05DB,$E96A62C4,$40782846,$6D30D706,$BBF48E2C,$BCE2D3DE,
    $049E37FA,$01B5E634,$2D886D8D,$7E5A2E7E,$D7412013,$06E90F97,$E45D3EBA,$B8AD3386,
    $13051B25,$0C035354,$71C89B75,$C638FBD0,$197F11A1,$EF0F08FB,$F8448651,$38409563,
    $452F4443,$5D464D55,$03D8764C,$B1B8D638,$A70BBA2F,$94B3D210,$EB6692A7,$D409C2D9,
    $68838526,$A6DB8A15,$751F6C98,$DE769A88,$C9EE4668,$1A82A373,$0896AA49,$42233681,
    $F62C55CB,$9F1C5404,$F74FB15C,$C06E4312,$6FFE5D72,$8AA8678B,$337CD129,$8211CEFD),
   ($074A1D09,$52A10E5A,$9275A3F8,$4B82506C,$37DF7E1B,$4C78B3C5,$CEFAB1DA,$F472267E,
    $B63045F6,$D66A1FC0,$400298E3,$27E60C94,$87D2F1B8,$DF9E56CC,$45CD1803,$1D35E098,
    $CCE7C736,$03483BF1,$1F7307D7,$C6E8F948,$E613C111,$3955C6FF,$1170ED7C,$8E95DA41,
    $99C31BF4,$A4DA8021,$7B5F94FB,$DD0DA51F,$6562AA77,$556BCB23,$DB1BACC6,$798040B9,
    $BFE5378F,$731D55E6,$DAA5BFEE,$389BBC60,$1B33FBA4,$9C567204,$36C26C68,$77EE9D69,
    $8AEB3E88,$2D50B5CE,$9579E790,$42B13CFC,$33FBD32B,$EE0503A7,$B5862824,$15E41EAD,
    $C8412EF7,$9D441275,$2FCEC582,$5FF483B7,$8F3931DF,$2E5D2A7B,$49467BF9,$0653DEA9,
    $2684CE35,$7E655E5C,$F12771D8,$BB15CC67,$AB097CA1,$983DCF52,$10DDF026,$21267F57,
    $2C58F6B4,$31043265,$0BAB8C01,$D5492099,$ACAAE619,$944CE54A,$F2D13D39,$ADD3FC32,
    $CDA08A40,$E2B0D451,$9EFE08AE,$B9D50FD2,$EA5CD7FD,$C9A749DD,$13EA2253,$832DEBAA,
    $24BE640F,$E03E926A,$29E01CDE,$8BF59F18,$0F9D00B6,$E1238B46,$1E7D8E34,$93619ADB,
    $76B32F9F,$BD972CEC,$E31FA976,$A68FBB10,$FB3BA49D,$8587C41D,$A5ADD1D0,$F3CF84BF,
    $D4E11150,$D9FFA6BC,$C3F6018C,$AEF10572,$74A64B2F,$E7DC9559,$2AAE35D5,$5B6F587F,
    $A9E353FE,$CA4FB674,$04BA24A8,$E5C6875F,$DCBC6266,$6BC5C03F,$661EEF02,$ED740BAB,
    $058E34E4,$B7E946CF,$88698125,$72EC48ED,$B11073A3,$A13485EB,$A2A2429C,$FA407547,
    $50B76713,$5418C37D,$96192DA5,$170BB04B,$518A021E,$B0AC13D1,$0963FA2A,$4A6E10E1,
    $58472BDC,$F7F8D962,$979139EA,$8D856538,$C0997042,$48324D7A,$447623CB,$8CBBE364,
    $6E0C6B0E,$D36D63B0,$3F244C84,$3542C971,$2B228DC1,$CB0325BB,$F8C0D6E9,$DE11066B,
    $A8649327,$FC31F83E,$7DD80406,$F916DD61,$D89F79D3,$615144C2,$EBB45D31,$28002958,
    $56890A37,$F05B3808,$123AE844,$86839E16,$914B0D83,$C506B43C,$CF3CBA5E,$7C60F5C9,
    $22DEB2A0,$5D9C2715,$C77BA0EF,$4F45360B,$C1017D8B,$E45ADC29,$A759909B,$412CD293,
    $D7D796B1,$00C8FF30,$23A34A80,$4EC15C91,$714E78B5,$47B9E42E,$78F3EA4D,$7F078F5B,
    $346C593A,$A3A87A1A,$9BCBFE12,$3D439963,$B2EF6D8E,$B8D46028,$6C2FD5CA,$62675256,
    $01F2A2F3,$BC96AE0A,$709A8920,$B4146E87,$6308B9E2,$64BDA7BA,$AFED6892,$6037F2A2,
    $F52969E0,$0ADB43A6,$82811400,$90D0BDF0,$19C9549E,$203F6A73,$1ACCAF4F,$89714E6D,
    $164D4705,$67665F07,$EC206170,$0C2182B2,$A02B9C81,$53289722,$F6A97686,$140E4179,
    $9F778849,$9A88E15D,$25CADB54,$D157F36F,$32A421C3,$B368E98A,$5A92CD0D,$757AA8D4,
    $C20AC278,$08B551C7,$849491E8,$4DC75AD6,$697C33BE,$BAF0CA33,$46125B4E,$59D677B3,
    $30D9C8F2,$D0AF860C,$1C7FD0FA,$FE0FF72C,$5C8D6F43,$57FDEC3B,$6AB6AD97,$D22ADF89,
    $18171785,$02BFE22D,$6DB80917,$80B216AF,$E85E4F9A,$7A1C306E,$6FC49BF5,$3AF7A11C,
    $81E215E7,$68363FCD,$3E9357C8,$EF52FD55,$3B8BAB4C,$3C8CF495,$BEFCEEBD,$FD25B714,
    $C498D83D,$0D2E1A8D,$E9F966AC,$0E387445,$435419E5,$5E7EBEC4,$AA90B8D9,$FF1A3A96),
   ($4A8FE4E3,$F27D99CD,$D04A40CA,$CB5FF194,$3668275A,$FF4816BE,$A78B394C,$4C6BE9DB,
    $4EEC38D2,$4296EC80,$CDCE96F8,$888C2F38,$E75508F5,$7B916414,$060AA14A,$A214F327,
    $BE608DAF,$1EBBDEC2,$61F98CE9,$E92156FE,$4F22D7A3,$3F76A8D9,$559A4B33,$38AD2959,
    $F3F17E9E,$85E1BA91,$E5EBA6FB,$73DCD48C,$F5C3FF78,$481B6058,$8A3297F7,$8F1F3BF4,
    $93785AB2,$477A4A5B,$6334EB5D,$6D251B2E,$74A9102D,$07E38FFA,$915C9C62,$CCC275EA,
    $6BE273EC,$3EBDDD70,$D895796C,$DC54A91B,$C9AFDF81,$23633F73,$275119B4,$B19F6B67,
    $50756E22,$2BB152E2,$76EA46A2,$A353E232,$2F596AD6,$0B1EDB0B,$02D3D9A4,$78B47843,
    $64893E90,$40F0CAAD,$F68D3AD7,$46FD1707,$1C9C67EF,$B5E086DE,$96EE6CA6,$9AA34774,
    $1BA4F48A,$8D01ABFD,$183EE1F6,$5FF8AA7A,$17E4FAAE,$303983B0,$6C08668B,$D4AC4382,
    $E6C5849F,$92FEFB53,$C1CAC4CE,$43501388,$441118CF,$EC4FB308,$53A08E86,$9E0FE0C5,
    $F91C1525,$AC45BE05,$D7987CB5,$49BA1487,$57938940,$D5877648,$A958727F,$58DFE3C3,
    $F436CF77,$399E4D11,$F0A5BFA9,$EF61A33B,$A64CAC60,$04A8D0BA,$030DD572,$B83D320F,
    $CAB23045,$E366F2F0,$815D008D,$C897A43A,$1D352DF3,$B9CC571D,$8BF38744,$72209092,
    $EBA124EB,$FB99CE5E,$3BB94293,$28DA549C,$AAB8A228,$A4197785,$33C70296,$25F6259B,
    $5C85DA21,$DF15BDEE,$15B7C7E8,$E2ABEF75,$FCC19BC1,$417FF868,$14884434,$62825179,
    $C6D5C11C,$0E4705DC,$22700DE0,$D3D2AF18,$9BE822A0,$35B669F1,$C42BB55C,$0A801252,
    $115BF0FC,$3CD7D856,$B43F5F9D,$C2306516,$A1231C47,$F149207E,$5209A795,$34B3CCD8,
    $67AEFE54,$2C83924E,$6662CBAC,$5EEDD161,$84E681AA,$5D57D26B,$FA465CC4,$7E3AC3A8,
    $BF7C0CC6,$E18A9AA1,$C32F0A6F,$B22CC00D,$3D280369,$994E554F,$68F480D3,$ADCFF5E6,
    $3A8EB265,$83269831,$BD568A09,$4BC8AE6A,$69F56D2B,$0F17EAC8,$772EB6C7,$9F41343C,
    $AB1D0742,$826A6F50,$FEA2097C,$1912C283,$CE185899,$E4444839,$2D8635D5,$65D0B1FF,
    $865A7F17,$326D9FB1,$59E52820,$0090ADE1,$753C7149,$9DDD8B98,$A5A691DA,$0D0382BB,
    $8904C930,$086CB000,$6E69D3BD,$24D4E7A7,$05244FD0,$101A5E0C,$6A947DCB,$E840F77B,
    $7D0C5003,$7C370F1F,$805245ED,$E05E3D3F,$7906880E,$BABFCD35,$1A7EC697,$8C052324,
    $0C6EC8DF,$D129A589,$C7A75B02,$12D81DE7,$D9BE2A66,$1F4263AB,$DE73FDB6,$2A00680A,
    $56649E36,$3133ED55,$90FA0BF2,$2910A02A,$949D9D46,$A0D1DCDD,$CFC9B7D4,$D2677BE5,
    $95CB36B3,$13CD9410,$DBF73313,$B7C6E8C0,$F781414B,$510B016D,$B0DE1157,$D6B0F62C,
    $BB074ECC,$7F1395B7,$EE792CF9,$EA6FD63E,$5BD6938E,$AF02FC64,$DAB57AB8,$8EDB3784,
    $8716318F,$164D1A01,$26F26141,$B372E6B9,$F8FC2B06,$7AC00E04,$3727B89A,$97E9BCA5,
    $9C2A742F,$BC3B1F7D,$7165B471,$609B4C29,$20925351,$5AE72112,$454BE5D1,$C0FFB95F,
    $DD0EF919,$6F2D70C9,$0974C5BF,$98AA6263,$01D91E4D,$2184BB6E,$70C43C1E,$4D435915,
    $AE7B8523,$B6FB06BC,$5431EE76,$FDBC5D26,$ED77493D,$C5712EE4,$A8380437,$2EEF261A),
   ($5A79392B,$B8AF32C2,$41F7720A,$833A61EC,$13DFEDAC,$C4990BC4,$DC0F54BC,$FEDD5E88,
    $80DA1881,$4DEA1AFD,$FD402CC6,$AE67CC7A,$C5238525,$8EA01254,$B56B9BD5,$862FBD6D,
    $AC8575D3,$6FBA3714,$DA7EBF46,$59CD5238,$8AC9DBFE,$353729FC,$E497D7F2,$C3AB84E0,
    $F05A114B,$7B887A75,$EDC603DD,$5E6FE680,$2C84B399,$884EB1DA,$1CB8C8BF,$AA51098A,
    $C862231C,$8BAC2221,$21B387E5,$208A430D,$2A3F0F8B,$A5FF9CD2,$6012A2EA,$147A9EE7,
    $F62A501D,$B4B2E51A,$3EF3484C,$C0253C59,$2B82B536,$0AA9696B,$BE0C109B,$C70B7929,
    $CE3E8A19,$2F66950E,$459F1C2C,$E68FB93D,$A3C3FF3E,$62B45C62,$300991CB,$01914C57,
    $7F7BC06A,$182831F5,$E7B74BCA,$FA50F6D0,$523CAA61,$E3A7CF05,$E9E41311,$280A21D1,
    $6A4297E1,$F24DC67E,$FC3189E6,$B72BF34F,$4B1E67AF,$543402CE,$79A59867,$0648E02A,
    $00A3AC17,$C6208D35,$6E7F5F76,$A45BB4BE,$F168FA63,$3F4125F3,$F311406F,$02706565,
    $BFE58022,$0CFCFDD9,$0735A7F7,$8F049092,$D98EDC27,$F5C5D55C,$E0F201DB,$0DCAFC9A,
    $7727FB79,$AF43ABF4,$26E938C1,$401B26A6,$900720FA,$2752D97B,$CFF1D1B3,$A9D9E424,
    $42DB99AB,$6CF8BE5F,$E82CEBE3,$3AFB733B,$6B734EB6,$1036414A,$975F667C,$049D6377,
    $BA587C60,$B1D10483,$DE1AEFCC,$1129D055,$72051E91,$6946D623,$F9E86EA7,$48768C00,
    $B0166C93,$9956BBF0,$1F1F6D84,$FB15E18E,$033B495D,$56E3362E,$4F44C53C,$747CBA51,
    $89D37872,$5D9C331B,$D2EF9FA8,$254917F8,$1B106F47,$37D75553,$B3F053B0,$7DCCD8EF,
    $D30EB802,$5889F42D,$610206D7,$1A7D34A1,$92D87DD8,$E5F4A315,$D1CF0E71,$B22DFE45,
    $B901E8EB,$0FC0CE5E,$2EFA60C9,$2DE74290,$36D0C906,$381C70E4,$4C6DA5B5,$3D81A682,
    $7E381F34,$396C4F52,$95AD5901,$1DB50C5A,$29982E9E,$1557689F,$3471EE42,$D7E2F7C0,
    $8795A1E2,$BC324D8D,$E224C3C8,$12837E39,$CDEE3D74,$7AD2143F,$0E13D40C,$78BD4A68,
    $A2EB194D,$DB9451F9,$859B71DC,$5C4F5B89,$CA14A8A4,$EF92F003,$16741D98,$33AA4444,
    $9E967FBB,$092E3020,$D86A35B8,$8CC17B10,$E1BF08AE,$55693FC5,$7680AD13,$1E6546E8,
    $23B6E7B9,$EE77A4B2,$08ED0533,$44FD2895,$B6393B69,$05D6CACF,$9819B209,$ECBBB72F,
    $9A75779C,$EAEC0749,$94A65AEE,$BDF52DC3,$D6A25D04,$82008E4E,$A6DE160F,$9B036AFB,
    $228B3A66,$5FB10A70,$CC338B58,$5378A9DF,$C908BCA9,$4959E25B,$46909A97,$66AE8F6E,
    $DD0683E9,$65F994B4,$6426CDA5,$C24B8840,$32539DA0,$63175650,$D0C815FF,$50CBC41E,
    $F7C774A3,$31B0C231,$8D0D8116,$24BEF16C,$D555D256,$DF47EA8C,$6D21ECCD,$A887A012,
    $84542AED,$A7B9C1BD,$914C1BB1,$A0D5B67D,$438CE937,$7030F873,$71F6B0C7,$574576BA,
    $F8BC4541,$9C61D348,$1960579D,$17C4DAAD,$96A4CB0B,$C193F2F6,$756EAFA2,$7C1D2F94,
    $F4FE2B43,$CB86E33A,$EBD4C728,$9D18AE64,$9FE13E30,$3CE0F5DE,$ABA1F985,$ADDC2718,
    $68CE6278,$D45E241F,$A15C82B7,$3B2293D4,$739EDD32,$674A6BF1,$5B5D587F,$4772DEAA,
    $4A63968F,$0BE68686,$513D6426,$939A4787,$BBA89296,$4EC20007,$818D0D08,$FF64DFD6),
   ($CB2297CB,$DB48A144,$A16CBE4B,$BBEA1D6C,$5AF6B6B7,$8A8110B6,$F9236EF9,$C98F83E6,
    $0F9C65B8,$252D4A89,$A497F068,$A5D7ED2D,$94C22845,$9DA1C8C4,$E27C2E2E,$6E8BA2B4,
    $C3DD17FB,$498CD482,$0DFE6A9F,$B0705829,$9A1E6DC1,$F829717C,$07BB8E3A,$DA3C0B02,
    $1AF82FC7,$73B70955,$7A04379C,$5EE20A28,$83712AE5,$F4C47C6D,$DF72BA56,$D794858D,
    $8C0CF709,$18F0F390,$B6C69B35,$BF2F01DB,$2FA74DCA,$D0CD9127,$BDE66CEC,$3DEEBD46,
    $57C88FC3,$CEE1406F,$0066385A,$F3C3444F,$3A79D5D5,$75751EB9,$3E7F8185,$521C2605,
    $E1AAAB6E,$38EBB80F,$BEE7E904,$61CB9647,$EA54904E,$05AE00E4,$2D7AC65F,$087751A1,
    $DCD82915,$0921EE16,$DD86D33B,$D6BD491A,$40FBADF0,$4232CBD2,$33808D10,$39098C42,
    $193F3199,$0BC1E47A,$4A82B149,$02B65A8A,$104CDC8E,$24A8F52C,$685C6077,$C79F95C9,
    $1D11FE50,$C08DAFCD,$7B1A9A03,$1C1F11D8,$84250E7F,$979DB248,$EBDC0501,$B9553395,
    $E3C05EA8,$B1E51C4C,$13B0E681,$3B407766,$36DB3087,$EE17C9FC,$6C53ECF2,$ADCCC58F,
    $C427660B,$EFD5867D,$9B6D54A5,$6FF1AEFF,$8E787952,$9E2BFFE0,$8761D034,$E00BDBAD,
    $AE99A8D3,$CC03F6E2,$FD0ED807,$0E508AE3,$B74182AB,$4349245D,$D120A465,$B246A641,
    $AF3B7AB0,$2A6488BB,$4B3A0D1F,$E7C7E58C,$3FAFF2EB,$90445FFD,$CF38C393,$995D07E7,
    $F24F1B36,$356F6891,$6D6EBCBE,$8DA9E262,$50FD520E,$5BCA9E1E,$37472CF3,$69075057,
    $7EC5FDED,$0CAB892A,$FB2412BA,$1728DEBF,$A000A988,$D843CE79,$042E20DD,$4FE8F853,
    $56659C3C,$2739D119,$A78A6120,$80960375,$70420611,$85E09F78,$ABD17E96,$1B513EAF,
    $1E01EB63,$26AD2133,$A890C094,$7613CF60,$817E781B,$A39113D7,$E957FA58,$4131B99E,
    $28B1EFDA,$66ACFBA7,$FF68944A,$77A44FD1,$7F331522,$59FFB3FA,$A6DF935B,$FA12D9DF,
    $C6BF6F3F,$89520CF6,$659EDD6A,$544DA739,$8B052538,$7C30EA21,$C2345525,$15927FB2,
    $144A436B,$BA107B8B,$1219AC97,$06730432,$31831AB3,$C55A5C24,$AA0FCD3E,$E5606BE8,
    $5C88F19B,$4C0841EE,$1FE37267,$11F9C4F4,$9F1B9DAE,$864E76D0,$E637C731,$D97D23A6,
    $32F53D5C,$B8161980,$93FA0F84,$CAEF0870,$8874487E,$98F2CC73,$645FB5C6,$CD853659,
    $2062470D,$16EDE8E9,$6B06DAB5,$78B43900,$FC95B786,$5D8E7DE1,$465B5954,$FE7BA014,
    $F7D23F7B,$92BC8B18,$03593592,$55CEF4F7,$74B27317,$79DE1FC2,$C8A0BFBD,$229398CC,
    $62A602CE,$BCB94661,$5336D206,$D2A375FE,$6A6AB483,$4702A5A4,$A2E9D73D,$23A2E0F1,
    $9189140A,$581D18DC,$B39A922B,$82356212,$D5F432A9,$D356C2A3,$5F765B4D,$450AFCC8,
    $4415E137,$E8ECDFBC,$ED0DE3EA,$60D42B13,$F13DF971,$71FC5DA2,$C1455340,$F087742F,
    $F55E5751,$67B3C1F8,$AC6B8774,$7DCFAAAC,$95983BC0,$489BB0B1,$2C184223,$964B6726,
    $2BD3271C,$72266472,$DED64530,$0A2AA343,$D4F716A0,$B4DAD6D9,$2184345E,$512C990C,
    $29D92D08,$2EBE709A,$01144C69,$34584B9D,$E4634ED6,$ECC963CF,$3C6984AA,$4ED056EF,
    $9CA56976,$8F3E80D4,$B5BAE7C5,$30B5CAF5,$63F33A64,$A9E4BBDE,$F6B82298,$4D673C1D),
   ($4B4F1121,$BA183081,$C784F41F,$D17D0BAC,$083D2267,$37B1361E,$3581AD05,$FDA2F6BC,
    $1E892CDD,$B56D3C3A,$32140E46,$138D8AAB,$E14773D4,$5B0E71DF,$5D1FE055,$3FB991D3,
    $F1F46C71,$A325988C,$10F66E80,$B1006348,$726A9F60,$3B67F8BA,$4E114EF4,$05C52115,
    $4C5CA11C,$99E1EFD8,$471B83B3,$CBF7E524,$43AD82F5,$690CA93B,$FAA61BB2,$12A832B5,
    $B734F943,$BD22AEA7,$88FEC626,$5E80C3E7,$BE3EAF5E,$44617652,$A5724475,$BB3B9695,
    $7F3FEE8F,$964E7DEB,$518C052D,$2A0BBC2B,$C2175F5C,$9A7B3889,$A70D8D0C,$EACCDD29,
    $CCCD6658,$34BB25E6,$B8391090,$F651356F,$52987C9E,$0C16C1CD,$8E372D3C,$2FC6EBBD,
    $6E5DA3E3,$B0E27239,$5F685738,$45411786,$067F65F8,$61778B40,$81AB2E65,$14C8F0F9,
    $A6B7B4CE,$4036EAEC,$BF62B00A,$ECFD5E02,$045449A6,$B20AFD28,$2166D273,$0D13A863,
    $89508756,$D51A7530,$2D653F7A,$3CDBDBC3,$80C9DF4F,$3D5812D9,$53FBB1F3,$C0F185C0,
    $7A3C3D7E,$68646410,$857607A0,$1D12622E,$97F33466,$DB4C9917,$6469607C,$566E043D,
    $79EF1EDB,$2C05898D,$C9578E25,$CD380101,$46E04377,$7D1CC7A9,$6552B837,$20192608,
    $B97500C5,$ED296B44,$368648B4,$62995CD5,$82731400,$F9AEBD8B,$3844C0C7,$7C2DE794,
    $33A1A770,$8AE528C2,$5A2BE812,$1F8F4A07,$2B5ED7CA,$937EB564,$6FDA7E11,$E49B5D6C,
    $B4B3244E,$18AA53A4,$3A061334,$4D6067A3,$83BA5868,$9BDF4DFE,$7449F261,$709F8450,
    $CAD133CB,$DE941C3F,$F52AE484,$781D77ED,$7E4395F0,$AE103B59,$922331BB,$42CE50C8,
    $E6F08153,$E7D941D0,$5028ED6B,$B3D2C49B,$AD4D9C3E,$D201FB6E,$A45BD5BE,$FFCB7F4B,
    $579D7806,$F821BB5B,$59D592AD,$D0BE0C31,$D4E3B676,$0107165A,$0FE939D2,$49BCAAFD,
    $55FFCFE5,$2EC1F783,$F39A09A5,$3EB42772,$19B55A5D,$024A0679,$8C83B3F7,$8642BA1D,
    $ACACD9EA,$87D352C4,$60931F45,$A05F97D7,$1CECD42C,$E2FCC87B,$B60F94E2,$67A34B0B,
    $FCDD40C9,$0B150A27,$D3EE9E04,$582E29E9,$4AC22B41,$6AC4E1B8,$BCCAA51A,$237AF30E,
    $EBC3B709,$C4A59D19,$284BC98A,$E9D41A93,$6BFA2018,$73B2D651,$11F9A2FA,$CE09BFF1,
    $41A470AA,$25888F22,$77E754E8,$F7330D8E,$158EAB16,$C5D68842,$C685A6F6,$E5B82FDE,
    $09EA3A96,$6DDE1536,$4FA919DA,$26C0BE9F,$9EED6F69,$F05555F2,$E06FC285,$9CD76D23,
    $AF452A92,$EFC74CB7,$9D6B4732,$8BE408EE,$22401D0D,$EE6C459D,$7587CB82,$E8746862,
    $5CBDDE87,$98794278,$31AFB94D,$C11E0F2F,$30E8FC2A,$CF3261EF,$1A3023E1,$AA2F86CF,
    $F202E24A,$8D08DCFF,$764837C6,$A26374CC,$9F7C3E88,$949CC57D,$DD26A07F,$C39EFAB0,
    $C8F879A1,$DCE67BB9,$F4B0A435,$912C9AE0,$D85603E4,$953A9BBF,$FB8290D6,$0AEBCD5F,
    $16206A9A,$6C787A14,$D9A0F16A,$29BF4F74,$8F8BCE91,$0E5A9354,$AB038CB1,$1B8AD11B,
    $E327FF49,$0053DA20,$90CF51DC,$DA92FE6D,$0390CA47,$A8958097,$A9DC5BAF,$3931E3C1,
    $840446B6,$63D069FB,$D7460299,$7124ECD1,$0791E613,$485918FC,$D635D04C,$DF96AC33,
    $66F2D303,$247056AE,$A1A7B2A8,$27D8CC9C,$17B6E998,$7BF5590F,$FE97F557,$5471D8A2),
   ($83A327A1,$9F379F51,$40A7D007,$11307423,$224587C1,$AC27D63B,$3B7E64EA,$2E1CBFA6,
    $09996000,$03BC0E2C,$D4C4478A,$4542E0AB,$FEDA26D4,$C1D10FCB,$8252F596,$4494EB5C,
    $A362F314,$F5BA81FD,$75C3A376,$4CA214CA,$E164DEDD,$5088FA97,$4B0930E0,$2FCFB7E8,
    $33A6F4B2,$C7E94211,$2D66C774,$43BE8BAE,$C663D445,$908EB130,$F4E3BE15,$63B9D566,
    $529396B5,$1E1BE743,$4D5FF63F,$985E4A83,$71AB9DF7,$C516C6F5,$85C19AB4,$1F4DAEE4,
    $F2973431,$B713DC5E,$3F2E159A,$C824DA16,$06BF376A,$B2FE23EC,$E39B1C22,$F1EECB5F,
    $08E82D52,$565686C2,$AB0AEA93,$FD47219F,$EBDBABD7,$2404A185,$8C7312B9,$A8F2D828,
    $0C8902DA,$65B42B63,$C0BBEF62,$4E3E4CEF,$788F8018,$EE1EBAB7,$93928F9D,$683D2903,
    $D3B60689,$AFCB0DDC,$88A4C47A,$F6DD9C3D,$7EA5FCA0,$8A6D7244,$BE11F120,$04FF91B8,
    $8D2DC8C0,$27F97FDB,$7F9E1F47,$1734F0C7,$26F3ED8E,$0DF8F2BF,$B0833D9E,$E420A4E5,
    $A423CAE6,$95616772,$9AE6C049,$075941F2,$D8E12812,$000F6F4F,$3C0D6B05,$6CEF921C,
    $B82BC264,$396CB008,$5D608A6F,$6D7782C8,$186550AA,$6B6FEC09,$28E70B13,$57CE5688,
    $ECD3AF84,$23335A95,$91F40CD2,$7B6A3B26,$BD32B3B6,$3754A6FB,$8ED088F0,$F867E87C,
    $20851746,$6410F9C6,$35380442,$C2CA10A7,$1ADEA27F,$76BDDD79,$92742CF4,$0E98F7EE,
    $164E931D,$B9C835B3,$69060A99,$B44C531E,$FA7B66FE,$C98A5B53,$7D95AAE9,$302F467B,
    $74B811DE,$F3866ABD,$B5B3D32D,$FC3157A4,$D251FE19,$0B5D8EAC,$DA71FFD5,$47EA05A3,
    $05C6A9E1,$CA0EE958,$9939034D,$25DC5EDF,$79083CB1,$86768450,$CF757D6D,$5972B6BC,
    $A78D59C9,$C4AD8D41,$2A362AD3,$D1179991,$601407FF,$DCF50917,$587069D0,$E0821ED6,
    $DBB59427,$73911A4B,$7C904FC3,$844AFB92,$6F8C955D,$E8C0C5BB,$B67AB987,$A529D96C,
    $F91F7181,$618B1B06,$E718BB0C,$8BD7615B,$D5A93A59,$54AEF81B,$772136E3,$CE44FD9C,
    $10CDA57E,$87D66E0B,$3D798967,$1B2C1804,$3EDFBD68,$15F6E62B,$EF68B854,$3896DB35,
    $12B7B5E2,$CB489029,$9E4F98A5,$62EB77A8,$217C24A2,$964152F6,$49B2080A,$53D23EE7,
    $48FB6D69,$1903D190,$9449E494,$BF6E7886,$FB356CFA,$3A261365,$424BC1EB,$A1192570,
    $019CA782,$9D3F7E0E,$9C127575,$EDF02039,$AD57BCCE,$5C153277,$81A84540,$BCAA7356,
    $CCD59B60,$A62A629B,$A25CCD10,$2B5B65CF,$1C535832,$55FD4E3A,$31D9790D,$F06BC37D,
    $4AFC1D71,$AEED5533,$BA461634,$BB694B78,$5F3A5C73,$6A3C764A,$8FB0CCA9,$F725684C,
    $4FE5382F,$1D0163AF,$5AA07A8F,$E205A8ED,$C30BAD38,$FF22CF1F,$72432E2E,$32C2518B,
    $3487CE4E,$7AE0AC02,$709FA098,$0A3B395A,$5B4043F8,$A9E48C36,$149A8521,$D07DEE6B,
    $46ACD2F3,$8958DFFC,$B3A1223C,$B11D31C4,$CD7F4D3E,$0F28E3AD,$E5B100BE,$AAC54824,
    $E9C9D7BA,$9BD47001,$80F149B0,$66022F0F,$020C4048,$6EFA192A,$67073F8D,$13EC7BF9,
    $3655011A,$E6AFE157,$D9845F6E,$DECC4425,$511AE2CC,$DF81B4D8,$D7809E55,$D6D883D9,
    $2CC7978C,$5E787CC5,$DD0033D1,$A050C937,$97F75DCD,$299DE580,$41E2B261,$EA5A54F1),
   ($7E672590,$BEA513BB,$2C906FE6,$86029C2B,$55DC4F74,$0553398E,$63E09647,$CAFD0BAB,
    $264C37DF,$8272210F,$67AFA669,$12D98A5F,$8CAB23C4,$75C68BD1,$C3370470,$33F37F4E,
    $283992FF,$E73A3A67,$1032F283,$F5AD9FC2,$963F0C5D,$664FBC45,$202BA41C,$C7C02D80,
    $54731E84,$8A1085F5,$601D80FB,$2F968E55,$35E96812,$E45A8F78,$BD7DE662,$3B6E6EAD,
    $8097C5EF,$070B6781,$B1E508F3,$24E4FAE3,$B81A7805,$EC0FC918,$43C8774B,$9B2512A9,
    $2B05AD04,$32C2536F,$EDF236E0,$8BC4B0CF,$BACEB837,$4535B289,$0D0E94C3,$A5A371D0,
    $AD695A58,$39E3437D,$9186BFFC,$21038C3B,$0AA9DFF9,$5D1F06CE,$62DEF8A4,$F740A2B4,
    $A2575868,$682683C1,$DBB30FAC,$61FE1928,$468A6511,$C61CD5F4,$E54D9800,$6B98D7F7,
    $8418B6A5,$5F09A5D2,$90B4E80B,$49B2C852,$69F11C77,$17412B7E,$7F6FC0ED,$56838DCC,
    $6E9546A2,$D0758619,$087B9B9A,$D231A01D,$AF46D415,$097060FD,$D920F657,$882D3F9F,
    $3AE7C3C9,$E8A00D9B,$4FE67EBE,$2EF80EB2,$C1916B0C,$F4DFFEA0,$B97EB3EB,$FDFF84DD,
    $FF8B14F1,$E96B0572,$F64B508C,$AE220A6E,$4423AE5A,$C2BECE5E,$DE27567C,$FC935C63,
    $47075573,$E65B27F0,$E121FD22,$F2668753,$2DEBF5D7,$8347E08D,$AC5EDA03,$2A7CEBE9,
    $3FE8D92E,$23542FE4,$1FA7BD50,$CF9B4102,$9D0DBA39,$9CB8902A,$A7249D8B,$0F6D667A,
    $5EBFA9EC,$6A594DF2,$79600938,$023B7591,$EA2C79C8,$C99D07EA,$64CB5EE1,$1A9CAB3D,
    $76DB9527,$C08E012F,$3DFB481A,$872F22E7,$2948D15C,$A4782C79,$6F50D232,$78F0728A,
    $5A87AAB1,$C4E2C19C,$EE767387,$1B2A1864,$7B8D10D3,$D1713161,$0EEAC456,$D8799E06,
    $B645B548,$4043CB65,$A874FB29,$4B12D030,$7D687413,$18EF9A1F,$D7631D4C,$5829C7DA,
    $CDFA30FA,$C5084BB0,$92CD20E2,$D4C16940,$03283EC0,$A917813F,$9A587D01,$70041F8F,
    $DC6AB1DC,$DDAEE3D5,$31829742,$198C022D,$1C9EAFCB,$5BBC6C49,$D3D3293A,$16D50007,
    $04BB8820,$3C5C2A41,$37EE7AF8,$8EB04025,$9313ECBA,$BFFC4799,$8955A744,$EF85D633,
    $504499A7,$A6CA6A86,$BB3D3297,$B34A8236,$6DCCBE4F,$06143394,$CE19FC7B,$CCC3C6C6,
    $E36254AE,$77B7EDA1,$A133DD9E,$EBF9356A,$513CCF88,$E2A1B417,$972EE5BD,$853824CD,
    $5752F4EE,$6C1142E8,$3EA4F309,$B2B5934A,$DFD628AA,$59ACEA3E,$A01EB92C,$389964BC,
    $DA305DD4,$019A59B7,$11D2CA93,$FAA6D3B9,$4E772ECA,$72651776,$FB4E5B0E,$A38F91A8,
    $1D0663B5,$30F4F192,$B50051B6,$B716CCB3,$4ABD1B59,$146C5F26,$F134E2DE,$00F67C6C,
    $B0E1B795,$98AA4EC7,$0CC73B34,$654276A3,$8D1BA871,$740A5216,$E0D01A23,$9ED161D6,
    $9F36A324,$993EBB7F,$FEB9491B,$365DDCDB,$810CFFC5,$71EC0382,$2249E7BF,$48817046,
    $F3A24A5B,$4288E4D9,$0BF5C243,$257FE151,$95B64C0D,$4164F066,$AAF7DB08,$73B1119D,
    $8F9F7BB8,$D6844596,$F07A34A6,$53943D0A,$F9DD166D,$7A8957AF,$F8BA3CE5,$27C9621E,
    $5CDAE910,$C8518998,$941538FE,$136115D8,$ABA8443C,$4D01F931,$34EDF760,$B45F266B,
    $D5D4DE14,$52D8AC35,$15CFD885,$CBC5CD21,$4CD76D4D,$7C80EF54,$BC92EE75,$1E56A1F6),
   ($BAA20B6C,$9FFBAD26,$E1F7D738,$794AEC8D,$C9E9CF3C,$8A9A7846,$C57C4685,$B9A92FED,
    $29CB141F,$52F9DDB7,$F68BA6BC,$19CCC020,$4F584AAA,$3BF6A596,$003B7CF7,$54F0CE9A,
    $A7EC4303,$46CF0077,$78D33AA1,$215247D9,$74BCDF91,$08381D30,$DAC43E40,$64872531,
    $0BEFFE5F,$B317F457,$AEBB12DA,$D5D0D67B,$7D75C6B4,$42A6D241,$1502D0A9,$3FD97FFF,
    $C6C3ED28,$81868D0A,$92628BC5,$86679544,$FD1867AF,$5CA3EA61,$568D5578,$4A2D71F4,
    $43C9D549,$8D95DE2B,$6E5C74A0,$9120FFC7,$0D05D14A,$A93049D3,$BFA80E17,$F4096810,
    $043F5EF5,$A673B4F1,$6D780298,$A4847783,$5EE726FB,$9934C281,$220A588C,$384E240F,
    $933D5C69,$39E5EF47,$26E8B8F3,$4C1C6212,$8040F75D,$074B7093,$6625A8D7,$36298945,
    $76285088,$651D37C3,$24F5274D,$DBCA3DAB,$186B7EE1,$D80F8182,$14210C89,$943A3075,
    $4E6E11C4,$4D7E6BAD,$F05064C8,$025DCD97,$4BC10302,$7CEDE572,$8F90A970,$AB88EEBA,
    $B5998029,$5124D839,$B0EEB6A3,$89DDABDC,$E8074D76,$A1465223,$32518CF2,$9D39D4EB,
    $C0D84524,$E35E6EA8,$7ABF3804,$113E2348,$9AE6069D,$B4DFDABB,$A8C5313F,$23EA3F79,
    $530E36A2,$A5FD228B,$95D1D350,$2B14CC09,$40042956,$879D05CC,$2064B9CA,$ACACA40E,
    $B29C846E,$9676C9E3,$752B7B8A,$7BE2BCC2,$6BD58F5E,$D48F4C32,$606835E4,$9CD7C364,
    $2C269B7A,$3A0D079C,$73B683FE,$45374F1E,$10AFA242,$577F8666,$DDAA10F6,$F34F561C,
    $3D355D6B,$E47048AE,$AA13C492,$050344FD,$2AAB5151,$F5B26AE5,$ED919A59,$5AC67900,
    $F1CDE380,$0C79A11B,$351533FC,$CD4D8E36,$1F856005,$690B9FDD,$E736DCCF,$1D47BF6A,
    $7F66C72A,$85F21B7F,$983CBDB6,$01EBBEBF,$035F3B99,$EB111F34,$28CEFDC6,$5BFC9ECD,
    $F22EACB0,$9E41CBB2,$E0F8327C,$82E3E26F,$FC43FC86,$D0BA66DF,$489EF2A7,$D9E0C81D,
    $68690D52,$CC451367,$C2232E16,$E95A7335,$0FDAE19B,$FF5B962C,$97596527,$C46DB333,
    $3ED4C562,$C14C9D9E,$5D6FAA21,$638E940D,$F9316D58,$47B3B0EA,$30FFCAD2,$CE1BBA7D,
    $1E6108E6,$2E1EA33D,$507BF05B,$FAFEF94B,$D17DE8E2,$5598B214,$1663F813,$17D25A2D,
    $EEFA5FF9,$582F4E37,$12128773,$FEF17AB8,$06005322,$BB32BBC9,$8C898508,$592C15F0,
    $D38A4054,$4957B7D6,$D2B891DB,$37BD2D3E,$34AD20CB,$622288E9,$2DC7345A,$AFB416C0,
    $1CF459B1,$DC7739FA,$0A711A25,$13E18A0C,$5F72AF4C,$6AC8DB11,$BE53C18E,$1AA569B9,
    $EF551EA4,$A02A429F,$BD16E790,$7EB9171A,$77D693D8,$8E06993A,$9BDE7560,$E5801987,
    $C37A09BE,$B8DB76AC,$E2087294,$6C81616D,$B7F30FE7,$BC9B82BD,$FBA4E4D4,$C7B1012F,
    $A20C043B,$DE9FEBD0,$2F9297CE,$E610AEF8,$70B06F19,$C86AE00B,$0E01988F,$41192AE0,
    $448C1CB5,$ADBE92EE,$7293A007,$1B54B5B3,$D61F63D1,$EAE40A74,$61A72B55,$EC83A7D5,
    $88942806,$90A07DA5,$D7424B95,$67745B4E,$A31A1853,$CA6021EF,$DFB56C4F,$CBC2D915,
    $3C48E918,$8BAE3C63,$6F659C71,$F8B754C1,$2782F3DE,$F796F168,$71492C84,$33C0F5A6,
    $3144F6EC,$25DC412E,$B16C5743,$83A1FA7E,$0997B101,$B627E6E8,$CF33905C,$8456FB65),
   ($B29BEA74,$C35DA605,$305C1CA3,$D2E9F5BC,$6FD5BFF4,$FF347703,$FC45B163,$F498E068,
    $B71229FC,$81ACC3FB,$78538A8B,$984ECF81,$A5DA47A4,$8F259EEF,$6475DC65,$081865B9,
    $49E14A3C,$19E66079,$D382E91B,$5B109794,$3F9F81E1,$4470A388,$41601ABE,$AAF9F407,
    $8E175EF6,$ED842297,$893A4271,$1790839A,$D566A99E,$6B417DEE,$75C90D23,$715EDB31,
    $723553F7,$9AFB50C9,$FBC5F600,$CD3B6A4E,$97ED0FBA,$29689AEC,$63135C8E,$F0E26C7E,
    $0692AE7F,$DBB208FF,$2EDE3E9B,$6A65BEBD,$D40867E9,$C954AFC5,$73B08201,$7FFDF809,
    $1195C24F,$1CA5ADCA,$74BD6D1F,$B393C455,$CADFD3FA,$99F13011,$0EBCA813,$60E791B8,
    $6597AC7A,$18A7E46B,$09CB49D3,$0B27DF6D,$CFE52F87,$CEF66837,$E6328035,$FA87C592,
    $37BAFF93,$D71FCC99,$DCAB205C,$4D7A5638,$48012510,$62797558,$B6CF1FE5,$BC311834,
    $9C2373AC,$14EC6175,$A439CBDF,$54AFB0EA,$D686960B,$FDD0D47B,$7B063902,$8B78BAC3,
    $26C6A4D5,$5C0055B6,$2376102E,$0411783E,$2AA3F1CD,$51FC6EA8,$701CE243,$9B2A0ABB,
    $0AD93733,$6E80D03D,$AF6295D1,$F629896F,$A30B0648,$463D8DD4,$963F84CB,$01FF94F8,
    $8D7FEFDC,$553611C0,$A97C1719,$B96AF759,$E0E3C95E,$0528335B,$21FE5925,$821A5245,
    $807238B1,$67F23DB5,$EA6B4EAB,$0DA6F985,$AB1BC85A,$EF8C90E4,$4526230E,$38EB8B1C,
    $1B91CD91,$9FCE5F0C,$F72CC72B,$C64F2617,$DAF7857D,$7D373CF1,$28EAEDD7,$203887D0,
    $C49A155F,$A251B3B0,$F2D47AE3,$3D9EF267,$4A94AB2F,$7755A222,$0205E329,$C28FA7A7,
    $AEC1FE51,$270F164C,$8C6D01BF,$53B5BC98,$C09D3FEB,$834986CC,$4309A12C,$578B2A96,
    $3BB74B86,$69561B4A,$037E32F3,$DE335B08,$C5156BE0,$E7EF09AD,$93B834C7,$A7719352,
    $59302821,$E3529D26,$F961DA76,$CB142C44,$A0F3B98D,$76502457,$945A414B,$078EEB12,
    $DFF8DE69,$EB6C8C2D,$BDA90C4D,$E9C44D16,$168DFD66,$AD64763B,$A65FD764,$95A29C06,
    $32D7713F,$40F0B277,$224AF08F,$004CB5E8,$92574814,$8877D827,$3E5B2D04,$68C2D5F2,
    $86966273,$1D433ADA,$8774988A,$3C0E0BFE,$DDAD581D,$2FD654ED,$0F4769FD,$C181EE9D,
    $5FD88F61,$341DBB3A,$528543F9,$D92235CF,$1EA82EB4,$B5CD790F,$91D24F1E,$A869E6C2,
    $61F474D2,$CC205ADD,$0C7BFBA9,$BF2B0489,$B02D72D8,$2B46ECE6,$E4DCD90A,$B8A11440,
    $EE8A63B7,$854DD1A1,$D1E00583,$42B40E24,$9E8964DE,$B4B35D78,$BEC76F6E,$24B9C620,
    $D8D399A6,$5ADB2190,$2DB12730,$3A5866AF,$58C8FADB,$5D8844E7,$8A4BF380,$15A01D70,
    $79F5C028,$66BE3B8C,$F3E42B53,$56990039,$2C0C3182,$5E16407C,$ECC04515,$6C440284,
    $4CB6701A,$13BFC142,$9D039F6A,$4F6E92C8,$A1407C62,$8483A095,$C70AE1C4,$E20213A2,
    $BACAFC41,$4ECC12B3,$4BEE3646,$1FE807AE,$25217F9C,$35DDE5F5,$7A7DD6CE,$F89CCE50,
    $AC07B718,$7E73D2C6,$E563E76C,$123CA536,$3948CA56,$9019DD49,$10AA88D9,$C82451E2,
    $473EB6D6,$506FE854,$E8BB03A5,$332F4C32,$FE1E1E72,$B1AE572A,$7C0D7BC1,$E1C37EB2,
    $F542AA60,$F1A48EA0,$D067B89F,$BBFA195D,$1A049B0D,$315946AA,$36D1B447,$6D2EBDF0),
   ($0D188A6D,$12CEA0DB,$7E63740E,$6A444821,$253D234F,$6FFC6597,$94A6BDEF,$33EE1B2F,
    $0A6C00C0,$3AA336B1,$5AF55D17,$265FB3DC,$0E89CF4D,$0786B008,$C80055B8,$6B17C3CE,
    $72B05A74,$D21A8D78,$A6B70840,$FE8EAE77,$ED69565C,$55E1BCF4,$585C2F60,$E06F1A62,
    $AD67C0CD,$7712AF88,$9CC26ACA,$1888053D,$37EB853E,$9215ABD7,$DE30ADFC,$1F1038E6,
    $70C51C8A,$8D586C26,$F72BDD90,$4DC3CE15,$68EAEEFA,$D0E9C8B9,$200F9C44,$DDD141BA,
    $024BF1D3,$0F64C9D4,$C421E9E9,$9D11C14C,$9A0DD9E4,$5F92EC19,$1B980DF0,$1DCC4542,
    $B8FE8C56,$0C9C9167,$4E81EB49,$CA368F27,$E3603B37,$EA08ACCC,$AC516992,$C34F513B,
    $804D100D,$6EDCA4C4,$FC912939,$29D219B0,$278AAA3C,$4868DA7D,$54E890B7,$B46D735A,
    $514589AA,$D6C630AF,$4980DFE8,$BE3CCC55,$59D41202,$650C078B,$AF3A9E7B,$3ED9827A,
    $9E79FC6E,$AADBFBAE,$C5F7D803,$3DAF7F50,$67B4F465,$73406E11,$39313F8C,$8A6E6686,
    $D8075F1F,$D3CBFED1,$69C7E49C,$930581E0,$E4B1A5A8,$BBC45472,$09DDBF58,$C91D687E,
    $BDBFFDA5,$88C08735,$E9E36BF9,$DB5EA9B6,$95559404,$08F432FB,$E24EA281,$64663579,
    $000B8010,$7914E7D5,$32FD0473,$D1A7F0A4,$445AB98E,$EC72993F,$A29A4D32,$B77306D8,
    $C7C97CF6,$7B6AB645,$F5EF7ADF,$FB2E15F7,$E747F757,$5E944354,$234A2669,$47E46359,
    $9B9D11A9,$40762CED,$56F1DE98,$11334668,$890A9A70,$1A296113,$B3BD4AF5,$163B7548,
    $D51B4F84,$B99B2ABC,$3CC1DC30,$A9F0B56C,$812272B2,$0B233A5F,$B650DBF2,$F1A0771B,
    $36562B76,$DC037B0F,$104C97FF,$C2EC98D2,$90596F22,$28B6620B,$DF42B212,$FDBC4243,
    $F3FB175E,$4A2D8B00,$E8F3869B,$30D69BC3,$853714C8,$A7751D2E,$31E56DEA,$D4840B0C,
    $9685D783,$068C9333,$8FBA032C,$76D7BB47,$6D0EE22B,$B546794B,$D971B894,$8B09D253,
    $A0AD5761,$EE77BA06,$46359F31,$577CC7EC,$52825EFD,$A4BEED95,$9825C52A,$EB48029A,
    $BAAE59F8,$CF490EE1,$BC990164,$8CA49DFE,$4F38A6E7,$2BA98389,$8228F538,$199F64AC,
    $01A1CAC5,$A8B51641,$5CE72D01,$8E5DF26B,$60F28E1E,$CD5BE125,$E5B376BF,$1C8D3116,
    $7132CBB3,$CB7AE320,$C0FA5366,$D7653E34,$971C88C2,$C62C7DD0,$34D0A3DA,$868F6709,
    $7AE6FA8F,$22BBD523,$66CD3D5B,$1EF9288D,$F9CF58C1,$5B784E80,$7439A191,$AE134C36,
    $9116C463,$2E9E1396,$F8611F3A,$2D2F3307,$247F37DD,$C1E2FF9D,$43C821E5,$05ED5CAB,
    $EF74E80A,$4CCA6028,$F0AC3CBD,$5D874B29,$6C62F6A6,$4B2A2EF3,$B1AA2087,$62A5D0A3,
    $0327221C,$B096B4C6,$417EC693,$ABA840D6,$789725EB,$F4B9E02D,$E6E00975,$CC04961A,
    $63F624BB,$7FA21ECB,$2C01EA7F,$B2415005,$2A8BBEB5,$83B2B14E,$A383D1A7,$5352F96A,
    $043ECDAD,$CE1918A1,$FA6BE6C9,$50DEF36F,$F6B80CE2,$4543EF7C,$9953D651,$F257955D,
    $87244914,$DA1E0A24,$FFDA4785,$14D327A2,$3B93C29F,$840684B4,$61AB71A0,$9F7B784A,
    $2FD570CF,$15955BDE,$38F8D471,$3534A718,$133FB71D,$3FD80F52,$4290A8BE,$75FF44C7,
    $A554E546,$E1023499,$BF2652E3,$7D20399E,$A1DF7E82,$177092EE,$217DD3F1,$7C1FF8D9),
   ($12113F2E,$BFBD0785,$F11793FB,$A5BFF566,$83C7B0E5,$72FB316B,$75526A9A,$41E0E612,
    $7156BA09,$53CE7DEE,$0AA26881,$A43E0D7D,$3DA73CA3,$182761ED,$BD5077FF,$56DB4AA0,
    $E792711C,$F0A4EB1D,$7F878237,$EC65C4E8,$08DC8D43,$0F8CE142,$8258ABDA,$F4154E16,
    $49DEC2FD,$CD8D5705,$6C2C3A0F,$5C12BB88,$EFF3CDB6,$2C89ED8C,$7BEBA967,$2A142157,
    $C6D0836F,$B4F97E96,$6931E969,$514E6C7C,$A7792600,$0BBBF780,$59671BBD,$0707B676,
    $37482D93,$80AF1479,$3805A60D,$E1F4CAC1,$580B3074,$30B8D6CE,$05A304BE,$D176626D,
    $EBCA97F3,$BB201F11,$6A1AFE23,$FFAA86E4,$62B4DA49,$1B6629F5,$F5D9E092,$F37F3DD1,
    $619BD45B,$A6EC8E4F,$29C80939,$0C7C0C34,$9CFE6E48,$E65FD3AC,$73613B65,$B3C669F9,
    $BE2E8A9E,$286F9678,$5797FD13,$99805D75,$CFB641C5,$A91074BA,$6343AF47,$6403CB46,
    $8894C8DB,$2663034C,$3C40DC5E,$00995231,$96789AA2,$2EFDE4B9,$7DC195E1,$547DADD5,
    $06A8EA04,$F2347A63,$5E0DC6F7,$8462DFC2,$1E6B2C3C,$9BD275B3,$91D419E2,$BCEFD17E,
    $B9003924,$D07E7320,$DEF0495C,$C36AD00E,$1785B1AB,$92E20BCF,$B139F0E9,$675BB9A1,
    $AECFA4AF,$132376CB,$E84589D3,$79A05456,$A2F860BC,$1AE4F8B5,$20DF4DB4,$A1E1428B,
    $3BF60A1A,$27FF7BF1,$CB44C0E7,$F7F587C4,$1F3B9B21,$94368F01,$856E23A4,$6F93DE3F,
    $773F5BBF,$8B22056E,$DF41F654,$B8246FF4,$8D57BFF2,$D57167EA,$C5699F22,$40734BA7,
    $5D5C2772,$033020A8,$E30A7C4D,$ADC40FD6,$76353441,$5AA5229B,$81516590,$DA49F14E,
    $4FA672A5,$4D9FAC5F,$154BE230,$8A7A5CC0,$CE3D2F84,$CCA15514,$5221360C,$AF0FB81E,
    $5BDD5873,$F6825F8F,$1113D228,$70AD996C,$93320051,$60471C53,$E9BA567B,$3A462AE3,
    $5F55E72D,$1D3C5AD7,$DCFC45EC,$34D812EF,$FA96EE1B,$369D1EF8,$C9B1A189,$7C1D3555,
    $50845EDC,$4BB31877,$8764A060,$8C9A9415,$230E1A3A,$B05E9133,$242B9E03,$A3B99DB7,
    $C2D7FB0A,$3333849D,$D27278D4,$B5D3EFA6,$78AC28AD,$C7B2C135,$0926ECF0,$C1374C91,
    $74F16D98,$2274084A,$3F6D9CFA,$7AC0A383,$B73AFF1F,$3909A23D,$9F1653AE,$4E2F3E71,
    $CA5AB22A,$E01E3858,$90C5A7EB,$3E4A17DF,$AA987FB0,$488BBD62,$B625062B,$2D776BB8,
    $43B5FC08,$1490D532,$D6D12495,$44E89845,$2FE60118,$9D9EF950,$AC38133E,$D3864329,
    $017B255A,$FDC2DD26,$256851E6,$318E7086,$2BFA4861,$89EAC706,$EE5940C6,$68C3BC2F,
    $E260334B,$98DA90BB,$F818F270,$4706D897,$212D3799,$4CF7E5D0,$D9C9649F,$A85DB5CD,
    $35E90E82,$6B881152,$AB1C02C7,$46752B02,$664F598E,$45AB2E64,$C4CDB4B2,$BA42107F,
    $EA2A808A,$971BF3DE,$4A54A836,$4253AECC,$1029BE68,$6DCC9225,$E4BCA56A,$C0AE50B1,
    $7E011D94,$E59C162C,$D8E5C340,$D470FA0B,$B2BE79DD,$D783889C,$1CEDE8F6,$8F4C817A,
    $DDB785C9,$860232D8,$198AAAD9,$A0814738,$3219CFFC,$169546D2,$FC0CB759,$55911510,
    $04D5CEC3,$ED08CC3B,$0D6CF427,$C8E38CCA,$0EEEE3FE,$9EE7D7C8,$F9F24FA9,$DB04B35D,
    $9AB0C9E0,$651F4417,$028F8B07,$6E28D9AA,$FBA96319,$8ED66687,$FECBC58D,$954DDB44),
   ($7B0BDFFE,$865D16B1,$49A058C0,$97ABAA3F,$CAACC75D,$ABA6C17D,$F8746F92,$6F48AEED,
    $8841D4B5,$F36A146A,$73C390AB,$E6FB558F,$87B1019E,$26970252,$246377B2,$CBF676AE,
    $F923DB06,$F7389116,$14C81A90,$83114EB4,$8B137559,$95A86A7A,$D5B8DA8C,$C4DF780E,
    $5A9CB3E2,$E44D4062,$E8DC8EF6,$9D180845,$817AD18B,$C286C85B,$251F20DE,$EE6D5933,
    $F6EDEF81,$D4D16C1E,$C94A0C32,$8437FD22,$3271EE43,$42572AEE,$5F91962A,$1C522D98,
    $59B23F0C,$D86B8804,$08C63531,$2C0D7A40,$B97C4729,$04964DF9,$13C74A17,$5878362F,
    $4C808CD6,$092CB1E0,$6DF02885,$A0C2105E,$8ABA9E68,$64E03057,$E5D61325,$0E43A628,
    $16DBD62B,$2733D90B,$3AE57283,$C0C1052C,$4B6FB620,$37513953,$FC898BB3,$471B179F,
    $DF6E66B8,$D32142F5,$9B30FAFC,$4ED92549,$105C6D99,$4ACD69FF,$2B1A27D3,$6BFCC067,
    $6301A278,$AD36E6F2,$EF3FF64E,$56B3CADB,$0184BB61,$17BEB9FD,$FAEC6109,$A2E1FFA1,
    $2FD224F8,$238F5BE6,$8F8570CF,$AEB5F25A,$4F1D3E64,$4377EB24,$1FA45346,$B2056386,
    $52095E76,$BB7B5ADC,$3514E472,$DDE81E6E,$7ACEA9C4,$AC15CC48,$71C97D93,$767F941C,
    $911052A2,$FFEA09BF,$FE3DDCF0,$15EBF3AA,$9235B8BC,$75408615,$9A723437,$E1A1BD38,
    $33541B7E,$1BDD6856,$B307E13E,$90814BB0,$51D7217B,$0BB92219,$689F4500,$C568B01F,
    $5DF3D2D7,$3C0ECD0D,$2A0244C8,$852574E8,$E72F23A9,$8E26ED02,$2D92CBDD,$DABC0458,
    $CDF5FEB6,$9E4E8DCC,$F4F1E344,$0D8C436D,$4427603B,$BDD37FDA,$80505F26,$8C7D2B8E,
    $B73273C5,$397362EA,$618A3811,$608BFB88,$06F7D714,$212E4677,$28EFCEAD,$076C0371,
    $36A3A4D9,$5487B455,$3429A365,$65D467AC,$78EE7EEB,$99BF12B7,$4D129896,$772A5601,
    $CCE284C7,$2ED85C21,$D099E8A4,$A179158A,$6AC0AB1A,$299A4807,$BE67A58D,$DC19544A,
    $B8949B54,$8D315779,$B6F849C1,$53C5AC34,$66DE92A5,$F195DD13,$318D3A73,$301EC542,
    $0CC40DA6,$F253ADE4,$467EE566,$EA5585EC,$3BAF19BB,$7DE9F480,$79006E7C,$A9B7A197,
    $A44BD8F1,$FB2BA739,$EC342FD4,$ED4FD32D,$3D1789BA,$400F5D7F,$C798F594,$4506A847,
    $034C0A95,$E2162C9D,$55A9CFD0,$692D832E,$CF9DB2CA,$5E2287E9,$D2610EF3,$1AE7ECC2,
    $48399CA0,$A7E4269B,$6EE3A0AF,$7065BFE1,$A6FFE708,$2256804C,$7476E21B,$41B0796C,
    $7C243B05,$000A950F,$1858416B,$F5A53C89,$E9FEF823,$3F443275,$E0CBF091,$0AF27B84,
    $3EBB0F27,$1DE6F7F4,$C31C29F7,$B166DE3D,$12932EC3,$9C0C0674,$5CDA81B9,$D1BD9D12,
    $AFFD7C82,$8962BCA7,$A342C4A8,$62457151,$82089F03,$EB49C670,$5B5F6530,$7E28BAD2,
    $20880BA3,$F0FAAFCD,$CE82B56F,$0275335C,$C18E8AFB,$DE601D69,$BA9B820A,$C8A2BE4F,
    $D7CAC335,$D9A73741,$115E974D,$7F5AC21D,$383BF9C6,$BCAEB75F,$FD0350CE,$B5D06B87,
    $9820E03C,$72D5F163,$E3644FC9,$A5464C4B,$57048FCB,$9690C9DF,$DBF9EAFA,$BFF4649A,
    $053C00E3,$B4B61136,$67593DD1,$503EE960,$9FB4993A,$19831810,$C670D518,$B05B51D8,
    $0F3A1CE5,$6CAA1F9C,$AACC31BE,$949ED050,$1EAD07E7,$A8479ABD,$D6CFFCD5,$936993EF),
   ($472E91CB,$5444B5B6,$62BE5861,$1BE102C7,$63E4B31E,$E81F71B7,$9E2317C9,$39A408AE,
    $518024F4,$1731C66F,$68CBC918,$71FB0C9E,$D03B7FDD,$7D6222EB,$9057EDA3,$1A34A407,
    $8CC2253D,$B6F6979D,$835675DC,$F319BE9F,$BE1CD743,$4D32FEE4,$77E7D887,$37E9EBFD,
    $15F851E8,$23DC3706,$19D78385,$BD506933,$A13AD4A6,$913F1A0E,$DDE560B9,$9A5F0996,
    $A65A0435,$48D34C4D,$E90839A7,$8ABBA54E,$6FD13CE1,$C7EEBD3C,$0E297602,$58B9BBB4,
    $EF7901E6,$64A28A62,$A509875A,$F8834442,$2702C709,$07353F31,$3B39F665,$F5B18B49,
    $4010AE37,$784DE00B,$7A1121E9,$DE918ED3,$C8529DCD,$816A5D05,$02ED8298,$04E3DD84,
    $FD2BC3E2,$AF167089,$96AF367E,$A4DA6232,$18FF7325,$05F9A9F1,$4FEFB9F9,$CD94EAA5,
    $BFAA5069,$A0B8C077,$60D86F57,$FE71C813,$29EBD2C8,$4CA86538,$6BF1A030,$A237B88A,
    $AA8AF41D,$E1F7B6EC,$E214D953,$33057879,$49CAA736,$FA45CFF3,$C063B411,$BA7E27D0,
    $31533819,$2A004AC1,$210EFC3F,$2646885E,$66727DCF,$9D7FBF54,$A8DD0EA8,$3447CACE,
    $3F0C14DB,$B8382AAC,$4ACE3539,$0A518D51,$95178981,$35AEE2CA,$73F0F7E3,$94281140,
    $59D0E523,$D292CB88,$565D1B27,$7EC8FBAF,$069AF08D,$C127FD24,$0BC77B10,$5F03E7EF,
    $453E99BA,$EED9FF7F,$87B55215,$7915AB4C,$D389A358,$5E75CE6D,$28D655C0,$DAD26C73,
    $2E2510FF,$9FA7EECC,$1D0629C3,$DC9C9C46,$2D67ECD7,$E75E94BD,$3D649E2A,$6C413A2B,
    $706F0D7C,$DFB0127B,$4E366B55,$2C825650,$24205720,$B5C998F7,$3E95462C,$756E5C72,
    $3259488F,$11E8771A,$A7C0A617,$577663E5,$089B6401,$8EAB1941,$AE55EF8C,$3AAC5460,
    $D4E6262F,$5D979A47,$B19823B0,$7F8D6A0C,$FFA08683,$0170CD0F,$858CD5D8,$53961C90,
    $C4C61556,$41F2F226,$CFCD062D,$F24C03B8,$EA81DF5B,$7BE2FA52,$B361F98B,$C2901316,
    $55BA4BBC,$93B234A9,$0FBC6603,$80A96822,$6D60491F,$22BD00F8,$BCAD5AAD,$52F3F13B,
    $42FD2B28,$B41DD01C,$C52C93BF,$FC663094,$8F58D100,$43FECC08,$C6331E5D,$E6480F66,
    $CA847204,$4BDF1DA0,$30CC2EFB,$13E02DEA,$FB49AC45,$F9D4434F,$F47C5B9C,$148879C2,
    $039FC234,$A3DB9BFC,$D1A1DC5C,$763D7CD4,$ED6D2F93,$AB13AF6E,$1E8E054A,$D68F4F9A,
    $C30484B3,$D7D50AFA,$6930855F,$CC07DB95,$CE746DB1,$744E967D,$F16CF575,$8643E8B5,
    $F0EAE38E,$E52DE1D1,$6587DAE0,$0C4B8121,$1C7AC567,$AC0DB20A,$36C3A812,$5B1A4514,
    $A9A3F868,$B9263BAA,$CB3CE9D2,$E44FB1A4,$9221BC82,$B29390FE,$6AB41863,$974A3E2E,
    $89F531C5,$255CA13E,$8B65D348,$EC248F78,$D8FC16F0,$50ECDEEE,$09010792,$3C7D1FB2,
    $EBA5426B,$847B417A,$468B40D9,$8DC4E680,$7CC1F391,$2F1EB086,$6E5BAA6A,$E0B395DA,
    $E31B2CF6,$D9690B0D,$729EC464,$38403DDE,$610B80A2,$5CF433AB,$B0785FC4,$D512E4C6,
    $BBB7D699,$5A86591B,$10CF5376,$12BF9F4B,$980FBAA1,$992A4E70,$20FA7AE7,$F7996EBB,
    $C918A2BE,$82DE74F2,$AD54209B,$F66B4D74,$1FC5B771,$169D9229,$887761DF,$00B667D5,
    $DB425E59,$B72F2844,$9B0AC1F5,$9C737E3A,$2B85476C,$6722ADD6,$44A63297,$0D688CED),
   ($ABC59484,$4107778A,$8AD94C6F,$FE83DF90,$0F64053F,$D1292E9D,$C5744356,$8DD1ABB4,
    $4C4E7667,$FB4A7FC1,$74F402CB,$70F06AFD,$A82286F2,$918DD076,$7A97C5CE,$48F7BDE3,
    $6A04D11D,$AC243EF7,$33AC10CA,$2F7A341E,$5F75157A,$F4773381,$591C870E,$78DF8CC8,
    $22F3ADB0,$251A5993,$09FBEF66,$796942A8,$97541D2E,$2373DAA9,$1BD2F142,$B57E8EB2,
    $E1A5BFDB,$7D0EFA92,$B3442C94,$D2CB6447,$386AC97E,$66D61805,$BDADA15E,$11BC1AA7,
    $14E9F6EA,$E533A0C0,$F935EE0A,$8FEE8A04,$810D6D85,$7C68B6D6,$4EDC9AA2,$956E897D,
    $ED87581A,$264BE9D7,$FF4DDB29,$823857C2,$E005A9A0,$F1CC2450,$6F9951E1,$AADE2310,
    $E70C75F5,$83E1A31F,$4F7DDE8E,$F723B563,$368E0928,$86362B71,$21E8982D,$DFB3F92B,
    $44676352,$99EFBA31,$2EAB4E1C,$FC6CA5E7,$0EBE5D4E,$A0717D0C,$B64F8199,$946B31A1,
    $5656CBC6,$CFFEC3EF,$622766C9,$FA211E35,$52F98B89,$6D01674B,$4978A802,$F651F701,
    $15B0D43D,$D6FF4683,$3463855F,$672BA29C,$BC128312,$4626A70D,$C8927A5A,$B8481CF9,
    $1C962262,$A21196BA,$BABA5EE9,$5BB162D0,$69943BD1,$0C47E35C,$8CC9619A,$E284D948,
    $271BF264,$C27FB398,$4BC70897,$60CF202C,$7F42D6AA,$A5A13506,$5D3E8860,$CEA63D3C,
    $63BF0A8F,$F02E9EFA,$B17B0674,$B072B1D3,$06E5723B,$3737E436,$24AA49C7,$0DED0D18,
    $DB256B14,$58B27877,$ECB49F54,$6C40256A,$6EA92FFB,$3906AA4C,$C9866FD5,$4549323E,
    $A7B85FAB,$1918CC27,$7308D7B5,$1E16C7AD,$71850B37,$3095FD78,$A63B70E6,$D880E2AE,
    $3E282769,$A39BA6BC,$98700FA3,$F34C53E8,$288AF426,$B99D930F,$F5B99DF1,$E9D0C8CF,
    $5AC8405D,$50E7217B,$511FBBBE,$2CA2E639,$C020301B,$356DBC00,$8E43DDB9,$4D327B4A,
    $F20FF3ED,$1DBB29BD,$43D44779,$A1B68F70,$6114455B,$E63D280B,$6BF6FF65,$10FC39E5,
    $3DAE126E,$C1D7CF11,$CB60B795,$1789D5B3,$9BCA36B7,$08306075,$84615608,$8B3A0186,
    $E88FBECD,$7BA47C4D,$2DE44DAC,$653FE58D,$CCA0B968,$D7FA0E72,$93901780,$1F2C26CC,
    $AE595B6B,$A9ECEA9B,$E3DBF8C4,$319CC130,$12981196,$01A3A4DE,$32C454B6,$755BD817,
    $3CD871E4,$A48BB8DA,$02FDEC09,$FD2DC2E2,$9E578088,$9A9F916D,$4065FE6C,$1853999E,
    $C7793F23,$DC1016BB,$969355FF,$7EF292F6,$CDCE4ADC,$05E24416,$85C16C46,$D441D37F,
    $57BD6855,$8746F54F,$9CA773DF,$770BAE22,$54828413,$B75E4B19,$04C35C03,$BF7CCA07,
    $2955C4DD,$721DB041,$B2394F33,$03F51387,$89B73C9F,$0B1737F3,$07E69024,$9231D245,
    $76193861,$88159C15,$DEB552D9,$D9767E40,$20C6C0C3,$4281977C,$F8AFE1E0,$D32A0751,
    $3FC27432,$DDF1DCC5,$68581F34,$3BCD5025,$0091B2EE,$4AEB6944,$1602E743,$EA09EB58,
    $EF0A2A8B,$641E03A5,$EB50E021,$5C8CCEF8,$802FF0B8,$D5E3EDFE,$C4DD1B49,$5334CD2A,
    $13F82D2F,$47450C20,$55DAFBD2,$BEC0C6F4,$B45D7959,$3AD36E8C,$0AA8AC57,$1A3C8D73,
    $E45AAFB1,$9F664838,$C6880053,$D0039BBF,$EE5F19EB,$CA0041D8,$BBEA3AAF,$DA628291,
    $9D5C95D4,$ADD504A6,$C39AB482,$5E9E14A4,$2BE065F0,$2A13FC3A,$9052E8EC,$AF6F5AFC),
   ($519AA8B5,$BB303DA9,$E00E2B10,$DFA6C1DB,$2E6B952E,$EE10DC23,$37936D09,$1FC42E92,
    $39B25A9F,$13FF89F4,$C8F53FEA,$18500BC7,$95A0379D,$98F751C2,$2289C42F,$A21E4098,
    $6F391F41,$F27E7E58,$0D0DF887,$4B79D540,$8E8409AA,$71FE46F8,$688A9B29,$3F08B548,
    $84ABE03A,$5E91B6C1,$FDE4C2AE,$251D0E72,$92D4FEE5,$F9371967,$9175108F,$E6E81835,
    $8C8CB8EE,$B55A67B3,$CEF138CC,$8B256268,$00D815F5,$E8810812,$77826189,$EA73267D,
    $19B90F8D,$45C33BB4,$82477056,$E1770075,$09467AA6,$A7C6F54A,$79768742,$61B86BCA,
    $D6644A44,$E33F0171,$C229FBCD,$41B08FEB,$D1903E30,$65EC9080,$563D6FBD,$F56DA488,
    $EBF64CD8,$4934426B,$7C8592FC,$6ACA8CF2,$1CEA111B,$3A57EE7A,$ACE11C0D,$9942D85E,
    $C4613407,$FA8E643B,$327FC701,$4CA9BE82,$3352526D,$2C047F63,$F3A8F7DD,$1A4A98A8,
    $762ED4D1,$27C75008,$BDF497C0,$7A7B84DF,$315C28AB,$801F93E3,$F19B0CA1,$8F14E46A,
    $E48BA333,$9605E625,$F03ECB60,$60385F2D,$902845BA,$7F96D66F,$24BFF05C,$2820730B,
    $947133CB,$D444828A,$B343F6F1,$0BEF4705,$8DA574F9,$01E25D6C,$1732793E,$4F0F7B27,
    $364B7117,$B2D1DA77,$A6C5F1E9,$574CA5B1,$386A3076,$AD6894D6,$1156D7FA,$A48D1D9A,
    $4794C0AF,$150C0AA0,$26D348AC,$29FDEABE,$A5DEDE53,$81671E8E,$594EE3BF,$A96C56E6,
    $3426A726,$C5976579,$BC22E5E4,$C1006319,$DAAFDD2A,$A1A1AA83,$3BADD0E7,$C3B14981,
    $D770B155,$CCD7C693,$42E944C5,$03E0064F,$CA95B4EF,$3DEE81C3,$FBBCD98C,$1E07E15B,
    $667CE949,$E7D6773F,$21B6124B,$6B2A6EF7,$D3278A9C,$9A988304,$75D2AE9B,$FE49E2FF,
    $9BC24F46,$74CC2CF6,$A3139F36,$6C9EF35A,$9FC1DFFE,$9E5FACDC,$AADC8BBB,$5ABDBC5F,
    $44B3B390,$F754EFA7,$5FE3BDB7,$4E59C886,$06A4C984,$A0338878,$CD513CD7,$63EBD27E,
    $8ABA80AD,$50DA144E,$5D9F4E97,$025B751C,$2D580200,$B6C05837,$580AA15D,$54022A6E,
    $B41A5415,$4863FAB6,$B0B79957,$46D0D159,$DC2B8650,$20A7BB0C,$4A032974,$EC8636A2,
    $8548F24C,$F6A2BF16,$1088F4B0,$0C2F3A94,$525DC396,$14065785,$2B4DCA52,$08AEED39,
    $ABEDFC99,$B1DBCF18,$87F85BBC,$AE3AFF61,$433CCD70,$5B23CC64,$7B453213,$5355C545,
    $9318EC0A,$78692D31,$0A21693D,$D5666814,$05FB59D9,$C71985B2,$2ABB8E0E,$CF6E6C91,
    $D9CFE7C6,$EFE7132C,$9711AB28,$3CE52732,$12D516D2,$7209A0D0,$D278D306,$70FA4B7B,
    $1D407DD3,$DB0BEBA4,$BFD97621,$A8BE21E1,$1B6F1B66,$30650DDA,$BA7DDBB9,$7DF953FB,
    $9D1C3902,$EDF0E8D5,$B8741AE0,$0F240565,$62CD438B,$C616A924,$AF7A96A3,$35365538,
    $E583AF4D,$73415EB8,$23176A47,$FC9CCEE8,$7EFC9DE2,$695E03CF,$F8CE66D4,$88B4781D,
    $67DD9C03,$3E8F9E73,$C0C95C51,$BE314D22,$55AA0795,$CB1BB011,$E980FDC8,$9C62B7CE,
    $DE2D239E,$042CADF3,$FFDF04DE,$5CE6A60F,$D8C831ED,$B7B5B9EC,$B9CBF962,$E253B254,
    $0735BA1F,$16AC917F,$DD607C2B,$64A335C4,$40159A7C,$869222F0,$6EF21769,$839D20A5,
    $D03B24C9,$F412601E,$6D72A243,$0E018DFD,$89F3721A,$C94F4134,$2F992F20,$4D87253C));

  Tiger_Data: array[0..3, 0..255] of Int64 = (
   ($02AAB17CF7E90C5E, $AC424B03E243A8EC, $72CD5BE30DD5FCD3,
    $6D019B93F6F97F3A, $CD9978FFD21F9193, $7573A1C9708029E2,
    $B164326B922A83C3, $46883EEE04915870, $EAACE3057103ECE6,
    $C54169B808A3535C, $4CE754918DDEC47C, $0AA2F4DFDC0DF40C,
    $10B76F18A74DBEFA, $C6CCB6235AD1AB6A, $13726121572FE2FF,
    $1A488C6F199D921E, $4BC9F9F4DA0007CA, $26F5E6F6E85241C7,
    $859079DBEA5947B6, $4F1885C5C99E8C92, $D78E761EA96F864B,
    $8E36428C52B5C17D, $69CF6827373063C1, $B607C93D9BB4C56E,
    $7D820E760E76B5EA, $645C9CC6F07FDC42, $BF38A078243342E0,
    $5F6B343C9D2E7D04, $F2C28AEB600B0EC6, $6C0ED85F7254BCAC,
    $71592281A4DB4FE5, $1967FA69CE0FED9F, $FD5293F8B96545DB,
    $C879E9D7F2A7600B, $860248920193194E, $A4F9533B2D9CC0B3,
    $9053836C15957613, $DB6DCF8AFC357BF1, $18BEEA7A7A370F57,
    $037117CA50B99066, $6AB30A9774424A35, $F4E92F02E325249B,
    $7739DB07061CCAE1, $D8F3B49CECA42A05, $BD56BE3F51382F73,
    $45FAED5843B0BB28, $1C813D5C11BF1F83, $8AF0E4B6D75FA169,
    $33EE18A487AD9999, $3C26E8EAB1C94410, $B510102BC0A822F9,
    $141EEF310CE6123B, $FC65B90059DDB154, $E0158640C5E0E607,
    $884E079826C3A3CF, $930D0D9523C535FD, $35638D754E9A2B00,
    $4085FCCF40469DD5, $C4B17AD28BE23A4C, $CAB2F0FC6A3E6A2E,
    $2860971A6B943FCD, $3DDE6EE212E30446, $6222F32AE01765AE,
    $5D550BB5478308FE, $A9EFA98DA0EDA22A, $C351A71686C40DA7,
    $1105586D9C867C84, $DCFFEE85FDA22853, $CCFBD0262C5EEF76,
    $BAF294CB8990D201, $E69464F52AFAD975, $94B013AFDF133E14,
    $06A7D1A32823C958, $6F95FE5130F61119, $D92AB34E462C06C0,
    $ED7BDE33887C71D2, $79746D6E6518393E, $5BA419385D713329,
    $7C1BA6B948A97564, $31987C197BFDAC67, $DE6C23C44B053D02,
    $581C49FED002D64D, $DD474D6338261571, $AA4546C3E473D062,
    $928FCE349455F860, $48161BBACAAB94D9, $63912430770E6F68,
    $6EC8A5E602C6641C, $87282515337DDD2B, $2CDA6B42034B701B,
    $B03D37C181CB096D, $E108438266C71C6F, $2B3180C7EB51B255,
    $DF92B82F96C08BBC, $5C68C8C0A632F3BA, $5504CC861C3D0556,
    $ABBFA4E55FB26B8F, $41848B0AB3BACEB4, $B334A273AA445D32,
    $BCA696F0A85AD881, $24F6EC65B528D56C, $0CE1512E90F4524A,
    $4E9DD79D5506D35A, $258905FAC6CE9779, $2019295B3E109B33,
    $F8A9478B73A054CC, $2924F2F934417EB0, $3993357D536D1BC4,
    $38A81AC21DB6FF8B, $47C4FBF17D6016BF, $1E0FAADD7667E3F5,
    $7ABCFF62938BEB96, $A78DAD948FC179C9, $8F1F98B72911E50D,
    $61E48EAE27121A91, $4D62F7AD31859808, $ECEBA345EF5CEAEB,
    $F5CEB25EBC9684CE, $F633E20CB7F76221, $A32CDF06AB8293E4,
    $985A202CA5EE2CA4, $CF0B8447CC8A8FB1, $9F765244979859A3,
    $A8D516B1A1240017, $0BD7BA3EBB5DC726, $E54BCA55B86ADB39,
    $1D7A3AFD6C478063, $519EC608E7669EDD, $0E5715A2D149AA23,
    $177D4571848FF194, $EEB55F3241014C22, $0F5E5CA13A6E2EC2,
    $8029927B75F5C361, $AD139FABC3D6E436, $0D5DF1A94CCF402F,
    $3E8BD948BEA5DFC8, $A5A0D357BD3FF77E, $A2D12E251F74F645,
    $66FD9E525E81A082, $2E0C90CE7F687A49, $C2E8BCBEBA973BC5,
    $000001BCE509745F, $423777BBE6DAB3D6, $D1661C7EAEF06EB5,
    $A1781F354DAACFD8, $2D11284A2B16AFFC, $F1FC4F67FA891D1F,
    $73ECC25DCB920ADA, $AE610C22C2A12651, $96E0A810D356B78A,
    $5A9A381F2FE7870F, $D5AD62EDE94E5530, $D225E5E8368D1427,
    $65977B70C7AF4631, $99F889B2DE39D74F, $233F30BF54E1D143,
    $9A9675D3D9A63C97, $5470554FF334F9A8, $166ACB744A4F5688,
    $70C74CAAB2E4AEAD, $F0D091646F294D12, $57B82A89684031D1,
    $EFD95A5A61BE0B6B, $2FBD12E969F2F29A, $9BD37013FEFF9FE8,
    $3F9B0404D6085A06, $4940C1F3166CFE15, $09542C4DCDF3DEFB,
    $B4C5218385CD5CE3, $C935B7DC4462A641, $3417F8A68ED3B63F,
    $B80959295B215B40, $F99CDAEF3B8C8572, $018C0614F8FCB95D,
    $1B14ACCD1A3ACDF3, $84D471F200BB732D, $C1A3110E95E8DA16,
    $430A7220BF1A82B8, $B77E090D39DF210E, $5EF4BD9F3CD05E9D,
    $9D4FF6DA7E57A444, $DA1D60E183D4A5F8, $B287C38417998E47,
    $FE3EDC121BB31886, $C7FE3CCC980CCBEF, $E46FB590189BFD03,
    $3732FD469A4C57DC, $7EF700A07CF1AD65, $59C64468A31D8859,
    $762FB0B4D45B61F6, $155BAED099047718, $68755E4C3D50BAA6,
    $E9214E7F22D8B4DF, $2ADDBF532EAC95F4, $32AE3909B4BD0109,
    $834DF537B08E3450, $FA209DA84220728D, $9E691D9B9EFE23F7,
    $0446D288C4AE8D7F, $7B4CC524E169785B, $21D87F0135CA1385,
    $CEBB400F137B8AA5, $272E2B66580796BE, $3612264125C2B0DE,
    $057702BDAD1EFBB2, $D4BABB8EACF84BE9, $91583139641BC67B,
    $8BDC2DE08036E024, $603C8156F49F68ED, $F7D236F7DBEF5111,
    $9727C4598AD21E80, $A08A0896670A5FD7, $CB4A8F4309EBA9CB,
    $81AF564B0F7036A1, $C0B99AA778199ABD, $959F1EC83FC8E952,
    $8C505077794A81B9, $3ACAAF8F056338F0, $07B43F50627A6778,
    $4A44AB49F5ECCC77, $3BC3D6E4B679EE98, $9CC0D4D1CF14108C,
    $4406C00B206BC8A0, $82A18854C8D72D89, $67E366B35C3C432C,
    $B923DD61102B37F2, $56AB2779D884271D, $BE83E1B0FF1525AF,
    $FB7C65D4217E49A9, $6BDBE0E76D48E7D4, $08DF828745D9179E,
    $22EA6A9ADD53BD34, $E36E141C5622200A, $7F805D1B8CB750EE,
    $AFE5C7A59F58E837, $E27F996A4FB1C23C, $D3867DFB0775F0D0,
    $D0E673DE6E88891A, $123AEB9EAFB86C25, $30F1D5D5C145B895,
    $BB434A2DEE7269E7, $78CB67ECF931FA38, $F33B0372323BBF9C,
    $52D66336FB279C74, $505F33AC0AFB4EAA, $E8A5CD99A2CCE187,
    $534974801E2D30BB, $8D2D5711D5876D90, $1F1A412891BC038E,
    $D6E2E71D82E56648, $74036C3A497732B7, $89B67ED96361F5AB,
    $FFED95D8F1EA02A2, $E72B3BD61464D43D, $A6300F170BDC4820,
    $EBC18760ED78A77A),
   ($E6A6BE5A05A12138, $B5A122A5B4F87C98, $563C6089140B6990,
    $4C46CB2E391F5DD5, $D932ADDBC9B79434, $08EA70E42015AFF5,
    $D765A6673E478CF1, $C4FB757EAB278D99, $DF11C6862D6E0692,
    $DDEB84F10D7F3B16, $6F2EF604A665EA04, $4A8E0F0FF0E0DFB3,
    $A5EDEEF83DBCBA51, $FC4F0A2A0EA4371E, $E83E1DA85CB38429,
    $DC8FF882BA1B1CE2, $CD45505E8353E80D, $18D19A00D4DB0717,
    $34A0CFEDA5F38101, $0BE77E518887CAF2, $1E341438B3C45136,
    $E05797F49089CCF9, $FFD23F9DF2591D14, $543DDA228595C5CD,
    $661F81FD99052A33, $8736E641DB0F7B76, $15227725418E5307,
    $E25F7F46162EB2FA, $48A8B2126C13D9FE, $AFDC541792E76EEA,
    $03D912BFC6D1898F, $31B1AAFA1B83F51B, $F1AC2796E42AB7D9,
    $40A3A7D7FCD2EBAC, $1056136D0AFBBCC5, $7889E1DD9A6D0C85,
    $D33525782A7974AA, $A7E25D09078AC09B, $BD4138B3EAC6EDD0,
    $920ABFBE71EB9E70, $A2A5D0F54FC2625C, $C054E36B0B1290A3,
    $F6DD59FF62FE932B, $3537354511A8AC7D, $CA845E9172FADCD4,
    $84F82B60329D20DC, $79C62CE1CD672F18, $8B09A2ADD124642C,
    $D0C1E96A19D9E726, $5A786A9B4BA9500C, $0E020336634C43F3,
    $C17B474AEB66D822, $6A731AE3EC9BAAC2, $8226667AE0840258,
    $67D4567691CAECA5, $1D94155C4875ADB5, $6D00FD985B813FDF,
    $51286EFCB774CD06, $5E8834471FA744AF, $F72CA0AEE761AE2E,
    $BE40E4CDAEE8E09A, $E9970BBB5118F665, $726E4BEB33DF1964,
    $703B000729199762, $4631D816F5EF30A7, $B880B5B51504A6BE,
    $641793C37ED84B6C, $7B21ED77F6E97D96, $776306312EF96B73,
    $AE528948E86FF3F4, $53DBD7F286A3F8F8, $16CADCE74CFC1063,
    $005C19BDFA52C6DD, $68868F5D64D46AD3, $3A9D512CCF1E186A,
    $367E62C2385660AE, $E359E7EA77DCB1D7, $526C0773749ABE6E,
    $735AE5F9D09F734B, $493FC7CC8A558BA8, $B0B9C1533041AB45,
    $321958BA470A59BD, $852DB00B5F46C393, $91209B2BD336B0E5,
    $6E604F7D659EF19F, $B99A8AE2782CCB24, $CCF52AB6C814C4C7,
    $4727D9AFBE11727B, $7E950D0C0121B34D, $756F435670AD471F,
    $F5ADD442615A6849, $4E87E09980B9957A, $2ACFA1DF50AEE355,
    $D898263AFD2FD556, $C8F4924DD80C8FD6, $CF99CA3D754A173A,
    $FE477BACAF91BF3C, $ED5371F6D690C12D, $831A5C285E687094,
    $C5D3C90A3708A0A4, $0F7F903717D06580, $19F9BB13B8FDF27F,
    $B1BD6F1B4D502843, $1C761BA38FFF4012, $0D1530C4E2E21F3B,
    $8943CE69A7372C8A, $E5184E11FEB5CE66, $618BDB80BD736621,
    $7D29BAD68B574D0B, $81BB613E25E6FE5B, $071C9C10BC07913F,
    $C7BEEB7909AC2D97, $C3E58D353BC5D757, $EB017892F38F61E8,
    $D4EFFB9C9B1CC21A, $99727D26F494F7AB, $A3E063A2956B3E03,
    $9D4A8B9A4AA09C30, $3F6AB7D500090FB4, $9CC0F2A057268AC0,
    $3DEE9D2DEDBF42D1, $330F49C87960A972, $C6B2720287421B41,
    $0AC59EC07C00369C, $EF4EAC49CB353425, $F450244EEF0129D8,
    $8ACC46E5CAF4DEB6, $2FFEAB63989263F7, $8F7CB9FE5D7A4578,
    $5BD8F7644E634635, $427A7315BF2DC900, $17D0C4AA2125261C,
    $3992486C93518E50, $B4CBFEE0A2D7D4C3, $7C75D6202C5DDD8D,
    $DBC295D8E35B6C61, $60B369D302032B19, $CE42685FDCE44132,
    $06F3DDB9DDF65610, $8EA4D21DB5E148F0, $20B0FCE62FCD496F,
    $2C1B912358B0EE31, $B28317B818F5A308, $A89C1E189CA6D2CF,
    $0C6B18576AAADBC8, $B65DEAA91299FAE3, $FB2B794B7F1027E7,
    $04E4317F443B5BEB, $4B852D325939D0A6, $D5AE6BEEFB207FFC,
    $309682B281C7D374, $BAE309A194C3B475, $8CC3F97B13B49F05,
    $98A9422FF8293967, $244B16B01076FF7C, $F8BF571C663D67EE,
    $1F0D6758EEE30DA1, $C9B611D97ADEB9B7, $B7AFD5887B6C57A2,
    $6290AE846B984FE1, $94DF4CDEACC1A5FD, $058A5BD1C5483AFF,
    $63166CC142BA3C37, $8DB8526EB2F76F40, $E10880036F0D6D4E,
    $9E0523C9971D311D, $45EC2824CC7CD691, $575B8359E62382C9,
    $FA9E400DC4889995, $D1823ECB45721568, $DAFD983B8206082F,
    $AA7D29082386A8CB, $269FCD4403B87588, $1B91F5F728BDD1E0,
    $E4669F39040201F6, $7A1D7C218CF04ADE, $65623C29D79CE5CE,
    $2368449096C00BB1, $AB9BF1879DA503BA, $BC23ECB1A458058E,
    $9A58DF01BB401ECC, $A070E868A85F143D, $4FF188307DF2239E,
    $14D565B41A641183, $EE13337452701602, $950E3DCF3F285E09,
    $59930254B9C80953, $3BF299408930DA6D, $A955943F53691387,
    $A15EDECAA9CB8784, $29142127352BE9A0, $76F0371FFF4E7AFB,
    $0239F450274F2228, $BB073AF01D5E868B, $BFC80571C10E96C1,
    $D267088568222E23, $9671A3D48E80B5B0, $55B5D38AE193BB81,
    $693AE2D0A18B04B8, $5C48B4ECADD5335F, $FD743B194916A1CA,
    $2577018134BE98C4, $E77987E83C54A4AD, $28E11014DA33E1B9,
    $270CC59E226AA213, $71495F756D1A5F60, $9BE853FB60AFEF77,
    $ADC786A7F7443DBF, $0904456173B29A82, $58BC7A66C232BD5E,
    $F306558C673AC8B2, $41F639C6B6C9772A, $216DEFE99FDA35DA,
    $11640CC71C7BE615, $93C43694565C5527, $EA038E6246777839,
    $F9ABF3CE5A3E2469, $741E768D0FD312D2, $0144B883CED652C6,
    $C20B5A5BA33F8552, $1AE69633C3435A9D, $97A28CA4088CFDEC,
    $8824A43C1E96F420, $37612FA66EEEA746, $6B4CB165F9CF0E5A,
    $43AA1C06A0ABFB4A, $7F4DC26FF162796B, $6CBACC8E54ED9B0F,
    $A6B7FFEFD2BB253E, $2E25BC95B0A29D4F, $86D6A58BDEF1388C,
    $DED74AC576B6F054, $8030BDBC2B45805D, $3C81AF70E94D9289,
    $3EFF6DDA9E3100DB, $B38DC39FDFCC8847, $123885528D17B87E,
    $F2DA0ED240B1B642, $44CEFADCD54BF9A9, $1312200E433C7EE6,
    $9FFCC84F3A78C748, $F0CD1F72248576BB, $EC6974053638CFE4,
    $2BA7B67C0CEC4E4C, $AC2F4DF3E5CE32ED, $CB33D14326EA4C11,
    $A4E9044CC77E58BC, $5F513293D934FCEF, $5DC9645506E55444,
    $50DE418F317DE40A, $388CB31A69DDE259, $2DB4A83455820A86,
    $9010A91E84711AE9, $4DF7F0B7B1498371, $D62A2EABC0977179,
    $22FAC097AA8D5C0E),
   ($F49FCC2FF1DAF39B, $487FD5C66FF29281, $E8A30667FCDCA83F,
    $2C9B4BE3D2FCCE63, $DA3FF74B93FBBBC2, $2FA165D2FE70BA66,
    $A103E279970E93D4, $BECDEC77B0E45E71, $CFB41E723985E497,
    $B70AAA025EF75017, $D42309F03840B8E0, $8EFC1AD035898579,
    $96C6920BE2B2ABC5, $66AF4163375A9172, $2174ABDCCA7127FB,
    $B33CCEA64A72FF41, $F04A4933083066A5, $8D970ACDD7289AF5,
    $8F96E8E031C8C25E, $F3FEC02276875D47, $EC7BF310056190DD,
    $F5ADB0AEBB0F1491, $9B50F8850FD58892, $4975488358B74DE8,
    $A3354FF691531C61, $0702BBE481D2C6EE, $89FB24057DEDED98,
    $AC3075138596E902, $1D2D3580172772ED, $EB738FC28E6BC30D,
    $5854EF8F63044326, $9E5C52325ADD3BBE, $90AA53CF325C4623,
    $C1D24D51349DD067, $2051CFEEA69EA624, $13220F0A862E7E4F,
    $CE39399404E04864, $D9C42CA47086FCB7, $685AD2238A03E7CC,
    $066484B2AB2FF1DB, $FE9D5D70EFBF79EC, $5B13B9DD9C481854,
    $15F0D475ED1509AD, $0BEBCD060EC79851, $D58C6791183AB7F8,
    $D1187C5052F3EEE4, $C95D1192E54E82FF, $86EEA14CB9AC6CA2,
    $3485BEB153677D5D, $DD191D781F8C492A, $F60866BAA784EBF9,
    $518F643BA2D08C74, $8852E956E1087C22, $A768CB8DC410AE8D,
    $38047726BFEC8E1A, $A67738B4CD3B45AA, $AD16691CEC0DDE19,
    $C6D4319380462E07, $C5A5876D0BA61938, $16B9FA1FA58FD840,
    $188AB1173CA74F18, $ABDA2F98C99C021F, $3E0580AB134AE816,
    $5F3B05B773645ABB, $2501A2BE5575F2F6, $1B2F74004E7E8BA9,
    $1CD7580371E8D953, $7F6ED89562764E30, $B15926FF596F003D,
    $9F65293DA8C5D6B9, $6ECEF04DD690F84C, $4782275FFF33AF88,
    $E41433083F820801, $FD0DFE409A1AF9B5, $4325A3342CDB396B,
    $8AE77E62B301B252, $C36F9E9F6655615A, $85455A2D92D32C09,
    $F2C7DEA949477485, $63CFB4C133A39EBA, $83B040CC6EBC5462,
    $3B9454C8FDB326B0, $56F56A9E87FFD78C, $2DC2940D99F42BC6,
    $98F7DF096B096E2D, $19A6E01E3AD852BF, $42A99CCBDBD4B40B,
    $A59998AF45E9C559, $366295E807D93186, $6B48181BFAA1F773,
    $1FEC57E2157A0A1D, $4667446AF6201AD5, $E615EBCACFB0F075,
    $B8F31F4F68290778, $22713ED6CE22D11E, $3057C1A72EC3C93B,
    $CB46ACC37C3F1F2F, $DBB893FD02AAF50E, $331FD92E600B9FCF,
    $A498F96148EA3AD6, $A8D8426E8B6A83EA, $A089B274B7735CDC,
    $87F6B3731E524A11, $118808E5CBC96749, $9906E4C7B19BD394,
    $AFED7F7E9B24A20C, $6509EADEEB3644A7, $6C1EF1D3E8EF0EDE,
    $B9C97D43E9798FB4, $A2F2D784740C28A3, $7B8496476197566F,
    $7A5BE3E6B65F069D, $F96330ED78BE6F10, $EEE60DE77A076A15,
    $2B4BEE4AA08B9BD0, $6A56A63EC7B8894E, $02121359BA34FEF4,
    $4CBF99F8283703FC, $398071350CAF30C8, $D0A77A89F017687A,
    $F1C1A9EB9E423569, $8C7976282DEE8199, $5D1737A5DD1F7ABD,
    $4F53433C09A9FA80, $FA8B0C53DF7CA1D9, $3FD9DCBC886CCB77,
    $C040917CA91B4720, $7DD00142F9D1DCDF, $8476FC1D4F387B58,
    $23F8E7C5F3316503, $032A2244E7E37339, $5C87A5D750F5A74B,
    $082B4CC43698992E, $DF917BECB858F63C, $3270B8FC5BF86DDA,
    $10AE72BB29B5DD76, $576AC94E7700362B, $1AD112DAC61EFB8F,
    $691BC30EC5FAA427, $FF246311CC327143, $3142368E30E53206,
    $71380E31E02CA396, $958D5C960AAD76F1, $F8D6F430C16DA536,
    $C8FFD13F1BE7E1D2, $7578AE66004DDBE1, $05833F01067BE646,
    $BB34B5AD3BFE586D, $095F34C9A12B97F0, $247AB64525D60CA8,
    $DCDBC6F3017477D1, $4A2E14D4DECAD24D, $BDB5E6D9BE0A1EEB,
    $2A7E70F7794301AB, $DEF42D8A270540FD, $01078EC0A34C22C1,
    $E5DE511AF4C16387, $7EBB3A52BD9A330A, $77697857AA7D6435,
    $004E831603AE4C32, $E7A21020AD78E312, $9D41A70C6AB420F2,
    $28E06C18EA1141E6, $D2B28CBD984F6B28, $26B75F6C446E9D83,
    $BA47568C4D418D7F, $D80BADBFE6183D8E, $0E206D7F5F166044,
    $E258A43911CBCA3E, $723A1746B21DC0BC, $C7CAA854F5D7CDD3,
    $7CAC32883D261D9C, $7690C26423BA942C, $17E55524478042B8,
    $E0BE477656A2389F, $4D289B5E67AB2DA0, $44862B9C8FBBFD31,
    $B47CC8049D141365, $822C1B362B91C793, $4EB14655FB13DFD8,
    $1ECBBA0714E2A97B, $6143459D5CDE5F14, $53A8FBF1D5F0AC89,
    $97EA04D81C5E5B00, $622181A8D4FDB3F3, $E9BCD341572A1208,
    $1411258643CCE58A, $9144C5FEA4C6E0A4, $0D33D06565CF620F,
    $54A48D489F219CA1, $C43E5EAC6D63C821, $A9728B3A72770DAF,
    $D7934E7B20DF87EF, $E35503B61A3E86E5, $CAE321FBC819D504,
    $129A50B3AC60BFA6, $CD5E68EA7E9FB6C3, $B01C90199483B1C7,
    $3DE93CD5C295376C, $AED52EDF2AB9AD13, $2E60F512C0A07884,
    $BC3D86A3E36210C9, $35269D9B163951CE, $0C7D6E2AD0CDB5FA,
    $59E86297D87F5733, $298EF221898DB0E7, $55000029D1A5AA7E,
    $8BC08AE1B5061B45, $C2C31C2B6C92703A, $94CC596BAF25EF42,
    $0A1D73DB22540456, $04B6A0F9D9C4179A, $EFFDAFA2AE3D3C60,
    $F7C8075BB49496C4, $9CC5C7141D1CD4E3, $78BD1638218E5534,
    $B2F11568F850246A, $EDFABCFA9502BC29, $796CE5F2DA23051B,
    $AAE128B0DC93537C, $3A493DA0EE4B29AE, $B5DF6B2C416895D7,
    $FCABBD25122D7F37, $70810B58105DC4B1, $E10FDD37F7882A90,
    $524DCAB5518A3F5C, $3C9E85878451255B, $4029828119BD34E2,
    $74A05B6F5D3CECCB, $B610021542E13ECA, $0FF979D12F59E2AC,
    $6037DA27E4F9CC50, $5E92975A0DF1847D, $D66DE190D3E623FE,
    $5032D6B87B568048, $9A36B7CE8235216E, $80272A7A24F64B4A,
    $93EFED8B8C6916F7, $37DDBFF44CCE1555, $4B95DB5D4B99BD25,
    $92D3FDA169812FC0, $FB1A4A9A90660BB6, $730C196946A4B9B2,
    $81E289AA7F49DA68, $64669A0F83B1A05F, $27B3FF7D9644F48B,
    $CC6B615C8DB675B3, $674F20B9BCEBBE95, $6F31238275655982,
    $5AE488713E45CF05, $BF619F9954C21157, $EABAC46040A8EAE9,
    $454C6FE9F2C0C1CD, $419CF6496412691C, $D3DC3BEF265B0F70,
    $6D0E60F5C3578A9E),
   ($5B0E608526323C55, $1A46C1A9FA1B59F5, $A9E245A17C4C8FFA,
    $65CA5159DB2955D7, $05DB0A76CE35AFC2, $81EAC77EA9113D45,
    $528EF88AB6AC0A0D, $A09EA253597BE3FF, $430DDFB3AC48CD56,
    $C4B3A67AF45CE46F, $4ECECFD8FBE2D05E, $3EF56F10B39935F0,
    $0B22D6829CD619C6, $17FD460A74DF2069, $6CF8CC8E8510ED40,
    $D6C824BF3A6ECAA7, $61243D581A817049, $048BACB6BBC163A2,
    $D9A38AC27D44CC32, $7FDDFF5BAAF410AB, $AD6D495AA804824B,
    $E1A6A74F2D8C9F94, $D4F7851235DEE8E3, $FD4B7F886540D893,
    $247C20042AA4BFDA, $096EA1C517D1327C, $D56966B4361A6685,
    $277DA5C31221057D, $94D59893A43ACFF7, $64F0C51CCDC02281,
    $3D33BCC4FF6189DB, $E005CB184CE66AF1, $FF5CCD1D1DB99BEA,
    $B0B854A7FE42980F, $7BD46A6A718D4B9F, $D10FA8CC22A5FD8C,
    $D31484952BE4BD31, $C7FA975FCB243847, $4886ED1E5846C407,
    $28CDDB791EB70B04, $C2B00BE2F573417F, $5C9590452180F877,
    $7A6BDDFFF370EB00, $CE509E38D6D9D6A4, $EBEB0F00647FA702,
    $1DCC06CF76606F06, $E4D9F28BA286FF0A, $D85A305DC918C262,
    $475B1D8732225F54, $2D4FB51668CCB5FE, $A679B9D9D72BBA20,
    $53841C0D912D43A5, $3B7EAA48BF12A4E8, $781E0E47F22F1DDF,
    $EFF20CE60AB50973, $20D261D19DFFB742, $16A12B03062A2E39,
    $1960EB2239650495, $251C16FED50EB8B8, $9AC0C330F826016E,
    $ED152665953E7671, $02D63194A6369570, $5074F08394B1C987,
    $70BA598C90B25CE1, $794A15810B9742F6, $0D5925E9FCAF8C6C,
    $3067716CD868744E, $910AB077E8D7731B, $6A61BBDB5AC42F61,
    $93513EFBF0851567, $F494724B9E83E9D5, $E887E1985C09648D,
    $34B1D3C675370CFD, $DC35E433BC0D255D, $D0AAB84234131BE0,
    $08042A50B48B7EAF, $9997C4EE44A3AB35, $829A7B49201799D0,
    $263B8307B7C54441, $752F95F4FD6A6CA6, $927217402C08C6E5,
    $2A8AB754A795D9EE, $A442F7552F72943D, $2C31334E19781208,
    $4FA98D7CEAEE6291, $55C3862F665DB309, $BD0610175D53B1F3,
    $46FE6CB840413F27, $3FE03792DF0CFA59, $CFE700372EB85E8F,
    $A7BE29E7ADBCE118, $E544EE5CDE8431DD, $8A781B1B41F1873E,
    $A5C94C78A0D2F0E7, $39412E2877B60728, $A1265EF3AFC9A62C,
    $BCC2770C6A2506C5, $3AB66DD5DCE1CE12, $E65499D04A675B37,
    $7D8F523481BFD216, $0F6F64FCEC15F389, $74EFBE618B5B13C8,
    $ACDC82B714273E1D, $DD40BFE003199D17, $37E99257E7E061F8,
    $FA52626904775AAA, $8BBBF63A463D56F9, $F0013F1543A26E64,
    $A8307E9F879EC898, $CC4C27A4150177CC, $1B432F2CCA1D3348,
    $DE1D1F8F9F6FA013, $606602A047A7DDD6, $D237AB64CC1CB2C7,
    $9B938E7225FCD1D3, $EC4E03708E0FF476, $FEB2FBDA3D03C12D,
    $AE0BCED2EE43889A, $22CB8923EBFB4F43, $69360D013CF7396D,
    $855E3602D2D4E022, $073805BAD01F784C, $33E17A133852F546,
    $DF4874058AC7B638, $BA92B29C678AA14A, $0CE89FC76CFAADCD,
    $5F9D4E0908339E34, $F1AFE9291F5923B9, $6E3480F60F4A265F,
    $EEBF3A2AB29B841C, $E21938A88F91B4AD, $57DFEFF845C6D3C3,
    $2F006B0BF62CAAF2, $62F479EF6F75EE78, $11A55AD41C8916A9,
    $F229D29084FED453, $42F1C27B16B000E6, $2B1F76749823C074,
    $4B76ECA3C2745360, $8C98F463B91691BD, $14BCC93CF1ADE66A,
    $8885213E6D458397, $8E177DF0274D4711, $B49B73B5503F2951,
    $10168168C3F96B6B, $0E3D963B63CAB0AE, $8DFC4B5655A1DB14,
    $F789F1356E14DE5C, $683E68AF4E51DAC1, $C9A84F9D8D4B0FD9,
    $3691E03F52A0F9D1, $5ED86E46E1878E80, $3C711A0E99D07150,
    $5A0865B20C4E9310, $56FBFC1FE4F0682E, $EA8D5DE3105EDF9B,
    $71ABFDB12379187A, $2EB99DE1BEE77B9C, $21ECC0EA33CF4523,
    $59A4D7521805C7A1, $3896F5EB56AE7C72, $AA638F3DB18F75DC,
    $9F39358DABE9808E, $B7DEFA91C00B72AC, $6B5541FD62492D92,
    $6DC6DEE8F92E4D5B, $353F57ABC4BEEA7E, $735769D6DA5690CE,
    $0A234AA642391484, $F6F9508028F80D9D, $B8E319A27AB3F215,
    $31AD9C1151341A4D, $773C22A57BEF5805, $45C7561A07968633,
    $F913DA9E249DBE36, $DA652D9B78A64C68, $4C27A97F3BC334EF,
    $76621220E66B17F4, $967743899ACD7D0B, $F3EE5BCAE0ED6782,
    $409F753600C879FC, $06D09A39B5926DB6, $6F83AEB0317AC588,
    $01E6CA4A86381F21, $66FF3462D19F3025, $72207C24DDFD3BFB,
    $4AF6B6D3E2ECE2EB, $9C994DBEC7EA08DE, $49ACE597B09A8BC4,
    $B38C4766CF0797BA, $131B9373C57C2A75, $B1822CCE61931E58,
    $9D7555B909BA1C0C, $127FAFDD937D11D2, $29DA3BADC66D92E4,
    $A2C1D57154C2ECBC, $58C5134D82F6FE24, $1C3AE3515B62274F,
    $E907C82E01CB8126, $F8ED091913E37FCB, $3249D8F9C80046C9,
    $80CF9BEDE388FB63, $1881539A116CF19E, $5103F3F76BD52457,
    $15B7E6F5AE47F7A8, $DBD7C6DED47E9CCF, $44E55C410228BB1A,
    $B647D4255EDB4E99, $5D11882BB8AAFC30, $F5098BBB29D3212A,
    $8FB5EA14E90296B3, $677B942157DD025A, $FB58E7C0A390ACB5,
    $89D3674C83BD4A01, $9E2DA4DF4BF3B93B, $FCC41E328CAB4829,
    $03F38C96BA582C52, $CAD1BDBD7FD85DB2, $BBB442C16082AE83,
    $B95FE86BA5DA9AB0, $B22E04673771A93F, $845358C9493152D8,
    $BE2A488697B4541E, $95A2DC2DD38E6966, $C02C11AC923C852B,
    $2388B1990DF2A87B, $7C8008FA1B4F37BE, $1F70D0C84D54E503,
    $5490ADEC7ECE57D4, $002B3C27D9063A3A, $7EAEA3848030A2BF,
    $C602326DED2003C0, $83A7287D69A94086, $C57A5FCB30F57A8A,
    $B56844E479EBE779, $A373B40F05DCBCE9, $D71A786E88570EE2,
    $879CBACDBDE8F6A0, $976AD1BCC164A32F, $AB21E25E9666D78B,
    $901063AAE5E5C33C, $9818B34448698D90, $E36487AE3E1E8ABB,
    $AFBDF931893BDCB4, $6345A0DC5FBBD519, $8628FE269B9465CA,
    $1E5D01603F9C51EC, $4DE44006A15049B7, $BF6C70E5F776CBB1,
    $411218F2EF552BED, $CB0C0708705A36A3, $E74D14754F986044,
    $CD56D9430EA8280E, $C12591D7535F5065, $C83223F1720AEF96,
    $C3A0396F7363A51F));

  SHA_256K: array[0..63] of LongWord = (
    $428A2F98,$71374491,$B5C0FBCF,$E9B5DBA5,$3956C25B,$59F111F1,$923F82A4,$AB1C5ED5,
    $D807AA98,$12835B01,$243185BE,$550C7DC3,$72BE5D74,$80DEB1FE,$9BDC06A7,$C19BF174,
    $E49B69C1,$EFBE4786,$0FC19DC6,$240CA1CC,$2DE92C6F,$4A7484AA,$5CB0A9DC,$76F988DA,
    $983E5152,$A831C66D,$B00327C8,$BF597FC7,$C6E00BF3,$D5A79147,$06CA6351,$14292967,
    $27B70A85,$2E1B2138,$4D2C6DFC,$53380D13,$650A7354,$766A0ABB,$81C2C92E,$92722C85,
    $A2BFE8A1,$A81A664B,$C24B8B70,$C76C51A3,$D192E819,$D6990624,$F40E3585,$106AA070,
    $19A4C116,$1E376C08,$2748774C,$34B0BCB5,$391C0CB3,$4ED8AA4A,$5B9CCA4F,$682E6FF3,
    $748F82EE,$78A5636F,$84C87814,$8CC70208,$90BEFFFA,$A4506CEB,$BEF9A3F7,$C67178F2);

  SHA_512K: array[0..79] of Int64 = (
    $428A2F98D728AE22,$7137449123EF65CD,$B5C0FBCFEC4D3B2F,$E9B5DBA58189DBBC,
    $3956C25BF348B538,$59F111F1B605D019,$923F82A4AF194F9B,$AB1C5ED5DA6D8118,
    $D807AA98A3030242,$12835B0145706FBE,$243185BE4EE4B28C,$550C7DC3D5FFB4E2,
    $72BE5D74F27B896F,$80DEB1FE3B1696B1,$9BDC06A725C71235,$C19BF174CF692694,
    $E49B69C19EF14AD2,$EFBE4786384F25E3,$0FC19DC68B8CD5B5,$240CA1CC77AC9C65,
    $2DE92C6F592B0275,$4A7484AA6EA6E483,$5CB0A9DCBD41FBD4,$76F988DA831153B5,
    $983E5152EE66DFAB,$A831C66D2DB43210,$B00327C898FB213F,$BF597FC7BEEF0EE4,
    $C6E00BF33DA88FC2,$D5A79147930AA725,$06CA6351E003826F,$142929670A0E6E70,
    $27B70A8546D22FFC,$2E1B21385C26C926,$4D2C6DFC5AC42AED,$53380D139D95B3DF,
    $650A73548BAF63DE,$766A0ABB3C77B2A8,$81C2C92E47EDAEE6,$92722C851482353B,
    $A2BFE8A14CF10364,$A81A664BBC423001,$C24B8B70D0F89791,$C76C51A30654BE30,
    $D192E819D6EF5218,$D69906245565A910,$F40E35855771202A,$106AA07032BBD1B8,
    $19A4C116B8D2D0C8,$1E376C085141AB53,$2748774CDF8EEB99,$34B0BCB5E19B48A8,
    $391C0CB3C5C95A63,$4ED8AA4AE3418ACB,$5B9CCA4F7763E373,$682E6FF3D6B2B8A3,
    $748F82EE5DEFB2FC,$78A5636F43172F60,$84C87814A1F0AB72,$8CC702081A6439EC,
    $90BEFFFA23631E28,$A4506CEBDE82BDE9,$BEF9A3F7B2C67915,$C67178F2E372532B,
    $CA273ECEEA26619C,$D186B8C721C0C207,$EADA7DD6CDE0EB1E,$F57D4F7FEE6ED178,
    $06F067AA72176FBA,$0A637DC5A2C898A6,$113F9804BEF90DAE,$1B710B35131C471B,
    $28DB77F523047D84,$32CAAB7B40C72493,$3C9EBE0A15C9BEBC,$431D67C49C100D4C,
    $4CC5D4BECB3E42B6,$597F299CFC657E2A,$5FCB6FAB3AD6FAEC,$6C44198C4A475817);

  Whirlpool_Rounds = 10;
  Whirlpool_RC_U: array[0..Whirlpool_Rounds * 2 -1] of LongWord = (
    $2BEBD068, $E46A9D48, $8156A3E3, $9E85F17D, $CA788E2C, $D561A917, $3C8C0B5D, $42225177,
    $8041543F, $18B386CC, $6206572E, $6BD136F4, $1075651B, $F92649DA, $BAE766CB, $AB5250AE,
    $730DF005, $FE20043B, $5FB4F5DD, $A0C0B50A);

  Whirlpool_C_U: array[0..7, 0..511] of LongWord = (
   ($68B86868, $D50F67D5, $D06DD0D0, $B71ECEB7, $EB20EBEB, $60E00B60, $2B7D2B2B, $876E4587,
    $48D84848, $75327A75, $9DBA9D9D, $D3019CD3, $6ABE6A6A, $DF1D77DF, $E431E4E4, $53977353,
    $E338E3E3, $48A84B48, $A3F8A3A3, $15D27115, $56FA5656, $13DC8A13, $819E8181, $BFFD7CBF,
    $7D877D7D, $94B2CF94, $F10EF1F1, $122ADB12, $85928585, $ABD95CAB, $9EBF9E9E, $DC1A84DC,
    $2C742C2C, $9C517D9C, $8E8F8E8E, $8C8A048C, $78887878, $859FE785, $CA43CACA, $C5D41EC5,
    $17391717, $4BAFB84B, $A9E6A9A9, $37882137, $61A36161, $F84E2FF8, $D562D5D5, $A633E6A6,
    $5DE75D5D, $348FD234, $0B1D0B0B, $27535827, $8C898C8C, $86981486, $3C443C3C, $CCC1FDCC,
    $77997777, $B6E89FB6, $51F35151, $08E3B208, $22662222, $AA2F0DAA, $42C64242, $57682A57,
    $3F413F3F, $C3DAE5C3, $54FC5454, $19CE9A19, $41C34141, $58733258, $809D8080, $BAF474BA,
    $CC49CCCC, $DBE22EDB, $86978686, $A4C244A4, $B3C8B3B3, $4542F145, $18281818, $78D8C078,
    $2E722E2E, $96436D96, $57F95757, $16D58216, $060A0606, $1E36301E, $62A66262, $F75537F7,
    $F401F4F4, $0307F303, $365A3636, $EE9BADEE, $D16ED1D1, $B217C6B2, $6BBD6B6B, $DA147FDA,
    $1B2D1B1B, $77C3D877, $65AF6565, $EC6A0FEC, $759F7575, $BCFA8FBC, $10301010, $50908050,
    $DA73DADA, $95449E95, $49DB4949, $703B7270, $266A2626, $BE0B2DBE, $F916F9F9, $3A629B3A,
    $CB40CBCB, $C0DD16C0, $66AA6666, $E37117E3, $E734E7E7, $5C8C6B5C, $BAD3BABA, $6803B968,
    $AEEFAEAE, $2CB7192C, $50F05050, $0DEABA0D, $52F65252, $07F8AA07, $ABE0ABAB, $3D9A313D,
    $050F0505, $112D2811, $F00DF0F0, $1723D317, $0D170D0D, $39656839, $73957373, $A2CCBFA2,
    $3B4D3B3B, $D7FEC5D7, $040C0404, $14242014, $20602020, $A03D1DA0, $FE1FFEFE, $215DA321,
    $DD7ADDDD, $8E7BA68E, $F502F5F5, $060EFB06, $B4C1B4B4, $5E7DC95E, $5FE15F5F, $3E9DC23E,
    $0A1E0A0A, $225A5022, $B5C2B5B5, $5B74C15B, $C05DC0C0, $E78E4EE7, $A0FDA0A0, $1AC9691A,
    $71937171, $A8DEAFA8, $A5F2A5A5, $0BE4410B, $2D772D2D, $99587599, $60A06060, $FD4727FD,
    $72967272, $A7C5B7A7, $93A89393, $E57FECE5, $394B3939, $DDECD5DD, $08180808, $28484028,
    $83988383, $B5EF6CB5, $21632121, $A53415A5, $5CE45C5C, $3186DA31, $87948787, $A1CB4CA1,
    $B1CEB1B1, $4F50E14F, $E03DE0E0, $47B35347, $00000000, $00000000, $C358C3C3, $E89556E8,
    $12361212, $5A82905A, $91AE9191, $EF6DFCEF, $8A838A8A, $98AE2498, $02060202, $0A12100A,
    $1C241C1C, $6CFCE06C, $E637E6E6, $59856359, $45CF4545, $4C57124C, $C25BC2C2, $ED9C5EED,
    $C451C4C4, $F3AA6EF3, $FD1AFDFD, $2E46BB2E, $BFDCBFBF, $792E9179, $44CC4444, $495E1A49,
    $A1FEA1A1, $1FC0611F, $4CD44C4C, $61165A61, $33553333, $FFB685FF, $C552C5C5, $F6A366F6,
    $84918484, $AED054AE, $23652323, $AF2605AF, $7C847C7C, $91BBC791, $B0CDB0B0, $4A59E94A,
    $256F2525, $B11035B1, $153F1515, $41BDA841, $355F3535, $E180B5E1, $69BB6969, $D0066FD0,
    $FF1CFFFF, $2454AB24, $94A19494, $FE40D4FE, $4DD74D4D, $641F5264, $70907070, $ADD7A7AD,
    $A2FBA2A2, $10DB7910, $AFECAFAF, $29BE1129, $CD4ACDCD, $DEEB26DE, $D667D6D6, $A928FEA9,
    $6CB46C6C, $C12B47C1, $B7C4B7B7, $5166D151, $F815F8F8, $3F6B933F, $091B0909, $2D41482D,
    $F308F3F3, $1838CB18, $67A96767, $E6781FE6, $A4F1A4A4, $0EED490E, $EA23EAEA, $65E90365,
    $EC29ECEC, $7BDF337B, $B6C7B6B6, $546FD954, $D461D4D4, $A33AEEA3, $D26BD2D2, $BD0CDEBD,
    $143C1414, $44B4A044, $1E221E1E, $66EEF066, $E13EE1E1, $42BA5B42, $246C2424, $B4193DB4,
    $38483838, $D8E5DDD8, $C657C6C6, $F9B87EF9, $DB70DBDB, $904D9690, $4BDD4B4B, $7A29627A,
    $7A8E7A7A, $8F8DF78F, $3A4E3A3A, $D2F7CDD2, $DE7FDEDE, $8160BE81, $5EE25E5E, $3B94CA3B,
    $DF7CDFDF, $8469B684, $95A29595, $FB49DCFB, $FC19FCFC, $2B4FB32B, $AAE3AAAA, $38933938,
    $D764D7D7, $AC21F6AC, $CE4FCECE, $D1F03ED1, $07090707, $1B3F381B, $0F110F0F, $33777833,
    $3D473D3D, $C9C8F5C9, $58E85858, $25A2FA25, $9AB39A9A, $C83EA4C8, $98B59898, $C22CB4C2,
    $9CB99C9C, $D60894D6, $F20BF2F2, $1D31C31D, $A7F4A7A7, $01F65101, $11331111, $55998855,
    $7E827E7E, $9BA9D79B, $8B808B8B, $9DA72C9D, $43C54343, $52612252, $03050303, $0F1B180F,
    $E23BE2E2, $4DA1434D, $DC79DCDC, $8B72AE8B, $E532E5E5, $569E7B56, $B2CBB2B2, $404BF940,
    $4ED24E4E, $6B044A6B, $C754C7C7, $FCB176FC, $6DB76D6D, $C4224FC4, $E926E9E9, $6AF21B6A,
    $27692727, $BB0225BB, $40C04040, $5D7A3A5D, $D875D8D8, $9F568E9F, $37593737, $EB92A5EB,
    $92AB9292, $E076E4E0, $8F8C8F8F, $89830C89, $01030101, $05090805, $1D271D1D, $69F5E869,
    $53F55353, $02F1A202, $3E423E3E, $C6D3EDC6, $59EB5959, $20ABF220, $C15EC1C1, $E28746E2,
    $4FD14F4F, $6E0D426E, $32563232, $FABF8DFA, $163A1616, $4EA6B04E, $FA13FAFA, $35798335,
    $749C7474, $B9F387B9, $FB10FBFB, $30708B30, $63A56363, $F25C3FF2, $9FBC9F9F, $D9138CD9,
    $345C3434, $E489BDE4, $1A2E1A1A, $72CAD072, $2A7E2A2A, $82674D82, $5AEE5A5A, $2FB0EA2F,
    $8D8A8D8D, $83911C83, $C946C9C9, $CACF06CA, $CF4CCFCF, $D4F936D4, $F607F6F6, $0915E309,
    $90AD9090, $EA64F4EA, $28782828, $88755D88, $88858888, $92BC3492, $9BB09B9B, $CD37ACCD,
    $31533131, $F5A495F5, $0E120E0E, $367E7036, $BDDABDBD, $733C8173, $4ADE4A4A, $7F206A7F,
    $E825E8E8, $6FFB136F, $96A79696, $F452C4F4, $A6F7A6A6, $04FF5904, $0C140C0C, $3C6C603C,
    $C845C8C8, $CFC60ECF, $798B7979, $8096EF80, $BCD9BCBC, $76358976, $BEDFBEBE, $7C27997C,
    $EF2CEFEF, $74C42B74, $6EB26E6E, $CB3957CB, $46CA4646, $434C0A43, $97A49797, $F15BCCF1,
    $5BED5B5B, $2AB9E22A, $ED2AEDED, $7ED63B7E, $192B1919, $7DD1C87D, $D976D9D9, $9A5F869A,
    $ACE9ACAC, $26A50926, $99B69999, $C725BCC7, $A8E5A8A8, $32812932, $297B2929, $8D7C558D,
    $64AC6464, $E96307E9, $1F211F1F, $63E7F863, $ADEAADAD, $23AC0123, $55FF5555, $1CC7921C,
    $13351313, $5F8B985F, $BBD0BBBB, $6D0AB16D, $F704F7F7, $0C1CEB0C, $6FB16F6F, $CE305FCE,
    $B9D6B9B9, $6718A167, $47C94747, $46450246, $2F712F2F, $934A6593, $EE2FEEEE, $71CD2371,
    $B8D5B8B8, $6211A962, $7B8D7B7B, $8A84FF8A, $89868989, $97B53C97, $30503030, $F0AD9DF0,
    $D368D3D3, $B805D6B8, $7F817F7F, $9EA0DF9E, $769A7676, $B3E197B3, $829B8282, $B0E664B0),
   ($B86868D5, $0F67D568, $6DD0D0B7, $1ECEB7D0, $20EBEB60, $E00B60EB, $7D2B2B87, $6E45872B,
    $D8484875, $327A7548, $BA9D9DD3, $019CD39D, $BE6A6ADF, $1D77DF6A, $31E4E453, $977353E4,
    $38E3E348, $A84B48E3, $F8A3A315, $D27115A3, $FA565613, $DC8A1356, $9E8181BF, $FD7CBF81,
    $877D7D94, $B2CF947D, $0EF1F112, $2ADB12F1, $928585AB, $D95CAB85, $BF9E9EDC, $1A84DC9E,
    $742C2C9C, $517D9C2C, $8F8E8E8C, $8A048C8E, $88787885, $9FE78578, $43CACAC5, $D41EC5CA,
    $3917174B, $AFB84B17, $E6A9A937, $882137A9, $A36161F8, $4E2FF861, $62D5D5A6, $33E6A6D5,
    $E75D5D34, $8FD2345D, $1D0B0B27, $5358270B, $898C8C86, $9814868C, $443C3CCC, $C1FDCC3C,
    $997777B6, $E89FB677, $F3515108, $E3B20851, $662222AA, $2F0DAA22, $C6424257, $682A5742,
    $413F3FC3, $DAE5C33F, $FC545419, $CE9A1954, $C3414158, $73325841, $9D8080BA, $F474BA80,
    $49CCCCDB, $E22EDBCC, $978686A4, $C244A486, $C8B3B345, $42F145B3, $28181878, $D8C07818,
    $722E2E96, $436D962E, $F9575716, $D5821657, $0A06061E, $36301E06, $A66262F7, $5537F762,
    $01F4F403, $07F303F4, $5A3636EE, $9BADEE36, $6ED1D1B2, $17C6B2D1, $BD6B6BDA, $147FDA6B,
    $2D1B1B77, $C3D8771B, $AF6565EC, $6A0FEC65, $9F7575BC, $FA8FBC75, $30101050, $90805010,
    $73DADA95, $449E95DA, $DB494970, $3B727049, $6A2626BE, $0B2DBE26, $16F9F93A, $629B3AF9,
    $40CBCBC0, $DD16C0CB, $AA6666E3, $7117E366, $34E7E75C, $8C6B5CE7, $D3BABA68, $03B968BA,
    $EFAEAE2C, $B7192CAE, $F050500D, $EABA0D50, $F6525207, $F8AA0752, $E0ABAB3D, $9A313DAB,
    $0F050511, $2D281105, $0DF0F017, $23D317F0, $170D0D39, $6568390D, $957373A2, $CCBFA273,
    $4D3B3BD7, $FEC5D73B, $0C040414, $24201404, $602020A0, $3D1DA020, $1FFEFE21, $5DA321FE,
    $7ADDDD8E, $7BA68EDD, $02F5F506, $0EFB06F5, $C1B4B45E, $7DC95EB4, $E15F5F3E, $9DC23E5F,
    $1E0A0A22, $5A50220A, $C2B5B55B, $74C15BB5, $5DC0C0E7, $8E4EE7C0, $FDA0A01A, $C9691AA0,
    $937171A8, $DEAFA871, $F2A5A50B, $E4410BA5, $772D2D99, $5875992D, $A06060FD, $4727FD60,
    $967272A7, $C5B7A772, $A89393E5, $7FECE593, $4B3939DD, $ECD5DD39, $18080828, $48402808,
    $988383B5, $EF6CB583, $632121A5, $3415A521, $E45C5C31, $86DA315C, $948787A1, $CB4CA187,
    $CEB1B14F, $50E14FB1, $3DE0E047, $B35347E0, $00000000, $00000000, $58C3C3E8, $9556E8C3,
    $3612125A, $82905A12, $AE9191EF, $6DFCEF91, $838A8A98, $AE24988A, $0602020A, $12100A02,
    $241C1C6C, $FCE06C1C, $37E6E659, $856359E6, $CF45454C, $57124C45, $5BC2C2ED, $9C5EEDC2,
    $51C4C4F3, $AA6EF3C4, $1AFDFD2E, $46BB2EFD, $DCBFBF79, $2E9179BF, $CC444449, $5E1A4944,
    $FEA1A11F, $C0611FA1, $D44C4C61, $165A614C, $553333FF, $B685FF33, $52C5C5F6, $A366F6C5,
    $918484AE, $D054AE84, $652323AF, $2605AF23, $847C7C91, $BBC7917C, $CDB0B04A, $59E94AB0,
    $6F2525B1, $1035B125, $3F151541, $BDA84115, $5F3535E1, $80B5E135, $BB6969D0, $066FD069,
    $1CFFFF24, $54AB24FF, $A19494FE, $40D4FE94, $D74D4D64, $1F52644D, $907070AD, $D7A7AD70,
    $FBA2A210, $DB7910A2, $ECAFAF29, $BE1129AF, $4ACDCDDE, $EB26DECD, $67D6D6A9, $28FEA9D6,
    $B46C6CC1, $2B47C16C, $C4B7B751, $66D151B7, $15F8F83F, $6B933FF8, $1B09092D, $41482D09,
    $08F3F318, $38CB18F3, $A96767E6, $781FE667, $F1A4A40E, $ED490EA4, $23EAEA65, $E90365EA,
    $29ECEC7B, $DF337BEC, $C7B6B654, $6FD954B6, $61D4D4A3, $3AEEA3D4, $6BD2D2BD, $0CDEBDD2,
    $3C141444, $B4A04414, $221E1E66, $EEF0661E, $3EE1E142, $BA5B42E1, $6C2424B4, $193DB424,
    $483838D8, $E5DDD838, $57C6C6F9, $B87EF9C6, $70DBDB90, $4D9690DB, $DD4B4B7A, $29627A4B,
    $8E7A7A8F, $8DF78F7A, $4E3A3AD2, $F7CDD23A, $7FDEDE81, $60BE81DE, $E25E5E3B, $94CA3B5E,
    $7CDFDF84, $69B684DF, $A29595FB, $49DCFB95, $19FCFC2B, $4FB32BFC, $E3AAAA38, $933938AA,
    $64D7D7AC, $21F6ACD7, $4FCECED1, $F03ED1CE, $0907071B, $3F381B07, $110F0F33, $7778330F,
    $473D3DC9, $C8F5C93D, $E8585825, $A2FA2558, $B39A9AC8, $3EA4C89A, $B59898C2, $2CB4C298,
    $B99C9CD6, $0894D69C, $0BF2F21D, $31C31DF2, $F4A7A701, $F65101A7, $33111155, $99885511,
    $827E7E9B, $A9D79B7E, $808B8B9D, $A72C9D8B, $C5434352, $61225243, $0503030F, $1B180F03,
    $3BE2E24D, $A1434DE2, $79DCDC8B, $72AE8BDC, $32E5E556, $9E7B56E5, $CBB2B240, $4BF940B2,
    $D24E4E6B, $044A6B4E, $54C7C7FC, $B176FCC7, $B76D6DC4, $224FC46D, $26E9E96A, $F21B6AE9,
    $692727BB, $0225BB27, $C040405D, $7A3A5D40, $75D8D89F, $568E9FD8, $593737EB, $92A5EB37,
    $AB9292E0, $76E4E092, $8C8F8F89, $830C898F, $03010105, $09080501, $271D1D69, $F5E8691D,
    $F5535302, $F1A20253, $423E3EC6, $D3EDC63E, $EB595920, $ABF22059, $5EC1C1E2, $8746E2C1,
    $D14F4F6E, $0D426E4F, $563232FA, $BF8DFA32, $3A16164E, $A6B04E16, $13FAFA35, $798335FA,
    $9C7474B9, $F387B974, $10FBFB30, $708B30FB, $A56363F2, $5C3FF263, $BC9F9FD9, $138CD99F,
    $5C3434E4, $89BDE434, $2E1A1A72, $CAD0721A, $7E2A2A82, $674D822A, $EE5A5A2F, $B0EA2F5A,
    $8A8D8D83, $911C838D, $46C9C9CA, $CF06CAC9, $4CCFCFD4, $F936D4CF, $07F6F609, $15E309F6,
    $AD9090EA, $64F4EA90, $78282888, $755D8828, $85888892, $BC349288, $B09B9BCD, $37ACCD9B,
    $533131F5, $A495F531, $120E0E36, $7E70360E, $DABDBD73, $3C8173BD, $DE4A4A7F, $206A7F4A,
    $25E8E86F, $FB136FE8, $A79696F4, $52C4F496, $F7A6A604, $FF5904A6, $140C0C3C, $6C603C0C,
    $45C8C8CF, $C60ECFC8, $8B797980, $96EF8079, $D9BCBC76, $358976BC, $DFBEBE7C, $27997CBE,
    $2CEFEF74, $C42B74EF, $B26E6ECB, $3957CB6E, $CA464643, $4C0A4346, $A49797F1, $5BCCF197,
    $ED5B5B2A, $B9E22A5B, $2AEDED7E, $D63B7EED, $2B19197D, $D1C87D19, $76D9D99A, $5F869AD9,
    $E9ACAC26, $A50926AC, $B69999C7, $25BCC799, $E5A8A832, $812932A8, $7B29298D, $7C558D29,
    $AC6464E9, $6307E964, $211F1F63, $E7F8631F, $EAADAD23, $AC0123AD, $FF55551C, $C7921C55,
    $3513135F, $8B985F13, $D0BBBB6D, $0AB16DBB, $04F7F70C, $1CEB0CF7, $B16F6FCE, $305FCE6F,
    $D6B9B967, $18A167B9, $C9474746, $45024647, $712F2F93, $4A65932F, $2FEEEE71, $CD2371EE,
    $D5B8B862, $11A962B8, $8D7B7B8A, $84FF8A7B, $86898997, $B53C9789, $503030F0, $AD9DF030,
    $68D3D3B8, $05D6B8D3, $817F7F9E, $A0DF9E7F, $9A7676B3, $E197B376, $9B8282B0, $E664B082),
   ($6868D50F, $67D568B8, $D0D0B71E, $CEB7D06D, $EBEB60E0, $0B60EB20, $2B2B876E, $45872B7D,
    $48487532, $7A7548D8, $9D9DD301, $9CD39DBA, $6A6ADF1D, $77DF6ABE, $E4E45397, $7353E431,
    $E3E348A8, $4B48E338, $A3A315D2, $7115A3F8, $565613DC, $8A1356FA, $8181BFFD, $7CBF819E,
    $7D7D94B2, $CF947D87, $F1F1122A, $DB12F10E, $8585ABD9, $5CAB8592, $9E9EDC1A, $84DC9EBF,
    $2C2C9C51, $7D9C2C74, $8E8E8C8A, $048C8E8F, $7878859F, $E7857888, $CACAC5D4, $1EC5CA43,
    $17174BAF, $B84B1739, $A9A93788, $2137A9E6, $6161F84E, $2FF861A3, $D5D5A633, $E6A6D562,
    $5D5D348F, $D2345DE7, $0B0B2753, $58270B1D, $8C8C8698, $14868C89, $3C3CCCC1, $FDCC3C44,
    $7777B6E8, $9FB67799, $515108E3, $B20851F3, $2222AA2F, $0DAA2266, $42425768, $2A5742C6,
    $3F3FC3DA, $E5C33F41, $545419CE, $9A1954FC, $41415873, $325841C3, $8080BAF4, $74BA809D,
    $CCCCDBE2, $2EDBCC49, $8686A4C2, $44A48697, $B3B34542, $F145B3C8, $181878D8, $C0781828,
    $2E2E9643, $6D962E72, $575716D5, $821657F9, $06061E36, $301E060A, $6262F755, $37F762A6,
    $F4F40307, $F303F401, $3636EE9B, $ADEE365A, $D1D1B217, $C6B2D16E, $6B6BDA14, $7FDA6BBD,
    $1B1B77C3, $D8771B2D, $6565EC6A, $0FEC65AF, $7575BCFA, $8FBC759F, $10105090, $80501030,
    $DADA9544, $9E95DA73, $4949703B, $727049DB, $2626BE0B, $2DBE266A, $F9F93A62, $9B3AF916,
    $CBCBC0DD, $16C0CB40, $6666E371, $17E366AA, $E7E75C8C, $6B5CE734, $BABA6803, $B968BAD3,
    $AEAE2CB7, $192CAEEF, $50500DEA, $BA0D50F0, $525207F8, $AA0752F6, $ABAB3D9A, $313DABE0,
    $0505112D, $2811050F, $F0F01723, $D317F00D, $0D0D3965, $68390D17, $7373A2CC, $BFA27395,
    $3B3BD7FE, $C5D73B4D, $04041424, $2014040C, $2020A03D, $1DA02060, $FEFE215D, $A321FE1F,
    $DDDD8E7B, $A68EDD7A, $F5F5060E, $FB06F502, $B4B45E7D, $C95EB4C1, $5F5F3E9D, $C23E5FE1,
    $0A0A225A, $50220A1E, $B5B55B74, $C15BB5C2, $C0C0E78E, $4EE7C05D, $A0A01AC9, $691AA0FD,
    $7171A8DE, $AFA87193, $A5A50BE4, $410BA5F2, $2D2D9958, $75992D77, $6060FD47, $27FD60A0,
    $7272A7C5, $B7A77296, $9393E57F, $ECE593A8, $3939DDEC, $D5DD394B, $08082848, $40280818,
    $8383B5EF, $6CB58398, $2121A534, $15A52163, $5C5C3186, $DA315CE4, $8787A1CB, $4CA18794,
    $B1B14F50, $E14FB1CE, $E0E047B3, $5347E03D, $00000000, $00000000, $C3C3E895, $56E8C358,
    $12125A82, $905A1236, $9191EF6D, $FCEF91AE, $8A8A98AE, $24988A83, $02020A12, $100A0206,
    $1C1C6CFC, $E06C1C24, $E6E65985, $6359E637, $45454C57, $124C45CF, $C2C2ED9C, $5EEDC25B,
    $C4C4F3AA, $6EF3C451, $FDFD2E46, $BB2EFD1A, $BFBF792E, $9179BFDC, $4444495E, $1A4944CC,
    $A1A11FC0, $611FA1FE, $4C4C6116, $5A614CD4, $3333FFB6, $85FF3355, $C5C5F6A3, $66F6C552,
    $8484AED0, $54AE8491, $2323AF26, $05AF2365, $7C7C91BB, $C7917C84, $B0B04A59, $E94AB0CD,
    $2525B110, $35B1256F, $151541BD, $A841153F, $3535E180, $B5E1355F, $6969D006, $6FD069BB,
    $FFFF2454, $AB24FF1C, $9494FE40, $D4FE94A1, $4D4D641F, $52644DD7, $7070ADD7, $A7AD7090,
    $A2A210DB, $7910A2FB, $AFAF29BE, $1129AFEC, $CDCDDEEB, $26DECD4A, $D6D6A928, $FEA9D667,
    $6C6CC12B, $47C16CB4, $B7B75166, $D151B7C4, $F8F83F6B, $933FF815, $09092D41, $482D091B,
    $F3F31838, $CB18F308, $6767E678, $1FE667A9, $A4A40EED, $490EA4F1, $EAEA65E9, $0365EA23,
    $ECEC7BDF, $337BEC29, $B6B6546F, $D954B6C7, $D4D4A33A, $EEA3D461, $D2D2BD0C, $DEBDD26B,
    $141444B4, $A044143C, $1E1E66EE, $F0661E22, $E1E142BA, $5B42E13E, $2424B419, $3DB4246C,
    $3838D8E5, $DDD83848, $C6C6F9B8, $7EF9C657, $DBDB904D, $9690DB70, $4B4B7A29, $627A4BDD,
    $7A7A8F8D, $F78F7A8E, $3A3AD2F7, $CDD23A4E, $DEDE8160, $BE81DE7F, $5E5E3B94, $CA3B5EE2,
    $DFDF8469, $B684DF7C, $9595FB49, $DCFB95A2, $FCFC2B4F, $B32BFC19, $AAAA3893, $3938AAE3,
    $D7D7AC21, $F6ACD764, $CECED1F0, $3ED1CE4F, $07071B3F, $381B0709, $0F0F3377, $78330F11,
    $3D3DC9C8, $F5C93D47, $585825A2, $FA2558E8, $9A9AC83E, $A4C89AB3, $9898C22C, $B4C298B5,
    $9C9CD608, $94D69CB9, $F2F21D31, $C31DF20B, $A7A701F6, $5101A7F4, $11115599, $88551133,
    $7E7E9BA9, $D79B7E82, $8B8B9DA7, $2C9D8B80, $43435261, $225243C5, $03030F1B, $180F0305,
    $E2E24DA1, $434DE23B, $DCDC8B72, $AE8BDC79, $E5E5569E, $7B56E532, $B2B2404B, $F940B2CB,
    $4E4E6B04, $4A6B4ED2, $C7C7FCB1, $76FCC754, $6D6DC422, $4FC46DB7, $E9E96AF2, $1B6AE926,
    $2727BB02, $25BB2769, $40405D7A, $3A5D40C0, $D8D89F56, $8E9FD875, $3737EB92, $A5EB3759,
    $9292E076, $E4E092AB, $8F8F8983, $0C898F8C, $01010509, $08050103, $1D1D69F5, $E8691D27,
    $535302F1, $A20253F5, $3E3EC6D3, $EDC63E42, $595920AB, $F22059EB, $C1C1E287, $46E2C15E,
    $4F4F6E0D, $426E4FD1, $3232FABF, $8DFA3256, $16164EA6, $B04E163A, $FAFA3579, $8335FA13,
    $7474B9F3, $87B9749C, $FBFB3070, $8B30FB10, $6363F25C, $3FF263A5, $9F9FD913, $8CD99FBC,
    $3434E489, $BDE4345C, $1A1A72CA, $D0721A2E, $2A2A8267, $4D822A7E, $5A5A2FB0, $EA2F5AEE,
    $8D8D8391, $1C838D8A, $C9C9CACF, $06CAC946, $CFCFD4F9, $36D4CF4C, $F6F60915, $E309F607,
    $9090EA64, $F4EA90AD, $28288875, $5D882878, $888892BC, $34928885, $9B9BCD37, $ACCD9BB0,
    $3131F5A4, $95F53153, $0E0E367E, $70360E12, $BDBD733C, $8173BDDA, $4A4A7F20, $6A7F4ADE,
    $E8E86FFB, $136FE825, $9696F452, $C4F496A7, $A6A604FF, $5904A6F7, $0C0C3C6C, $603C0C14,
    $C8C8CFC6, $0ECFC845, $79798096, $EF80798B, $BCBC7635, $8976BCD9, $BEBE7C27, $997CBEDF,
    $EFEF74C4, $2B74EF2C, $6E6ECB39, $57CB6EB2, $4646434C, $0A4346CA, $9797F15B, $CCF197A4,
    $5B5B2AB9, $E22A5BED, $EDED7ED6, $3B7EED2A, $19197DD1, $C87D192B, $D9D99A5F, $869AD976,
    $ACAC26A5, $0926ACE9, $9999C725, $BCC799B6, $A8A83281, $2932A8E5, $29298D7C, $558D297B,
    $6464E963, $07E964AC, $1F1F63E7, $F8631F21, $ADAD23AC, $0123ADEA, $55551CC7, $921C55FF,
    $13135F8B, $985F1335, $BBBB6D0A, $B16DBBD0, $F7F70C1C, $EB0CF704, $6F6FCE30, $5FCE6FB1,
    $B9B96718, $A167B9D6, $47474645, $024647C9, $2F2F934A, $65932F71, $EEEE71CD, $2371EE2F,
    $B8B86211, $A962B8D5, $7B7B8A84, $FF8A7B8D, $898997B5, $3C978986, $3030F0AD, $9DF03050,
    $D3D3B805, $D6B8D368, $7F7F9EA0, $DF9E7F81, $7676B3E1, $97B3769A, $8282B0E6, $64B0829B),
   ($68D50F67, $D568B868, $D0B71ECE, $B7D06DD0, $EB60E00B, $60EB20EB, $2B876E45, $872B7D2B,
    $4875327A, $7548D848, $9DD3019C, $D39DBA9D, $6ADF1D77, $DF6ABE6A, $E4539773, $53E431E4,
    $E348A84B, $48E338E3, $A315D271, $15A3F8A3, $5613DC8A, $1356FA56, $81BFFD7C, $BF819E81,
    $7D94B2CF, $947D877D, $F1122ADB, $12F10EF1, $85ABD95C, $AB859285, $9EDC1A84, $DC9EBF9E,
    $2C9C517D, $9C2C742C, $8E8C8A04, $8C8E8F8E, $78859FE7, $85788878, $CAC5D41E, $C5CA43CA,
    $174BAFB8, $4B173917, $A9378821, $37A9E6A9, $61F84E2F, $F861A361, $D5A633E6, $A6D562D5,
    $5D348FD2, $345DE75D, $0B275358, $270B1D0B, $8C869814, $868C898C, $3CCCC1FD, $CC3C443C,
    $77B6E89F, $B6779977, $5108E3B2, $0851F351, $22AA2F0D, $AA226622, $4257682A, $5742C642,
    $3FC3DAE5, $C33F413F, $5419CE9A, $1954FC54, $41587332, $5841C341, $80BAF474, $BA809D80,
    $CCDBE22E, $DBCC49CC, $86A4C244, $A4869786, $B34542F1, $45B3C8B3, $1878D8C0, $78182818,
    $2E96436D, $962E722E, $5716D582, $1657F957, $061E3630, $1E060A06, $62F75537, $F762A662,
    $F40307F3, $03F401F4, $36EE9BAD, $EE365A36, $D1B217C6, $B2D16ED1, $6BDA147F, $DA6BBD6B,
    $1B77C3D8, $771B2D1B, $65EC6A0F, $EC65AF65, $75BCFA8F, $BC759F75, $10509080, $50103010,
    $DA95449E, $95DA73DA, $49703B72, $7049DB49, $26BE0B2D, $BE266A26, $F93A629B, $3AF916F9,
    $CBC0DD16, $C0CB40CB, $66E37117, $E366AA66, $E75C8C6B, $5CE734E7, $BA6803B9, $68BAD3BA,
    $AE2CB719, $2CAEEFAE, $500DEABA, $0D50F050, $5207F8AA, $0752F652, $AB3D9A31, $3DABE0AB,
    $05112D28, $11050F05, $F01723D3, $17F00DF0, $0D396568, $390D170D, $73A2CCBF, $A2739573,
    $3BD7FEC5, $D73B4D3B, $04142420, $14040C04, $20A03D1D, $A0206020, $FE215DA3, $21FE1FFE,
    $DD8E7BA6, $8EDD7ADD, $F5060EFB, $06F502F5, $B45E7DC9, $5EB4C1B4, $5F3E9DC2, $3E5FE15F,
    $0A225A50, $220A1E0A, $B55B74C1, $5BB5C2B5, $C0E78E4E, $E7C05DC0, $A01AC969, $1AA0FDA0,
    $71A8DEAF, $A8719371, $A50BE441, $0BA5F2A5, $2D995875, $992D772D, $60FD4727, $FD60A060,
    $72A7C5B7, $A7729672, $93E57FEC, $E593A893, $39DDECD5, $DD394B39, $08284840, $28081808,
    $83B5EF6C, $B5839883, $21A53415, $A5216321, $5C3186DA, $315CE45C, $87A1CB4C, $A1879487,
    $B14F50E1, $4FB1CEB1, $E047B353, $47E03DE0, $00000000, $00000000, $C3E89556, $E8C358C3,
    $125A8290, $5A123612, $91EF6DFC, $EF91AE91, $8A98AE24, $988A838A, $020A1210, $0A020602,
    $1C6CFCE0, $6C1C241C, $E6598563, $59E637E6, $454C5712, $4C45CF45, $C2ED9C5E, $EDC25BC2,
    $C4F3AA6E, $F3C451C4, $FD2E46BB, $2EFD1AFD, $BF792E91, $79BFDCBF, $44495E1A, $4944CC44,
    $A11FC061, $1FA1FEA1, $4C61165A, $614CD44C, $33FFB685, $FF335533, $C5F6A366, $F6C552C5,
    $84AED054, $AE849184, $23AF2605, $AF236523, $7C91BBC7, $917C847C, $B04A59E9, $4AB0CDB0,
    $25B11035, $B1256F25, $1541BDA8, $41153F15, $35E180B5, $E1355F35, $69D0066F, $D069BB69,
    $FF2454AB, $24FF1CFF, $94FE40D4, $FE94A194, $4D641F52, $644DD74D, $70ADD7A7, $AD709070,
    $A210DB79, $10A2FBA2, $AF29BE11, $29AFECAF, $CDDEEB26, $DECD4ACD, $D6A928FE, $A9D667D6,
    $6CC12B47, $C16CB46C, $B75166D1, $51B7C4B7, $F83F6B93, $3FF815F8, $092D4148, $2D091B09,
    $F31838CB, $18F308F3, $67E6781F, $E667A967, $A40EED49, $0EA4F1A4, $EA65E903, $65EA23EA,
    $EC7BDF33, $7BEC29EC, $B6546FD9, $54B6C7B6, $D4A33AEE, $A3D461D4, $D2BD0CDE, $BDD26BD2,
    $1444B4A0, $44143C14, $1E66EEF0, $661E221E, $E142BA5B, $42E13EE1, $24B4193D, $B4246C24,
    $38D8E5DD, $D8384838, $C6F9B87E, $F9C657C6, $DB904D96, $90DB70DB, $4B7A2962, $7A4BDD4B,
    $7A8F8DF7, $8F7A8E7A, $3AD2F7CD, $D23A4E3A, $DE8160BE, $81DE7FDE, $5E3B94CA, $3B5EE25E,
    $DF8469B6, $84DF7CDF, $95FB49DC, $FB95A295, $FC2B4FB3, $2BFC19FC, $AA389339, $38AAE3AA,
    $D7AC21F6, $ACD764D7, $CED1F03E, $D1CE4FCE, $071B3F38, $1B070907, $0F337778, $330F110F,
    $3DC9C8F5, $C93D473D, $5825A2FA, $2558E858, $9AC83EA4, $C89AB39A, $98C22CB4, $C298B598,
    $9CD60894, $D69CB99C, $F21D31C3, $1DF20BF2, $A701F651, $01A7F4A7, $11559988, $55113311,
    $7E9BA9D7, $9B7E827E, $8B9DA72C, $9D8B808B, $43526122, $5243C543, $030F1B18, $0F030503,
    $E24DA143, $4DE23BE2, $DC8B72AE, $8BDC79DC, $E5569E7B, $56E532E5, $B2404BF9, $40B2CBB2,
    $4E6B044A, $6B4ED24E, $C7FCB176, $FCC754C7, $6DC4224F, $C46DB76D, $E96AF21B, $6AE926E9,
    $27BB0225, $BB276927, $405D7A3A, $5D40C040, $D89F568E, $9FD875D8, $37EB92A5, $EB375937,
    $92E076E4, $E092AB92, $8F89830C, $898F8C8F, $01050908, $05010301, $1D69F5E8, $691D271D,
    $5302F1A2, $0253F553, $3EC6D3ED, $C63E423E, $5920ABF2, $2059EB59, $C1E28746, $E2C15EC1,
    $4F6E0D42, $6E4FD14F, $32FABF8D, $FA325632, $164EA6B0, $4E163A16, $FA357983, $35FA13FA,
    $74B9F387, $B9749C74, $FB30708B, $30FB10FB, $63F25C3F, $F263A563, $9FD9138C, $D99FBC9F,
    $34E489BD, $E4345C34, $1A72CAD0, $721A2E1A, $2A82674D, $822A7E2A, $5A2FB0EA, $2F5AEE5A,
    $8D83911C, $838D8A8D, $C9CACF06, $CAC946C9, $CFD4F936, $D4CF4CCF, $F60915E3, $09F607F6,
    $90EA64F4, $EA90AD90, $2888755D, $88287828, $8892BC34, $92888588, $9BCD37AC, $CD9BB09B,
    $31F5A495, $F5315331, $0E367E70, $360E120E, $BD733C81, $73BDDABD, $4A7F206A, $7F4ADE4A,
    $E86FFB13, $6FE825E8, $96F452C4, $F496A796, $A604FF59, $04A6F7A6, $0C3C6C60, $3C0C140C,
    $C8CFC60E, $CFC845C8, $798096EF, $80798B79, $BC763589, $76BCD9BC, $BE7C2799, $7CBEDFBE,
    $EF74C42B, $74EF2CEF, $6ECB3957, $CB6EB26E, $46434C0A, $4346CA46, $97F15BCC, $F197A497,
    $5B2AB9E2, $2A5BED5B, $ED7ED63B, $7EED2AED, $197DD1C8, $7D192B19, $D99A5F86, $9AD976D9,
    $AC26A509, $26ACE9AC, $99C725BC, $C799B699, $A8328129, $32A8E5A8, $298D7C55, $8D297B29,
    $64E96307, $E964AC64, $1F63E7F8, $631F211F, $AD23AC01, $23ADEAAD, $551CC792, $1C55FF55,
    $135F8B98, $5F133513, $BB6D0AB1, $6DBBD0BB, $F70C1CEB, $0CF704F7, $6FCE305F, $CE6FB16F,
    $B96718A1, $67B9D6B9, $47464502, $4647C947, $2F934A65, $932F712F, $EE71CD23, $71EE2FEE,
    $B86211A9, $62B8D5B8, $7B8A84FF, $8A7B8D7B, $8997B53C, $97898689, $30F0AD9D, $F0305030,
    $D3B805D6, $B8D368D3, $7F9EA0DF, $9E7F817F, $76B3E197, $B3769A76, $82B0E664, $B0829B82),
   ($D50F67D5, $68B86868, $B71ECEB7, $D06DD0D0, $60E00B60, $EB20EBEB, $876E4587, $2B7D2B2B,
    $75327A75, $48D84848, $D3019CD3, $9DBA9D9D, $DF1D77DF, $6ABE6A6A, $53977353, $E431E4E4,
    $48A84B48, $E338E3E3, $15D27115, $A3F8A3A3, $13DC8A13, $56FA5656, $BFFD7CBF, $819E8181,
    $94B2CF94, $7D877D7D, $122ADB12, $F10EF1F1, $ABD95CAB, $85928585, $DC1A84DC, $9EBF9E9E,
    $9C517D9C, $2C742C2C, $8C8A048C, $8E8F8E8E, $859FE785, $78887878, $C5D41EC5, $CA43CACA,
    $4BAFB84B, $17391717, $37882137, $A9E6A9A9, $F84E2FF8, $61A36161, $A633E6A6, $D562D5D5,
    $348FD234, $5DE75D5D, $27535827, $0B1D0B0B, $86981486, $8C898C8C, $CCC1FDCC, $3C443C3C,
    $B6E89FB6, $77997777, $08E3B208, $51F35151, $AA2F0DAA, $22662222, $57682A57, $42C64242,
    $C3DAE5C3, $3F413F3F, $19CE9A19, $54FC5454, $58733258, $41C34141, $BAF474BA, $809D8080,
    $DBE22EDB, $CC49CCCC, $A4C244A4, $86978686, $4542F145, $B3C8B3B3, $78D8C078, $18281818,
    $96436D96, $2E722E2E, $16D58216, $57F95757, $1E36301E, $060A0606, $F75537F7, $62A66262,
    $0307F303, $F401F4F4, $EE9BADEE, $365A3636, $B217C6B2, $D16ED1D1, $DA147FDA, $6BBD6B6B,
    $77C3D877, $1B2D1B1B, $EC6A0FEC, $65AF6565, $BCFA8FBC, $759F7575, $50908050, $10301010,
    $95449E95, $DA73DADA, $703B7270, $49DB4949, $BE0B2DBE, $266A2626, $3A629B3A, $F916F9F9,
    $C0DD16C0, $CB40CBCB, $E37117E3, $66AA6666, $5C8C6B5C, $E734E7E7, $6803B968, $BAD3BABA,
    $2CB7192C, $AEEFAEAE, $0DEABA0D, $50F05050, $07F8AA07, $52F65252, $3D9A313D, $ABE0ABAB,
    $112D2811, $050F0505, $1723D317, $F00DF0F0, $39656839, $0D170D0D, $A2CCBFA2, $73957373,
    $D7FEC5D7, $3B4D3B3B, $14242014, $040C0404, $A03D1DA0, $20602020, $215DA321, $FE1FFEFE,
    $8E7BA68E, $DD7ADDDD, $060EFB06, $F502F5F5, $5E7DC95E, $B4C1B4B4, $3E9DC23E, $5FE15F5F,
    $225A5022, $0A1E0A0A, $5B74C15B, $B5C2B5B5, $E78E4EE7, $C05DC0C0, $1AC9691A, $A0FDA0A0,
    $A8DEAFA8, $71937171, $0BE4410B, $A5F2A5A5, $99587599, $2D772D2D, $FD4727FD, $60A06060,
    $A7C5B7A7, $72967272, $E57FECE5, $93A89393, $DDECD5DD, $394B3939, $28484028, $08180808,
    $B5EF6CB5, $83988383, $A53415A5, $21632121, $3186DA31, $5CE45C5C, $A1CB4CA1, $87948787,
    $4F50E14F, $B1CEB1B1, $47B35347, $E03DE0E0, $00000000, $00000000, $E89556E8, $C358C3C3,
    $5A82905A, $12361212, $EF6DFCEF, $91AE9191, $98AE2498, $8A838A8A, $0A12100A, $02060202,
    $6CFCE06C, $1C241C1C, $59856359, $E637E6E6, $4C57124C, $45CF4545, $ED9C5EED, $C25BC2C2,
    $F3AA6EF3, $C451C4C4, $2E46BB2E, $FD1AFDFD, $792E9179, $BFDCBFBF, $495E1A49, $44CC4444,
    $1FC0611F, $A1FEA1A1, $61165A61, $4CD44C4C, $FFB685FF, $33553333, $F6A366F6, $C552C5C5,
    $AED054AE, $84918484, $AF2605AF, $23652323, $91BBC791, $7C847C7C, $4A59E94A, $B0CDB0B0,
    $B11035B1, $256F2525, $41BDA841, $153F1515, $E180B5E1, $355F3535, $D0066FD0, $69BB6969,
    $2454AB24, $FF1CFFFF, $FE40D4FE, $94A19494, $641F5264, $4DD74D4D, $ADD7A7AD, $70907070,
    $10DB7910, $A2FBA2A2, $29BE1129, $AFECAFAF, $DEEB26DE, $CD4ACDCD, $A928FEA9, $D667D6D6,
    $C12B47C1, $6CB46C6C, $5166D151, $B7C4B7B7, $3F6B933F, $F815F8F8, $2D41482D, $091B0909,
    $1838CB18, $F308F3F3, $E6781FE6, $67A96767, $0EED490E, $A4F1A4A4, $65E90365, $EA23EAEA,
    $7BDF337B, $EC29ECEC, $546FD954, $B6C7B6B6, $A33AEEA3, $D461D4D4, $BD0CDEBD, $D26BD2D2,
    $44B4A044, $143C1414, $66EEF066, $1E221E1E, $42BA5B42, $E13EE1E1, $B4193DB4, $246C2424,
    $D8E5DDD8, $38483838, $F9B87EF9, $C657C6C6, $904D9690, $DB70DBDB, $7A29627A, $4BDD4B4B,
    $8F8DF78F, $7A8E7A7A, $D2F7CDD2, $3A4E3A3A, $8160BE81, $DE7FDEDE, $3B94CA3B, $5EE25E5E,
    $8469B684, $DF7CDFDF, $FB49DCFB, $95A29595, $2B4FB32B, $FC19FCFC, $38933938, $AAE3AAAA,
    $AC21F6AC, $D764D7D7, $D1F03ED1, $CE4FCECE, $1B3F381B, $07090707, $33777833, $0F110F0F,
    $C9C8F5C9, $3D473D3D, $25A2FA25, $58E85858, $C83EA4C8, $9AB39A9A, $C22CB4C2, $98B59898,
    $D60894D6, $9CB99C9C, $1D31C31D, $F20BF2F2, $01F65101, $A7F4A7A7, $55998855, $11331111,
    $9BA9D79B, $7E827E7E, $9DA72C9D, $8B808B8B, $52612252, $43C54343, $0F1B180F, $03050303,
    $4DA1434D, $E23BE2E2, $8B72AE8B, $DC79DCDC, $569E7B56, $E532E5E5, $404BF940, $B2CBB2B2,
    $6B044A6B, $4ED24E4E, $FCB176FC, $C754C7C7, $C4224FC4, $6DB76D6D, $6AF21B6A, $E926E9E9,
    $BB0225BB, $27692727, $5D7A3A5D, $40C04040, $9F568E9F, $D875D8D8, $EB92A5EB, $37593737,
    $E076E4E0, $92AB9292, $89830C89, $8F8C8F8F, $05090805, $01030101, $69F5E869, $1D271D1D,
    $02F1A202, $53F55353, $C6D3EDC6, $3E423E3E, $20ABF220, $59EB5959, $E28746E2, $C15EC1C1,
    $6E0D426E, $4FD14F4F, $FABF8DFA, $32563232, $4EA6B04E, $163A1616, $35798335, $FA13FAFA,
    $B9F387B9, $749C7474, $30708B30, $FB10FBFB, $F25C3FF2, $63A56363, $D9138CD9, $9FBC9F9F,
    $E489BDE4, $345C3434, $72CAD072, $1A2E1A1A, $82674D82, $2A7E2A2A, $2FB0EA2F, $5AEE5A5A,
    $83911C83, $8D8A8D8D, $CACF06CA, $C946C9C9, $D4F936D4, $CF4CCFCF, $0915E309, $F607F6F6,
    $EA64F4EA, $90AD9090, $88755D88, $28782828, $92BC3492, $88858888, $CD37ACCD, $9BB09B9B,
    $F5A495F5, $31533131, $367E7036, $0E120E0E, $733C8173, $BDDABDBD, $7F206A7F, $4ADE4A4A,
    $6FFB136F, $E825E8E8, $F452C4F4, $96A79696, $04FF5904, $A6F7A6A6, $3C6C603C, $0C140C0C,
    $CFC60ECF, $C845C8C8, $8096EF80, $798B7979, $76358976, $BCD9BCBC, $7C27997C, $BEDFBEBE,
    $74C42B74, $EF2CEFEF, $CB3957CB, $6EB26E6E, $434C0A43, $46CA4646, $F15BCCF1, $97A49797,
    $2AB9E22A, $5BED5B5B, $7ED63B7E, $ED2AEDED, $7DD1C87D, $192B1919, $9A5F869A, $D976D9D9,
    $26A50926, $ACE9ACAC, $C725BCC7, $99B69999, $32812932, $A8E5A8A8, $8D7C558D, $297B2929,
    $E96307E9, $64AC6464, $63E7F863, $1F211F1F, $23AC0123, $ADEAADAD, $1CC7921C, $55FF5555,
    $5F8B985F, $13351313, $6D0AB16D, $BBD0BBBB, $0C1CEB0C, $F704F7F7, $CE305FCE, $6FB16F6F,
    $6718A167, $B9D6B9B9, $46450246, $47C94747, $934A6593, $2F712F2F, $71CD2371, $EE2FEEEE,
    $6211A962, $B8D5B8B8, $8A84FF8A, $7B8D7B7B, $97B53C97, $89868989, $F0AD9DF0, $30503030,
    $B805D6B8, $D368D3D3, $9EA0DF9E, $7F817F7F, $B3E197B3, $769A7676, $B0E664B0, $829B8282),
   ($0F67D568, $B86868D5, $1ECEB7D0, $6DD0D0B7, $E00B60EB, $20EBEB60, $6E45872B, $7D2B2B87,
    $327A7548, $D8484875, $019CD39D, $BA9D9DD3, $1D77DF6A, $BE6A6ADF, $977353E4, $31E4E453,
    $A84B48E3, $38E3E348, $D27115A3, $F8A3A315, $DC8A1356, $FA565613, $FD7CBF81, $9E8181BF,
    $B2CF947D, $877D7D94, $2ADB12F1, $0EF1F112, $D95CAB85, $928585AB, $1A84DC9E, $BF9E9EDC,
    $517D9C2C, $742C2C9C, $8A048C8E, $8F8E8E8C, $9FE78578, $88787885, $D41EC5CA, $43CACAC5,
    $AFB84B17, $3917174B, $882137A9, $E6A9A937, $4E2FF861, $A36161F8, $33E6A6D5, $62D5D5A6,
    $8FD2345D, $E75D5D34, $5358270B, $1D0B0B27, $9814868C, $898C8C86, $C1FDCC3C, $443C3CCC,
    $E89FB677, $997777B6, $E3B20851, $F3515108, $2F0DAA22, $662222AA, $682A5742, $C6424257,
    $DAE5C33F, $413F3FC3, $CE9A1954, $FC545419, $73325841, $C3414158, $F474BA80, $9D8080BA,
    $E22EDBCC, $49CCCCDB, $C244A486, $978686A4, $42F145B3, $C8B3B345, $D8C07818, $28181878,
    $436D962E, $722E2E96, $D5821657, $F9575716, $36301E06, $0A06061E, $5537F762, $A66262F7,
    $07F303F4, $01F4F403, $9BADEE36, $5A3636EE, $17C6B2D1, $6ED1D1B2, $147FDA6B, $BD6B6BDA,
    $C3D8771B, $2D1B1B77, $6A0FEC65, $AF6565EC, $FA8FBC75, $9F7575BC, $90805010, $30101050,
    $449E95DA, $73DADA95, $3B727049, $DB494970, $0B2DBE26, $6A2626BE, $629B3AF9, $16F9F93A,
    $DD16C0CB, $40CBCBC0, $7117E366, $AA6666E3, $8C6B5CE7, $34E7E75C, $03B968BA, $D3BABA68,
    $B7192CAE, $EFAEAE2C, $EABA0D50, $F050500D, $F8AA0752, $F6525207, $9A313DAB, $E0ABAB3D,
    $2D281105, $0F050511, $23D317F0, $0DF0F017, $6568390D, $170D0D39, $CCBFA273, $957373A2,
    $FEC5D73B, $4D3B3BD7, $24201404, $0C040414, $3D1DA020, $602020A0, $5DA321FE, $1FFEFE21,
    $7BA68EDD, $7ADDDD8E, $0EFB06F5, $02F5F506, $7DC95EB4, $C1B4B45E, $9DC23E5F, $E15F5F3E,
    $5A50220A, $1E0A0A22, $74C15BB5, $C2B5B55B, $8E4EE7C0, $5DC0C0E7, $C9691AA0, $FDA0A01A,
    $DEAFA871, $937171A8, $E4410BA5, $F2A5A50B, $5875992D, $772D2D99, $4727FD60, $A06060FD,
    $C5B7A772, $967272A7, $7FECE593, $A89393E5, $ECD5DD39, $4B3939DD, $48402808, $18080828,
    $EF6CB583, $988383B5, $3415A521, $632121A5, $86DA315C, $E45C5C31, $CB4CA187, $948787A1,
    $50E14FB1, $CEB1B14F, $B35347E0, $3DE0E047, $00000000, $00000000, $9556E8C3, $58C3C3E8,
    $82905A12, $3612125A, $6DFCEF91, $AE9191EF, $AE24988A, $838A8A98, $12100A02, $0602020A,
    $FCE06C1C, $241C1C6C, $856359E6, $37E6E659, $57124C45, $CF45454C, $9C5EEDC2, $5BC2C2ED,
    $AA6EF3C4, $51C4C4F3, $46BB2EFD, $1AFDFD2E, $2E9179BF, $DCBFBF79, $5E1A4944, $CC444449,
    $C0611FA1, $FEA1A11F, $165A614C, $D44C4C61, $B685FF33, $553333FF, $A366F6C5, $52C5C5F6,
    $D054AE84, $918484AE, $2605AF23, $652323AF, $BBC7917C, $847C7C91, $59E94AB0, $CDB0B04A,
    $1035B125, $6F2525B1, $BDA84115, $3F151541, $80B5E135, $5F3535E1, $066FD069, $BB6969D0,
    $54AB24FF, $1CFFFF24, $40D4FE94, $A19494FE, $1F52644D, $D74D4D64, $D7A7AD70, $907070AD,
    $DB7910A2, $FBA2A210, $BE1129AF, $ECAFAF29, $EB26DECD, $4ACDCDDE, $28FEA9D6, $67D6D6A9,
    $2B47C16C, $B46C6CC1, $66D151B7, $C4B7B751, $6B933FF8, $15F8F83F, $41482D09, $1B09092D,
    $38CB18F3, $08F3F318, $781FE667, $A96767E6, $ED490EA4, $F1A4A40E, $E90365EA, $23EAEA65,
    $DF337BEC, $29ECEC7B, $6FD954B6, $C7B6B654, $3AEEA3D4, $61D4D4A3, $0CDEBDD2, $6BD2D2BD,
    $B4A04414, $3C141444, $EEF0661E, $221E1E66, $BA5B42E1, $3EE1E142, $193DB424, $6C2424B4,
    $E5DDD838, $483838D8, $B87EF9C6, $57C6C6F9, $4D9690DB, $70DBDB90, $29627A4B, $DD4B4B7A,
    $8DF78F7A, $8E7A7A8F, $F7CDD23A, $4E3A3AD2, $60BE81DE, $7FDEDE81, $94CA3B5E, $E25E5E3B,
    $69B684DF, $7CDFDF84, $49DCFB95, $A29595FB, $4FB32BFC, $19FCFC2B, $933938AA, $E3AAAA38,
    $21F6ACD7, $64D7D7AC, $F03ED1CE, $4FCECED1, $3F381B07, $0907071B, $7778330F, $110F0F33,
    $C8F5C93D, $473D3DC9, $A2FA2558, $E8585825, $3EA4C89A, $B39A9AC8, $2CB4C298, $B59898C2,
    $0894D69C, $B99C9CD6, $31C31DF2, $0BF2F21D, $F65101A7, $F4A7A701, $99885511, $33111155,
    $A9D79B7E, $827E7E9B, $A72C9D8B, $808B8B9D, $61225243, $C5434352, $1B180F03, $0503030F,
    $A1434DE2, $3BE2E24D, $72AE8BDC, $79DCDC8B, $9E7B56E5, $32E5E556, $4BF940B2, $CBB2B240,
    $044A6B4E, $D24E4E6B, $B176FCC7, $54C7C7FC, $224FC46D, $B76D6DC4, $F21B6AE9, $26E9E96A,
    $0225BB27, $692727BB, $7A3A5D40, $C040405D, $568E9FD8, $75D8D89F, $92A5EB37, $593737EB,
    $76E4E092, $AB9292E0, $830C898F, $8C8F8F89, $09080501, $03010105, $F5E8691D, $271D1D69,
    $F1A20253, $F5535302, $D3EDC63E, $423E3EC6, $ABF22059, $EB595920, $8746E2C1, $5EC1C1E2,
    $0D426E4F, $D14F4F6E, $BF8DFA32, $563232FA, $A6B04E16, $3A16164E, $798335FA, $13FAFA35,
    $F387B974, $9C7474B9, $708B30FB, $10FBFB30, $5C3FF263, $A56363F2, $138CD99F, $BC9F9FD9,
    $89BDE434, $5C3434E4, $CAD0721A, $2E1A1A72, $674D822A, $7E2A2A82, $B0EA2F5A, $EE5A5A2F,
    $911C838D, $8A8D8D83, $CF06CAC9, $46C9C9CA, $F936D4CF, $4CCFCFD4, $15E309F6, $07F6F609,
    $64F4EA90, $AD9090EA, $755D8828, $78282888, $BC349288, $85888892, $37ACCD9B, $B09B9BCD,
    $A495F531, $533131F5, $7E70360E, $120E0E36, $3C8173BD, $DABDBD73, $206A7F4A, $DE4A4A7F,
    $FB136FE8, $25E8E86F, $52C4F496, $A79696F4, $FF5904A6, $F7A6A604, $6C603C0C, $140C0C3C,
    $C60ECFC8, $45C8C8CF, $96EF8079, $8B797980, $358976BC, $D9BCBC76, $27997CBE, $DFBEBE7C,
    $C42B74EF, $2CEFEF74, $3957CB6E, $B26E6ECB, $4C0A4346, $CA464643, $5BCCF197, $A49797F1,
    $B9E22A5B, $ED5B5B2A, $D63B7EED, $2AEDED7E, $D1C87D19, $2B19197D, $5F869AD9, $76D9D99A,
    $A50926AC, $E9ACAC26, $25BCC799, $B69999C7, $812932A8, $E5A8A832, $7C558D29, $7B29298D,
    $6307E964, $AC6464E9, $E7F8631F, $211F1F63, $AC0123AD, $EAADAD23, $C7921C55, $FF55551C,
    $8B985F13, $3513135F, $0AB16DBB, $D0BBBB6D, $1CEB0CF7, $04F7F70C, $305FCE6F, $B16F6FCE,
    $18A167B9, $D6B9B967, $45024647, $C9474746, $4A65932F, $712F2F93, $CD2371EE, $2FEEEE71,
    $11A962B8, $D5B8B862, $84FF8A7B, $8D7B7B8A, $B53C9789, $86898997, $AD9DF030, $503030F0,
    $05D6B8D3, $68D3D3B8, $A0DF9E7F, $817F7F9E, $E197B376, $9A7676B3, $E664B082, $9B8282B0),
   ($67D568B8, $6868D50F, $CEB7D06D, $D0D0B71E, $0B60EB20, $EBEB60E0, $45872B7D, $2B2B876E,
    $7A7548D8, $48487532, $9CD39DBA, $9D9DD301, $77DF6ABE, $6A6ADF1D, $7353E431, $E4E45397,
    $4B48E338, $E3E348A8, $7115A3F8, $A3A315D2, $8A1356FA, $565613DC, $7CBF819E, $8181BFFD,
    $CF947D87, $7D7D94B2, $DB12F10E, $F1F1122A, $5CAB8592, $8585ABD9, $84DC9EBF, $9E9EDC1A,
    $7D9C2C74, $2C2C9C51, $048C8E8F, $8E8E8C8A, $E7857888, $7878859F, $1EC5CA43, $CACAC5D4,
    $B84B1739, $17174BAF, $2137A9E6, $A9A93788, $2FF861A3, $6161F84E, $E6A6D562, $D5D5A633,
    $D2345DE7, $5D5D348F, $58270B1D, $0B0B2753, $14868C89, $8C8C8698, $FDCC3C44, $3C3CCCC1,
    $9FB67799, $7777B6E8, $B20851F3, $515108E3, $0DAA2266, $2222AA2F, $2A5742C6, $42425768,
    $E5C33F41, $3F3FC3DA, $9A1954FC, $545419CE, $325841C3, $41415873, $74BA809D, $8080BAF4,
    $2EDBCC49, $CCCCDBE2, $44A48697, $8686A4C2, $F145B3C8, $B3B34542, $C0781828, $181878D8,
    $6D962E72, $2E2E9643, $821657F9, $575716D5, $301E060A, $06061E36, $37F762A6, $6262F755,
    $F303F401, $F4F40307, $ADEE365A, $3636EE9B, $C6B2D16E, $D1D1B217, $7FDA6BBD, $6B6BDA14,
    $D8771B2D, $1B1B77C3, $0FEC65AF, $6565EC6A, $8FBC759F, $7575BCFA, $80501030, $10105090,
    $9E95DA73, $DADA9544, $727049DB, $4949703B, $2DBE266A, $2626BE0B, $9B3AF916, $F9F93A62,
    $16C0CB40, $CBCBC0DD, $17E366AA, $6666E371, $6B5CE734, $E7E75C8C, $B968BAD3, $BABA6803,
    $192CAEEF, $AEAE2CB7, $BA0D50F0, $50500DEA, $AA0752F6, $525207F8, $313DABE0, $ABAB3D9A,
    $2811050F, $0505112D, $D317F00D, $F0F01723, $68390D17, $0D0D3965, $BFA27395, $7373A2CC,
    $C5D73B4D, $3B3BD7FE, $2014040C, $04041424, $1DA02060, $2020A03D, $A321FE1F, $FEFE215D,
    $A68EDD7A, $DDDD8E7B, $FB06F502, $F5F5060E, $C95EB4C1, $B4B45E7D, $C23E5FE1, $5F5F3E9D,
    $50220A1E, $0A0A225A, $C15BB5C2, $B5B55B74, $4EE7C05D, $C0C0E78E, $691AA0FD, $A0A01AC9,
    $AFA87193, $7171A8DE, $410BA5F2, $A5A50BE4, $75992D77, $2D2D9958, $27FD60A0, $6060FD47,
    $B7A77296, $7272A7C5, $ECE593A8, $9393E57F, $D5DD394B, $3939DDEC, $40280818, $08082848,
    $6CB58398, $8383B5EF, $15A52163, $2121A534, $DA315CE4, $5C5C3186, $4CA18794, $8787A1CB,
    $E14FB1CE, $B1B14F50, $5347E03D, $E0E047B3, $00000000, $00000000, $56E8C358, $C3C3E895,
    $905A1236, $12125A82, $FCEF91AE, $9191EF6D, $24988A83, $8A8A98AE, $100A0206, $02020A12,
    $E06C1C24, $1C1C6CFC, $6359E637, $E6E65985, $124C45CF, $45454C57, $5EEDC25B, $C2C2ED9C,
    $6EF3C451, $C4C4F3AA, $BB2EFD1A, $FDFD2E46, $9179BFDC, $BFBF792E, $1A4944CC, $4444495E,
    $611FA1FE, $A1A11FC0, $5A614CD4, $4C4C6116, $85FF3355, $3333FFB6, $66F6C552, $C5C5F6A3,
    $54AE8491, $8484AED0, $05AF2365, $2323AF26, $C7917C84, $7C7C91BB, $E94AB0CD, $B0B04A59,
    $35B1256F, $2525B110, $A841153F, $151541BD, $B5E1355F, $3535E180, $6FD069BB, $6969D006,
    $AB24FF1C, $FFFF2454, $D4FE94A1, $9494FE40, $52644DD7, $4D4D641F, $A7AD7090, $7070ADD7,
    $7910A2FB, $A2A210DB, $1129AFEC, $AFAF29BE, $26DECD4A, $CDCDDEEB, $FEA9D667, $D6D6A928,
    $47C16CB4, $6C6CC12B, $D151B7C4, $B7B75166, $933FF815, $F8F83F6B, $482D091B, $09092D41,
    $CB18F308, $F3F31838, $1FE667A9, $6767E678, $490EA4F1, $A4A40EED, $0365EA23, $EAEA65E9,
    $337BEC29, $ECEC7BDF, $D954B6C7, $B6B6546F, $EEA3D461, $D4D4A33A, $DEBDD26B, $D2D2BD0C,
    $A044143C, $141444B4, $F0661E22, $1E1E66EE, $5B42E13E, $E1E142BA, $3DB4246C, $2424B419,
    $DDD83848, $3838D8E5, $7EF9C657, $C6C6F9B8, $9690DB70, $DBDB904D, $627A4BDD, $4B4B7A29,
    $F78F7A8E, $7A7A8F8D, $CDD23A4E, $3A3AD2F7, $BE81DE7F, $DEDE8160, $CA3B5EE2, $5E5E3B94,
    $B684DF7C, $DFDF8469, $DCFB95A2, $9595FB49, $B32BFC19, $FCFC2B4F, $3938AAE3, $AAAA3893,
    $F6ACD764, $D7D7AC21, $3ED1CE4F, $CECED1F0, $381B0709, $07071B3F, $78330F11, $0F0F3377,
    $F5C93D47, $3D3DC9C8, $FA2558E8, $585825A2, $A4C89AB3, $9A9AC83E, $B4C298B5, $9898C22C,
    $94D69CB9, $9C9CD608, $C31DF20B, $F2F21D31, $5101A7F4, $A7A701F6, $88551133, $11115599,
    $D79B7E82, $7E7E9BA9, $2C9D8B80, $8B8B9DA7, $225243C5, $43435261, $180F0305, $03030F1B,
    $434DE23B, $E2E24DA1, $AE8BDC79, $DCDC8B72, $7B56E532, $E5E5569E, $F940B2CB, $B2B2404B,
    $4A6B4ED2, $4E4E6B04, $76FCC754, $C7C7FCB1, $4FC46DB7, $6D6DC422, $1B6AE926, $E9E96AF2,
    $25BB2769, $2727BB02, $3A5D40C0, $40405D7A, $8E9FD875, $D8D89F56, $A5EB3759, $3737EB92,
    $E4E092AB, $9292E076, $0C898F8C, $8F8F8983, $08050103, $01010509, $E8691D27, $1D1D69F5,
    $A20253F5, $535302F1, $EDC63E42, $3E3EC6D3, $F22059EB, $595920AB, $46E2C15E, $C1C1E287,
    $426E4FD1, $4F4F6E0D, $8DFA3256, $3232FABF, $B04E163A, $16164EA6, $8335FA13, $FAFA3579,
    $87B9749C, $7474B9F3, $8B30FB10, $FBFB3070, $3FF263A5, $6363F25C, $8CD99FBC, $9F9FD913,
    $BDE4345C, $3434E489, $D0721A2E, $1A1A72CA, $4D822A7E, $2A2A8267, $EA2F5AEE, $5A5A2FB0,
    $1C838D8A, $8D8D8391, $06CAC946, $C9C9CACF, $36D4CF4C, $CFCFD4F9, $E309F607, $F6F60915,
    $F4EA90AD, $9090EA64, $5D882878, $28288875, $34928885, $888892BC, $ACCD9BB0, $9B9BCD37,
    $95F53153, $3131F5A4, $70360E12, $0E0E367E, $8173BDDA, $BDBD733C, $6A7F4ADE, $4A4A7F20,
    $136FE825, $E8E86FFB, $C4F496A7, $9696F452, $5904A6F7, $A6A604FF, $603C0C14, $0C0C3C6C,
    $0ECFC845, $C8C8CFC6, $EF80798B, $79798096, $8976BCD9, $BCBC7635, $997CBEDF, $BEBE7C27,
    $2B74EF2C, $EFEF74C4, $57CB6EB2, $6E6ECB39, $0A4346CA, $4646434C, $CCF197A4, $9797F15B,
    $E22A5BED, $5B5B2AB9, $3B7EED2A, $EDED7ED6, $C87D192B, $19197DD1, $869AD976, $D9D99A5F,
    $0926ACE9, $ACAC26A5, $BCC799B6, $9999C725, $2932A8E5, $A8A83281, $558D297B, $29298D7C,
    $07E964AC, $6464E963, $F8631F21, $1F1F63E7, $0123ADEA, $ADAD23AC, $921C55FF, $55551CC7,
    $985F1335, $13135F8B, $B16DBBD0, $BBBB6D0A, $EB0CF704, $F7F70C1C, $5FCE6FB1, $6F6FCE30,
    $A167B9D6, $B9B96718, $024647C9, $47474645, $65932F71, $2F2F934A, $2371EE2F, $EEEE71CD,
    $A962B8D5, $B8B86211, $FF8A7B8D, $7B7B8A84, $3C978986, $898997B5, $9DF03050, $3030F0AD,
    $D6B8D368, $D3D3B805, $DF9E7F81, $7F7F9EA0, $97B3769A, $7676B3E1, $64B0829B, $8282B0E6),
   ($D568B868, $68D50F67, $B7D06DD0, $D0B71ECE, $60EB20EB, $EB60E00B, $872B7D2B, $2B876E45,
    $7548D848, $4875327A, $D39DBA9D, $9DD3019C, $DF6ABE6A, $6ADF1D77, $53E431E4, $E4539773,
    $48E338E3, $E348A84B, $15A3F8A3, $A315D271, $1356FA56, $5613DC8A, $BF819E81, $81BFFD7C,
    $947D877D, $7D94B2CF, $12F10EF1, $F1122ADB, $AB859285, $85ABD95C, $DC9EBF9E, $9EDC1A84,
    $9C2C742C, $2C9C517D, $8C8E8F8E, $8E8C8A04, $85788878, $78859FE7, $C5CA43CA, $CAC5D41E,
    $4B173917, $174BAFB8, $37A9E6A9, $A9378821, $F861A361, $61F84E2F, $A6D562D5, $D5A633E6,
    $345DE75D, $5D348FD2, $270B1D0B, $0B275358, $868C898C, $8C869814, $CC3C443C, $3CCCC1FD,
    $B6779977, $77B6E89F, $0851F351, $5108E3B2, $AA226622, $22AA2F0D, $5742C642, $4257682A,
    $C33F413F, $3FC3DAE5, $1954FC54, $5419CE9A, $5841C341, $41587332, $BA809D80, $80BAF474,
    $DBCC49CC, $CCDBE22E, $A4869786, $86A4C244, $45B3C8B3, $B34542F1, $78182818, $1878D8C0,
    $962E722E, $2E96436D, $1657F957, $5716D582, $1E060A06, $061E3630, $F762A662, $62F75537,
    $03F401F4, $F40307F3, $EE365A36, $36EE9BAD, $B2D16ED1, $D1B217C6, $DA6BBD6B, $6BDA147F,
    $771B2D1B, $1B77C3D8, $EC65AF65, $65EC6A0F, $BC759F75, $75BCFA8F, $50103010, $10509080,
    $95DA73DA, $DA95449E, $7049DB49, $49703B72, $BE266A26, $26BE0B2D, $3AF916F9, $F93A629B,
    $C0CB40CB, $CBC0DD16, $E366AA66, $66E37117, $5CE734E7, $E75C8C6B, $68BAD3BA, $BA6803B9,
    $2CAEEFAE, $AE2CB719, $0D50F050, $500DEABA, $0752F652, $5207F8AA, $3DABE0AB, $AB3D9A31,
    $11050F05, $05112D28, $17F00DF0, $F01723D3, $390D170D, $0D396568, $A2739573, $73A2CCBF,
    $D73B4D3B, $3BD7FEC5, $14040C04, $04142420, $A0206020, $20A03D1D, $21FE1FFE, $FE215DA3,
    $8EDD7ADD, $DD8E7BA6, $06F502F5, $F5060EFB, $5EB4C1B4, $B45E7DC9, $3E5FE15F, $5F3E9DC2,
    $220A1E0A, $0A225A50, $5BB5C2B5, $B55B74C1, $E7C05DC0, $C0E78E4E, $1AA0FDA0, $A01AC969,
    $A8719371, $71A8DEAF, $0BA5F2A5, $A50BE441, $992D772D, $2D995875, $FD60A060, $60FD4727,
    $A7729672, $72A7C5B7, $E593A893, $93E57FEC, $DD394B39, $39DDECD5, $28081808, $08284840,
    $B5839883, $83B5EF6C, $A5216321, $21A53415, $315CE45C, $5C3186DA, $A1879487, $87A1CB4C,
    $4FB1CEB1, $B14F50E1, $47E03DE0, $E047B353, $00000000, $00000000, $E8C358C3, $C3E89556,
    $5A123612, $125A8290, $EF91AE91, $91EF6DFC, $988A838A, $8A98AE24, $0A020602, $020A1210,
    $6C1C241C, $1C6CFCE0, $59E637E6, $E6598563, $4C45CF45, $454C5712, $EDC25BC2, $C2ED9C5E,
    $F3C451C4, $C4F3AA6E, $2EFD1AFD, $FD2E46BB, $79BFDCBF, $BF792E91, $4944CC44, $44495E1A,
    $1FA1FEA1, $A11FC061, $614CD44C, $4C61165A, $FF335533, $33FFB685, $F6C552C5, $C5F6A366,
    $AE849184, $84AED054, $AF236523, $23AF2605, $917C847C, $7C91BBC7, $4AB0CDB0, $B04A59E9,
    $B1256F25, $25B11035, $41153F15, $1541BDA8, $E1355F35, $35E180B5, $D069BB69, $69D0066F,
    $24FF1CFF, $FF2454AB, $FE94A194, $94FE40D4, $644DD74D, $4D641F52, $AD709070, $70ADD7A7,
    $10A2FBA2, $A210DB79, $29AFECAF, $AF29BE11, $DECD4ACD, $CDDEEB26, $A9D667D6, $D6A928FE,
    $C16CB46C, $6CC12B47, $51B7C4B7, $B75166D1, $3FF815F8, $F83F6B93, $2D091B09, $092D4148,
    $18F308F3, $F31838CB, $E667A967, $67E6781F, $0EA4F1A4, $A40EED49, $65EA23EA, $EA65E903,
    $7BEC29EC, $EC7BDF33, $54B6C7B6, $B6546FD9, $A3D461D4, $D4A33AEE, $BDD26BD2, $D2BD0CDE,
    $44143C14, $1444B4A0, $661E221E, $1E66EEF0, $42E13EE1, $E142BA5B, $B4246C24, $24B4193D,
    $D8384838, $38D8E5DD, $F9C657C6, $C6F9B87E, $90DB70DB, $DB904D96, $7A4BDD4B, $4B7A2962,
    $8F7A8E7A, $7A8F8DF7, $D23A4E3A, $3AD2F7CD, $81DE7FDE, $DE8160BE, $3B5EE25E, $5E3B94CA,
    $84DF7CDF, $DF8469B6, $FB95A295, $95FB49DC, $2BFC19FC, $FC2B4FB3, $38AAE3AA, $AA389339,
    $ACD764D7, $D7AC21F6, $D1CE4FCE, $CED1F03E, $1B070907, $071B3F38, $330F110F, $0F337778,
    $C93D473D, $3DC9C8F5, $2558E858, $5825A2FA, $C89AB39A, $9AC83EA4, $C298B598, $98C22CB4,
    $D69CB99C, $9CD60894, $1DF20BF2, $F21D31C3, $01A7F4A7, $A701F651, $55113311, $11559988,
    $9B7E827E, $7E9BA9D7, $9D8B808B, $8B9DA72C, $5243C543, $43526122, $0F030503, $030F1B18,
    $4DE23BE2, $E24DA143, $8BDC79DC, $DC8B72AE, $56E532E5, $E5569E7B, $40B2CBB2, $B2404BF9,
    $6B4ED24E, $4E6B044A, $FCC754C7, $C7FCB176, $C46DB76D, $6DC4224F, $6AE926E9, $E96AF21B,
    $BB276927, $27BB0225, $5D40C040, $405D7A3A, $9FD875D8, $D89F568E, $EB375937, $37EB92A5,
    $E092AB92, $92E076E4, $898F8C8F, $8F89830C, $05010301, $01050908, $691D271D, $1D69F5E8,
    $0253F553, $5302F1A2, $C63E423E, $3EC6D3ED, $2059EB59, $5920ABF2, $E2C15EC1, $C1E28746,
    $6E4FD14F, $4F6E0D42, $FA325632, $32FABF8D, $4E163A16, $164EA6B0, $35FA13FA, $FA357983,
    $B9749C74, $74B9F387, $30FB10FB, $FB30708B, $F263A563, $63F25C3F, $D99FBC9F, $9FD9138C,
    $E4345C34, $34E489BD, $721A2E1A, $1A72CAD0, $822A7E2A, $2A82674D, $2F5AEE5A, $5A2FB0EA,
    $838D8A8D, $8D83911C, $CAC946C9, $C9CACF06, $D4CF4CCF, $CFD4F936, $09F607F6, $F60915E3,
    $EA90AD90, $90EA64F4, $88287828, $2888755D, $92888588, $8892BC34, $CD9BB09B, $9BCD37AC,
    $F5315331, $31F5A495, $360E120E, $0E367E70, $73BDDABD, $BD733C81, $7F4ADE4A, $4A7F206A,
    $6FE825E8, $E86FFB13, $F496A796, $96F452C4, $04A6F7A6, $A604FF59, $3C0C140C, $0C3C6C60,
    $CFC845C8, $C8CFC60E, $80798B79, $798096EF, $76BCD9BC, $BC763589, $7CBEDFBE, $BE7C2799,
    $74EF2CEF, $EF74C42B, $CB6EB26E, $6ECB3957, $4346CA46, $46434C0A, $F197A497, $97F15BCC,
    $2A5BED5B, $5B2AB9E2, $7EED2AED, $ED7ED63B, $7D192B19, $197DD1C8, $9AD976D9, $D99A5F86,
    $26ACE9AC, $AC26A509, $C799B699, $99C725BC, $32A8E5A8, $A8328129, $8D297B29, $298D7C55,
    $E964AC64, $64E96307, $631F211F, $1F63E7F8, $23ADEAAD, $AD23AC01, $1C55FF55, $551CC792,
    $5F133513, $135F8B98, $6DBBD0BB, $BB6D0AB1, $0CF704F7, $F70C1CEB, $CE6FB16F, $6FCE305F,
    $67B9D6B9, $B96718A1, $4647C947, $47464502, $932F712F, $2F934A65, $71EE2FEE, $EE71CD23,
    $62B8D5B8, $B86211A9, $8A7B8D7B, $7B8A84FF, $97898689, $8997B53C, $F0305030, $30F0AD9D,
    $B8D368D3, $D3B805D6, $9E7F817F, $7F9EA0DF, $B3769A76, $76B3E197, $B0829B82, $82B0E664));


  Whirlpool_RC_T: array[0..Whirlpool_Rounds * 2 -1] of LongWord = (
    $E8C62318, $4F01B887, $F5D2A636, $52916F79, $8E9BBC60, $357B0CA3, $C2D7E01D, $57FE4B2E,
    $E5377715, $DA4AF09F, $0A29C958, $856BA0B1, $F4105DBD, $67053ECB, $8B4127E4, $D8957DA7,
    $667CEEFB, $9E4717DD, $07BF2DCA, $33835AAD);

  Whirlpool_C_T: array[0..7, 0..511] of LongWord = (
   ($18281818, $78D8C078, $23652323, $AF2605AF, $C657C6C6, $F9B87EF9, $E825E8E8, $6FFB136F,
    $87948787, $A1CB4CA1, $B8D5B8B8, $6211A962, $01030101, $05090805, $4FD14F4F, $6E0D426E,
    $365A3636, $EE9BADEE, $A6F7A6A6, $04FF5904, $D26BD2D2, $BD0CDEBD, $F502F5F5, $060EFB06,
    $798B7979, $8096EF80, $6FB16F6F, $CE305FCE, $91AE9191, $EF6DFCEF, $52F65252, $07F8AA07,
    $60A06060, $FD4727FD, $BCD9BCBC, $76358976, $9BB09B9B, $CD37ACCD, $8E8F8E8E, $8C8A048C,
    $A3F8A3A3, $15D27115, $0C140C0C, $3C6C603C, $7B8D7B7B, $8A84FF8A, $355F3535, $E180B5E1,
    $1D271D1D, $69F5E869, $E03DE0E0, $47B35347, $D764D7D7, $AC21F6AC, $C25BC2C2, $ED9C5EED,
    $2E722E2E, $96436D96, $4BDD4B4B, $7A29627A, $FE1FFEFE, $215DA321, $57F95757, $16D58216,
    $153F1515, $41BDA841, $77997777, $B6E89FB6, $37593737, $EB92A5EB, $E532E5E5, $569E7B56,
    $9FBC9F9F, $D9138CD9, $F00DF0F0, $1723D317, $4ADE4A4A, $7F206A7F, $DA73DADA, $95449E95,
    $58E85858, $25A2FA25, $C946C9C9, $CACF06CA, $297B2929, $8D7C558D, $0A1E0A0A, $225A5022,
    $B1CEB1B1, $4F50E14F, $A0FDA0A0, $1AC9691A, $6BBD6B6B, $DA147FDA, $85928585, $ABD95CAB,
    $BDDABDBD, $733C8173, $5DE75D5D, $348FD234, $10301010, $50908050, $F401F4F4, $0307F303,
    $CB40CBCB, $C0DD16C0, $3E423E3E, $C6D3EDC6, $050F0505, $112D2811, $67A96767, $E6781FE6,
    $E431E4E4, $53977353, $27692727, $BB0225BB, $41C34141, $58733258, $8B808B8B, $9DA72C9D,
    $A7F4A7A7, $01F65101, $7D877D7D, $94B2CF94, $95A29595, $FB49DCFB, $D875D8D8, $9F568E9F,
    $FB10FBFB, $30708B30, $EE2FEEEE, $71CD2371, $7C847C7C, $91BBC791, $66AA6666, $E37117E3,
    $DD7ADDDD, $8E7BA68E, $17391717, $4BAFB84B, $47C94747, $46450246, $9EBF9E9E, $DC1A84DC,
    $CA43CACA, $C5D41EC5, $2D772D2D, $99587599, $BFDCBFBF, $792E9179, $07090707, $1B3F381B,
    $ADEAADAD, $23AC0123, $5AEE5A5A, $2FB0EA2F, $83988383, $B5EF6CB5, $33553333, $FFB685FF,
    $63A56363, $F25C3FF2, $02060202, $0A12100A, $AAE3AAAA, $38933938, $71937171, $A8DEAFA8,
    $C845C8C8, $CFC60ECF, $192B1919, $7DD1C87D, $49DB4949, $703B7270, $D976D9D9, $9A5F869A,
    $F20BF2F2, $1D31C31D, $E338E3E3, $48A84B48, $5BED5B5B, $2AB9E22A, $88858888, $92BC3492,
    $9AB39A9A, $C83EA4C8, $266A2626, $BE0B2DBE, $32563232, $FABF8DFA, $B0CDB0B0, $4A59E94A,
    $E926E9E9, $6AF21B6A, $0F110F0F, $33777833, $D562D5D5, $A633E6A6, $809D8080, $BAF474BA,
    $BEDFBEBE, $7C27997C, $CD4ACDCD, $DEEB26DE, $345C3434, $E489BDE4, $48D84848, $75327A75,
    $FF1CFFFF, $2454AB24, $7A8E7A7A, $8F8DF78F, $90AD9090, $EA64F4EA, $5FE15F5F, $3E9DC23E,
    $20602020, $A03D1DA0, $68B86868, $D50F67D5, $1A2E1A1A, $72CAD072, $AEEFAEAE, $2CB7192C,
    $B4C1B4B4, $5E7DC95E, $54FC5454, $19CE9A19, $93A89393, $E57FECE5, $22662222, $AA2F0DAA,
    $64AC6464, $E96307E9, $F10EF1F1, $122ADB12, $73957373, $A2CCBFA2, $12361212, $5A82905A,
    $40C04040, $5D7A3A5D, $08180808, $28484028, $C358C3C3, $E89556E8, $EC29ECEC, $7BDF337B,
    $DB70DBDB, $904D9690, $A1FEA1A1, $1FC0611F, $8D8A8D8D, $83911C83, $3D473D3D, $C9C8F5C9,
    $97A49797, $F15BCCF1, $00000000, $00000000, $CF4CCFCF, $D4F936D4, $2B7D2B2B, $876E4587,
    $769A7676, $B3E197B3, $829B8282, $B0E664B0, $D667D6D6, $A928FEA9, $1B2D1B1B, $77C3D877,
    $B5C2B5B5, $5B74C15B, $AFECAFAF, $29BE1129, $6ABE6A6A, $DF1D77DF, $50F05050, $0DEABA0D,
    $45CF4545, $4C57124C, $F308F3F3, $1838CB18, $30503030, $F0AD9DF0, $EF2CEFEF, $74C42B74,
    $3F413F3F, $C3DAE5C3, $55FF5555, $1CC7921C, $A2FBA2A2, $10DB7910, $EA23EAEA, $65E90365,
    $65AF6565, $EC6A0FEC, $BAD3BABA, $6803B968, $2F712F2F, $934A6593, $C05DC0C0, $E78E4EE7,
    $DE7FDEDE, $8160BE81, $1C241C1C, $6CFCE06C, $FD1AFDFD, $2E46BB2E, $4DD74D4D, $641F5264,
    $92AB9292, $E076E4E0, $759F7575, $BCFA8FBC, $060A0606, $1E36301E, $8A838A8A, $98AE2498,
    $B2CBB2B2, $404BF940, $E637E6E6, $59856359, $0E120E0E, $367E7036, $1F211F1F, $63E7F863,
    $62A66262, $F75537F7, $D461D4D4, $A33AEEA3, $A8E5A8A8, $32812932, $96A79696, $F452C4F4,
    $F916F9F9, $3A629B3A, $C552C5C5, $F6A366F6, $256F2525, $B11035B1, $59EB5959, $20ABF220,
    $84918484, $AED054AE, $72967272, $A7C5B7A7, $394B3939, $DDECD5DD, $4CD44C4C, $61165A61,
    $5EE25E5E, $3B94CA3B, $78887878, $859FE785, $38483838, $D8E5DDD8, $8C898C8C, $86981486,
    $D16ED1D1, $B217C6B2, $A5F2A5A5, $0BE4410B, $E23BE2E2, $4DA1434D, $61A36161, $F84E2FF8,
    $B3C8B3B3, $4542F145, $21632121, $A53415A5, $9CB99C9C, $D60894D6, $1E221E1E, $66EEF066,
    $43C54343, $52612252, $C754C7C7, $FCB176FC, $FC19FCFC, $2B4FB32B, $040C0404, $14242014,
    $51F35151, $08E3B208, $99B69999, $C725BCC7, $6DB76D6D, $C4224FC4, $0D170D0D, $39656839,
    $FA13FAFA, $35798335, $DF7CDFDF, $8469B684, $7E827E7E, $9BA9D79B, $246C2424, $B4193DB4,
    $3B4D3B3B, $D7FEC5D7, $ABE0ABAB, $3D9A313D, $CE4FCECE, $D1F03ED1, $11331111, $55998855,
    $8F8C8F8F, $89830C89, $4ED24E4E, $6B044A6B, $B7C4B7B7, $5166D151, $EB20EBEB, $60E00B60,
    $3C443C3C, $CCC1FDCC, $819E8181, $BFFD7CBF, $94A19494, $FE40D4FE, $F704F7F7, $0C1CEB0C,
    $B9D6B9B9, $6718A167, $13351313, $5F8B985F, $2C742C2C, $9C517D9C, $D368D3D3, $B805D6B8,
    $E734E7E7, $5C8C6B5C, $6EB26E6E, $CB3957CB, $C451C4C4, $F3AA6EF3, $03050303, $0F1B180F,
    $56FA5656, $13DC8A13, $44CC4444, $495E1A49, $7F817F7F, $9EA0DF9E, $A9E6A9A9, $37882137,
    $2A7E2A2A, $82674D82, $BBD0BBBB, $6D0AB16D, $C15EC1C1, $E28746E2, $53F55353, $02F1A202,
    $DC79DCDC, $8B72AE8B, $0B1D0B0B, $27535827, $9DBA9D9D, $D3019CD3, $6CB46C6C, $C12B47C1,
    $31533131, $F5A495F5, $749C7474, $B9F387B9, $F607F6F6, $0915E309, $46CA4646, $434C0A43,
    $ACE9ACAC, $26A50926, $89868989, $97B53C97, $143C1414, $44B4A044, $E13EE1E1, $42BA5B42,
    $163A1616, $4EA6B04E, $3A4E3A3A, $D2F7CDD2, $69BB6969, $D0066FD0, $091B0909, $2D41482D,
    $70907070, $ADD7A7AD, $B6C7B6B6, $546FD954, $D06DD0D0, $B71ECEB7, $ED2AEDED, $7ED63B7E,
    $CC49CCCC, $DBE22EDB, $42C64242, $57682A57, $98B59898, $C22CB4C2, $A4F1A4A4, $0EED490E,
    $28782828, $88755D88, $5CE45C5C, $3186DA31, $F815F8F8, $3F6B933F, $86978686, $A4C244A4),
   ($28181878, $D8C07818, $652323AF, $2605AF23, $57C6C6F9, $B87EF9C6, $25E8E86F, $FB136FE8,
    $948787A1, $CB4CA187, $D5B8B862, $11A962B8, $03010105, $09080501, $D14F4F6E, $0D426E4F,
    $5A3636EE, $9BADEE36, $F7A6A604, $FF5904A6, $6BD2D2BD, $0CDEBDD2, $02F5F506, $0EFB06F5,
    $8B797980, $96EF8079, $B16F6FCE, $305FCE6F, $AE9191EF, $6DFCEF91, $F6525207, $F8AA0752,
    $A06060FD, $4727FD60, $D9BCBC76, $358976BC, $B09B9BCD, $37ACCD9B, $8F8E8E8C, $8A048C8E,
    $F8A3A315, $D27115A3, $140C0C3C, $6C603C0C, $8D7B7B8A, $84FF8A7B, $5F3535E1, $80B5E135,
    $271D1D69, $F5E8691D, $3DE0E047, $B35347E0, $64D7D7AC, $21F6ACD7, $5BC2C2ED, $9C5EEDC2,
    $722E2E96, $436D962E, $DD4B4B7A, $29627A4B, $1FFEFE21, $5DA321FE, $F9575716, $D5821657,
    $3F151541, $BDA84115, $997777B6, $E89FB677, $593737EB, $92A5EB37, $32E5E556, $9E7B56E5,
    $BC9F9FD9, $138CD99F, $0DF0F017, $23D317F0, $DE4A4A7F, $206A7F4A, $73DADA95, $449E95DA,
    $E8585825, $A2FA2558, $46C9C9CA, $CF06CAC9, $7B29298D, $7C558D29, $1E0A0A22, $5A50220A,
    $CEB1B14F, $50E14FB1, $FDA0A01A, $C9691AA0, $BD6B6BDA, $147FDA6B, $928585AB, $D95CAB85,
    $DABDBD73, $3C8173BD, $E75D5D34, $8FD2345D, $30101050, $90805010, $01F4F403, $07F303F4,
    $40CBCBC0, $DD16C0CB, $423E3EC6, $D3EDC63E, $0F050511, $2D281105, $A96767E6, $781FE667,
    $31E4E453, $977353E4, $692727BB, $0225BB27, $C3414158, $73325841, $808B8B9D, $A72C9D8B,
    $F4A7A701, $F65101A7, $877D7D94, $B2CF947D, $A29595FB, $49DCFB95, $75D8D89F, $568E9FD8,
    $10FBFB30, $708B30FB, $2FEEEE71, $CD2371EE, $847C7C91, $BBC7917C, $AA6666E3, $7117E366,
    $7ADDDD8E, $7BA68EDD, $3917174B, $AFB84B17, $C9474746, $45024647, $BF9E9EDC, $1A84DC9E,
    $43CACAC5, $D41EC5CA, $772D2D99, $5875992D, $DCBFBF79, $2E9179BF, $0907071B, $3F381B07,
    $EAADAD23, $AC0123AD, $EE5A5A2F, $B0EA2F5A, $988383B5, $EF6CB583, $553333FF, $B685FF33,
    $A56363F2, $5C3FF263, $0602020A, $12100A02, $E3AAAA38, $933938AA, $937171A8, $DEAFA871,
    $45C8C8CF, $C60ECFC8, $2B19197D, $D1C87D19, $DB494970, $3B727049, $76D9D99A, $5F869AD9,
    $0BF2F21D, $31C31DF2, $38E3E348, $A84B48E3, $ED5B5B2A, $B9E22A5B, $85888892, $BC349288,
    $B39A9AC8, $3EA4C89A, $6A2626BE, $0B2DBE26, $563232FA, $BF8DFA32, $CDB0B04A, $59E94AB0,
    $26E9E96A, $F21B6AE9, $110F0F33, $7778330F, $62D5D5A6, $33E6A6D5, $9D8080BA, $F474BA80,
    $DFBEBE7C, $27997CBE, $4ACDCDDE, $EB26DECD, $5C3434E4, $89BDE434, $D8484875, $327A7548,
    $1CFFFF24, $54AB24FF, $8E7A7A8F, $8DF78F7A, $AD9090EA, $64F4EA90, $E15F5F3E, $9DC23E5F,
    $602020A0, $3D1DA020, $B86868D5, $0F67D568, $2E1A1A72, $CAD0721A, $EFAEAE2C, $B7192CAE,
    $C1B4B45E, $7DC95EB4, $FC545419, $CE9A1954, $A89393E5, $7FECE593, $662222AA, $2F0DAA22,
    $AC6464E9, $6307E964, $0EF1F112, $2ADB12F1, $957373A2, $CCBFA273, $3612125A, $82905A12,
    $C040405D, $7A3A5D40, $18080828, $48402808, $58C3C3E8, $9556E8C3, $29ECEC7B, $DF337BEC,
    $70DBDB90, $4D9690DB, $FEA1A11F, $C0611FA1, $8A8D8D83, $911C838D, $473D3DC9, $C8F5C93D,
    $A49797F1, $5BCCF197, $00000000, $00000000, $4CCFCFD4, $F936D4CF, $7D2B2B87, $6E45872B,
    $9A7676B3, $E197B376, $9B8282B0, $E664B082, $67D6D6A9, $28FEA9D6, $2D1B1B77, $C3D8771B,
    $C2B5B55B, $74C15BB5, $ECAFAF29, $BE1129AF, $BE6A6ADF, $1D77DF6A, $F050500D, $EABA0D50,
    $CF45454C, $57124C45, $08F3F318, $38CB18F3, $503030F0, $AD9DF030, $2CEFEF74, $C42B74EF,
    $413F3FC3, $DAE5C33F, $FF55551C, $C7921C55, $FBA2A210, $DB7910A2, $23EAEA65, $E90365EA,
    $AF6565EC, $6A0FEC65, $D3BABA68, $03B968BA, $712F2F93, $4A65932F, $5DC0C0E7, $8E4EE7C0,
    $7FDEDE81, $60BE81DE, $241C1C6C, $FCE06C1C, $1AFDFD2E, $46BB2EFD, $D74D4D64, $1F52644D,
    $AB9292E0, $76E4E092, $9F7575BC, $FA8FBC75, $0A06061E, $36301E06, $838A8A98, $AE24988A,
    $CBB2B240, $4BF940B2, $37E6E659, $856359E6, $120E0E36, $7E70360E, $211F1F63, $E7F8631F,
    $A66262F7, $5537F762, $61D4D4A3, $3AEEA3D4, $E5A8A832, $812932A8, $A79696F4, $52C4F496,
    $16F9F93A, $629B3AF9, $52C5C5F6, $A366F6C5, $6F2525B1, $1035B125, $EB595920, $ABF22059,
    $918484AE, $D054AE84, $967272A7, $C5B7A772, $4B3939DD, $ECD5DD39, $D44C4C61, $165A614C,
    $E25E5E3B, $94CA3B5E, $88787885, $9FE78578, $483838D8, $E5DDD838, $898C8C86, $9814868C,
    $6ED1D1B2, $17C6B2D1, $F2A5A50B, $E4410BA5, $3BE2E24D, $A1434DE2, $A36161F8, $4E2FF861,
    $C8B3B345, $42F145B3, $632121A5, $3415A521, $B99C9CD6, $0894D69C, $221E1E66, $EEF0661E,
    $C5434352, $61225243, $54C7C7FC, $B176FCC7, $19FCFC2B, $4FB32BFC, $0C040414, $24201404,
    $F3515108, $E3B20851, $B69999C7, $25BCC799, $B76D6DC4, $224FC46D, $170D0D39, $6568390D,
    $13FAFA35, $798335FA, $7CDFDF84, $69B684DF, $827E7E9B, $A9D79B7E, $6C2424B4, $193DB424,
    $4D3B3BD7, $FEC5D73B, $E0ABAB3D, $9A313DAB, $4FCECED1, $F03ED1CE, $33111155, $99885511,
    $8C8F8F89, $830C898F, $D24E4E6B, $044A6B4E, $C4B7B751, $66D151B7, $20EBEB60, $E00B60EB,
    $443C3CCC, $C1FDCC3C, $9E8181BF, $FD7CBF81, $A19494FE, $40D4FE94, $04F7F70C, $1CEB0CF7,
    $D6B9B967, $18A167B9, $3513135F, $8B985F13, $742C2C9C, $517D9C2C, $68D3D3B8, $05D6B8D3,
    $34E7E75C, $8C6B5CE7, $B26E6ECB, $3957CB6E, $51C4C4F3, $AA6EF3C4, $0503030F, $1B180F03,
    $FA565613, $DC8A1356, $CC444449, $5E1A4944, $817F7F9E, $A0DF9E7F, $E6A9A937, $882137A9,
    $7E2A2A82, $674D822A, $D0BBBB6D, $0AB16DBB, $5EC1C1E2, $8746E2C1, $F5535302, $F1A20253,
    $79DCDC8B, $72AE8BDC, $1D0B0B27, $5358270B, $BA9D9DD3, $019CD39D, $B46C6CC1, $2B47C16C,
    $533131F5, $A495F531, $9C7474B9, $F387B974, $07F6F609, $15E309F6, $CA464643, $4C0A4346,
    $E9ACAC26, $A50926AC, $86898997, $B53C9789, $3C141444, $B4A04414, $3EE1E142, $BA5B42E1,
    $3A16164E, $A6B04E16, $4E3A3AD2, $F7CDD23A, $BB6969D0, $066FD069, $1B09092D, $41482D09,
    $907070AD, $D7A7AD70, $C7B6B654, $6FD954B6, $6DD0D0B7, $1ECEB7D0, $2AEDED7E, $D63B7EED,
    $49CCCCDB, $E22EDBCC, $C6424257, $682A5742, $B59898C2, $2CB4C298, $F1A4A40E, $ED490EA4,
    $78282888, $755D8828, $E45C5C31, $86DA315C, $15F8F83F, $6B933FF8, $978686A4, $C244A486),
   ($181878D8, $C0781828, $2323AF26, $05AF2365, $C6C6F9B8, $7EF9C657, $E8E86FFB, $136FE825,
    $8787A1CB, $4CA18794, $B8B86211, $A962B8D5, $01010509, $08050103, $4F4F6E0D, $426E4FD1,
    $3636EE9B, $ADEE365A, $A6A604FF, $5904A6F7, $D2D2BD0C, $DEBDD26B, $F5F5060E, $FB06F502,
    $79798096, $EF80798B, $6F6FCE30, $5FCE6FB1, $9191EF6D, $FCEF91AE, $525207F8, $AA0752F6,
    $6060FD47, $27FD60A0, $BCBC7635, $8976BCD9, $9B9BCD37, $ACCD9BB0, $8E8E8C8A, $048C8E8F,
    $A3A315D2, $7115A3F8, $0C0C3C6C, $603C0C14, $7B7B8A84, $FF8A7B8D, $3535E180, $B5E1355F,
    $1D1D69F5, $E8691D27, $E0E047B3, $5347E03D, $D7D7AC21, $F6ACD764, $C2C2ED9C, $5EEDC25B,
    $2E2E9643, $6D962E72, $4B4B7A29, $627A4BDD, $FEFE215D, $A321FE1F, $575716D5, $821657F9,
    $151541BD, $A841153F, $7777B6E8, $9FB67799, $3737EB92, $A5EB3759, $E5E5569E, $7B56E532,
    $9F9FD913, $8CD99FBC, $F0F01723, $D317F00D, $4A4A7F20, $6A7F4ADE, $DADA9544, $9E95DA73,
    $585825A2, $FA2558E8, $C9C9CACF, $06CAC946, $29298D7C, $558D297B, $0A0A225A, $50220A1E,
    $B1B14F50, $E14FB1CE, $A0A01AC9, $691AA0FD, $6B6BDA14, $7FDA6BBD, $8585ABD9, $5CAB8592,
    $BDBD733C, $8173BDDA, $5D5D348F, $D2345DE7, $10105090, $80501030, $F4F40307, $F303F401,
    $CBCBC0DD, $16C0CB40, $3E3EC6D3, $EDC63E42, $0505112D, $2811050F, $6767E678, $1FE667A9,
    $E4E45397, $7353E431, $2727BB02, $25BB2769, $41415873, $325841C3, $8B8B9DA7, $2C9D8B80,
    $A7A701F6, $5101A7F4, $7D7D94B2, $CF947D87, $9595FB49, $DCFB95A2, $D8D89F56, $8E9FD875,
    $FBFB3070, $8B30FB10, $EEEE71CD, $2371EE2F, $7C7C91BB, $C7917C84, $6666E371, $17E366AA,
    $DDDD8E7B, $A68EDD7A, $17174BAF, $B84B1739, $47474645, $024647C9, $9E9EDC1A, $84DC9EBF,
    $CACAC5D4, $1EC5CA43, $2D2D9958, $75992D77, $BFBF792E, $9179BFDC, $07071B3F, $381B0709,
    $ADAD23AC, $0123ADEA, $5A5A2FB0, $EA2F5AEE, $8383B5EF, $6CB58398, $3333FFB6, $85FF3355,
    $6363F25C, $3FF263A5, $02020A12, $100A0206, $AAAA3893, $3938AAE3, $7171A8DE, $AFA87193,
    $C8C8CFC6, $0ECFC845, $19197DD1, $C87D192B, $4949703B, $727049DB, $D9D99A5F, $869AD976,
    $F2F21D31, $C31DF20B, $E3E348A8, $4B48E338, $5B5B2AB9, $E22A5BED, $888892BC, $34928885,
    $9A9AC83E, $A4C89AB3, $2626BE0B, $2DBE266A, $3232FABF, $8DFA3256, $B0B04A59, $E94AB0CD,
    $E9E96AF2, $1B6AE926, $0F0F3377, $78330F11, $D5D5A633, $E6A6D562, $8080BAF4, $74BA809D,
    $BEBE7C27, $997CBEDF, $CDCDDEEB, $26DECD4A, $3434E489, $BDE4345C, $48487532, $7A7548D8,
    $FFFF2454, $AB24FF1C, $7A7A8F8D, $F78F7A8E, $9090EA64, $F4EA90AD, $5F5F3E9D, $C23E5FE1,
    $2020A03D, $1DA02060, $6868D50F, $67D568B8, $1A1A72CA, $D0721A2E, $AEAE2CB7, $192CAEEF,
    $B4B45E7D, $C95EB4C1, $545419CE, $9A1954FC, $9393E57F, $ECE593A8, $2222AA2F, $0DAA2266,
    $6464E963, $07E964AC, $F1F1122A, $DB12F10E, $7373A2CC, $BFA27395, $12125A82, $905A1236,
    $40405D7A, $3A5D40C0, $08082848, $40280818, $C3C3E895, $56E8C358, $ECEC7BDF, $337BEC29,
    $DBDB904D, $9690DB70, $A1A11FC0, $611FA1FE, $8D8D8391, $1C838D8A, $3D3DC9C8, $F5C93D47,
    $9797F15B, $CCF197A4, $00000000, $00000000, $CFCFD4F9, $36D4CF4C, $2B2B876E, $45872B7D,
    $7676B3E1, $97B3769A, $8282B0E6, $64B0829B, $D6D6A928, $FEA9D667, $1B1B77C3, $D8771B2D,
    $B5B55B74, $C15BB5C2, $AFAF29BE, $1129AFEC, $6A6ADF1D, $77DF6ABE, $50500DEA, $BA0D50F0,
    $45454C57, $124C45CF, $F3F31838, $CB18F308, $3030F0AD, $9DF03050, $EFEF74C4, $2B74EF2C,
    $3F3FC3DA, $E5C33F41, $55551CC7, $921C55FF, $A2A210DB, $7910A2FB, $EAEA65E9, $0365EA23,
    $6565EC6A, $0FEC65AF, $BABA6803, $B968BAD3, $2F2F934A, $65932F71, $C0C0E78E, $4EE7C05D,
    $DEDE8160, $BE81DE7F, $1C1C6CFC, $E06C1C24, $FDFD2E46, $BB2EFD1A, $4D4D641F, $52644DD7,
    $9292E076, $E4E092AB, $7575BCFA, $8FBC759F, $06061E36, $301E060A, $8A8A98AE, $24988A83,
    $B2B2404B, $F940B2CB, $E6E65985, $6359E637, $0E0E367E, $70360E12, $1F1F63E7, $F8631F21,
    $6262F755, $37F762A6, $D4D4A33A, $EEA3D461, $A8A83281, $2932A8E5, $9696F452, $C4F496A7,
    $F9F93A62, $9B3AF916, $C5C5F6A3, $66F6C552, $2525B110, $35B1256F, $595920AB, $F22059EB,
    $8484AED0, $54AE8491, $7272A7C5, $B7A77296, $3939DDEC, $D5DD394B, $4C4C6116, $5A614CD4,
    $5E5E3B94, $CA3B5EE2, $7878859F, $E7857888, $3838D8E5, $DDD83848, $8C8C8698, $14868C89,
    $D1D1B217, $C6B2D16E, $A5A50BE4, $410BA5F2, $E2E24DA1, $434DE23B, $6161F84E, $2FF861A3,
    $B3B34542, $F145B3C8, $2121A534, $15A52163, $9C9CD608, $94D69CB9, $1E1E66EE, $F0661E22,
    $43435261, $225243C5, $C7C7FCB1, $76FCC754, $FCFC2B4F, $B32BFC19, $04041424, $2014040C,
    $515108E3, $B20851F3, $9999C725, $BCC799B6, $6D6DC422, $4FC46DB7, $0D0D3965, $68390D17,
    $FAFA3579, $8335FA13, $DFDF8469, $B684DF7C, $7E7E9BA9, $D79B7E82, $2424B419, $3DB4246C,
    $3B3BD7FE, $C5D73B4D, $ABAB3D9A, $313DABE0, $CECED1F0, $3ED1CE4F, $11115599, $88551133,
    $8F8F8983, $0C898F8C, $4E4E6B04, $4A6B4ED2, $B7B75166, $D151B7C4, $EBEB60E0, $0B60EB20,
    $3C3CCCC1, $FDCC3C44, $8181BFFD, $7CBF819E, $9494FE40, $D4FE94A1, $F7F70C1C, $EB0CF704,
    $B9B96718, $A167B9D6, $13135F8B, $985F1335, $2C2C9C51, $7D9C2C74, $D3D3B805, $D6B8D368,
    $E7E75C8C, $6B5CE734, $6E6ECB39, $57CB6EB2, $C4C4F3AA, $6EF3C451, $03030F1B, $180F0305,
    $565613DC, $8A1356FA, $4444495E, $1A4944CC, $7F7F9EA0, $DF9E7F81, $A9A93788, $2137A9E6,
    $2A2A8267, $4D822A7E, $BBBB6D0A, $B16DBBD0, $C1C1E287, $46E2C15E, $535302F1, $A20253F5,
    $DCDC8B72, $AE8BDC79, $0B0B2753, $58270B1D, $9D9DD301, $9CD39DBA, $6C6CC12B, $47C16CB4,
    $3131F5A4, $95F53153, $7474B9F3, $87B9749C, $F6F60915, $E309F607, $4646434C, $0A4346CA,
    $ACAC26A5, $0926ACE9, $898997B5, $3C978986, $141444B4, $A044143C, $E1E142BA, $5B42E13E,
    $16164EA6, $B04E163A, $3A3AD2F7, $CDD23A4E, $6969D006, $6FD069BB, $09092D41, $482D091B,
    $7070ADD7, $A7AD7090, $B6B6546F, $D954B6C7, $D0D0B71E, $CEB7D06D, $EDED7ED6, $3B7EED2A,
    $CCCCDBE2, $2EDBCC49, $42425768, $2A5742C6, $9898C22C, $B4C298B5, $A4A40EED, $490EA4F1,
    $28288875, $5D882878, $5C5C3186, $DA315CE4, $F8F83F6B, $933FF815, $8686A4C2, $44A48697),
   ($1878D8C0, $78182818, $23AF2605, $AF236523, $C6F9B87E, $F9C657C6, $E86FFB13, $6FE825E8,
    $87A1CB4C, $A1879487, $B86211A9, $62B8D5B8, $01050908, $05010301, $4F6E0D42, $6E4FD14F,
    $36EE9BAD, $EE365A36, $A604FF59, $04A6F7A6, $D2BD0CDE, $BDD26BD2, $F5060EFB, $06F502F5,
    $798096EF, $80798B79, $6FCE305F, $CE6FB16F, $91EF6DFC, $EF91AE91, $5207F8AA, $0752F652,
    $60FD4727, $FD60A060, $BC763589, $76BCD9BC, $9BCD37AC, $CD9BB09B, $8E8C8A04, $8C8E8F8E,
    $A315D271, $15A3F8A3, $0C3C6C60, $3C0C140C, $7B8A84FF, $8A7B8D7B, $35E180B5, $E1355F35,
    $1D69F5E8, $691D271D, $E047B353, $47E03DE0, $D7AC21F6, $ACD764D7, $C2ED9C5E, $EDC25BC2,
    $2E96436D, $962E722E, $4B7A2962, $7A4BDD4B, $FE215DA3, $21FE1FFE, $5716D582, $1657F957,
    $1541BDA8, $41153F15, $77B6E89F, $B6779977, $37EB92A5, $EB375937, $E5569E7B, $56E532E5,
    $9FD9138C, $D99FBC9F, $F01723D3, $17F00DF0, $4A7F206A, $7F4ADE4A, $DA95449E, $95DA73DA,
    $5825A2FA, $2558E858, $C9CACF06, $CAC946C9, $298D7C55, $8D297B29, $0A225A50, $220A1E0A,
    $B14F50E1, $4FB1CEB1, $A01AC969, $1AA0FDA0, $6BDA147F, $DA6BBD6B, $85ABD95C, $AB859285,
    $BD733C81, $73BDDABD, $5D348FD2, $345DE75D, $10509080, $50103010, $F40307F3, $03F401F4,
    $CBC0DD16, $C0CB40CB, $3EC6D3ED, $C63E423E, $05112D28, $11050F05, $67E6781F, $E667A967,
    $E4539773, $53E431E4, $27BB0225, $BB276927, $41587332, $5841C341, $8B9DA72C, $9D8B808B,
    $A701F651, $01A7F4A7, $7D94B2CF, $947D877D, $95FB49DC, $FB95A295, $D89F568E, $9FD875D8,
    $FB30708B, $30FB10FB, $EE71CD23, $71EE2FEE, $7C91BBC7, $917C847C, $66E37117, $E366AA66,
    $DD8E7BA6, $8EDD7ADD, $174BAFB8, $4B173917, $47464502, $4647C947, $9EDC1A84, $DC9EBF9E,
    $CAC5D41E, $C5CA43CA, $2D995875, $992D772D, $BF792E91, $79BFDCBF, $071B3F38, $1B070907,
    $AD23AC01, $23ADEAAD, $5A2FB0EA, $2F5AEE5A, $83B5EF6C, $B5839883, $33FFB685, $FF335533,
    $63F25C3F, $F263A563, $020A1210, $0A020602, $AA389339, $38AAE3AA, $71A8DEAF, $A8719371,
    $C8CFC60E, $CFC845C8, $197DD1C8, $7D192B19, $49703B72, $7049DB49, $D99A5F86, $9AD976D9,
    $F21D31C3, $1DF20BF2, $E348A84B, $48E338E3, $5B2AB9E2, $2A5BED5B, $8892BC34, $92888588,
    $9AC83EA4, $C89AB39A, $26BE0B2D, $BE266A26, $32FABF8D, $FA325632, $B04A59E9, $4AB0CDB0,
    $E96AF21B, $6AE926E9, $0F337778, $330F110F, $D5A633E6, $A6D562D5, $80BAF474, $BA809D80,
    $BE7C2799, $7CBEDFBE, $CDDEEB26, $DECD4ACD, $34E489BD, $E4345C34, $4875327A, $7548D848,
    $FF2454AB, $24FF1CFF, $7A8F8DF7, $8F7A8E7A, $90EA64F4, $EA90AD90, $5F3E9DC2, $3E5FE15F,
    $20A03D1D, $A0206020, $68D50F67, $D568B868, $1A72CAD0, $721A2E1A, $AE2CB719, $2CAEEFAE,
    $B45E7DC9, $5EB4C1B4, $5419CE9A, $1954FC54, $93E57FEC, $E593A893, $22AA2F0D, $AA226622,
    $64E96307, $E964AC64, $F1122ADB, $12F10EF1, $73A2CCBF, $A2739573, $125A8290, $5A123612,
    $405D7A3A, $5D40C040, $08284840, $28081808, $C3E89556, $E8C358C3, $EC7BDF33, $7BEC29EC,
    $DB904D96, $90DB70DB, $A11FC061, $1FA1FEA1, $8D83911C, $838D8A8D, $3DC9C8F5, $C93D473D,
    $97F15BCC, $F197A497, $00000000, $00000000, $CFD4F936, $D4CF4CCF, $2B876E45, $872B7D2B,
    $76B3E197, $B3769A76, $82B0E664, $B0829B82, $D6A928FE, $A9D667D6, $1B77C3D8, $771B2D1B,
    $B55B74C1, $5BB5C2B5, $AF29BE11, $29AFECAF, $6ADF1D77, $DF6ABE6A, $500DEABA, $0D50F050,
    $454C5712, $4C45CF45, $F31838CB, $18F308F3, $30F0AD9D, $F0305030, $EF74C42B, $74EF2CEF,
    $3FC3DAE5, $C33F413F, $551CC792, $1C55FF55, $A210DB79, $10A2FBA2, $EA65E903, $65EA23EA,
    $65EC6A0F, $EC65AF65, $BA6803B9, $68BAD3BA, $2F934A65, $932F712F, $C0E78E4E, $E7C05DC0,
    $DE8160BE, $81DE7FDE, $1C6CFCE0, $6C1C241C, $FD2E46BB, $2EFD1AFD, $4D641F52, $644DD74D,
    $92E076E4, $E092AB92, $75BCFA8F, $BC759F75, $061E3630, $1E060A06, $8A98AE24, $988A838A,
    $B2404BF9, $40B2CBB2, $E6598563, $59E637E6, $0E367E70, $360E120E, $1F63E7F8, $631F211F,
    $62F75537, $F762A662, $D4A33AEE, $A3D461D4, $A8328129, $32A8E5A8, $96F452C4, $F496A796,
    $F93A629B, $3AF916F9, $C5F6A366, $F6C552C5, $25B11035, $B1256F25, $5920ABF2, $2059EB59,
    $84AED054, $AE849184, $72A7C5B7, $A7729672, $39DDECD5, $DD394B39, $4C61165A, $614CD44C,
    $5E3B94CA, $3B5EE25E, $78859FE7, $85788878, $38D8E5DD, $D8384838, $8C869814, $868C898C,
    $D1B217C6, $B2D16ED1, $A50BE441, $0BA5F2A5, $E24DA143, $4DE23BE2, $61F84E2F, $F861A361,
    $B34542F1, $45B3C8B3, $21A53415, $A5216321, $9CD60894, $D69CB99C, $1E66EEF0, $661E221E,
    $43526122, $5243C543, $C7FCB176, $FCC754C7, $FC2B4FB3, $2BFC19FC, $04142420, $14040C04,
    $5108E3B2, $0851F351, $99C725BC, $C799B699, $6DC4224F, $C46DB76D, $0D396568, $390D170D,
    $FA357983, $35FA13FA, $DF8469B6, $84DF7CDF, $7E9BA9D7, $9B7E827E, $24B4193D, $B4246C24,
    $3BD7FEC5, $D73B4D3B, $AB3D9A31, $3DABE0AB, $CED1F03E, $D1CE4FCE, $11559988, $55113311,
    $8F89830C, $898F8C8F, $4E6B044A, $6B4ED24E, $B75166D1, $51B7C4B7, $EB60E00B, $60EB20EB,
    $3CCCC1FD, $CC3C443C, $81BFFD7C, $BF819E81, $94FE40D4, $FE94A194, $F70C1CEB, $0CF704F7,
    $B96718A1, $67B9D6B9, $135F8B98, $5F133513, $2C9C517D, $9C2C742C, $D3B805D6, $B8D368D3,
    $E75C8C6B, $5CE734E7, $6ECB3957, $CB6EB26E, $C4F3AA6E, $F3C451C4, $030F1B18, $0F030503,
    $5613DC8A, $1356FA56, $44495E1A, $4944CC44, $7F9EA0DF, $9E7F817F, $A9378821, $37A9E6A9,
    $2A82674D, $822A7E2A, $BB6D0AB1, $6DBBD0BB, $C1E28746, $E2C15EC1, $5302F1A2, $0253F553,
    $DC8B72AE, $8BDC79DC, $0B275358, $270B1D0B, $9DD3019C, $D39DBA9D, $6CC12B47, $C16CB46C,
    $31F5A495, $F5315331, $74B9F387, $B9749C74, $F60915E3, $09F607F6, $46434C0A, $4346CA46,
    $AC26A509, $26ACE9AC, $8997B53C, $97898689, $1444B4A0, $44143C14, $E142BA5B, $42E13EE1,
    $164EA6B0, $4E163A16, $3AD2F7CD, $D23A4E3A, $69D0066F, $D069BB69, $092D4148, $2D091B09,
    $70ADD7A7, $AD709070, $B6546FD9, $54B6C7B6, $D0B71ECE, $B7D06DD0, $ED7ED63B, $7EED2AED,
    $CCDBE22E, $DBCC49CC, $4257682A, $5742C642, $98C22CB4, $C298B598, $A40EED49, $0EA4F1A4,
    $2888755D, $88287828, $5C3186DA, $315CE45C, $F83F6B93, $3FF815F8, $86A4C244, $A4869786),
   ($78D8C078, $18281818, $AF2605AF, $23652323, $F9B87EF9, $C657C6C6, $6FFB136F, $E825E8E8,
    $A1CB4CA1, $87948787, $6211A962, $B8D5B8B8, $05090805, $01030101, $6E0D426E, $4FD14F4F,
    $EE9BADEE, $365A3636, $04FF5904, $A6F7A6A6, $BD0CDEBD, $D26BD2D2, $060EFB06, $F502F5F5,
    $8096EF80, $798B7979, $CE305FCE, $6FB16F6F, $EF6DFCEF, $91AE9191, $07F8AA07, $52F65252,
    $FD4727FD, $60A06060, $76358976, $BCD9BCBC, $CD37ACCD, $9BB09B9B, $8C8A048C, $8E8F8E8E,
    $15D27115, $A3F8A3A3, $3C6C603C, $0C140C0C, $8A84FF8A, $7B8D7B7B, $E180B5E1, $355F3535,
    $69F5E869, $1D271D1D, $47B35347, $E03DE0E0, $AC21F6AC, $D764D7D7, $ED9C5EED, $C25BC2C2,
    $96436D96, $2E722E2E, $7A29627A, $4BDD4B4B, $215DA321, $FE1FFEFE, $16D58216, $57F95757,
    $41BDA841, $153F1515, $B6E89FB6, $77997777, $EB92A5EB, $37593737, $569E7B56, $E532E5E5,
    $D9138CD9, $9FBC9F9F, $1723D317, $F00DF0F0, $7F206A7F, $4ADE4A4A, $95449E95, $DA73DADA,
    $25A2FA25, $58E85858, $CACF06CA, $C946C9C9, $8D7C558D, $297B2929, $225A5022, $0A1E0A0A,
    $4F50E14F, $B1CEB1B1, $1AC9691A, $A0FDA0A0, $DA147FDA, $6BBD6B6B, $ABD95CAB, $85928585,
    $733C8173, $BDDABDBD, $348FD234, $5DE75D5D, $50908050, $10301010, $0307F303, $F401F4F4,
    $C0DD16C0, $CB40CBCB, $C6D3EDC6, $3E423E3E, $112D2811, $050F0505, $E6781FE6, $67A96767,
    $53977353, $E431E4E4, $BB0225BB, $27692727, $58733258, $41C34141, $9DA72C9D, $8B808B8B,
    $01F65101, $A7F4A7A7, $94B2CF94, $7D877D7D, $FB49DCFB, $95A29595, $9F568E9F, $D875D8D8,
    $30708B30, $FB10FBFB, $71CD2371, $EE2FEEEE, $91BBC791, $7C847C7C, $E37117E3, $66AA6666,
    $8E7BA68E, $DD7ADDDD, $4BAFB84B, $17391717, $46450246, $47C94747, $DC1A84DC, $9EBF9E9E,
    $C5D41EC5, $CA43CACA, $99587599, $2D772D2D, $792E9179, $BFDCBFBF, $1B3F381B, $07090707,
    $23AC0123, $ADEAADAD, $2FB0EA2F, $5AEE5A5A, $B5EF6CB5, $83988383, $FFB685FF, $33553333,
    $F25C3FF2, $63A56363, $0A12100A, $02060202, $38933938, $AAE3AAAA, $A8DEAFA8, $71937171,
    $CFC60ECF, $C845C8C8, $7DD1C87D, $192B1919, $703B7270, $49DB4949, $9A5F869A, $D976D9D9,
    $1D31C31D, $F20BF2F2, $48A84B48, $E338E3E3, $2AB9E22A, $5BED5B5B, $92BC3492, $88858888,
    $C83EA4C8, $9AB39A9A, $BE0B2DBE, $266A2626, $FABF8DFA, $32563232, $4A59E94A, $B0CDB0B0,
    $6AF21B6A, $E926E9E9, $33777833, $0F110F0F, $A633E6A6, $D562D5D5, $BAF474BA, $809D8080,
    $7C27997C, $BEDFBEBE, $DEEB26DE, $CD4ACDCD, $E489BDE4, $345C3434, $75327A75, $48D84848,
    $2454AB24, $FF1CFFFF, $8F8DF78F, $7A8E7A7A, $EA64F4EA, $90AD9090, $3E9DC23E, $5FE15F5F,
    $A03D1DA0, $20602020, $D50F67D5, $68B86868, $72CAD072, $1A2E1A1A, $2CB7192C, $AEEFAEAE,
    $5E7DC95E, $B4C1B4B4, $19CE9A19, $54FC5454, $E57FECE5, $93A89393, $AA2F0DAA, $22662222,
    $E96307E9, $64AC6464, $122ADB12, $F10EF1F1, $A2CCBFA2, $73957373, $5A82905A, $12361212,
    $5D7A3A5D, $40C04040, $28484028, $08180808, $E89556E8, $C358C3C3, $7BDF337B, $EC29ECEC,
    $904D9690, $DB70DBDB, $1FC0611F, $A1FEA1A1, $83911C83, $8D8A8D8D, $C9C8F5C9, $3D473D3D,
    $F15BCCF1, $97A49797, $00000000, $00000000, $D4F936D4, $CF4CCFCF, $876E4587, $2B7D2B2B,
    $B3E197B3, $769A7676, $B0E664B0, $829B8282, $A928FEA9, $D667D6D6, $77C3D877, $1B2D1B1B,
    $5B74C15B, $B5C2B5B5, $29BE1129, $AFECAFAF, $DF1D77DF, $6ABE6A6A, $0DEABA0D, $50F05050,
    $4C57124C, $45CF4545, $1838CB18, $F308F3F3, $F0AD9DF0, $30503030, $74C42B74, $EF2CEFEF,
    $C3DAE5C3, $3F413F3F, $1CC7921C, $55FF5555, $10DB7910, $A2FBA2A2, $65E90365, $EA23EAEA,
    $EC6A0FEC, $65AF6565, $6803B968, $BAD3BABA, $934A6593, $2F712F2F, $E78E4EE7, $C05DC0C0,
    $8160BE81, $DE7FDEDE, $6CFCE06C, $1C241C1C, $2E46BB2E, $FD1AFDFD, $641F5264, $4DD74D4D,
    $E076E4E0, $92AB9292, $BCFA8FBC, $759F7575, $1E36301E, $060A0606, $98AE2498, $8A838A8A,
    $404BF940, $B2CBB2B2, $59856359, $E637E6E6, $367E7036, $0E120E0E, $63E7F863, $1F211F1F,
    $F75537F7, $62A66262, $A33AEEA3, $D461D4D4, $32812932, $A8E5A8A8, $F452C4F4, $96A79696,
    $3A629B3A, $F916F9F9, $F6A366F6, $C552C5C5, $B11035B1, $256F2525, $20ABF220, $59EB5959,
    $AED054AE, $84918484, $A7C5B7A7, $72967272, $DDECD5DD, $394B3939, $61165A61, $4CD44C4C,
    $3B94CA3B, $5EE25E5E, $859FE785, $78887878, $D8E5DDD8, $38483838, $86981486, $8C898C8C,
    $B217C6B2, $D16ED1D1, $0BE4410B, $A5F2A5A5, $4DA1434D, $E23BE2E2, $F84E2FF8, $61A36161,
    $4542F145, $B3C8B3B3, $A53415A5, $21632121, $D60894D6, $9CB99C9C, $66EEF066, $1E221E1E,
    $52612252, $43C54343, $FCB176FC, $C754C7C7, $2B4FB32B, $FC19FCFC, $14242014, $040C0404,
    $08E3B208, $51F35151, $C725BCC7, $99B69999, $C4224FC4, $6DB76D6D, $39656839, $0D170D0D,
    $35798335, $FA13FAFA, $8469B684, $DF7CDFDF, $9BA9D79B, $7E827E7E, $B4193DB4, $246C2424,
    $D7FEC5D7, $3B4D3B3B, $3D9A313D, $ABE0ABAB, $D1F03ED1, $CE4FCECE, $55998855, $11331111,
    $89830C89, $8F8C8F8F, $6B044A6B, $4ED24E4E, $5166D151, $B7C4B7B7, $60E00B60, $EB20EBEB,
    $CCC1FDCC, $3C443C3C, $BFFD7CBF, $819E8181, $FE40D4FE, $94A19494, $0C1CEB0C, $F704F7F7,
    $6718A167, $B9D6B9B9, $5F8B985F, $13351313, $9C517D9C, $2C742C2C, $B805D6B8, $D368D3D3,
    $5C8C6B5C, $E734E7E7, $CB3957CB, $6EB26E6E, $F3AA6EF3, $C451C4C4, $0F1B180F, $03050303,
    $13DC8A13, $56FA5656, $495E1A49, $44CC4444, $9EA0DF9E, $7F817F7F, $37882137, $A9E6A9A9,
    $82674D82, $2A7E2A2A, $6D0AB16D, $BBD0BBBB, $E28746E2, $C15EC1C1, $02F1A202, $53F55353,
    $8B72AE8B, $DC79DCDC, $27535827, $0B1D0B0B, $D3019CD3, $9DBA9D9D, $C12B47C1, $6CB46C6C,
    $F5A495F5, $31533131, $B9F387B9, $749C7474, $0915E309, $F607F6F6, $434C0A43, $46CA4646,
    $26A50926, $ACE9ACAC, $97B53C97, $89868989, $44B4A044, $143C1414, $42BA5B42, $E13EE1E1,
    $4EA6B04E, $163A1616, $D2F7CDD2, $3A4E3A3A, $D0066FD0, $69BB6969, $2D41482D, $091B0909,
    $ADD7A7AD, $70907070, $546FD954, $B6C7B6B6, $B71ECEB7, $D06DD0D0, $7ED63B7E, $ED2AEDED,
    $DBE22EDB, $CC49CCCC, $57682A57, $42C64242, $C22CB4C2, $98B59898, $0EED490E, $A4F1A4A4,
    $88755D88, $28782828, $3186DA31, $5CE45C5C, $3F6B933F, $F815F8F8, $A4C244A4, $86978686),
   ($D8C07818, $28181878, $2605AF23, $652323AF, $B87EF9C6, $57C6C6F9, $FB136FE8, $25E8E86F,
    $CB4CA187, $948787A1, $11A962B8, $D5B8B862, $09080501, $03010105, $0D426E4F, $D14F4F6E,
    $9BADEE36, $5A3636EE, $FF5904A6, $F7A6A604, $0CDEBDD2, $6BD2D2BD, $0EFB06F5, $02F5F506,
    $96EF8079, $8B797980, $305FCE6F, $B16F6FCE, $6DFCEF91, $AE9191EF, $F8AA0752, $F6525207,
    $4727FD60, $A06060FD, $358976BC, $D9BCBC76, $37ACCD9B, $B09B9BCD, $8A048C8E, $8F8E8E8C,
    $D27115A3, $F8A3A315, $6C603C0C, $140C0C3C, $84FF8A7B, $8D7B7B8A, $80B5E135, $5F3535E1,
    $F5E8691D, $271D1D69, $B35347E0, $3DE0E047, $21F6ACD7, $64D7D7AC, $9C5EEDC2, $5BC2C2ED,
    $436D962E, $722E2E96, $29627A4B, $DD4B4B7A, $5DA321FE, $1FFEFE21, $D5821657, $F9575716,
    $BDA84115, $3F151541, $E89FB677, $997777B6, $92A5EB37, $593737EB, $9E7B56E5, $32E5E556,
    $138CD99F, $BC9F9FD9, $23D317F0, $0DF0F017, $206A7F4A, $DE4A4A7F, $449E95DA, $73DADA95,
    $A2FA2558, $E8585825, $CF06CAC9, $46C9C9CA, $7C558D29, $7B29298D, $5A50220A, $1E0A0A22,
    $50E14FB1, $CEB1B14F, $C9691AA0, $FDA0A01A, $147FDA6B, $BD6B6BDA, $D95CAB85, $928585AB,
    $3C8173BD, $DABDBD73, $8FD2345D, $E75D5D34, $90805010, $30101050, $07F303F4, $01F4F403,
    $DD16C0CB, $40CBCBC0, $D3EDC63E, $423E3EC6, $2D281105, $0F050511, $781FE667, $A96767E6,
    $977353E4, $31E4E453, $0225BB27, $692727BB, $73325841, $C3414158, $A72C9D8B, $808B8B9D,
    $F65101A7, $F4A7A701, $B2CF947D, $877D7D94, $49DCFB95, $A29595FB, $568E9FD8, $75D8D89F,
    $708B30FB, $10FBFB30, $CD2371EE, $2FEEEE71, $BBC7917C, $847C7C91, $7117E366, $AA6666E3,
    $7BA68EDD, $7ADDDD8E, $AFB84B17, $3917174B, $45024647, $C9474746, $1A84DC9E, $BF9E9EDC,
    $D41EC5CA, $43CACAC5, $5875992D, $772D2D99, $2E9179BF, $DCBFBF79, $3F381B07, $0907071B,
    $AC0123AD, $EAADAD23, $B0EA2F5A, $EE5A5A2F, $EF6CB583, $988383B5, $B685FF33, $553333FF,
    $5C3FF263, $A56363F2, $12100A02, $0602020A, $933938AA, $E3AAAA38, $DEAFA871, $937171A8,
    $C60ECFC8, $45C8C8CF, $D1C87D19, $2B19197D, $3B727049, $DB494970, $5F869AD9, $76D9D99A,
    $31C31DF2, $0BF2F21D, $A84B48E3, $38E3E348, $B9E22A5B, $ED5B5B2A, $BC349288, $85888892,
    $3EA4C89A, $B39A9AC8, $0B2DBE26, $6A2626BE, $BF8DFA32, $563232FA, $59E94AB0, $CDB0B04A,
    $F21B6AE9, $26E9E96A, $7778330F, $110F0F33, $33E6A6D5, $62D5D5A6, $F474BA80, $9D8080BA,
    $27997CBE, $DFBEBE7C, $EB26DECD, $4ACDCDDE, $89BDE434, $5C3434E4, $327A7548, $D8484875,
    $54AB24FF, $1CFFFF24, $8DF78F7A, $8E7A7A8F, $64F4EA90, $AD9090EA, $9DC23E5F, $E15F5F3E,
    $3D1DA020, $602020A0, $0F67D568, $B86868D5, $CAD0721A, $2E1A1A72, $B7192CAE, $EFAEAE2C,
    $7DC95EB4, $C1B4B45E, $CE9A1954, $FC545419, $7FECE593, $A89393E5, $2F0DAA22, $662222AA,
    $6307E964, $AC6464E9, $2ADB12F1, $0EF1F112, $CCBFA273, $957373A2, $82905A12, $3612125A,
    $7A3A5D40, $C040405D, $48402808, $18080828, $9556E8C3, $58C3C3E8, $DF337BEC, $29ECEC7B,
    $4D9690DB, $70DBDB90, $C0611FA1, $FEA1A11F, $911C838D, $8A8D8D83, $C8F5C93D, $473D3DC9,
    $5BCCF197, $A49797F1, $00000000, $00000000, $F936D4CF, $4CCFCFD4, $6E45872B, $7D2B2B87,
    $E197B376, $9A7676B3, $E664B082, $9B8282B0, $28FEA9D6, $67D6D6A9, $C3D8771B, $2D1B1B77,
    $74C15BB5, $C2B5B55B, $BE1129AF, $ECAFAF29, $1D77DF6A, $BE6A6ADF, $EABA0D50, $F050500D,
    $57124C45, $CF45454C, $38CB18F3, $08F3F318, $AD9DF030, $503030F0, $C42B74EF, $2CEFEF74,
    $DAE5C33F, $413F3FC3, $C7921C55, $FF55551C, $DB7910A2, $FBA2A210, $E90365EA, $23EAEA65,
    $6A0FEC65, $AF6565EC, $03B968BA, $D3BABA68, $4A65932F, $712F2F93, $8E4EE7C0, $5DC0C0E7,
    $60BE81DE, $7FDEDE81, $FCE06C1C, $241C1C6C, $46BB2EFD, $1AFDFD2E, $1F52644D, $D74D4D64,
    $76E4E092, $AB9292E0, $FA8FBC75, $9F7575BC, $36301E06, $0A06061E, $AE24988A, $838A8A98,
    $4BF940B2, $CBB2B240, $856359E6, $37E6E659, $7E70360E, $120E0E36, $E7F8631F, $211F1F63,
    $5537F762, $A66262F7, $3AEEA3D4, $61D4D4A3, $812932A8, $E5A8A832, $52C4F496, $A79696F4,
    $629B3AF9, $16F9F93A, $A366F6C5, $52C5C5F6, $1035B125, $6F2525B1, $ABF22059, $EB595920,
    $D054AE84, $918484AE, $C5B7A772, $967272A7, $ECD5DD39, $4B3939DD, $165A614C, $D44C4C61,
    $94CA3B5E, $E25E5E3B, $9FE78578, $88787885, $E5DDD838, $483838D8, $9814868C, $898C8C86,
    $17C6B2D1, $6ED1D1B2, $E4410BA5, $F2A5A50B, $A1434DE2, $3BE2E24D, $4E2FF861, $A36161F8,
    $42F145B3, $C8B3B345, $3415A521, $632121A5, $0894D69C, $B99C9CD6, $EEF0661E, $221E1E66,
    $61225243, $C5434352, $B176FCC7, $54C7C7FC, $4FB32BFC, $19FCFC2B, $24201404, $0C040414,
    $E3B20851, $F3515108, $25BCC799, $B69999C7, $224FC46D, $B76D6DC4, $6568390D, $170D0D39,
    $798335FA, $13FAFA35, $69B684DF, $7CDFDF84, $A9D79B7E, $827E7E9B, $193DB424, $6C2424B4,
    $FEC5D73B, $4D3B3BD7, $9A313DAB, $E0ABAB3D, $F03ED1CE, $4FCECED1, $99885511, $33111155,
    $830C898F, $8C8F8F89, $044A6B4E, $D24E4E6B, $66D151B7, $C4B7B751, $E00B60EB, $20EBEB60,
    $C1FDCC3C, $443C3CCC, $FD7CBF81, $9E8181BF, $40D4FE94, $A19494FE, $1CEB0CF7, $04F7F70C,
    $18A167B9, $D6B9B967, $8B985F13, $3513135F, $517D9C2C, $742C2C9C, $05D6B8D3, $68D3D3B8,
    $8C6B5CE7, $34E7E75C, $3957CB6E, $B26E6ECB, $AA6EF3C4, $51C4C4F3, $1B180F03, $0503030F,
    $DC8A1356, $FA565613, $5E1A4944, $CC444449, $A0DF9E7F, $817F7F9E, $882137A9, $E6A9A937,
    $674D822A, $7E2A2A82, $0AB16DBB, $D0BBBB6D, $8746E2C1, $5EC1C1E2, $F1A20253, $F5535302,
    $72AE8BDC, $79DCDC8B, $5358270B, $1D0B0B27, $019CD39D, $BA9D9DD3, $2B47C16C, $B46C6CC1,
    $A495F531, $533131F5, $F387B974, $9C7474B9, $15E309F6, $07F6F609, $4C0A4346, $CA464643,
    $A50926AC, $E9ACAC26, $B53C9789, $86898997, $B4A04414, $3C141444, $BA5B42E1, $3EE1E142,
    $A6B04E16, $3A16164E, $F7CDD23A, $4E3A3AD2, $066FD069, $BB6969D0, $41482D09, $1B09092D,
    $D7A7AD70, $907070AD, $6FD954B6, $C7B6B654, $1ECEB7D0, $6DD0D0B7, $D63B7EED, $2AEDED7E,
    $E22EDBCC, $49CCCCDB, $682A5742, $C6424257, $2CB4C298, $B59898C2, $ED490EA4, $F1A4A40E,
    $755D8828, $78282888, $86DA315C, $E45C5C31, $6B933FF8, $15F8F83F, $C244A486, $978686A4),
   ($C0781828, $181878D8, $05AF2365, $2323AF26, $7EF9C657, $C6C6F9B8, $136FE825, $E8E86FFB,
    $4CA18794, $8787A1CB, $A962B8D5, $B8B86211, $08050103, $01010509, $426E4FD1, $4F4F6E0D,
    $ADEE365A, $3636EE9B, $5904A6F7, $A6A604FF, $DEBDD26B, $D2D2BD0C, $FB06F502, $F5F5060E,
    $EF80798B, $79798096, $5FCE6FB1, $6F6FCE30, $FCEF91AE, $9191EF6D, $AA0752F6, $525207F8,
    $27FD60A0, $6060FD47, $8976BCD9, $BCBC7635, $ACCD9BB0, $9B9BCD37, $048C8E8F, $8E8E8C8A,
    $7115A3F8, $A3A315D2, $603C0C14, $0C0C3C6C, $FF8A7B8D, $7B7B8A84, $B5E1355F, $3535E180,
    $E8691D27, $1D1D69F5, $5347E03D, $E0E047B3, $F6ACD764, $D7D7AC21, $5EEDC25B, $C2C2ED9C,
    $6D962E72, $2E2E9643, $627A4BDD, $4B4B7A29, $A321FE1F, $FEFE215D, $821657F9, $575716D5,
    $A841153F, $151541BD, $9FB67799, $7777B6E8, $A5EB3759, $3737EB92, $7B56E532, $E5E5569E,
    $8CD99FBC, $9F9FD913, $D317F00D, $F0F01723, $6A7F4ADE, $4A4A7F20, $9E95DA73, $DADA9544,
    $FA2558E8, $585825A2, $06CAC946, $C9C9CACF, $558D297B, $29298D7C, $50220A1E, $0A0A225A,
    $E14FB1CE, $B1B14F50, $691AA0FD, $A0A01AC9, $7FDA6BBD, $6B6BDA14, $5CAB8592, $8585ABD9,
    $8173BDDA, $BDBD733C, $D2345DE7, $5D5D348F, $80501030, $10105090, $F303F401, $F4F40307,
    $16C0CB40, $CBCBC0DD, $EDC63E42, $3E3EC6D3, $2811050F, $0505112D, $1FE667A9, $6767E678,
    $7353E431, $E4E45397, $25BB2769, $2727BB02, $325841C3, $41415873, $2C9D8B80, $8B8B9DA7,
    $5101A7F4, $A7A701F6, $CF947D87, $7D7D94B2, $DCFB95A2, $9595FB49, $8E9FD875, $D8D89F56,
    $8B30FB10, $FBFB3070, $2371EE2F, $EEEE71CD, $C7917C84, $7C7C91BB, $17E366AA, $6666E371,
    $A68EDD7A, $DDDD8E7B, $B84B1739, $17174BAF, $024647C9, $47474645, $84DC9EBF, $9E9EDC1A,
    $1EC5CA43, $CACAC5D4, $75992D77, $2D2D9958, $9179BFDC, $BFBF792E, $381B0709, $07071B3F,
    $0123ADEA, $ADAD23AC, $EA2F5AEE, $5A5A2FB0, $6CB58398, $8383B5EF, $85FF3355, $3333FFB6,
    $3FF263A5, $6363F25C, $100A0206, $02020A12, $3938AAE3, $AAAA3893, $AFA87193, $7171A8DE,
    $0ECFC845, $C8C8CFC6, $C87D192B, $19197DD1, $727049DB, $4949703B, $869AD976, $D9D99A5F,
    $C31DF20B, $F2F21D31, $4B48E338, $E3E348A8, $E22A5BED, $5B5B2AB9, $34928885, $888892BC,
    $A4C89AB3, $9A9AC83E, $2DBE266A, $2626BE0B, $8DFA3256, $3232FABF, $E94AB0CD, $B0B04A59,
    $1B6AE926, $E9E96AF2, $78330F11, $0F0F3377, $E6A6D562, $D5D5A633, $74BA809D, $8080BAF4,
    $997CBEDF, $BEBE7C27, $26DECD4A, $CDCDDEEB, $BDE4345C, $3434E489, $7A7548D8, $48487532,
    $AB24FF1C, $FFFF2454, $F78F7A8E, $7A7A8F8D, $F4EA90AD, $9090EA64, $C23E5FE1, $5F5F3E9D,
    $1DA02060, $2020A03D, $67D568B8, $6868D50F, $D0721A2E, $1A1A72CA, $192CAEEF, $AEAE2CB7,
    $C95EB4C1, $B4B45E7D, $9A1954FC, $545419CE, $ECE593A8, $9393E57F, $0DAA2266, $2222AA2F,
    $07E964AC, $6464E963, $DB12F10E, $F1F1122A, $BFA27395, $7373A2CC, $905A1236, $12125A82,
    $3A5D40C0, $40405D7A, $40280818, $08082848, $56E8C358, $C3C3E895, $337BEC29, $ECEC7BDF,
    $9690DB70, $DBDB904D, $611FA1FE, $A1A11FC0, $1C838D8A, $8D8D8391, $F5C93D47, $3D3DC9C8,
    $CCF197A4, $9797F15B, $00000000, $00000000, $36D4CF4C, $CFCFD4F9, $45872B7D, $2B2B876E,
    $97B3769A, $7676B3E1, $64B0829B, $8282B0E6, $FEA9D667, $D6D6A928, $D8771B2D, $1B1B77C3,
    $C15BB5C2, $B5B55B74, $1129AFEC, $AFAF29BE, $77DF6ABE, $6A6ADF1D, $BA0D50F0, $50500DEA,
    $124C45CF, $45454C57, $CB18F308, $F3F31838, $9DF03050, $3030F0AD, $2B74EF2C, $EFEF74C4,
    $E5C33F41, $3F3FC3DA, $921C55FF, $55551CC7, $7910A2FB, $A2A210DB, $0365EA23, $EAEA65E9,
    $0FEC65AF, $6565EC6A, $B968BAD3, $BABA6803, $65932F71, $2F2F934A, $4EE7C05D, $C0C0E78E,
    $BE81DE7F, $DEDE8160, $E06C1C24, $1C1C6CFC, $BB2EFD1A, $FDFD2E46, $52644DD7, $4D4D641F,
    $E4E092AB, $9292E076, $8FBC759F, $7575BCFA, $301E060A, $06061E36, $24988A83, $8A8A98AE,
    $F940B2CB, $B2B2404B, $6359E637, $E6E65985, $70360E12, $0E0E367E, $F8631F21, $1F1F63E7,
    $37F762A6, $6262F755, $EEA3D461, $D4D4A33A, $2932A8E5, $A8A83281, $C4F496A7, $9696F452,
    $9B3AF916, $F9F93A62, $66F6C552, $C5C5F6A3, $35B1256F, $2525B110, $F22059EB, $595920AB,
    $54AE8491, $8484AED0, $B7A77296, $7272A7C5, $D5DD394B, $3939DDEC, $5A614CD4, $4C4C6116,
    $CA3B5EE2, $5E5E3B94, $E7857888, $7878859F, $DDD83848, $3838D8E5, $14868C89, $8C8C8698,
    $C6B2D16E, $D1D1B217, $410BA5F2, $A5A50BE4, $434DE23B, $E2E24DA1, $2FF861A3, $6161F84E,
    $F145B3C8, $B3B34542, $15A52163, $2121A534, $94D69CB9, $9C9CD608, $F0661E22, $1E1E66EE,
    $225243C5, $43435261, $76FCC754, $C7C7FCB1, $B32BFC19, $FCFC2B4F, $2014040C, $04041424,
    $B20851F3, $515108E3, $BCC799B6, $9999C725, $4FC46DB7, $6D6DC422, $68390D17, $0D0D3965,
    $8335FA13, $FAFA3579, $B684DF7C, $DFDF8469, $D79B7E82, $7E7E9BA9, $3DB4246C, $2424B419,
    $C5D73B4D, $3B3BD7FE, $313DABE0, $ABAB3D9A, $3ED1CE4F, $CECED1F0, $88551133, $11115599,
    $0C898F8C, $8F8F8983, $4A6B4ED2, $4E4E6B04, $D151B7C4, $B7B75166, $0B60EB20, $EBEB60E0,
    $FDCC3C44, $3C3CCCC1, $7CBF819E, $8181BFFD, $D4FE94A1, $9494FE40, $EB0CF704, $F7F70C1C,
    $A167B9D6, $B9B96718, $985F1335, $13135F8B, $7D9C2C74, $2C2C9C51, $D6B8D368, $D3D3B805,
    $6B5CE734, $E7E75C8C, $57CB6EB2, $6E6ECB39, $6EF3C451, $C4C4F3AA, $180F0305, $03030F1B,
    $8A1356FA, $565613DC, $1A4944CC, $4444495E, $DF9E7F81, $7F7F9EA0, $2137A9E6, $A9A93788,
    $4D822A7E, $2A2A8267, $B16DBBD0, $BBBB6D0A, $46E2C15E, $C1C1E287, $A20253F5, $535302F1,
    $AE8BDC79, $DCDC8B72, $58270B1D, $0B0B2753, $9CD39DBA, $9D9DD301, $47C16CB4, $6C6CC12B,
    $95F53153, $3131F5A4, $87B9749C, $7474B9F3, $E309F607, $F6F60915, $0A4346CA, $4646434C,
    $0926ACE9, $ACAC26A5, $3C978986, $898997B5, $A044143C, $141444B4, $5B42E13E, $E1E142BA,
    $B04E163A, $16164EA6, $CDD23A4E, $3A3AD2F7, $6FD069BB, $6969D006, $482D091B, $09092D41,
    $A7AD7090, $7070ADD7, $D954B6C7, $B6B6546F, $CEB7D06D, $D0D0B71E, $3B7EED2A, $EDED7ED6,
    $2EDBCC49, $CCCCDBE2, $2A5742C6, $42425768, $B4C298B5, $9898C22C, $490EA4F1, $A4A40EED,
    $5D882878, $28288875, $DA315CE4, $5C5C3186, $933FF815, $F8F83F6B, $44A48697, $8686A4C2),
   ($78182818, $1878D8C0, $AF236523, $23AF2605, $F9C657C6, $C6F9B87E, $6FE825E8, $E86FFB13,
    $A1879487, $87A1CB4C, $62B8D5B8, $B86211A9, $05010301, $01050908, $6E4FD14F, $4F6E0D42,
    $EE365A36, $36EE9BAD, $04A6F7A6, $A604FF59, $BDD26BD2, $D2BD0CDE, $06F502F5, $F5060EFB,
    $80798B79, $798096EF, $CE6FB16F, $6FCE305F, $EF91AE91, $91EF6DFC, $0752F652, $5207F8AA,
    $FD60A060, $60FD4727, $76BCD9BC, $BC763589, $CD9BB09B, $9BCD37AC, $8C8E8F8E, $8E8C8A04,
    $15A3F8A3, $A315D271, $3C0C140C, $0C3C6C60, $8A7B8D7B, $7B8A84FF, $E1355F35, $35E180B5,
    $691D271D, $1D69F5E8, $47E03DE0, $E047B353, $ACD764D7, $D7AC21F6, $EDC25BC2, $C2ED9C5E,
    $962E722E, $2E96436D, $7A4BDD4B, $4B7A2962, $21FE1FFE, $FE215DA3, $1657F957, $5716D582,
    $41153F15, $1541BDA8, $B6779977, $77B6E89F, $EB375937, $37EB92A5, $56E532E5, $E5569E7B,
    $D99FBC9F, $9FD9138C, $17F00DF0, $F01723D3, $7F4ADE4A, $4A7F206A, $95DA73DA, $DA95449E,
    $2558E858, $5825A2FA, $CAC946C9, $C9CACF06, $8D297B29, $298D7C55, $220A1E0A, $0A225A50,
    $4FB1CEB1, $B14F50E1, $1AA0FDA0, $A01AC969, $DA6BBD6B, $6BDA147F, $AB859285, $85ABD95C,
    $73BDDABD, $BD733C81, $345DE75D, $5D348FD2, $50103010, $10509080, $03F401F4, $F40307F3,
    $C0CB40CB, $CBC0DD16, $C63E423E, $3EC6D3ED, $11050F05, $05112D28, $E667A967, $67E6781F,
    $53E431E4, $E4539773, $BB276927, $27BB0225, $5841C341, $41587332, $9D8B808B, $8B9DA72C,
    $01A7F4A7, $A701F651, $947D877D, $7D94B2CF, $FB95A295, $95FB49DC, $9FD875D8, $D89F568E,
    $30FB10FB, $FB30708B, $71EE2FEE, $EE71CD23, $917C847C, $7C91BBC7, $E366AA66, $66E37117,
    $8EDD7ADD, $DD8E7BA6, $4B173917, $174BAFB8, $4647C947, $47464502, $DC9EBF9E, $9EDC1A84,
    $C5CA43CA, $CAC5D41E, $992D772D, $2D995875, $79BFDCBF, $BF792E91, $1B070907, $071B3F38,
    $23ADEAAD, $AD23AC01, $2F5AEE5A, $5A2FB0EA, $B5839883, $83B5EF6C, $FF335533, $33FFB685,
    $F263A563, $63F25C3F, $0A020602, $020A1210, $38AAE3AA, $AA389339, $A8719371, $71A8DEAF,
    $CFC845C8, $C8CFC60E, $7D192B19, $197DD1C8, $7049DB49, $49703B72, $9AD976D9, $D99A5F86,
    $1DF20BF2, $F21D31C3, $48E338E3, $E348A84B, $2A5BED5B, $5B2AB9E2, $92888588, $8892BC34,
    $C89AB39A, $9AC83EA4, $BE266A26, $26BE0B2D, $FA325632, $32FABF8D, $4AB0CDB0, $B04A59E9,
    $6AE926E9, $E96AF21B, $330F110F, $0F337778, $A6D562D5, $D5A633E6, $BA809D80, $80BAF474,
    $7CBEDFBE, $BE7C2799, $DECD4ACD, $CDDEEB26, $E4345C34, $34E489BD, $7548D848, $4875327A,
    $24FF1CFF, $FF2454AB, $8F7A8E7A, $7A8F8DF7, $EA90AD90, $90EA64F4, $3E5FE15F, $5F3E9DC2,
    $A0206020, $20A03D1D, $D568B868, $68D50F67, $721A2E1A, $1A72CAD0, $2CAEEFAE, $AE2CB719,
    $5EB4C1B4, $B45E7DC9, $1954FC54, $5419CE9A, $E593A893, $93E57FEC, $AA226622, $22AA2F0D,
    $E964AC64, $64E96307, $12F10EF1, $F1122ADB, $A2739573, $73A2CCBF, $5A123612, $125A8290,
    $5D40C040, $405D7A3A, $28081808, $08284840, $E8C358C3, $C3E89556, $7BEC29EC, $EC7BDF33,
    $90DB70DB, $DB904D96, $1FA1FEA1, $A11FC061, $838D8A8D, $8D83911C, $C93D473D, $3DC9C8F5,
    $F197A497, $97F15BCC, $00000000, $00000000, $D4CF4CCF, $CFD4F936, $872B7D2B, $2B876E45,
    $B3769A76, $76B3E197, $B0829B82, $82B0E664, $A9D667D6, $D6A928FE, $771B2D1B, $1B77C3D8,
    $5BB5C2B5, $B55B74C1, $29AFECAF, $AF29BE11, $DF6ABE6A, $6ADF1D77, $0D50F050, $500DEABA,
    $4C45CF45, $454C5712, $18F308F3, $F31838CB, $F0305030, $30F0AD9D, $74EF2CEF, $EF74C42B,
    $C33F413F, $3FC3DAE5, $1C55FF55, $551CC792, $10A2FBA2, $A210DB79, $65EA23EA, $EA65E903,
    $EC65AF65, $65EC6A0F, $68BAD3BA, $BA6803B9, $932F712F, $2F934A65, $E7C05DC0, $C0E78E4E,
    $81DE7FDE, $DE8160BE, $6C1C241C, $1C6CFCE0, $2EFD1AFD, $FD2E46BB, $644DD74D, $4D641F52,
    $E092AB92, $92E076E4, $BC759F75, $75BCFA8F, $1E060A06, $061E3630, $988A838A, $8A98AE24,
    $40B2CBB2, $B2404BF9, $59E637E6, $E6598563, $360E120E, $0E367E70, $631F211F, $1F63E7F8,
    $F762A662, $62F75537, $A3D461D4, $D4A33AEE, $32A8E5A8, $A8328129, $F496A796, $96F452C4,
    $3AF916F9, $F93A629B, $F6C552C5, $C5F6A366, $B1256F25, $25B11035, $2059EB59, $5920ABF2,
    $AE849184, $84AED054, $A7729672, $72A7C5B7, $DD394B39, $39DDECD5, $614CD44C, $4C61165A,
    $3B5EE25E, $5E3B94CA, $85788878, $78859FE7, $D8384838, $38D8E5DD, $868C898C, $8C869814,
    $B2D16ED1, $D1B217C6, $0BA5F2A5, $A50BE441, $4DE23BE2, $E24DA143, $F861A361, $61F84E2F,
    $45B3C8B3, $B34542F1, $A5216321, $21A53415, $D69CB99C, $9CD60894, $661E221E, $1E66EEF0,
    $5243C543, $43526122, $FCC754C7, $C7FCB176, $2BFC19FC, $FC2B4FB3, $14040C04, $04142420,
    $0851F351, $5108E3B2, $C799B699, $99C725BC, $C46DB76D, $6DC4224F, $390D170D, $0D396568,
    $35FA13FA, $FA357983, $84DF7CDF, $DF8469B6, $9B7E827E, $7E9BA9D7, $B4246C24, $24B4193D,
    $D73B4D3B, $3BD7FEC5, $3DABE0AB, $AB3D9A31, $D1CE4FCE, $CED1F03E, $55113311, $11559988,
    $898F8C8F, $8F89830C, $6B4ED24E, $4E6B044A, $51B7C4B7, $B75166D1, $60EB20EB, $EB60E00B,
    $CC3C443C, $3CCCC1FD, $BF819E81, $81BFFD7C, $FE94A194, $94FE40D4, $0CF704F7, $F70C1CEB,
    $67B9D6B9, $B96718A1, $5F133513, $135F8B98, $9C2C742C, $2C9C517D, $B8D368D3, $D3B805D6,
    $5CE734E7, $E75C8C6B, $CB6EB26E, $6ECB3957, $F3C451C4, $C4F3AA6E, $0F030503, $030F1B18,
    $1356FA56, $5613DC8A, $4944CC44, $44495E1A, $9E7F817F, $7F9EA0DF, $37A9E6A9, $A9378821,
    $822A7E2A, $2A82674D, $6DBBD0BB, $BB6D0AB1, $E2C15EC1, $C1E28746, $0253F553, $5302F1A2,
    $8BDC79DC, $DC8B72AE, $270B1D0B, $0B275358, $D39DBA9D, $9DD3019C, $C16CB46C, $6CC12B47,
    $F5315331, $31F5A495, $B9749C74, $74B9F387, $09F607F6, $F60915E3, $4346CA46, $46434C0A,
    $26ACE9AC, $AC26A509, $97898689, $8997B53C, $44143C14, $1444B4A0, $42E13EE1, $E142BA5B,
    $4E163A16, $164EA6B0, $D23A4E3A, $3AD2F7CD, $D069BB69, $69D0066F, $2D091B09, $092D4148,
    $AD709070, $70ADD7A7, $54B6C7B6, $B6546FD9, $B7D06DD0, $D0B71ECE, $7EED2AED, $ED7ED63B,
    $DBCC49CC, $CCDBE22E, $5742C642, $4257682A, $C298B598, $98C22CB4, $0EA4F1A4, $A40EED49,
    $88287828, $2888755D, $315CE45C, $5C3186DA, $3FF815F8, $F83F6B93, $A4869786, $86A4C244));

implementation

end.
