/**
 * Reference documentation:
 * R600/R700/Evergreen Assembly Language Format
 * http://amd-dev.wpengine.netdna-cdn.com/wordpress/media/2012/10/R600-R700-Evergreen_Assembly_Language_Format.pdf
 *
 * ATI R700-Family ISA
 * http://developer.amd.com/wordpress/media/2012/10/R700-Family_Instruction_Set_Architecture.pdf
 *
 * ATI Evergreen-Family ISA
 * http://developer.amd.com/wordpress/media/2012/10/AMD_Evergreen-Family_Instruction_Set_Architecture.pdf
 *
 * AMD HD 6900 ISA
 * http://developer.amd.com/wordpress/media/2012/10/AMD_HD_6900_Series_Instruction_Set_Architecture.pdf
 */

#ifndef CF_INST
#define CF_INST(name, value)
#endif

#ifndef EXP_INST
#define EXP_INST(name, value)
#endif

#ifndef ALU_INST
#define ALU_INST(name, value)
#endif

#ifndef ALU_OP2
#define ALU_OP2(name, value, srcs, flags)
#endif

#ifndef ALU_OP3
#define ALU_OP3(name, value, srcs, flags)
#endif

#ifndef TEX_INST
#define TEX_INST(name, value)
#endif

#ifndef VTX_INST
#define VTX_INST(name, value)
#endif

#ifndef MEM_INST
#define MEM_INST(name, value)
#endif

#ifndef ALU_REDUC
#define ALU_REDUC Opcode::Reduction
#endif

#ifndef ALU_VEC
#define ALU_VEC Opcode::Vector
#endif

#ifndef ALU_TRANS
#define ALU_TRANS Opcode::Transcendental
#endif

#ifndef ALU_PRED_SET
#define ALU_PRED_SET Opcode::PredSet
#endif

#ifndef ALU_INT
#define ALU_INT Opcode::IntIn | Opcode::IntOut
#endif

#ifndef ALU_UINT
#define ALU_UINT Opcode::UintIn | Opcode::UintOut
#endif

#ifndef ALU_INT_IN
#define ALU_INT_IN Opcode::IntIn
#endif

#ifndef ALU_UINT_IN
#define ALU_UINT_IN Opcode::UintIn
#endif

#ifndef ALU_INT_OUT
#define ALU_INT_OUT Opcode::IntOut
#endif

#ifndef ALU_UINT_OUT
#define ALU_UINT_OUT Opcode::UintOut
#endif


// CF
CF_INST(NOP,                     0x00000000)
CF_INST(TEX,                     0x00000001)
CF_INST(VTX,                     0x00000002)
CF_INST(VTX_TC,                  0x00000003)
CF_INST(LOOP_START,              0x00000004)
CF_INST(LOOP_END,                0x00000005)
CF_INST(LOOP_START_DX10,         0x00000006)
CF_INST(LOOP_START_NO_AL,        0x00000007)
CF_INST(LOOP_CONTINUE,           0x00000008)
CF_INST(LOOP_BREAK,              0x00000009)
CF_INST(JUMP,                    0x0000000A)
CF_INST(PUSH,                    0x0000000B)
CF_INST(PUSH_ELSE,               0x0000000C)
CF_INST(ELSE,                    0x0000000D)
CF_INST(POP,                     0x0000000E)
CF_INST(POP_JUMP,                0x0000000F)
CF_INST(POP_PUSH,                0x00000010)
CF_INST(POP_PUSH_ELSE,           0x00000011)
CF_INST(CALL,                    0x00000012)
CF_INST(CALL_FS,                 0x00000013)
CF_INST(RETURN,                  0x00000014)
CF_INST(EMIT_VERTEX,             0x00000015)
CF_INST(EMIT_CUT_VERTEX,         0x00000016)
CF_INST(CUT_VERTEX,              0x00000017)
CF_INST(KILL,                    0x00000018)
CF_INST(END_PROGRAM,             0x00000019)
CF_INST(WAIT_ACK,                0x0000001A)
CF_INST(TEX_ACK,                 0x0000001B)
CF_INST(VTX_ACK,                 0x0000001C)
CF_INST(VTX_TC_ACK,              0x0000001D)
/* I don't think Wii U has these.
CF_INST(TC,                      0x0000001E)
CF_INST(VC,                      0x0000001F)
CF_INST(GDS,                     0x00000020)
CF_INST(TC_ACK,                  0x00000021)
CF_INST(VC_ACK,                  0x00000022)
CF_INST(JUMPTABLE,               0x00000023)
CF_INST(GLOBAL_WAVE_SYNC,        0x00000024)
CF_INST(HALT,                    0x00000025)
CF_INST(END,                     0x00000026)
CF_INST(LDS_DEALLOC,             0x00000027)
CF_INST(PUSH_WQM,                0x00000028)
CF_INST(POP_WQM,                 0x00000029)
CF_INST(ELSE_WQM,                0x0000002A)
CF_INST(JUMP_ANY,                0x0000002B)
CF_INST(REACTIVATE,              0x0000002C)
CF_INST(REACTIVATE_WQM,          0x0000002D)
CF_INST(INTERRUPT,               0x0000002E)
CF_INST(INTERRUPT_AND_SLEEP,     0x0000002F)
CF_INST(SET_PRIORITY,            0x00000030)
*/

// EXP
EXP_INST(MEM_STREAM0,                  0x00000020)
EXP_INST(MEM_STREAM1,                  0x00000021)
EXP_INST(MEM_STREAM2,                  0x00000022)
EXP_INST(MEM_STREAM3,                  0x00000023)
EXP_INST(MEM_SCRATCH,                  0x00000024)
EXP_INST(MEM_REDUCTION,                0x00000025)
EXP_INST(MEM_RING,                     0x00000026)
EXP_INST(EXP,                          0x00000027)
EXP_INST(EXP_DONE,                     0x00000028)
EXP_INST(MEM_EXPORT,                   0x0000003A)
/* I don't think Wii U has these
EXP_INST(MEM_STREAM0_BUF0,             0x00000040)
EXP_INST(MEM_STREAM0_BUF1,             0x00000041)
EXP_INST(MEM_STREAM0_BUF2,             0x00000042)
EXP_INST(MEM_STREAM0_BUF3,             0x00000043)
EXP_INST(MEM_STREAM1_BUF0,             0x00000044)
EXP_INST(MEM_STREAM1_BUF1,             0x00000045)
EXP_INST(MEM_STREAM1_BUF2,             0x00000046)
EXP_INST(MEM_STREAM1_BUF3,             0x00000047)
EXP_INST(MEM_STREAM2_BUF0,             0x00000048)
EXP_INST(MEM_STREAM2_BUF1,             0x00000049)
EXP_INST(MEM_STREAM2_BUF2,             0x0000004A)
EXP_INST(MEM_STREAM2_BUF3,             0x0000004B)
EXP_INST(MEM_STREAM3_BUF0,             0x0000004C)
EXP_INST(MEM_STREAM3_BUF1,             0x0000004D)
EXP_INST(MEM_STREAM3_BUF2,             0x0000004E)
EXP_INST(MEM_STREAM3_BUF3,             0x0000004F)
EXP_INST(MEM_RAT,                      0x00000056)
EXP_INST(MEM_RAT_CACHELESS,            0x00000057)
EXP_INST(MEM_RING1,                    0x00000058)
EXP_INST(MEM_RING2,                    0x00000059)
EXP_INST(MEM_RING3,                    0x0000005A)
EXP_INST(MEM_EXPORT_COMBINED,          0x0000005B)
EXP_INST(MEM_RAT_COMBINED_CACHELESS,   0x0000005C)
EXP_INST(MEM_RAT_COMBINED,             0x0000005D)
EXP_INST(EXP_DONE_END_IS_NEXT,         0x0000005E)
*/

// ALU
ALU_INST(ALU,                    0x00000008)
ALU_INST(ALU_PUSH_BEFORE,        0x00000009)
ALU_INST(ALU_POP_AFTER,          0x0000000A)
ALU_INST(ALU_POP2_AFTER,         0x0000000B)
ALU_INST(ALU_EXT,                0x0000000C)
ALU_INST(ALU_CONTINUE,           0x0000000D)
ALU_INST(ALU_BREAK,              0x0000000E)
ALU_INST(ALU_ELSE_AFTER,         0x0000000F)

// ALU OP2
ALU_OP2(ADD,                     0x00000000, 2, ALU_VEC | ALU_TRANS)
ALU_OP2(MUL,                     0x00000001, 2, ALU_VEC | ALU_TRANS)
ALU_OP2(MUL_IEEE,                0x00000002, 2, ALU_VEC | ALU_TRANS)
ALU_OP2(MAX,                     0x00000003, 2, ALU_VEC | ALU_TRANS)
ALU_OP2(MIN,                     0x00000004, 2, ALU_VEC | ALU_TRANS)
ALU_OP2(MAX_DX10,                0x00000005, 2, ALU_VEC | ALU_TRANS)
ALU_OP2(MIN_DX10,                0x00000006, 2, ALU_VEC | ALU_TRANS)
ALU_OP2(FREXP_64,                0x00000007, 1, ALU_VEC | ALU_REDUC)
ALU_OP2(SETE,                    0x00000008, 2, ALU_VEC | ALU_TRANS)
ALU_OP2(SETGT,                   0x00000009, 2, ALU_VEC | ALU_TRANS)
ALU_OP2(SETGE,                   0x0000000A, 2, ALU_VEC | ALU_TRANS)
ALU_OP2(SETNE,                   0x0000000B, 2, ALU_VEC | ALU_TRANS)
ALU_OP2(SETE_DX10,               0x0000000C, 2, ALU_VEC | ALU_TRANS | ALU_INT_OUT)
ALU_OP2(SETGT_DX10,              0x0000000D, 2, ALU_VEC | ALU_TRANS | ALU_INT_OUT)
ALU_OP2(SETGE_DX10,              0x0000000E, 2, ALU_VEC | ALU_TRANS | ALU_INT_OUT)
ALU_OP2(SETNE_DX10,              0x0000000F, 2, ALU_VEC | ALU_TRANS | ALU_INT_OUT)
ALU_OP2(FRACT,                   0x00000010, 1, ALU_VEC | ALU_TRANS)
ALU_OP2(TRUNC,                   0x00000011, 1, ALU_VEC | ALU_TRANS)
ALU_OP2(CEIL,                    0x00000012, 1, ALU_VEC | ALU_TRANS)
ALU_OP2(RNDNE,                   0x00000013, 1, ALU_VEC | ALU_TRANS)
ALU_OP2(FLOOR,                   0x00000014, 1, ALU_VEC | ALU_TRANS)
ALU_OP2(MOVA,                    0x00000015, 1, ALU_VEC | ALU_INT_OUT)
ALU_OP2(MOVA_FLOOR,              0x00000016, 1, ALU_VEC | ALU_INT_OUT)
ALU_OP2(ADD_64,                  0x00000017, 2, ALU_VEC | ALU_TRANS)
ALU_OP2(MOVA_INT,                0x00000018, 1, ALU_VEC | ALU_INT)
ALU_OP2(MOV,                     0x00000019, 1, ALU_VEC | ALU_TRANS)
ALU_OP2(NOP,                     0x0000001A, 0, ALU_VEC | ALU_TRANS)
ALU_OP2(MUL_64,                  0x0000001B, 2, ALU_VEC | ALU_REDUC)
ALU_OP2(FLT64_TO_FLT32,          0x0000001C, 1, ALU_VEC | ALU_REDUC)
ALU_OP2(FLT32_TO_FLT64,          0x0000001D, 1, ALU_VEC | ALU_REDUC)
ALU_OP2(PRED_SETGT_UINT,         0x0000001E, 2, ALU_VEC | ALU_TRANS | ALU_PRED_SET | ALU_UINT)
ALU_OP2(PRED_SETGE_UINT,         0x0000001F, 2, ALU_VEC | ALU_TRANS | ALU_PRED_SET | ALU_UINT)
ALU_OP2(PRED_SETE,               0x00000020, 2, ALU_VEC | ALU_TRANS | ALU_PRED_SET)
ALU_OP2(PRED_SETGT,              0x00000021, 2, ALU_VEC | ALU_TRANS | ALU_PRED_SET)
ALU_OP2(PRED_SETGE,              0x00000022, 2, ALU_VEC | ALU_TRANS | ALU_PRED_SET)
ALU_OP2(PRED_SETNE,              0x00000023, 2, ALU_VEC | ALU_TRANS | ALU_PRED_SET)
ALU_OP2(PRED_SET_INV,            0x00000024, 2, ALU_VEC | ALU_TRANS | ALU_PRED_SET)
ALU_OP2(PRED_SET_POP,            0x00000025, 2, ALU_VEC | ALU_TRANS | ALU_PRED_SET)
ALU_OP2(PRED_SET_CLR,            0x00000026, 2, ALU_VEC | ALU_TRANS | ALU_PRED_SET)
ALU_OP2(PRED_SET_RESTORE,        0x00000027, 2, ALU_VEC | ALU_TRANS | ALU_PRED_SET)
ALU_OP2(PRED_SETE_PUSH,          0x00000028, 2, ALU_VEC | ALU_TRANS | ALU_PRED_SET)
ALU_OP2(PRED_SETGT_PUSH,         0x00000029, 2, ALU_VEC | ALU_TRANS | ALU_PRED_SET)
ALU_OP2(PRED_SETGE_PUSH,         0x0000002A, 2, ALU_VEC | ALU_TRANS | ALU_PRED_SET)
ALU_OP2(PRED_SETNE_PUSH,         0x0000002B, 2, ALU_VEC | ALU_TRANS | ALU_PRED_SET)
ALU_OP2(KILLE,                   0x0000002C, 2, ALU_VEC | ALU_TRANS)
ALU_OP2(KILLGT,                  0x0000002D, 2, ALU_VEC | ALU_TRANS)
ALU_OP2(KILLGE,                  0x0000002E, 2, ALU_VEC | ALU_TRANS)
ALU_OP2(KILLNE,                  0x0000002F, 2, ALU_VEC | ALU_TRANS)
ALU_OP2(AND_INT,                 0x00000030, 2, ALU_VEC | ALU_TRANS | ALU_INT)
ALU_OP2(OR_INT,                  0x00000031, 2, ALU_VEC | ALU_TRANS | ALU_INT)
ALU_OP2(XOR_INT,                 0x00000032, 2, ALU_VEC | ALU_TRANS | ALU_INT)
ALU_OP2(NOT_INT,                 0x00000033, 2, ALU_VEC | ALU_TRANS | ALU_INT)
ALU_OP2(ADD_INT,                 0x00000034, 2, ALU_VEC | ALU_TRANS | ALU_INT)
ALU_OP2(SUB_INT,                 0x00000035, 2, ALU_VEC | ALU_TRANS | ALU_INT)
ALU_OP2(MAX_INT,                 0x00000036, 2, ALU_VEC | ALU_TRANS | ALU_INT)
ALU_OP2(MIN_INT,                 0x00000037, 2, ALU_VEC | ALU_TRANS | ALU_INT)
ALU_OP2(MAX_UINT,                0x00000038, 2, ALU_VEC | ALU_TRANS | ALU_UINT)
ALU_OP2(MIN_UINT,                0x00000039, 2, ALU_VEC | ALU_TRANS | ALU_UINT)
ALU_OP2(SETE_INT,                0x0000003A, 2, ALU_VEC | ALU_TRANS | ALU_INT)
ALU_OP2(SETGT_INT,               0x0000003B, 2, ALU_VEC | ALU_TRANS | ALU_INT)
ALU_OP2(SETGE_INT,               0x0000003C, 2, ALU_VEC | ALU_TRANS | ALU_INT)
ALU_OP2(SETNE_INT,               0x0000003D, 2, ALU_VEC | ALU_TRANS | ALU_INT)
ALU_OP2(SETGT_UINT,              0x0000003E, 2, ALU_VEC | ALU_TRANS | ALU_UINT)
ALU_OP2(SETGE_UINT,              0x0000003F, 2, ALU_VEC | ALU_TRANS | ALU_UINT)
ALU_OP2(KILLGT_UINT,             0x00000040, 2, ALU_VEC | ALU_TRANS | ALU_UINT)
ALU_OP2(KILLGE_UINT,             0x00000041, 2, ALU_VEC | ALU_TRANS | ALU_UINT)
ALU_OP2(PRED_SETE_INT,           0x00000042, 2, ALU_VEC | ALU_TRANS | ALU_PRED_SET | ALU_INT)
ALU_OP2(PRED_SETGT_INT,          0x00000043, 2, ALU_VEC | ALU_TRANS | ALU_PRED_SET | ALU_INT)
ALU_OP2(PRED_SETGE_INT,          0x00000044, 2, ALU_VEC | ALU_TRANS | ALU_PRED_SET | ALU_INT)
ALU_OP2(PRED_SETNE_INT,          0x00000045, 2, ALU_VEC | ALU_TRANS | ALU_PRED_SET | ALU_INT)
ALU_OP2(KILLE_INT,               0x00000046, 2, ALU_VEC | ALU_TRANS | ALU_INT)
ALU_OP2(KILLGT_INT,              0x00000047, 2, ALU_VEC | ALU_TRANS | ALU_INT)
ALU_OP2(KILLGE_INT,              0x00000048, 2, ALU_VEC | ALU_TRANS | ALU_INT)
ALU_OP2(KILLNE_INT,              0x00000049, 2, ALU_VEC | ALU_TRANS | ALU_INT)
ALU_OP2(PRED_SETE_PUSH_INT,      0x0000004A, 2, ALU_VEC | ALU_TRANS | ALU_PRED_SET | ALU_INT)
ALU_OP2(PRED_SETGT_PUSH_INT,     0x0000004B, 2, ALU_VEC | ALU_TRANS | ALU_PRED_SET | ALU_INT)
ALU_OP2(PRED_SETGE_PUSH_INT,     0x0000004C, 2, ALU_VEC | ALU_TRANS | ALU_PRED_SET | ALU_INT)
ALU_OP2(PRED_SETNE_PUSH_INT,     0x0000004D, 2, ALU_VEC | ALU_TRANS | ALU_PRED_SET | ALU_INT)
ALU_OP2(PRED_SETLT_PUSH_INT,     0x0000004E, 2, ALU_VEC | ALU_TRANS | ALU_PRED_SET | ALU_INT)
ALU_OP2(PRED_SETLE_PUSH_INT,     0x0000004F, 2, ALU_VEC | ALU_TRANS | ALU_PRED_SET | ALU_INT)
ALU_OP2(DOT4,                    0x00000050, 2, ALU_VEC | ALU_REDUC)
ALU_OP2(DOT4_IEEE,               0x00000051, 2, ALU_VEC | ALU_REDUC)
ALU_OP2(CUBE,                    0x00000052, 2, ALU_VEC | ALU_REDUC)
ALU_OP2(MAX4,                    0x00000053, 2, ALU_VEC | ALU_REDUC)
ALU_OP2(GROUP_BARRIER,           0x00000054, 2, ALU_VEC | ALU_TRANS)
ALU_OP2(GROUP_SEQ_BEGIN,         0x00000055, 2, ALU_VEC | ALU_TRANS)
ALU_OP2(GROUP_SEQ_END,           0x00000056, 2, ALU_VEC | ALU_TRANS)
ALU_OP2(SET_MODE,                0x00000057, 0, ALU_VEC | ALU_TRANS)
ALU_OP2(SET_CF_IDX0,             0x00000058, 0, ALU_VEC | ALU_TRANS)
ALU_OP2(SET_CF_IDX1,             0x00000059, 0, ALU_VEC | ALU_TRANS)
ALU_OP2(SET_LDS_SIZE,            0x0000005A, 2, ALU_VEC | ALU_TRANS)
ALU_OP2(MUL_INT24,               0x0000005B, 2, ALU_VEC | ALU_TRANS)
ALU_OP2(MULHI_INT24,             0x0000005C, 2, ALU_VEC | ALU_TRANS)
ALU_OP2(MOVA_GPR_INT,            0x00000060, 2, ALU_VEC | ALU_INT)
ALU_OP2(EXP_IEEE,                0x00000061, 1, ALU_TRANS)
ALU_OP2(LOG_CLAMPED,             0x00000062, 1, ALU_TRANS)
ALU_OP2(LOG_IEEE,                0x00000063, 1, ALU_TRANS)
ALU_OP2(RECIP_CLAMPED,           0x00000064, 1, ALU_TRANS)
ALU_OP2(RECIP_FF,                0x00000065, 1, ALU_TRANS)
ALU_OP2(RECIP_IEEE,              0x00000066, 1, ALU_TRANS)
ALU_OP2(RECIPSQRT_CLAMPED,       0x00000067, 1, ALU_TRANS)
ALU_OP2(RECIPSQRT_FF,            0x00000068, 1, ALU_TRANS)
ALU_OP2(RECIPSQRT_IEEE,          0x00000069, 1, ALU_TRANS)
ALU_OP2(SQRT_IEEE,               0x0000006A, 1, ALU_TRANS)
ALU_OP2(FLT_TO_INT,              0x0000006B, 1, ALU_TRANS | ALU_INT_OUT)
ALU_OP2(INT_TO_FLT,              0x0000006C, 1, ALU_TRANS | ALU_INT_IN)
ALU_OP2(UINT_TO_FLT,             0x0000006D, 1, ALU_TRANS | ALU_UINT_IN)
ALU_OP2(SIN,                     0x0000006E, 1, ALU_TRANS)
ALU_OP2(COS,                     0x0000006F, 1, ALU_TRANS)
ALU_OP2(ASHR_INT,                0x00000070, 2, ALU_VEC | ALU_TRANS | ALU_INT)
ALU_OP2(LSHR_INT,                0x00000071, 2, ALU_VEC | ALU_TRANS | ALU_INT)
ALU_OP2(LSHL_INT,                0x00000072, 2, ALU_VEC | ALU_TRANS | ALU_INT)
ALU_OP2(MULLO_INT,               0x00000073, 2, ALU_TRANS | ALU_INT)
ALU_OP2(MULHI_INT,               0x00000074, 2, ALU_TRANS | ALU_INT)
ALU_OP2(MULLO_UINT,              0x00000075, 2, ALU_TRANS | ALU_UINT)
ALU_OP2(MULHI_UINT,              0x00000076, 2, ALU_TRANS | ALU_UINT)
ALU_OP2(RECIP_INT,               0x00000077, 1, ALU_TRANS | ALU_INT)
ALU_OP2(RECIP_UINT,              0x00000078, 1, ALU_TRANS | ALU_UINT)
ALU_OP2(FLT_TO_UINT,             0x00000079, 1, ALU_TRANS | ALU_UINT_OUT)
ALU_OP2(LDEXP_64,                0x0000007A, 2, ALU_VEC | ALU_REDUC)
ALU_OP2(FRACT_64,                0x0000007B, 1, ALU_VEC | ALU_REDUC)
ALU_OP2(PRED_SETGT_64,           0x0000007C, 2, ALU_VEC | ALU_REDUC | ALU_PRED_SET)
ALU_OP2(PRED_SETE_64,            0x0000007D, 2, ALU_VEC | ALU_REDUC | ALU_PRED_SET)
ALU_OP2(PRED_SETGE_64,           0x0000007E, 2, ALU_VEC | ALU_REDUC | ALU_PRED_SET)

// ALU OP3
ALU_OP3(BFE_UINT,                0x00000004, 3, ALU_VEC | ALU_TRANS | ALU_UINT)
ALU_OP3(BFE_INT,                 0x00000005, 3, ALU_VEC | ALU_TRANS | ALU_INT)
ALU_OP3(BFI_INT,                 0x00000006, 3, ALU_VEC | ALU_TRANS | ALU_INT)
ALU_OP3(FMA,                     0x00000007, 3, ALU_VEC | ALU_TRANS)
ALU_OP3(MULADD_64,               0x00000008, 3, ALU_VEC | ALU_REDUC)
ALU_OP3(MULADD_64_M2,            0x00000009, 3, ALU_VEC | ALU_REDUC)
ALU_OP3(MULADD_64_M4,            0x0000000A, 3, ALU_VEC | ALU_REDUC)
ALU_OP3(MULADD_64_D2,            0x0000000B, 3, ALU_VEC | ALU_REDUC)
ALU_OP3(MUL_LIT,                 0x0000000C, 3, ALU_TRANS)
ALU_OP3(MUL_LIT_M2,              0x0000000D, 3, ALU_TRANS)
ALU_OP3(MUL_LIT_M4,              0x0000000E, 3, ALU_TRANS)
ALU_OP3(MUL_LIT_D2,              0x0000000F, 3, ALU_TRANS)
ALU_OP3(MULADD,                  0x00000010, 3, ALU_VEC | ALU_TRANS)
ALU_OP3(MULADD_M2,               0x00000011, 3, ALU_VEC | ALU_TRANS)
ALU_OP3(MULADD_M4,               0x00000012, 3, ALU_VEC | ALU_TRANS)
ALU_OP3(MULADD_D2,               0x00000013, 3, ALU_VEC | ALU_TRANS)
ALU_OP3(MULADD_IEEE,             0x00000014, 3, ALU_VEC | ALU_TRANS)
ALU_OP3(MULADD_IEEE_M2,          0x00000015, 3, ALU_VEC | ALU_TRANS)
ALU_OP3(MULADD_IEEE_M4,          0x00000016, 3, ALU_VEC | ALU_TRANS)
ALU_OP3(MULADD_IEEE_D2,          0x00000017, 3, ALU_VEC | ALU_TRANS)
ALU_OP3(CNDE,                    0x00000018, 3, ALU_VEC | ALU_TRANS)
ALU_OP3(CNDGT,                   0x00000019, 3, ALU_VEC | ALU_TRANS)
ALU_OP3(CNDGE,                   0x0000001A, 3, ALU_VEC | ALU_TRANS)
ALU_OP3(CNDE_INT,                0x0000001C, 3, ALU_VEC | ALU_TRANS | ALU_INT)
ALU_OP3(CNDGT_INT,               0x0000001D, 3, ALU_VEC | ALU_TRANS | ALU_INT)
ALU_OP3(CNDGE_INT,               0x0000001E, 3, ALU_VEC | ALU_TRANS | ALU_INT)

// TEX
TEX_INST(VTX_FETCH,              0x00000000)
TEX_INST(VTX_SEMANTIC,           0x00000001)
TEX_INST(MEM,                    0x00000002)
TEX_INST(LD,                     0x00000003)
TEX_INST(GET_TEXTURE_INFO,       0x00000004)
TEX_INST(GET_SAMPLE_INFO,        0x00000005)
TEX_INST(GET_COMP_TEX_LOD,       0x00000006)
TEX_INST(GET_GRADIENTS_H,        0x00000007)
TEX_INST(GET_GRADIENTS_V,        0x00000008)
TEX_INST(GET_LERP,               0x00000009)
TEX_INST(KEEP_GRADIENTS,         0x0000000A)
TEX_INST(SET_GRADIENTS_H,        0x0000000B)
TEX_INST(SET_GRADIENTS_V,        0x0000000C)
TEX_INST(PASS,                   0x0000000D)
TEX_INST(SET_CUBEMAP_INDEX,      0x0000000E)
TEX_INST(FETCH4,                 0x0000000F)
TEX_INST(SAMPLE,                 0x00000010)
TEX_INST(SAMPLE_L,               0x00000011)
TEX_INST(SAMPLE_LB,              0x00000012)
TEX_INST(SAMPLE_LZ,              0x00000013)
TEX_INST(SAMPLE_G,               0x00000014)
TEX_INST(SAMPLE_G_L,             0x00000015)
TEX_INST(SAMPLE_G_LB,            0x00000016)
TEX_INST(SAMPLE_G_LZ,            0x00000017)
TEX_INST(SAMPLE_C,               0x00000018)
TEX_INST(SAMPLE_C_L,             0x00000019)
TEX_INST(SAMPLE_C_LB,            0x0000001A)
TEX_INST(SAMPLE_C_LZ,            0x0000001B)
TEX_INST(SAMPLE_C_G,             0x0000001C)
TEX_INST(SAMPLE_C_G_L,           0x0000001D)
TEX_INST(SAMPLE_C_G_LB,          0x0000001E)
TEX_INST(SAMPLE_C_G_LZ,          0x0000001F)
TEX_INST(SET_TEXTURE_OFFSETS,    0x00000020)
TEX_INST(GATHER4,                0x00000021)
TEX_INST(GATHER4_O,              0x00000022)
TEX_INST(GATHER4_C,              0x00000023)
TEX_INST(GATHER4_C_O,            0x00000024)
TEX_INST(GET_BUFFER_RESINFO,     0x00000025)

// VTX
VTX_INST(FETCH,                  0x00000000)
VTX_INST(SEMANTIC,               0x00000001)
VTX_INST(BUFINFO,                0x0000000E)

// MEM
MEM_INST(RD_SCRATCH,             0x00000000)
MEM_INST(RD_REDUC,               0x00000001)
MEM_INST(RD_SCATTER,             0x00000002)
MEM_INST(LOCAL_DS_WRITE,         0x00000004)
MEM_INST(LOCAL_DS_READ,          0x00000005)
MEM_INST(DS_GLOBAL_WRITE,        0x00000006)
MEM_INST(DS_GLOBAL_READ,         0x00000007)
MEM_INST(MEM_GDS,                0x00000008)
MEM_INST(TF_WRITE,               0x00000009)

#undef CF_INST
#undef EXP_INST
#undef ALU_INST
#undef ALU_OP2
#undef ALU_OP3
#undef TEX_INST
#undef VTX_INST
#undef MEM_INST

/*
#undef ALU_REDUC
#undef ALU_VEC
#undef ALU_TRANS
#undef ALU_PRED_SET
#undef ALU_INT
#undef ALU_UINT
#undef ALU_INT_IN
#undef ALU_UINT_IN
#undef ALU_INT_OUT
#undef ALU_UINT_OUT
*/
