#ifndef LATTE_ENUM_PM4_H
#define LATTE_ENUM_PM4_H

#include <common/enum_start.inl>

ENUM_NAMESPACE_ENTER(latte)
ENUM_NAMESPACE_ENTER(pm4)

ENUM_BEG(PacketType, uint32_t)
   ENUM_VALUE(Type0,                         0x00)
   ENUM_VALUE(Type1,                         0x01)
   ENUM_VALUE(Type2,                         0x02)
   ENUM_VALUE(Type3,                         0x03)
ENUM_END(PacketType)

ENUM_BEG(IT_OPCODE, uint32_t)
   ENUM_VALUE(DECAF_COPY_COLOR_TO_SCAN,      0x01)
   ENUM_VALUE(DECAF_SWAP_BUFFERS,            0x02)
   ENUM_VALUE(DECAF_CLEAR_COLOR,             0x03)
   ENUM_VALUE(DECAF_CLEAR_DEPTH_STENCIL,     0x04)
   ENUM_VALUE(DECAF_CAP_SYNC_REGISTERS,      0x05)
   ENUM_VALUE(DECAF_SET_BUFFER,              0x06)
   ENUM_VALUE(DECAF_COPY_SURFACE,            0x07)
   ENUM_VALUE(DECAF_EXPAND_COLORBUFFER,      0x08)
   ENUM_VALUE(DECAF_OSSCREEN_FLIP,           0x09)

   ENUM_VALUE(NOP,                           0x10)
   ENUM_VALUE(INDIRECT_BUFFER_END,           0x17)
   ENUM_VALUE(NEXTCHAR,                      0x19)
   ENUM_VALUE(PLY_NEXTSCAN,                  0x1D)
   ENUM_VALUE(SET_SCISSORS,                  0x1E)
   ENUM_VALUE(OCCLUSION_QUERY,               0x1F)
   ENUM_VALUE(SET_PREDICATION,               0x20)
   ENUM_VALUE(REG_RMW,                       0x21)
   ENUM_VALUE(COND_EXEC,                     0x22)
   ENUM_VALUE(PRED_EXEC,                     0x23)
   ENUM_VALUE(START_3D_CMDBUF,               0x24)
   ENUM_VALUE(START_2D_CMDBUF,               0x25)
   ENUM_VALUE(INDEX_BASE,                    0x26)
   ENUM_VALUE(DRAW_INDEX_2,                  0x27)
   ENUM_VALUE(CONTEXT_CTL,                   0x28)
   ENUM_VALUE(DRAW_INDEX_OFFSET,             0x29)
   ENUM_VALUE(INDEX_TYPE,                    0x2A)
   ENUM_VALUE(DRAW_INDEX,                    0x2B)
   ENUM_VALUE(LOAD_PALETTE,                  0x2C)
   ENUM_VALUE(DRAW_INDEX_AUTO,               0x2D)
   ENUM_VALUE(DRAW_INDEX_IMMD,               0x2E)
   ENUM_VALUE(NUM_INSTANCES,                 0x2F)
   ENUM_VALUE(DRAW_INDEX_MULTI_AUTO,         0x30)
   ENUM_VALUE(INDIRECT_BUFFER_PRIV,          0x32)
   ENUM_VALUE(STRMOUT_BUFFER_UPDATE,         0x34)
   ENUM_VALUE(DRAW_INDEX_OFFSET_2,           0x35)
   ENUM_VALUE(DRAW_INDEX_MULTI_ELEMENT,      0x36)
   ENUM_VALUE(INDIRECT_BUFFER_MP,            0x38)
   ENUM_VALUE(MEM_SEMAPHORE,                 0x39)
   ENUM_VALUE(MPEG_INDEX,                    0x3A)
   ENUM_VALUE(COPY_DW,                       0x3B)
   ENUM_VALUE(WAIT_REG_MEM,                  0x3C)
   ENUM_VALUE(MEM_WRITE,                     0x3D)
   ENUM_VALUE(PER_FRAME,                     0x3E)
   ENUM_VALUE(INDIRECT_BUFFER,               0x3F)
   ENUM_VALUE(CP_DMA,                        0x41)
   ENUM_VALUE(PFP_SYNC_ME,                   0x42)
   ENUM_VALUE(SURFACE_SYNC,                  0x43)
   ENUM_VALUE(ME_INITIALIZE,                 0x44)
   ENUM_VALUE(COND_WRITE,                    0x45)
   ENUM_VALUE(EVENT_WRITE,                   0x46)
   ENUM_VALUE(EVENT_WRITE_EOP,               0x47)
   ENUM_VALUE(LOAD_SURFACE_PROBE,            0x48)
   ENUM_VALUE(SURFACE_PROBE,                 0x49)
   ENUM_VALUE(PREAMBLE_CNTL,                 0x4A)
   ENUM_VALUE(RB_OFFSET,                     0x4B)
   ENUM_VALUE(GFX_CNTX_UPDATE,               0x52)
   ENUM_VALUE(BLK_CNTX_UPDATE,               0x53)
   ENUM_VALUE(IB_OFFSET,                     0x54)
   ENUM_VALUE(INCR_UPDT_STATE,               0x55)
   ENUM_VALUE(INCR_UPDT_CONST,               0x56)
   ENUM_VALUE(ONE_REG_WRITE,                 0x57)
   ENUM_VALUE(LOAD_CONFIG_REG,               0x60)
   ENUM_VALUE(LOAD_CONTEXT_REG,              0x61)
   ENUM_VALUE(LOAD_ALU_CONST,                0x62)
   ENUM_VALUE(LOAD_BOOL_CONST,               0x63)
   ENUM_VALUE(LOAD_LOOP_CONST,               0x64)
   ENUM_VALUE(LOAD_RESOURCE,                 0x65)
   ENUM_VALUE(LOAD_SAMPLER,                  0x66)
   ENUM_VALUE(LOAD_CTL_CONST,                0x67)
   ENUM_VALUE(SET_CONFIG_REG,                0x68)
   ENUM_VALUE(SET_CONTEXT_REG,               0x69)
   ENUM_VALUE(SET_ALU_CONST,                 0x6A)
   ENUM_VALUE(SET_BOOL_CONST,                0x6B)
   ENUM_VALUE(SET_LOOP_CONST,                0x6C)
   ENUM_VALUE(SET_RESOURCE,                  0x6D)
   ENUM_VALUE(SET_SAMPLER,                   0x6E)
   ENUM_VALUE(SET_CTL_CONST,                 0x6F)
   ENUM_VALUE(SET_RESOURCE_OFFSET,           0x70)
   ENUM_VALUE(STRMOUT_BASE_UPDATE,           0x72)
   ENUM_VALUE(SURFACE_BASE_UPDATE,           0x73)
   ENUM_VALUE(SET_ALL_CONTEXTS,              0x74)
   ENUM_VALUE(INDIRECT_BUFFER_BASE,          0x78)
   ENUM_VALUE(EXECUTE_IB2,                   0x79)
   ENUM_VALUE(PFP_REG_WR,                    0x7B)
   ENUM_VALUE(FORWARD_HEADER,                0x7C)
   ENUM_VALUE(PAINT,                         0x91)
   ENUM_VALUE(BITBLT,                        0x92)
   ENUM_VALUE(HOSTDATA_BLT,                  0x94)
   ENUM_VALUE(POLYLINE,                      0x95)
   ENUM_VALUE(POLYSCANLINES,                 0x98)
   ENUM_VALUE(PAINT_MULTI,                   0x9A)
   ENUM_VALUE(BITBLT_MULTI,                  0x9B)
   ENUM_VALUE(TRANS_BITBLT,                  0x9C)
   ENUM_VALUE(DRAW_2D_DIRTY_AREA,            0xFF)
ENUM_END(IT_OPCODE)

ENUM_NAMESPACE_EXIT(pm4)
ENUM_NAMESPACE_EXIT(latte)

#include <common/enum_end.inl>

#endif // ifdef LATTE_ENUM_PM4_H
