#ifndef LATTE_ENUM_CB_H
#define LATTE_ENUM_CB_H

#include <common/enum_start.inl>

ENUM_NAMESPACE_ENTER(latte)

ENUM_BEG(CB_BLEND_FUNC, uint32_t)
   ENUM_VALUE(ZERO,                       0)
   ENUM_VALUE(ONE,                        1)
   ENUM_VALUE(SRC_COLOR,                  2)
   ENUM_VALUE(ONE_MINUS_SRC_COLOR,        3)
   ENUM_VALUE(SRC_ALPHA,                  4)
   ENUM_VALUE(ONE_MINUS_SRC_ALPHA,        5)
   ENUM_VALUE(DST_ALPHA,                  6)
   ENUM_VALUE(ONE_MINUS_DST_ALPHA,        7)
   ENUM_VALUE(DST_COLOR,                  8)
   ENUM_VALUE(ONE_MINUS_DST_COLOR,        9)
   ENUM_VALUE(SRC_ALPHA_SATURATE,         10)
   ENUM_VALUE(BOTH_SRC_ALPHA,             11)
   ENUM_VALUE(BOTH_INV_SRC_ALPHA,         12)
   ENUM_VALUE(CONSTANT_COLOR,             13)
   ENUM_VALUE(ONE_MINUS_CONSTANT_COLOR,   14)
   ENUM_VALUE(SRC1_COLOR,                 15)
   ENUM_VALUE(ONE_MINUS_SRC1_COLOR,       16)
   ENUM_VALUE(SRC1_ALPHA,                 17)
   ENUM_VALUE(ONE_MINUS_SRC1_ALPHA,       18)
   ENUM_VALUE(CONSTANT_ALPHA,             19)
   ENUM_VALUE(ONE_MINUS_CONSTANT_ALPHA,   20)
ENUM_END(CB_BLEND_FUNC)

ENUM_BEG(CB_CLRCMP_DRAW, uint32_t)
   ENUM_VALUE(ALWAYS,                     0)
   ENUM_VALUE(NEVER,                      1)
   ENUM_VALUE(ON_NEQ,                     4)
   ENUM_VALUE(ON_EQ,                      5)
ENUM_END(CB_CLRCMP_DRAW)

ENUM_BEG(CB_CLRCMP_SEL, uint32_t)
   ENUM_VALUE(DST,                        0)
   ENUM_VALUE(SRC,                        1)
   ENUM_VALUE(AND,                        2)
ENUM_END(CB_CLRCMP_SEL)

ENUM_BEG(CB_COMB_FUNC, uint32_t)
   ENUM_VALUE(DST_PLUS_SRC,               0)
   ENUM_VALUE(SRC_MINUS_DST,              1)
   ENUM_VALUE(MIN_DST_SRC,                2)
   ENUM_VALUE(MAX_DST_SRC,                3)
   ENUM_VALUE(DST_MINUS_SRC,              4)
ENUM_END(CB_COMB_FUNC)

ENUM_BEG(CB_ENDIAN, uint32_t)
   ENUM_VALUE(NONE,                       0)
   ENUM_VALUE(SWAP_8IN16,                 1)
   ENUM_VALUE(SWAP_8IN32,                 2)
   ENUM_VALUE(SWAP_8IN64,                 3)
ENUM_END(CB_ENDIAN)

ENUM_BEG(CB_FORMAT, uint32_t)
   ENUM_VALUE(COLOR_INVALID,              0)
   ENUM_VALUE(COLOR_8,                    1)
   ENUM_VALUE(COLOR_4_4,                  2)
   ENUM_VALUE(COLOR_3_3_2,                3)
   ENUM_VALUE(COLOR_16,                   5)
   ENUM_VALUE(COLOR_16_FLOAT,             6)
   ENUM_VALUE(COLOR_8_8,                  7)
   ENUM_VALUE(COLOR_5_6_5,                8)
   ENUM_VALUE(COLOR_6_5_5,                9)
   ENUM_VALUE(COLOR_1_5_5_5,              10)
   ENUM_VALUE(COLOR_4_4_4_4,              11)
   ENUM_VALUE(COLOR_5_5_5_1,              12)
   ENUM_VALUE(COLOR_32,                   13)
   ENUM_VALUE(COLOR_32_FLOAT,             14)
   ENUM_VALUE(COLOR_16_16,                15)
   ENUM_VALUE(COLOR_16_16_FLOAT,          16)
   ENUM_VALUE(COLOR_8_24,                 17)
   ENUM_VALUE(COLOR_8_24_FLOAT,           18)
   ENUM_VALUE(COLOR_24_8,                 19)
   ENUM_VALUE(COLOR_24_8_FLOAT,           20)
   ENUM_VALUE(COLOR_10_11_11,             21)
   ENUM_VALUE(COLOR_10_11_11_FLOAT,       22)
   ENUM_VALUE(COLOR_11_11_10,             23)
   ENUM_VALUE(COLOR_11_11_10_FLOAT,       24)
   ENUM_VALUE(COLOR_2_10_10_10,           25)
   ENUM_VALUE(COLOR_8_8_8_8,              26)
   ENUM_VALUE(COLOR_10_10_10_2,           27)
   ENUM_VALUE(COLOR_X24_8_32_FLOAT,       28)
   ENUM_VALUE(COLOR_32_32,                29)
   ENUM_VALUE(COLOR_32_32_FLOAT,          30)
   ENUM_VALUE(COLOR_16_16_16_16,          31)
   ENUM_VALUE(COLOR_16_16_16_16_FLOAT,    32)
   ENUM_VALUE(COLOR_32_32_32_32,          34)
   ENUM_VALUE(COLOR_32_32_32_32_FLOAT,    35)
ENUM_END(CB_FORMAT)

ENUM_BEG(CB_NUMBER_TYPE, uint32_t)
   ENUM_VALUE(UNORM,                      0)
   ENUM_VALUE(SNORM,                      1)
   ENUM_VALUE(USCALED,                    2)
   ENUM_VALUE(SSCALED,                    3)
   ENUM_VALUE(UINT,                       4)
   ENUM_VALUE(SINT,                       5)
   ENUM_VALUE(SRGB,                       6)
   ENUM_VALUE(FLOAT,                      7)
ENUM_END(CB_NUMBER_TYPE)

ENUM_BEG(CB_ROUND_MODE, uint32_t)
   ENUM_VALUE(BY_HALF,                    0)
   ENUM_VALUE(TRUNCATE,                   1)
ENUM_END(CB_ROUND_MODE)

ENUM_BEG(CB_SOURCE_FORMAT, uint32_t)
   ENUM_VALUE(EXPORT_FULL,                0)
   ENUM_VALUE(EXPORT_NORM,                1)
ENUM_END(CB_SOURCE_FORMAT)

ENUM_BEG(CB_SPECIAL_OP, uint32_t)
   ENUM_VALUE(NORMAL,                     0)
   ENUM_VALUE(DISABLE,                    1)
   ENUM_VALUE(FAST_CLEAR,                 2)
   ENUM_VALUE(FORCE_CLEAR,                3)
   ENUM_VALUE(EXPAND_COLOR,               4)
   ENUM_VALUE(EXPAND_TEXTURE,             5)
   ENUM_VALUE(EXPAND_SAMPLES,             6)
   ENUM_VALUE(RESOLVE_BOX,                7)
ENUM_END(CB_SPECIAL_OP)

ENUM_BEG(CB_COMP_SWAP, uint32_t)
   ENUM_VALUE(STD,                        0)
   ENUM_VALUE(ALT,                        1)
   ENUM_VALUE(STD_REV,                    2)
   ENUM_VALUE(ALT_REV,                    3)
ENUM_END(CB_COMP_SWAP)

ENUM_BEG(CB_TILE_MODE, uint32_t)
   ENUM_VALUE(DISABLE,                    0)
   ENUM_VALUE(CLEAR_ENABLE,               1)
   ENUM_VALUE(FRAG_ENABLE,                2)
ENUM_END(CB_TILE_MODE)

ENUM_NAMESPACE_EXIT(latte)

#include <common/enum_end.inl>

#endif // ifdef LATTE_ENUM_CB_H
