#pragma once
#include <libcpu/be2_struct.h>

namespace nn::acp
{

using ACPTitleId = uint64_t;

struct ACPMetaXml
{
   be2_val<uint64_t> title_id;
   be2_val<uint64_t> boss_id;
   be2_val<uint64_t> os_version;
   be2_val<uint64_t> app_size;
   be2_val<uint64_t> common_save_size;
   be2_val<uint64_t> account_save_size;
   be2_val<uint64_t> common_boss_size;
   be2_val<uint64_t> account_boss_size;
   be2_val<uint64_t> join_game_mode_mask;
   be2_val<uint32_t> version;
   be2_array<char, 32> product_code;
   be2_array<char, 32> content_platform;
   be2_array<char, 8> company_code;
   be2_array<char, 32> mastering_date;
   be2_val<uint32_t> logo_type;
   be2_val<uint32_t> app_launch_type;
   be2_val<uint32_t> invisible_flag;
   be2_val<uint32_t> no_managed_flag;
   be2_val<uint32_t> no_event_log;
   be2_val<uint32_t> no_icon_database;
   be2_val<uint32_t> launching_flag;
   be2_val<uint32_t> install_flag;
   be2_val<uint32_t> closing_msg;
   be2_val<uint32_t> title_version;
   be2_val<uint32_t> group_id;
   be2_val<uint32_t> save_no_rollback;
   be2_val<uint32_t> bg_daemon_enable;
   be2_val<uint32_t> join_game_id;
   be2_val<uint32_t> olv_accesskey;
   be2_val<uint32_t> wood_tin;
   be2_val<uint32_t> e_manual;
   be2_val<uint32_t> e_manual_version;
   be2_val<uint32_t> region;
   be2_val<uint32_t> pc_cero;
   be2_val<uint32_t> pc_esrb;
   be2_val<uint32_t> pc_bbfc;
   be2_val<uint32_t> pc_usk;
   be2_val<uint32_t> pc_pegi_gen;
   be2_val<uint32_t> pc_pegi_fin;
   be2_val<uint32_t> pc_pegi_prt;
   be2_val<uint32_t> pc_pegi_bbfc;
   be2_val<uint32_t> pc_cob;
   be2_val<uint32_t> pc_grb;
   be2_val<uint32_t> pc_cgsrr;
   be2_val<uint32_t> pc_oflc;
   be2_val<uint32_t> pc_reserved0;
   be2_val<uint32_t> pc_reserved1;
   be2_val<uint32_t> pc_reserved2;
   be2_val<uint32_t> pc_reserved3;
   be2_val<uint32_t> ext_dev_nunchaku;
   be2_val<uint32_t> ext_dev_classic;
   be2_val<uint32_t> ext_dev_urcc;
   be2_val<uint32_t> ext_dev_board;
   be2_val<uint32_t> ext_dev_usb_keyboard;
   be2_val<uint32_t> ext_dev_etc;
   be2_array<char, 512> ext_dev_etc_name;
   be2_val<uint32_t> eula_version;
   be2_val<uint32_t> drc_use;
   be2_val<uint32_t> network_use;
   be2_val<uint32_t> online_account_use;
   be2_val<uint32_t> direct_boot;
   be2_array<uint32_t, 8> reserved_flags;
   be2_array<char, 512> longname_ja;
   be2_array<char, 512> longname_en;
   be2_array<char, 512> longname_fr;
   be2_array<char, 512> longname_de;
   be2_array<char, 512> longname_it;
   be2_array<char, 512> longname_es;
   be2_array<char, 512> longname_zhs;
   be2_array<char, 512> longname_ko;
   be2_array<char, 512> longname_nl;
   be2_array<char, 512> longname_pt;
   be2_array<char, 512> longname_ru;
   be2_array<char, 512> longname_zht;
   be2_array<char, 256> shortname_ja;
   be2_array<char, 256> shortname_en;
   be2_array<char, 256> shortname_fr;
   be2_array<char, 256> shortname_de;
   be2_array<char, 256> shortname_it;
   be2_array<char, 256> shortname_es;
   be2_array<char, 256> shortname_zhs;
   be2_array<char, 256> shortname_ko;
   be2_array<char, 256> shortname_nl;
   be2_array<char, 256> shortname_pt;
   be2_array<char, 256> shortname_ru;
   be2_array<char, 256> shortname_zht;
   be2_array<char, 256> publisher_ja;
   be2_array<char, 256> publisher_en;
   be2_array<char, 256> publisher_fr;
   be2_array<char, 256> publisher_de;
   be2_array<char, 256> publisher_it;
   be2_array<char, 256> publisher_es;
   be2_array<char, 256> publisher_zhs;
   be2_array<char, 256> publisher_ko;
   be2_array<char, 256> publisher_nl;
   be2_array<char, 256> publisher_pt;
   be2_array<char, 256> publisher_ru;
   be2_array<char, 256> publisher_zht;
   be2_array<uint32_t, 32> add_on_unique_ids;
   UNKNOWN(52);
};
CHECK_OFFSET(ACPMetaXml, 0x0000, title_id);
CHECK_OFFSET(ACPMetaXml, 0x0008, boss_id);
CHECK_OFFSET(ACPMetaXml, 0x0010, os_version);
CHECK_OFFSET(ACPMetaXml, 0x0018, app_size);
CHECK_OFFSET(ACPMetaXml, 0x0020, common_save_size);
CHECK_OFFSET(ACPMetaXml, 0x0028, account_save_size);
CHECK_OFFSET(ACPMetaXml, 0x0030, common_boss_size);
CHECK_OFFSET(ACPMetaXml, 0x0038, account_boss_size);
CHECK_OFFSET(ACPMetaXml, 0x0040, join_game_mode_mask);
CHECK_OFFSET(ACPMetaXml, 0x0048, version);
CHECK_OFFSET(ACPMetaXml, 0x004C, product_code);
CHECK_OFFSET(ACPMetaXml, 0x006C, content_platform);
CHECK_OFFSET(ACPMetaXml, 0x008C, company_code);
CHECK_OFFSET(ACPMetaXml, 0x0094, mastering_date);
CHECK_OFFSET(ACPMetaXml, 0x00B4, logo_type);
CHECK_OFFSET(ACPMetaXml, 0x00B8, app_launch_type);
CHECK_OFFSET(ACPMetaXml, 0x00BC, invisible_flag);
CHECK_OFFSET(ACPMetaXml, 0x00C0, no_managed_flag);
CHECK_OFFSET(ACPMetaXml, 0x00C4, no_event_log);
CHECK_OFFSET(ACPMetaXml, 0x00C8, no_icon_database);
CHECK_OFFSET(ACPMetaXml, 0x00CC, launching_flag);
CHECK_OFFSET(ACPMetaXml, 0x00D0, install_flag);
CHECK_OFFSET(ACPMetaXml, 0x00D4, closing_msg);
CHECK_OFFSET(ACPMetaXml, 0x00D8, title_version);
CHECK_OFFSET(ACPMetaXml, 0x00DC, group_id);
CHECK_OFFSET(ACPMetaXml, 0x00E0, save_no_rollback);
CHECK_OFFSET(ACPMetaXml, 0x00E4, bg_daemon_enable);
CHECK_OFFSET(ACPMetaXml, 0x00E8, join_game_id);
CHECK_OFFSET(ACPMetaXml, 0x00EC, olv_accesskey);
CHECK_OFFSET(ACPMetaXml, 0x00F0, wood_tin);
CHECK_OFFSET(ACPMetaXml, 0x00F4, e_manual);
CHECK_OFFSET(ACPMetaXml, 0x00F8, e_manual_version);
CHECK_OFFSET(ACPMetaXml, 0x00FC, region);
CHECK_OFFSET(ACPMetaXml, 0x0100, pc_cero);
CHECK_OFFSET(ACPMetaXml, 0x0104, pc_esrb);
CHECK_OFFSET(ACPMetaXml, 0x0108, pc_bbfc);
CHECK_OFFSET(ACPMetaXml, 0x010C, pc_usk);
CHECK_OFFSET(ACPMetaXml, 0x0110, pc_pegi_gen);
CHECK_OFFSET(ACPMetaXml, 0x0114, pc_pegi_fin);
CHECK_OFFSET(ACPMetaXml, 0x0118, pc_pegi_prt);
CHECK_OFFSET(ACPMetaXml, 0x011C, pc_pegi_bbfc);
CHECK_OFFSET(ACPMetaXml, 0x0120, pc_cob);
CHECK_OFFSET(ACPMetaXml, 0x0124, pc_grb);
CHECK_OFFSET(ACPMetaXml, 0x0128, pc_cgsrr);
CHECK_OFFSET(ACPMetaXml, 0x012C, pc_oflc);
CHECK_OFFSET(ACPMetaXml, 0x0130, pc_reserved0);
CHECK_OFFSET(ACPMetaXml, 0x0134, pc_reserved1);
CHECK_OFFSET(ACPMetaXml, 0x0138, pc_reserved2);
CHECK_OFFSET(ACPMetaXml, 0x013C, pc_reserved3);
CHECK_OFFSET(ACPMetaXml, 0x0140, ext_dev_nunchaku);
CHECK_OFFSET(ACPMetaXml, 0x0144, ext_dev_classic);
CHECK_OFFSET(ACPMetaXml, 0x0148, ext_dev_urcc);
CHECK_OFFSET(ACPMetaXml, 0x014C, ext_dev_board);
CHECK_OFFSET(ACPMetaXml, 0x0150, ext_dev_usb_keyboard);
CHECK_OFFSET(ACPMetaXml, 0x0154, ext_dev_etc);
CHECK_OFFSET(ACPMetaXml, 0x0158, ext_dev_etc_name);
CHECK_OFFSET(ACPMetaXml, 0x0358, eula_version);
CHECK_OFFSET(ACPMetaXml, 0x035C, drc_use);
CHECK_OFFSET(ACPMetaXml, 0x0360, network_use);
CHECK_OFFSET(ACPMetaXml, 0x0364, online_account_use);
CHECK_OFFSET(ACPMetaXml, 0x0368, direct_boot);
CHECK_OFFSET(ACPMetaXml, 0x036C, reserved_flags);
CHECK_OFFSET(ACPMetaXml, 0x038C, longname_ja);
CHECK_OFFSET(ACPMetaXml, 0x058C, longname_en);
CHECK_OFFSET(ACPMetaXml, 0x078C, longname_fr);
CHECK_OFFSET(ACPMetaXml, 0x098C, longname_de);
CHECK_OFFSET(ACPMetaXml, 0x0B8C, longname_it);
CHECK_OFFSET(ACPMetaXml, 0x0D8C, longname_es);
CHECK_OFFSET(ACPMetaXml, 0x0F8C, longname_zhs);
CHECK_OFFSET(ACPMetaXml, 0x118C, longname_ko);
CHECK_OFFSET(ACPMetaXml, 0x138C, longname_nl);
CHECK_OFFSET(ACPMetaXml, 0x158C, longname_pt);
CHECK_OFFSET(ACPMetaXml, 0x178C, longname_ru);
CHECK_OFFSET(ACPMetaXml, 0x198C, longname_zht);
CHECK_OFFSET(ACPMetaXml, 0x1B8C, shortname_ja);
CHECK_OFFSET(ACPMetaXml, 0x1C8C, shortname_en);
CHECK_OFFSET(ACPMetaXml, 0x1D8C, shortname_fr);
CHECK_OFFSET(ACPMetaXml, 0x1E8C, shortname_de);
CHECK_OFFSET(ACPMetaXml, 0x1F8C, shortname_it);
CHECK_OFFSET(ACPMetaXml, 0x208C, shortname_es);
CHECK_OFFSET(ACPMetaXml, 0x218C, shortname_zhs);
CHECK_OFFSET(ACPMetaXml, 0x228C, shortname_ko);
CHECK_OFFSET(ACPMetaXml, 0x238C, shortname_nl);
CHECK_OFFSET(ACPMetaXml, 0x248C, shortname_pt);
CHECK_OFFSET(ACPMetaXml, 0x258C, shortname_ru);
CHECK_OFFSET(ACPMetaXml, 0x268C, shortname_zht);
CHECK_OFFSET(ACPMetaXml, 0x278C, publisher_ja);
CHECK_OFFSET(ACPMetaXml, 0x288C, publisher_en);
CHECK_OFFSET(ACPMetaXml, 0x298C, publisher_fr);
CHECK_OFFSET(ACPMetaXml, 0x2A8C, publisher_de);
CHECK_OFFSET(ACPMetaXml, 0x2B8C, publisher_it);
CHECK_OFFSET(ACPMetaXml, 0x2C8C, publisher_es);
CHECK_OFFSET(ACPMetaXml, 0x2D8C, publisher_zhs);
CHECK_OFFSET(ACPMetaXml, 0x2E8C, publisher_ko);
CHECK_OFFSET(ACPMetaXml, 0x2F8C, publisher_nl);
CHECK_OFFSET(ACPMetaXml, 0x308C, publisher_pt);
CHECK_OFFSET(ACPMetaXml, 0x318C, publisher_ru);
CHECK_OFFSET(ACPMetaXml, 0x328C, publisher_zht);
CHECK_OFFSET(ACPMetaXml, 0x338C, add_on_unique_ids);
CHECK_SIZE(ACPMetaXml, 0x3440);

} // namespace nn::acp
