#ifndef IOS_NET_ENUM_H
#define IOS_NET_ENUM_H

#include <common/enum_start.inl>

ENUM_NAMESPACE_ENTER(ios)

ENUM_NAMESPACE_ENTER(net)

ENUM_BEG(SocketCommand, uint32_t)
   ENUM_VALUE(Accept,                  0x1)
   ENUM_VALUE(Bind,                    0x2)
   ENUM_VALUE(Close,                   0x3)
   ENUM_VALUE(Connect,                 0x4)
   ENUM_VALUE(GetPeerName,             0x6)
   ENUM_VALUE(GetSockName,             0x7)
   ENUM_VALUE(GetSockOpt,              0x8)
   ENUM_VALUE(SetSockOpt,              0x9)
   ENUM_VALUE(Listen,                  0xA)
   ENUM_VALUE(Recv,                    0xC)
   ENUM_VALUE(RecvFrom,                0xD)
   ENUM_VALUE(Send,                    0xE)
   ENUM_VALUE(SendTo,                  0xF)
   ENUM_VALUE(Shutdown,                0x10)
   ENUM_VALUE(Socket,                  0x11)
   ENUM_VALUE(DnsQuery,                0x26)
   ENUM_VALUE(Select,                  0x27)
   ENUM_VALUE(SimplePing,              0x28)
   ENUM_VALUE(SimplePingResult,        0x29)
   ENUM_VALUE(GetProcessSocketHandle,  0x2A)
   ENUM_VALUE(CloseAll,                0x2D)
   ENUM_VALUE(GetProxyConfig,          0x2E)
   ENUM_VALUE(GetOpt,                  0x2F)
   ENUM_VALUE(SetOpt,                  0x30)
   ENUM_VALUE(ClearResolverCache,      0x32)
   ENUM_VALUE(SendToMulti,             0x33)
   ENUM_VALUE(RecvFromMulti,           0x35)
   ENUM_VALUE(SendToMultiEx,           0x36)
   ENUM_VALUE(RecvFromEx,              0x38)
ENUM_END(SocketCommand)

ENUM_BEG(SocketDnsQueryType, uint8_t)
   ENUM_VALUE(GetHostByName,           1)
ENUM_END(SocketDnsQueryType)

ENUM_BEG(SocketError, uint32_t)
   ENUM_VALUE(OK,                0)
   ENUM_VALUE(NoBufs,            1)
   ENUM_VALUE(TimedOut,          2)
   ENUM_VALUE(IsConn,            3)
   ENUM_VALUE(OpNotSupp,         4)
   ENUM_VALUE(ConnAborted,       5)
   ENUM_VALUE(WouldBlock,        6)
   ENUM_VALUE(ConnRefused,       7)
   ENUM_VALUE(ConnReset,         8)
   ENUM_VALUE(NotConn,           9)
   ENUM_VALUE(Already,           10)
   ENUM_VALUE(Inval,             11)
   ENUM_VALUE(MsgSize,           12)
   ENUM_VALUE(Pipe,              13)
   ENUM_VALUE(DestAddrReq,       14)
   ENUM_VALUE(Shutdown,          15)
   ENUM_VALUE(NoProtoOpt,        16)
   ENUM_VALUE(HaveOob,           17)
   ENUM_VALUE(NoMem,             18)
   ENUM_VALUE(AddrNotAvail,      19)
   ENUM_VALUE(AddrInUse,         20)
   ENUM_VALUE(AfNoSupport,       21)
   ENUM_VALUE(InProgress,        22)
   ENUM_VALUE(Lower,             23)
   ENUM_VALUE(NotSock,           24)
   ENUM_VALUE(Eieio,             27)
   ENUM_VALUE(TooManyRefs,       28)
   ENUM_VALUE(Fault,             29)
   ENUM_VALUE(NetUnreach,        30)
   ENUM_VALUE(ProtoNoSupport,    31)
   ENUM_VALUE(Prototype,         32)
   ENUM_VALUE(GenericError,      41)
   ENUM_VALUE(NoLibRm,           42)
   ENUM_VALUE(NotInitialised,    43)
   ENUM_VALUE(Busy,              44)
   ENUM_VALUE(Unknown,           45)
   ENUM_VALUE(NoResources,       48)
   ENUM_VALUE(BadFd,             49)
   ENUM_VALUE(Aborted,           50)
   ENUM_VALUE(MFile,             51)
ENUM_END(SocketError)

ENUM_BEG(SocketFamily, uint32_t)
   ENUM_VALUE(Inet,              0x2)
ENUM_END(SocketFamily)

ENUM_NAMESPACE_EXIT(net)

ENUM_NAMESPACE_EXIT(ios)

#include <common/enum_end.inl>

#endif // ifdef IOS_NET_ENUM_H
