#ifndef IOS_KERNEL_ENUM_H
#define IOS_KERNEL_ENUM_H

#include <common/enum_start.inl>

ENUM_NAMESPACE_ENTER(ios)

ENUM_NAMESPACE_ENTER(kernel)

ENUM_BEG(DeviceId, uint32_t)
   ENUM_VALUE(Timer,                0)
   ENUM_VALUE(NandInterfaceAHBALL,  1)
   ENUM_VALUE(AesEngineAHBALL,      2)
   ENUM_VALUE(Sha1EngineAHBALL,     3)
   ENUM_VALUE(UsbEhci,              4)
   ENUM_VALUE(UsbOhci0,             5)
   ENUM_VALUE(UsbOhci1,             6)
   ENUM_VALUE(SdHostController,     7)
   ENUM_VALUE(Wireless80211,        8)
   ENUM_VALUE(SysEvent,             9)
   ENUM_VALUE(SysProt,              10)
   ENUM_VALUE(PowerButton,          15)
   ENUM_VALUE(DriveInterface,       16)
   ENUM_VALUE(ExiRtc,               18)
   ENUM_VALUE(Sata,                 26)
   ENUM_VALUE(IpcStarbuckCompat,    29)
   ENUM_VALUE(Unknown30,            30)
   ENUM_VALUE(Unknown31,            31)
   ENUM_VALUE(Unknown32,            32)
   ENUM_VALUE(Unknown33,            33)
   ENUM_VALUE(Drh,                  34)
   ENUM_VALUE(Unknown35,            35)
   ENUM_VALUE(Unknown36,            36)
   ENUM_VALUE(Unknown37,            37)
   ENUM_VALUE(AesEngineAHBLT,       38)
   ENUM_VALUE(Sha1EngineAHBLT,      39)
   ENUM_VALUE(Unknown40,            40)
   ENUM_VALUE(Unknown41,            41)
   ENUM_VALUE(Unknown42,            42)
   ENUM_VALUE(I2CEspresso,          43)
   ENUM_VALUE(I2CStarbuck,          44)
   ENUM_VALUE(IpcStarbuckCore2,     45)
   ENUM_VALUE(IpcStarbuckCore1,     46)
   ENUM_VALUE(IpcStarbuckCore0,     47)
ENUM_END(DeviceId)

FLAGS_BEG(HeapFlags, uint32_t)
   FLAGS_VALUE(LocalProcessHeap,    1 << 0)
   FLAGS_VALUE(CrossProcessHeap,    1 << 1)
FLAGS_END(HeapFlags)

ENUM_BEG(HeapBlockState, uint32_t)
   ENUM_VALUE(Free,                 0xBABE0000)
   ENUM_VALUE(Allocated,            0xBABE0001)
   ENUM_VALUE(InnerBlock,           0xBABE0002)
ENUM_END(HeapBlockState)

FLAGS_BEG(MessageFlags, uint8_t)
   FLAGS_VALUE(None,                      0)
   FLAGS_VALUE(NonBlocking,               1)
FLAGS_END(MessageFlags)

FLAGS_BEG(MessageQueueFlags, uint8_t)
   FLAGS_VALUE(None,                      0)
   FLAGS_VALUE(RegisteredEventHandler,    1)
FLAGS_END(MessageQueueFlags)

ENUM_BEG(OtpFieldIndex, uint32_t)
   ENUM_VALUE(WiiBoot1Sha1Hash,           0x1)
   ENUM_VALUE(WiiCommonKey,               0x5)
   ENUM_VALUE(WiiNgId,                    0x9)
   ENUM_VALUE(WiiNgPrivateKey,            0xA)
   ENUM_VALUE(WiiNandHmac,                0x11)
   ENUM_VALUE(WiiNandKey,                 0x16)
   ENUM_VALUE(WiiRngKey,                  0x1A)
   ENUM_VALUE(SecurityLevel,              0x20)
   ENUM_VALUE(StarbuckAncastKey,          0x24)
   ENUM_VALUE(SeepromKey,                 0x28)
   ENUM_VALUE(VwiiCommonKey,              0x34)
   ENUM_VALUE(CommonKey,                  0x38)
   ENUM_VALUE(SslRsaKey,                  0x48)
   ENUM_VALUE(UsbStorageKey,              0x4C)
   ENUM_VALUE(Unknown0x50,                0x50)
   ENUM_VALUE(XorKey,                     0x54)
   ENUM_VALUE(RngKey,                     0x58)
   ENUM_VALUE(SlcKey,                     0x5C)
   ENUM_VALUE(MlcKey,                     0x60)
   ENUM_VALUE(ShddKey,                    0x64)
   ENUM_VALUE(DrhWlanKey,                 0x68)
   ENUM_VALUE(SlcHmac,                    0x78)
   ENUM_VALUE(NgId,                       0x87)
   ENUM_VALUE(NgPrivateKey,               0x88)
   ENUM_VALUE(NssPrivateKey,              0x90)
   ENUM_VALUE(OtpRngSeed,                 0x98)
   ENUM_VALUE(RootCertMsId,               0xA0)
   ENUM_VALUE(RootCertCaId,               0xA1)
   ENUM_VALUE(RootCertNgId,               0xC2)
   ENUM_VALUE(RootCertNgSig,              0xC3)
   ENUM_VALUE(WiiKoreanKey,               0xD2)
   ENUM_VALUE(WiiNssPrivateKey,           0xD8)
   ENUM_VALUE(Boot1Key,                   0xE8)
   ENUM_VALUE(OtpVersion,                 0xF9)
   ENUM_VALUE(OtpDateCode,                0xFA)
   ENUM_VALUE(OtpVersionName,             0xFC)
   ENUM_VALUE(JtagStatus,                 0xFF)
ENUM_END(OtpFieldIndex)

ENUM_BEG(OtpFieldSize, uint32_t)
   ENUM_VALUE(WiiBoot1Sha1Hash,           0x14)
   ENUM_VALUE(WiiCommonKey,               0x10)
   ENUM_VALUE(WiiNgId,                    0x4)
   ENUM_VALUE(WiiNgPrivateKey,            0x1C)
   ENUM_VALUE(WiiNandHmac,                0x14)
   ENUM_VALUE(WiiNandKey,                 0x10)
   ENUM_VALUE(WiiRngKey,                  0x10)
   ENUM_VALUE(SecurityLevel,              0x4)
   ENUM_VALUE(StarbuckAncastKey,          0x10)
   ENUM_VALUE(SeepromKey,                 0x10)
   ENUM_VALUE(VwiiCommonKey,              0x10)
   ENUM_VALUE(CommonKey,                  0x10)
   ENUM_VALUE(SslRsaKey,                  0x10)
   ENUM_VALUE(UsbStorageKey,              0x10)
   ENUM_VALUE(Unknown0x50,                0x10)
   ENUM_VALUE(XorKey,                     0x10)
   ENUM_VALUE(RngKey,                     0x10)
   ENUM_VALUE(SlcKey,                     0x10)
   ENUM_VALUE(MlcKey,                     0x10)
   ENUM_VALUE(ShddKey,                    0x10)
   ENUM_VALUE(DrhWlanKey,                 0x10)
   ENUM_VALUE(SlcHmac,                    0x14)
   ENUM_VALUE(NgId,                       0x4)
   ENUM_VALUE(NgPrivateKey,               0x20)
   ENUM_VALUE(NssPrivateKey,              0x20)
   ENUM_VALUE(OtpRngSeed,                 0x10)
   ENUM_VALUE(RootCertMsId,               0x4)
   ENUM_VALUE(RootCertCaId,               0x4)
   ENUM_VALUE(RootCertNgId,               0x4)
   ENUM_VALUE(RootCertNgSig,              0x3C)
   ENUM_VALUE(WiiKoreanKey,               0x10)
   ENUM_VALUE(WiiNssPrivateKey,           0x20)
   ENUM_VALUE(Boot1Key,                   0x10)
   ENUM_VALUE(OtpVersion,                 0x4)
   ENUM_VALUE(OtpDateCode,                0x8)
   ENUM_VALUE(OtpVersionName,             0x8)
   ENUM_VALUE(JtagStatus,                 0x4)
ENUM_END(OtpFieldSize)

ENUM_BEG(RootThreadCommand, int32_t)
   ENUM_VALUE(Timer,                0x100)
   ENUM_VALUE(SysprotEvent,         0x101)
ENUM_END(RootThreadCommand)

ENUM_BEG(ResourceHandleState, int32_t)
   ENUM_VALUE(Free,                 0x00)
   ENUM_VALUE(Opening,              0x11)
   ENUM_VALUE(Open,                 0x22)
   ENUM_VALUE(Closed,               0x33)
ENUM_END(ResourceHandleState)

ENUM_BEG(ResourcePermissionGroup, int32_t)
   ENUM_VALUE(None,                 0)
   ENUM_VALUE(BSP,                  1)
   ENUM_VALUE(DK,                   3)
   ENUM_VALUE(FS,                   11)
   ENUM_VALUE(UHS,                  12)
   ENUM_VALUE(MCP,                  13)
   ENUM_VALUE(NIM,                  14)
   ENUM_VALUE(ACT,                  15)
   ENUM_VALUE(FPD,                  16)
   ENUM_VALUE(BOSS,                 17)
   ENUM_VALUE(ACP,                  18)
   ENUM_VALUE(PDM,                  19)
   ENUM_VALUE(AC,                   20)
   ENUM_VALUE(NDM,                  21)
   ENUM_VALUE(NSEC,                 22)
   ENUM_VALUE(PAD,                  1000)
   ENUM_VALUE(All,                  0x7FFFFFFF)
ENUM_END(ResourcePermissionGroup)

ENUM_BEG(SecurityLevel, uint32_t)
   ENUM_VALUE(Test,                 10)
   ENUM_VALUE(Debug,                20)
   ENUM_VALUE(Normal,               30)
ENUM_END(SecurityLevel)

FLAGS_BEG(ThreadFlags, uint32_t)
   FLAGS_VALUE(Detached,               1 << 0)
   FLAGS_VALUE(AllocateTLS,            1 << 1)
FLAGS_END(ThreadFlags)

ENUM_BEG(ThreadState, uint32_t)
   ENUM_VALUE(Available,               0x00)
   ENUM_VALUE(Ready,                   0x01)
   ENUM_VALUE(Running,                 0x02)
   ENUM_VALUE(Stopped,                 0x03)
   ENUM_VALUE(Waiting,                 0x04)
   ENUM_VALUE(Dead,                    0x05)
   ENUM_VALUE(Faulted,                 0x06)
   ENUM_VALUE(Unknown,                 0x07)
ENUM_END(ThreadState)

ENUM_BEG(TimerState, uint32_t)
   ENUM_VALUE(Free,                    0x00)
   ENUM_VALUE(Ready,                   0x01)
   ENUM_VALUE(Running,                 0x02)
   ENUM_VALUE(Triggered,               0x03)
   ENUM_VALUE(Stopped,                 0x04)
ENUM_END(TimerState)

ENUM_NAMESPACE_EXIT(kernel)

ENUM_NAMESPACE_EXIT(ios)

#include <common/enum_end.inl>

#endif // ifdef IOS_KERNEL_ENUM_H
