#ifndef IOS_FS_ENUM_H
#define IOS_FS_ENUM_H

#include <common/enum_start.inl>

ENUM_NAMESPACE_ENTER(ios)

ENUM_NAMESPACE_ENTER(fs)

ENUM_BEG(FSACommand, uint32_t)
   ENUM_VALUE(Invalid,                 0x0)
   ENUM_VALUE(Mount,                   0x1)
   ENUM_VALUE(Unmount,                 0x2)
   ENUM_VALUE(GetVolumeInfo,           0x3)
   ENUM_VALUE(GetAttach,               0x4)
   ENUM_VALUE(ChangeDir,               0x5)
   ENUM_VALUE(GetCwd,                  0x6)
   ENUM_VALUE(MakeDir,                 0x7)
   ENUM_VALUE(Remove,                  0x8)
   ENUM_VALUE(Rename,                  0x9)
   ENUM_VALUE(OpenDir,                 0xA)
   ENUM_VALUE(ReadDir,                 0xB)
   ENUM_VALUE(RewindDir,               0xC)
   ENUM_VALUE(CloseDir,                0xD)
   ENUM_VALUE(OpenFile,                0xE)
   ENUM_VALUE(ReadFile,                0xF)
   ENUM_VALUE(WriteFile,               0x10)
   ENUM_VALUE(GetPosFile,              0x11)
   ENUM_VALUE(SetPosFile,              0x12)
   ENUM_VALUE(IsEof,                   0x13)
   ENUM_VALUE(StatFile,                0x14)
   ENUM_VALUE(CloseFile,               0x15)
   ENUM_VALUE(GetError,                0x16)
   ENUM_VALUE(FlushFile,               0x17)
   ENUM_VALUE(GetInfoByQuery,          0x18)
   ENUM_VALUE(AppendFile,              0x19)
   ENUM_VALUE(TruncateFile,            0x1A)
   ENUM_VALUE(FlushVolume,             0x1B)
   ENUM_VALUE(RollbackVolume,          0x1C)
   ENUM_VALUE(MakeQuota,               0x1D)
   ENUM_VALUE(FlushQuota,              0x1E)
   ENUM_VALUE(RollbackQuota,           0x1F)
   ENUM_VALUE(ChangeMode,              0x20)
   ENUM_VALUE(OpenFileByStat,          0x21)
   ENUM_VALUE(RegisterFlushQuota,      0x22)
   ENUM_VALUE(FlushMultiQuota,         0x23)
   ENUM_VALUE(GetFileBlockAddress,     0x25)
   ENUM_VALUE(AddUserProcess,          0x65)
   ENUM_VALUE(DelUserProcess,          0x66)
   ENUM_VALUE(MountWithProcess,        0x67)
   ENUM_VALUE(UnmountWithProcess,      0x68)
   ENUM_VALUE(Format,                  0x69)
   ENUM_VALUE(RawOpen,                 0x6A)
   ENUM_VALUE(RawRead,                 0x6B)
   ENUM_VALUE(RawWrite,                0x6C)
   ENUM_VALUE(RawClose,                0x6D)
   ENUM_VALUE(GetLastFailedVolume,     0x6E)
   ENUM_VALUE(GetVolumeExistence,      0x6F)
   ENUM_VALUE(ChangeOwner,             0x70)
   ENUM_VALUE(CancelGetAttach,         0x71)
   ENUM_VALUE(RemoveQuota,             0x72)
   ENUM_VALUE(SetClientPriority,       0x73)
   ENUM_VALUE(ApplyMemoryCache,        0x74)
   ENUM_VALUE(MakeLink,                0x75)
   ENUM_VALUE(XferParams,              0x76)
   ENUM_VALUE(ExecDebugProc,           0x78)
   ENUM_VALUE(DebugSetTitleId,         0x79)
   ENUM_VALUE(DebugSetCapability,      0x7A)
   ENUM_VALUE(SetProcessConfig,        0x82)
   ENUM_VALUE(ConfigSetMemoryCache,    0x83)
   ENUM_VALUE(ConfigUnsetMemoryCache,  0x84)
   ENUM_VALUE(ConfigSetPrf2CharCode,   0x85)
   ENUM_VALUE(GetProcResourceUsage,    0x8C)
   ENUM_VALUE(GetAllResourceUsage,     0x8D)
   ENUM_VALUE(SendProfileCmd,          0x8E)
ENUM_END(FSACommand)

ENUM_BEG(FSAMediaState, uint32_t)
   ENUM_VALUE(Ready,                   0)
   ENUM_VALUE(NoMedia,                 1)
   ENUM_VALUE(InvalidMedia,            2)
   ENUM_VALUE(DirtyMedia,              3)
   ENUM_VALUE(MediaError,              4)
ENUM_END(FSAMediaState)

ENUM_BEG(FSAMountPriority, uint32_t)
   ENUM_VALUE(Base,                    1)
   ENUM_VALUE(RamDiskCache,            4)
   ENUM_VALUE(TitleUpdate,             9)
   ENUM_VALUE(UnmountAll,              0x80000000)
ENUM_END(FSAMountPriority)

ENUM_BEG(FSAQueryInfoType, uint32_t)
   ENUM_VALUE(FreeSpaceSize,           0)
   ENUM_VALUE(DirSize,                 1)
   ENUM_VALUE(EntryNum,                2)
   ENUM_VALUE(FileSystemInfo,          3)
   ENUM_VALUE(DeviceInfo,              4)
   ENUM_VALUE(Stat,                    5)
   ENUM_VALUE(BadBlockInfo,            6)
   ENUM_VALUE(JournalFreeSpaceSize,    7)
   ENUM_VALUE(FragmentBlockInfo,       8)
ENUM_END(FSAQueryInfoType)

FLAGS_BEG(FSAReadFlag, uint32_t)
   FLAGS_VALUE(None,                   0x0)
   FLAGS_VALUE(ReadWithPos,            1 << 0)
FLAGS_END(FSAReadFlag)

ENUM_BEG(FSAStatFlags, uint32_t)
   ENUM_VALUE(Quota,                   0x40000000)
   ENUM_VALUE(Directory,               0x80000000)
ENUM_END(FSAStatFlags)

ENUM_BEG(FSAStatus, int32_t)
   ENUM_VALUE(OK,                      0)
   ENUM_VALUE(NotInit,                 -0x30001)
   ENUM_VALUE(Busy,                    -0x30002)
   ENUM_VALUE(Cancelled,               -0x30003)
   ENUM_VALUE(EndOfDir,                -0x30004)
   ENUM_VALUE(EndOfFile,               -0x30005)
   ENUM_VALUE(MaxMountpoints,          -0x30010)
   ENUM_VALUE(MaxVolumes,              -0x30011)
   ENUM_VALUE(MaxClients,              -0x30012)
   ENUM_VALUE(MaxFiles,                -0x30013)
   ENUM_VALUE(MaxDirs,                 -0x30014)
   ENUM_VALUE(AlreadyOpen,             -0x30015)
   ENUM_VALUE(AlreadyExists,           -0x30016)
   ENUM_VALUE(NotFound,                -0x30017)
   ENUM_VALUE(NotEmpty,                -0x30018)
   ENUM_VALUE(AccessError,             -0x30019)
   ENUM_VALUE(PermissionError,         -0x3001a)
   ENUM_VALUE(DataCorrupted,           -0x3001b)
   ENUM_VALUE(StorageFull,             -0x3001c)
   ENUM_VALUE(JournalFull,             -0x3001d)
   ENUM_VALUE(LinkEntry,               -0x3001e)
   ENUM_VALUE(UnavailableCmd,          -0x3001f)
   ENUM_VALUE(UnsupportedCmd,          -0x30020)
   ENUM_VALUE(InvalidParam,            -0x30021)
   ENUM_VALUE(InvalidPath,             -0x30022)
   ENUM_VALUE(InvalidBuffer,           -0x30023)
   ENUM_VALUE(InvalidAlignment,        -0x30024)
   ENUM_VALUE(InvalidClientHandle,     -0x30025)
   ENUM_VALUE(InvalidFileHandle,       -0x30026)
   ENUM_VALUE(InvalidDirHandle,        -0x30027)
   ENUM_VALUE(NotFile,                 -0x30028)
   ENUM_VALUE(NotDir,                  -0x30029)
   ENUM_VALUE(FileTooBig,              -0x3002a)
   ENUM_VALUE(OutOfRange,              -0x3002b)
   ENUM_VALUE(OutOfResources,          -0x3002c)
   ENUM_VALUE(MediaNotReady,           -0x30040)
   ENUM_VALUE(MediaError,              -0x30041)
   ENUM_VALUE(WriteProtected,          -0x30042)
   ENUM_VALUE(InvalidMedia,            -0x30043)
ENUM_END(FSAStatus)

FLAGS_BEG(FSAWriteFlag, uint32_t)
   FLAGS_VALUE(None,                   0x0)
   FLAGS_VALUE(WriteWithPos,           0x1)
FLAGS_END(FSAWriteFlag)

ENUM_BEG(FSResourcePermissions, uint32_t)
   ENUM_VALUE(SdCardRead,              0x90000)
   ENUM_VALUE(SdCardWrite,             0xA0000)
ENUM_END(FSResourcePermissions)

ENUM_NAMESPACE_EXIT(fs)

ENUM_NAMESPACE_EXIT(ios)

#include <common/enum_end.inl>

#endif // ifdef IOS_FS_ENUM_H
