#pragma once
#include "espresso_instruction.h"

namespace espresso
{

enum class SPR
{
   XER = 0x1,
   LR = 0x8,
   CTR = 0x9,
   DSISR = 0x12,
   DAR = 0x13,
   DEC = 0x16,
   SDR1 = 0x19,
   SRR0 = 0x1A,
   SRR1 = 0x1B,
   UTBL = 0x10C,
   UTBU = 0x10D,
   SPRG0 = 0x110,
   SPRG1 = 0x111,
   SPRG2 = 0x112,
   SPRG3 = 0x113,
   EAR = 0x11A,
   TBL = 0x11C,
   TBU = 0x11D,
   PVR = 0x11F,
   IBAT0U = 0x210,
   IBAT0L = 0x211,
   IBAT1U = 0x212,
   IBAT1L = 0x213,
   IBAT2U = 0x214,
   IBAT2L = 0x215,
   IBAT3U = 0x216,
   IBAT3L = 0x217,
   DBAT0U = 0x218,
   DBAT0L = 0x219,
   DBAT1U = 0x21A,
   DBAT1L = 0x21B,
   DBAT2U = 0x21C,
   DBAT2L = 0x21D,
   DBAT3U = 0x21E,
   DBAT3L = 0x21F,
   IBAT4U = 0x230,
   IBAT4L = 0x231,
   IBAT5U = 0x232,
   IBAT5L = 0x233,
   IBAT6U = 0x234,
   IBAT6L = 0x235,
   IBAT7U = 0x236,
   IBAT7L = 0x237,
   DBAT4U = 0x238,
   DBAT4L = 0x239,
   DBAT5U = 0x23A,
   DBAT5L = 0x23B,
   DBAT6U = 0x23C,
   DBAT6L = 0x23D,
   DBAT7U = 0x23E,
   DBAT7L = 0x23F,
   UGQR0 = 0x380,
   UGQR1 = 0x381,
   UGQR2 = 0x382,
   UGQR3 = 0x383,
   UGQR4 = 0x384,
   UGQR5 = 0x385,
   UGQR6 = 0x386,
   UGQR7 = 0x387,
   UHID2 = 0x388,
   UWPAR = 0x389,
   UDMAU = 0x38A,
   UDMAL = 0x38B,
   GQR0 = 0x390,
   GQR1 = 0x391,
   GQR2 = 0x392,
   GQR3 = 0x393,
   GQR4 = 0x394,
   GQR5 = 0x395,
   GQR6 = 0x396,
   GQR7 = 0x397,
   HID2 = 0x398,
   WPAR = 0x399,
   DMA_U = 0x39A,
   DMA_L = 0x39B,
   UMMCR0 = 0x3A8,
   UPMC1 = 0x3A9,
   UPMC2 = 0x3AA,
   USIA = 0x3AB,
   UMMCR1 = 0x3AC,
   UPMC3 = 0x3AD,
   UPMC4 = 0x3AE,
   HID5 = 0x3B0,
   PCSR = 0x3B2,
   SCR = 0x3B3,
   CAR = 0x3B4,
   BCR = 0x3B5,
   WPSAR = 0x3B6,
   MMCR0 = 0x3B8,
   PMC1 = 0x3B9,
   PMC2 = 0x3BA,
   SIA = 0x3BB,
   MMCR1 = 0x3BC,
   PMC3 = 0x3BD,
   PMC4 = 0x3BE,
   DCATE = 0x3D0,
   DCATR = 0x3D1,
   DMATL0 = 0x3D8,
   DMATU0 = 0x3D9,
   DMATR0 = 0x3DA,
   DMATL1 = 0x3DB,
   DMATU1 = 0x3DC,
   DMATR1 = 0x3DD,
   UPIR = 0x3EF,
   HID0 = 0x3F0,
   HID1 = 0x3F1,
   IABR = 0x3F2,
   HID4 = 0x3F3,
   TDCL = 0x3F4,
   DABR = 0x3F5,
   L2CR = 0x3F9,
   TDCH = 0x3FA,
   ICTC = 0x3FB,
   THRM1 = 0x3FC,
   THRM2 = 0x3FD,
   THRM3 = 0x3FE,
   PIR = 0x3FF,
};

SPR
decodeSPR(Instruction instr);

void
encodeSPR(Instruction &instr, SPR spr);

} // namespace espresso
