#pragma once

namespace nCine {

	enum class Keys
	{
		// Common keysyms
		Backspace,
		Tab,
		Return,
		Escape,
		Space,
		Quote,
		Plus,
		Comma,
		Minus,
		Period,
		Slash,
		D0,
		D1,
		D2,
		D3,
		D4,
		D5,
		D6,
		D7,
		D8,
		D9,
		Semicolon,
		LeftBracket,
		Backslash,
		RightBracket,
		Backquote,

		A,
		B,
		C,
		D,
		E,
		F,
		G,
		H,
		I,
		J,
		K,
		L,
		M,
		N,
		O,
		P,
		Q,
		R,
		S,
		T,
		U,
		V,
		W,
		X,
		Y,
		Z,
		Delete,

		NumPad0,
		NumPad1,
		NumPad2,
		NumPad3,
		NumPad4,
		NumPad5,
		NumPad6,
		NumPad7,
		NumPad8,
		NumPad9,
		NumPadPeriod,
		NumPadDivide,
		NumPadMultiply,
		NumPadMinus,
		NumPadPlus,
		NumPadEnter,
		NumPadEquals,

		Up,
		Down,
		Right,
		Left,
		Insert,
		Home,
		End,
		PageUp,
		PageDown,

		F1,
		F2,
		F3,
		F4,
		F5,
		F6,
		F7,
		F8,
		F9,
		F10,
		F11,
		F12,
		F13,
		F14,
		F15,

		NumLock,
		CapsLock,
		ScrollLock,
		RShift,
		LShift,
		RCtrl,
		LCtrl,
		RAlt,
		LAlt,
		RSuper,
		LSuper,
		PrintScreen,
		Pause,
		Menu,

		// SDL only keysyms
		Clear, // Android too
		Exclaim,
		QuoteDbl,
		Hash,
		Dollar,
		Ampersand,
		LeftParen,
		RightParen,
		Asterisk,
		Colon,
		Less,
		Equals, // Android too
		Greater,
		Question,
		At, // Android too
		Caret,
		Underscore,
		Mode,
		Application,
		Help,
		SysReq, // Android too
		Power, // Android too
		Undo,

		// GLFW only keysyms
		World1,
		World2,

		// Android only keysyms
		SoftLeft,
		SoftRight,
		Back,
		Call,
		EndCall,
		Star,
		Pound,
		DpadCenter,
		VolumeUp,
		VolumeDown,
		Camera,
		Sym,
		Explorer,
		Envelope,
		Num,
		HeadsetHook,
		Focus,
		Notification,
		Search,
		MediaPlayPause,
		MediaStop,
		MediaNext,
		MediaPrevious,
		MediaRewind,
		MediaFastForward,
		Mute,
		PictSymbols,
		SwitchCharset,
		ButtonA,
		ButtonB,
		ButtonC,
		ButtonX,
		ButtonY,
		ButtonZ,
		ButtonL1,
		ButtonR1,
		ButtonL2,
		ButtonR2,
		ButtonThumbLeft,
		ButtonThumbRight,
		ButtonStart,
		ButtonSelect,
		ButtonMode,
		// From API level 13
		FunctionKey,
		MoveHome,
		MoveEnd,
		Forward,
		MediaPlay,
		MediaPause,
		MediaClose,
		MediaEject,
		MediaRecord,
		NumPadComma,
		NumPadLeftParen,
		NumPadRightParen,
		VolumeMute,
		Info,
		ChannelUp,
		ChannelDown,
		ZoomIn,
		ZoomOut,
		TV,
		Window,
		Guide,
		DVR,
		Bookmark,
		Captions,
		Settings,
		TVPower,
		TVInput,
		STBPower,
		STBInput,
		AVRPower,
		AVRInput,
		ProgRed,
		ProgGreen,
		ProgYellow,
		ProgBlue,
		AppSwitch,
		Button1,
		Button2,
		Button3,
		Button4,
		Button5,
		Button6,
		Button7,
		Button8,
		Button9,
		Button10,
		Button11,
		Button12,
		Button13,
		Button14,
		Button15,
		Button16,

		Count,

		Unknown = Count
	};

	enum KeyMod
	{
		None = 0x0000,

		LShift = 0x0001,
		RShift = 0x0002,
		LCtrl = 0x0040,
		RCtrl = 0x0080,
		LAlt = 0x0100,
		RAlt = 0x0200,
		LSuper = 0x0400,
		RSuper = 0x0800,
		NumLock = 0x1000,
		CapsLock = 0x2000,
		Mode = 0x4000,
		Sym = 0x8000,

		Ctrl = (LCtrl | RCtrl),
		Shift = (LShift | RShift),
		Alt = (LAlt | RAlt),
		Super = (LSuper | RSuper),
		Mask = (Ctrl | Shift | Alt | Super),

		Count
	};

}
