# 架构设计

## 关于解耦

### 什么时候寻求解耦

- 业务功能不同
- 代码变化不同
- 可伸缩性不同
- 容错要求不同
- 数据安全不同

### 什么时候耦合是必要的

- 存在数据库事务
- 存在数据依赖
- 存在工作流编排

### 识别耦合的边界

```
                            technology
                                ^
             static coupling    |   dynamic coupling
             (compile time)     |   (runtime)
explicit <----------------------+------------------------> implicit
             logic coupling     |   semantic coupling
             (feature)          |   (contract)
                                V
                            business
```

### 复杂问题特征

错综复杂，纵横交错。

- 模糊性：问题难以定义，每个人看法都不一样
- 多面性：问题涉及面广，涉及的部门、角色、相关方多
- 非线性：问题产生原因多方面的，原因之间不正交，可能有不同层次、维度并相互影响

### 重构的目标

- 业务敏捷
   - 业务变化响应力
      - 需求交付周期
      - 需求吞吐量
   - 交付质量
      - 变更实施成功率
      - 线上问题数量
   - 运维能力
      - 部署频率
      - 服务恢复时长
- 运营效率
- 客户洞见
- 系统韧性与弹性

## 业务建模

>业务建模（Business Modeling）是以软件模型方式描述企业管理和业务所涉及的对象和要素、以及它们的行为、属性和彼此关系，业务建模强调以体系的方式来理解、设计和构架企业信息系统。

### 关键概念

#### 广义合同

>包含协议、共识、承诺、约定等具备履约行为的内容，都可以称之为合同，或者合同的履约凭证。

合同的生命周期主要分为：询价、报价、合同签订、履约四个阶段。合同签订前的活动，不具备法律效力。履约过程中会产生相应履约凭证，以此证明参与方履行了相关义务与权利。

软件虽然使得业务过程管理更加高效便利，但是由线下管理迁移到线上的过程中，往往模糊了业务凭证的概念及边界，使得我们在分析业务时很难发现业务本质。那么该怎么寻找合同中的凭证呢？从业务流程中归纳业务凭证，业务流程即业务凭证的追溯过程。通过梳理询价、报价、履约的流程对凭证进行溯源、归纳及定义。无论线上化程度多高，业务本身的履约动作并没有改变，改变的仅仅是记录履约信息的载体。

#### 业务流程

业务流程，是业务链路，在链路上把各个业务角色纳入进来，体现的是业务逻辑的流转。

业务流程的核心要义其实更多是划分责任归属，而流程的推进就是责任的转移。例如，货物经过不同的流程环节时，实际上就是货物在托运人、承运人和收货人直接的责任转移。

- 所有作业过程，有4个层次：领域，业务，流程，活动
   - 活动是业务功能描述的基本单位
   - 流程是活动的集合，在活动相互作用下产生特定结果
   - 流程按照作业的逻辑顺序完成一个完整业务工作
- 作用对象，参与对象，结果对象

#### 领域知识

领域知识是指在特定领域内所需要的知识和技能，具体包括了：领域背景(历史，发展，趋势，文化，社区)，领域业务(业务流程/流程间依赖关系，业务对象、对象间关系、业务规则、应用场景等)，领域技术，领域人员。

#### 业务规则

业务规则是对企业或组织业务过程的约束条件，它描述了业务流程的各种限制、规范和条件。业务规则通常是由法律、政策、行业标准、企业内部规章制度等产生的，可以用来约束业务流程的各种行为和决策。
业务规则通常包括以下几种类型：
1. 约束性规则：指必须遵守的规则，如法律、政策等规定
2. 规范性规则：指应该遵守的规则，如行业标准、企业内部规章制度等
3. 推荐性规则：指建议性规则，如最佳实践、经验分享等
4. 条件性规则：指在一定条件下才适用的规则，如优惠活动、特殊情况等

在一个复杂的业务系统中，通常有很多不同的业务规则，并且这些规则之间可能存在冲突，导致系统出现不一致或者错误的结果。造成业务规则冲突的原因主要有以下几点：
1. 业务规则的复杂性：随着业务系统的发展，业务规则会变得越来越复杂。不同的业务规则之间可能存在交叉、重叠或者互斥的关系，导致规则之间出现冲突。
2. 规则设计的不合理：在业务规则设计时，如果没有考虑到不同规则之间的关系，或者规则之间存在歧义或者矛盾，就很容易造成规则之间的冲突。
3. 规则实现的不完善：在业务规则实现的过程中，如果没有考虑到规则之间的相互影响，或者没有进行充分的测试和验证，就很容易出现规则之间的冲突。
4. 数据质量问题：在业务规则的实现中，如果数据质量存在问题，例如数据重复、缺失或者错误等，就会导致规则之间出现冲突。

解决业务规则冲突的方法主要包括以下几种：
1. 优先级排序：确定具有高优先级的规则将覆盖低优先级的规则，从而避免规则之间的冲突。例如，对于一个销售订单，一个规则要求在3天内发货，另一个规则要求在5天内完成发货，可以通过设置优先级，让3天内发货的规则优先于5天内完成发货的规则。
2. 规则合并：对于业务规则之间存在矛盾的情况，可以通过对规则进行合并，产生新的规则以解决冲突。例如，如果一个业务流程要求客户提供完整的地址信息，但另一个业务流程却允许在后续环节提供地址信息，可以将两个规则进行合并，产生新的规则要求客户在下单时提供部分地址信息，但在发货前必须提供完整地址信息。
3. 规则嵌套：通过规则嵌套的方式，将一些特殊规则嵌套在通用规则之内，从而解决业务规则冲突的问题。例如，企业内部规定优惠券不能与其他优惠活动同时使用，但当地政府规定在特定节日可以同时使用多种优惠，可以将政府规定的规则嵌套在企业内部规则之内，从而解决规则冲突。
4. 规则调整：如果业务规则之间的冲突无法通过优先级排序、规则合并和规则嵌套等方式解决，可以对规则进行调整或修改，以达到业务流程的顺利进行。在进行规则调整时，需要考虑到业务规则的合法性、有效性和公平性等方面。

#### 2B

系统的变更，来自两个方向：
- 需求变化
- 治理偏差

B端有个特点就是很多的业务流程变更都是由领导变更开始的，因为B端是要承载管理思想的，所以当管理思想发生变化，业务流程就一定会发生变化。

### 方法论

文化做引领，架构做创建，落地做应用，治理做维护。

#### 两个流

- 业务流
- 数据流

#### 沟通

- 向上沟通求授权
- 同级沟通求支持
- 向下沟通求落实

#### 指导思想

- 抽象要素
- 理清关系
- 寻找规律

#### 模型分层

- 概念模型
- 逻辑模型
- 物理模型

#### 业务复用前提

1. 业务可复用：即该业务适合被复用，通常表现为该业务有一定的通用性和可重用性，能够在多个场景下使用。
2. 业务规范化：即该业务已经经过规范化处理，有明确的标准和规范，能够被其他系统或模块所理解和使用。
3. 技术支持：即该业务的实现需要有相应的技术支持，如标准化接口、开放式API等技术手段，以便其他系统或模块可以方便地调用和使用。
4. 组织支持：即该业务的复用需要有相应的组织支持，包括建立复用文化、制定复用策略、培训复用人员等。
5. 业务管理：即需要对复用的业务进行管理，包括版本管理、权限管理、安全管理等，以保证复用的业务能够稳定地运行。

