<h1 align="center">DDDplus落地演示</h1>

<div align="center">

使用DDDplus进行(正向，逆向)建模，实现一个供应链仓储管理系统WMS。

</div>

<div align="center">

Languages： [English](README.md) | 中文

</div>

----

## 一、供应链WMS出库系统

作为供应链执行层的`WMS`(Warehouse Management System)，负责(收，发，存，退)：`B2C`处理商家到消费者的末端，`B2B`处理商品的流通端。
我们如何透过杂乱无章的碎片化业务细节问题摸清本质，梳理并实现反映本质问题的业务模型?

### 1.1 业务介绍

仓库在收到客户发出的出库单履约请求后，进行仓库生产计划、库存定位、任务分配、拣货，然后进入后半程(复核，装箱，打包，装车，发货)，这里仅演示后半程。

物理世界是这样的：
>。。。 ，拣货员推着装有不同订单货品的容器(容器可能是推车，也可能是一个虚拟编号)根据`WMS`系统推荐提示送到指定的一个复核台，复核员(一个复核台一个复核员)根据订单要求进行(数量，质量)核对，同时要保证出库单的完整性(没有集齐不能发货，否则引发客诉)。都核对无误后，把货品从容器转移到纸箱(可运输)，为保证运输安全要为纸箱装填耗材(例如：发泡袋)，然后根据承运商处购买的面单进行装车、发货。

>在此过程中，可能发生：货品破损、数量对不齐；数量数到一半发现错了，需要重新复核；客户突然取消出库单；复核员要暂停；耗材该用哪个用多少，这涉及到成本；可能有预售订单，此时可能还未付清尾款，是不能发货的；。。。

### 1.2 如何掌握这个演示

1. 通过逆向模型<sup>[1.3]</sup>，了解具体的业务模型和代码结构
2. 进入正向模型<sup>[1.4]</sup>，了解业务模型是如何具体实现的
3. 进入调用关系<sup>[1.5]</sup>，了解业务对象间的调用关系图
4. 进入技术细节<sup>[1.6]</sup>，了解具体的技术实现细节

### 1.3 逆向模型

![](/doc/showcase/wms.svg)

[逆向建模源代码 ->](reverse/WmsReverseModelingTest.java)

### 1.4 正向模型

- [应用层](wms/application/)
   - 系统交互入口：[出库复核](wms/application/service/CheckingAppService.java)
- [领域层](wms/domain/)
- [基础设施层](wms/infrastructure/)

### 1.5 领域行为调用关系

![](/doc/showcase/callgraph.svg)


### 1.6 包间依赖图

![](/doc/showcase/pkgref.svg)

### 1.7 技术细节

![](/doc/showcase/tech.svg)

## 二、订单履约中台

>演示内容：扩展点机制的使用

订单作为电商系统的纽带，贯穿了电商系统的关键流程，其他模块都是围绕订单构建的。

订单可以认为是一次交易的生命周期，订单是交易的载体，反应的是履约的内容，即：一份订单就是一份合同。

通过OMS，使得订单执行过程中的相关系统，例如`TMS`/`WMS`/`BMS`等成为一个有机整体，并为持续优化提供有力的数据支持。

[订单履约中台OMS ->](https://github.com/dddplus/dddplus-demo)
