/*
 * Decompiled with CFR 0.152.
 */
package io.github.dddplus.runtime.registry;

import io.github.dddplus.annotation.Router;
import io.github.dddplus.ext.IDomainExtension;
import io.github.dddplus.runtime.BaseRouter;
import io.github.dddplus.runtime.registry.BootstrapException;
import io.github.dddplus.runtime.registry.IRegistryAware;
import io.github.dddplus.runtime.registry.InternalAopUtils;
import io.github.dddplus.runtime.registry.InternalIndexer;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ResolvableType;

class RouterDef
implements IRegistryAware {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RouterDef.class);
    private static final int MAX_INHERITANCE_DEPTH = 5;
    private String domain;
    private String name;
    private BaseRouter baseRouterBean;
    private Class<? extends BaseRouter> baseRouterClazz;
    private Class<? extends IDomainExtension> extClazz;

    RouterDef() {
    }

    @Override
    public void registerBean(@NonNull Object bean) {
        if (bean == null) {
            throw new NullPointerException("bean is marked non-null but is null");
        }
        Router router = InternalAopUtils.getAnnotation(bean, Router.class);
        this.domain = router.domain();
        this.name = router.name();
        if (!(bean instanceof BaseRouter)) {
            throw BootstrapException.ofMessage(bean.getClass().getCanonicalName(), " MUST extend BaseRouter");
        }
        this.baseRouterBean = (BaseRouter)bean;
        this.baseRouterClazz = InternalAopUtils.getTarget(bean).getClass();
        this.resolveExtClazz();
        log.debug("router:{} ext:{}", (Object)bean.getClass().getCanonicalName(), (Object)this.extClazz.getCanonicalName());
        InternalIndexer.index(this);
    }

    private void resolveExtClazz() {
        ResolvableType baseRouterClazz = ResolvableType.forClass(this.baseRouterClazz).getSuperType();
        for (int i = 0; i < 5; ++i) {
            for (ResolvableType resolvableType : baseRouterClazz.getGenerics()) {
                if (!IDomainExtension.class.isAssignableFrom(resolvableType.resolve())) continue;
                this.extClazz = resolvableType.resolve();
                return;
            }
            baseRouterClazz = baseRouterClazz.getSuperType();
        }
        throw BootstrapException.ofMessage("Even after many tries, still unable to figure out the extension class of BaseRouter:", this.baseRouterClazz.getCanonicalName());
    }

    @Generated
    public String toString() {
        return "RouterDef(domain=" + this.getDomain() + ", name=" + this.getName() + ", baseRouterBean=" + this.getBaseRouterBean() + ", baseRouterClazz=" + this.getBaseRouterClazz() + ", extClazz=" + this.getExtClazz() + ")";
    }

    @Generated
    public String getDomain() {
        return this.domain;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public BaseRouter getBaseRouterBean() {
        return this.baseRouterBean;
    }

    @Generated
    public Class<? extends BaseRouter> getBaseRouterClazz() {
        return this.baseRouterClazz;
    }

    @Generated
    public Class<? extends IDomainExtension> getExtClazz() {
        return this.extClazz;
    }
}

