/*
 * Decompiled with CFR 0.152.
 */
package io.github.dddplus.runtime.registry;

import io.github.dddplus.ext.IDomainExtension;
import io.github.dddplus.ext.IIdentity;
import io.github.dddplus.ext.IPolicy;
import io.github.dddplus.runtime.registry.BootstrapException;
import io.github.dddplus.runtime.registry.ExtensionDef;
import io.github.dddplus.runtime.registry.IRegistryAware;
import io.github.dddplus.runtime.registry.InternalAopUtils;
import io.github.dddplus.runtime.registry.InternalIndexer;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ResolvableType;

class PolicyDef
implements IRegistryAware {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PolicyDef.class);
    private static final int MAX_INHERITANCE_DEPTH = 5;
    private IPolicy policyBean;
    private Class<? extends IDomainExtension> extClazz;
    private Class<? extends IPolicy> policyClazz;
    private Map<String, ExtensionDef> extensionDefMap = new HashMap<String, ExtensionDef>();

    PolicyDef() {
    }

    @Override
    public void registerBean(@NonNull Object bean) {
        if (bean == null) {
            throw new NullPointerException("bean is marked non-null but is null");
        }
        this.initialize(bean);
        this.resolveExtClazz();
        log.debug("policy:{} ext:{}", (Object)bean.getClass().getCanonicalName(), (Object)this.extClazz.getCanonicalName());
        InternalIndexer.index(this);
    }

    private void initialize(Object bean) {
        if (!(bean instanceof IPolicy)) {
            throw BootstrapException.ofMessage(bean.getClass().getCanonicalName(), " MUST implements IPolicy");
        }
        this.policyBean = (IPolicy)bean;
        this.policyClazz = InternalAopUtils.getTarget(bean).getClass();
    }

    private void resolveExtClazz() {
        ResolvableType resolvableType = ResolvableType.forInstance((Object)InternalAopUtils.getTarget(this.policyBean));
        for (int i = 0; i < 5; ++i) {
            for (ResolvableType iPolicyType : resolvableType.getInterfaces()) {
                if (!IPolicy.class.isAssignableFrom(iPolicyType.resolve())) continue;
                ResolvableType extType = iPolicyType.getGeneric(new int[]{0});
                this.extClazz = extType.resolve();
                return;
            }
            resolvableType = resolvableType.getSuperType();
        }
        throw BootstrapException.ofMessage("Even after many tries, still unable to figure out the extension class of IPolicy:", this.policyClazz.getCanonicalName());
    }

    void registerExtensionDef(ExtensionDef extensionDef) {
        this.extensionDefMap.put(extensionDef.getCode(), extensionDef);
    }

    @NonNull
    ExtensionDef getExtension(IIdentity identity) {
        String extensionCode = this.policyBean.extensionCode(identity);
        if (extensionCode == null) {
            return null;
        }
        return this.extensionDefMap.get(extensionCode);
    }

    String policyName() {
        return this.policyBean.getClass().getCanonicalName();
    }

    @Generated
    public String toString() {
        return "PolicyDef(policyBean=" + this.getPolicyBean() + ", extClazz=" + this.getExtClazz() + ", policyClazz=" + this.getPolicyClazz() + ", extensionDefMap=" + this.getExtensionDefMap() + ")";
    }

    @Generated
    IPolicy getPolicyBean() {
        return this.policyBean;
    }

    @Generated
    Class<? extends IDomainExtension> getExtClazz() {
        return this.extClazz;
    }

    @Generated
    Class<? extends IPolicy> getPolicyClazz() {
        return this.policyClazz;
    }

    @Generated
    Map<String, ExtensionDef> getExtensionDefMap() {
        return this.extensionDefMap;
    }
}

