/*
 * Decompiled with CFR 0.152.
 */
package io.github.dddplus.runtime.registry;

import io.github.dddplus.annotation.Pattern;
import io.github.dddplus.ext.IDomainExtension;
import io.github.dddplus.ext.IIdentity;
import io.github.dddplus.ext.IIdentityResolver;
import io.github.dddplus.ext.IPatternFilter;
import io.github.dddplus.runtime.registry.BootstrapException;
import io.github.dddplus.runtime.registry.ExtensionDef;
import io.github.dddplus.runtime.registry.IRegistryAware;
import io.github.dddplus.runtime.registry.InternalAopUtils;
import io.github.dddplus.runtime.registry.InternalIndexer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import lombok.NonNull;

class PatternDef
implements IRegistryAware,
IIdentityResolver {
    private String code;
    private String name;
    private int priority;
    private IIdentityResolver patternBean;
    private IPatternFilter filterBean;
    private Map<Class<? extends IDomainExtension>, ExtensionDef> extensionDefMap = new HashMap<Class<? extends IDomainExtension>, ExtensionDef>();

    PatternDef() {
    }

    @Override
    public void registerBean(@NonNull Object bean) {
        if (bean == null) {
            throw new NullPointerException("bean is marked non-null but is null");
        }
        boolean needIndex = this.initialize(bean);
        if (needIndex) {
            InternalIndexer.index(this);
        }
    }

    public boolean match(@NonNull IIdentity identity) {
        if (identity == null) {
            throw new NullPointerException("identity is marked non-null but is null");
        }
        return this.patternBean.match(identity);
    }

    private boolean initialize(Object bean) {
        Pattern pattern = InternalAopUtils.getAnnotation(bean, Pattern.class);
        this.code = pattern.code();
        this.name = pattern.name();
        this.priority = pattern.priority();
        if (this.priority < 0) {
            throw BootstrapException.ofMessage("Pattern.priority must be zero or positive");
        }
        if (!pattern.asResolver()) {
            return false;
        }
        if (!(bean instanceof IIdentityResolver)) {
            throw BootstrapException.ofMessage(bean.getClass().getCanonicalName(), " MUST implements IIdentityResolver");
        }
        this.patternBean = (IIdentityResolver)bean;
        if (bean instanceof IPatternFilter) {
            this.filterBean = (IPatternFilter)bean;
        }
        return true;
    }

    void registerExtensionDef(ExtensionDef extensionDef) {
        Class<? extends IDomainExtension> extClazz = extensionDef.getExtClazz();
        if (this.extensionDefMap.containsKey(extClazz)) {
            throw BootstrapException.ofMessage("Pattern(code=", this.code, ") can hold ONLY one instance on ", extClazz.getCanonicalName(), ", existing ", this.extensionDefMap.get(extClazz).toString(), ", illegal ", extensionDef.toString());
        }
        this.extensionDefMap.put(extClazz, extensionDef);
    }

    ExtensionDef getExtension(Class<? extends IDomainExtension> extClazz) {
        return this.extensionDefMap.get(extClazz);
    }

    Set<Class<? extends IDomainExtension>> extClazzSet() {
        return this.extensionDefMap.keySet();
    }

    @Generated
    public String toString() {
        return "PatternDef(code=" + this.getCode() + ", name=" + this.getName() + ", priority=" + this.getPriority() + ", patternBean=" + this.patternBean + ", filterBean=" + this.filterBean + ", extensionDefMap=" + this.extensionDefMap + ")";
    }

    @Generated
    public String getCode() {
        return this.code;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public int getPriority() {
        return this.priority;
    }
}

