/*
 * Decompiled with CFR 0.152.
 */
package io.github.dddplus.runtime.registry;

import io.github.dddplus.ext.IDomainExtension;
import io.github.dddplus.runtime.registry.InternalIndexer;
import io.github.dddplus.runtime.registry.PartnerDef;
import io.github.dddplus.runtime.registry.PatternDef;
import io.github.dddplus.runtime.registry.StepDef;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;

public class DomainArtifacts {
    private static final DomainArtifacts instance = new DomainArtifacts();
    private List<Domain> domains;
    private Map<String, List<Step>> steps;
    private List<Extension> extensions;

    public static DomainArtifacts getInstance() {
        return instance;
    }

    private DomainArtifacts() {
    }

    synchronized void export() {
        this.domains = new ArrayList<Domain>(InternalIndexer.domainDefMap.size());
        this.domains.addAll(InternalIndexer.domainDefMap.values().stream().map(domainDef -> new Domain(domainDef.getCode(), domainDef.getName())).collect(Collectors.toList()));
        this.steps = new HashMap<String, List<Step>>();
        for (Map.Entry<String, Map<String, StepDef>> entry : InternalIndexer.domainStepDefMap.entrySet()) {
            String activity = entry.getKey();
            this.steps.put(activity, new ArrayList());
            for (StepDef stepDef : entry.getValue().values()) {
                this.steps.get(activity).add(new Step(activity, stepDef.getCode(), stepDef.getName(), stepDef.getTags()));
            }
        }
        this.extensions = new ArrayList<Extension>();
        for (Map.Entry<Object, Object> entry : InternalIndexer.sortedPatternMap.entrySet()) {
            Extension extension = new Extension((Class)entry.getKey());
            for (PatternDef patternDef : (List)entry.getValue()) {
                extension.getPatterns().add(new Pattern(patternDef.getCode(), patternDef.getName()));
            }
            for (PartnerDef partnerDef : InternalIndexer.partnerDefMap.values()) {
                if (partnerDef.getExtension(extension.ext) == null) continue;
                extension.getPartners().add(new Partner(partnerDef.getCode(), partnerDef.getName()));
            }
            this.extensions.add(extension);
        }
        for (PartnerDef partnerDef : InternalIndexer.partnerDefMap.values()) {
            for (Class<? extends IDomainExtension> ext : partnerDef.getExtensionDefMap().keySet()) {
                Extension extensionsOfPattern = null;
                for (Extension extension : this.extensions) {
                    if (extension.ext != ext) continue;
                    extensionsOfPattern = extension;
                    break;
                }
                if (extensionsOfPattern == null) {
                    Extension extension = new Extension(ext);
                    extension.getPartners().add(new Partner(partnerDef.getCode(), partnerDef.getName()));
                    this.extensions.add(extension);
                    continue;
                }
                Partner partner = new Partner(partnerDef.getCode(), partnerDef.getName());
                if (extensionsOfPattern.getPartners().contains(partner)) continue;
                extensionsOfPattern.getPartners().add(partner);
            }
        }
    }

    @Generated
    public List<Domain> getDomains() {
        return this.domains;
    }

    @Generated
    public Map<String, List<Step>> getSteps() {
        return this.steps;
    }

    @Generated
    public List<Extension> getExtensions() {
        return this.extensions;
    }

    public static class Partner {
        private String code;
        private String name;

        @Generated
        public String getCode() {
            return this.code;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        Partner(String code, String name) {
            this.code = code;
            this.name = name;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Partner)) {
                return false;
            }
            Partner other = (Partner)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$code = this.getCode();
            String other$code = other.getCode();
            if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Partner;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $code = this.getCode();
            result = result * 59 + ($code == null ? 43 : $code.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }
    }

    public static class Pattern {
        private String code;
        private String name;

        @Generated
        public String getCode() {
            return this.code;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        private Pattern(String code, String name) {
            this.code = code;
            this.name = name;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Pattern)) {
                return false;
            }
            Pattern other = (Pattern)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$code = this.getCode();
            String other$code = other.getCode();
            if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Pattern;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $code = this.getCode();
            result = result * 59 + ($code == null ? 43 : $code.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }
    }

    public static class Extension {
        private Class<? extends IDomainExtension> ext;
        private List<Pattern> patterns;
        private List<Partner> partners;

        private Extension(Class<? extends IDomainExtension> ext) {
            this.ext = ext;
            this.patterns = new ArrayList<Pattern>();
            this.partners = new ArrayList<Partner>();
        }

        @Generated
        public Class<? extends IDomainExtension> getExt() {
            return this.ext;
        }

        @Generated
        public List<Pattern> getPatterns() {
            return this.patterns;
        }

        @Generated
        public List<Partner> getPartners() {
            return this.partners;
        }
    }

    public static class Step {
        private String activity;
        private String code;
        private String name;
        private String[] tags;

        @Generated
        public String getActivity() {
            return this.activity;
        }

        @Generated
        public String getCode() {
            return this.code;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String[] getTags() {
            return this.tags;
        }

        @Generated
        private Step(String activity, String code, String name, String[] tags) {
            this.activity = activity;
            this.code = code;
            this.name = name;
            this.tags = tags;
        }
    }

    public static class Domain {
        private String code;
        private String name;

        @Generated
        public String getCode() {
            return this.code;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        private Domain(String code, String name) {
            this.code = code;
            this.name = name;
        }
    }
}

