/*
 * Decompiled with CFR 0.152.
 */
package io.github.dddplus.runtime;

import io.github.dddplus.ext.IDomainExtension;
import io.github.dddplus.ext.IIdentity;
import io.github.dddplus.ext.IPolicy;
import io.github.dddplus.runtime.BaseRouter;
import io.github.dddplus.runtime.ExtensionInvocationHandler;
import io.github.dddplus.runtime.registry.InternalIndexer;
import io.github.dddplus.runtime.registry.StepDef;
import io.github.dddplus.step.IDomainStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.NonNull;

public final class DDD {
    private DDD() {
    }

    @NonNull
    public static <T extends BaseRouter> T useRouter(@NonNull Class<? extends T> routerClazz) {
        if (routerClazz == null) {
            throw new NullPointerException("routerClazz is marked non-null but is null");
        }
        return InternalIndexer.findRouter(routerClazz);
    }

    public static <Ext extends IDomainExtension, Identity extends IIdentity> Ext usePolicy(@NonNull Class<? extends IPolicy<Ext, Identity>> policy, @NonNull Identity identity) {
        if (policy == null) {
            throw new NullPointerException("policy is marked non-null but is null");
        }
        if (identity == null) {
            throw new NullPointerException("identity is marked non-null but is null");
        }
        return DDD.firstExtension(InternalIndexer.extClazzOfPolicy(policy), identity);
    }

    public static <Ext extends IDomainExtension> Ext firstExtension(@NonNull Class<Ext> extClazz, @NonNull IIdentity identity) {
        if (extClazz == null) {
            throw new NullPointerException("extClazz is marked non-null but is null");
        }
        if (identity == null) {
            throw new NullPointerException("identity is marked non-null but is null");
        }
        return DDD.firstExtension(extClazz, identity, 0);
    }

    private static <Ext extends IDomainExtension, R> Ext firstExtension(@NonNull Class<Ext> extClazz, @NonNull IIdentity identity, int timeoutInMs) {
        if (extClazz == null) {
            throw new NullPointerException("extClazz is marked non-null but is null");
        }
        if (identity == null) {
            throw new NullPointerException("identity is marked non-null but is null");
        }
        ExtensionInvocationHandler proxy = new ExtensionInvocationHandler(extClazz, identity, null, null, InternalIndexer.registeredInterceptor(), timeoutInMs);
        return proxy.createProxy();
    }

    @Deprecated
    public static <Step extends IDomainStep> Step getStep(@NonNull String activityCode, @NonNull String stepCode) {
        if (activityCode == null) {
            throw new NullPointerException("activityCode is marked non-null but is null");
        }
        if (stepCode == null) {
            throw new NullPointerException("stepCode is marked non-null but is null");
        }
        List<Step> steps = DDD.findSteps(activityCode, Arrays.asList(stepCode));
        if (steps.size() == 1) {
            return (Step)((IDomainStep)steps.get(0));
        }
        return null;
    }

    @Deprecated
    public static <Step extends IDomainStep> List<Step> findSteps(@NonNull String activityCode, @NonNull List<String> stepCodeList) {
        if (activityCode == null) {
            throw new NullPointerException("activityCode is marked non-null but is null");
        }
        if (stepCodeList == null) {
            throw new NullPointerException("stepCodeList is marked non-null but is null");
        }
        List<StepDef> stepDefs = InternalIndexer.findDomainSteps(activityCode, stepCodeList);
        ArrayList<IDomainStep> result = new ArrayList<IDomainStep>(stepDefs.size());
        for (StepDef stepDef : stepDefs) {
            result.add(stepDef.getStepBean());
        }
        return result;
    }
}

