<p align="center">
  <img src="./public/vim-logo.png" alt="logo" width=200/>
</p>

<p align="center">
  <b>vimrc building made easy</b> via a web app

  <br/>
  <br/>

  <a href="LICENSE">
    <img src="https://img.shields.io/badge/license-MIT-blue.svg" alt="MIT Licensed" />
  </a>

  <br/>
</p>

<br/>

## Why

Building a vimrc file should not be difficult. **You're configuring a code editor that was invented in 1991** after all. No-matter your experience level, there are always new ways to alter your vim experience, yet finding the commands to do so can be impossible as tips are scattered across the internet.

<br/>

<p align="center">
  <b>Build a snippet or an entire vimrc with vimrc-builder</b>
</p>

<br/>

<p align="center">
  <img src="https://i.imgur.com/IqmbOTY.png" alt="screenshot" />
</p>

<br/>

Having a vimrc is nearly critical if it's your primary text editor. Certain things should have just been built in, but they are not.

Example: `syntax on` in your vimrc enables syntax hi-lighting

`syntax on` and many more options are available in the web app.

<br/>

## Contributing

Please do! If you want to add more vim commands, find those [here](https://github.com/dawsbot/vimrc-builder/blob/master/src/vim-commands.json). If you have a feature request, submit an [issue](https://github.com/dawsbot/vimrc-builder/issues).

#### Color Palette

Inspired by [Laura](https://twitter.com/laurium)'s [article on color theory in web apps](https://www.smashingmagazine.com/2016/04/web-developer-guide-color/), this application was themed with the following palette:

* Primary: (light pink) #fd746c (right side of background gradient)
* Secondary: (juicy green): #BBEB64
* Near white pink: #fff5f5 (use instead of white)
* Near black pink:  #1f0200 (use instead of black)

<br/>

## License

MIT © [Dawson Botsford](https://dawsbot.com)
