<?php 
    
    /** 
     * --------------------------------------------------------------------------
     * ROOT_PATH FUNCTION
     * --------------------------------------------------------------------------
     * 
     * @param string $path 
     * @return string
     */

    function root_path(string $path = null): string 
    {
        $root = realpath(__DIR__.'/../').DIRECTORY_SEPARATOR;
        return $path ? $root.ltrim($path, DIRECTORY_SEPARATOR) : $root;
    }

    /*
    |--------------------------------------------------------------------------
    | AUTOLOAD PSR-4
    |--------------------------------------------------------------------------
    */
     
    require root_path('vendor/autoload.php');
    
    /*
    |--------------------------------------------------------------------------
    | BOOTSTRAP APPLICATION
    |--------------------------------------------------------------------------
    */
    
    require_once root_path('bootstrap/app.php');

    /** 
     * --------------------------------------------------------------------------
     * RUN APPLICATION
     * --------------------------------------------------------------------------
     * 
     * @var Embryo\Application $app 
     */

    $app->run();